/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.provider.Telephony;
import android.telephony.SmsMessage;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsHeader;
import java.util.Arrays;

public abstract class SmsMessageBase {
    private static final String LOG_TAG = "SMS";
    protected String emailBody;
    protected String emailFrom;
    protected int indexOnIcc = -1;
    protected boolean isEmail;
    protected boolean isMwi;
    protected byte[] mPdu;
    protected String messageBody;
    public int messageRef;
    protected boolean mwiDontStore;
    protected boolean mwiSense;
    protected SmsAddress originatingAddress;
    protected String pseudoSubject;
    protected String scAddress;
    protected long scTimeMillis;
    protected int statusOnIcc = -1;
    protected byte[] userData;
    protected SmsHeader userDataHeader;

    protected void extractEmailAddressFromMessageBody() {
        boolean bl;
        String string2;
        String string3;
        String[] stringArray = this.messageBody.split("( /)|( )", 2);
        if (stringArray.length < 2) {
            return;
        }
        this.emailFrom = string3 = stringArray[0];
        this.emailBody = string2 = stringArray[1];
        this.isEmail = bl = Telephony.Mms.isEmailAddress(this.emailFrom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDisplayMessageBody() {
        if (!this.isEmail) return this.getMessageBody();
        return this.emailBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDisplayOriginatingAddress() {
        if (!this.isEmail) return this.getOriginatingAddress();
        return this.emailFrom;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public int getIndexOnIcc() {
        return this.indexOnIcc;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public abstract SmsMessage.MessageClass getMessageClass();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOriginatingAddress() {
        if (this.originatingAddress != null) return this.originatingAddress.getAddressString();
        return null;
    }

    public byte[] getPdu() {
        return this.mPdu;
    }

    public abstract int getProtocolIdentifier();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPseudoSubject() {
        if (this.pseudoSubject != null) return this.pseudoSubject;
        return "";
    }

    public String getServiceCenterAddress() {
        return this.scAddress;
    }

    public abstract int getStatus();

    public int getStatusOnIcc() {
        return this.statusOnIcc;
    }

    public long getTimestampMillis() {
        return this.scTimeMillis;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public SmsHeader getUserDataHeader() {
        return this.userDataHeader;
    }

    public abstract boolean isCphsMwiMessage();

    public boolean isEmail() {
        return this.isEmail;
    }

    public abstract boolean isMWIClearMessage();

    public abstract boolean isMWISetMessage();

    public abstract boolean isMwiDontStore();

    public abstract boolean isReplace();

    public abstract boolean isReplyPathPresent();

    public abstract boolean isStatusReportMessage();

    protected void parseMessageBody() {
        if (this.originatingAddress == null) {
            return;
        }
        if (!this.originatingAddress.couldBeEmailGateway()) {
            return;
        }
        this.extractEmailAddressFromMessageBody();
    }

    public static abstract class SubmitPduBase {
        public byte[] encodedMessage;
        public byte[] encodedScAddress;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("SubmitPdu: encodedScAddress = ");
            String string2 = Arrays.toString(this.encodedScAddress);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", encodedMessage = ");
            String string3 = Arrays.toString(this.encodedMessage);
            return stringBuilder2.append(string3).toString();
        }
    }

    public static class TextEncodingDetails {
        public int codeUnitCount;
        public int codeUnitSize;
        public int codeUnitsRemaining;
        public int msgCount;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("TextEncodingDetails { msgCount=");
            int n = this.msgCount;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(", codeUnitCount=");
            int n2 = this.codeUnitCount;
            StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(", codeUnitsRemaining=");
            int n3 = this.codeUnitsRemaining;
            StringBuilder stringBuilder4 = stringBuilder3.append(n3).append(", codeUnitSize=");
            int n4 = this.codeUnitSize;
            return stringBuilder4.append(n4).append(" }").toString();
        }
    }
}

