/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.WspTypeDecoder;

public class WapPushOverSms {
    private static final String LOG_TAG = "WAP PUSH";
    private final int WAKE_LOCK_TIMEOUT;
    private final Context mContext;
    private SMSDispatcher mSmsDispatcher;
    private WspTypeDecoder pduDecoder;

    public WapPushOverSms(Phone phone, SMSDispatcher sMSDispatcher) {
        Context context;
        this.WAKE_LOCK_TIMEOUT = 5000;
        this.mSmsDispatcher = sMSDispatcher;
        this.mContext = context = phone.getContext();
    }

    private void dispatchWapPdu_MMS(byte[] byArray, int n, int n2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        int n5 = byArray2.length;
        System.arraycopy(byArray, n3, byArray2, 0, n5);
        int n6 = n3 + n4;
        byte[] byArray3 = new byte[byArray.length - n6];
        int n7 = byArray3.length;
        System.arraycopy(byArray, n6, byArray3, 0, n7);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        Intent intent2 = intent.setType("application/vnd.wap.mms-message");
        Intent intent3 = intent.putExtra("transactionId", n);
        Intent intent4 = intent.putExtra("pduType", n2);
        Intent intent5 = intent.putExtra("header", byArray2);
        Intent intent6 = intent.putExtra("data", byArray3);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_MMS");
    }

    private void dispatchWapPdu_PushCO(byte[] byArray, int n, int n2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        int n5 = byArray2.length;
        System.arraycopy(byArray, n3, byArray2, 0, n5);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        Intent intent2 = intent.setType("application/vnd.wap.coc");
        Intent intent3 = intent.putExtra("transactionId", n);
        Intent intent4 = intent.putExtra("pduType", n2);
        Intent intent5 = intent.putExtra("header", byArray2);
        Intent intent6 = intent.putExtra("data", byArray);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_WAP_PUSH");
    }

    private void dispatchWapPdu_default(byte[] byArray, int n, int n2, String string2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        int n5 = byArray2.length;
        System.arraycopy(byArray, n3, byArray2, 0, n5);
        int n6 = n3 + n4;
        byte[] byArray3 = new byte[byArray.length - n6];
        int n7 = byArray3.length;
        System.arraycopy(byArray, n6, byArray3, 0, n7);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        Intent intent2 = intent.setType(string2);
        Intent intent3 = intent.putExtra("transactionId", n);
        Intent intent4 = intent.putExtra("pduType", n2);
        Intent intent5 = intent.putExtra("header", byArray2);
        Intent intent6 = intent.putExtra("data", byArray3);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_WAP_PUSH");
    }

    /*
     * Enabled aggressive block sorting
     */
    public int dispatchWapPdu(byte[] byArray) {
        int n;
        WspTypeDecoder wspTypeDecoder;
        WspTypeDecoder wspTypeDecoder2;
        StringBuilder stringBuilder = new StringBuilder().append("Rx: ");
        String string2 = IccUtils.bytesToHexString(byArray);
        String string3 = stringBuilder.append(string2).toString();
        int n2 = Log.d(LOG_TAG, string3);
        int n3 = 0 + 1;
        int n4 = byArray[0] & 0xFF;
        int n5 = n3 + 1;
        int n6 = byArray[n3] & 0xFF;
        if (n6 != 6 && n6 != 7) {
            String string4 = "Received non-PUSH WAP PDU. Type = " + n6;
            int n7 = Log.w(LOG_TAG, string4);
            return 1;
        }
        WspTypeDecoder wspTypeDecoder3 = wspTypeDecoder2;
        byte[] byArray2 = byArray;
        wspTypeDecoder3(byArray2);
        WspTypeDecoder wspTypeDecoder4 = this.pduDecoder = (wspTypeDecoder = wspTypeDecoder2);
        int n8 = n5;
        if (!wspTypeDecoder4.decodeUintvarInteger(n8)) {
            int n9 = Log.w(LOG_TAG, "Received PDU. Header Length error.");
            return 2;
        }
        int n10 = (int)this.pduDecoder.getValue32();
        int n11 = n5 = this.pduDecoder.getDecodedDataLength() + 2;
        WspTypeDecoder wspTypeDecoder5 = this.pduDecoder;
        int n12 = n5;
        if (!wspTypeDecoder5.decodeContentType(n12)) {
            int n13 = Log.w(LOG_TAG, "Received PDU. Header Content-Type error.");
            return 2;
        }
        String string5 = this.pduDecoder.getValueString();
        if (string5 == null) {
            n = (int)this.pduDecoder.getValue32();
            switch (n) {
                default: {
                    String string6 = "Received PDU. Unsupported Content-Type = " + n;
                    int n14 = Log.w(LOG_TAG, string6);
                    return 1;
                }
                case 74: {
                    string5 = "application/vnd.oma.drm.rights+xml";
                    break;
                }
                case 75: {
                    string5 = "application/vnd.oma.drm.rights+wbxml";
                    break;
                }
                case 46: {
                    string5 = "application/vnd.wap.sic";
                    break;
                }
                case 48: {
                    string5 = "application/vnd.wap.slc";
                    break;
                }
                case 50: {
                    string5 = "application/vnd.wap.coc";
                    break;
                }
                case 62: {
                    string5 = "application/vnd.wap.mms-message";
                    break;
                }
                case 784: {
                    string5 = "application/vnd.docomo.pf";
                    break;
                }
                case 786: {
                    string5 = "application/vnd.omaloc-supl-init";
                    break;
                }
            }
        } else if (string5.equals("application/vnd.oma.drm.rights+xml")) {
            n = 74;
        } else if (string5.equals("application/vnd.oma.drm.rights+wbxml")) {
            n = 75;
        } else if (string5.equals("application/vnd.wap.sic")) {
            n = 46;
        } else if (string5.equals("application/vnd.wap.slc")) {
            n = 48;
        } else if (string5.equals("application/vnd.wap.coc")) {
            n = 50;
        } else if (string5.equals("application/vnd.wap.mms-message")) {
            n = 62;
        } else if (string5.equals("application/vnd.docomo.pf")) {
            n = 784;
        } else {
            if (!string5.equals("application/vnd.omaloc-supl-init")) {
                String string7 = "Received PDU. Unknown Content-Type = " + string5;
                int n15 = Log.w(LOG_TAG, string7);
                return 1;
            }
            n = 786;
        }
        int n16 = this.pduDecoder.getDecodedDataLength();
        int n17 = n5 + n16;
        boolean bl = false;
        switch (n) {
            case 50: {
                WapPushOverSms wapPushOverSms = this;
                byte[] byArray3 = byArray;
                wapPushOverSms.dispatchWapPdu_PushCO(byArray3, n4, n6, n11, n10);
                bl = true;
            }
            default: {
                break;
            }
            case 62: {
                WapPushOverSms wapPushOverSms = this;
                byte[] byArray4 = byArray;
                wapPushOverSms.dispatchWapPdu_MMS(byArray4, n4, n6, n11, n10);
                return -1;
            }
        }
        if (bl) return -1;
        WapPushOverSms wapPushOverSms = this;
        byte[] byArray5 = byArray;
        int n18 = n4;
        int n19 = n6;
        int n20 = n11;
        int n21 = n10;
        wapPushOverSms.dispatchWapPdu_default(byArray5, n18, n19, string5, n20, n21);
        return -1;
    }
}

