/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

public class WspTypeDecoder {
    public static final String CONTENT_MIME_TYPE_B_DRM_RIGHTS_WBXML = "application/vnd.oma.drm.rights+wbxml";
    public static final String CONTENT_MIME_TYPE_B_DRM_RIGHTS_XML = "application/vnd.oma.drm.rights+xml";
    public static final String CONTENT_MIME_TYPE_B_MMS = "application/vnd.wap.mms-message";
    public static final String CONTENT_MIME_TYPE_B_PUSH_CO = "application/vnd.wap.coc";
    public static final String CONTENT_MIME_TYPE_B_PUSH_SI = "application/vnd.wap.sic";
    public static final String CONTENT_MIME_TYPE_B_PUSH_SL = "application/vnd.wap.slc";
    public static final String CONTENT_MIME_TYPE_B_SUPL_INIT = "application/vnd.omaloc-supl-init";
    public static final String CONTENT_MIME_TYPE_B_VND_DOCOMO_PF = "application/vnd.docomo.pf";
    public static final int CONTENT_TYPE_B_DRM_RIGHTS_WBXML = 75;
    public static final int CONTENT_TYPE_B_DRM_RIGHTS_XML = 74;
    public static final int CONTENT_TYPE_B_MMS = 62;
    public static final int CONTENT_TYPE_B_PUSH_CO = 50;
    public static final int CONTENT_TYPE_B_PUSH_SI = 46;
    public static final int CONTENT_TYPE_B_PUSH_SL = 48;
    public static final int CONTENT_TYPE_B_SUPL_INIT = 786;
    public static final int CONTENT_TYPE_B_VND_DOCOMO_PF = 784;
    public static final int PARAMETER_ID_X_WAP_APPLICATION_ID = 47;
    public static final int PDU_TYPE_CONFIRMED_PUSH = 7;
    public static final int PDU_TYPE_PUSH = 6;
    private static final int WAP_PDU_LENGTH_QUOTE = 31;
    private static final int WAP_PDU_SHORT_LENGTH_MAX = 30;
    int dataLength;
    String stringValue;
    long unsigned32bit;
    byte[] wspData;

    public WspTypeDecoder(byte[] byArray) {
        this.wspData = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeConstrainedEncoding(int n) {
        if (!this.decodeShortInteger(n)) return this.decodeExtensionMedia(n);
        this.stringValue = null;
        return true;
    }

    public boolean decodeContentLength(int n) {
        return this.decodeIntegerValue(n);
    }

    public boolean decodeContentLocation(int n) {
        return this.decodeTextString(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeContentType(int n) {
        int n2;
        if (!this.decodeValueLength(n)) {
            return this.decodeConstrainedEncoding(n);
        }
        int n3 = this.getDecodedDataLength();
        long l = this.getValue32();
        int n4 = n + n3;
        if (this.decodeIntegerValue(n4)) {
            int n5;
            this.dataLength = n5 = this.dataLength + n3;
            this.stringValue = null;
            return true;
        }
        int n6 = n + n3;
        if (!this.decodeExtensionMedia(n6)) return false;
        this.dataLength = n2 = this.dataLength + n3;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean decodeExtensionMedia(int n) {
        String string2;
        int n2;
        int n3;
        this.dataLength = 0;
        this.stringValue = null;
        int n4 = this.wspData.length;
        boolean bl = n3 < n4;
        for (n3 = n; n3 < n4 && this.wspData[n3] != null; ++n3) {
        }
        this.dataLength = n2 = n3 - n + 1;
        byte[] byArray = this.wspData;
        int n5 = this.dataLength - 1;
        this.stringValue = string2 = new String(byArray, n, n5);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeIntegerValue(int n) {
        if (!this.decodeShortInteger(n)) return this.decodeLongInteger(n);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeLongInteger(int n) {
        int n2;
        int n3 = this.wspData[n] & 0xFF;
        if (n3 > 30) {
            return false;
        }
        this.unsigned32bit = 0L;
        for (int i = 1; i <= n3; ++i) {
            long l;
            long l2 = this.unsigned32bit << 8;
            byte[] byArray = this.wspData;
            int n4 = n + i;
            long l3 = byArray[n4] & 0xFF;
            this.unsigned32bit = l = l2 | l3;
        }
        this.dataLength = n2 = n3 + 1;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeShortInteger(int n) {
        long l;
        if ((this.wspData[n] & 0x80) == 0) {
            return false;
        }
        this.unsigned32bit = l = (long)(this.wspData[n] & 0x7F);
        this.dataLength = 1;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeTextString(int n) {
        String string2;
        int n2;
        int n3 = n;
        while (this.wspData[n3] != null) {
            ++n3;
        }
        this.dataLength = n2 = n3 - n + 1;
        if (this.wspData[n] == 127) {
            String string3;
            byte[] byArray = this.wspData;
            int n4 = n + 1;
            int n5 = this.dataLength - 2;
            this.stringValue = string3 = new String(byArray, n4, n5);
            return true;
        }
        byte[] byArray = this.wspData;
        int n6 = this.dataLength - 1;
        this.stringValue = string2 = new String(byArray, n, n6);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeUintvarInteger(int n) {
        int n2;
        long l;
        int n3 = n;
        this.unsigned32bit = 0L;
        while ((this.wspData[n3] & 0x80) != 0) {
            long l2;
            if (n3 - n >= 4) {
                return false;
            }
            long l3 = this.unsigned32bit << 7;
            long l4 = this.wspData[n3] & 0x7F;
            this.unsigned32bit = l2 = l3 | l4;
            ++n3;
        }
        long l5 = this.unsigned32bit << 7;
        long l6 = this.wspData[n3] & 0x7F;
        this.unsigned32bit = l = l5 | l6;
        this.dataLength = n2 = n3 - n + 1;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeValueLength(int n) {
        int n2;
        if ((this.wspData[n] & 0xFF) > 31) {
            return false;
        }
        if (this.wspData[n] < 31) {
            long l;
            this.unsigned32bit = l = (long)this.wspData[n];
            this.dataLength = 1;
            return true;
        }
        int n3 = n + 1;
        boolean bl = this.decodeUintvarInteger(n3);
        this.dataLength = n2 = this.dataLength + 1;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeXWapApplicationId(int n) {
        if (!this.decodeIntegerValue(n)) return this.decodeTextString(n);
        this.stringValue = null;
        return true;
    }

    public boolean decodeXWapContentURI(int n) {
        return this.decodeTextString(n);
    }

    public boolean decodeXWapInitiatorURI(int n) {
        return this.decodeTextString(n);
    }

    public int getDecodedDataLength() {
        return this.dataLength;
    }

    public long getValue32() {
        return this.unsigned32bit;
    }

    public String getValueString() {
        return this.stringValue;
    }
}

