/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.util.ArrayList;
import java.util.List;

public final class CdmaCall
extends Call {
    ArrayList<Connection> connections;
    CdmaCallTracker owner;
    Call.State state;

    CdmaCall(CdmaCallTracker cdmaCallTracker) {
        Call.State state;
        ArrayList arrayList = new ArrayList();
        this.connections = arrayList;
        this.state = state = Call.State.IDLE;
        this.owner = cdmaCallTracker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Call.State stateFromDCState(DriverCall.State state) {
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$DriverCall$State;
        int n = state.ordinal();
        switch (nArray[n]) {
            default: {
                String string2 = "illegal call state:" + (Object)((Object)state);
                throw new RuntimeException(string2);
            }
            case 1: {
                return Call.State.ACTIVE;
            }
            case 2: {
                return Call.State.HOLDING;
            }
            case 3: {
                return Call.State.DIALING;
            }
            case 4: {
                return Call.State.ALERTING;
            }
            case 5: {
                return Call.State.INCOMING;
            }
            case 6: 
        }
        return Call.State.WAITING;
    }

    void attach(Connection connection, DriverCall driverCall) {
        Call.State state;
        boolean bl = this.connections.add(connection);
        this.state = state = CdmaCall.stateFromDCState(driverCall.state);
    }

    void attachFake(Connection connection, Call.State state) {
        boolean bl = this.connections.add(connection);
        this.state = state;
    }

    void clearDisconnected() {
        Call.State state;
        for (int i = this.connections.size() - 1; i >= 0; i += -1) {
            Call.State state2;
            Call.State state3 = ((CdmaConnection)this.connections.get(i)).getState();
            if (state3 != (state2 = Call.State.DISCONNECTED)) continue;
            Connection connection = this.connections.remove(i);
        }
        if (this.connections.size() != 0) {
            return;
        }
        this.state = state = Call.State.IDLE;
    }

    void connectionDisconnected(CdmaConnection cdmaConnection) {
        Call.State state = this.state;
        Call.State state2 = Call.State.DISCONNECTED;
        if (state == state2) {
            return;
        }
        boolean bl = true;
        int n = 0;
        int n2 = this.connections.size();
        while (true) {
            block7: {
                Call.State state3;
                block6: {
                    Call.State state4;
                    if (n >= n2) break block6;
                    Call.State state5 = this.connections.get(n).getState();
                    if (state5 == (state4 = Call.State.DISCONNECTED)) break block7;
                    bl = false;
                }
                if (!bl) {
                    return;
                }
                this.state = state3 = Call.State.DISCONNECTED;
                return;
            }
            ++n;
        }
    }

    void detach(CdmaConnection cdmaConnection) {
        Call.State state;
        boolean bl = this.connections.remove(cdmaConnection);
        if (this.connections.size() != 0) {
            return;
        }
        this.state = state = Call.State.IDLE;
    }

    public void dispose() {
    }

    @Override
    public List<Connection> getConnections() {
        return this.connections;
    }

    @Override
    public Phone getPhone() {
        return this.owner.phone;
    }

    @Override
    public Call.State getState() {
        return this.state;
    }

    @Override
    public void hangup() throws CallStateException {
        this.owner.hangup(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isFull() {
        if (this.connections.size() != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMultiparty() {
        if (this.connections.size() <= 1) return false;
        return true;
    }

    void onHangupLocal() {
        Call.State state;
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            ((CdmaConnection)this.connections.get(i)).onHangupLocal();
        }
        this.state = state = Call.State.DISCONNECTING;
    }

    public String toString() {
        return this.state.toString();
    }

    boolean update(CdmaConnection cdmaConnection, DriverCall driverCall) {
        Call.State state;
        boolean bl = false;
        Call.State state2 = CdmaCall.stateFromDCState(driverCall.state);
        if (state2 != (state = this.state)) {
            this.state = state2;
            bl = true;
        }
        return bl;
    }
}

