/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.util.ArrayList;
import java.util.List;

public final class CdmaCallTracker
extends CallTracker {
    private static final boolean DBG_POLL = false;
    static final String LOG_TAG = "CDMA";
    static final int MAX_CONNECTIONS = 1;
    static final int MAX_CONNECTIONS_PER_CALL = 1;
    private static final boolean REPEAT_POLLING;
    CdmaCall backgroundCall;
    RegistrantList callWaitingRegistrants;
    CdmaConnection[] connections;
    boolean desiredMute;
    ArrayList<CdmaConnection> droppedDuringPoll;
    CdmaCall foregroundCall;
    boolean hangupPendingMO;
    private boolean mIsEcmTimerCanceled;
    boolean mIsInEmergencyCall;
    int pendingCallClirMode;
    boolean pendingCallInEcm;
    CdmaConnection pendingMO;
    CDMAPhone phone;
    CdmaCall ringingCall;
    Phone.State state;
    RegistrantList voiceCallEndedRegistrants;
    RegistrantList voiceCallStartedRegistrants;

    CdmaCallTracker(CDMAPhone cDMAPhone) {
        CommandsInterface commandsInterface;
        Phone.State state;
        CdmaCall cdmaCall;
        CdmaCall cdmaCall2;
        CdmaCall cdmaCall3;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        CdmaConnection[] cdmaConnectionArray = new CdmaConnection[1];
        this.connections = cdmaConnectionArray;
        this.voiceCallEndedRegistrants = registrantList3 = new RegistrantList();
        this.voiceCallStartedRegistrants = registrantList2 = new RegistrantList();
        this.callWaitingRegistrants = registrantList = new RegistrantList();
        ArrayList arrayList = new ArrayList(1);
        this.droppedDuringPoll = arrayList;
        this.ringingCall = cdmaCall3 = new CdmaCall(this);
        this.foregroundCall = cdmaCall2 = new CdmaCall(this);
        this.backgroundCall = cdmaCall = new CdmaCall(this);
        this.pendingCallInEcm = false;
        this.mIsInEmergencyCall = false;
        this.desiredMute = false;
        this.state = state = Phone.State.IDLE;
        this.mIsEcmTimerCanceled = false;
        this.phone = cDMAPhone;
        this.cm = commandsInterface = cDMAPhone.mCM;
        this.cm.registerForCallStateChanged(this, 2, null);
        this.cm.registerForOn(this, 9, null);
        this.cm.registerForNotAvailable(this, 10, null);
        this.cm.registerForCallWaitingInfo(this, 15, null);
        this.foregroundCall.setGeneric(false);
    }

    private void checkAndEnableDataCallAfterEmergencyCallDropped() {
        if (!this.mIsInEmergencyCall) {
            return;
        }
        this.mIsInEmergencyCall = false;
        String string2 = SystemProperties.get("ril.cdma.inecmmode", "false");
        String string3 = "checkAndEnableDataCallAfterEmergencyCallDropped,inEcm=" + string2;
        this.log(string3);
        if (string2.compareTo("false") != 0) {
            return;
        }
        boolean bl = this.phone.mDataConnection.setDataEnabled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Connection checkMtFindNewRinging(DriverCall driverCall, int n) {
        long l;
        CdmaCall cdmaCall;
        CdmaConnection cdmaConnection;
        CdmaConnection cdmaConnection2 = null;
        CdmaConnection[] cdmaConnectionArray = this.connections;
        Context context = this.phone.getContext();
        cdmaConnectionArray[n] = cdmaConnection = new CdmaConnection(context, driverCall, this, n);
        Call call = this.connections[n].getCall();
        if (call == (cdmaCall = this.ringingCall)) {
            cdmaConnection2 = this.connections[n];
            String string2 = "Notify new ring " + driverCall;
            this.log(string2);
            return cdmaConnection2;
        }
        String string3 = "Phantom call appeared " + driverCall;
        int n2 = Log.e(LOG_TAG, string3);
        DriverCall.State state = driverCall.state;
        DriverCall.State state2 = DriverCall.State.ALERTING;
        if (state == state2) return cdmaConnection2;
        DriverCall.State state3 = driverCall.state;
        DriverCall.State state4 = DriverCall.State.DIALING;
        if (state3 == state4) return cdmaConnection2;
        CdmaConnection cdmaConnection3 = this.connections[n];
        cdmaConnection3.connectTime = l = System.currentTimeMillis();
        return cdmaConnection2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection dialThreeWay(String string2) {
        CdmaConnection cdmaConnection;
        if (this.foregroundCall.isIdle()) return null;
        this.disableDataCallInEmergencyCall(string2);
        Context context = this.phone.getContext();
        CdmaCall cdmaCall = this.foregroundCall;
        this.pendingMO = cdmaConnection = new CdmaConnection(context, string2, this, cdmaCall);
        CommandsInterface commandsInterface = this.cm;
        String string3 = this.pendingMO.address;
        Message message = this.obtainMessage(16);
        commandsInterface.sendCDMAFeatureCode(string3, message);
        return this.pendingMO;
    }

    private void disableDataCallInEmergencyCall(String string2) {
        if (!PhoneNumberUtils.isEmergencyNumber(string2)) {
            return;
        }
        this.log("disableDataCallInEmergencyCall");
        this.mIsInEmergencyCall = true;
        boolean bl = this.phone.disableDataConnectivity();
    }

    private void fakeHoldForegroundBeforeDial() {
        List list = (List)this.foregroundCall.connections.clone();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            ((CdmaConnection)list.get(n)).fakeHoldBeforeDial();
            ++n;
        }
        return;
    }

    private void flashAndSetGenericTrue() throws CallStateException {
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainMessage(8);
        commandsInterface.sendCDMAFeatureCode("", message);
        this.foregroundCall.setGeneric(true);
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Phone.SuppService getFailedService(int n) {
        switch (n) {
            default: {
                return Phone.SuppService.UNKNOWN;
            }
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: 
        }
        return Phone.SuppService.TRANSFER;
    }

    private void handleCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        if (this.foregroundCall.connections.size() > 1) {
            this.foregroundCall.setGeneric(true);
        }
        this.ringingCall.setGeneric(false);
        Context context = this.phone.getContext();
        CdmaCall cdmaCall = this.ringingCall;
        CdmaConnection cdmaConnection = new CdmaConnection(context, cdmaCallWaitingNotification, this, cdmaCall);
        this.updatePhoneState();
        this.notifyCallWaitingInfo(cdmaCallWaitingNotification);
    }

    private void handleEcmTimer(int n) {
        this.phone.handleTimerInEmergencyCallbackMode(n);
        switch (n) {
            default: {
                String string2 = "handleEcmTimer, unsupported action " + n;
                int n2 = Log.e(LOG_TAG, string2);
                return;
            }
            case 1: {
                this.mIsEcmTimerCanceled = true;
                return;
            }
            case 0: 
        }
        this.mIsEcmTimerCanceled = false;
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void internalClearDisconnected() {
        this.ringingCall.clearDisconnected();
        this.foregroundCall.clearDisconnected();
        this.backgroundCall.clearDisconnected();
    }

    private void notifyCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        if (this.callWaitingRegistrants == null) {
            return;
        }
        RegistrantList registrantList = this.callWaitingRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, cdmaCallWaitingNotification, null);
        registrantList.notifyRegistrants(asyncResult);
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int n) {
        int n2;
        this.pendingOperations = n2 = this.pendingOperations + 1;
        this.lastRelevantPoll = null;
        this.needsPoll = true;
        return this.obtainMessage(n);
    }

    private void operationComplete() {
        int n;
        this.pendingOperations = n = this.pendingOperations - 1;
        if (this.pendingOperations == 0 && this.needsPoll) {
            Message message;
            this.lastRelevantPoll = message = this.obtainMessage(1);
            CommandsInterface commandsInterface = this.cm;
            Message message2 = this.lastRelevantPoll;
            commandsInterface.getCurrentCalls(message2);
            return;
        }
        if (this.pendingOperations >= 0) {
            return;
        }
        int n2 = Log.e(LOG_TAG, "CdmaCallTracker.pendingOperations < 0");
        this.pendingOperations = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePhoneState() {
        Phone.State state;
        Phone.State state2;
        Phone.State state3;
        Phone.State state4;
        Phone.State state5 = this.state;
        this.state = this.ringingCall.isRinging() ? (state4 = Phone.State.RINGING) : (this.pendingMO != null || !this.foregroundCall.isIdle() || !this.backgroundCall.isIdle() ? (state3 = Phone.State.OFFHOOK) : (state2 = Phone.State.IDLE));
        Phone.State state6 = this.state;
        Phone.State state7 = Phone.State.IDLE;
        if (state6 == state7 && state5 != (state = this.state)) {
            RegistrantList registrantList = this.voiceCallEndedRegistrants;
            AsyncResult asyncResult = new AsyncResult(null, null, null);
            registrantList.notifyRegistrants(asyncResult);
        } else {
            Phone.State state8;
            Phone.State state9 = Phone.State.IDLE;
            if (state5 == state9 && state5 != (state8 = this.state)) {
                RegistrantList registrantList = this.voiceCallStartedRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, null, null);
                registrantList.notifyRegistrants(asyncResult);
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("update phone state, old=").append((Object)state5).append(" new=");
        Phone.State state10 = this.state;
        String string2 = stringBuilder.append((Object)state10).toString();
        this.log(string2);
        if (this.state == state5) {
            return;
        }
        this.phone.notifyPhoneStateChanged();
    }

    void acceptCall() throws CallStateException {
        Call.State state;
        Call.State state2;
        Call.State state3 = this.ringingCall.getState();
        if (state3 == (state2 = Call.State.INCOMING)) {
            int n = Log.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.acceptCall(message);
            return;
        }
        Call.State state4 = this.ringingCall.getState();
        if (state4 == (state = Call.State.WAITING)) {
            CdmaConnection cdmaConnection = (CdmaConnection)this.ringingCall.getLatestConnection();
            CdmaCall cdmaCall = this.ringingCall;
            CdmaCall cdmaCall2 = this.foregroundCall;
            cdmaConnection.updateParent(cdmaCall, cdmaCall2);
            cdmaConnection.onConnectedInOrOut();
            this.updatePhoneState();
            this.switchWaitingOrHoldingAndActive();
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canConference() {
        Call.State state;
        Call.State state2;
        Call.State state3 = this.foregroundCall.getState();
        if (state3 != (state2 = Call.State.ACTIVE)) return false;
        Call.State state4 = this.backgroundCall.getState();
        if (state4 != (state = Call.State.HOLDING)) return false;
        if (this.backgroundCall.isFull()) return false;
        if (this.foregroundCall.isFull()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canDial() {
        Call.State state;
        int n = this.phone.getServiceState().getState();
        String string2 = SystemProperties.get("ro.telephony.disable-call", "false");
        if (n == 3) return false;
        if (this.pendingMO != null) return false;
        if (this.ringingCall.isRinging()) return false;
        if (string2.equals("true")) return false;
        if (!this.foregroundCall.getState().isAlive()) return true;
        Call.State state2 = this.foregroundCall.getState();
        if (state2 == (state = Call.State.ACTIVE)) return true;
        if (this.backgroundCall.getState().isAlive()) return false;
        return true;
    }

    boolean canTransfer() {
        int n = Log.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
    }

    void conference() throws CallStateException {
        this.flashAndSetGenericTrue();
    }

    Connection dial(String string2) throws CallStateException {
        return this.dial(string2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    Connection dial(String string2, int n) throws CallStateException {
        CdmaConnection cdmaConnection;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        boolean bl = SystemProperties.get("ril.cdma.inecmmode", "false").equals("true");
        boolean bl2 = PhoneNumberUtils.isEmergencyNumber(string2);
        if (bl && bl2) {
            CDMAPhone cDMAPhone = this.phone;
            this.handleEcmTimer(1);
        }
        this.foregroundCall.setGeneric(false);
        Call.State state = this.foregroundCall.getState();
        Call.State state2 = Call.State.ACTIVE;
        if (state == state2) {
            return this.dialThreeWay(string2);
        }
        Context context = this.phone.getContext();
        CdmaCall cdmaCall = this.foregroundCall;
        this.pendingMO = cdmaConnection = new CdmaConnection(context, string2, this, cdmaCall);
        this.hangupPendingMO = false;
        if (this.pendingMO.address == null || this.pendingMO.address.length() == 0 || this.pendingMO.address.indexOf(78) >= 0) {
            Connection.DisconnectCause disconnectCause;
            CdmaConnection cdmaConnection2 = this.pendingMO;
            cdmaConnection2.cause = disconnectCause = Connection.DisconnectCause.INVALID_NUMBER;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.disableDataCallInEmergencyCall(string2);
            if (!bl || bl && bl2) {
                CommandsInterface commandsInterface = this.cm;
                String string3 = this.pendingMO.address;
                Message message = this.obtainCompleteMessage();
                commandsInterface.dial(string3, n, message);
            } else {
                this.phone.exitEmergencyCallbackMode();
                this.phone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = n;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
        return this.pendingMO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.cm.unregisterForCallStateChanged(this);
        this.cm.unregisterForOn(this);
        this.cm.unregisterForNotAvailable(this);
        this.cm.unregisterForCallWaitingInfo(this);
        for (CdmaConnection cdmaConnection : this.connections) {
            if (cdmaConnection == null) continue;
            try {
                this.hangup(cdmaConnection);
            }
            catch (CallStateException callStateException) {
                int n = Log.e(LOG_TAG, "unexpected error on hangup during dispose");
            }
        }
        try {
            if (this.pendingMO != null) {
                CdmaConnection cdmaConnection = this.pendingMO;
                this.hangup(cdmaConnection);
            }
        }
        catch (CallStateException callStateException) {
            int n = Log.e(LOG_TAG, "unexpected error on hangup during dispose");
        }
        this.clearDisconnected();
    }

    void explicitCallTransfer() throws CallStateException {
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage(13);
        commandsInterface.explicitCallTransfer(message);
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "CdmaCallTracker finalized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CdmaConnection getConnectionByIndex(CdmaCall cdmaCall, int n) throws CallStateException {
        int n2 = cdmaCall.connections.size();
        int n3 = 0;
        while (n3 < n2) {
            CdmaConnection cdmaConnection = (CdmaConnection)cdmaCall.connections.get(n3);
            if (cdmaConnection.getCDMAIndex() != n) {
                return cdmaConnection;
            }
            ++n3;
        }
        return null;
    }

    boolean getMute() {
        return this.desiredMute;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
            case 1: {
                int n = Log.d(LOG_TAG, "Event EVENT_POLL_CALLS_RESULT Received");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Message message2 = this.lastRelevantPoll;
                if (message != message2) {
                    return;
                }
                this.needsPoll = false;
                this.lastRelevantPoll = null;
                AsyncResult asyncResult2 = (AsyncResult)message.obj;
                this.handlePollCalls(asyncResult2);
            }
            case 8: {
                return;
            }
            case 4: {
                this.operationComplete();
                return;
            }
            case 5: {
                int n;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.operationComplete();
                if (asyncResult.exception != null) {
                    n = 16;
                    int n2 = Log.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    n = ((int[])asyncResult.result)[0];
                }
                int n3 = 0;
                int n4 = this.droppedDuringPoll.size();
                while (true) {
                    if (n3 >= n4) {
                        this.updatePhoneState();
                        this.phone.notifyPreciseCallStateChanged();
                        this.droppedDuringPoll.clear();
                        return;
                    }
                    this.droppedDuringPoll.get(n3).onRemoteDisconnect(n);
                    ++n3;
                }
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                return;
            }
            case 9: {
                this.handleRadioAvailable();
                return;
            }
            case 10: {
                this.handleRadioNotAvailable();
                return;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    CommandsInterface commandsInterface = this.cm;
                    String string2 = this.pendingMO.address;
                    int n = this.pendingCallClirMode;
                    Message message3 = this.obtainCompleteMessage();
                    commandsInterface.dial(string2, n, message3);
                    this.pendingCallInEcm = false;
                }
                this.phone.unsetOnEcbModeExitResponse(this);
                return;
            }
            case 15: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    return;
                }
                CdmaCallWaitingNotification cdmaCallWaitingNotification = (CdmaCallWaitingNotification)asyncResult.result;
                this.handleCallWaitingInfo(cdmaCallWaitingNotification);
                int n = Log.d(LOG_TAG, "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                return;
            }
            case 16: 
        }
        if (((AsyncResult)message.obj).exception != null) {
            return;
        }
        this.pendingMO.onConnectedInOrOut();
        this.pendingMO = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        int n;
        int n2;
        int n3;
        ArrayList arrayList;
        if (asyncResult.exception == null) {
            arrayList = (ArrayList)asyncResult.result;
        } else {
            CdmaCallTracker cdmaCallTracker = this;
            Throwable throwable = asyncResult.exception;
            Throwable throwable2 = throwable;
            if (!cdmaCallTracker.isCommandExceptionRadioNotAvailable(throwable2)) {
                this.pollCallsAfterDelay();
                return;
            }
            arrayList = new ArrayList();
        }
        Connection connection = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = arrayList.size();
        while ((n3 = ++n4) < (n2 = (n = this.connections.length))) {
            CdmaConnection cdmaConnection = this.connections[n4];
            DriverCall driverCall = null;
            if (n5 < n6) {
                ArrayList arrayList2 = arrayList;
                int n7 = n5++;
                driverCall = (DriverCall)arrayList2.get(n7);
                int n8 = driverCall.index;
                int n9 = n8;
                int n10 = n4 + 1;
                int n11 = n10;
                if (n9 == n11) {
                    driverCall = null;
                }
            }
            if (cdmaConnection == null && driverCall != null) {
                DriverCall driverCall2;
                CdmaConnection cdmaConnection2;
                if (this.pendingMO != null && (cdmaConnection2 = this.pendingMO).compareTo(driverCall2 = driverCall)) {
                    int n12;
                    CdmaConnection cdmaConnection3;
                    CdmaConnection[] cdmaConnectionArray = this.connections;
                    cdmaConnectionArray[n4] = cdmaConnection3 = this.pendingMO;
                    CdmaConnection cdmaConnection4 = this.pendingMO;
                    cdmaConnection4.index = n12 = n4;
                    CdmaConnection cdmaConnection5 = this.pendingMO;
                    DriverCall driverCall3 = driverCall;
                    boolean bl4 = cdmaConnection5.update(driverCall3);
                    Object var30_33 = null;
                    this.pendingMO = var30_33;
                    if (this.hangupPendingMO) {
                        boolean bl5;
                        this.hangupPendingMO = bl5 = false;
                        if (this.mIsEcmTimerCanceled) {
                            CDMAPhone cDMAPhone = this.phone;
                            CdmaCallTracker cdmaCallTracker = this;
                            int n13 = 0;
                            cdmaCallTracker.handleEcmTimer(n13);
                        }
                        try {
                            StringBuilder stringBuilder = new StringBuilder().append("poll: hangupPendingMO, hangup conn ");
                            int n14 = n4;
                            String string2 = stringBuilder.append(n14).toString();
                            CdmaCallTracker cdmaCallTracker = this;
                            String string3 = string2;
                            cdmaCallTracker.log(string3);
                            CdmaConnection cdmaConnection6 = this.connections[n4];
                            CdmaCallTracker cdmaCallTracker2 = this;
                            CdmaConnection cdmaConnection7 = cdmaConnection6;
                            cdmaCallTracker2.hangup(cdmaConnection7);
                            return;
                        }
                        catch (CallStateException callStateException) {
                            int n15 = Log.e(LOG_TAG, "unexpected error on hangup");
                            return;
                        }
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("pendingMo=");
                    CdmaConnection cdmaConnection8 = this.pendingMO;
                    StringBuilder stringBuilder2 = stringBuilder.append(cdmaConnection8).append(", dc=");
                    DriverCall driverCall4 = driverCall;
                    String string4 = stringBuilder2.append(driverCall4).toString();
                    CdmaCallTracker cdmaCallTracker = this;
                    String string5 = string4;
                    cdmaCallTracker.log(string5);
                    CdmaCallTracker cdmaCallTracker3 = this;
                    DriverCall driverCall5 = driverCall;
                    int n16 = n4;
                    connection = cdmaCallTracker3.checkMtFindNewRinging(driverCall5, n16);
                    if (connection == null) {
                        bl3 = true;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                }
                bl = true;
                continue;
            }
            if (cdmaConnection != null && driverCall == null) {
                int n17 = this.foregroundCall.connections.size();
                int n18 = 0;
                while (n18 < n17) {
                    StringBuilder stringBuilder = new StringBuilder().append("adding fgCall cn ");
                    int n19 = n18;
                    String string6 = stringBuilder.append(n19).append(" to droppedDuringPoll").toString();
                    CdmaCallTracker cdmaCallTracker = this;
                    String string7 = string6;
                    cdmaCallTracker.log(string7);
                    ArrayList<Connection> arrayList3 = this.foregroundCall.connections;
                    int n20 = n18++;
                    CdmaConnection cdmaConnection9 = (CdmaConnection)arrayList3.get(n20);
                    ArrayList<CdmaConnection> arrayList4 = this.droppedDuringPoll;
                    CdmaConnection cdmaConnection10 = cdmaConnection9;
                    boolean bl6 = arrayList4.add(cdmaConnection10);
                }
                int n21 = this.ringingCall.connections.size();
                int n22 = 0;
                while (n22 < n21) {
                    StringBuilder stringBuilder = new StringBuilder().append("adding rgCall cn ");
                    int n23 = n22;
                    String string8 = stringBuilder.append(n23).append(" to droppedDuringPoll").toString();
                    CdmaCallTracker cdmaCallTracker = this;
                    String string9 = string8;
                    cdmaCallTracker.log(string9);
                    ArrayList<Connection> arrayList5 = this.ringingCall.connections;
                    int n24 = n22++;
                    CdmaConnection cdmaConnection11 = (CdmaConnection)arrayList5.get(n24);
                    ArrayList<CdmaConnection> arrayList6 = this.droppedDuringPoll;
                    CdmaConnection cdmaConnection12 = cdmaConnection11;
                    boolean bl7 = arrayList6.add(cdmaConnection12);
                }
                this.foregroundCall.setGeneric(false);
                this.ringingCall.setGeneric(false);
                if (this.mIsEcmTimerCanceled) {
                    CDMAPhone cDMAPhone = this.phone;
                    CdmaCallTracker cdmaCallTracker = this;
                    int n25 = 0;
                    cdmaCallTracker.handleEcmTimer(n25);
                }
                this.checkAndEnableDataCallAfterEmergencyCallDropped();
                this.connections[n4] = null;
                continue;
            }
            if (cdmaConnection == null || driverCall == null) continue;
            boolean bl8 = cdmaConnection.isIncoming;
            boolean bl9 = bl8;
            boolean bl10 = driverCall.isMT;
            boolean bl11 = bl10;
            if (bl9 != bl11) {
                boolean bl12 = driverCall.isMT;
                boolean bl13 = true;
                if (bl12 == bl13) {
                    ArrayList<CdmaConnection> arrayList7 = this.droppedDuringPoll;
                    CdmaConnection cdmaConnection13 = cdmaConnection;
                    boolean bl14 = arrayList7.add(cdmaConnection13);
                    CdmaCallTracker cdmaCallTracker = this;
                    DriverCall driverCall6 = driverCall;
                    int n26 = n4;
                    connection = cdmaCallTracker.checkMtFindNewRinging(driverCall6, n26);
                    if (connection == null) {
                        bl3 = true;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Error in RIL, Phantom call appeared ");
                DriverCall driverCall7 = driverCall;
                String string10 = stringBuilder.append(driverCall7).toString();
                int n27 = Log.e(LOG_TAG, string10);
                continue;
            }
            boolean bl15 = cdmaConnection.update(driverCall);
            if (bl || bl15) {
                bl = true;
                continue;
            }
            bl = false;
        }
        if (this.pendingMO != null) {
            boolean bl16;
            StringBuilder stringBuilder = new StringBuilder().append("Pending MO dropped before poll fg state:");
            Call.State state = this.foregroundCall.getState();
            String string11 = stringBuilder.append((Object)state).toString();
            int n28 = Log.d(LOG_TAG, string11);
            ArrayList<CdmaConnection> arrayList8 = this.droppedDuringPoll;
            CdmaConnection cdmaConnection = this.pendingMO;
            boolean bl17 = arrayList8.add(cdmaConnection);
            Object var111_111 = null;
            this.pendingMO = var111_111;
            this.hangupPendingMO = bl16 = false;
            if (this.pendingCallInEcm) {
                boolean bl18;
                this.pendingCallInEcm = bl18 = false;
            }
        }
        if (connection != null) {
            CDMAPhone cDMAPhone = this.phone;
            Connection connection2 = connection;
            cDMAPhone.notifyNewRingingConnection(connection2);
        }
        n4 = this.droppedDuringPoll.size() - 1;
        while (n4 >= 0) {
            ArrayList<CdmaConnection> arrayList9 = this.droppedDuringPoll;
            int n29 = n4;
            CdmaConnection cdmaConnection = arrayList9.get(n29);
            if (cdmaConnection.isIncoming() && cdmaConnection.getConnectTime() == 0L) {
                Connection.DisconnectCause disconnectCause = cdmaConnection.cause;
                Connection.DisconnectCause disconnectCause2 = disconnectCause;
                Connection.DisconnectCause disconnectCause3 = Connection.DisconnectCause.LOCAL;
                Connection.DisconnectCause disconnectCause4 = disconnectCause3;
                Connection.DisconnectCause disconnectCause5 = disconnectCause2 == disconnectCause4 ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.INCOMING_MISSED;
                StringBuilder stringBuilder = new StringBuilder().append("missed/rejected call, conn.cause=");
                Connection.DisconnectCause disconnectCause6 = cdmaConnection.cause;
                String string12 = stringBuilder.append((Object)disconnectCause6).toString();
                CdmaCallTracker cdmaCallTracker = this;
                String string13 = string12;
                cdmaCallTracker.log(string13);
                StringBuilder stringBuilder3 = new StringBuilder().append("setting cause to ");
                Connection.DisconnectCause disconnectCause7 = disconnectCause5;
                String string14 = stringBuilder3.append((Object)disconnectCause7).toString();
                CdmaCallTracker cdmaCallTracker4 = this;
                String string15 = string14;
                cdmaCallTracker4.log(string15);
                ArrayList<CdmaConnection> arrayList10 = this.droppedDuringPoll;
                int n30 = n4;
                CdmaConnection cdmaConnection14 = arrayList10.remove(n30);
                cdmaConnection.onDisconnect(disconnectCause5);
            } else {
                Connection.DisconnectCause disconnectCause = cdmaConnection.cause;
                Connection.DisconnectCause disconnectCause8 = disconnectCause;
                Connection.DisconnectCause disconnectCause9 = Connection.DisconnectCause.LOCAL;
                Connection.DisconnectCause disconnectCause10 = disconnectCause9;
                if (disconnectCause8 == disconnectCause10) {
                    ArrayList<CdmaConnection> arrayList11 = this.droppedDuringPoll;
                    int n31 = n4;
                    CdmaConnection cdmaConnection15 = arrayList11.remove(n31);
                    Connection.DisconnectCause disconnectCause11 = Connection.DisconnectCause.LOCAL;
                    CdmaConnection cdmaConnection16 = cdmaConnection;
                    Connection.DisconnectCause disconnectCause12 = disconnectCause11;
                    cdmaConnection16.onDisconnect(disconnectCause12);
                } else {
                    Connection.DisconnectCause disconnectCause13 = cdmaConnection.cause;
                    Connection.DisconnectCause disconnectCause14 = disconnectCause13;
                    Connection.DisconnectCause disconnectCause15 = Connection.DisconnectCause.INVALID_NUMBER;
                    Connection.DisconnectCause disconnectCause16 = disconnectCause15;
                    if (disconnectCause14 == disconnectCause16) {
                        ArrayList<CdmaConnection> arrayList12 = this.droppedDuringPoll;
                        int n32 = n4;
                        CdmaConnection cdmaConnection17 = arrayList12.remove(n32);
                        Connection.DisconnectCause disconnectCause17 = Connection.DisconnectCause.INVALID_NUMBER;
                        CdmaConnection cdmaConnection18 = cdmaConnection;
                        Connection.DisconnectCause disconnectCause18 = disconnectCause17;
                        cdmaConnection18.onDisconnect(disconnectCause18);
                    }
                }
            }
            int n33 = n4 + -1;
        }
        if (this.droppedDuringPoll.size() > 0) {
            CommandsInterface commandsInterface = this.cm;
            CdmaCallTracker cdmaCallTracker = this;
            int n34 = 5;
            Message message = cdmaCallTracker.obtainNoPollCompleteMessage(n34);
            commandsInterface.getLastCallFailCause(message);
        }
        if (bl2) {
            this.pollCallsAfterDelay();
        }
        if (connection != null || bl) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (bl3) {
            this.phone.notifyUnknownConnection();
        }
        if (!bl && connection == null) {
            return;
        }
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    void hangup(CdmaCall cdmaCall) throws CallStateException {
        if (cdmaCall.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        CdmaCall cdmaCall2 = this.ringingCall;
        if (cdmaCall == cdmaCall2) {
            this.log("(ringing) hangup waiting or background");
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.hangupWaitingOrBackground(message);
        } else {
            CdmaCall cdmaCall3 = this.foregroundCall;
            if (cdmaCall == cdmaCall3) {
                if (cdmaCall.isDialingOrAlerting()) {
                    this.log("(foregnd) hangup dialing or alerting...");
                    CdmaConnection cdmaConnection = (CdmaConnection)cdmaCall.getConnections().get(0);
                    this.hangup(cdmaConnection);
                } else {
                    this.hangupForegroundResumeBackground();
                }
            } else {
                CdmaCall cdmaCall4 = this.backgroundCall;
                if (cdmaCall != cdmaCall4) {
                    String string2 = "CdmaCall " + cdmaCall + "does not belong to CdmaCallTracker " + this;
                    throw new RuntimeException(string2);
                }
                if (this.ringingCall.isRinging()) {
                    this.log("hangup all conns in background call");
                    this.hangupAllConnections(cdmaCall);
                } else {
                    this.hangupWaitingOrBackground();
                }
            }
        }
        cdmaCall.onHangupLocal();
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void hangup(CdmaConnection cdmaConnection) throws CallStateException {
        if (cdmaConnection.owner != this) {
            String string2 = "CdmaConnection " + cdmaConnection + "does not belong to CdmaCallTracker " + this;
            throw new CallStateException(string2);
        }
        CdmaConnection cdmaConnection2 = this.pendingMO;
        if (cdmaConnection == cdmaConnection2) {
            this.log("hangup: set hangupPendingMO to true");
            this.hangupPendingMO = true;
        } else {
            Call.State state;
            Call.State state2;
            CdmaCall cdmaCall;
            Call call = cdmaConnection.getCall();
            if (call == (cdmaCall = this.ringingCall) && (state2 = this.ringingCall.getState()) == (state = Call.State.WAITING)) {
                cdmaConnection.onLocalDisconnect();
                this.updatePhoneState();
                this.phone.notifyPreciseCallStateChanged();
                return;
            }
            try {
                CommandsInterface commandsInterface = this.cm;
                int n = cdmaConnection.getCDMAIndex();
                Message message = this.obtainCompleteMessage();
                commandsInterface.hangupConnection(n, message);
            }
            catch (CallStateException callStateException) {
                String string3 = "CdmaCallTracker WARN: hangup() on absent connection " + cdmaConnection;
                int n = Log.w(LOG_TAG, string3);
            }
        }
        cdmaConnection.onHangupLocal();
    }

    void hangupAllConnections(CdmaCall cdmaCall) throws CallStateException {
        try {
            int n = cdmaCall.connections.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                CdmaConnection cdmaConnection = (CdmaConnection)cdmaCall.connections.get(n2);
                CommandsInterface commandsInterface = this.cm;
                int n3 = cdmaConnection.getCDMAIndex();
                Message message = this.obtainCompleteMessage();
                commandsInterface.hangupConnection(n3, message);
                ++n2;
            }
        }
        catch (CallStateException callStateException) {
            String string2 = "hangupConnectionByIndex caught " + callStateException;
            int n = Log.e(LOG_TAG, string2);
            return;
        }
    }

    void hangupConnectionByIndex(CdmaCall cdmaCall, int n) throws CallStateException {
        int n2 = cdmaCall.connections.size();
        for (int i = 0; i < n2; ++i) {
            if (((CdmaConnection)cdmaCall.connections.get(i)).getCDMAIndex() == n) continue;
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.hangupConnection(n, message);
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage();
        commandsInterface.hangupForegroundResumeBackground(message);
    }

    void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage();
        commandsInterface.hangupWaitingOrBackground(message);
    }

    boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    @Override
    protected void log(String string2) {
        String string3 = "[CdmaCallTracker] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.callWaitingRegistrants.add(registrant);
    }

    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallEndedRegistrants.add(registrant);
    }

    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallStartedRegistrants.add(registrant);
    }

    void rejectCall() throws CallStateException {
        if (this.ringingCall.getState().isRinging()) {
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.rejectCall(message);
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    void separate(CdmaConnection cdmaConnection) throws CallStateException {
        if (cdmaConnection.owner != this) {
            String string2 = "CdmaConnection " + cdmaConnection + "does not belong to CdmaCallTracker " + this;
            throw new CallStateException(string2);
        }
        try {
            CommandsInterface commandsInterface = this.cm;
            int n = cdmaConnection.getCDMAIndex();
            Message message = this.obtainCompleteMessage(12);
            commandsInterface.separateConnection(n, message);
            return;
        }
        catch (CallStateException callStateException) {
            String string3 = "CdmaCallTracker WARN: separate() on absent connection " + cdmaConnection;
            int n = Log.w(LOG_TAG, string3);
            return;
        }
    }

    void setMute(boolean bl) {
        this.desiredMute = bl;
        CommandsInterface commandsInterface = this.cm;
        boolean bl2 = this.desiredMute;
        commandsInterface.setMute(bl2, null);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        Call.State state;
        Call.State state2 = this.ringingCall.getState();
        if (state2 == (state = Call.State.INCOMING)) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.foregroundCall.getConnections().size() > 1) {
            this.flashAndSetGenericTrue();
            return;
        }
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainMessage(8);
        commandsInterface.sendCDMAFeatureCode("", message);
    }

    public void unregisterForCallWaiting(Handler handler) {
        this.callWaitingRegistrants.remove(handler);
    }

    public void unregisterForVoiceCallEnded(Handler handler) {
        this.voiceCallEndedRegistrants.remove(handler);
    }

    public void unregisterForVoiceCallStarted(Handler handler) {
        this.voiceCallStartedRegistrants.remove(handler);
    }
}

