/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.cdma.CDMAPhone;

public class CdmaDataConnection
extends DataConnection {
    private static final String LOG_TAG = "CDMA";
    private static final int PS_NET_DOWN_REASON_AUTH_FAILED = 29;
    private static final int PS_NET_DOWN_REASON_OPERATOR_DETERMINED_BARRING = 8;
    private static final int PS_NET_DOWN_REASON_OPTION_NOT_SUPPORTED = 32;
    private static final int PS_NET_DOWN_REASON_OPTION_UNSUBSCRIBED = 33;

    private CdmaDataConnection(CDMAPhone cDMAPhone, String string2) {
        super(cDMAPhone, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static CdmaDataConnection makeDataConnection(CDMAPhone cDMAPhone) {
        Object object = mCountLock;
        // MONITORENTER : object
        // MONITOREXIT : object
        StringBuilder stringBuilder = new StringBuilder().append("CdmaDataConnection-");
        int n = ++mCount;
        String string2 = stringBuilder.append(n).toString();
        CdmaDataConnection cdmaDataConnection = new CdmaDataConnection(cDMAPhone, string2);
        cdmaDataConnection.start();
        StringBuilder stringBuilder2 = new StringBuilder().append("Made ");
        String string3 = cdmaDataConnection.getName();
        String string4 = stringBuilder2.append(string3).toString();
        cdmaDataConnection.log(string4);
        return cdmaDataConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected DataConnection.FailCause getFailCauseFromRequest(int n) {
        switch (n) {
            default: {
                return DataConnection.FailCause.UNKNOWN;
            }
            case 8: {
                return DataConnection.FailCause.OPERATOR_BARRED;
            }
            case 29: {
                return DataConnection.FailCause.USER_AUTHENTICATION;
            }
            case 32: {
                return DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
            }
            case 33: 
        }
        return DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isDnsOk(String[] stringArray) {
        String string2 = stringArray[0];
        if (!"0.0.0.0".equals(string2)) return true;
        String string3 = stringArray[1];
        if (!"0.0.0.0".equals(string3)) return true;
        if (((CDMAPhone)this.phone).isDnsCheckDisabled()) return true;
        return false;
    }

    @Override
    protected void log(String string2) {
        StringBuilder stringBuilder = new StringBuilder().append("[");
        String string3 = this.getName();
        String string4 = stringBuilder.append(string3).append("] ").append(string2).toString();
        int n = Log.d(LOG_TAG, string4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onConnect(DataConnection.ConnectionParams connectionParams) {
        int n;
        DataConnection.FailCause failCause;
        this.log("CdmaDataConnection Connecting...");
        this.createTime = 65535L;
        this.lastFailTime = 65535L;
        this.lastFailCause = failCause = DataConnection.FailCause.NONE;
        if (connectionParams.apn != null && connectionParams.apn.types.length > 0 && connectionParams.apn.types[0] != null && connectionParams.apn.types[0].equals("dun")) {
            this.log("CdmaDataConnection using DUN");
            n = 1;
        } else {
            n = 0;
        }
        Message message = this.obtainMessage(3, connectionParams);
        message.obj = connectionParams;
        CommandsInterface commandsInterface = this.phone.mCM;
        String string2 = Integer.toString(0);
        String string3 = Integer.toString(n);
        String string4 = Integer.toString(3);
        String string5 = null;
        String string6 = null;
        commandsInterface.setupDataCall(string2, string3, null, string5, string6, string4, message);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("State=");
        String string2 = this.getCurrentState().getName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" create=");
        long l = this.createTime;
        StringBuilder stringBuilder3 = stringBuilder2.append(l).append(" lastFail=");
        long l2 = this.lastFailTime;
        StringBuilder stringBuilder4 = stringBuilder3.append(l2).append(" lastFasilCause=");
        DataConnection.FailCause failCause = this.lastFailCause;
        return stringBuilder4.append((Object)failCause).toString();
    }
}

