/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaDataConnection;
import com.android.internal.telephony.gsm.ApnSetting;
import java.util.ArrayList;
import java.util.Iterator;

public final class CdmaDataConnectionTracker
extends DataConnectionTracker {
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_DOWN = 1;
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_INACTIVE = 0;
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_UP = 2;
    private static final int DATA_CONNECTION_POOL_SIZE = 1;
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.cdma-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    private static final int POLL_CONNECTION_MILLIS = 5000;
    private static final int TIME_DELAYED_TO_RESTART_RADIO = SystemProperties.getInt("ro.cdma.timetoradiorestart", 60000);
    private static final String[] mDefaultApnTypes;
    private static final String[] mSupportedApnTypes;
    protected final String LOG_TAG;
    private ArrayList<DataConnection> dataConnectionList;
    boolean failNextConnect = false;
    protected ApnSetting mActiveApn;
    private CdmaDataConnection mActiveDataConnection;
    private CDMAPhone mCdmaPhone;
    BroadcastReceiver mIntentReceiver;
    private boolean mIsScreenOn = true;
    private boolean mPendingRestartRadio = false;
    private Runnable mPollNetStat;
    private boolean noAutoAttach = false;

    static {
        String[] stringArray = new String[]{"default", "mms", "dun", "hipri"};
        mSupportedApnTypes = stringArray;
        String[] stringArray2 = new String[]{"default", "mms", "hipri"};
        mDefaultApnTypes = stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CdmaDataConnectionTracker(CDMAPhone cDMAPhone) {
        super(cDMAPhone);
        Runnable runnable;
        BroadcastReceiver broadcastReceiver;
        this.LOG_TAG = "CDMA";
        this.mIntentReceiver = broadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if (string2.equals("android.intent.action.SCREEN_ON")) {
                    boolean bl = CdmaDataConnectionTracker.access$002(CdmaDataConnectionTracker.this, true);
                    CdmaDataConnectionTracker.this.stopNetStatPoll();
                    CdmaDataConnectionTracker.this.startNetStatPoll();
                    return;
                }
                if (string2.equals("android.intent.action.SCREEN_OFF")) {
                    boolean bl = CdmaDataConnectionTracker.access$002(CdmaDataConnectionTracker.this, false);
                    CdmaDataConnectionTracker.this.stopNetStatPoll();
                    CdmaDataConnectionTracker.this.startNetStatPoll();
                    return;
                }
                if (string2.equals(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                    DataConnectionTracker.State state;
                    StringBuilder stringBuilder = new StringBuilder().append("Data reconnect alarm. Previous state was ");
                    DataConnectionTracker.State state2 = CdmaDataConnectionTracker.this.state;
                    String string3 = stringBuilder.append((Object)state2).toString();
                    int n = Log.d("CDMA", string3);
                    String string4 = intent.getStringExtra(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                    DataConnectionTracker.State state3 = CdmaDataConnectionTracker.this.state;
                    if (state3 == (state = DataConnectionTracker.State.FAILED)) {
                        CdmaDataConnectionTracker.this.cleanUpConnection(false, string4);
                    }
                    boolean bl = CdmaDataConnectionTracker.this.trySetupData(string4);
                    return;
                }
                if (string2.equals("android.net.wifi.STATE_CHANGE")) {
                    NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    CdmaDataConnectionTracker cdmaDataConnectionTracker = CdmaDataConnectionTracker.this;
                    boolean bl = networkInfo != null && networkInfo.isConnected();
                    boolean bl2 = CdmaDataConnectionTracker.access$502(cdmaDataConnectionTracker, bl);
                    return;
                }
                if (!string2.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    return;
                }
                if (intent.getIntExtra("wifi_state", 4) == 3) {
                    return;
                }
                boolean bl = false;
                if (bl) {
                    return;
                }
                boolean bl3 = CdmaDataConnectionTracker.access$602(CdmaDataConnectionTracker.this, false);
            }
        };
        this.mPollNetStat = runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                long l = CdmaDataConnectionTracker.this.txPkts;
                long l2 = CdmaDataConnectionTracker.this.rxPkts;
                CdmaDataConnectionTracker cdmaDataConnectionTracker = CdmaDataConnectionTracker.this;
                long l3 = TrafficStats.getMobileTxPackets();
                long l4 = CdmaDataConnectionTracker.access$902(cdmaDataConnectionTracker, l3);
                CdmaDataConnectionTracker cdmaDataConnectionTracker2 = CdmaDataConnectionTracker.this;
                long l5 = TrafficStats.getMobileRxPackets();
                long l6 = CdmaDataConnectionTracker.access$1002(cdmaDataConnectionTracker2, l5);
                if (CdmaDataConnectionTracker.this.netStatPollEnabled && (l > 0L || l2 > 0L)) {
                    DataConnectionTracker.Activity activity;
                    long l7 = CdmaDataConnectionTracker.this.txPkts - l;
                    long l8 = CdmaDataConnectionTracker.this.rxPkts - l2;
                    if (l7 > 0L && l8 > 0L) {
                        long l9 = CdmaDataConnectionTracker.access$1402(CdmaDataConnectionTracker.this, 0L);
                        activity = DataConnectionTracker.Activity.DATAINANDOUT;
                    } else if (l7 > 0L && l8 == 0L) {
                        Phone.State state;
                        Phone.State state2 = CdmaDataConnectionTracker.this.phone.getState();
                        if (state2 == (state = Phone.State.IDLE)) {
                            long l10 = CdmaDataConnectionTracker.access$1614(CdmaDataConnectionTracker.this, l7);
                        } else {
                            long l11 = CdmaDataConnectionTracker.access$1702(CdmaDataConnectionTracker.this, 0L);
                        }
                        activity = DataConnectionTracker.Activity.DATAOUT;
                    } else if (l7 == 0L && l8 > 0L) {
                        long l12 = CdmaDataConnectionTracker.access$1802(CdmaDataConnectionTracker.this, 0L);
                        activity = DataConnectionTracker.Activity.DATAIN;
                    } else if (l7 == 0L && l8 == 0L) {
                        DataConnectionTracker.Activity activity2;
                        DataConnectionTracker.Activity activity3 = CdmaDataConnectionTracker.this.activity;
                        activity = activity3 == (activity2 = DataConnectionTracker.Activity.DORMANT) ? CdmaDataConnectionTracker.this.activity : DataConnectionTracker.Activity.NONE;
                    } else {
                        DataConnectionTracker.Activity activity4;
                        long l13 = CdmaDataConnectionTracker.access$2102(CdmaDataConnectionTracker.this, 0L);
                        DataConnectionTracker.Activity activity5 = CdmaDataConnectionTracker.this.activity;
                        activity = activity5 == (activity4 = DataConnectionTracker.Activity.DORMANT) ? CdmaDataConnectionTracker.this.activity : DataConnectionTracker.Activity.NONE;
                    }
                    if (CdmaDataConnectionTracker.this.activity != activity) {
                        DataConnectionTracker.Activity activity6 = CdmaDataConnectionTracker.access$2502(CdmaDataConnectionTracker.this, activity);
                        CdmaDataConnectionTracker.this.phone.notifyDataActivity();
                    }
                }
                if (CdmaDataConnectionTracker.this.sentSinceLastRecv >= 10L) {
                    if (CdmaDataConnectionTracker.this.mNoRecvPollCount == 0) {
                        long l14 = CdmaDataConnectionTracker.this.sentSinceLastRecv;
                        int n = EventLog.writeEvent(50101, l14);
                    }
                    if (CdmaDataConnectionTracker.this.mNoRecvPollCount < 24) {
                        int n = CdmaDataConnectionTracker.access$3108(CdmaDataConnectionTracker.this);
                        int n2 = CdmaDataConnectionTracker.access$3202(CdmaDataConnectionTracker.this, 5000);
                    } else {
                        boolean bl = CdmaDataConnectionTracker.access$3302(CdmaDataConnectionTracker.this, false);
                        CdmaDataConnectionTracker.this.stopNetStatPoll();
                        CdmaDataConnectionTracker.this.restartRadio();
                        int n = EventLog.writeEvent(50102, 24);
                    }
                } else {
                    int n = CdmaDataConnectionTracker.access$3402(CdmaDataConnectionTracker.this, 0);
                    int n3 = CdmaDataConnectionTracker.access$3502(CdmaDataConnectionTracker.this, 1000);
                }
                if (!CdmaDataConnectionTracker.this.netStatPollEnabled) {
                    return;
                }
                Handler handler = CdmaDataConnectionTracker.this.mDataConnectionTracker;
                long l15 = CdmaDataConnectionTracker.this.netStatPollPeriod;
                boolean bl = handler.postDelayed(this, l15);
            }
        };
        this.mCdmaPhone = cDMAPhone;
        cDMAPhone.mCM.registerForAvailable(this, 3, null);
        cDMAPhone.mCM.registerForOffOrNotAvailable(this, 12, null);
        cDMAPhone.mRuimRecords.registerForRecordsLoaded(this, 4, null);
        cDMAPhone.mCM.registerForNVReady(this, 31, null);
        cDMAPhone.mCM.registerForDataStateChanged(this, 6, null);
        cDMAPhone.mCT.registerForVoiceCallEnded(this, 15, null);
        cDMAPhone.mCT.registerForVoiceCallStarted(this, 14, null);
        cDMAPhone.mSST.registerForCdmaDataConnectionAttached(this, 5, null);
        cDMAPhone.mSST.registerForCdmaDataConnectionDetached(this, 30, null);
        cDMAPhone.mSST.registerForRoamingOn(this, 21, null);
        cDMAPhone.mSST.registerForRoamingOff(this, 22, null);
        cDMAPhone.mCM.registerForCdmaOtaProvision(this, 35, null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(INTENT_RECONNECT_ALARM);
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        Context context = cDMAPhone.getContext();
        BroadcastReceiver broadcastReceiver2 = this.mIntentReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver2, intentFilter, null, cDMAPhone);
        this.mDataConnectionTracker = this;
        this.createAllDataConnectionList();
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean bl = true;
        try {
            boolean bl2;
            bl = bl2 = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")).getMobileDataEnabled();
        }
        catch (Exception exception) {}
        boolean[] blArray = this.dataEnabled;
        boolean bl3 = !sharedPreferences.getBoolean("disabled_on_boot_key", false) && bl;
        blArray[0] = bl3;
        if (this.dataEnabled[0] != null) {
            int n;
            this.enabledCount = n = this.enabledCount + 1;
        }
        boolean bl4 = this.dataEnabled[0] == null;
        this.noAutoAttach = bl4;
        RetryManager retryManager = this.mRetryMgr;
        String string2 = SystemProperties.get("ro.cdma.data_retry_config");
        if (retryManager.configure(string2)) {
            return;
        }
        if (this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            return;
        }
        int n = Log.e("CDMA", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
        boolean bl5 = this.mRetryMgr.configure(20, 2000, 1000);
    }

    static /* synthetic */ boolean access$002(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.mIsScreenOn = bl;
        return bl;
    }

    static /* synthetic */ long access$1002(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.rxPkts = l;
        return l;
    }

    static /* synthetic */ long access$1402(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1614(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        long l2;
        cdmaDataConnectionTracker.sentSinceLastRecv = l2 = cdmaDataConnectionTracker.sentSinceLastRecv + l;
        return l2;
    }

    static /* synthetic */ long access$1702(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1802(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$2102(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ DataConnectionTracker.Activity access$2502(CdmaDataConnectionTracker cdmaDataConnectionTracker, DataConnectionTracker.Activity activity) {
        cdmaDataConnectionTracker.activity = activity;
        return activity;
    }

    static /* synthetic */ int access$3108(CdmaDataConnectionTracker cdmaDataConnectionTracker) {
        int n;
        int n2 = cdmaDataConnectionTracker.mNoRecvPollCount;
        cdmaDataConnectionTracker.mNoRecvPollCount = n = n2 + 1;
        return n2;
    }

    static /* synthetic */ int access$3202(CdmaDataConnectionTracker cdmaDataConnectionTracker, int n) {
        cdmaDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$3302(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.netStatPollEnabled = bl;
        return bl;
    }

    static /* synthetic */ int access$3402(CdmaDataConnectionTracker cdmaDataConnectionTracker, int n) {
        cdmaDataConnectionTracker.mNoRecvPollCount = n;
        return n;
    }

    static /* synthetic */ int access$3502(CdmaDataConnectionTracker cdmaDataConnectionTracker, int n) {
        cdmaDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$502(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ long access$902(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.txPkts = l;
        return l;
    }

    private void cleanUpConnection(boolean bl, String string2) {
        if (this.mReconnectIntent != null) {
            AlarmManager alarmManager = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            PendingIntent pendingIntent = this.mReconnectIntent;
            alarmManager.cancel(pendingIntent);
            this.mReconnectIntent = null;
        }
        DataConnectionTracker.State state = DataConnectionTracker.State.DISCONNECTING;
        this.setState(state);
        boolean bl2 = false;
        for (DataConnection dataConnection : this.dataConnectionList) {
            if (dataConnection == null) continue;
            if (bl) {
                Message message = this.obtainMessage(25, string2);
                dataConnection.disconnect(message);
                bl2 = true;
                continue;
            }
            dataConnection.resetSynchronously();
            bl2 = false;
        }
        this.stopNetStatPoll();
        if (bl2) {
            return;
        }
        this.gotoIdleAndNotifyDataConnection(string2);
    }

    private void createAllDataConnectionList() {
        ArrayList arrayList = new ArrayList();
        this.dataConnectionList = arrayList;
        int n = 0;
        while (n < 1) {
            CdmaDataConnection cdmaDataConnection = CdmaDataConnection.makeDataConnection(this.mCdmaPhone);
            boolean bl = this.dataConnectionList.add(cdmaDataConnection);
            ++n;
        }
        return;
    }

    private void destroyAllDataConnectionList() {
        if (this.dataConnectionList == null) {
            return;
        }
        ArrayList<DataConnection> arrayList = this.dataConnectionList;
        ArrayList<DataConnection> arrayList2 = this.dataConnectionList;
        boolean bl = arrayList.removeAll(arrayList2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CdmaDataConnection findFreeDataConnection() {
        CdmaDataConnection cdmaDataConnection;
        Iterator<DataConnection> iterator = this.dataConnectionList.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while (!(cdmaDataConnection = (CdmaDataConnection)iterator.next()).isInactive());
        return cdmaDataConnection;
    }

    private void gotoIdleAndNotifyDataConnection(String string2) {
        DataConnectionTracker.State state = DataConnectionTracker.State.IDLE;
        this.setState(state);
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDataAllowed() {
        boolean bl = this.phone.getServiceState().getRoaming();
        if (!this.getAnyDataEnabled()) return false;
        if (bl) {
            if (!this.getDataOnRoamingEnabled()) return false;
        }
        if (!this.mMasterDataEnabled) return false;
        return true;
    }

    private void notifyDefaultData(String string2) {
        DataConnectionTracker.State state = DataConnectionTracker.State.CONNECTED;
        this.setState(state);
        this.phone.notifyDataConnection(string2);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
    }

    private void notifyNoData(DataConnection.FailCause failCause) {
        DataConnectionTracker.State state = DataConnectionTracker.State.FAILED;
        this.setState(state);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onCdmaDataDetached() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state == state2) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("cdmaDataDetached");
            return;
        }
        DataConnectionTracker.State state3 = this.state;
        DataConnectionTracker.State state4 = DataConnectionTracker.State.FAILED;
        if (state3 == state4) {
            this.cleanUpConnection(false, "cdmaDataDetached");
            this.mRetryMgr.resetRetryCount();
            CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)this.phone.getCellLocation();
            int n = 50110;
            Object[] objectArray = new Object[2];
            int n2 = cdmaCellLocation != null ? cdmaCellLocation.getBaseStationId() : -1;
            Integer n3 = n2;
            objectArray[0] = n3;
            Integer n4 = TelephonyManager.getDefault().getNetworkType();
            objectArray[1] = n4;
            int n5 = EventLog.writeEvent(n, objectArray);
        }
        boolean bl = this.trySetupData("cdmaDataDetached");
    }

    private void onCdmaOtaProvision(AsyncResult asyncResult) {
        if (asyncResult.exception == null) {
            return;
        }
        int[] nArray = (int[])asyncResult.result;
        if (nArray == null) {
            return;
        }
        if (nArray.length <= 1) {
            return;
        }
        switch (nArray[0]) {
            default: {
                return;
            }
            case 8: 
            case 10: 
        }
        this.mRetryMgr.resetRetryCount();
    }

    private void onRestartRadio() {
        if (!this.mPendingRestartRadio) {
            return;
        }
        int n = Log.d("CDMA", "************TURN OFF RADIO**************");
        this.phone.mCM.setRadioPower(false, null);
        this.mPendingRestartRadio = false;
    }

    private void reconnectAfterFail(DataConnection.FailCause failCause, String string2) {
        PendingIntent pendingIntent;
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.FAILED;
        if (state != state2) {
            return;
        }
        int n = this.mRetryMgr.getRetryTimer();
        StringBuilder stringBuilder = new StringBuilder().append("Data Connection activate failed. Scheduling next attempt for ");
        int n2 = n / 1000;
        String string3 = stringBuilder.append(n2).append("s").toString();
        int n3 = Log.d("CDMA", string3);
        AlarmManager alarmManager = (AlarmManager)this.phone.getContext().getSystemService("alarm");
        Intent intent = new Intent(INTENT_RECONNECT_ALARM);
        Intent intent2 = intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, string2);
        this.mReconnectIntent = pendingIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
        long l = SystemClock.elapsedRealtime();
        long l2 = n;
        long l3 = l + l2;
        PendingIntent pendingIntent2 = this.mReconnectIntent;
        alarmManager.set(2, l3, pendingIntent2);
        this.mRetryMgr.increaseRetryCount();
        if (!this.shouldPostNotification(failCause)) {
            int n4 = Log.d("CDMA", "NOT Posting Data Connection Unavailable notification -- likely transient error");
            return;
        }
        this.notifyNoData(failCause);
    }

    private void resetPollStats() {
        this.txPkts = 65535L;
        this.rxPkts = 65535L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    private boolean retryAfterDisconnected(String string2) {
        boolean bl = true;
        if ("radioTurnedOff".equals(string2)) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupData(String string2) {
        int n;
        ApnSetting apnSetting;
        CdmaDataConnection cdmaDataConnection;
        CdmaDataConnection cdmaDataConnection2 = this.findFreeDataConnection();
        if (cdmaDataConnection2 == null) {
            return false;
        }
        this.mActiveDataConnection = cdmaDataConnection = cdmaDataConnection2;
        String[] stringArray = this.mRequestedApnType.equals("dun") ? new String[]{"dun"} : mDefaultApnTypes;
        this.mActiveApn = apnSetting = new ApnSetting(0, "", "", "", "", "", "", "", "", "", "", 0, stringArray);
        Message message = this.obtainMessage();
        message.what = n = 1;
        String string3 = string2;
        message.obj = string3;
        ApnSetting apnSetting2 = this.mActiveApn;
        CdmaDataConnection cdmaDataConnection3 = cdmaDataConnection2;
        Message message2 = message;
        ApnSetting apnSetting3 = apnSetting2;
        cdmaDataConnection3.connect(message2, apnSetting3);
        DataConnectionTracker.State state = DataConnectionTracker.State.INITING;
        CdmaDataConnectionTracker cdmaDataConnectionTracker = this;
        DataConnectionTracker.State state2 = state;
        cdmaDataConnectionTracker.setState(state2);
        PhoneBase phoneBase = this.phone;
        String string4 = string2;
        phoneBase.notifyDataConnection(string4);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldPostNotification(DataConnection.FailCause failCause) {
        DataConnection.FailCause failCause2 = DataConnection.FailCause.UNKNOWN;
        if (failCause == failCause2) return false;
        return true;
    }

    private void startDelayedRetry(DataConnection.FailCause failCause, String string2) {
        this.notifyNoData(failCause);
        this.reconnectAfterFail(failCause, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean trySetupData(String string2) {
        CommandsInterface.RadioState radioState;
        if (this.phone.getSimulatedRadioControl() != null) {
            DataConnectionTracker.State state = DataConnectionTracker.State.CONNECTED;
            this.setState(state);
            this.phone.notifyDataConnection(string2);
            int n = Log.i("CDMA", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int n = this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState();
        boolean bl = this.phone.getServiceState().getRoaming();
        boolean bl2 = this.mCdmaPhone.mSST.getDesiredPowerState();
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.IDLE;
        if (state != state2) {
            DataConnectionTracker.State state3 = this.state;
            DataConnectionTracker.State state4 = DataConnectionTracker.State.SCANNING;
            if (state3 != state4) return false;
        }
        if (n != 0) return false;
        CommandsInterface.RadioState radioState2 = this.phone.mCM.getRadioState();
        if (radioState2 != (radioState = CommandsInterface.RadioState.NV_READY)) {
            if (!this.mCdmaPhone.mRuimRecords.getRecordsLoaded()) return false;
        }
        if (!this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
            Phone.State state5;
            Phone.State state6 = this.phone.getState();
            if (state6 != (state5 = Phone.State.IDLE)) return false;
        }
        if (!this.isDataAllowed()) return false;
        if (!bl2) return false;
        if (this.mPendingRestartRadio) return false;
        if (this.mCdmaPhone.needsOtaServiceProvisioning()) return false;
        return this.setupData(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeEventLogCdmaDataDrop() {
        CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)this.phone.getCellLocation();
        Object[] objectArray = new Object[2];
        int n = cdmaCellLocation != null ? cdmaCellLocation.getBaseStationId() : -1;
        Integer n2 = n;
        objectArray[0] = n2;
        Integer n3 = TelephonyManager.getDefault().getNetworkType();
        objectArray[1] = n3;
        int n4 = EventLog.writeEvent(50111, objectArray);
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mCdmaPhone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForNVReady(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionAttached(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionDetached(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOn(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOff(this);
        this.phone.mCM.unregisterForCdmaOtaProvision(this);
        Context context = this.phone.getContext();
        BroadcastReceiver broadcastReceiver = this.mIntentReceiver;
        context.unregisterReceiver(broadcastReceiver);
        this.destroyAllDataConnectionList();
    }

    protected void finalize() {
    }

    @Override
    protected String getActiveApnString() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[] getActiveApnTypes() {
        if (this.mActiveApn != null) {
            return this.mActiveApn.types;
        }
        String[] stringArray = new String[]{"default"};
        return stringArray;
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        return this.dataConnectionList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[] getDnsServers(String string2) {
        if (this.mActiveDataConnection == null) return null;
        return this.mActiveDataConnection.getDnsServers();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getGateway(String string2) {
        if (this.mActiveDataConnection == null) return null;
        return this.mActiveDataConnection.getGatewayAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getInterfaceName(String string2) {
        if (this.mActiveDataConnection == null) return null;
        return this.mActiveDataConnection.getInterface();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getIpAddress(String string2) {
        if (this.mActiveDataConnection == null) return null;
        return this.mActiveDataConnection.getIpAddress();
    }

    @Override
    public void handleMessage(Message message) {
        if (!this.phone.mIsTheCurrentActivePhone) {
            int n = Log.d("CDMA", "Ignore CDMA msgs since CDMA phone is inactive");
            return;
        }
        switch (message.what) {
            default: {
                super.handleMessage(message);
                return;
            }
            case 4: {
                this.onRecordsLoaded();
                return;
            }
            case 31: {
                this.onNVReady();
                return;
            }
            case 30: {
                this.onCdmaDataDetached();
                return;
            }
            case 6: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onDataStateChanged(asyncResult);
                return;
            }
            case 35: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onCdmaOtaProvision(asyncResult);
                return;
            }
            case 36: 
        }
        this.onRestartRadio();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApnTypeActive(String string2) {
        if (this.mActiveApn == null) return false;
        if (!this.mActiveApn.canHandleType(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApnTypeAvailable(String string2) {
        String[] stringArray = mSupportedApnTypes;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            if (TextUtils.equals(string2, string3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDataConnectionAsDesired() {
        CommandsInterface.RadioState radioState;
        boolean bl = this.phone.getServiceState().getRoaming();
        CommandsInterface.RadioState radioState2 = this.phone.mCM.getRadioState();
        if (radioState2 != (radioState = CommandsInterface.RadioState.NV_READY)) {
            if (!this.mCdmaPhone.mRuimRecords.getRecordsLoaded()) return true;
        }
        if (this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState() != 0) return true;
        if (bl) {
            if (!this.getDataOnRoamingEnabled()) return true;
        }
        if (this.mIsWifiConnected) return true;
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) return false;
        return true;
    }

    @Override
    protected void log(String string2) {
        String string3 = "[CdmaDataConnectionTracker] " + string2;
        int n = Log.d("CDMA", string3);
    }

    @Override
    protected void onCleanUpConnection(boolean bl, String string2) {
        this.cleanUpConnection(bl, string2);
    }

    @Override
    protected void onDataSetupComplete(AsyncResult asyncResult) {
        String string2 = null;
        if (asyncResult.userObj instanceof String) {
            string2 = (String)asyncResult.userObj;
        }
        if (asyncResult.exception == null) {
            this.notifyDefaultData(string2);
            return;
        }
        DataConnection.FailCause failCause = (DataConnection.FailCause)((Object)asyncResult.result);
        if (failCause.isPermanentFail()) {
            this.notifyNoData(failCause);
            return;
        }
        this.startDelayedRetry(failCause, string2);
    }

    protected void onDataStateChanged(AsyncResult asyncResult) {
        block9: {
            DataConnectionTracker.Activity activity;
            ArrayList arrayList = (ArrayList)asyncResult.result;
            if (asyncResult.exception != null) {
                return;
            }
            DataConnectionTracker.State state = this.state;
            DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
            if (state != state2) break block9;
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            while (true) {
                block11: {
                    block10: {
                        int n3;
                        if (n2 >= (n3 = arrayList.size())) break block10;
                        n = ((DataCallState)arrayList.get((int)n2)).active;
                        if (n == 0) break block11;
                        bl = true;
                    }
                    if (bl) break;
                    int n4 = Log.i("CDMA", "onDataStateChanged: No active connectionstate is CONNECTED, disconnecting/cleanup");
                    this.writeEventLogCdmaDataDrop();
                    this.cleanUpConnection(true, null);
                    return;
                }
                ++n2;
            }
            switch (n) {
                default: {
                    String string2 = "onDataStateChanged: IGNORE unexpected DataCallState.active=" + n;
                    int n5 = Log.v("CDMA", string2);
                    return;
                }
                case 2: {
                    DataConnectionTracker.Activity activity2;
                    int n6 = Log.v("CDMA", "onDataStateChanged: active=LINK_ACTIVE && CONNECTED, ignore");
                    this.activity = activity2 = DataConnectionTracker.Activity.NONE;
                    this.phone.notifyDataActivity();
                    this.startNetStatPoll();
                    return;
                }
                case 1: 
            }
            int n7 = Log.v("CDMA", "onDataStateChanged active=LINK_DOWN && CONNECTED, dormant");
            this.activity = activity = DataConnectionTracker.Activity.DORMANT;
            this.phone.notifyDataActivity();
            this.stopNetStatPoll();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("onDataStateChanged: not connected, state=");
        DataConnectionTracker.State state = this.state;
        String string3 = stringBuilder.append((Object)state).append(" ignoring").toString();
        int n = Log.i("CDMA", string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDisconnectDone(AsyncResult asyncResult) {
        String string2 = null;
        if (asyncResult.userObj instanceof String) {
            string2 = (String)asyncResult.userObj;
        }
        DataConnectionTracker.State state = DataConnectionTracker.State.IDLE;
        this.setState(state);
        if (this.mPendingRestartRadio) {
            this.removeMessages(36);
        }
        if (this.mCdmaPhone.mSST.processPendingRadioPowerOffAfterDataOff()) {
            this.mPendingRestartRadio = false;
        } else {
            this.onRestartRadio();
        }
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
        if (!this.retryAfterDisconnected(string2)) {
            return;
        }
        boolean bl = this.trySetupData(string2);
    }

    @Override
    protected void onEnableNewApn() {
        this.cleanUpConnection(true, "apnSwitched");
    }

    protected void onNVReady() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.FAILED;
        if (state == state2) {
            this.cleanUpConnection(false, null);
        }
        Message message = this.obtainMessage(5);
        boolean bl = this.sendMessage(message);
    }

    @Override
    protected void onRadioAvailable() {
        DataConnectionTracker.State state;
        DataConnectionTracker.State state2;
        if (this.phone.getSimulatedRadioControl() != null) {
            DataConnectionTracker.State state3 = DataConnectionTracker.State.CONNECTED;
            this.setState(state3);
            this.phone.notifyDataConnection(null);
            int n = Log.i("CDMA", "We're on the simulator; assuming data is connected");
        }
        if ((state2 = this.state) == (state = DataConnectionTracker.State.IDLE)) {
            return;
        }
        this.cleanUpConnection(true, null);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        if (this.phone.getSimulatedRadioControl() != null) {
            int n = Log.i("CDMA", "We're on the simulator; assuming radio off is meaningless");
            return;
        }
        this.cleanUpConnection(false, "radioTurnedOff");
    }

    protected void onRecordsLoaded() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.FAILED;
        if (state == state2) {
            this.cleanUpConnection(false, null);
        }
        Message message = this.obtainMessage(5, "simLoaded");
        boolean bl = this.sendMessage(message);
    }

    @Override
    protected void onResetDone(AsyncResult asyncResult) {
        String string2 = null;
        if (asyncResult.userObj instanceof String) {
            string2 = (String)asyncResult.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(string2);
    }

    @Override
    protected void onRoamingOff() {
        boolean bl = this.trySetupData("roamingOff");
    }

    @Override
    protected void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            boolean bl = this.trySetupData("roamingOn");
            return;
        }
        this.cleanUpConnection(true, "roamingOn");
    }

    @Override
    protected boolean onTrySetupData(String string2) {
        return this.trySetupData(string2);
    }

    @Override
    protected void onVoiceCallEnded() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state == state2) {
            if (!this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
                return;
            }
            this.resetPollStats();
            return;
        }
        this.mRetryMgr.resetRetryCount();
        boolean bl = this.trySetupData("2GVoiceCallEnded");
    }

    @Override
    protected void onVoiceCallStarted() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        if (this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
            return;
        }
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("2GVoiceCallStarted");
    }

    @Override
    protected void restartRadio() {
        this.cleanUpConnection(true, "radioTurnedOff");
        long l = TIME_DELAYED_TO_RESTART_RADIO;
        boolean bl = this.sendEmptyMessageDelayed(36, l);
        this.mPendingRestartRadio = true;
    }

    @Override
    protected void setState(DataConnectionTracker.State state) {
        if (this.state == state) {
            return;
        }
        Object[] objectArray = new Object[2];
        String string2 = this.state.toString();
        objectArray[0] = string2;
        String string3 = state.toString();
        objectArray[1] = string3;
        int n = EventLog.writeEvent(50115, objectArray);
        this.state = state;
    }

    @Override
    protected void startNetStatPoll() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        if (this.netStatPollEnabled) {
            return;
        }
        int n = Log.d("CDMA", "[DataConnection] Start poll NetStat");
        this.resetPollStats();
        this.netStatPollEnabled = true;
        this.mPollNetStat.run();
    }

    @Override
    protected void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        Runnable runnable = this.mPollNetStat;
        this.removeCallbacks(runnable);
        int n = Log.d("CDMA", "[DataConnection] Stop poll NetStat");
    }
}

