/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Parcel;

public final class CdmaInformationRecords {
    public static final int RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC = 1;
    public static final int RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC = 2;
    public static final int RIL_CDMA_CONNECTED_NUMBER_INFO_REC = 3;
    public static final int RIL_CDMA_DISPLAY_INFO_REC = 0;
    public static final int RIL_CDMA_EXTENDED_DISPLAY_INFO_REC = 7;
    public static final int RIL_CDMA_LINE_CONTROL_INFO_REC = 6;
    public static final int RIL_CDMA_REDIRECTING_NUMBER_INFO_REC = 5;
    public static final int RIL_CDMA_SIGNAL_INFO_REC = 4;
    public static final int RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC = 10;
    public static final int RIL_CDMA_T53_CLIR_INFO_REC = 8;
    public static final int RIL_CDMA_T53_RELEASE_INFO_REC = 9;
    public Object record;

    public CdmaInformationRecords(Parcel parcel) {
        int n = parcel.readInt();
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("RIL_UNSOL_CDMA_INFO_REC: unsupported record. Got ");
                String string2 = CdmaInformationRecords.idToString(n);
                String string3 = stringBuilder.append(string2).append(" ").toString();
                throw new RuntimeException(string3);
            }
            case 0: 
            case 7: {
                String string4 = parcel.readString();
                CdmaDisplayInfoRec cdmaDisplayInfoRec = new CdmaDisplayInfoRec(n, string4);
                this.record = cdmaDisplayInfoRec;
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                String string5 = parcel.readString();
                int n2 = parcel.readInt();
                int n3 = parcel.readInt();
                int n4 = parcel.readInt();
                int n5 = parcel.readInt();
                CdmaNumberInfoRec cdmaNumberInfoRec = new CdmaNumberInfoRec(n, string5, n2, n3, n4, n5);
                this.record = cdmaNumberInfoRec;
                return;
            }
            case 4: {
                int n6 = parcel.readInt();
                int n7 = parcel.readInt();
                int n8 = parcel.readInt();
                int n9 = parcel.readInt();
                CdmaSignalInfoRec cdmaSignalInfoRec = new CdmaSignalInfoRec(n6, n7, n8, n9);
                this.record = cdmaSignalInfoRec;
                return;
            }
            case 5: {
                String string6 = parcel.readString();
                int n10 = parcel.readInt();
                int n11 = parcel.readInt();
                int n12 = parcel.readInt();
                int n13 = parcel.readInt();
                int n14 = parcel.readInt();
                CdmaRedirectingNumberInfoRec cdmaRedirectingNumberInfoRec = new CdmaRedirectingNumberInfoRec(string6, n10, n11, n12, n13, n14);
                this.record = cdmaRedirectingNumberInfoRec;
                return;
            }
            case 6: {
                int n15 = parcel.readInt();
                int n16 = parcel.readInt();
                int n17 = parcel.readInt();
                int n18 = parcel.readInt();
                CdmaLineControlInfoRec cdmaLineControlInfoRec = new CdmaLineControlInfoRec(n15, n16, n17, n18);
                this.record = cdmaLineControlInfoRec;
                return;
            }
            case 8: {
                int n19 = parcel.readInt();
                CdmaT53ClirInfoRec cdmaT53ClirInfoRec = new CdmaT53ClirInfoRec(n19);
                this.record = cdmaT53ClirInfoRec;
                return;
            }
            case 10: 
        }
        int n20 = parcel.readInt();
        int n21 = parcel.readInt();
        CdmaT53AudioControlInfoRec cdmaT53AudioControlInfoRec = new CdmaT53AudioControlInfoRec(n20, n21);
        this.record = cdmaT53AudioControlInfoRec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String idToString(int n) {
        switch (n) {
            default: {
                return "<unknown record>";
            }
            case 0: {
                return "RIL_CDMA_DISPLAY_INFO_REC";
            }
            case 1: {
                return "RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC";
            }
            case 2: {
                return "RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC";
            }
            case 3: {
                return "RIL_CDMA_CONNECTED_NUMBER_INFO_REC";
            }
            case 4: {
                return "RIL_CDMA_SIGNAL_INFO_REC";
            }
            case 5: {
                return "RIL_CDMA_REDIRECTING_NUMBER_INFO_REC";
            }
            case 6: {
                return "RIL_CDMA_LINE_CONTROL_INFO_REC";
            }
            case 7: {
                return "RIL_CDMA_EXTENDED_DISPLAY_INFO_REC";
            }
            case 8: {
                return "RIL_CDMA_T53_CLIR_INFO_REC";
            }
            case 9: {
                return "RIL_CDMA_T53_RELEASE_INFO_REC";
            }
            case 10: 
        }
        return "RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC";
    }

    public static class CdmaT53AudioControlInfoRec {
        public byte downlink;
        public byte uplink;

        public CdmaT53AudioControlInfoRec(int n, int n2) {
            byte by;
            byte by2;
            this.uplink = by2 = (byte)n;
            this.downlink = by = (byte)n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaT53AudioControlInfoRec: { uplink: ");
            byte by = this.uplink;
            StringBuilder stringBuilder2 = stringBuilder.append(by).append(" downlink: ");
            byte by2 = this.downlink;
            return stringBuilder2.append(by2).append(" }").toString();
        }
    }

    public static class CdmaT53ClirInfoRec {
        public byte cause;

        public CdmaT53ClirInfoRec(int n) {
            byte by;
            this.cause = by = (byte)n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaT53ClirInfoRec: { cause: ");
            byte by = this.cause;
            return stringBuilder.append(by).append(" }").toString();
        }
    }

    public static class CdmaLineControlInfoRec {
        public byte lineCtrlPolarityIncluded;
        public byte lineCtrlPowerDenial;
        public byte lineCtrlReverse;
        public byte lineCtrlToggle;

        public CdmaLineControlInfoRec(int n, int n2, int n3, int n4) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            this.lineCtrlPolarityIncluded = by4 = (byte)n;
            this.lineCtrlToggle = by3 = (byte)n2;
            this.lineCtrlReverse = by2 = (byte)n3;
            this.lineCtrlPowerDenial = by = (byte)n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaLineControlInfoRec: { lineCtrlPolarityIncluded: ");
            byte by = this.lineCtrlPolarityIncluded;
            StringBuilder stringBuilder2 = stringBuilder.append(by).append(" lineCtrlToggle: ");
            byte by2 = this.lineCtrlToggle;
            StringBuilder stringBuilder3 = stringBuilder2.append(by2).append(" lineCtrlReverse: ");
            byte by3 = this.lineCtrlReverse;
            StringBuilder stringBuilder4 = stringBuilder3.append(by3).append(" lineCtrlPowerDenial: ");
            byte by4 = this.lineCtrlPowerDenial;
            return stringBuilder4.append(by4).append(" }").toString();
        }
    }

    public static class CdmaRedirectingNumberInfoRec {
        public static final int REASON_CALLED_DTE_OUT_OF_ORDER = 9;
        public static final int REASON_CALL_FORWARDING_BUSY = 1;
        public static final int REASON_CALL_FORWARDING_BY_THE_CALLED_DTE = 10;
        public static final int REASON_CALL_FORWARDING_NO_REPLY = 2;
        public static final int REASON_CALL_FORWARDING_UNCONDITIONAL = 15;
        public static final int REASON_UNKNOWN;
        public CdmaNumberInfoRec numberInfoRec;
        public int redirectingReason;

        public CdmaRedirectingNumberInfoRec(String string2, int n, int n2, int n3, int n4, int n5) {
            CdmaNumberInfoRec cdmaNumberInfoRec;
            String string3 = string2;
            int n6 = n;
            int n7 = n2;
            int n8 = n3;
            int n9 = n4;
            this.numberInfoRec = cdmaNumberInfoRec = new CdmaNumberInfoRec(5, string3, n6, n7, n8, n9);
            this.redirectingReason = n5;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaNumberInfoRec: { numberInfoRec: ");
            CdmaNumberInfoRec cdmaNumberInfoRec = this.numberInfoRec;
            StringBuilder stringBuilder2 = stringBuilder.append(cdmaNumberInfoRec).append(", redirectingReason: ");
            int n = this.redirectingReason;
            return stringBuilder2.append(n).append(" }").toString();
        }
    }

    public static class CdmaNumberInfoRec {
        public int id;
        public String number;
        public byte numberPlan;
        public byte numberType;
        public byte pi;
        public byte si;

        public CdmaNumberInfoRec(int n, String string2, int n2, int n3, int n4, int n5) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            this.number = string2;
            this.numberType = by4 = (byte)n2;
            this.numberPlan = by3 = (byte)n3;
            this.pi = by2 = (byte)n4;
            this.si = by = (byte)n5;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaNumberInfoRec: { id: ");
            String string2 = CdmaInformationRecords.idToString(this.id);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", number: ");
            String string3 = this.number;
            StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(", numberType: ");
            byte by = this.numberType;
            StringBuilder stringBuilder4 = stringBuilder3.append(by).append(", numberPlan: ");
            byte by2 = this.numberPlan;
            StringBuilder stringBuilder5 = stringBuilder4.append(by2).append(", pi: ");
            byte by3 = this.pi;
            StringBuilder stringBuilder6 = stringBuilder5.append(by3).append(", si: ");
            byte by4 = this.si;
            return stringBuilder6.append(by4).append(" }").toString();
        }
    }

    public static class CdmaDisplayInfoRec {
        public String alpha;
        public int id;

        public CdmaDisplayInfoRec(int n, String string2) {
            this.id = n;
            this.alpha = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaDisplayInfoRec: { id: ");
            String string2 = CdmaInformationRecords.idToString(this.id);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", alpha: ");
            String string3 = this.alpha;
            return stringBuilder2.append(string3).append(" }").toString();
        }
    }

    public static class CdmaSignalInfoRec {
        public int alertPitch;
        public boolean isPresent;
        public int signal;
        public int signalType;

        public CdmaSignalInfoRec() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public CdmaSignalInfoRec(int n, int n2, int n3, int n4) {
            boolean bl = n != 0;
            this.isPresent = bl;
            this.signalType = n2;
            this.alertPitch = n3;
            this.signal = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CdmaSignalInfo: { isPresent: ");
            boolean bl = this.isPresent;
            StringBuilder stringBuilder2 = stringBuilder.append(bl).append(", signalType: ");
            int n = this.signalType;
            StringBuilder stringBuilder3 = stringBuilder2.append(n).append(", alertPitch: ");
            int n2 = this.alertPitch;
            StringBuilder stringBuilder4 = stringBuilder3.append(n2).append(", signal: ");
            int n3 = this.signal;
            return stringBuilder4.append(n3).append(" }").toString();
        }
    }
}

