/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CdmaMmiCode
extends Handler
implements MmiCode {
    static final String ACTION_REGISTER = "**";
    static final int EVENT_SET_COMPLETE = 1;
    static final String LOG_TAG = "CDMA_MMI";
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final String SC_PUK = "05";
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    String action;
    Context context;
    String dialingNumber;
    CharSequence message;
    CDMAPhone phone;
    String poundString;
    String pwd;
    String sc;
    String sia;
    String sib;
    String sic;
    MmiCode.State state;

    CdmaMmiCode(CDMAPhone cDMAPhone) {
        Context context;
        MmiCode.State state;
        Looper looper = cDMAPhone.getHandler().getLooper();
        super(looper);
        this.state = state = MmiCode.State.PENDING;
        this.phone = cDMAPhone;
        this.context = context = cDMAPhone.getContext();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence getScString() {
        void var1_2;
        if (this.sc != null && this.isPukCommand()) {
            CharSequence charSequence = this.context.getText(17039559);
            return var1_2;
        }
        String string2 = "";
        return var1_2;
    }

    private void handlePasswordError(int n) {
        MmiCode.State state;
        this.state = state = MmiCode.State.FAILED;
        CharSequence charSequence = this.getScString();
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        StringBuilder stringBuilder2 = stringBuilder.append("\n");
        CharSequence charSequence2 = this.context.getText(n);
        StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String makeEmptyNull(String string2) {
        if (string2 == null) return string2;
        if (string2.length() != 0) return string2;
        return null;
    }

    public static CdmaMmiCode newFromDialString(String string2, CDMAPhone cDMAPhone) {
        CdmaMmiCode cdmaMmiCode = null;
        Matcher matcher = sPatternSuppService.matcher(string2);
        if (matcher.matches()) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            cdmaMmiCode = new CdmaMmiCode(cDMAPhone);
            cdmaMmiCode.poundString = string10 = CdmaMmiCode.makeEmptyNull(matcher.group(1));
            cdmaMmiCode.action = string9 = CdmaMmiCode.makeEmptyNull(matcher.group(2));
            cdmaMmiCode.sc = string8 = CdmaMmiCode.makeEmptyNull(matcher.group(3));
            cdmaMmiCode.sia = string7 = CdmaMmiCode.makeEmptyNull(matcher.group(5));
            cdmaMmiCode.sib = string6 = CdmaMmiCode.makeEmptyNull(matcher.group(7));
            cdmaMmiCode.sic = string5 = CdmaMmiCode.makeEmptyNull(matcher.group(9));
            cdmaMmiCode.pwd = string4 = CdmaMmiCode.makeEmptyNull(matcher.group(11));
            cdmaMmiCode.dialingNumber = string3 = CdmaMmiCode.makeEmptyNull(matcher.group(12));
        }
        return cdmaMmiCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSetComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder;
        block6: {
            block7: {
                block8: {
                    CommandException.Error error;
                    MmiCode.State state;
                    CharSequence charSequence = this.getScString();
                    stringBuilder = new StringBuilder(charSequence);
                    StringBuilder stringBuilder2 = stringBuilder.append("\n");
                    if (asyncResult.exception == null) break block7;
                    this.state = state = MmiCode.State.FAILED;
                    if (!(asyncResult.exception instanceof CommandException)) break block8;
                    CommandException.Error error2 = ((CommandException)asyncResult.exception).getCommandError();
                    if (error2 == (error = CommandException.Error.PASSWORD_INCORRECT)) {
                        if (this.isPukCommand()) {
                            CharSequence charSequence2 = this.context.getText(17039548);
                            StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
                            break block6;
                        } else {
                            CharSequence charSequence3 = this.context.getText(17039545);
                            StringBuilder stringBuilder4 = stringBuilder.append(charSequence3);
                        }
                        break block6;
                    } else {
                        CharSequence charSequence4 = this.context.getText(17039538);
                        StringBuilder stringBuilder5 = stringBuilder.append(charSequence4);
                    }
                    break block6;
                }
                CharSequence charSequence = this.context.getText(17039538);
                StringBuilder stringBuilder6 = stringBuilder.append(charSequence);
                break block6;
            }
            if (this.isRegister()) {
                MmiCode.State state;
                this.state = state = MmiCode.State.COMPLETE;
                CharSequence charSequence = this.context.getText(17039543);
                StringBuilder stringBuilder7 = stringBuilder.append(charSequence);
            } else {
                MmiCode.State state;
                this.state = state = MmiCode.State.FAILED;
                CharSequence charSequence = this.context.getText(17039538);
                StringBuilder stringBuilder8 = stringBuilder.append(charSequence);
            }
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    @Override
    public void cancel() {
        MmiCode.State state;
        MmiCode.State state2 = this.state;
        MmiCode.State state3 = MmiCode.State.COMPLETE;
        if (state2 == state3) {
            return;
        }
        MmiCode.State state4 = this.state;
        MmiCode.State state5 = MmiCode.State.FAILED;
        if (state4 == state5) {
            return;
        }
        this.state = state = MmiCode.State.CANCELLED;
        this.phone.onMMIDone(this);
    }

    @Override
    public CharSequence getMessage() {
        return this.message;
    }

    @Override
    public MmiCode.State getState() {
        return this.state;
    }

    @Override
    public void handleMessage(Message message) {
        if (message.what == 1) {
            AsyncResult asyncResult = (AsyncResult)message.obj;
            this.onSetComplete(asyncResult);
            return;
        }
        int n = Log.e(LOG_TAG, "Unexpected reply");
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isPukCommand() {
        if (this.sc == null) return false;
        if (!this.sc.equals(SC_PUK)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRegister() {
        if (this.action == null) return false;
        if (!this.action.equals(ACTION_REGISTER)) return false;
        return true;
    }

    @Override
    public boolean isUssdRequest() {
        int n = Log.w(LOG_TAG, "isUssdRequest is not implemented in CdmaMmiCode");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processCode() {
        try {
            if (!this.isPukCommand()) throw new RuntimeException("Invalid or Unsupported MMI Code");
            String string2 = this.sia;
            String string3 = this.sib;
            int n = string3.length();
            if (!this.isRegister()) throw new RuntimeException("Invalid or Unsupported MMI Code");
            String string4 = this.sic;
            if (!string3.equals(string4)) {
                this.handlePasswordError(17039549);
                return;
            }
            if (n < 4 || n > 8) {
                this.handlePasswordError(17039550);
                return;
            }
            CommandsInterface commandsInterface = this.phone.mCM;
            Message message = this.obtainMessage(1, this);
            commandsInterface.supplyIccPuk(string2, string3, message);
            return;
        }
        catch (RuntimeException runtimeException) {
            CharSequence charSequence;
            MmiCode.State state;
            this.state = state = MmiCode.State.FAILED;
            this.message = charSequence = this.context.getText(17039538);
            this.phone.onMMIDone(this);
            return;
        }
    }
}

