/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;

final class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CDMA";
    private byte[] mLastAcknowledgedSmsFingerprint;
    private byte[] mLastDispatchedSmsFingerprint;

    CdmaSMSDispatcher(CDMAPhone cDMAPhone) {
        super(cDMAPhone);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCdmaStatusReport(SmsMessage smsMessage) {
        int n = 0;
        int n2 = this.deliveryPendingList.size();
        while (n < n2) {
            SMSDispatcher.SmsTracker smsTracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(n);
            int n3 = smsTracker.mMessageRef;
            int n4 = smsMessage.messageRef;
            if (n3 != n4) {
                Object e = this.deliveryPendingList.remove(n);
                PendingIntent pendingIntent = smsTracker.mDeliveryIntent;
                Intent intent = new Intent();
                byte[] byArray = smsMessage.getPdu();
                Intent intent2 = intent.putExtra("pdu", byArray);
                try {
                    Context context = this.mContext;
                    pendingIntent.send(context, -1, intent);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    return;
                }
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int resultToCause(int n) {
        switch (n) {
            default: {
                return 96;
            }
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 35;
            }
            case 4: 
        }
        return 4;
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        if (SystemProperties.get("ril.cdma.inecmmode", "false").equals("true")) {
            return;
        }
        if (this.mCm == null) {
            return;
        }
        int n2 = this.resultToCause(n);
        this.mCm.acknowledgeLastIncomingCdmaSms(bl, n2, message);
        if (n2 == 0) {
            byte[] byArray = this.mLastDispatchedSmsFingerprint;
            this.mLastAcknowledgedSmsFingerprint = byArray;
        }
        this.mLastDispatchedSmsFingerprint = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void activateCellBroadcastSms(int n, Message message) {
        CommandsInterface commandsInterface = this.mCm;
        boolean bl = n == 0;
        commandsInterface.setCdmaBroadcastActivation(bl, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int dispatchMessage(SmsMessageBase smsMessageBase) {
        int n;
        SmsMessage.MessageClass messageClass;
        SmsMessage.MessageClass messageClass2;
        byte[] byArray;
        byte[] byArray2;
        if (smsMessageBase == null) {
            int n2 = Log.e(TAG, "dispatchMessage: message is null");
            return 2;
        }
        if (SystemProperties.get("ril.cdma.inecmmode", "false").equals("true")) {
            return -1;
        }
        SmsMessage smsMessage = (SmsMessage)smsMessageBase;
        byte[] byArray3 = smsMessage.getIncomingSmsFingerprint();
        this.mLastDispatchedSmsFingerprint = byArray3;
        if (this.mLastAcknowledgedSmsFingerprint != null && Arrays.equals(byArray2 = this.mLastDispatchedSmsFingerprint, byArray = this.mLastAcknowledgedSmsFingerprint)) {
            return 1;
        }
        smsMessage.parseSms();
        int n3 = smsMessage.getTeleService();
        boolean bl = false;
        if (4099 == n3 || 262144 != n3) {
            int n4 = smsMessage.getNumOfVoicemails();
            String string2 = "Voicemail count=" + n4;
            int n5 = Log.d(TAG, string2);
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext()).edit();
            SharedPreferences.Editor editor2 = editor.putInt("vm_count_key_cdma", n4);
            editor.apply();
            ((CDMAPhone)this.mPhone).updateMessageWaitingIndicator(n4);
            return 1;
        }
        if ((4098 == n3 || 4101 != n3) && smsMessage.isStatusReportMessage()) {
            this.handleCdmaStatusReport(smsMessage);
            return 1;
        }
        if (smsMessage.getUserData() == null) {
            int n6 = Log.d(TAG, "Received SMS without user data");
            return 1;
        }
        if (bl) {
            return 1;
        }
        if (!this.mStorageAvailable && (messageClass2 = smsMessage.getMessageClass()) != (messageClass = SmsMessage.MessageClass.CLASS_0)) {
            return 3;
        }
        if (4100 != n3) {
            byte[] byArray4 = smsMessage.getUserData();
            int n7 = smsMessage.messageRef;
            String string3 = smsMessage.getOriginatingAddress();
            return this.processCdmaWapPdu(byArray4, n7, string3);
        }
        if (4098 != n3 && 4101 != n3 && 1 != (n = smsMessage.getMessageType())) {
            return 4;
        }
        SmsHeader smsHeader = smsMessage.getUserDataHeader();
        if (smsHeader != null && smsHeader.concatRef != null) {
            SmsHeader.ConcatRef concatRef = smsHeader.concatRef;
            SmsHeader.PortAddrs portAddrs = smsHeader.portAddrs;
            return this.processMessagePart(smsMessage, concatRef, portAddrs);
        }
        byte[] byArray5 = new byte[1];
        byte[] byArray6 = smsMessage.getPdu();
        byArray5[0] = (byte)byArray6;
        if (smsHeader != null && smsHeader.portAddrs != null) {
            if (smsHeader.portAddrs.destPort == 2948) {
                WapPushOverSms wapPushOverSms = this.mWapPush;
                byte[] byArray7 = smsMessage.getUserData();
                return wapPushOverSms.dispatchWapPdu(byArray7);
            }
            int n8 = smsHeader.portAddrs.destPort;
            this.dispatchPortAddressedPdus((byte[][])byArray5, n8);
            return -1;
        } else {
            this.dispatchPdus((byte[][])byArray5);
        }
        return -1;
    }

    @Override
    protected void getCellBroadcastSmsConfig(Message message) {
        this.mCm.getCdmaBroadcastConfig(message);
    }

    @Override
    protected void handleStatusReport(AsyncResult asyncResult) {
        int n = Log.d(TAG, "handleStatusReport is a special GSM function, should never be called in CDMA!");
    }

    /*
     * Unable to fully structure code
     */
    protected int processCdmaWapPdu(byte[] var1_1, int var2_2, String var3_3) {
        block21: {
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0 + 1;
            var7_7 = var1_1[0];
            if (var7_7 != null) {
                var8_8 = Log.w("CDMA", "Received a WAP SMS which is not WDP. Discard.");
                var9_9 = 1;
                var10_10 = var6_6;
lbl9:
                // 6 sources

                return var9_9;
            }
            var11_11 = var6_6 + 1;
            var12_12 = var1_1[var6_6];
            var6_6 = var11_11 + 1;
            var13_13 = var1_1[var11_11];
            if (var13_13 != null) break block21;
            var14_14 = var6_6 + 1;
            var15_15 = (var1_1[var6_6] & 255) << 8;
            var16_16 = var14_14 + 1;
            var17_17 = var1_1[var14_14] & 255;
            var4_4 = var15_15 | var17_17;
            var18_18 = var16_16 + 1;
            var19_19 = (var1_1[var16_16] & 255) << 8;
            var20_20 = var18_18 + 1;
            var21_21 = var1_1[var18_18] & 255;
            var5_5 = var19_19 | var21_21;
            var22_22 = var20_20;
lbl27:
            // 2 sources

            while (true) {
                block22: {
                    block20: {
                        block19: {
                            block18: {
                                var24_24 = var23_23;
                                var25_25 = "reference_number =";
                                var24_24(var25_25);
                                var26_26 = var23_23;
                                var27_27 = var2_2;
                                var28_28 = var26_26.append(var27_27);
                                var29_29 = var23_23;
                                var30_30 = " AND address = ?";
                                var31_31 = var29_29.append(var30_30);
                                var32_32 = new String[]{var3_3};
                                var33_33 = new StringBuilder().append("Received WAP PDU. Type = ");
                                var34_34 = var7_7;
                                var35_35 = var33_33.append(var34_34).append(", originator = ");
                                var36_36 = var3_3;
                                var37_37 = var35_35.append(var36_36).append(", src-port = ");
                                var38_38 = var4_4;
                                var39_39 = var37_37.append(var38_38).append(", dst-port = ").append(var5_5).append(", ID = ");
                                var40_40 = var2_2;
                                var41_41 = var39_39.append(var40_40).append(", segment# = ");
                                var42_42 = var13_13;
                                var43_43 = var41_41.append(var42_42).append("/");
                                var44_44 = var12_12;
                                var45_45 = var43_43.append(var44_44).toString();
                                var46_46 = Log.i("CDMA", var45_45);
                                var47_47 = null;
                                var48_48 = this.mResolver;
                                var49_49 = this.mRawUri;
                                var50_50 = CdmaSMSDispatcher.RAW_PROJECTION;
                                var51_51 = var23_23.toString();
                                var52_52 = var48_48.query(var49_49, var50_50, var51_51, var32_32, null);
                                var53_53 = var52_52.getCount();
                                var54_54 = var12_12 - 1;
                                if (var53_53 == var54_54) break block18;
                                var55_55 = new ContentValues();
                                var56_56 = new Long(0L);
                                var57_57 = var55_55;
                                var58_58 = "date";
                                var59_59 = var56_56;
                                var57_57.put(var58_58, var59_59);
                                var60_60 = var1_1.length - var22_22;
                                var61_61 = var1_1;
                                var62_62 = var22_22;
                                var63_63 = var60_60;
                                var64_64 = HexDump.toHexString(var61_61, var62_62, var63_63);
                                var65_65 = var55_55;
                                var66_66 = "pdu";
                                var67_67 = var64_64;
                                var65_65.put(var66_66, var67_67);
                                var68_68 = var55_55;
                                var69_69 = "address";
                                var70_70 = var3_3;
                                var68_68.put(var69_69, var70_70);
                                var71_71 = var2_2;
                                var72_72 = var55_55;
                                var73_73 = "reference_number";
                                var74_74 = var71_71;
                                var72_72.put(var73_73, var74_74);
                                var75_75 = var12_12;
                                var76_76 = var55_55;
                                var77_77 = "count";
                                var78_78 = var75_75;
                                var76_76.put(var77_77, var78_78);
                                var79_79 = var13_13;
                                var80_80 = var55_55;
                                var81_81 = "sequence";
                                var82_82 = var79_79;
                                var80_80.put(var81_81, var82_82);
                                var83_83 = var5_5;
                                var84_84 = var55_55;
                                var85_85 = "destination_port";
                                var86_86 = var83_83;
                                var84_84.put(var85_85, var86_86);
                                var87_87 = this.mResolver;
                                var88_88 = this.mRawUri;
                                var89_89 = var87_87;
                                var90_90 = var88_88;
                                var91_91 = var55_55;
                                var92_92 = var89_89.insert(var90_90, var91_91);
                                var9_9 = 1;
                                if (var52_52 == null) ** GOTO lbl9
lbl109:
                                // 2 sources

                                while (true) {
                                    var52_52.close();
                                    ** GOTO lbl9
                                    break;
                                }
                            }
                            try {
                                var93_93 = var52_52.getColumnIndex("pdu");
                                var94_94 = var52_52.getColumnIndex("sequence");
                                var95_95 = new byte[var12_12];
                                var96_96 = 0;
                                while ((var97_97 = ++var96_96) < (var98_98 = var53_53)) {
                                    var99_99 = var52_52.moveToNext();
                                    var100_100 = var52_52;
                                    var101_101 = var94_94;
                                    var102_102 = (int)var100_100.getLong(var101_101);
                                    if (var102_102 == 0) {
                                        var103_103 = var52_52.getColumnIndex("destination_port");
                                        var5_5 = (int)var52_52.getLong(var103_103);
                                    }
                                    var104_104 = var52_52;
                                    var105_105 = var93_93;
                                    var106_106 = HexDump.hexStringToByteArray(var104_104.getString(var105_105));
                                    var95_95[var102_102] = (byte)var106_106;
                                }
                                var107_107 = this.mResolver;
                                var108_108 = this.mRawUri;
                                var109_109 = var23_23.toString();
                                var110_110 = var107_107.delete(var108_108, var109_109, var32_32);
                                if (var52_52 == null) break block19;
                            }
                            catch (SQLException var122_128) {
                                try {
                                    var123_129 = "CDMA";
                                    var124_130 = "Can't access multipart SMS database";
                                    var125_131 = var122_128;
                                    var126_132 = Log.e(var123_129, var124_130, var125_131);
                                    var9_9 = 2;
                                    if (var52_52 == null) ** GOTO lbl9
                                    ** continue;
                                }
                                catch (Throwable var127_133) {
                                    if (var52_52 != null) {
                                        var52_52.close();
                                    }
                                    throw var127_133;
                                }
                            }
                            var52_52.close();
                        }
                        var111_111 = new ByteArrayOutputStream();
                        var112_112 = 0;
                        block12: while ((var113_119 = ++var112_112) < (var114_120 = var12_12)) {
                            var115_121 = var112_112;
                            var116_122 = var13_13;
                            if (var115_121 != var116_122) {
                                var117_123 = var1_1.length - var22_22;
                                var118_124 = var111_111;
                                var119_125 = var1_1;
                                var120_126 = var22_22;
                                var121_127 = var117_123;
                                var118_124.write(var119_125, var120_126, var121_127);
lbl150:
                                // 2 sources

                                continue block12;
                            }
                            break block20;
                        }
                        break block22;
                    }
                    var128_113 = var95_95[var112_112];
                    var129_114 = ((byte)var95_95[var112_112]).length;
                    var130_115 = var111_111;
                    var131_116 = var128_113;
                    var132_117 = 0;
                    var133_118 = var129_114;
                    var130_115.write((byte[])var131_116, var132_117, var133_118);
                    ** continue;
                }
                var134_134 = var111_111.toByteArray();
                switch (var5_5) {
                    default: {
                        var135_135 = new byte[]{(byte)var134_134};
                        var136_136 = this;
                        var137_137 = var135_135;
                        var138_138 = var5_5;
                        var136_136.dispatchPortAddressedPdus((byte[][])var137_137, var138_138);
                        var9_9 = -1;
                        ** GOTO lbl9
                    }
                    case 2948: 
                }
                var9_9 = this.mWapPush.dispatchWapPdu(var134_134);
                ** continue;
                break;
            }
        }
        var22_22 = var6_6;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, n, byArray, bl);
        this.sendSubmitPdu(submitPdu, pendingIntent, pendingIntent2);
    }

    @Override
    protected void sendMultipartSms(SMSDispatcher.SmsTracker smsTracker) {
        int n = Log.d(TAG, "TODO: CdmaSMSDispatcher.sendMultipartSms not implemented");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        int n = CdmaSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int n2 = arrayList.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ArrayList<String> arrayList4 = arrayList;
            int n4 = i;
            CharSequence charSequence = arrayList4.get(n4);
            boolean bl = false;
            SmsMessageBase.TextEncodingDetails textEncodingDetails = SmsMessage.calculateLength(charSequence, bl);
            int n5 = textEncodingDetails.codeUnitSize;
            if (n3 == n5 || n3 != 0 && n3 != 1) continue;
            n3 = textEncodingDetails.codeUnitSize;
        }
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            String string4;
            int n8;
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = n;
            concatRef.seqNumber = n8 = n6 + 1;
            concatRef.msgCount = n2;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            PendingIntent pendingIntent = null;
            if (arrayList2 != null && arrayList2.size() > n6) {
                ArrayList<PendingIntent> arrayList5 = arrayList2;
                int n9 = n6;
                pendingIntent = arrayList5.get(n9);
            }
            PendingIntent pendingIntent2 = null;
            if (arrayList3 != null && arrayList3.size() > n6) {
                ArrayList<PendingIntent> arrayList6 = arrayList3;
                int n10 = n6;
                pendingIntent2 = arrayList6.get(n10);
            }
            UserData userData = new UserData();
            ArrayList<String> arrayList7 = arrayList;
            int n11 = n6;
            userData.payloadStr = string4 = arrayList7.get(n11);
            userData.userDataHeader = smsHeader;
            userData.msgEncoding = n3 == 1 ? 9 : 4;
            userData.msgEncodingSet = true;
            boolean bl = pendingIntent2 != null && n6 != (n7 = n2 - 1);
            SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string2, userData, bl);
            this.sendSubmitPdu(submitPdu, pendingIntent, pendingIntent2);
            ++n6;
        }
        return;
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        byte[] byArray = (byte[])smsTracker.mData.get("pdu");
        Message message = this.obtainMessage(2, smsTracker);
        this.mCm.sendCdmaSms(byArray, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendSubmitPdu(SmsMessage.SubmitPdu submitPdu, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        if (!SystemProperties.getBoolean("ril.cdma.inecmmode", false)) {
            byte[] byArray = submitPdu.encodedScAddress;
            byte[] byArray2 = submitPdu.encodedMessage;
            this.sendRawPdu(byArray, byArray2, pendingIntent, pendingIntent2);
            return;
        }
        if (pendingIntent != null) {
            int n = 4;
            try {
                pendingIntent.send(n);
            }
            catch (PendingIntent.CanceledException canceledException) {}
        }
        int n = Log.d(TAG, "Block SMS in Emergency Callback mode");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, string4, bl, null);
        this.sendSubmitPdu(submitPdu, pendingIntent, pendingIntent2);
    }

    @Override
    protected void setCellBroadcastConfig(int[] nArray, Message message) {
        this.mCm.setCdmaBroadcastConfig(nArray, message);
    }
}

