/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.RuimRecords;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class CdmaServiceStateTracker
extends ServiceStateTracker {
    static final String LOG_TAG = "CDMA";
    private static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
    private static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    private RegistrantList cdmaDataConnectionAttachedRegistrants;
    private RegistrantList cdmaDataConnectionDetachedRegistrants;
    private int cdmaDataConnectionState;
    private RegistrantList cdmaForSubscriptionInfoReadyRegistrants;
    CdmaCellLocation cellLoc;
    private ContentResolver cr;
    private String curPlmn;
    private String curSpn;
    private int curSpnRule;
    private String currentCarrier;
    private boolean isEriTextLoaded;
    private boolean isSubscriptionFromRuim;
    private ContentObserver mAutoTimeObserver;
    private boolean mCdmaRoaming;
    private int mDefaultRoamingIndicator;
    private boolean mGotCountryCode;
    private int[] mHomeNetworkId;
    private int[] mHomeSystemId;
    private boolean mIsInPrl;
    private boolean mIsMinInfoReady;
    private String mMdn;
    private String mMin;
    private boolean mNeedFixZone;
    private boolean mNeedToRegForRuimLoaded;
    private int mNitzUpdateDiff;
    private int mNitzUpdateSpacing;
    private boolean mPendingRadioPowerOffAfterDataOff;
    private String mPrlVersion;
    private String mRegistrationDeniedReason;
    private int mRegistrationState;
    private int mRoamingIndicator;
    long mSavedAtTime;
    long mSavedTime;
    String mSavedTimeZone;
    private PowerManager.WakeLock mWakeLock;
    private boolean mZoneDst;
    private int mZoneOffset;
    private long mZoneTime;
    private int networkType;
    private int newCdmaDataConnectionState;
    CdmaCellLocation newCellLoc;
    private int newNetworkType;
    CDMAPhone phone;

    /*
     * Enabled aggressive block sorting
     */
    public CdmaServiceStateTracker(CDMAPhone cDMAPhone) {
        PowerManager.WakeLock wakeLock;
        SignalStrength signalStrength;
        CdmaCellLocation cdmaCellLocation;
        CdmaCellLocation cdmaCellLocation2;
        ServiceState serviceState;
        ServiceState serviceState2;
        CommandsInterface commandsInterface;
        ContentResolver contentResolver;
        ContentObserver contentObserver;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        int n;
        int n2;
        this.mNitzUpdateSpacing = n2 = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
        this.mNitzUpdateDiff = n = SystemProperties.getInt("ro.nitz_update_diff", 2000);
        this.networkType = 0;
        this.newNetworkType = 0;
        this.mCdmaRoaming = false;
        this.cdmaDataConnectionState = 1;
        this.newCdmaDataConnectionState = 1;
        this.mRegistrationState = -1;
        this.cdmaDataConnectionAttachedRegistrants = registrantList3 = new RegistrantList();
        this.cdmaDataConnectionDetachedRegistrants = registrantList2 = new RegistrantList();
        this.cdmaForSubscriptionInfoReadyRegistrants = registrantList = new RegistrantList();
        this.mNeedFixZone = false;
        this.mGotCountryCode = false;
        this.mNeedToRegForRuimLoaded = false;
        this.curSpn = null;
        this.curSpnRule = 0;
        this.curPlmn = null;
        this.mHomeSystemId = null;
        this.mHomeNetworkId = null;
        this.mIsMinInfoReady = false;
        this.isEriTextLoaded = false;
        this.isSubscriptionFromRuim = false;
        this.mPendingRadioPowerOffAfterDataOff = false;
        this.currentCarrier = null;
        Handler handler = new Handler();
        this.mAutoTimeObserver = contentObserver = new ContentObserver(handler){

            @Override
            public void onChange(boolean bl) {
                int n = Log.i("CdmaServiceStateTracker", "Auto time state called ...");
                CdmaServiceStateTracker.this.revertToNitz();
            }
        };
        this.phone = cDMAPhone;
        this.cr = contentResolver = cDMAPhone.getContext().getContentResolver();
        this.cm = commandsInterface = cDMAPhone.mCM;
        this.ss = serviceState2 = new ServiceState();
        this.newSS = serviceState = new ServiceState();
        this.cellLoc = cdmaCellLocation2 = new CdmaCellLocation();
        this.newCellLoc = cdmaCellLocation = new CdmaCellLocation();
        this.mSignalStrength = signalStrength = new SignalStrength();
        this.mWakeLock = wakeLock = ((PowerManager)cDMAPhone.getContext().getSystemService("power")).newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForNetworkStateChanged(this, 30, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.registerForRUIMReady(this, 26, null);
        this.cm.registerForNVReady(this, 35, null);
        cDMAPhone.registerForEriFileLoaded(this, 36, null);
        this.cm.registerForCdmaOtaProvision(this, 37, null);
        boolean bl = Settings.System.getInt(this.cr, "airplane_mode_on", 0) <= 0;
        this.mDesiredPowerState = bl;
        ContentResolver contentResolver2 = this.cr;
        Uri uri = Settings.System.getUriFor("auto_time");
        ContentObserver contentObserver2 = this.mAutoTimeObserver;
        contentResolver2.registerContentObserver(uri, true, contentObserver2);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForRuimLoaded = true;
    }

    private TimeZone findTimeZone(int n, boolean bl, long l) {
        int n2 = n;
        if (bl) {
            n2 -= 3600000;
        }
        String[] stringArray = TimeZone.getAvailableIDs(n2);
        TimeZone timeZone = null;
        Date date = new Date(l);
        String[] stringArray2 = stringArray;
        int n3 = stringArray2.length;
        int n4 = 0;
        while (true) {
            block6: {
                block5: {
                    if (n4 >= n3) break block5;
                    TimeZone timeZone2 = TimeZone.getTimeZone(stringArray2[n4]);
                    if (timeZone2.getOffset(l) == n || timeZone2.inDaylightTime(date) == bl) break block6;
                    timeZone = timeZone2;
                }
                return timeZone;
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixTimeZone(String string2) {
        TimeZone timeZone;
        String string3 = SystemProperties.get("persist.sys.timezone");
        if (this.mZoneOffset == 0 && !this.mZoneDst && string3 != null && string3.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, string2) < 0) {
            timeZone = TimeZone.getDefault();
            long l = System.currentTimeMillis();
            long l2 = timeZone.getOffset(l);
            if (this.getAutoTime()) {
                long l3 = System.currentTimeMillis() - l2;
                this.setAndBroadcastNetworkSetTime(l3);
            } else {
                long l4;
                this.mSavedTime = l4 = this.mSavedTime - l2;
            }
        } else if (string2.equals("")) {
            int n = this.mZoneOffset;
            boolean bl = this.mZoneDst;
            long l = this.mZoneTime;
            timeZone = this.getNitzTimeZone(n, bl, l);
        } else {
            int n = this.mZoneOffset;
            boolean bl = this.mZoneDst;
            long l = this.mZoneTime;
            timeZone = TimeUtils.getTimeZone(n, bl, l, string2);
        }
        this.mNeedFixZone = false;
        if (timeZone == null) {
            return;
        }
        if (this.getAutoTime()) {
            String string4 = timeZone.getID();
            this.setAndBroadcastNetworkSetTimeZone(string4);
        }
        String string5 = timeZone.getID();
        this.saveNitzTimeZone(string5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getAutoTime() {
        try {
            int n = Settings.System.getInt(this.cr, "auto_time");
            if (n <= 0) return false;
            return true;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TimeZone getNitzTimeZone(int n, boolean bl, long l) {
        TimeZone timeZone = this.findTimeZone(n, bl, l);
        if (timeZone == null) {
            boolean bl2 = !bl;
            timeZone = this.findTimeZone(n, bl2, l);
        }
        StringBuilder stringBuilder = new StringBuilder().append("getNitzTimeZone returning ");
        Object object = timeZone == null ? timeZone : timeZone.getID();
        String string2 = stringBuilder.append(object).toString();
        this.log(string2);
        return timeZone;
    }

    private void hangupAndPowerOff() {
        this.phone.mCT.ringingCall.hangupIfAlive();
        this.phone.mCT.backgroundCall.hangupIfAlive();
        this.phone.mCT.foregroundCall.hangupIfAlive();
        this.cm.setRadioPower(false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHomeSid(int n) {
        int n2;
        if (this.mHomeSystemId == null) return false;
        int n3 = 0;
        while (n3 < (n2 = this.mHomeSystemId.length)) {
            int n4 = this.mHomeSystemId[n3];
            if (n != n4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRoamIndForHomeSystem(String string2) {
        String string3 = SystemProperties.get("ro.cdma.homesystem");
        if (TextUtils.isEmpty(string3)) return false;
        String[] stringArray = string3.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isRoamingBetweenOperators(boolean bl, ServiceState serviceState) {
        String string2 = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String string3 = serviceState.getOperatorAlphaLong();
        String string4 = serviceState.getOperatorAlphaShort();
        boolean bl2 = string3 != null && string2.equals(string3);
        boolean bl3 = string4 != null && string2.equals(string4);
        if (!bl) return false;
        if (bl2) return false;
        if (bl3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSidsAllZeros() {
        int n;
        if (this.mHomeSystemId == null) return true;
        int n2 = 0;
        while (n2 < (n = this.mHomeSystemId.length)) {
            if (this.mHomeSystemId[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String networkTypeToString(int n) {
        String string2 = "unknown";
        switch (n) {
            default: {
                int n2 = Log.e(LOG_TAG, "Wrong network. Can not return a string.");
                return string2;
            }
            case 4: 
            case 5: {
                return LOG_TAG;
            }
            case 6: {
                return "CDMA - 1xRTT";
            }
            case 7: {
                return "CDMA - EvDo rev. 0";
            }
            case 8: {
                return "CDMA - EvDo rev. A";
            }
            case 12: 
        }
        return "CDMA - EvDo rev. B";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSignalStrengthResult(AsyncResult asyncResult) {
        SignalStrength signalStrength = this.mSignalStrength;
        if (asyncResult.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            SignalStrength signalStrength2;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int[] nArray = (int[])asyncResult.result;
            int n9 = 2;
            int n10 = nArray[n9] > 0 ? -nArray[n9] : 65416;
            int n11 = n9 + 1;
            if (nArray[n11] > 0) {
                int n12 = n9 + 1;
                n8 = -nArray[n12];
            } else {
                n8 = 65376;
            }
            if (nArray[n7 = n9 + 2] > 0) {
                int n13 = n9 + 2;
                n6 = -nArray[n13];
            } else {
                n6 = 65416;
            }
            if (nArray[n5 = n9 + 3] > 0) {
                int n14 = n9 + 3;
                n4 = -nArray[n14];
            } else {
                n4 = -1;
            }
            if (nArray[n3 = n9 + 4] > 0 && nArray[n2 = n9 + 4] <= 8) {
                int n15 = n9 + 4;
                n = nArray[n15];
            } else {
                n = -1;
            }
            this.mSignalStrength = signalStrength2 = new SignalStrength(99, -1, n10, n8, n6, n4, n, false);
        }
        try {
            this.phone.notifySignalStrength();
            return;
        }
        catch (NullPointerException nullPointerException) {
            String string2 = "onSignalStrengthResult() Phone already destroyed: " + nullPointerException + "SignalStrength not notified";
            this.log(string2);
            return;
        }
    }

    private void pollState() {
        int[] nArray = new int[1];
        this.pollingContext = nArray;
        this.pollingContext[0] = 0;
        int[] nArray2 = 2.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState;
        int n = this.cm.getRadioState().ordinal();
        switch (nArray2[n]) {
            default: {
                int n2;
                int n3;
                int[] nArray3 = this.pollingContext;
                nArray3[0] = n3 = nArray3[0] + 1;
                CommandsInterface commandsInterface = this.cm;
                int[] nArray4 = this.pollingContext;
                Message message = this.obtainMessage(25, nArray4);
                commandsInterface.getOperator(message);
                int[] nArray5 = this.pollingContext;
                nArray5[0] = n2 = nArray5[0] + 1;
                CommandsInterface commandsInterface2 = this.cm;
                int[] nArray6 = this.pollingContext;
                Message message2 = this.obtainMessage(24, nArray6);
                commandsInterface2.getRegistrationState(message2);
                return;
            }
            case 1: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 2: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 3: 
            case 4: 
            case 5: 
        }
        this.log("Radio Technology Change ongoing, setting SS to off");
        this.newSS.setStateOff();
        this.newCellLoc.setStateInvalid();
        this.setSignalStrengthDefaultValues();
        this.mGotCountryCode = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pollStateDone() {
        int n;
        int n2;
        CdmaCellLocation cdmaCellLocation;
        CdmaCellLocation cdmaCellLocation2;
        ServiceState serviceState;
        ServiceState serviceState2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        StringBuilder stringBuilder = new StringBuilder().append("Poll ServiceState done: oldSS=[");
        ServiceState serviceState3 = this.ss;
        StringBuilder stringBuilder2 = stringBuilder.append(serviceState3).append("] newSS=[");
        ServiceState serviceState4 = this.newSS;
        String string2 = stringBuilder2.append(serviceState4).append("]").toString();
        CdmaServiceStateTracker cdmaServiceStateTracker = this;
        String string3 = string2;
        cdmaServiceStateTracker.log(string3);
        boolean bl = this.ss.getState() != 0 && this.newSS.getState() == 0;
        if (this.ss.getState() == 0 && this.newSS.getState() != 0) {
            boolean bl2 = true;
        } else {
            boolean bl3 = false;
        }
        boolean bl4 = this.cdmaDataConnectionState != 0 && this.newCdmaDataConnectionState == 0;
        boolean bl5 = this.cdmaDataConnectionState == 0 && this.newCdmaDataConnectionState != 0;
        int n9 = this.cdmaDataConnectionState;
        int n10 = n9;
        int n11 = this.newCdmaDataConnectionState;
        int n12 = n11;
        boolean bl6 = n10 != n12;
        int n13 = this.networkType;
        int n14 = n13;
        int n15 = this.newNetworkType;
        int n16 = n15;
        boolean bl7 = n14 != n16;
        ServiceState serviceState5 = this.newSS;
        ServiceState serviceState6 = this.ss;
        boolean bl8 = !serviceState5.equals(serviceState6);
        boolean bl9 = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean bl10 = this.ss.getRoaming() && !this.newSS.getRoaming();
        CdmaCellLocation cdmaCellLocation3 = this.newCellLoc;
        CdmaCellLocation cdmaCellLocation4 = this.cellLoc;
        boolean bl11 = !cdmaCellLocation3.equals(cdmaCellLocation4);
        int n17 = this.ss.getState();
        int n18 = n17;
        if (n18 == (n8 = (n7 = this.newSS.getState())) || (n6 = (n5 = this.cdmaDataConnectionState)) != (n4 = (n3 = this.newCdmaDataConnectionState))) {
            Object[] objectArray = new Object[4];
            Integer n19 = this.ss.getState();
            objectArray[0] = n19;
            Integer n20 = this.cdmaDataConnectionState;
            objectArray[1] = n20;
            Integer n21 = this.newSS.getState();
            objectArray[2] = n21;
            Integer n22 = this.newCdmaDataConnectionState;
            objectArray[3] = n22;
            int n23 = EventLog.writeEvent(50116, objectArray);
        }
        ServiceState serviceState7 = this.ss;
        this.ss = serviceState2 = this.newSS;
        this.newSS = serviceState = serviceState7;
        this.newSS.setStateOutOfService();
        CdmaCellLocation cdmaCellLocation5 = this.cellLoc;
        this.cellLoc = cdmaCellLocation2 = this.newCellLoc;
        this.newCellLoc = cdmaCellLocation = cdmaCellLocation5;
        this.cdmaDataConnectionState = n2 = this.newCdmaDataConnectionState;
        this.networkType = n = this.newNetworkType;
        this.newSS.setStateOutOfService();
        if (bl7) {
            CDMAPhone cDMAPhone = this.phone;
            String string4 = CdmaServiceStateTracker.networkTypeToString(this.networkType);
            cDMAPhone.setSystemProperty("gsm.network.type", string4);
        }
        if (bl) {
            this.networkAttachedRegistrants.notifyRegistrants();
        }
        if (bl8) {
            if (this.cm.getRadioState().isNVReady()) {
                String string5 = this.ss.getState() == 0 ? this.phone.getCdmaEriText() : ((Object)this.phone.getContext().getText(17039602)).toString();
                ServiceState serviceState8 = this.ss;
                String string6 = string5;
                serviceState8.setCdmaEriText(string6);
            }
            CDMAPhone cDMAPhone = this.phone;
            String string7 = this.ss.getOperatorAlphaLong();
            cDMAPhone.setSystemProperty("gsm.operator.alpha", string7);
            String string8 = this.ss.getOperatorNumeric();
            CDMAPhone cDMAPhone2 = this.phone;
            String string9 = "gsm.operator.numeric";
            String string10 = string8;
            cDMAPhone2.setSystemProperty(string9, string10);
            if (string8 == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
            } else {
                boolean bl12;
                String string11 = "";
                int n24 = 0;
                int n25 = 3;
                try {
                    String string12;
                    String string13 = string8;
                    int n26 = n24;
                    int n27 = n25;
                    string11 = string12 = MccTable.countryCodeForMcc(Integer.parseInt(string13.substring(n26, n27)));
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder3 = new StringBuilder().append("countryCodeForMcc error");
                    NumberFormatException numberFormatException2 = numberFormatException;
                    String string14 = stringBuilder3.append(numberFormatException2).toString();
                    int n28 = Log.w(LOG_TAG, string14);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    StringBuilder stringBuilder4 = new StringBuilder().append("countryCodeForMcc error");
                    StringIndexOutOfBoundsException stringIndexOutOfBoundsException2 = stringIndexOutOfBoundsException;
                    String string15 = stringBuilder4.append(stringIndexOutOfBoundsException2).toString();
                    int n29 = Log.w(LOG_TAG, string15);
                }
                CDMAPhone cDMAPhone3 = this.phone;
                String string16 = "gsm.operator.iso-country";
                String string17 = string11;
                cDMAPhone3.setSystemProperty(string16, string17);
                this.mGotCountryCode = bl12 = true;
                if (this.mNeedFixZone) {
                    CdmaServiceStateTracker cdmaServiceStateTracker2 = this;
                    String string18 = string11;
                    cdmaServiceStateTracker2.fixTimeZone(string18);
                }
            }
            CDMAPhone cDMAPhone4 = this.phone;
            String string19 = "gsm.operator.isroaming";
            String string20 = this.ss.getRoaming() ? "true" : "false";
            cDMAPhone4.setSystemProperty(string19, string20);
            this.updateSpnDisplay();
            CDMAPhone cDMAPhone5 = this.phone;
            ServiceState serviceState9 = this.ss;
            cDMAPhone5.notifyServiceStateChanged(serviceState9);
        }
        if (bl4) {
            this.cdmaDataConnectionAttachedRegistrants.notifyRegistrants();
        }
        if (bl5) {
            this.cdmaDataConnectionDetachedRegistrants.notifyRegistrants();
        }
        if (bl6 || bl7) {
            this.phone.notifyDataConnection(null);
        }
        if (bl9) {
            this.roamingOnRegistrants.notifyRegistrants();
        }
        if (bl10) {
            this.roamingOffRegistrants.notifyRegistrants();
        }
        if (!bl11) {
            return;
        }
        this.phone.notifyLocationChanged();
    }

    private void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength) {
            return;
        }
        if (this.cm.getRadioState().isGsm()) {
            return;
        }
        Message message = this.obtainMessage();
        message.what = 10;
        boolean bl = this.sendMessageDelayed(message, 20000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int radioTechnologyToDataServiceState(int n) {
        int n2 = 1;
        switch (n) {
            default: {
                int n3 = Log.e(LOG_TAG, "Wrong radioTechnology code.");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return n2;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean regCodeIsRoaming(int n) {
        if (5 == n) return false;
        return true;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private int regCodeToServiceState(int n) {
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        block5: do {
            switch (n3 == Integer.MIN_VALUE ? n : n3) {
                default: {
                    String string2 = "unexpected service state " + n;
                    int n4 = Log.w(LOG_TAG, string2);
                    n2 = 1;
                    n3 = 1;
                    continue block5;
                }
                case 0: {
                    n2 = 1;
                }
                case 1: 
                case 5: {
                    return n2;
                }
                case 2: 
                case 3: 
                case 4: 
            }
            return 1;
        } while (true);
        return 1;
    }

    private void revertToNitz() {
        if (Settings.System.getInt(this.cr, "auto_time", 0) == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Reverting to NITZ: tz='");
        String string2 = this.mSavedTimeZone;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("' mSavedTime=");
        long l = this.mSavedTime;
        StringBuilder stringBuilder3 = stringBuilder2.append(l).append(" mSavedAtTime=");
        long l2 = this.mSavedAtTime;
        String string3 = stringBuilder3.append(l2).toString();
        int n = Log.d(LOG_TAG, string3);
        if (this.mSavedTimeZone == null) {
            return;
        }
        if (this.mSavedTime == 0L) {
            return;
        }
        if (this.mSavedAtTime == 0L) {
            return;
        }
        String string4 = this.mSavedTimeZone;
        this.setAndBroadcastNetworkSetTimeZone(string4);
        long l3 = this.mSavedTime;
        long l4 = SystemClock.elapsedRealtime();
        long l5 = this.mSavedAtTime;
        long l6 = l4 - l5;
        long l7 = l3 + l6;
        this.setAndBroadcastNetworkSetTime(l7);
    }

    private void saveNitzTimeZone(String string2) {
        this.mSavedTimeZone = string2;
    }

    private void setAndBroadcastNetworkSetTime(long l) {
        boolean bl = SystemClock.setCurrentTimeMillis(l);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        Intent intent2 = intent.addFlags(0x20000000);
        Intent intent3 = intent.putExtra("time", l);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setAndBroadcastNetworkSetTimeZone(String string2) {
        ((AlarmManager)this.phone.getContext().getSystemService("alarm")).setTimeZone(string2);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        Intent intent2 = intent.addFlags(0x20000000);
        Intent intent3 = intent.putExtra("time-zone", string2);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setSignalStrengthDefaultValues() {
        SignalStrength signalStrength;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        this.mSignalStrength = signalStrength = new SignalStrength(99, -1, n, n2, n3, n4, n5, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeFromNITZString(String string2, long l) {
        long l2;
        long l3;
        long l4;
        block22: {
            long l5;
            long l6;
            long l7;
            char n;
            Calendar calendar;
            block21: {
                block20: {
                    l4 = SystemClock.elapsedRealtime();
                    StringBuilder stringBuilder = new StringBuilder().append("NITZ: ");
                    String string3 = string2;
                    StringBuilder stringBuilder2 = stringBuilder.append(string3).append(",");
                    long l8 = l;
                    StringBuilder stringBuilder3 = stringBuilder2.append(l8).append(" start=");
                    long l9 = l4;
                    StringBuilder stringBuilder4 = stringBuilder3.append(l9).append(" delay=");
                    long l10 = l4 - l;
                    String string4 = stringBuilder4.append(l10).toString();
                    int n2 = Log.i(LOG_TAG, string4);
                    try {
                        String string5;
                        String string6;
                        String string7;
                        calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        calendar.clear();
                        Calendar calendar2 = calendar;
                        int n3 = 16;
                        int n4 = 0;
                        calendar2.set(n3, n4);
                        String string8 = string2;
                        String string9 = "[/:,+-]";
                        String[] stringArray = string8.split(string9);
                        int n5 = Integer.parseInt(stringArray[0]) + 2000;
                        Calendar calendar3 = calendar;
                        int n6 = 1;
                        int n7 = n5;
                        calendar3.set(n6, n7);
                        int n8 = Integer.parseInt(stringArray[1]) - 1;
                        Calendar calendar4 = calendar;
                        int n9 = 2;
                        int n10 = n8;
                        calendar4.set(n9, n10);
                        int n11 = Integer.parseInt(stringArray[2]);
                        Calendar calendar5 = calendar;
                        int n12 = 5;
                        int n13 = n11;
                        calendar5.set(n12, n13);
                        int n14 = Integer.parseInt(stringArray[3]);
                        Calendar calendar6 = calendar;
                        int n15 = 10;
                        int n16 = n14;
                        calendar6.set(n15, n16);
                        int n17 = Integer.parseInt(stringArray[4]);
                        Calendar calendar7 = calendar;
                        int n18 = 12;
                        int n19 = n17;
                        calendar7.set(n18, n19);
                        int n20 = Integer.parseInt(stringArray[5]);
                        Calendar calendar8 = calendar;
                        int n21 = 13;
                        int n22 = n20;
                        calendar8.set(n21, n22);
                        String string10 = string2;
                        int n23 = 45;
                        int n24 = string10.indexOf(n23);
                        n21 = 65535;
                        n22 = n24 == n21 ? 1 : 0;
                        int n25 = Integer.parseInt(stringArray[6]);
                        int n26 = stringArray.length;
                        int n27 = 8;
                        int n28 = n26 >= n27 ? Integer.parseInt(stringArray[7]) : 0;
                        n = n22 != 0 ? '\u0001' : '\uffff';
                        n25 = n * n25 * 15 * 60 * 1000;
                        TimeZone timeZone = null;
                        int n29 = stringArray.length;
                        int n30 = 9;
                        if (n29 >= n30) {
                            timeZone = TimeZone.getTimeZone(stringArray[8].replace('!', '/'));
                        }
                        String string11 = SystemProperties.get("gsm.operator.iso-country");
                        if (timeZone == null && this.mGotCountryCode) {
                            if (string11 != null && string11.length() > 0) {
                                n = n28 != 0 ? '\u0001' : '\u0000';
                                long l11 = calendar.getTimeInMillis();
                                int n31 = n25;
                                char n32 = n;
                                long l12 = l11;
                                String string12 = string11;
                                timeZone = TimeUtils.getTimeZone(n31, n32 != '\u0000', l12, string12);
                            } else {
                                TimeZone timeZone2;
                                n = n28 != 0 ? '\u0001' : '\u0000';
                                long l13 = calendar.getTimeInMillis();
                                CdmaServiceStateTracker cdmaServiceStateTracker = this;
                                int n33 = n25;
                                char n34 = n;
                                long l14 = l13;
                                timeZone = timeZone2 = cdmaServiceStateTracker.getNitzTimeZone(n33, n34 != '\u0000', l14);
                            }
                        }
                        if (timeZone == null) {
                            long l15;
                            int n35;
                            boolean bl;
                            this.mNeedFixZone = bl = true;
                            this.mZoneOffset = n35 = n25;
                            n = n28 != 0 ? '\u0001' : '\u0000';
                            char n36 = n;
                            this.mZoneDst = n36;
                            this.mZoneTime = l15 = calendar.getTimeInMillis();
                        }
                        if (timeZone != null) {
                            if (this.getAutoTime()) {
                                String string13 = timeZone.getID();
                                CdmaServiceStateTracker cdmaServiceStateTracker = this;
                                String string14 = string13;
                                cdmaServiceStateTracker.setAndBroadcastNetworkSetTimeZone(string14);
                            }
                            String string15 = timeZone.getID();
                            CdmaServiceStateTracker cdmaServiceStateTracker = this;
                            String string16 = string15;
                            cdmaServiceStateTracker.saveNitzTimeZone(string16);
                        }
                        if ((string7 = SystemProperties.get("gsm.ignore-nitz")) == null || !(string6 = string7).equals(string5 = "yes")) break block20;
                        int n37 = Log.i(LOG_TAG, "NITZ: Not setting clock because gsm.ignore-nitz is set");
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        StringBuilder stringBuilder5 = new StringBuilder().append("NITZ: Parsing NITZ time ");
                        String string17 = string2;
                        String string18 = stringBuilder5.append(string17).toString();
                        String string19 = LOG_TAG;
                        String string20 = string18;
                        RuntimeException runtimeException2 = runtimeException;
                        int n38 = Log.e(string19, string20, runtimeException2);
                        return;
                    }
                }
                this.mWakeLock.acquire();
                l7 = SystemClock.elapsedRealtime() - l;
                if (l7 >= 0L) break block21;
                StringBuilder stringBuilder = new StringBuilder().append("NITZ: not setting time, clock has rolled backwards since NITZ time was received, ");
                String string21 = string2;
                String string22 = stringBuilder.append(string21).toString();
                int n39 = Log.i(LOG_TAG, string22);
                long l16 = SystemClock.elapsedRealtime();
                StringBuilder stringBuilder6 = new StringBuilder().append("NITZ: end=");
                long l17 = l16;
                StringBuilder stringBuilder7 = stringBuilder6.append(l17).append(" dur=");
                long l18 = l16 - l4;
                String string23 = stringBuilder7.append(l18).toString();
                int n40 = Log.i(LOG_TAG, string23);
                this.mWakeLock.release();
                return;
            }
            if (l7 > Integer.MAX_VALUE) {
                StringBuilder stringBuilder = new StringBuilder().append("NITZ: not setting time, processing has taken ");
                long l19 = l7 / 86400000L;
                String string24 = stringBuilder.append(l19).append(" days").toString();
                int n41 = Log.i(LOG_TAG, string24);
                long l20 = SystemClock.elapsedRealtime();
                StringBuilder stringBuilder8 = new StringBuilder().append("NITZ: end=");
                long l21 = l20;
                StringBuilder stringBuilder9 = stringBuilder8.append(l21).append(" dur=");
                long l22 = l20 - l4;
                String string25 = stringBuilder9.append(l22).toString();
                int n42 = Log.i(LOG_TAG, string25);
                this.mWakeLock.release();
                return;
            }
            n = '\u000e';
            int n43 = (int)l7;
            Calendar calendar9 = calendar;
            char n44 = n;
            int n45 = n43;
            calendar9.add(n44, n45);
            if (this.getAutoTime()) {
                long l23;
                long l24;
                long l25;
                long l26 = calendar.getTimeInMillis();
                long l27 = System.currentTimeMillis();
                l3 = l26 - l27;
                long l28 = SystemClock.elapsedRealtime();
                long l29 = this.mSavedAtTime;
                l2 = l28 - l29;
                ContentResolver contentResolver = this.cr;
                int n46 = this.mNitzUpdateSpacing;
                int n47 = Settings.Secure.getInt(contentResolver, "nitz_update_spacing", n46);
                ContentResolver contentResolver2 = this.cr;
                int n48 = this.mNitzUpdateDiff;
                int n49 = Settings.Secure.getInt(contentResolver2, "nitz_update_diff", n48);
                if (this.mSavedAtTime != 0L && l2 <= (l25 = (long)n47) && (l24 = Math.abs(l3)) <= (l23 = (long)n49)) break block22;
                StringBuilder stringBuilder = new StringBuilder().append("NITZ: Auto updating time of day to ");
                Date date = calendar.getTime();
                StringBuilder stringBuilder10 = stringBuilder.append(date).append(" NITZ receive delay=");
                long l30 = l7;
                StringBuilder stringBuilder11 = stringBuilder10.append(l30).append("ms gained=");
                long l31 = l3;
                StringBuilder stringBuilder12 = stringBuilder11.append(l31).append("ms from ");
                String string26 = string2;
                String string27 = stringBuilder12.append(string26).toString();
                int n50 = Log.i(LOG_TAG, string27);
                long l32 = calendar.getTimeInMillis();
                CdmaServiceStateTracker cdmaServiceStateTracker = this;
                long l33 = l32;
                cdmaServiceStateTracker.setAndBroadcastNetworkSetTime(l33);
            }
            int n51 = Log.i(LOG_TAG, "NITZ: update nitz time property");
            String string28 = String.valueOf(calendar.getTimeInMillis());
            SystemProperties.set("gsm.nitz.time", string28);
            this.mSavedTime = l6 = calendar.getTimeInMillis();
            this.mSavedAtTime = l5 = SystemClock.elapsedRealtime();
            long l34 = SystemClock.elapsedRealtime();
            StringBuilder stringBuilder = new StringBuilder().append("NITZ: end=");
            long l35 = l34;
            StringBuilder stringBuilder13 = stringBuilder.append(l35).append(" dur=");
            long l36 = l34 - l4;
            String string29 = stringBuilder13.append(l36).toString();
            int n52 = Log.i(LOG_TAG, string29);
            this.mWakeLock.release();
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder().append("NITZ: ignore, a previous update was ");
            long l37 = l2;
            StringBuilder stringBuilder14 = stringBuilder.append(l37).append("ms ago and gained=");
            long l38 = l3;
            String string30 = stringBuilder14.append(l38).append("ms").toString();
            int n = Log.i(LOG_TAG, string30);
        }
        catch (Throwable throwable) {
            long l39 = SystemClock.elapsedRealtime();
            StringBuilder stringBuilder = new StringBuilder().append("NITZ: end=");
            long l40 = l39;
            StringBuilder stringBuilder15 = stringBuilder.append(l40).append(" dur=");
            long l41 = l39 - l4;
            String string31 = stringBuilder15.append(l41).toString();
            int n = Log.i(LOG_TAG, string31);
            this.mWakeLock.release();
            throw throwable;
        }
        long l42 = SystemClock.elapsedRealtime();
        StringBuilder stringBuilder = new StringBuilder().append("NITZ: end=");
        long l43 = l42;
        StringBuilder stringBuilder16 = stringBuilder.append(l43).append(" dur=");
        long l44 = l42 - l4;
        String string32 = stringBuilder16.append(l44).toString();
        int n = Log.i(LOG_TAG, string32);
        this.mWakeLock.release();
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForNetworkStateChanged(this);
        this.cm.unregisterForRUIMReady(this);
        this.cm.unregisterForNVReady(this);
        this.cm.unregisterForCdmaOtaProvision(this);
        this.phone.unregisterForEriFileLoaded(this);
        this.phone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnNITZTime(this);
        ContentResolver contentResolver = this.cr;
        ContentObserver contentObserver = this.mAutoTimeObserver;
        contentResolver.unregisterContentObserver(contentObserver);
    }

    protected void finalize() {
        this.log("CdmaServiceStateTracker finalized");
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    int getCurrentCdmaDataConnectionState() {
        return this.cdmaDataConnectionState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getImsi() {
        String string2 = SystemProperties.get("gsm.sim.operator.numeric", "");
        if (TextUtils.isEmpty(string2)) return null;
        if (this.getCdmaMin() == null) return null;
        StringBuilder stringBuilder = new StringBuilder().append(string2);
        String string3 = this.getCdmaMin();
        return stringBuilder.append(string3).toString();
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        String string2;
        String string3;
        int n;
        String[] stringArray;
        block52: {
            int n2;
            String[] stringArray2;
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unhandled message with number: ");
                    int n3 = message.what;
                    String string4 = stringBuilder.append(n3).toString();
                    int n4 = Log.e(LOG_TAG, string4);
                }
                case 13: {
                    return;
                }
                case 26: {
                    boolean bl;
                    this.isSubscriptionFromRuim = bl = true;
                    if (this.mNeedToRegForRuimLoaded) {
                        boolean bl2;
                        RuimRecords ruimRecords = this.phone.mRuimRecords;
                        CdmaServiceStateTracker cdmaServiceStateTracker = this;
                        int n5 = 27;
                        Object var10_10 = null;
                        ruimRecords.registerForRecordsLoaded(cdmaServiceStateTracker, n5, var10_10);
                        this.mNeedToRegForRuimLoaded = bl2 = false;
                    }
                    CommandsInterface commandsInterface = this.cm;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    int n6 = 34;
                    Message message2 = cdmaServiceStateTracker.obtainMessage(n6);
                    commandsInterface.getCDMASubscription(message2);
                    CdmaServiceStateTracker cdmaServiceStateTracker2 = this;
                    String string5 = "Receive EVENT_RUIM_READY and Send Request getCDMASubscription.";
                    cdmaServiceStateTracker2.log(string5);
                    this.pollState();
                    this.queueNextSignalStrengthPoll();
                    return;
                }
                case 35: {
                    boolean bl;
                    this.isSubscriptionFromRuim = bl = false;
                    CommandsInterface commandsInterface = this.cm;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    int n7 = 34;
                    Message message3 = cdmaServiceStateTracker.obtainMessage(n7);
                    commandsInterface.getCDMASubscription(message3);
                    this.pollState();
                    this.queueNextSignalStrengthPoll();
                    return;
                }
                case 1: {
                    this.setPowerStateToDesired();
                    this.pollState();
                    return;
                }
                case 30: {
                    this.pollState();
                    return;
                }
                case 3: {
                    if (!this.cm.getRadioState().isOn()) {
                        return;
                    }
                    if (this.cm.getRadioState().isGsm()) {
                        return;
                    }
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    AsyncResult asyncResult2 = asyncResult;
                    cdmaServiceStateTracker.onSignalStrengthResult(asyncResult2);
                    this.queueNextSignalStrengthPoll();
                    return;
                }
                case 31: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception == null) {
                        String[] stringArray3 = (String[])asyncResult.result;
                        int n8 = -1;
                        int n9 = Integer.MAX_VALUE;
                        int n10 = Integer.MAX_VALUE;
                        int n11 = -1;
                        int n12 = -1;
                        if (stringArray3.length > 9) {
                            int n13 = 4;
                            try {
                                if (stringArray3[n13] != null) {
                                    int n14 = Integer.parseInt(stringArray3[4]);
                                }
                                if (stringArray3[5] != null) {
                                    int n15 = Integer.parseInt(stringArray3[5]);
                                }
                                if (stringArray3[6] != null) {
                                    n10 = Integer.parseInt(stringArray3[6]);
                                }
                                if (n9 == 0 && n10 == 0) {
                                    n10 = Integer.MAX_VALUE;
                                }
                                if (stringArray3[8] != null) {
                                    n11 = Integer.parseInt(stringArray3[8]);
                                }
                                if (stringArray3[9] != null) {
                                    int n16;
                                    n12 = n16 = Integer.parseInt(stringArray3[9]);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                String string6 = "error parsing cell location data: " + numberFormatException;
                                int n17 = Log.w(LOG_TAG, string6);
                            }
                        }
                        this.cellLoc.setCellLocationData(n8, n9, n10, n11, n12);
                        this.phone.notifyLocationChanged();
                    }
                    this.disableSingleLocationUpdate();
                    return;
                }
                case 24: 
                case 25: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    int n18 = message.what;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    int n19 = n18;
                    AsyncResult asyncResult3 = asyncResult;
                    cdmaServiceStateTracker.handlePollStateResult(n19, asyncResult3);
                    return;
                }
                case 34: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception != null) {
                        return;
                    }
                    stringArray = (String[])asyncResult.result;
                    if (stringArray != null && stringArray.length >= 5) {
                        String string7;
                        this.mMdn = string7 = stringArray[0];
                        if (stringArray[1] != null) {
                            stringArray2 = stringArray[1].split(",");
                            int[] nArray = new int[stringArray2.length];
                            this.mHomeSystemId = nArray;
                            break;
                        }
                        break block52;
                    } else {
                        StringBuilder stringBuilder = new StringBuilder().append("error parsing cdmaSubscription params num=");
                        int n20 = stringArray.length;
                        String string8 = stringBuilder.append(n20).toString();
                        int n21 = Log.w(LOG_TAG, string8);
                        return;
                    }
                }
                case 10: {
                    CommandsInterface commandsInterface = this.cm;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    int n22 = 3;
                    Message message4 = cdmaServiceStateTracker.obtainMessage(n22);
                    commandsInterface.getSignalStrength(message4);
                    return;
                }
                case 11: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    String string9 = (String)((Object[])asyncResult.result)[0];
                    long l = (Long)((Object[])asyncResult.result)[1];
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    String string10 = string9;
                    long l2 = l;
                    cdmaServiceStateTracker.setTimeFromNITZString(string10, l2);
                    return;
                }
                case 12: {
                    boolean bl;
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    this.dontPollSignalStrength = bl = true;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    AsyncResult asyncResult4 = asyncResult;
                    cdmaServiceStateTracker.onSignalStrengthResult(asyncResult4);
                    return;
                }
                case 27: {
                    this.updateSpnDisplay();
                    return;
                }
                case 18: {
                    if (((AsyncResult)message.obj).exception != null) {
                        return;
                    }
                    CommandsInterface commandsInterface = this.cm;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    int n23 = 31;
                    Object var100_100 = null;
                    Message message5 = cdmaServiceStateTracker.obtainMessage(n23, var100_100);
                    commandsInterface.getRegistrationState(message5);
                    return;
                }
                case 36: {
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    String string11 = "[CdmaServiceStateTracker] ERI file has been loaded, repolling.";
                    cdmaServiceStateTracker.log(string11);
                    this.pollState();
                    return;
                }
                case 37: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception != null) {
                        return;
                    }
                    int n24 = ((int[])asyncResult.result)[0];
                    CDMAPhone cDMAPhone = this.phone;
                    int n25 = n24;
                    int n26 = 8;
                    if (n25 != n26) {
                        CDMAPhone cDMAPhone2 = this.phone;
                        int n27 = n24;
                        int n28 = 10;
                        if (n27 != n28) {
                            return;
                        }
                    }
                    int n29 = Log.d(LOG_TAG, "Received OTA_PROGRAMMING Complete,Reload MDN ");
                    CommandsInterface commandsInterface = this.cm;
                    CdmaServiceStateTracker cdmaServiceStateTracker = this;
                    int n30 = 34;
                    Message message6 = cdmaServiceStateTracker.obtainMessage(n30);
                    commandsInterface.getCDMASubscription(message6);
                    return;
                }
                case 38: {
                    synchronized (this) {
                        if (this.mPendingRadioPowerOffAfterDataOff) {
                            boolean bl;
                            CdmaServiceStateTracker cdmaServiceStateTracker = this;
                            String string12 = "EVENT_SET_RADIO_OFF, turn radio off now.";
                            cdmaServiceStateTracker.log(string12);
                            this.hangupAndPowerOff();
                            this.mPendingRadioPowerOffAfterDataOff = bl = false;
                        }
                        return;
                    }
                }
            }
            for (n = 0; n < (n2 = stringArray2.length); ++n) {
                try {
                    int n31;
                    int[] nArray = this.mHomeSystemId;
                    nArray[n] = n31 = Integer.parseInt(stringArray2[n]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    int n32 = Log.e(LOG_TAG, "error parsing system id: ", numberFormatException);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("GET_CDMA_SUBSCRIPTION SID=");
        String string13 = stringArray[1];
        String string14 = stringBuilder.append(string13).toString();
        int n33 = Log.d(LOG_TAG, string14);
        if (stringArray[2] != null) {
            int n34;
            String[] stringArray4 = stringArray[2].split(",");
            int[] nArray = new int[stringArray4.length];
            this.mHomeNetworkId = nArray;
            for (n = 0; n < (n34 = stringArray4.length); ++n) {
                try {
                    int n35;
                    int[] nArray2 = this.mHomeNetworkId;
                    nArray2[n] = n35 = Integer.parseInt(stringArray4[n]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    int n36 = Log.e(LOG_TAG, "error parsing network id: ", numberFormatException);
                }
            }
        }
        StringBuilder stringBuilder2 = new StringBuilder().append("GET_CDMA_SUBSCRIPTION NID=");
        String string15 = stringArray[2];
        String string16 = stringBuilder2.append(string15).toString();
        int n37 = Log.d(LOG_TAG, string16);
        this.mMin = string3 = stringArray[3];
        this.mPrlVersion = string2 = stringArray[4];
        StringBuilder stringBuilder3 = new StringBuilder().append("GET_CDMA_SUBSCRIPTION MDN=");
        String string17 = this.mMdn;
        String string18 = stringBuilder3.append(string17).toString();
        int n38 = Log.d(LOG_TAG, string18);
        if (this.cdmaForSubscriptionInfoReadyRegistrants != null) {
            this.cdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
        }
        if (!this.mIsMinInfoReady) {
            boolean bl;
            this.mIsMinInfoReady = bl = true;
        }
        this.phone.getIccCard().broadcastIccStateChangedIntent("IMSI", null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handlePollStateResult(int var1_1, AsyncResult var2_2) {
        block47: {
            block46: {
                var3_3 = var2_2.userObj;
                var4_4 = this.pollingContext;
                if (var3_3 != var4_4) {
                    return;
                }
                if (var2_2.exception == null) break block46;
                var5_5 = null;
                if (var2_2.exception instanceof CommandException) {
                    var5_5 = ((CommandException)var2_2.exception).getCommandError();
                }
                if (var5_5 == (var6_6 = CommandException.Error.RADIO_NOT_AVAILABLE)) {
                    this.cancelPollState();
                    return;
                }
                if (!this.cm.getRadioState().isOn()) {
                    this.cancelPollState();
                    return;
                }
                var7_7 = CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW;
                if (var5_5 != var7_7 && var5_5 != (var8_8 = CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW)) {
                    var9_9 = var2_2.exception;
                    var10_10 = Log.e("CDMA", "RIL implementation has returned an error where it must succeed", var9_9);
                }
                break block47;
            }
            switch (var1_1) {
                default: {
                    var57_57 = Log.e("CDMA", "RIL response handle in wrong phone! Expected CDMA RIL request and get GSM RIL request.");
                }
                case 24: {
                    try {
                        var60_60 = (String[])var2_2.result;
                        var61_61 = 4;
                        var62_62 = 65535;
                        var63_63 = -1;
                        var64_64 = 0x7FFFFFFF;
                        var65_65 = 0x7FFFFFFF;
                        var66_66 = 0;
                        var67_67 = 0;
                        var68_68 = 0;
                        var69_69 = 65535;
                        var70_70 = 0;
                        var71_71 = 0;
                        var72_72 = 0;
                        var73_73 = var60_60.length;
                        if (var73_73 != 14) {
                            var104_104 = new StringBuilder().append("Warning! Wrong number of parameters returned from RIL_REQUEST_REGISTRATION_STATE: expected 14 got ");
                            var105_105 = var60_60.length;
                            var106_106 = var104_104.append(var105_105).toString();
                            throw new RuntimeException(var106_106);
                        }
                        var73_73 = 0;
                        ** try [egrp 2[TRYBLOCK] [2 : 718->947)] { 
lbl49:
                        // 1 sources

                        ** GOTO lbl-1000
                    }
                    catch (RuntimeException var58_58) {
                        var59_59 = Log.e("CDMA", "Exception while polling service state. Probably malformed RIL response.", var58_58);
                    }
                    break;
lbl-1000:
                    // 1 sources

                    {
                        if (var60_60[var73_73] != null) {
                            var61_61 = Integer.parseInt(var60_60[0]);
                        }
                        if (var60_60[3] != null) {
                            var62_62 = Integer.parseInt(var60_60[3]);
                        }
                        if (var60_60[4] != null) {
                            var63_63 = Integer.parseInt(var60_60[4]);
                        }
                        if (var60_60[5] != null) {
                            var64_64 = Integer.parseInt(var60_60[5]);
                        }
                        if (var60_60[6] != null) {
                            var65_65 = Integer.parseInt(var60_60[6]);
                        }
                        if (var64_64 == 0 && var65_65 == 0) {
                            var64_64 = 0x7FFFFFFF;
                            var65_65 = 0x7FFFFFFF;
                        }
                        if (var60_60[7] != null) {
                            var66_66 = Integer.parseInt(var60_60[7]);
                        }
                        if (var60_60[8] != null) {
                            var67_67 = Integer.parseInt(var60_60[8]);
                        }
                        if (var60_60[9] != null) {
                            var68_68 = Integer.parseInt(var60_60[9]);
                        }
                        if (var60_60[10] != null) {
                            var69_69 = Integer.parseInt(var60_60[10]);
                        }
                        if (var60_60[11] != null) {
                            var70_70 = Integer.parseInt(var60_60[11]);
                        }
                        if (var60_60[12] != null) {
                            var71_71 = Integer.parseInt(var60_60[12]);
                        }
                        if (var60_60[13] != null) {
                            var72_72 = var74_74 = Integer.parseInt(var60_60[13]);
                        }
                    }
lbl81:
                    // 1 sources

                    catch (NumberFormatException var101_101) {
                        var102_102 = "error parsing RegistrationState: " + var101_101;
                        var103_103 = Log.w("CDMA", var102_102);
                    }
                    this.mRegistrationState = var75_75 = var61_61;
                    var76_76 = this;
                    var77_77 = var61_61;
                    var73_73 = var76_76.regCodeIsRoaming(var77_77) != false && (var79_79 = this).isRoamIndForHomeSystem(var80_80 = (var78_78 = var60_60[10])) == false ? 1 : 0;
                    var81_81 = var73_73;
                    this.mCdmaRoaming = var81_81;
                    var82_82 = this.newSS;
                    var83_83 = this;
                    var84_84 = var61_61;
                    var85_85 = var83_83.regCodeToServiceState(var84_84);
                    var82_82.setState(var85_85);
                    var86_86 = this;
                    var87_87 = var62_62;
                    this.newCdmaDataConnectionState = var88_88 = var86_86.radioTechnologyToDataServiceState(var87_87);
                    var89_89 = this.newSS;
                    var90_90 = var62_62;
                    var89_89.setRadioTechnology(var90_90);
                    this.newNetworkType = var91_91 = var62_62;
                    this.newSS.setCssIndicator(var66_66);
                    this.newSS.setSystemAndNetworkId(var67_67, var68_68);
                    this.mRoamingIndicator = var92_92 = var69_69;
                    var73_73 = var70_70 == 0 ? 0 : 1;
                    var93_93 = var73_73;
                    this.mIsInPrl = var93_93;
                    this.mDefaultRoamingIndicator = var94_94 = var71_71;
                    this.newCellLoc.setCellLocationData(var63_63, var64_64, var65_65, var67_67, var68_68);
                    this.mRegistrationDeniedReason = var72_72 == 0 ? (var95_95 = "General") : ((var107_107 = var72_72) == (var108_108 = 1) ? (var109_109 = "Authentication Failure") : (var110_110 = ""));
                    if (this.mRegistrationState != 3) break;
                    var96_96 = new StringBuilder().append("Registration denied, ");
                    var97_97 = this.mRegistrationDeniedReason;
                    var98_98 = var96_96.append(var97_97).toString();
                    var99_99 = this;
                    var100_100 = var98_98;
                    var99_99.log(var100_100);
                    break;
                }
                case 25: {
                    var111_111 = (String[])var2_2.result;
                    if (var111_111 != null && var111_111.length >= 3) {
                        if (this.cm.getRadioState().isNVReady()) {
                            var112_112 = this.newSS;
                            var113_113 = var111_111[1];
                            var114_114 = var111_111[2];
                            var112_112.setOperatorName(null, var113_113, var114_114);
                            break;
                        }
                        var115_115 = this.newSS;
                        var116_116 = var111_111[0];
                        var117_117 = var111_111[1];
                        var118_118 = var111_111[2];
                        var115_115.setOperatorName(var116_116, var117_117, var118_118);
                        break;
                    }
                    var119_119 = Log.w("CDMA", "error parsing opNames");
                }
            }
        }
        var11_11 = this.pollingContext;
        var11_11[0] = var12_12 = var11_11[0] - 1;
        if (this.pollingContext[0] != 0) {
            return;
        }
        var13_13 = false;
        if (!this.isSidsAllZeros() && (var15_15 = this).isHomeSid(var16_16 = (var14_14 = this.newSS.getSystemId()))) {
            var13_13 = true;
        }
        if (this.isSubscriptionFromRuim) {
            var17_17 = this.newSS;
            var18_18 = this.mCdmaRoaming;
            var19_19 = this.newSS;
            var20_20 = this;
            var21_21 = var18_18;
            var22_22 = var19_19;
            var23_23 = var20_20.isRoamingBetweenOperators(var21_21, var22_22);
            var17_17.setRoaming(var23_23);
        } else {
            var120_120 = this.newSS;
            var121_121 = this.mCdmaRoaming;
            var120_120.setRoaming(var121_121);
        }
        var24_24 = this.newSS;
        var25_25 = this.mDefaultRoamingIndicator;
        var24_24.setCdmaDefaultRoamingIndicator(var25_25);
        var26_26 = this.newSS;
        var27_27 = this.mRoamingIndicator;
        var26_26.setCdmaRoamingIndicator(var27_27);
        var28_28 = true;
        if (TextUtils.isEmpty(this.mPrlVersion)) {
            var28_28 = false;
        }
        if (!var28_28) {
            this.newSS.setCdmaRoamingIndicator(2);
        } else if (!this.isSidsAllZeros()) {
            if (!var13_13 && !this.mIsInPrl) {
                var122_122 = this.newSS;
                var123_123 = this.mDefaultRoamingIndicator;
                var122_122.setCdmaRoamingIndicator(var123_123);
            } else if (var13_13 && !this.mIsInPrl) {
                this.newSS.setCdmaRoamingIndicator(2);
            } else if (!var13_13 && this.mIsInPrl) {
                var124_124 = this.newSS;
                var125_125 = this.mRoamingIndicator;
                var124_124.setCdmaRoamingIndicator(var125_125);
            } else if (this.mRoamingIndicator <= 2) {
                this.newSS.setCdmaRoamingIndicator(1);
            } else {
                var126_126 = this.newSS;
                var127_127 = this.mRoamingIndicator;
                var126_126.setCdmaRoamingIndicator(var127_127);
            }
        }
        var29_29 = this.newSS.getCdmaRoamingIndicator();
        var30_30 = this.newSS;
        var31_31 = this.phone.mEriManager;
        var32_32 = this.mDefaultRoamingIndicator;
        var33_33 = var31_31;
        var34_34 = var29_29;
        var35_35 = var32_32;
        var36_36 = var33_33.getCdmaEriIconIndex(var34_34, var35_35);
        var30_30.setCdmaEriIconIndex(var36_36);
        var37_37 = this.newSS;
        var38_38 = this.phone.mEriManager;
        var39_39 = this.mDefaultRoamingIndicator;
        var40_40 = var38_38;
        var41_41 = var29_29;
        var42_42 = var39_39;
        var43_43 = var40_40.getCdmaEriIconMode(var41_41, var42_42);
        var37_37.setCdmaEriIconMode(var43_43);
        var44_44 = new StringBuilder().append("Set CDMA Roaming Indicator to: ");
        var45_45 = this.newSS.getCdmaRoamingIndicator();
        var46_46 = var44_44.append(var45_45).append(". mCdmaRoaming = ");
        var47_47 = this.mCdmaRoaming;
        var48_48 = var46_46.append(var47_47).append(", isPrlLoaded = ").append(var28_28).append(". namMatch = ").append(var13_13).append(" , mIsInPrl = ");
        var49_49 = this.mIsInPrl;
        var50_50 = var48_48.append(var49_49).append(", mRoamingIndicator = ");
        var51_51 = this.mRoamingIndicator;
        var52_52 = var50_50.append(var51_51).append(", mDefaultRoamingIndicator= ");
        var53_53 = this.mDefaultRoamingIndicator;
        var54_54 = var52_52.append(var53_53).toString();
        var55_55 = this;
        var56_56 = var54_54;
        var55_55.log(var56_56);
        this.pollStateDone();
    }

    boolean isConcurrentVoiceAndData() {
        return false;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    protected void log(String string2) {
        String string3 = "[CdmaServiceStateTracker] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void powerOffRadioSafely() {
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        Message message = dataConnectionTracker.obtainMessage(34);
        message.arg1 = 1;
        message.obj = "radioTurnedOff";
        boolean bl = dataConnectionTracker.sendMessage(message);
        synchronized (this) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                DataConnectionTracker.State state;
                DataConnectionTracker.State state2;
                DataConnectionTracker.State state3;
                DataConnectionTracker.State state4 = dataConnectionTracker.getState();
                if (state4 != (state3 = DataConnectionTracker.State.CONNECTED) && state4 != (state2 = DataConnectionTracker.State.DISCONNECTING) && state4 != (state = DataConnectionTracker.State.INITING)) {
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else if (this.sendEmptyMessageDelayed(38, 30000L)) {
                    this.log("Wait up to 30 sec for data to disconnect, then turn off radio.");
                    this.mPendingRadioPowerOffAfterDataOff = true;
                } else {
                    int n = Log.w(LOG_TAG, "Cannot send delayed Msg, turn off radio right away.");
                    this.hangupAndPowerOff();
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processPendingRadioPowerOffAfterDataOff() {
        synchronized (this) {
            if (!this.mPendingRadioPowerOffAfterDataOff) return false;
            this.log("Process pending request to turn radio off.");
            this.removeMessages(38);
            this.hangupAndPowerOff();
            this.mPendingRadioPowerOffAfterDataOff = false;
            return true;
        }
    }

    void registerForCdmaDataConnectionAttached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.cdmaDataConnectionAttachedRegistrants.add(registrant);
        if (this.cdmaDataConnectionState != 0) {
            return;
        }
        registrant.notifyRegistrant();
    }

    void registerForCdmaDataConnectionDetached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.cdmaDataConnectionDetachedRegistrants.add(registrant);
        if (this.cdmaDataConnectionState == 0) {
            return;
        }
        registrant.notifyRegistrant();
    }

    void registerForNetworkAttach(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.networkAttachedRegistrants.add(registrant);
        if (this.ss.getState() != 0) {
            return;
        }
        registrant.notifyRegistrant();
    }

    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.cdmaForSubscriptionInfoReadyRegistrants.add(registrant);
        if (!this.isMinInfoReady()) {
            return;
        }
        registrant.notifyRegistrant();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setPowerStateToDesired() {
        CommandsInterface.RadioState radioState;
        CommandsInterface.RadioState radioState2;
        if (this.mDesiredPowerState && (radioState2 = this.cm.getRadioState()) == (radioState = CommandsInterface.RadioState.RADIO_OFF)) {
            this.cm.setRadioPower(true, null);
            return;
        }
        if (this.mDesiredPowerState) {
            return;
        }
        if (!this.cm.getRadioState().isOn()) {
            return;
        }
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        if (!dataConnectionTracker.isDataConnectionAsDesired()) {
            int n = 50108;
            Object[] objectArray = new Object[2];
            String string2 = dataConnectionTracker.getStateInString();
            objectArray[0] = string2;
            int n2 = dataConnectionTracker.getAnyDataEnabled() ? 1 : 0;
            Integer n3 = n2;
            objectArray[1] = n3;
            int n4 = EventLog.writeEvent(n, objectArray);
        }
        this.powerOffRadioSafely();
    }

    void unregisterForCdmaDataConnectionAttached(Handler handler) {
        this.cdmaDataConnectionAttachedRegistrants.remove(handler);
    }

    void unregisterForCdmaDataConnectionDetached(Handler handler) {
        this.cdmaDataConnectionDetachedRegistrants.remove(handler);
    }

    void unregisterForNetworkAttach(Handler handler) {
        this.networkAttachedRegistrants.remove(handler);
    }

    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.cdmaForSubscriptionInfoReadyRegistrants.remove(handler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateSpnDisplay() {
        String string2;
        String string3;
        int n;
        boolean bl;
        String string4;
        if (this.cm.getRadioState().isRUIMReady()) {
            string4 = this.ss.getOperatorAlphaLong();
            bl = true;
        } else {
            string4 = this.ss.getOperatorAlphaLong();
            bl = true;
        }
        if (0 == (n = this.curSpnRule) || !TextUtils.equals("", string3 = this.curSpn) || !TextUtils.equals(string4, string2 = this.curPlmn)) {
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            Intent intent2 = intent.addFlags(0x20000000);
            Intent intent3 = intent.putExtra("showSpn", false);
            Intent intent4 = intent.putExtra("spn", "");
            Intent intent5 = intent.putExtra("showPlmn", bl);
            Intent intent6 = intent.putExtra("plmn", string4);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.curSpnRule = 0;
        this.curSpn = "";
        this.curPlmn = string4;
    }
}

