/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Message;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.cdma.CDMAPhone;

public final class RuimRecords
extends IccRecords {
    private static final boolean DBG = true;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_GET_CDMA_SUBSCRIPTION_DONE = 10;
    private static final int EVENT_GET_DEVICE_IDENTITY_DONE = 4;
    private static final int EVENT_GET_ICCID_DONE = 5;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 2;
    private static final int EVENT_RUIM_READY = 1;
    private static final int EVENT_RUIM_REFRESH = 31;
    private static final int EVENT_SMS_ON_RUIM = 21;
    private static final int EVENT_UPDATE_DONE = 14;
    static final String LOG_TAG = "CDMA";
    private String mImsi;
    private String mMin2Min1;
    private String mMyMobileNumber;
    private String mPrlVersion;
    private boolean m_ota_commited = false;

    RuimRecords(CDMAPhone cDMAPhone) {
        super(cDMAPhone);
        AdnRecordCache adnRecordCache;
        PhoneBase phoneBase = this.phone;
        this.adnCache = adnRecordCache = new AdnRecordCache(phoneBase);
        this.recordsRequested = false;
        this.recordsToLoad = 0;
        cDMAPhone.mCM.registerForRUIMReady(this, 1, null);
        cDMAPhone.mCM.registerForOffOrNotAvailable(this, 2, null);
        cDMAPhone.mCM.setOnIccRefresh(this, 31, null);
        this.onRadioOffOrNotAvailable();
    }

    private void fetchRuimRecords() {
        int n;
        this.recordsRequested = true;
        StringBuilder stringBuilder = new StringBuilder().append("RuimRecords:fetchRuimRecords ");
        int n2 = this.recordsToLoad;
        String string2 = stringBuilder.append(n2).toString();
        int n3 = Log.v(LOG_TAG, string2);
        IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
        Message message = this.obtainMessage(5);
        iccFileHandler.loadEFTransparent(12258, message);
        this.recordsToLoad = n = this.recordsToLoad + 1;
    }

    private void handleRuimRefresh(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.log("handleRuimRefresh without input");
            return;
        }
        switch (nArray[0]) {
            default: {
                this.log("handleRuimRefresh with unknown operation");
                return;
            }
            case 0: {
                this.log("handleRuimRefresh with SIM_REFRESH_FILE_UPDATED");
                this.adnCache.reset();
                this.fetchRuimRecords();
                return;
            }
            case 1: {
                this.log("handleRuimRefresh with SIM_REFRESH_INIT");
                this.fetchRuimRecords();
                return;
            }
            case 2: 
        }
        this.log("handleRuimRefresh with SIM_REFRESH_RESET");
        this.phone.mCM.setRadioPower(false, null);
    }

    private void onRuimReady() {
        ((CDMAPhone)this.phone).mRuimCard.broadcastIccStateChangedIntent("READY", null);
        this.fetchRuimRecords();
        CommandsInterface commandsInterface = this.phone.mCM;
        Message message = this.obtainMessage(10);
        commandsInterface.getCDMASubscription(message);
    }

    public void dispose() {
        this.phone.mCM.unregisterForRUIMReady(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unSetOnIccRefresh(this);
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "RuimRecords finalized");
    }

    public String getCdmaMin() {
        return this.mMin2Min1;
    }

    @Override
    protected int getDisplayRule(String string2) {
        return 0;
    }

    public String getMdnNumber() {
        return this.mMyMobileNumber;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRUIMOperatorNumeric() {
        if (this.mImsi == null) {
            return null;
        }
        if (this.mncLength != -1 && this.mncLength != 0) {
            String string2 = this.mImsi;
            int n = this.mncLength + 3;
            return string2.substring(0, n);
        }
        int n = Integer.parseInt(this.mImsi.substring(0, 3));
        String string3 = this.mImsi;
        int n2 = MccTable.smallestDigitsMccForMnc(n) + 3;
        return string3.substring(0, n2);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5, 6 : 154->161)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void log(String string2) {
        String string3 = "[RuimRecords] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    @Override
    protected void onAllRecordsLoaded() {
        int n = Log.d(LOG_TAG, "RuimRecords: record load complete");
        RegistrantList registrantList = this.recordsLoadedRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, null, null);
        registrantList.notifyRegistrants(asyncResult);
        ((CDMAPhone)this.phone).mRuimCard.broadcastIccStateChangedIntent("LOADED", null);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.iccid = null;
        this.adnCache.reset();
        this.recordsRequested = false;
    }

    @Override
    protected void onRecordLoaded() {
        int n;
        this.recordsToLoad = n = this.recordsToLoad - 1;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
            return;
        }
        if (this.recordsToLoad >= 0) {
            return;
        }
        int n2 = Log.e(LOG_TAG, "RuimRecords: recordsToLoad <0, programmer error suspected");
        this.recordsToLoad = 0;
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        if (!bl) {
            return;
        }
        this.fetchRuimRecords();
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message);
        IccException iccException = new IccException("setVoiceMailNumber not implemented");
        asyncResult.exception = iccException;
        message.sendToTarget();
        int n = Log.e(LOG_TAG, "method setVoiceMailNumber is not implemented");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        if (n != 1) {
            return;
        }
        if (n2 < 0) {
            n2 = -1;
        } else if (n2 > 255) {
            n2 = 255;
        }
        this.countVoiceMessages = n2;
        ((CDMAPhone)this.phone).notifyMessageWaitingIndicator();
    }
}

