/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RuimSmsInterfaceManager
extends IccSmsInterfaceManager {
    static final boolean DBG = true;
    private static final int EVENT_LOAD_DONE = 1;
    private static final int EVENT_UPDATE_DONE = 2;
    static final String LOG_TAG = "CDMA";
    Handler mHandler;
    private final Object mLock;
    private List<SmsRawData> mSms;
    private boolean mSuccess;

    public RuimSmsInterfaceManager(CDMAPhone cDMAPhone, SMSDispatcher sMSDispatcher) {
        super(cDMAPhone);
        Handler handler;
        Object object;
        this.mLock = object = new Object();
        this.mHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 2: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = RuimSmsInterfaceManager.this.mLock;
                        synchronized (object) {
                            RuimSmsInterfaceManager ruimSmsInterfaceManager = RuimSmsInterfaceManager.this;
                            boolean bl = asyncResult.exception == null;
                            boolean bl2 = RuimSmsInterfaceManager.access$102(ruimSmsInterfaceManager, bl);
                            RuimSmsInterfaceManager.this.mLock.notifyAll();
                            return;
                        }
                    }
                    case 1: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Object object = RuimSmsInterfaceManager.this.mLock;
                synchronized (object) {
                    if (asyncResult.exception == null) {
                        RuimSmsInterfaceManager ruimSmsInterfaceManager = RuimSmsInterfaceManager.this;
                        RuimSmsInterfaceManager ruimSmsInterfaceManager2 = RuimSmsInterfaceManager.this;
                        ArrayList arrayList = (ArrayList)asyncResult.result;
                        ArrayList arrayList2 = ruimSmsInterfaceManager2.buildValidRawData(arrayList);
                        List list = RuimSmsInterfaceManager.access$202(ruimSmsInterfaceManager, arrayList2);
                    } else {
                        RuimSmsInterfaceManager.this.log("Cannot load Sms records");
                        if (RuimSmsInterfaceManager.this.mSms != null) {
                            RuimSmsInterfaceManager.this.mSms.clear();
                        }
                    }
                    RuimSmsInterfaceManager.this.mLock.notifyAll();
                    return;
                }
            }
        };
        this.mDispatcher = sMSDispatcher;
    }

    static /* synthetic */ boolean access$102(RuimSmsInterfaceManager ruimSmsInterfaceManager, boolean bl) {
        ruimSmsInterfaceManager.mSuccess = bl;
        return bl;
    }

    static /* synthetic */ List access$202(RuimSmsInterfaceManager ruimSmsInterfaceManager, List list) {
        ruimSmsInterfaceManager.mSms = list;
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean copyMessageToIccEf(int n, byte[] byArray, byte[] byArray2) {
        StringBuilder stringBuilder = new StringBuilder().append("copyMessageToIccEf: status=").append(n).append(" ==> ").append("pdu=(");
        String string2 = Arrays.toString(byArray);
        String string3 = stringBuilder.append(string2).append(")").toString();
        this.log(string3);
        this.enforceReceiveAndSend("Copying message to RUIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message message = this.mHandler.obtainMessage(2);
            CommandsInterface commandsInterface = this.mPhone.mCM;
            String string4 = IccUtils.bytesToHexString(byArray);
            commandsInterface.writeSmsToRuim(n, string4, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to update by index");
            }
            return this.mSuccess;
        }
    }

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            int n = Log.e(LOG_TAG, "Error while finalizing:", throwable);
        }
        int n = Log.d(LOG_TAG, "RuimSmsInterfaceManager finalized");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf() {
        this.log("getAllMessagesFromEF");
        this.mPhone.getContext().enforceCallingPermission("android.permission.RECEIVE_SMS", "Reading messages from RUIM");
        Object object = this.mLock;
        synchronized (object) {
            Message message = this.mHandler.obtainMessage(1);
            this.mPhone.getIccFileHandler().loadEFLinearFixedAll(28476, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to load from the RUIM");
            }
            return this.mSms;
        }
    }

    @Override
    protected void log(String string2) {
        String string3 = "[RuimSmsInterfaceManager] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateMessageOnIccEf(int n, int n2, byte[] byArray) {
        String string2 = "updateMessageOnIccEf: index=" + n + " status=" + n2 + " ==> " + "(" + byArray + ")";
        this.log(string2);
        this.enforceReceiveAndSend("Updating message on RUIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message message = this.mHandler.obtainMessage(2);
            if (n2 == 0) {
                this.mPhone.mCM.deleteSmsOnRuim(n, message);
            } else {
                byte[] byArray2 = this.makeSmsRecordData(n2, byArray);
                IccFileHandler iccFileHandler = this.mPhone.getIccFileHandler();
                int n3 = n;
                iccFileHandler.updateEFLinearFixed(28476, n3, byArray2, null, message);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to update by index");
            }
            return this.mSuccess;
        }
    }
}

