/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Parcel;
import android.os.SystemProperties;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.sms.BearerData;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.android.internal.telephony.cdma.sms.SmsEnvelope;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SmsMessage
extends SmsMessageBase {
    private static final String LOGGABLE_TAG = "CDMA:SMS";
    static final String LOG_TAG = "CDMA";
    private static final int RETURN_ACK = 1;
    private static final int RETURN_NO_ACK;
    private BearerData mBearerData;
    private SmsEnvelope mEnvelope;
    private int status;

    public static SmsMessageBase.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return BearerData.calcTextEncodingDetails(charSequence, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte convertDtmfToAscii(byte by) {
        switch (by) {
            default: {
                return 32;
            }
            case 0: {
                return 68;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
            case 10: {
                return 48;
            }
            case 11: {
                return 42;
            }
            case 12: {
                return 35;
            }
            case 13: {
                return 65;
            }
            case 14: {
                return 66;
            }
            case 15: 
        }
        return 67;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        try {
            int n2;
            SmsMessage smsMessage = new SmsMessage();
            smsMessage.indexOnIcc = n;
            if ((byArray[0] & 1) == 0) {
                int n3 = Log.w(LOG_TAG, "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            smsMessage.statusOnIcc = n2 = byArray[0] & 7;
            byte by = byArray[1];
            byte[] byArray2 = new byte[by];
            System.arraycopy(byArray, 2, byArray2, 0, by);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            int n4 = Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage createFromPdu(byte[] byArray) {
        SmsMessage smsMessage = new SmsMessage();
        try {
            smsMessage.parsePdu(byArray);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    private void createPdu() {
        SmsEnvelope smsEnvelope = this.mEnvelope;
        CdmaSmsAddress cdmaSmsAddress = smsEnvelope.origAddress;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        try {
            int n = smsEnvelope.messageType;
            dataOutputStream.writeInt(n);
            int n2 = smsEnvelope.teleService;
            dataOutputStream.writeInt(n2);
            int n3 = smsEnvelope.serviceCategory;
            dataOutputStream.writeInt(n3);
            int n4 = cdmaSmsAddress.digitMode;
            dataOutputStream.writeByte(n4);
            int n5 = cdmaSmsAddress.numberMode;
            dataOutputStream.writeByte(n5);
            int n6 = cdmaSmsAddress.ton;
            dataOutputStream.writeByte(n6);
            int n7 = cdmaSmsAddress.numberPlan;
            dataOutputStream.writeByte(n7);
            int n8 = cdmaSmsAddress.numberOfDigits;
            dataOutputStream.writeByte(n8);
            byte[] byArray = cdmaSmsAddress.origBytes;
            int n9 = cdmaSmsAddress.origBytes.length;
            dataOutputStream.write(byArray, 0, n9);
            int n10 = smsEnvelope.bearerReply;
            dataOutputStream.writeInt(n10);
            byte by = smsEnvelope.replySeqNo;
            dataOutputStream.writeByte(by);
            byte by2 = smsEnvelope.errorClass;
            dataOutputStream.writeByte(by2);
            byte by3 = smsEnvelope.causeCode;
            dataOutputStream.writeByte(by3);
            int n11 = smsEnvelope.bearerData.length;
            dataOutputStream.writeInt(n11);
            byte[] byArray2 = smsEnvelope.bearerData;
            int n12 = smsEnvelope.bearerData.length;
            dataOutputStream.write(byArray2, 0, n12);
            dataOutputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            this.mPdu = byArray3;
            return;
        }
        catch (IOException iOException) {
            String string2 = "createPdu: conversion from object to byte array failed: " + iOException;
            int n = Log.e(LOG_TAG, string2);
            return;
        }
    }

    private static int getNextMessageId() {
        synchronized (SmsMessage.class) {
            int n = SystemProperties.getInt("persist.radio.cdma.msgid", 1);
            String string2 = Integer.toString(n % 65535 + 1);
            SystemProperties.set("persist.radio.cdma.msgid", string2);
            if (Log.isLoggable(LOGGABLE_TAG, 2)) {
                String string3 = "next persist.radio.cdma.msgid = " + string2;
                int n2 = Log.d(LOG_TAG, string3);
                StringBuilder stringBuilder = new StringBuilder().append("readback gets ");
                String string4 = SystemProperties.get("persist.radio.cdma.msgid");
                String string5 = stringBuilder.append(string4).toString();
                int n3 = Log.d(LOG_TAG, string5);
            }
            return n;
        }
    }

    public static SubmitPdu getSubmitPdu(String string2, UserData userData, boolean bl) {
        return SmsMessage.privateGetSubmitPdu(string2, bl, userData);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = n;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        UserData userData = new UserData();
        userData.userDataHeader = smsHeader;
        userData.msgEncoding = 0;
        userData.msgEncodingSet = true;
        userData.payload = byArray;
        return SmsMessage.privateGetSubmitPdu(string3, bl, userData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, SmsHeader smsHeader) {
        if (string4 == null) return null;
        if (string3 == null) {
            return null;
        }
        UserData userData = new UserData();
        userData.payloadStr = string4;
        userData.userDataHeader = smsHeader;
        return SmsMessage.privateGetSubmitPdu(string3, bl, userData);
    }

    public static int getTPLayerLengthForPDU(String string2) {
        int n = Log.w(LOG_TAG, "getTPLayerLengthForPDU: is not supported in CDMA mode.");
        return 0;
    }

    public static SmsMessage newFromCDS(String string2) {
        int n = Log.w(LOG_TAG, "newFromCDS: is not supported in CDMA mode.");
        return null;
    }

    public static SmsMessage newFromCMT(String[] stringArray) {
        int n = Log.w(LOG_TAG, "newFromCMT: is not supported in CDMA mode.");
        return null;
    }

    public static SmsMessage newFromCMTI(String string2) {
        int n = Log.w(LOG_TAG, "newFromCMTI: is not supported in CDMA mode.");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SmsMessage newFromParcel(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        SmsMessage smsMessage = new SmsMessage();
        SmsEnvelope smsEnvelope = new SmsEnvelope();
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        smsEnvelope.teleService = n4 = parcel.readInt();
        smsEnvelope.messageType = parcel.readByte() != null ? 1 : (smsEnvelope.teleService == 0 ? 2 : 0);
        smsEnvelope.serviceCategory = n3 = parcel.readInt();
        int n5 = parcel.readInt();
        byte by = (byte)(n5 & 0xFF);
        cdmaSmsAddress.digitMode = by;
        byte by2 = (byte)(parcel.readInt() & 0xFF);
        cdmaSmsAddress.numberMode = by2;
        cdmaSmsAddress.ton = n2 = parcel.readInt();
        byte by3 = (byte)(parcel.readInt() & 0xFF);
        cdmaSmsAddress.numberPlan = by3;
        int n6 = parcel.readByte();
        cdmaSmsAddress.numberOfDigits = n6;
        byte[] byArray = new byte[n6];
        for (int i = 0; i < n6; ++i) {
            byte by4;
            byte by5;
            byArray[i] = by5 = parcel.readByte();
            if (n5 != 0) continue;
            byte by6 = byArray[i];
            byArray[i] = by4 = smsMessage.convertDtmfToAscii(by6);
        }
        cdmaSmsAddress.origBytes = byArray;
        int n7 = parcel.readInt();
        int n8 = parcel.readInt();
        int n9 = parcel.readByte();
        for (n = 0; n < n9; ++n) {
            byte by7 = parcel.readByte();
        }
        int n10 = parcel.readInt();
        if (n10 > 0) {
            byArray = new byte[n10];
            n = 0;
            while (n < n10) {
                byte by8;
                byArray[n] = by8 = parcel.readByte();
                int n11 = n + 1;
            }
            smsEnvelope.bearerData = byArray;
        }
        smsEnvelope.origAddress = cdmaSmsAddress;
        smsMessage.originatingAddress = cdmaSmsAddress;
        smsMessage.mEnvelope = smsEnvelope;
        smsMessage.createPdu();
        return smsMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        SmsEnvelope smsEnvelope = new SmsEnvelope();
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        try {
            byte by;
            byte by2;
            byte by3;
            int n;
            int n2;
            int n3;
            int n4;
            smsEnvelope.messageType = n4 = dataInputStream.readInt();
            smsEnvelope.teleService = n3 = dataInputStream.readInt();
            smsEnvelope.serviceCategory = n2 = dataInputStream.readInt();
            byte by4 = dataInputStream.readByte();
            cdmaSmsAddress.digitMode = by4;
            byte by5 = dataInputStream.readByte();
            cdmaSmsAddress.numberMode = by5;
            byte by6 = dataInputStream.readByte();
            cdmaSmsAddress.ton = by6;
            byte by7 = dataInputStream.readByte();
            cdmaSmsAddress.numberPlan = by7;
            byte by8 = dataInputStream.readByte();
            cdmaSmsAddress.numberOfDigits = by8;
            byte[] byArray2 = new byte[by8];
            byte[] byArray3 = cdmaSmsAddress.origBytes = byArray2;
            int n5 = dataInputStream.read(byArray3, 0, by8);
            smsEnvelope.bearerReply = n = dataInputStream.readInt();
            smsEnvelope.replySeqNo = by3 = dataInputStream.readByte();
            smsEnvelope.errorClass = by2 = dataInputStream.readByte();
            smsEnvelope.causeCode = by = dataInputStream.readByte();
            int n6 = dataInputStream.readInt();
            byte[] byArray4 = new byte[n6];
            byte[] byArray5 = smsEnvelope.bearerData = byArray4;
            int n7 = dataInputStream.read(byArray5, 0, n6);
            dataInputStream.close();
        }
        catch (Exception exception) {
            String string2 = "createFromPdu: conversion from byte array to object failed: " + exception;
            int n = Log.e(LOG_TAG, string2);
        }
        this.originatingAddress = cdmaSmsAddress;
        smsEnvelope.origAddress = cdmaSmsAddress;
        this.mEnvelope = smsEnvelope;
        this.mPdu = byArray;
        this.parseSms();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SubmitPdu privateGetSubmitPdu(String string2, boolean bl, UserData object) {
        int n;
        CdmaSmsAddress cdmaSmsAddress = CdmaSmsAddress.parse(string2);
        if (cdmaSmsAddress == null) {
            return null;
        }
        BearerData bearerData = new BearerData();
        bearerData.messageType = 2;
        bearerData.messageId = n = SmsMessage.getNextMessageId();
        bearerData.deliveryAckReq = bl;
        bearerData.userAckReq = false;
        bearerData.readAckReq = false;
        bearerData.reportReq = false;
        bearerData.userData = object;
        object = BearerData.encode(bearerData);
        if (Log.isLoggable(LOGGABLE_TAG, 2)) {
            String string3 = "MO (encoded) BearerData = " + bearerData;
            int n2 = Log.d(LOG_TAG, string3);
            StringBuilder stringBuilder = new StringBuilder().append("MO raw BearerData = '");
            String string4 = HexDump.toHexString((byte[])object);
            String string5 = stringBuilder.append(string4).append("'").toString();
            int n3 = Log.d(LOG_TAG, string5);
        }
        if (object == null) {
            return null;
        }
        int n4 = bearerData.hasUserDataHeader ? 4101 : 4098;
        SmsEnvelope smsEnvelope = new SmsEnvelope();
        smsEnvelope.messageType = 0;
        smsEnvelope.teleService = n4;
        smsEnvelope.destAddress = cdmaSmsAddress;
        smsEnvelope.bearerReply = 1;
        smsEnvelope.bearerData = (byte[])object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n5 = smsEnvelope.teleService;
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            int n6 = cdmaSmsAddress.digitMode;
            dataOutputStream.write(n6);
            int n7 = cdmaSmsAddress.numberMode;
            dataOutputStream.write(n7);
            int n8 = cdmaSmsAddress.ton;
            dataOutputStream.write(n8);
            int n9 = cdmaSmsAddress.numberPlan;
            dataOutputStream.write(n9);
            int n10 = cdmaSmsAddress.numberOfDigits;
            dataOutputStream.write(n10);
            byte[] byArray = cdmaSmsAddress.origBytes;
            int n11 = cdmaSmsAddress.origBytes.length;
            dataOutputStream.write(byArray, 0, n11);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            int n12 = ((Object)object).length;
            dataOutputStream.write(n12);
            int n13 = ((Object)object).length;
            dataOutputStream.write((byte[])object, 0, n13);
            dataOutputStream.close();
            SubmitPdu submitPdu = new SubmitPdu();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            submitPdu.encodedMessage = byArray2;
            submitPdu.encodedScAddress = null;
            return submitPdu;
        }
        catch (IOException iOException) {
            String string6 = "creating SubmitPdu failed: " + iOException;
            int n14 = Log.e(LOG_TAG, string6);
            return null;
        }
    }

    byte[] getIncomingSmsFingerprint() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.mEnvelope.teleService;
        byteArrayOutputStream.write(n);
        byte[] byArray = this.mEnvelope.origAddress.origBytes;
        int n2 = this.mEnvelope.origAddress.origBytes.length;
        byteArrayOutputStream.write(byArray, 0, n2);
        byte[] byArray2 = this.mEnvelope.bearerData;
        int n3 = this.mEnvelope.bearerData.length;
        byteArrayOutputStream.write(byArray2, 0, n3);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SmsMessage.MessageClass getMessageClass() {
        if (this.mBearerData.displayMode != 0) return SmsMessage.MessageClass.UNKNOWN;
        return SmsMessage.MessageClass.CLASS_0;
    }

    int getMessageType() {
        return this.mEnvelope.messageType;
    }

    int getNumOfVoicemails() {
        return this.mBearerData.numberOfMessages;
    }

    @Override
    public int getProtocolIdentifier() {
        int n = Log.w(LOG_TAG, "getProtocolIdentifier: is not supported in CDMA mode.");
        return 0;
    }

    @Override
    public int getStatus() {
        return this.status << 16;
    }

    int getTeleService() {
        return this.mEnvelope.teleService;
    }

    @Override
    public boolean isCphsMwiMessage() {
        int n = Log.w(LOG_TAG, "isCphsMwiMessage: is not supported in CDMA mode.");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMWIClearMessage() {
        if (this.mBearerData == null) return false;
        if (this.mBearerData.numberOfMessages != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMWISetMessage() {
        if (this.mBearerData == null) return false;
        if (this.mBearerData.numberOfMessages <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMwiDontStore() {
        if (this.mBearerData == null) return false;
        if (this.mBearerData.numberOfMessages <= 0) return false;
        if (this.mBearerData.userData != null) return false;
        return true;
    }

    @Override
    public boolean isReplace() {
        int n = Log.w(LOG_TAG, "isReplace: is not supported in CDMA mode.");
        return false;
    }

    @Override
    public boolean isReplyPathPresent() {
        int n = Log.w(LOG_TAG, "isReplyPathPresent: is not supported in CDMA mode.");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isStatusReportMessage() {
        if (this.mBearerData.messageType != 4) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseSms() {
        int n;
        BearerData bearerData;
        if (this.mEnvelope.teleService == 262144) {
            int n2;
            BearerData bearerData2;
            this.mBearerData = bearerData2 = new BearerData();
            if (this.mEnvelope.bearerData == null) {
                return;
            }
            BearerData bearerData3 = this.mBearerData;
            bearerData3.numberOfMessages = n2 = this.mEnvelope.bearerData[0] & 0xFF;
            return;
        }
        this.mBearerData = bearerData = BearerData.decode(this.mEnvelope.bearerData);
        if (Log.isLoggable(LOGGABLE_TAG, 2)) {
            StringBuilder stringBuilder = new StringBuilder().append("MT raw BearerData = '");
            String string2 = HexDump.toHexString(this.mEnvelope.bearerData);
            String string3 = stringBuilder.append(string2).append("'").toString();
            int n3 = Log.d(LOG_TAG, string3);
            StringBuilder stringBuilder2 = new StringBuilder().append("MT (decoded) BearerData = ");
            BearerData bearerData4 = this.mBearerData;
            String string4 = stringBuilder2.append(bearerData4).toString();
            int n4 = Log.d(LOG_TAG, string4);
        }
        this.messageRef = n = this.mBearerData.messageId;
        if (this.mBearerData.userData != null) {
            String string5;
            SmsHeader smsHeader;
            byte[] byArray = this.mBearerData.userData.payload;
            this.userData = byArray;
            this.userDataHeader = smsHeader = this.mBearerData.userData.userDataHeader;
            this.messageBody = string5 = this.mBearerData.userData.payloadStr;
        }
        if (this.originatingAddress != null) {
            String string6;
            SmsAddress smsAddress = this.originatingAddress;
            byte[] byArray = this.originatingAddress.origBytes;
            smsAddress.address = string6 = new String(byArray);
        }
        if (this.mBearerData.msgCenterTimeStamp != null) {
            long l;
            this.scTimeMillis = l = this.mBearerData.msgCenterTimeStamp.toMillis(true);
        }
        StringBuilder stringBuilder = new StringBuilder().append("SMS SC timestamp: ");
        long l = this.scTimeMillis;
        String string7 = stringBuilder.append(l).toString();
        int n5 = Log.d(LOG_TAG, string7);
        if (this.mBearerData.messageType == 4) {
            if (!this.mBearerData.messageStatusSet) {
                StringBuilder stringBuilder3 = new StringBuilder().append("DELIVERY_ACK message without msgStatus (");
                String string8 = this.userData == null ? "also missing" : "does have";
                String string9 = stringBuilder3.append(string8).append(" userData).").toString();
                int n6 = Log.d(LOG_TAG, string9);
                this.status = 0;
            } else {
                int n7;
                int n8;
                int n9 = this.status = (n8 = this.mBearerData.errorClass << 8);
                int n10 = this.mBearerData.messageStatus;
                this.status = n7 = n9 | n10;
            }
        } else if (this.mBearerData.messageType != 1) {
            StringBuilder stringBuilder4 = new StringBuilder().append("Unsupported message type: ");
            int n11 = this.mBearerData.messageType;
            String string10 = stringBuilder4.append(n11).toString();
            throw new RuntimeException(string10);
        }
        if (this.messageBody != null) {
            this.parseMessageBody();
            return;
        }
        if (this.userData == null) {
            return;
        }
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase {
    }
}

