/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma.sms;

import android.text.format.Time;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.util.BitwiseInputStream;
import com.android.internal.util.BitwiseOutputStream;
import java.io.UnsupportedEncodingException;

public final class BearerData {
    public static final int ALERT_DEFAULT = 0;
    public static final int ALERT_HIGH_PRIO = 3;
    public static final int ALERT_LOW_PRIO = 1;
    public static final int ALERT_MEDIUM_PRIO = 2;
    public static final int DISPLAY_MODE_DEFAULT = 1;
    public static final int DISPLAY_MODE_IMMEDIATE = 0;
    public static final int DISPLAY_MODE_USER = 2;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_PERMANENT = 3;
    public static final int ERROR_TEMPORARY = 2;
    public static final int ERROR_UNDEFINED = 255;
    public static final int LANGUAGE_CHINESE = 6;
    public static final int LANGUAGE_ENGLISH = 1;
    public static final int LANGUAGE_FRENCH = 2;
    public static final int LANGUAGE_HEBREW = 7;
    public static final int LANGUAGE_JAPANESE = 4;
    public static final int LANGUAGE_KOREAN = 5;
    public static final int LANGUAGE_SPANISH = 3;
    public static final int LANGUAGE_UNKNOWN = 0;
    private static final String LOG_TAG = "SMS";
    public static final int MESSAGE_TYPE_CANCELLATION = 3;
    public static final int MESSAGE_TYPE_DELIVER = 1;
    public static final int MESSAGE_TYPE_DELIVERY_ACK = 4;
    public static final int MESSAGE_TYPE_DELIVER_REPORT = 7;
    public static final int MESSAGE_TYPE_READ_ACK = 6;
    public static final int MESSAGE_TYPE_SUBMIT = 2;
    public static final int MESSAGE_TYPE_SUBMIT_REPORT = 8;
    public static final int MESSAGE_TYPE_USER_ACK = 5;
    public static final int PRIORITY_EMERGENCY = 3;
    public static final int PRIORITY_INTERACTIVE = 1;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_URGENT = 2;
    public static final int PRIVACY_CONFIDENTIAL = 2;
    public static final int PRIVACY_NOT_RESTRICTED = 0;
    public static final int PRIVACY_RESTRICTED = 1;
    public static final int PRIVACY_SECRET = 3;
    public static final int RELATIVE_TIME_DAYS_LIMIT = 196;
    public static final int RELATIVE_TIME_HOURS_LIMIT = 167;
    public static final int RELATIVE_TIME_INDEFINITE = 245;
    public static final int RELATIVE_TIME_MINS_LIMIT = 143;
    public static final int RELATIVE_TIME_MOBILE_INACTIVE = 247;
    public static final int RELATIVE_TIME_NOW = 246;
    public static final int RELATIVE_TIME_RESERVED = 248;
    public static final int RELATIVE_TIME_WEEKS_LIMIT = 244;
    public static final int STATUS_ACCEPTED = 0;
    public static final int STATUS_BLOCKED_DESTINATION = 7;
    public static final int STATUS_CANCELLED = 3;
    public static final int STATUS_CANCEL_FAILED = 6;
    public static final int STATUS_DELIVERED = 2;
    public static final int STATUS_DEPOSITED_TO_INTERNET = 1;
    public static final int STATUS_DUPLICATE_MESSAGE = 9;
    public static final int STATUS_INVALID_DESTINATION = 10;
    public static final int STATUS_MESSAGE_EXPIRED = 13;
    public static final int STATUS_NETWORK_CONGESTION = 4;
    public static final int STATUS_NETWORK_ERROR = 5;
    public static final int STATUS_TEXT_TOO_LONG = 8;
    public static final int STATUS_UNDEFINED = 255;
    public static final int STATUS_UNKNOWN_ERROR = 31;
    private static final byte SUBPARAM_ALERT_ON_MESSAGE_DELIVERY = 12;
    private static final byte SUBPARAM_CALLBACK_NUMBER = 14;
    private static final byte SUBPARAM_DEFERRED_DELIVERY_TIME_ABSOLUTE = 6;
    private static final byte SUBPARAM_DEFERRED_DELIVERY_TIME_RELATIVE = 7;
    private static final byte SUBPARAM_LANGUAGE_INDICATOR = 13;
    private static final byte SUBPARAM_MESSAGE_CENTER_TIME_STAMP = 3;
    private static final byte SUBPARAM_MESSAGE_DEPOSIT_INDEX = 17;
    private static final byte SUBPARAM_MESSAGE_DISPLAY_MODE = 15;
    private static final byte SUBPARAM_MESSAGE_IDENTIFIER = 0;
    private static final byte SUBPARAM_MESSAGE_STATUS = 20;
    private static final byte SUBPARAM_NUMBER_OF_MESSAGES = 11;
    private static final byte SUBPARAM_PRIORITY_INDICATOR = 8;
    private static final byte SUBPARAM_PRIVACY_INDICATOR = 9;
    private static final byte SUBPARAM_REPLY_OPTION = 10;
    private static final byte SUBPARAM_USER_DATA = 1;
    private static final byte SUBPARAM_USER_REPONSE_CODE = 2;
    private static final byte SUBPARAM_VALIDITY_PERIOD_ABSOLUTE = 4;
    private static final byte SUBPARAM_VALIDITY_PERIOD_RELATIVE = 5;
    public int alert = 0;
    public boolean alertIndicatorSet = false;
    public CdmaSmsAddress callbackNumber;
    public TimeStamp deferredDeliveryTimeAbsolute;
    public int deferredDeliveryTimeRelative;
    public boolean deferredDeliveryTimeRelativeSet;
    public boolean deliveryAckReq;
    public int depositIndex;
    public int displayMode = 1;
    public boolean displayModeSet = false;
    public int errorClass = 255;
    public boolean hasUserDataHeader;
    public int language = 0;
    public boolean languageIndicatorSet = false;
    public int messageId;
    public int messageStatus = 255;
    public boolean messageStatusSet = false;
    public int messageType;
    public TimeStamp msgCenterTimeStamp;
    public int numberOfMessages;
    public int priority = 0;
    public boolean priorityIndicatorSet = false;
    public int privacy = 0;
    public boolean privacyIndicatorSet = false;
    public boolean readAckReq;
    public boolean reportReq;
    public boolean userAckReq;
    public UserData userData;
    public int userResponseCode;
    public boolean userResponseCodeSet = false;
    public TimeStamp validityPeriodAbsolute;
    public int validityPeriodRelative;
    public boolean validityPeriodRelativeSet;

    /*
     * Enabled aggressive block sorting
     */
    public static SmsMessageBase.TextEncodingDetails calcTextEncodingDetails(CharSequence charSequence, boolean bl) {
        int n;
        SmsMessageBase.TextEncodingDetails textEncodingDetails;
        int n2 = BearerData.countAsciiSeptets(charSequence, bl);
        if (n2 != -1 && n2 <= 160) {
            int n3;
            textEncodingDetails = new SmsMessageBase.TextEncodingDetails();
            textEncodingDetails.msgCount = 1;
            textEncodingDetails.codeUnitCount = n2;
            textEncodingDetails.codeUnitsRemaining = n3 = 160 - n2;
            textEncodingDetails.codeUnitSize = 1;
            return textEncodingDetails;
        }
        textEncodingDetails = SmsMessage.calculateLength(charSequence, bl);
        if (textEncodingDetails.msgCount != 1) return textEncodingDetails;
        if (textEncodingDetails.codeUnitSize != 1) return textEncodingDetails;
        textEncodingDetails.codeUnitCount = n = charSequence.length();
        int n4 = textEncodingDetails.codeUnitCount * 2;
        if (n4 > 140) {
            int n5;
            int n6;
            textEncodingDetails.msgCount = n6 = (n4 + 133) / 134;
            textEncodingDetails.codeUnitsRemaining = n5 = (textEncodingDetails.msgCount * 134 - n4) / 2;
        } else {
            int n7;
            textEncodingDetails.msgCount = 1;
            textEncodingDetails.codeUnitsRemaining = n7 = (140 - n4) / 2;
        }
        textEncodingDetails.codeUnitSize = 3;
        return textEncodingDetails;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int countAsciiSeptets(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        if (bl) {
            return n;
        }
        int n2 = 0;
        while (n2 < n) {
            SparseIntArray sparseIntArray = UserData.charToAscii;
            char c = charSequence.charAt(n2);
            if (sparseIntArray.get(c, -1) == -1) {
                return -1;
            }
            ++n2;
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    public static BearerData decode(byte[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2, 3 : 228->267)] com.android.internal.util.BitwiseInputStream$AccessException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String decode7bitAscii(byte[] byArray, int n, int n2) throws CodingException {
        int n3;
        BitwiseInputStream bitwiseInputStream;
        StringBuffer stringBuffer;
        int n4 = n * 8;
        try {
            stringBuffer = new StringBuffer(n2);
            bitwiseInputStream = new BitwiseInputStream(byArray);
            int n5 = n4 * 8;
            int n6 = n2 * 7;
            int n7 = n5 + n6;
            if (bitwiseInputStream.available() < n7) {
                StringBuilder stringBuilder = new StringBuilder().append("insufficient data (wanted ").append(n7).append(" bits, but only have ");
                int n8 = bitwiseInputStream.available();
                String string2 = stringBuilder.append(n8).append(")").toString();
                throw new CodingException(string2);
            }
            bitwiseInputStream.skip(n4);
            n3 = 0;
        }
        catch (BitwiseInputStream.AccessException accessException) {
            String string3 = "7bit ASCII decode failed: " + accessException;
            throw new CodingException(string3);
        }
        while (n3 < n2) {
            int n9;
            int n10 = bitwiseInputStream.read(7);
            if (n10 >= 32 && n10 <= (n9 = UserData.ASCII_MAP_MAX_INDEX)) {
                char[] cArray = UserData.ASCII_MAP;
                int n11 = n10 - 32;
                char c = cArray[n11];
                StringBuffer stringBuffer2 = stringBuffer.append(c);
            } else if (n10 == 10) {
                StringBuffer stringBuffer3 = stringBuffer.append('\n');
            } else if (n10 == 13) {
                StringBuffer stringBuffer4 = stringBuffer.append('\r');
            } else {
                StringBuffer stringBuffer5 = stringBuffer.append(' ');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String decode7bitGsm(byte[] byArray, int n, int n2) throws CodingException {
        int n3 = n * 8;
        int n4 = (n3 + 6) / 7;
        int n5 = n2 - n4;
        int n6 = n4 * 7 - n3;
        String string2 = GsmAlphabet.gsm7BitPackedToString(byArray, n, n5, n6);
        if (string2 == null) {
            throw new CodingException("7bit GSM decoding failed");
        }
        return string2;
    }

    private static boolean decodeCallbackNumber(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n;
        int n2;
        int n3 = bitwiseInputStream.read(8) * 8;
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        cdmaSmsAddress.digitMode = n2 = bitwiseInputStream.read(1);
        int n4 = 4;
        int n5 = 1;
        if (cdmaSmsAddress.digitMode == 1) {
            int n6;
            int n7;
            cdmaSmsAddress.ton = n7 = bitwiseInputStream.read(3);
            cdmaSmsAddress.numberPlan = n6 = bitwiseInputStream.read(4);
            n4 = 8;
            n5 = (byte)(1 + 7);
        }
        cdmaSmsAddress.numberOfDigits = n = bitwiseInputStream.read(8);
        byte by = (byte)(n5 + 8);
        int n8 = n3 - by;
        int n9 = cdmaSmsAddress.numberOfDigits * n4;
        int n10 = n8 - n9;
        if (n8 < n9) {
            String string2 = "CALLBACK_NUMBER subparam encoding size error (remainingBits + " + n8 + ", dataBits + " + n9 + ", paddingBits + " + n10 + ")";
            throw new CodingException(string2);
        }
        byte[] byArray = bitwiseInputStream.readByteArray(n9);
        cdmaSmsAddress.origBytes = byArray;
        bitwiseInputStream.skip(n10);
        BearerData.decodeSmsAddress(cdmaSmsAddress);
        bearerData.callbackNumber = cdmaSmsAddress;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDeferredDeliveryAbs(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 48) {
            TimeStamp timeStamp;
            n += -48;
            bl = true;
            bearerData.deferredDeliveryTimeAbsolute = timeStamp = TimeStamp.fromByteArray(bitwiseInputStream.readByteArray(48));
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("DEFERRED_DELIVERY_TIME_ABSOLUTE decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n2 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDeferredDeliveryRel(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.validityPeriodRelative = n2 = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("DEFERRED_DELIVERY_TIME_RELATIVE decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.validityPeriodRelativeSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDepositIndex(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 16) {
            int n2;
            n += -16;
            bl = true;
            int n3 = bitwiseInputStream.read(8) << 8;
            int n4 = bitwiseInputStream.read(8);
            bearerData.depositIndex = n2 = n3 | n4;
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_DEPOSIT_INDEX decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n5 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDisplayMode(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.displayMode = n2 = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("DISPLAY_MODE decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.displayModeSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String decodeDtmfSmsAddress(byte[] byArray, int n) throws CodingException {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 / 2;
            byte by = byArray[n3];
            int n4 = n2 % 2 * 4;
            int n5 = 4 - n4;
            int n6 = by >>> n5 & 0xF;
            if (n6 >= 1 && n6 <= 9) {
                String string2 = Integer.toString(n6, 10);
                StringBuffer stringBuffer2 = stringBuffer.append(string2);
            } else if (n6 == 10) {
                StringBuffer stringBuffer3 = stringBuffer.append('0');
            } else if (n6 == 11) {
                StringBuffer stringBuffer4 = stringBuffer.append('*');
            } else {
                if (n6 != 12) {
                    String string3 = "invalid SMS address DTMF code (" + n6 + ")";
                    throw new CodingException(string3);
                }
                StringBuffer stringBuffer5 = stringBuffer.append('#');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void decodeIs91(BearerData bearerData) throws BitwiseInputStream.AccessException, CodingException {
        switch (bearerData.userData.msgType) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("unsupported IS-91 message type (");
                int n = bearerData.userData.msgType;
                String string2 = stringBuilder.append(n).append(")").toString();
                throw new CodingException(string2);
            }
            case 130: {
                BearerData.decodeIs91VoicemailStatus(bearerData);
                return;
            }
            case 132: {
                BearerData.decodeIs91Cli(bearerData);
                return;
            }
            case 131: 
            case 133: 
        }
        BearerData.decodeIs91ShortMessage(bearerData);
    }

    private static void decodeIs91Cli(BearerData bearerData) throws CodingException {
        byte[] byArray = bearerData.userData.payload;
        int n = new BitwiseInputStream(byArray).available() / 4;
        int n2 = bearerData.userData.numFields;
        if (n > 14 || n < 3 || n < n2) {
            throw new CodingException("IS-91 voicemail status decoding failed");
        }
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        cdmaSmsAddress.digitMode = 0;
        byte[] byArray2 = bearerData.userData.payload;
        cdmaSmsAddress.origBytes = byArray2;
        byte by = (byte)n2;
        cdmaSmsAddress.numberOfDigits = by;
        BearerData.decodeSmsAddress(cdmaSmsAddress);
        bearerData.callbackNumber = cdmaSmsAddress;
    }

    private static void decodeIs91ShortMessage(BearerData bearerData) throws BitwiseInputStream.AccessException, CodingException {
        String string2;
        byte[] byArray = bearerData.userData.payload;
        BitwiseInputStream bitwiseInputStream = new BitwiseInputStream(byArray);
        int n = bitwiseInputStream.available() / 6;
        int n2 = bearerData.userData.numFields;
        if (n > 14 || n < n2) {
            throw new CodingException("IS-91 voicemail status decoding failed");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n2; ++i) {
            char[] cArray = UserData.ASCII_MAP;
            int n3 = bitwiseInputStream.read(6);
            char c = cArray[n3];
            StringBuffer stringBuffer2 = stringBuffer.append(c);
        }
        UserData userData = bearerData.userData;
        userData.payloadStr = string2 = stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void decodeIs91VoicemailStatus(BearerData bearerData) throws BitwiseInputStream.AccessException, CodingException {
        byte[] byArray = bearerData.userData.payload;
        BitwiseInputStream bitwiseInputStream = new BitwiseInputStream(byArray);
        int n = bitwiseInputStream.available() / 6;
        int n2 = bearerData.userData.numFields;
        if (n > 14 || n < 3 || n < n2) {
            throw new CodingException("IS-91 voicemail status decoding failed");
        }
        try {
            char c;
            block12: {
                String string2;
                String string3;
                block11: {
                    block10: {
                        int n3;
                        StringBuffer stringBuffer = new StringBuffer(n);
                        while (bitwiseInputStream.available() >= 6) {
                            char[] cArray = UserData.ASCII_MAP;
                            int n4 = bitwiseInputStream.read(6);
                            char c2 = cArray[n4];
                            StringBuffer stringBuffer2 = stringBuffer.append(c2);
                        }
                        string3 = stringBuffer.toString();
                        bearerData.numberOfMessages = n3 = Integer.parseInt(string3.substring(0, 2));
                        c = string3.charAt(2);
                        if (c != ' ') break block10;
                        bearerData.priority = 0;
                        break block11;
                    }
                    if (c != '!') break block12;
                    bearerData.priority = 2;
                }
                bearerData.priorityIndicatorSet = true;
                UserData userData = bearerData.userData;
                int n5 = n2 - 3;
                userData.payloadStr = string2 = string3.substring(3, n5);
                return;
            }
            String string4 = "IS-91 voicemail status decoding failed: illegal priority setting (" + c + ")";
            throw new CodingException(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = "IS-91 voicemail status decoding failed: " + numberFormatException;
            throw new CodingException(string5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string6 = "IS-91 voicemail status decoding failed: " + indexOutOfBoundsException;
            throw new CodingException(string6);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeLanguageIndicator(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.language = n2 = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("LANGUAGE_INDICATOR decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.languageIndicatorSet = bl;
        return bl;
    }

    private static String decodeLatin(byte[] byArray, int n, int n2) throws CodingException {
        try {
            int n3 = n2 - n;
            String string2 = new String(byArray, n, n3, "ISO-8859-1");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = "ISO-8859-1 decode failed: " + unsupportedEncodingException;
            throw new CodingException(string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMessageId(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 24) {
            int n2;
            int n3;
            int n4;
            n += -24;
            bl = true;
            bearerData.messageType = n4 = bitwiseInputStream.read(4);
            int n5 = bearerData.messageId = (n3 = bitwiseInputStream.read(8) << 8);
            int n6 = bitwiseInputStream.read(8);
            bearerData.messageId = n2 = n5 | n6;
            boolean bl2 = bitwiseInputStream.read(1) == 1;
            bearerData.hasUserDataHeader = bl2;
            bitwiseInputStream.skip(3);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_IDENTIFIER decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n7 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgCenterTimeStamp(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 48) {
            TimeStamp timeStamp;
            n += -48;
            bl = true;
            bearerData.msgCenterTimeStamp = timeStamp = TimeStamp.fromByteArray(bitwiseInputStream.readByteArray(48));
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_CENTER_TIME_STAMP decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n2 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgCount(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.numberOfMessages = n2 = IccUtils.cdmaBcdByteToInt((byte)bitwiseInputStream.read(8));
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("NUMBER_OF_MESSAGES decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgDeliveryAlert(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.alert = n2 = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("ALERT_ON_MESSAGE_DELIVERY decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.alertIndicatorSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgStatus(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            int n3;
            n += -8;
            bl = true;
            bearerData.errorClass = n3 = bitwiseInputStream.read(2);
            bearerData.messageStatus = n2 = bitwiseInputStream.read(6);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_STATUS decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n4 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.messageStatusSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodePriorityIndicator(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.priority = n2 = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("PRIORITY_INDICATOR decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.priorityIndicatorSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodePrivacyIndicator(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.privacy = n2 = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("PRIVACY_INDICATOR decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.privacyIndicatorSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeReplyOption(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            n += -8;
            bl = true;
            boolean bl2 = bitwiseInputStream.read(1) == 1;
            bearerData.userAckReq = bl2;
            boolean bl3 = bitwiseInputStream.read(1) == 1;
            bearerData.deliveryAckReq = bl3;
            boolean bl4 = bitwiseInputStream.read(1) == 1;
            bearerData.readAckReq = bl4;
            boolean bl5 = bitwiseInputStream.read(1) == 1;
            bearerData.reportReq = bl5;
            bitwiseInputStream.skip(4);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("REPLY_OPTION decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n2 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    private static void decodeSmsAddress(CdmaSmsAddress cdmaSmsAddress) throws CodingException {
        String string2;
        if (cdmaSmsAddress.digitMode == 1) {
            try {
                String string3;
                byte[] byArray = cdmaSmsAddress.origBytes;
                int n = cdmaSmsAddress.origBytes.length;
                cdmaSmsAddress.address = string3 = new String(byArray, 0, n, "US-ASCII");
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CodingException("invalid SMS address ASCII code");
            }
        }
        byte[] byArray = cdmaSmsAddress.origBytes;
        int n = cdmaSmsAddress.numberOfDigits;
        cdmaSmsAddress.address = string2 = BearerData.decodeDtmfSmsAddress(byArray, n);
    }

    private static boolean decodeUserData(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException {
        int n;
        int n2;
        UserData userData;
        int n3 = bitwiseInputStream.read(8) * 8;
        UserData userData2 = bearerData.userData = (userData = new UserData());
        userData2.msgEncoding = n2 = bitwiseInputStream.read(5);
        bearerData.userData.msgEncodingSet = true;
        bearerData.userData.msgType = 0;
        int n4 = 5;
        if (bearerData.userData.msgEncoding == 1 || bearerData.userData.msgEncoding == 10) {
            int n5;
            UserData userData3 = bearerData.userData;
            userData3.msgType = n5 = bitwiseInputStream.read(8);
            n4 = 5 + 8;
        }
        UserData userData4 = bearerData.userData;
        userData4.numFields = n = bitwiseInputStream.read(8);
        int n6 = n4 + 8;
        int n7 = n3 - n6;
        UserData userData5 = bearerData.userData;
        byte[] byArray = bitwiseInputStream.readByteArray(n7);
        userData5.payload = byArray;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void decodeUserDataPayload(UserData userData, boolean bl) throws CodingException {
        String string2;
        int n = 0;
        if (bl) {
            SmsHeader smsHeader;
            int n2 = userData.payload[0] & 0xFF;
            int n3 = n2 + 1;
            n = 0 + n3;
            byte[] byArray = new byte[n2];
            System.arraycopy(userData.payload, 1, byArray, 0, n2);
            userData.userDataHeader = smsHeader = SmsHeader.fromByteArray(byArray);
        }
        switch (userData.msgEncoding) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("unsupported user data encoding (");
                int n4 = userData.msgEncoding;
                String string3 = stringBuilder.append(n4).append(")").toString();
                throw new CodingException(string3);
            }
            case 0: {
                String string4;
                byte[] byArray = new byte[userData.numFields];
                int n5 = userData.numFields;
                int n6 = userData.payload.length;
                int n7 = n5 < n6 ? userData.numFields : userData.payload.length;
                System.arraycopy(userData.payload, 0, byArray, 0, n7);
                byte[] byArray2 = userData.payload = byArray;
                int n8 = userData.numFields;
                userData.payloadStr = string4 = BearerData.decodeLatin(byArray2, n, n8);
                return;
            }
            case 2: 
            case 3: {
                String string5;
                byte[] byArray = userData.payload;
                int n9 = userData.numFields;
                userData.payloadStr = string5 = BearerData.decode7bitAscii(byArray, n, n9);
                return;
            }
            case 4: {
                String string6;
                byte[] byArray = userData.payload;
                int n10 = userData.numFields;
                userData.payloadStr = string6 = BearerData.decodeUtf16(byArray, n, n10);
                return;
            }
            case 9: {
                String string7;
                byte[] byArray = userData.payload;
                int n11 = userData.numFields;
                userData.payloadStr = string7 = BearerData.decode7bitGsm(byArray, n, n11);
                return;
            }
            case 8: 
        }
        byte[] byArray = userData.payload;
        int n12 = userData.numFields;
        userData.payloadStr = string2 = BearerData.decodeLatin(byArray, n, n12);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeUserResponseCode(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.userResponseCode = n2 = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("USER_REPONSE_CODE decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.userResponseCodeSet = bl;
        return bl;
    }

    private static String decodeUtf16(byte[] byArray, int n, int n2) throws CodingException {
        int n3 = n % 2;
        int n4 = (n + n3) / 2;
        int n5 = n2 - n4;
        try {
            int n6 = n5 * 2;
            String string2 = new String(byArray, n, n6, "utf-16be");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = "UTF-16 decode failed: " + unsupportedEncodingException;
            throw new CodingException(string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeValidityAbs(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 48) {
            TimeStamp timeStamp;
            n += -48;
            bl = true;
            bearerData.validityPeriodAbsolute = timeStamp = TimeStamp.fromByteArray(bitwiseInputStream.readByteArray(48));
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("VALIDITY_PERIOD_ABSOLUTE decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n2 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeValidityRel(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        boolean bl = false;
        int n = bitwiseInputStream.read(8) * 8;
        if (n >= 8) {
            int n2;
            n += -8;
            bl = true;
            bearerData.deferredDeliveryTimeRelative = n2 = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            String string2 = LOG_TAG;
            StringBuilder stringBuilder = new StringBuilder().append("VALIDITY_PERIOD_RELATIVE decode ");
            String string3 = bl ? "succeeded" : "failed";
            String string4 = stringBuilder.append(string3).append(" (extra bits = ").append(n).append(")").toString();
            int n3 = Log.d(string2, string4);
        }
        bitwiseInputStream.skip(n);
        bearerData.deferredDeliveryTimeRelativeSet = bl;
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encode(BearerData bearerData) {
        boolean bl = bearerData.userData != null && bearerData.userData.userDataHeader != null;
        bearerData.hasUserDataHeader = bl;
        try {
            byte[] byArray;
            BitwiseOutputStream bitwiseOutputStream = new BitwiseOutputStream(200);
            bitwiseOutputStream.write(8, 0);
            BearerData.encodeMessageId(bearerData, bitwiseOutputStream);
            if (bearerData.userData != null) {
                bitwiseOutputStream.write(8, 1);
                BearerData.encodeUserData(bearerData, bitwiseOutputStream);
            }
            if (bearerData.callbackNumber != null) {
                bitwiseOutputStream.write(8, 14);
                BearerData.encodeCallbackNumber(bearerData, bitwiseOutputStream);
            }
            if (bearerData.userAckReq || bearerData.deliveryAckReq || bearerData.readAckReq || bearerData.reportReq) {
                bitwiseOutputStream.write(8, 10);
                BearerData.encodeReplyOption(bearerData, bitwiseOutputStream);
            }
            if (bearerData.numberOfMessages != 0) {
                bitwiseOutputStream.write(8, 11);
                BearerData.encodeMsgCount(bearerData, bitwiseOutputStream);
            }
            if (bearerData.validityPeriodRelativeSet) {
                bitwiseOutputStream.write(8, 5);
                BearerData.encodeValidityPeriodRel(bearerData, bitwiseOutputStream);
            }
            if (bearerData.privacyIndicatorSet) {
                bitwiseOutputStream.write(8, 9);
                BearerData.encodePrivacyIndicator(bearerData, bitwiseOutputStream);
            }
            if (bearerData.languageIndicatorSet) {
                bitwiseOutputStream.write(8, 13);
                BearerData.encodeLanguageIndicator(bearerData, bitwiseOutputStream);
            }
            if (bearerData.displayModeSet) {
                bitwiseOutputStream.write(8, 15);
                BearerData.encodeDisplayMode(bearerData, bitwiseOutputStream);
            }
            if (bearerData.priorityIndicatorSet) {
                bitwiseOutputStream.write(8, 8);
                BearerData.encodePriorityIndicator(bearerData, bitwiseOutputStream);
            }
            if (bearerData.alertIndicatorSet) {
                bitwiseOutputStream.write(8, 12);
                BearerData.encodeMsgDeliveryAlert(bearerData, bitwiseOutputStream);
            }
            if (!bearerData.messageStatusSet) return byArray;
            bitwiseOutputStream.write(8, 20);
            BearerData.encodeMsgStatus(bearerData, bitwiseOutputStream);
            byArray = bitwiseOutputStream.toByteArray();
            return byArray;
        }
        catch (BitwiseOutputStream.AccessException accessException) {
            String string2 = "BearerData encode failed: " + accessException;
            int n = Log.e(LOG_TAG, string2);
            return null;
            catch (CodingException codingException) {
                String string3 = "BearerData encode failed: " + codingException;
                int n2 = Log.e(LOG_TAG, string3);
            }
            return null;
        }
    }

    private static void encode16bitEms(UserData userData, byte[] byArray) throws CodingException {
        byte by;
        int n;
        byte[] byArray2 = BearerData.encodeUtf16(userData.payloadStr);
        int n2 = byArray.length + 1;
        int n3 = (n2 + 1) / 2;
        int n4 = n2 % 2;
        int n5 = byArray2.length / 2;
        userData.msgEncoding = 4;
        userData.msgEncodingSet = true;
        userData.numFields = n = n3 + n5;
        byte[] byArray3 = new byte[userData.numFields * 2];
        byte[] byArray4 = userData.payload = byArray3;
        byArray4[0] = by = (byte)byArray.length;
        byte[] byArray5 = userData.payload;
        int n6 = byArray.length;
        System.arraycopy(byArray, 0, byArray5, 1, n6);
        byte[] byArray6 = userData.payload;
        int n7 = n2 + n4;
        int n8 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray6, n7, n8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] encode7bitAscii(String string2, boolean bl) throws CodingException {
        try {
            int n = string2.length();
            BitwiseOutputStream bitwiseOutputStream = new BitwiseOutputStream(n);
            int n2 = string2.length();
            int n3 = 0;
            while (n3 < n2) {
                SparseIntArray sparseIntArray = UserData.charToAscii;
                char c = string2.charAt(n3);
                int n4 = sparseIntArray.get(c, -1);
                if (n4 == -1) {
                    if (!bl) {
                        StringBuilder stringBuilder = new StringBuilder().append("cannot ASCII encode (");
                        char c2 = string2.charAt(n3);
                        String string3 = stringBuilder.append(c2).append(")").toString();
                        throw new CodingException(string3);
                    }
                    bitwiseOutputStream.write(7, 32);
                } else {
                    int n5 = 7;
                    bitwiseOutputStream.write(n5, n4);
                }
                ++n3;
            }
            return bitwiseOutputStream.toByteArray();
        }
        catch (BitwiseOutputStream.AccessException accessException) {
            String string4 = "7bit ASCII encode failed: " + accessException;
            throw new CodingException(string4);
        }
    }

    private static void encode7bitEms(UserData userData, byte[] byArray, boolean bl) throws CodingException {
        byte by;
        int n;
        int n2 = ((byArray.length + 1) * 8 + 6) / 7;
        Gsm7bitCodingResult gsm7bitCodingResult = BearerData.encode7bitGsm(userData.payloadStr, n2, bl);
        userData.msgEncoding = 9;
        userData.msgEncodingSet = true;
        userData.numFields = n = gsm7bitCodingResult.septets;
        byte[] byArray2 = gsm7bitCodingResult.data;
        byte[] byArray3 = userData.payload = byArray2;
        byArray3[0] = by = (byte)byArray.length;
        byte[] byArray4 = userData.payload;
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray4, 1, n3);
    }

    private static Gsm7bitCodingResult encode7bitGsm(String string2, int n, boolean bl) throws CodingException {
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        try {
            int n2;
            byte[] byArray = GsmAlphabet.stringToGsm7BitPacked(string2, n, bl2);
            Gsm7bitCodingResult gsm7bitCodingResult = new Gsm7bitCodingResult();
            byte[] byArray2 = new byte[byArray.length - 1];
            byte[] byArray3 = gsm7bitCodingResult.data = byArray2;
            int n3 = byArray.length - 1;
            System.arraycopy(byArray, 1, byArray3, 0, n3);
            gsm7bitCodingResult.septets = n2 = byArray[0] & 0xFF;
            return gsm7bitCodingResult;
        }
        catch (EncodeException encodeException) {
            String string3 = "7bit GSM encode failed: " + encodeException;
            throw new CodingException(string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeCallbackNumber(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException, CodingException {
        int n;
        CdmaSmsAddress cdmaSmsAddress = bearerData.callbackNumber;
        BearerData.encodeCdmaSmsAddress(cdmaSmsAddress);
        int n2 = 9;
        if (cdmaSmsAddress.digitMode == 1) {
            n2 = 9 + 7;
            n = cdmaSmsAddress.numberOfDigits * 8;
        } else {
            n = cdmaSmsAddress.numberOfDigits * 4;
        }
        int n3 = n2 + n;
        int n4 = n3 / 8;
        int n5 = n3 % 8 > 0 ? 1 : 0;
        int n6 = n4 + n5;
        int n7 = n6 * 8 - n3;
        bitwiseOutputStream.write(8, n6);
        int n8 = cdmaSmsAddress.digitMode;
        bitwiseOutputStream.write(1, n8);
        if (cdmaSmsAddress.digitMode == 1) {
            int n9 = cdmaSmsAddress.ton;
            bitwiseOutputStream.write(3, n9);
            int n10 = cdmaSmsAddress.numberPlan;
            bitwiseOutputStream.write(4, n10);
        }
        int n11 = cdmaSmsAddress.numberOfDigits;
        bitwiseOutputStream.write(8, n11);
        byte[] byArray = cdmaSmsAddress.origBytes;
        bitwiseOutputStream.writeByteArray(n, byArray);
        if (n7 <= 0) {
            return;
        }
        bitwiseOutputStream.write(n7, 0);
    }

    private static void encodeCdmaSmsAddress(CdmaSmsAddress cdmaSmsAddress) throws CodingException {
        if (cdmaSmsAddress.digitMode == 1) {
            try {
                byte[] byArray = cdmaSmsAddress.address.getBytes("US-ASCII");
                cdmaSmsAddress.origBytes = byArray;
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CodingException("invalid SMS address, cannot convert to ASCII");
            }
        }
        byte[] byArray = BearerData.encodeDtmfSmsAddress(cdmaSmsAddress.address);
        cdmaSmsAddress.origBytes = byArray;
    }

    private static void encodeDisplayMode(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.displayMode;
        bitwiseOutputStream.write(2, n);
        bitwiseOutputStream.skip(6);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] encodeDtmfSmsAddress(String string2) {
        int n = string2.length();
        int n2 = n * 4;
        int n3 = n2 / 8;
        int n4 = n2 % 8 > 0 ? 1 : 0;
        byte[] byArray = new byte[n3 + n4];
        int n5 = 0;
        while (n5 < n) {
            byte by;
            int n6;
            char c = string2.charAt(n5);
            if (c >= '1' && c <= '9') {
                n6 = c - 48;
            } else if (c == '0') {
                n6 = 10;
            } else if (c == '*') {
                n6 = 11;
            } else {
                if (c != '#') {
                    return null;
                }
                n6 = 12;
            }
            int n7 = n5 / 2;
            byte by2 = byArray[n7];
            int n8 = n5 % 2 * 4;
            int n9 = 4 - n8;
            int n10 = n6 << n9;
            byArray[n7] = by = (byte)(by2 | n10);
            ++n5;
        }
        return byArray;
    }

    private static void encodeEmsUserDataPayload(UserData userData) throws CodingException {
        byte[] byArray = SmsHeader.toByteArray(userData.userDataHeader);
        if (userData.msgEncodingSet) {
            if (userData.msgEncoding == 9) {
                BearerData.encode7bitEms(userData, byArray, true);
                return;
            }
            if (userData.msgEncoding == 4) {
                BearerData.encode16bitEms(userData, byArray);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("unsupported EMS user data encoding (");
            int n = userData.msgEncoding;
            String string2 = stringBuilder.append(n).append(")").toString();
            throw new CodingException(string2);
        }
        boolean bl = false;
        try {
            BearerData.encode7bitEms(userData, byArray, bl);
            return;
        }
        catch (CodingException codingException) {
            BearerData.encode16bitEms(userData, byArray);
            return;
        }
    }

    private static void encodeLanguageIndicator(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.language;
        bitwiseOutputStream.write(8, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeMessageId(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 3);
        int n = bearerData.messageType;
        bitwiseOutputStream.write(4, n);
        int n2 = bearerData.messageId >> 8;
        bitwiseOutputStream.write(8, n2);
        int n3 = bearerData.messageId;
        bitwiseOutputStream.write(8, n3);
        int n4 = bearerData.hasUserDataHeader ? 1 : 0;
        bitwiseOutputStream.write(1, n4);
        bitwiseOutputStream.skip(3);
    }

    private static void encodeMsgCount(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.numberOfMessages;
        bitwiseOutputStream.write(8, n);
    }

    private static void encodeMsgDeliveryAlert(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.alert;
        bitwiseOutputStream.write(2, n);
        bitwiseOutputStream.skip(6);
    }

    private static void encodeMsgStatus(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.errorClass;
        bitwiseOutputStream.write(2, n);
        int n2 = bearerData.messageStatus;
        bitwiseOutputStream.write(6, n2);
    }

    private static void encodePriorityIndicator(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.priority;
        bitwiseOutputStream.write(2, n);
        bitwiseOutputStream.skip(6);
    }

    private static void encodePrivacyIndicator(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.privacy;
        bitwiseOutputStream.write(2, n);
        bitwiseOutputStream.skip(6);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeReplyOption(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.userAckReq ? 1 : 0;
        bitwiseOutputStream.write(1, n);
        int n2 = bearerData.deliveryAckReq ? 1 : 0;
        bitwiseOutputStream.write(1, n2);
        int n3 = bearerData.readAckReq ? 1 : 0;
        bitwiseOutputStream.write(1, n3);
        int n4 = bearerData.reportReq ? 1 : 0;
        bitwiseOutputStream.write(1, n4);
        bitwiseOutputStream.write(4, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeUserData(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException, CodingException {
        BearerData.encodeUserDataPayload(bearerData.userData);
        boolean bl = bearerData.userData.userDataHeader != null;
        bearerData.hasUserDataHeader = bl;
        if (bearerData.userData.payload.length > 140) {
            StringBuilder stringBuilder = new StringBuilder().append("encoded user data too large (");
            int n = bearerData.userData.payload.length;
            String string2 = stringBuilder.append(n).append(" > ").append(140).append(" bytes)").toString();
            throw new CodingException(string2);
        }
        int n = bearerData.userData.payload.length * 8;
        int n2 = bearerData.userData.paddingBits;
        int n3 = n - n2;
        int n4 = n3 + 13;
        if (bearerData.userData.msgEncoding == 1 || bearerData.userData.msgEncoding == 10) {
            n4 += 8;
        }
        int n5 = n4 / 8;
        int n6 = n4 % 8 > 0 ? 1 : 0;
        int n7 = n5 + n6;
        int n8 = n7 * 8 - n4;
        bitwiseOutputStream.write(8, n7);
        int n9 = bearerData.userData.msgEncoding;
        bitwiseOutputStream.write(5, n9);
        if (bearerData.userData.msgEncoding == 1 || bearerData.userData.msgEncoding == 10) {
            int n10 = bearerData.userData.msgType;
            bitwiseOutputStream.write(8, n10);
        }
        int n11 = bearerData.userData.numFields;
        bitwiseOutputStream.write(8, n11);
        byte[] byArray = bearerData.userData.payload;
        bitwiseOutputStream.writeByteArray(n3, byArray);
        if (n8 <= 0) {
            return;
        }
        bitwiseOutputStream.write(n8, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void encodeUserDataPayload(UserData userData) throws CodingException {
        int n;
        if (userData.payloadStr == null && userData.msgEncoding != 0) {
            int n2 = Log.e(LOG_TAG, "user data with null payloadStr");
            userData.payloadStr = "";
        }
        if (userData.userDataHeader != null) {
            BearerData.encodeEmsUserDataPayload(userData);
            return;
        }
        if (userData.msgEncodingSet) {
            if (userData.msgEncoding == 0) {
                int n3;
                byte[] byArray;
                if (userData.payload == null) {
                    int n4 = Log.e(LOG_TAG, "user data with octet encoding but null payload");
                    byte[] byArray2 = new byte[]{};
                    userData.payload = byArray2;
                    userData.numFields = 0;
                    return;
                }
                userData.payload = byArray = userData.payload;
                userData.numFields = n3 = userData.payload.length;
                return;
            }
            if (userData.payloadStr == null) {
                int n5 = Log.e(LOG_TAG, "non-octet user data with null payloadStr");
                userData.payloadStr = "";
            }
            if (userData.msgEncoding == 9) {
                int n6;
                Gsm7bitCodingResult gsm7bitCodingResult = BearerData.encode7bitGsm(userData.payloadStr, 0, true);
                byte[] byArray = gsm7bitCodingResult.data;
                userData.payload = byArray;
                userData.numFields = n6 = gsm7bitCodingResult.septets;
                return;
            }
            if (userData.msgEncoding == 2) {
                int n7;
                byte[] byArray = BearerData.encode7bitAscii(userData.payloadStr, true);
                userData.payload = byArray;
                userData.numFields = n7 = userData.payloadStr.length();
                return;
            }
            if (userData.msgEncoding == 4) {
                int n8;
                byte[] byArray = BearerData.encodeUtf16(userData.payloadStr);
                userData.payload = byArray;
                userData.numFields = n8 = userData.payloadStr.length();
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("unsupported user data encoding (");
            int n9 = userData.msgEncoding;
            String string2 = stringBuilder.append(n9).append(")").toString();
            throw new CodingException(string2);
        }
        try {
            byte[] byArray = BearerData.encode7bitAscii(userData.payloadStr, false);
            userData.payload = byArray;
            userData.msgEncoding = 2;
        }
        catch (CodingException codingException) {
            byte[] byArray = BearerData.encodeUtf16(userData.payloadStr);
            userData.payload = byArray;
            userData.msgEncoding = 4;
        }
        userData.numFields = n = userData.payloadStr.length();
        userData.msgEncodingSet = true;
    }

    private static byte[] encodeUtf16(String string2) throws CodingException {
        try {
            byte[] byArray = string2.getBytes("utf-16be");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = "UTF-16 encode failed: " + unsupportedEncodingException;
            throw new CodingException(string3);
        }
    }

    private static void encodeValidityPeriodRel(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.validityPeriodRelative;
        bitwiseOutputStream.write(8, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("BearerData ");
        StringBuilder stringBuilder3 = new StringBuilder().append("{ messageType=");
        int n = this.messageType;
        String string2 = stringBuilder3.append(n).toString();
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        StringBuilder stringBuilder5 = new StringBuilder().append(", messageId=");
        int n2 = this.messageId;
        String string3 = stringBuilder5.append(n2).toString();
        StringBuilder stringBuilder6 = stringBuilder.append(string3);
        StringBuilder stringBuilder7 = new StringBuilder().append(", priority=");
        Object object = this.priorityIndicatorSet ? Integer.valueOf(this.priority) : "unset";
        String string4 = stringBuilder7.append(object).toString();
        StringBuilder stringBuilder8 = stringBuilder.append(string4);
        StringBuilder stringBuilder9 = new StringBuilder().append(", privacy=");
        Object object2 = this.privacyIndicatorSet ? Integer.valueOf(this.privacy) : "unset";
        String string5 = stringBuilder9.append(object2).toString();
        StringBuilder stringBuilder10 = stringBuilder.append(string5);
        StringBuilder stringBuilder11 = new StringBuilder().append(", alert=");
        Object object3 = this.alertIndicatorSet ? Integer.valueOf(this.alert) : "unset";
        String string6 = stringBuilder11.append(object3).toString();
        StringBuilder stringBuilder12 = stringBuilder.append(string6);
        StringBuilder stringBuilder13 = new StringBuilder().append(", displayMode=");
        Object object4 = this.displayModeSet ? Integer.valueOf(this.displayMode) : "unset";
        String string7 = stringBuilder13.append(object4).toString();
        StringBuilder stringBuilder14 = stringBuilder.append(string7);
        StringBuilder stringBuilder15 = new StringBuilder().append(", language=");
        Object object5 = this.languageIndicatorSet ? Integer.valueOf(this.language) : "unset";
        String string8 = stringBuilder15.append(object5).toString();
        StringBuilder stringBuilder16 = stringBuilder.append(string8);
        StringBuilder stringBuilder17 = new StringBuilder().append(", errorClass=");
        Object object6 = this.messageStatusSet ? Integer.valueOf(this.errorClass) : "unset";
        String string9 = stringBuilder17.append(object6).toString();
        StringBuilder stringBuilder18 = stringBuilder.append(string9);
        StringBuilder stringBuilder19 = new StringBuilder().append(", msgStatus=");
        Object object7 = this.messageStatusSet ? Integer.valueOf(this.messageStatus) : "unset";
        String string10 = stringBuilder19.append(object7).toString();
        StringBuilder stringBuilder20 = stringBuilder.append(string10);
        StringBuilder stringBuilder21 = new StringBuilder().append(", msgCenterTimeStamp=");
        Object object8 = this.msgCenterTimeStamp != null ? this.msgCenterTimeStamp : "unset";
        String string11 = stringBuilder21.append(object8).toString();
        StringBuilder stringBuilder22 = stringBuilder.append(string11);
        StringBuilder stringBuilder23 = new StringBuilder().append(", validityPeriodAbsolute=");
        Object object9 = this.validityPeriodAbsolute != null ? this.validityPeriodAbsolute : "unset";
        String string12 = stringBuilder23.append(object9).toString();
        StringBuilder stringBuilder24 = stringBuilder.append(string12);
        StringBuilder stringBuilder25 = new StringBuilder().append(", validityPeriodRelative=");
        Object object10 = this.validityPeriodRelativeSet ? Integer.valueOf(this.validityPeriodRelative) : "unset";
        String string13 = stringBuilder25.append(object10).toString();
        StringBuilder stringBuilder26 = stringBuilder.append(string13);
        StringBuilder stringBuilder27 = new StringBuilder().append(", deferredDeliveryTimeAbsolute=");
        Object object11 = this.deferredDeliveryTimeAbsolute != null ? this.deferredDeliveryTimeAbsolute : "unset";
        String string14 = stringBuilder27.append(object11).toString();
        StringBuilder stringBuilder28 = stringBuilder.append(string14);
        StringBuilder stringBuilder29 = new StringBuilder().append(", deferredDeliveryTimeRelative=");
        Object object12 = this.deferredDeliveryTimeRelativeSet ? Integer.valueOf(this.deferredDeliveryTimeRelative) : "unset";
        String string15 = stringBuilder29.append(object12).toString();
        StringBuilder stringBuilder30 = stringBuilder.append(string15);
        StringBuilder stringBuilder31 = new StringBuilder().append(", userAckReq=");
        boolean bl = this.userAckReq;
        String string16 = stringBuilder31.append(bl).toString();
        StringBuilder stringBuilder32 = stringBuilder.append(string16);
        StringBuilder stringBuilder33 = new StringBuilder().append(", deliveryAckReq=");
        boolean bl2 = this.deliveryAckReq;
        String string17 = stringBuilder33.append(bl2).toString();
        StringBuilder stringBuilder34 = stringBuilder.append(string17);
        StringBuilder stringBuilder35 = new StringBuilder().append(", readAckReq=");
        boolean bl3 = this.readAckReq;
        String string18 = stringBuilder35.append(bl3).toString();
        StringBuilder stringBuilder36 = stringBuilder.append(string18);
        StringBuilder stringBuilder37 = new StringBuilder().append(", reportReq=");
        boolean bl4 = this.reportReq;
        String string19 = stringBuilder37.append(bl4).toString();
        StringBuilder stringBuilder38 = stringBuilder.append(string19);
        StringBuilder stringBuilder39 = new StringBuilder().append(", numberOfMessages=");
        int n3 = this.numberOfMessages;
        String string20 = stringBuilder39.append(n3).toString();
        StringBuilder stringBuilder40 = stringBuilder.append(string20);
        StringBuilder stringBuilder41 = new StringBuilder().append(", callbackNumber=");
        CdmaSmsAddress cdmaSmsAddress = this.callbackNumber;
        String string21 = stringBuilder41.append(cdmaSmsAddress).toString();
        StringBuilder stringBuilder42 = stringBuilder.append(string21);
        StringBuilder stringBuilder43 = new StringBuilder().append(", depositIndex=");
        int n4 = this.depositIndex;
        String string22 = stringBuilder43.append(n4).toString();
        StringBuilder stringBuilder44 = stringBuilder.append(string22);
        StringBuilder stringBuilder45 = new StringBuilder().append(", hasUserDataHeader=");
        boolean bl5 = this.hasUserDataHeader;
        String string23 = stringBuilder45.append(bl5).toString();
        StringBuilder stringBuilder46 = stringBuilder.append(string23);
        StringBuilder stringBuilder47 = new StringBuilder().append(", userData=");
        UserData userData = this.userData;
        String string24 = stringBuilder47.append(userData).toString();
        StringBuilder stringBuilder48 = stringBuilder.append(string24);
        StringBuilder stringBuilder49 = stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private static class Gsm7bitCodingResult {
        byte[] data;
        int septets;

        private Gsm7bitCodingResult() {
        }
    }

    private static class CodingException
    extends Exception {
        public CodingException(String string2) {
            super(string2);
        }
    }

    public static class TimeStamp
    extends Time {
        public TimeStamp() {
            super("UTC");
        }

        /*
         * Enabled aggressive block sorting
         */
        public static TimeStamp fromByteArray(byte[] byArray) {
            int n;
            TimeStamp timeStamp = new TimeStamp();
            int n2 = IccUtils.cdmaBcdByteToInt(byArray[0]);
            if (n2 > 99) return null;
            if (n2 < 0) {
                return null;
            }
            int n3 = n2 >= 96 ? n2 + 1900 : n2 + 2000;
            timeStamp.year = n3;
            int n4 = IccUtils.cdmaBcdByteToInt(byArray[1]);
            if (n4 < 1) return null;
            if (n4 > 12) {
                return null;
            }
            timeStamp.month = n = n4 - 1;
            int n5 = IccUtils.cdmaBcdByteToInt(byArray[2]);
            if (n5 < 1) return null;
            if (n5 > 31) {
                return null;
            }
            timeStamp.monthDay = n5;
            int n6 = IccUtils.cdmaBcdByteToInt(byArray[3]);
            if (n6 < 0) return null;
            if (n6 > 23) {
                return null;
            }
            timeStamp.hour = n6;
            int n7 = IccUtils.cdmaBcdByteToInt(byArray[4]);
            if (n7 < 0) return null;
            if (n7 > 59) {
                return null;
            }
            timeStamp.minute = n7;
            int n8 = IccUtils.cdmaBcdByteToInt(byArray[5]);
            if (n8 < 0) return null;
            if (n8 > 59) return null;
            timeStamp.second = n8;
            return timeStamp;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append("TimeStamp ");
            StringBuilder stringBuilder3 = new StringBuilder().append("{ year=");
            int n = this.year;
            String string2 = stringBuilder3.append(n).toString();
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
            StringBuilder stringBuilder5 = new StringBuilder().append(", month=");
            int n2 = this.month;
            String string3 = stringBuilder5.append(n2).toString();
            StringBuilder stringBuilder6 = stringBuilder.append(string3);
            StringBuilder stringBuilder7 = new StringBuilder().append(", day=");
            int n3 = this.monthDay;
            String string4 = stringBuilder7.append(n3).toString();
            StringBuilder stringBuilder8 = stringBuilder.append(string4);
            StringBuilder stringBuilder9 = new StringBuilder().append(", hour=");
            int n4 = this.hour;
            String string5 = stringBuilder9.append(n4).toString();
            StringBuilder stringBuilder10 = stringBuilder.append(string5);
            StringBuilder stringBuilder11 = new StringBuilder().append(", minute=");
            int n5 = this.minute;
            String string6 = stringBuilder11.append(n5).toString();
            StringBuilder stringBuilder12 = stringBuilder.append(string6);
            StringBuilder stringBuilder13 = new StringBuilder().append(", second=");
            int n6 = this.second;
            String string7 = stringBuilder13.append(n6).toString();
            StringBuilder stringBuilder14 = stringBuilder.append(string7);
            StringBuilder stringBuilder15 = stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }
}

