/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma.sms;

import android.util.SparseBooleanArray;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;

public class CdmaSmsAddress
extends SmsAddress {
    public static final int DIGIT_MODE_4BIT_DTMF = 0;
    public static final int DIGIT_MODE_8BIT_CHAR = 1;
    public static final int NUMBERING_PLAN_ISDN_TELEPHONY = 1;
    public static final int NUMBERING_PLAN_UNKNOWN = 0;
    public static final int NUMBER_MODE_DATA_NETWORK = 1;
    public static final int NUMBER_MODE_NOT_DATA_NETWORK = 0;
    public static final int SMS_ADDRESS_MAX = 36;
    public static final int SMS_SUBADDRESS_MAX = 36;
    public static final int TON_ABBREVIATED = 6;
    public static final int TON_ALPHANUMERIC = 5;
    public static final int TON_INTERNATIONAL_OR_IP = 1;
    public static final int TON_NATIONAL_OR_EMAIL = 2;
    public static final int TON_NETWORK = 3;
    public static final int TON_RESERVED = 7;
    public static final int TON_SUBSCRIBER = 4;
    public static final int TON_UNKNOWN;
    private static final SparseBooleanArray numericCharDialableMap;
    private static final char[] numericCharsDialable;
    private static final char[] numericCharsSugar;
    public int digitMode;
    public int numberMode;
    public int numberOfDigits;
    public int numberPlan;

    static {
        int n;
        numericCharsDialable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#'};
        numericCharsSugar = new char[]{'(', ')', ' ', '-', '+', '.', '/', '\\'};
        int n2 = numericCharsDialable.length;
        int n3 = numericCharsSugar.length;
        int n4 = n2 + n3;
        numericCharDialableMap = new SparseBooleanArray(n4);
        for (int i = 0; i < (n = numericCharsDialable.length); ++i) {
            SparseBooleanArray sparseBooleanArray = numericCharDialableMap;
            char c = numericCharsDialable[i];
            sparseBooleanArray.put(c, true);
        }
        int n5 = 0;
        int n6;
        while (n5 < (n6 = numericCharsSugar.length)) {
            SparseBooleanArray sparseBooleanArray = numericCharDialableMap;
            char c = numericCharsSugar[n5];
            sparseBooleanArray.put(c, false);
            ++n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String filterNumericSugar(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            int n3 = numericCharDialableMap.indexOfKey(c);
            if (n3 < 0) {
                return null;
            }
            if (numericCharDialableMap.valueAt(n3)) {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String filterWhitespace(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t') {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CdmaSmsAddress parse(String string2) {
        int n;
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        cdmaSmsAddress.address = string2;
        cdmaSmsAddress.ton = 0;
        byte[] byArray = null;
        String string3 = CdmaSmsAddress.filterNumericSugar(string2);
        if (string3 != null) {
            byArray = CdmaSmsAddress.parseToDtmf(string3);
        }
        if (byArray != null) {
            cdmaSmsAddress.digitMode = 0;
            cdmaSmsAddress.numberMode = 0;
            if (string2.indexOf(43) != -1) {
                cdmaSmsAddress.ton = 1;
            }
        } else {
            byArray = UserData.stringToAscii(CdmaSmsAddress.filterWhitespace(string2));
            if (byArray == null) {
                return null;
            }
            cdmaSmsAddress.digitMode = 1;
            cdmaSmsAddress.numberMode = 1;
            if (string2.indexOf(64) != -1) {
                cdmaSmsAddress.ton = 2;
            }
        }
        cdmaSmsAddress.origBytes = byArray;
        cdmaSmsAddress.numberOfDigits = n = byArray.length;
        return cdmaSmsAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] parseToDtmf(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byte by;
            int n3;
            char c = string2.charAt(n2);
            if (c >= '1' && c <= '9') {
                n3 = c - 48;
            } else if (c == '0') {
                n3 = 10;
            } else if (c == '*') {
                n3 = 11;
            } else {
                if (c != '#') {
                    return null;
                }
                n3 = 12;
            }
            byArray[n2] = by = (byte)n3;
            ++n2;
        }
        return byArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("CdmaSmsAddress ");
        StringBuilder stringBuilder3 = new StringBuilder().append("{ digitMode=");
        int n = this.digitMode;
        String string2 = stringBuilder3.append(n).toString();
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        StringBuilder stringBuilder5 = new StringBuilder().append(", numberMode=");
        int n2 = this.numberMode;
        String string3 = stringBuilder5.append(n2).toString();
        StringBuilder stringBuilder6 = stringBuilder.append(string3);
        StringBuilder stringBuilder7 = new StringBuilder().append(", numberPlan=");
        int n3 = this.numberPlan;
        String string4 = stringBuilder7.append(n3).toString();
        StringBuilder stringBuilder8 = stringBuilder.append(string4);
        StringBuilder stringBuilder9 = new StringBuilder().append(", numberOfDigits=");
        int n4 = this.numberOfDigits;
        String string5 = stringBuilder9.append(n4).toString();
        StringBuilder stringBuilder10 = stringBuilder.append(string5);
        StringBuilder stringBuilder11 = new StringBuilder().append(", ton=");
        int n5 = this.ton;
        String string6 = stringBuilder11.append(n5).toString();
        StringBuilder stringBuilder12 = stringBuilder.append(string6);
        StringBuilder stringBuilder13 = new StringBuilder().append(", address=\"");
        String string7 = this.address;
        String string8 = stringBuilder13.append(string7).append("\"").toString();
        StringBuilder stringBuilder14 = stringBuilder.append(string8);
        StringBuilder stringBuilder15 = new StringBuilder().append(", origBytes=");
        String string9 = HexDump.toHexString(this.origBytes);
        String string10 = stringBuilder15.append(string9).toString();
        StringBuilder stringBuilder16 = stringBuilder.append(string10);
        StringBuilder stringBuilder17 = stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

