/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma.sms;

import android.util.SparseIntArray;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.util.HexDump;

public class UserData {
    public static final int ASCII_CR_INDEX = 13;
    public static final char[] ASCII_MAP;
    public static final int ASCII_MAP_BASE_INDEX = 32;
    public static final int ASCII_MAP_MAX_INDEX = 0;
    public static final int ASCII_NL_INDEX = 10;
    public static final int ENCODING_7BIT_ASCII = 2;
    public static final int ENCODING_GSM_7BIT_ALPHABET = 9;
    public static final int ENCODING_GSM_DCS = 10;
    public static final int ENCODING_IA5 = 3;
    public static final int ENCODING_IS91_EXTENDED_PROTOCOL = 1;
    public static final int ENCODING_LATIN = 8;
    public static final int ENCODING_OCTET = 0;
    public static final int ENCODING_UNICODE_16 = 4;
    public static final int IS91_MSG_TYPE_CLI = 132;
    public static final int IS91_MSG_TYPE_SHORT_MESSAGE = 133;
    public static final int IS91_MSG_TYPE_SHORT_MESSAGE_FULL = 131;
    public static final int IS91_MSG_TYPE_VOICEMAIL_STATUS = 130;
    public static final int PRINTABLE_ASCII_MIN_INDEX = 32;
    static final byte UNENCODABLE_7_BIT_CHAR = 32;
    public static final SparseIntArray charToAscii;
    public int msgEncoding;
    public boolean msgEncodingSet = false;
    public int msgType;
    public int numFields;
    public int paddingBits;
    public byte[] payload;
    public String payloadStr;
    public SmsHeader userDataHeader;

    static {
        int n;
        ASCII_MAP = new char[]{' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~'};
        charToAscii = new SparseIntArray();
        for (int i = 0; i < (n = ASCII_MAP.length); ++i) {
            SparseIntArray sparseIntArray = charToAscii;
            char c = ASCII_MAP[i];
            int n2 = i + 32;
            sparseIntArray.put(c, n2);
        }
        charToAscii.put(10, 10);
        charToAscii.put(13, 13);
        ASCII_MAP_MAX_INDEX = ASCII_MAP.length + 32 - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] stringToAscii(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byte by;
            SparseIntArray sparseIntArray = charToAscii;
            char c = string2.charAt(n2);
            int n3 = sparseIntArray.get(c, -1);
            if (n3 == -1) {
                return null;
            }
            byArray[n2] = by = (byte)n3;
            ++n2;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("UserData ");
        StringBuilder stringBuilder3 = new StringBuilder().append("{ msgEncoding=");
        Object object = this.msgEncodingSet ? Integer.valueOf(this.msgEncoding) : "unset";
        String string2 = stringBuilder3.append(object).toString();
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        StringBuilder stringBuilder5 = new StringBuilder().append(", msgType=");
        int n = this.msgType;
        String string3 = stringBuilder5.append(n).toString();
        StringBuilder stringBuilder6 = stringBuilder.append(string3);
        StringBuilder stringBuilder7 = new StringBuilder().append(", paddingBits=");
        int n2 = this.paddingBits;
        String string4 = stringBuilder7.append(n2).toString();
        StringBuilder stringBuilder8 = stringBuilder.append(string4);
        StringBuilder stringBuilder9 = new StringBuilder().append(", numFields=");
        int n3 = this.numFields;
        String string5 = stringBuilder9.append(n3).toString();
        StringBuilder stringBuilder10 = stringBuilder.append(string5);
        StringBuilder stringBuilder11 = new StringBuilder().append(", userDataHeader=");
        SmsHeader smsHeader = this.userDataHeader;
        String string6 = stringBuilder11.append(smsHeader).toString();
        StringBuilder stringBuilder12 = stringBuilder.append(string6);
        StringBuilder stringBuilder13 = new StringBuilder().append(", payload='");
        String string7 = HexDump.toHexString(this.payload);
        String string8 = stringBuilder13.append(string7).append("'").toString();
        StringBuilder stringBuilder14 = stringBuilder.append(string8);
        StringBuilder stringBuilder15 = new StringBuilder().append(", payloadStr='");
        String string9 = this.payloadStr;
        String string10 = stringBuilder15.append(string9).append("'").toString();
        StringBuilder stringBuilder16 = stringBuilder.append(string10);
        StringBuilder stringBuilder17 = stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

