/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccVmNotSupportedException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import com.android.internal.telephony.gsm.GsmDataConnectionTracker;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import com.android.internal.telephony.gsm.GsmServiceStateTracker;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.SIMRecords;
import com.android.internal.telephony.gsm.SimCard;
import com.android.internal.telephony.gsm.SimPhoneBookInterfaceManager;
import com.android.internal.telephony.gsm.SimSmsInterfaceManager;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.gsm.stk.StkService;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

public class GSMPhone
extends PhoneBase {
    public static final String CIPHERING_KEY = "ciphering_key";
    private static final boolean LOCAL_DEBUG = true;
    static final String LOG_TAG = "GSM";
    public static final String VM_NUMBER = "vm_number_key";
    public static final String VM_SIM_IMSI = "vm_sim_imsi_key";
    Thread debugPortThread;
    ServerSocket debugSocket;
    GsmCallTracker mCT;
    private String mImei;
    private String mImeiSv;
    ArrayList<GsmMmiCode> mPendingMMIs;
    Registrant mPostDialHandler;
    SIMRecords mSIMRecords;
    GsmSMSDispatcher mSMS;
    GsmServiceStateTracker mSST;
    SimCard mSimCard;
    SimPhoneBookInterfaceManager mSimPhoneBookIntManager;
    SimSmsInterfaceManager mSimSmsIntManager;
    RegistrantList mSsnRegistrants;
    StkService mStkService;
    PhoneSubInfo mSubInfo;
    private String mVmNumber;

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this(context, commandsInterface, phoneNotifier, false);
    }

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        super(phoneNotifier, context, commandsInterface, bl);
        StkService stkService;
        SimCard simCard;
        SIMRecords sIMRecords;
        GsmSMSDispatcher gsmSMSDispatcher;
        GsmServiceStateTracker gsmServiceStateTracker;
        GsmCallTracker gsmCallTracker;
        RegistrantList registrantList;
        ArrayList arrayList = new ArrayList();
        this.mPendingMMIs = arrayList;
        this.mSsnRegistrants = registrantList = new RegistrantList();
        if (commandsInterface instanceof SimulatedRadioControl) {
            SimulatedRadioControl simulatedRadioControl;
            this.mSimulatedRadioControl = simulatedRadioControl = (SimulatedRadioControl)((Object)commandsInterface);
        }
        this.mCM.setPhoneType(1);
        this.mCT = gsmCallTracker = new GsmCallTracker(this);
        this.mSST = gsmServiceStateTracker = new GsmServiceStateTracker(this);
        this.mSMS = gsmSMSDispatcher = new GsmSMSDispatcher(this);
        SIMFileHandler sIMFileHandler = new SIMFileHandler(this);
        this.mIccFileHandler = sIMFileHandler;
        this.mSIMRecords = sIMRecords = new SIMRecords(this);
        GsmDataConnectionTracker gsmDataConnectionTracker = new GsmDataConnectionTracker(this);
        this.mDataConnection = gsmDataConnectionTracker;
        this.mSimCard = simCard = new SimCard(this);
        if (!bl) {
            PhoneSubInfo phoneSubInfo;
            SimSmsInterfaceManager simSmsInterfaceManager;
            SimPhoneBookInterfaceManager simPhoneBookInterfaceManager;
            this.mSimPhoneBookIntManager = simPhoneBookInterfaceManager = new SimPhoneBookInterfaceManager(this);
            GsmSMSDispatcher gsmSMSDispatcher2 = this.mSMS;
            this.mSimSmsIntManager = simSmsInterfaceManager = new SimSmsInterfaceManager(this, gsmSMSDispatcher2);
            this.mSubInfo = phoneSubInfo = new PhoneSubInfo(this);
        }
        CommandsInterface commandsInterface2 = this.mCM;
        SIMRecords sIMRecords2 = this.mSIMRecords;
        Context context2 = this.mContext;
        SIMFileHandler sIMFileHandler2 = (SIMFileHandler)this.mIccFileHandler;
        SimCard simCard2 = this.mSimCard;
        this.mStkService = stkService = StkService.getInstance(commandsInterface2, sIMRecords2, context2, sIMFileHandler2, simCard2);
        this.mCM.registerForAvailable(this, 1, null);
        this.mSIMRecords.registerForRecordsLoaded(this, 3, null);
        this.mCM.registerForOffOrNotAvailable(this, 8, null);
        this.mCM.registerForOn(this, 5, null);
        this.mCM.setOnUSSD(this, 7, null);
        this.mCM.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttach(this, 19, null);
        String string2 = new Integer(1).toString();
        SystemProperties.set("gsm.current.phone-type", string2);
    }

    private String getVmSimImsi() {
        return PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(VM_SIM_IMSI, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCallDeflectionIncallSupplementaryService(String string2) throws CallStateException {
        Call.State state;
        Call.State state2;
        if (string2.length() > 1) {
            return false;
        }
        Call.State state3 = this.getRingingCall().getState();
        if (state3 != (state2 = Call.State.IDLE)) {
            int n = Log.d(LOG_TAG, "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException callStateException) {
                int n2 = Log.d(LOG_TAG, "reject failed", callStateException);
                Phone.SuppService suppService = Phone.SuppService.REJECT;
                this.notifySuppServiceFailed(suppService);
                return true;
            }
            return true;
        }
        Call.State state4 = this.getBackgroundCall().getState();
        if (state4 == (state = Call.State.IDLE)) return true;
        int n = Log.d(LOG_TAG, "MmiCode 0: hangupWaitingOrBackground");
        this.mCT.hangupWaitingOrBackground();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleCallHoldIncallSupplementaryService(String string2) throws CallStateException {
        int n = string2.length();
        if (n > 2) {
            return false;
        }
        Call call = this.getForegroundCall();
        if (n > 1) {
            int n2 = 1;
            try {
                int n3 = string2.charAt(n2) - 48;
                GsmConnection gsmConnection = this.mCT.getConnectionByIndex((GsmCall)call, n3);
                if (gsmConnection != null && n3 >= 1 && n3 <= 7) {
                    String string3 = "MmiCode 2: separate call " + n3;
                    int n4 = Log.d(LOG_TAG, string3);
                    this.mCT.separate(gsmConnection);
                    return true;
                }
                String string4 = "separate: invalid call index " + n3;
                int n5 = Log.d(LOG_TAG, string4);
                Phone.SuppService suppService = Phone.SuppService.SEPARATE;
                this.notifySuppServiceFailed(suppService);
                return true;
            }
            catch (CallStateException callStateException) {
                int n6 = Log.d(LOG_TAG, "separate failed", callStateException);
                Phone.SuppService suppService = Phone.SuppService.SEPARATE;
                this.notifySuppServiceFailed(suppService);
            }
            return true;
        }
        try {
            Call.State state = this.getRingingCall().getState();
            Call.State state2 = Call.State.IDLE;
            if (state != state2) {
                int n7 = Log.d(LOG_TAG, "MmiCode 2: accept ringing call");
                this.mCT.acceptCall();
                return true;
            }
            int n8 = Log.d(LOG_TAG, "MmiCode 2: switchWaitingOrHoldingAndActive");
            this.mCT.switchWaitingOrHoldingAndActive();
            return true;
        }
        catch (CallStateException callStateException) {
            int n9 = Log.d(LOG_TAG, "switch failed", callStateException);
            Phone.SuppService suppService = Phone.SuppService.SWITCH;
            this.notifySuppServiceFailed(suppService);
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleCallWaitingIncallSupplementaryService(String var1_1) throws CallStateException {
        var2_2 = var1_1.length();
        if (var2_2 > 2) {
            return false;
        }
        var4_4 = this.getForegroundCall();
        if (var2_2 <= 1) ** GOTO lbl16
        var5_5 = 1;
        try {
            var6_6 = var1_1.charAt(var5_5) - 48;
            if (var6_6 < 1) return true;
            if (var6_6 > 7) return true;
            var7_7 = "MmiCode 1: hangupConnectionByIndex " + var6_6;
            var8_8 = Log.d("GSM", var7_7);
            this.mCT.hangupConnectionByIndex((GsmCall)var4_4, var6_6);
            return true;
lbl16:
            // 1 sources

            var9_9 = var4_4.getState();
            if (var9_9 != (var10_10 = Call.State.IDLE)) {
                var11_11 = Log.d("GSM", "MmiCode 1: hangup foreground");
                this.mCT.hangup((GsmCall)var4_4);
                return true;
            }
            ** GOTO lbl-1000
        }
        catch (CallStateException var12_12) {
            var13_13 = Log.d("GSM", "hangup failed", var12_12);
            var14_14 = Phone.SuppService.HANGUP;
            this.notifySuppServiceFailed(var14_14);
        }
        return true;
lbl-1000:
        // 1 sources

        {
            var15_15 = Log.d("GSM", "MmiCode 1: switchWaitingOrHoldingAndActive");
            this.mCT.switchWaitingOrHoldingAndActive();
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCcbsIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() > 1) {
            return false;
        }
        int n = Log.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        Phone.SuppService suppService = Phone.SuppService.UNKNOWN;
        this.notifySuppServiceFailed(suppService);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleCfuQueryResult(CallForwardInfo[] callForwardInfoArray) {
        if (callForwardInfoArray == null || callForwardInfoArray.length == 0) {
            this.mSIMRecords.setVoiceCallForwardingFlag(1, false);
            return;
        }
        int n = 0;
        int n2 = callForwardInfoArray.length;
        while (n < n2) {
            if ((callForwardInfoArray[n].serviceClass & 1) != 0) {
                SIMRecords sIMRecords = this.mSIMRecords;
                boolean bl = callForwardInfoArray[n].status == 1;
                sIMRecords.setVoiceCallForwardingFlag(1, bl);
                return;
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleEctIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() != 1) {
            return false;
        }
        int n = Log.d(LOG_TAG, "MmiCode 4: explicit call transfer");
        try {
            this.explicitCallTransfer();
            return true;
        }
        catch (CallStateException callStateException) {
            int n2 = Log.d(LOG_TAG, "transfer failed", callStateException);
            Phone.SuppService suppService = Phone.SuppService.TRANSFER;
            this.notifySuppServiceFailed(suppService);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleMultipartyIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() > 1) {
            return false;
        }
        int n = Log.d(LOG_TAG, "MmiCode 3: merge calls");
        try {
            this.conference();
            return true;
        }
        catch (CallStateException callStateException) {
            int n2 = Log.d(LOG_TAG, "conference failed", callStateException);
            Phone.SuppService suppService = Phone.SuppService.CONFERENCE;
            this.notifySuppServiceFailed(suppService);
            return true;
        }
    }

    private void handleSetSelectNetwork(AsyncResult asyncResult) {
        if (!(asyncResult.userObj instanceof NetworkSelectMessage)) {
            int n = Log.d(LOG_TAG, "unexpected result from user object.");
            return;
        }
        NetworkSelectMessage networkSelectMessage = (NetworkSelectMessage)asyncResult.userObj;
        if (networkSelectMessage.message != null) {
            int n = Log.d(LOG_TAG, "sending original message to recipient");
            Message message = networkSelectMessage.message;
            Object object = asyncResult.result;
            Throwable throwable = asyncResult.exception;
            AsyncResult asyncResult2 = AsyncResult.forMessage(message, object, throwable);
            networkSelectMessage.message.sendToTarget();
        }
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        String string2 = networkSelectMessage.operatorNumeric;
        SharedPreferences.Editor editor2 = editor.putString("network_selection_key", string2);
        String string3 = networkSelectMessage.operatorAlphaLong;
        SharedPreferences.Editor editor3 = editor.putString("network_selection_name_key", string3);
        if (editor.commit()) {
            return;
        }
        int n = Log.e(LOG_TAG, "failed to commit network selection preference");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidCommandInterfaceCFAction(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidCommandInterfaceCFReason(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onIncomingUSSD(int n, String string2) {
        boolean bl;
        boolean bl2;
        block5: {
            bl2 = n == 1;
            bl = n != 0 && n != 1;
            GsmMmiCode gsmMmiCode = null;
            int n2 = 0;
            int n3 = this.mPendingMMIs.size();
            while (true) {
                block7: {
                    block6: {
                        if (n2 >= n3) break block6;
                        if (!this.mPendingMMIs.get(n2).isPendingUSSD()) break block7;
                        gsmMmiCode = this.mPendingMMIs.get(n2);
                    }
                    if (gsmMmiCode != null) {
                        if (!bl) break;
                        gsmMmiCode.onUssdFinishedError();
                        return;
                    }
                    break block5;
                }
                ++n2;
            }
            gsmMmiCode.onUssdFinished(string2, bl2);
            return;
        }
        if (bl) {
            return;
        }
        if (string2 == null) {
            return;
        }
        GsmMmiCode gsmMmiCode = GsmMmiCode.newNetworkInitiatedUssd(string2, bl2, this);
        this.onNetworkInitiatedUssd(gsmMmiCode);
    }

    private void onNetworkInitiatedUssd(GsmMmiCode gsmMmiCode) {
        RegistrantList registrantList = this.mMmiCompleteRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, gsmMmiCode, null);
        registrantList.notifyRegistrants(asyncResult);
    }

    private void setVmSimImsi(String string2) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        SharedPreferences.Editor editor2 = editor.putString(VM_SIM_IMSI, string2);
        editor.apply();
    }

    private void storeVoiceMailNumber(String string2) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        SharedPreferences.Editor editor2 = editor.putString(VM_NUMBER, string2);
        editor.apply();
        String string3 = this.getSubscriberId();
        this.setVmSimImsi(string3);
    }

    @Override
    public void acceptCall() throws CallStateException {
        this.mCT.acceptCall();
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        int n2 = Log.e(LOG_TAG, "Error! This functionality is not implemented for GSM.");
    }

    @Override
    public boolean canConference() {
        return this.mCT.canConference();
    }

    public boolean canDial() {
        return this.mCT.canDial();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public void conference() throws CallStateException {
        this.mCT.conference();
    }

    @Override
    public Connection dial(String string2) throws CallStateException {
        return this.dial(string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        String string3 = PhoneNumberUtils.stripSeparators(string2);
        if (this.handleInCallMmiCommands(string3)) {
            return null;
        }
        GsmMmiCode gsmMmiCode = GsmMmiCode.newFromDialString(PhoneNumberUtils.extractNetworkPortionAlt(string3), this);
        String string4 = "dialing w/ mmi '" + gsmMmiCode + "'...";
        int n = Log.d(LOG_TAG, string4);
        if (gsmMmiCode == null) {
            return this.mCT.dial(string3, uUSInfo);
        }
        if (gsmMmiCode.isTemporaryModeCLIR()) {
            GsmCallTracker gsmCallTracker = this.mCT;
            String string5 = gsmMmiCode.dialingNumber;
            int n2 = gsmMmiCode.getCLIRMode();
            return gsmCallTracker.dial(string5, n2, uUSInfo);
        }
        boolean bl = this.mPendingMMIs.add(gsmMmiCode);
        RegistrantList registrantList = this.mMmiRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, gsmMmiCode, null);
        registrantList.notifyRegistrants(asyncResult);
        gsmMmiCode.processCode();
        return null;
    }

    @Override
    public boolean disableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(false);
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.mCM.unregisterForAvailable(this);
            this.mSIMRecords.unregisterForRecordsLoaded(this);
            this.mCM.unregisterForOffOrNotAvailable(this);
            this.mCM.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttach(this);
            this.mCM.unSetOnUSSD(this);
            this.mCM.unSetOnSuppServiceNotification(this);
            this.mPendingMMIs.clear();
            this.mStkService.dispose();
            this.mCT.dispose();
            this.mDataConnection.dispose();
            this.mSST.dispose();
            this.mIccFileHandler.dispose();
            this.mSIMRecords.dispose();
            this.mSimCard.dispose();
            this.mSimPhoneBookIntManager.dispose();
            this.mSimSmsIntManager.dispose();
            this.mSubInfo.dispose();
            return;
        }
    }

    @Override
    public boolean enableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(true);
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
        this.mCT.explicitCallTransfer();
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "GSMPhone finalized");
    }

    @Override
    public void getAvailableNetworks(Message message) {
        this.mCM.getAvailableNetworks(message);
    }

    @Override
    public GsmCall getBackgroundCall() {
        return this.mCT.backgroundCall;
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return this.mSIMRecords.getVoiceCallForwardingFlag();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void getCallForwardingOption(int n, Message message) {
        if (!this.isValidCommandInterfaceCFReason(n)) {
            return;
        }
        int n2 = Log.d(LOG_TAG, "requesting call forwarding query.");
        Message message2 = n == 0 ? this.obtainMessage(13, message) : message;
        this.mCM.queryCallForwardStatus(n, 0, null, message2);
    }

    @Override
    public void getCallWaiting(Message message) {
        this.mCM.queryCallWaiting(1, message);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        int n = Log.e(LOG_TAG, "Error! This functionality is not implemented for GSM.");
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mSST.cellLoc;
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return this.mDataConnection.getAllDataConnections();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Phone.DataActivityState getDataActivityState() {
        Phone.DataActivityState dataActivityState = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentGprsState() != 0) return dataActivityState;
        int[] nArray = 2.$SwitchMap$com$android$internal$telephony$DataConnectionTracker$Activity;
        int n = this.mDataConnection.getActivity().ordinal();
        switch (nArray[n]) {
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
        }
        return dataActivityState;
    }

    @Override
    public void getDataCallList(Message message) {
        this.mCM.getDataCallList(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Phone.DataState getDataConnectionState() {
        Phone.DataState dataState = Phone.DataState.DISCONNECTED;
        if (this.mSST == null) {
            return Phone.DataState.DISCONNECTED;
        }
        if (this.mSST.getCurrentGprsState() != 0) {
            return Phone.DataState.DISCONNECTED;
        }
        int[] nArray = 2.$SwitchMap$com$android$internal$telephony$DataConnectionTracker$State;
        int n = this.mDataConnection.getState().ordinal();
        switch (nArray[n]) {
            default: {
                return dataState;
            }
            case 1: 
            case 2: {
                return Phone.DataState.DISCONNECTED;
            }
            case 3: 
            case 4: {
                Phone.State state = this.mCT.state;
                Phone.State state2 = Phone.State.IDLE;
                if (state == state2) return Phone.DataState.CONNECTED;
                if (this.mSST.isConcurrentVoiceAndData()) return Phone.DataState.CONNECTED;
                return Phone.DataState.SUSPENDED;
            }
            case 5: 
            case 6: 
            case 7: 
        }
        return Phone.DataState.CONNECTING;
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDataConnection.getDataOnRoamingEnabled();
    }

    @Override
    public String getDeviceId() {
        return this.mImei;
    }

    @Override
    public String getDeviceSvn() {
        return this.mImeiSv;
    }

    @Override
    public String getEsn() {
        int n = Log.e(LOG_TAG, "[GSMPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public GsmCall getForegroundCall() {
        return this.mCT.foregroundCall;
    }

    @Override
    public IccCard getIccCard() {
        return this.mSimCard;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return this.mIccFileHandler;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mSimPhoneBookIntManager;
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mSIMRecords.getRecordsLoaded();
    }

    @Override
    public String getIccSerialNumber() {
        return this.mSIMRecords.iccid;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mSimSmsIntManager;
    }

    @Override
    public String getLine1AlphaTag() {
        return this.mSIMRecords.getMsisdnAlphaTag();
    }

    @Override
    public String getLine1Number() {
        return this.mSIMRecords.getMsisdnNumber();
    }

    @Override
    public String getMeid() {
        int n = Log.e(LOG_TAG, "[GSMPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.mSIMRecords.getVoiceMessageWaiting();
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void getNeighboringCids(Message message) {
        this.mCM.getNeighboringCids(message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        this.mCM.getCLIR(message);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public String getPhoneName() {
        return LOG_TAG;
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mSubInfo;
    }

    @Override
    public int getPhoneType() {
        return 1;
    }

    @Override
    public GsmCall getRingingCall() {
        return this.mCT.ringingCall;
    }

    @Override
    public ServiceState getServiceState() {
        return this.mSST.ss;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return this.mSST.mSignalStrength;
    }

    @Override
    public Phone.State getState() {
        return this.mCT.state;
    }

    @Override
    public String getSubscriberId() {
        return this.mSIMRecords.imsi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getVoiceMailAlphaTag() {
        String string2 = this.mSIMRecords.getVoiceMailAlphaTag();
        if (string2 == null) return ((Object)this.mContext.getText(0x1040004)).toString();
        if (string2.length() != 0) return string2;
        return ((Object)this.mContext.getText(0x1040004)).toString();
    }

    @Override
    public String getVoiceMailNumber() {
        String string2 = this.mSIMRecords.getVoiceMailNumber();
        if (TextUtils.isEmpty(string2)) {
            string2 = PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(VM_NUMBER, null);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        boolean bl = false;
        switch (string2.charAt(0)) {
            case '0': {
                bl = this.handleCallDeflectionIncallSupplementaryService(string2);
                return bl;
            }
            case '1': {
                bl = this.handleCallWaitingIncallSupplementaryService(string2);
                return bl;
            }
            case '2': {
                bl = this.handleCallHoldIncallSupplementaryService(string2);
                return bl;
            }
            case '3': {
                bl = this.handleMultipartyIncallSupplementaryService(string2);
                return bl;
            }
            case '4': {
                bl = this.handleEctIncallSupplementaryService(string2);
                return bl;
            }
            case '5': {
                bl = this.handleCcbsIncallSupplementaryService(string2);
                return bl;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        Message message2;
        switch (message.what) {
            default: {
                super.handleMessage(message);
            }
            case 5: {
                return;
            }
            case 1: {
                CommandsInterface commandsInterface = this.mCM;
                Message message3 = this.obtainMessage(6);
                commandsInterface.getBasebandVersion(message3);
                CommandsInterface commandsInterface2 = this.mCM;
                Message message4 = this.obtainMessage(9);
                commandsInterface2.getIMEI(message4);
                CommandsInterface commandsInterface3 = this.mCM;
                Message message5 = this.obtainMessage(10);
                commandsInterface3.getIMEISV(message5);
                return;
            }
            case 19: {
                this.syncClirSetting();
                return;
            }
            case 3: {
                boolean bl = this.updateCurrentCarrierInProvider();
                String string2 = this.getVmSimImsi();
                if (string2 == null) {
                    return;
                }
                if (this.getSubscriberId().equals(string2)) {
                    return;
                }
                this.storeVoiceMailNumber(null);
                this.setVmSimImsi(null);
                return;
            }
            case 6: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Baseband version: ");
                Object object = asyncResult.result;
                String string3 = stringBuilder.append(object).toString();
                int n = Log.d(LOG_TAG, string3);
                String string4 = (String)asyncResult.result;
                this.setSystemProperty("gsm.version.baseband", string4);
                return;
            }
            case 9: {
                String string5;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    return;
                }
                this.mImei = string5 = (String)asyncResult.result;
                return;
            }
            case 10: {
                String string6;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    return;
                }
                this.mImeiSv = string6 = (String)asyncResult.result;
                return;
            }
            case 7: {
                String[] stringArray = (String[])((AsyncResult)message.obj).result;
                if (stringArray.length <= 1) {
                    return;
                }
                int n = 0;
                try {
                    int n2 = Integer.parseInt(stringArray[n]);
                    String string7 = stringArray[1];
                    this.onIncomingUSSD(n2, string7);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    int n3 = Log.w(LOG_TAG, "error parsing USSD");
                    return;
                }
            }
            case 8: {
                int n = 0;
                int n4 = this.mPendingMMIs.size();
                while (true) {
                    if (n >= n4) {
                        return;
                    }
                    if (this.mPendingMMIs.get(n).isPendingUSSD()) {
                        this.mPendingMMIs.get(n).onUssdFinishedError();
                    }
                    ++n;
                }
            }
            case 2: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                SuppServiceNotification suppServiceNotification = (SuppServiceNotification)asyncResult.result;
                this.mSsnRegistrants.notifyRegistrants(asyncResult);
                return;
            }
            case 12: {
                Message message6;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    SIMRecords sIMRecords = this.mSIMRecords;
                    boolean bl = message.arg1 == 1;
                    sIMRecords.setVoiceCallForwardingFlag(1, bl);
                }
                if ((message6 = (Message)asyncResult.userObj) == null) {
                    return;
                }
                Object object = asyncResult.result;
                Throwable throwable = asyncResult.exception;
                AsyncResult asyncResult2 = AsyncResult.forMessage(message6, object, throwable);
                message6.sendToTarget();
                return;
            }
            case 20: {
                Message message7;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Throwable throwable = asyncResult.exception;
                if (IccVmNotSupportedException.class.isInstance(throwable)) {
                    String string8 = this.mVmNumber;
                    this.storeVoiceMailNumber(string8);
                    asyncResult.exception = null;
                }
                if ((message7 = (Message)asyncResult.userObj) == null) {
                    return;
                }
                Object object = asyncResult.result;
                Throwable throwable2 = asyncResult.exception;
                AsyncResult asyncResult3 = AsyncResult.forMessage(message7, object, throwable2);
                message7.sendToTarget();
                return;
            }
            case 13: {
                Message message8;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    CallForwardInfo[] callForwardInfoArray = (CallForwardInfo[])asyncResult.result;
                    this.handleCfuQueryResult(callForwardInfoArray);
                }
                if ((message8 = (Message)asyncResult.userObj) == null) {
                    return;
                }
                Object object = asyncResult.result;
                Throwable throwable = asyncResult.exception;
                AsyncResult asyncResult4 = AsyncResult.forMessage(message8, object, throwable);
                message8.sendToTarget();
                return;
            }
            case 16: 
            case 17: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.handleSetSelectNetwork(asyncResult);
                return;
            }
            case 18: 
        }
        AsyncResult asyncResult = (AsyncResult)message.obj;
        if (asyncResult.exception == null) {
            int n = message.arg1;
            this.saveClirSetting(n);
        }
        if ((message2 = (Message)asyncResult.userObj) == null) {
            return;
        }
        Object object = asyncResult.result;
        Throwable throwable = asyncResult.exception;
        AsyncResult asyncResult5 = AsyncResult.forMessage(message2, object, throwable);
        message2.sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handlePinMmi(String string2) {
        GsmMmiCode gsmMmiCode = GsmMmiCode.newFromDialString(string2, this);
        if (gsmMmiCode == null) return false;
        if (!gsmMmiCode.isPinCommand()) return false;
        boolean bl = this.mPendingMMIs.add(gsmMmiCode);
        RegistrantList registrantList = this.mMmiRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, gsmMmiCode, null);
        registrantList.notifyRegistrants(asyncResult);
        gsmMmiCode.processCode();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isCfEnable(int n) {
        if (n == 1) return true;
        if (n != 3) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isDataConnectivityPossible() {
        IccCard.State state;
        Phone.DataState dataState;
        Phone.DataState dataState2;
        if (this.mDataConnection.getDataEnabled() && (dataState2 = this.getDataConnectionState()) == (dataState = Phone.DataState.DISCONNECTED)) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        IccCard.State state2 = this.getIccCard().getState();
        if (state2 != (state = IccCard.State.READY)) return false;
        if (this.getServiceState().getState() != 0) return false;
        if (this.mDataConnection.getDataOnRoamingEnabled()) return true;
        if (this.getServiceState().getRoaming()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isInCall() {
        Call.State state = this.getForegroundCall().getState();
        Call.State state2 = this.getBackgroundCall().getState();
        Call.State state3 = this.getRingingCall().getState();
        if (state.isAlive()) return true;
        if (state2.isAlive()) return true;
        if (!state3.isAlive()) return false;
        return true;
    }

    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    void notifyDataConnectionFailed(String string2) {
        this.mNotifier.notifyDataConnectionFailed(this, string2);
    }

    void notifyDisconnect(Connection connection) {
        this.mDisconnectRegistrants.notifyResult(connection);
    }

    void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    void notifyNewRingingConnection(Connection connection) {
        super.notifyNewRingingConnectionP(connection);
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        super.notifyServiceStateChangedP(serviceState);
    }

    void notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    void notifySuppServiceFailed(Phone.SuppService suppService) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)suppService);
    }

    void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    void onMMIDone(GsmMmiCode gsmMmiCode) {
        if (!this.mPendingMMIs.remove(gsmMmiCode) && !gsmMmiCode.isUssdRequest()) {
            return;
        }
        RegistrantList registrantList = this.mMmiCompleteRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, gsmMmiCode, null);
        registrantList.notifyRegistrants(asyncResult);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        this.mSsnRegistrants.addUnique(handler, n, object);
        if (this.mSsnRegistrants.size() != 1) {
            return;
        }
        this.mCM.setSuppServiceNotifications(true, null);
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    public void removeReferences() {
        this.mSimulatedRadioControl = null;
        this.mStkService = null;
        this.mSimPhoneBookIntManager = null;
        this.mSimSmsIntManager = null;
        this.mSMS = null;
        this.mSubInfo = null;
        this.mSIMRecords = null;
        this.mIccFileHandler = null;
        this.mSimCard = null;
        this.mDataConnection = null;
        this.mCT = null;
        this.mSST = null;
    }

    public void saveClirSetting(int n) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        SharedPreferences.Editor editor2 = editor.putInt("clir_key", n);
        if (editor.commit()) {
            return;
        }
        int n2 = Log.e(LOG_TAG, "failed to commit CLIR preference");
    }

    @Override
    public void selectNetworkManually(NetworkInfo networkInfo, Message message) {
        String string2;
        String string3;
        NetworkSelectMessage networkSelectMessage = new NetworkSelectMessage();
        networkSelectMessage.message = message;
        networkSelectMessage.operatorNumeric = string3 = networkInfo.operatorNumeric;
        networkSelectMessage.operatorAlphaLong = string2 = networkInfo.operatorAlphaLong;
        Message message2 = this.obtainMessage(16, networkSelectMessage);
        CommandsInterface commandsInterface = this.mCM;
        String string4 = networkInfo.operatorNumeric;
        commandsInterface.setNetworkSelectionModeManual(string4, message2);
    }

    public void sendBurstDtmf(String string2) {
        int n = Log.e(LOG_TAG, "[GSMPhone] sendBurstDtmf() is a CDMA method");
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            String string2 = "sendDtmf called with invalid character '" + c + "'";
            int n = Log.e(LOG_TAG, string2);
            return;
        }
        Phone.State state = this.mCT.state;
        Phone.State state2 = Phone.State.OFFHOOK;
        if (state != state2) {
            return;
        }
        this.mCM.sendDtmf(c, null);
    }

    @Override
    public void sendUssdResponse(String string2) {
        GsmMmiCode gsmMmiCode = GsmMmiCode.newFromUssdUserInput(string2, this);
        boolean bl = this.mPendingMMIs.add(gsmMmiCode);
        RegistrantList registrantList = this.mMmiRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, gsmMmiCode, null);
        registrantList.notifyRegistrants(asyncResult);
        gsmMmiCode.sendUssd(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        Message message2;
        if (!this.isValidCommandInterfaceCFAction(n)) {
            return;
        }
        if (!this.isValidCommandInterfaceCFReason(n2)) {
            return;
        }
        if (n2 == 0) {
            int n4 = 12;
            int n5 = this.isCfEnable(n) ? 1 : 0;
            message2 = this.obtainMessage(n4, n5, 0, message);
        } else {
            message2 = message;
        }
        CommandsInterface commandsInterface = this.mCM;
        int n6 = n;
        int n7 = n2;
        String string3 = string2;
        int n8 = n3;
        commandsInterface.setCallForward(n6, n7, 1, string3, n8, message2);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        this.mCM.setCallWaiting(bl, 1, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        int n = Log.e(LOG_TAG, "Error! This functionality is not implemented for GSM.");
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        this.mDataConnection.setDataOnRoamingEnabled(bl);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        this.mSIMRecords.setMsisdnNumber(string2, string3, message);
    }

    @Override
    public void setMute(boolean bl) {
        this.mCT.setMute(bl);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        NetworkSelectMessage networkSelectMessage = new NetworkSelectMessage();
        networkSelectMessage.message = message;
        networkSelectMessage.operatorNumeric = "";
        networkSelectMessage.operatorAlphaLong = "";
        Message message2 = this.obtainMessage(17, networkSelectMessage);
        int n = Log.d(LOG_TAG, "wrapping and sending message to connect automatically");
        this.mCM.setNetworkSelectionModeAutomatic(message2);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        Registrant registrant;
        this.mPostDialHandler = registrant = new Registrant(handler, n, object);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        CommandsInterface commandsInterface = this.mCM;
        Message message2 = this.obtainMessage(18, n, 0, message);
        commandsInterface.setCLIR(n, message2);
    }

    @Override
    public void setRadioPower(boolean bl) {
        this.mSST.setRadioPower(bl);
    }

    @Override
    public final void setSystemProperty(String string2, String string3) {
        super.setSystemProperty(string2, string3);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        this.mVmNumber = string3;
        Message message2 = this.obtainMessage(20, 0, 0, message);
        SIMRecords sIMRecords = this.mSIMRecords;
        String string4 = this.mVmNumber;
        sIMRecords.setVoiceMailNumber(string2, string4, message2);
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            String string2 = "startDtmf called with invalid character '" + c + "'";
            int n = Log.e(LOG_TAG, string2);
            return;
        }
        this.mCM.startDtmf(c, null);
    }

    @Override
    public void stopDtmf() {
        this.mCM.stopDtmf(null);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    protected void syncClirSetting() {
        int n = PreferenceManager.getDefaultSharedPreferences(this.getContext()).getInt("clir_key", -1);
        if (n < 0) {
            return;
        }
        this.mCM.setCLIR(n, null);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        this.mSsnRegistrants.remove(handler);
        if (this.mSsnRegistrants.size() != 0) {
            return;
        }
        this.mCM.setSuppServiceNotifications(false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateCurrentCarrierInProvider() {
        if (this.mSIMRecords == null) return false;
        try {
            Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
            ContentValues contentValues = new ContentValues();
            String string2 = this.mSIMRecords.getSIMOperatorNumeric();
            contentValues.put("numeric", string2);
            Uri uri2 = this.mContext.getContentResolver().insert(uri, contentValues);
            return true;
        }
        catch (SQLException sQLException) {
            int n = Log.e(LOG_TAG, "Can't store current operator", sQLException);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateMessageWaitingIndicator(boolean bl) {
        SIMRecords sIMRecords = this.mSIMRecords;
        int n = bl ? -1 : 0;
        sIMRecords.setVoiceMessageWaiting(1, n);
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    private static class NetworkSelectMessage {
        public Message message;
        public String operatorAlphaLong;
        public String operatorNumeric;

        private NetworkSelectMessage() {
        }
    }
}

