/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmConnection;
import java.util.ArrayList;
import java.util.List;

public final class GsmCallTracker
extends CallTracker {
    private static final boolean DBG_POLL = false;
    static final String LOG_TAG = "GSM";
    static final int MAX_CONNECTIONS = 7;
    static final int MAX_CONNECTIONS_PER_CALL = 5;
    private static final boolean REPEAT_POLLING;
    GsmCall backgroundCall;
    GsmConnection[] connections;
    boolean desiredMute;
    ArrayList<GsmConnection> droppedDuringPoll;
    GsmCall foregroundCall;
    boolean hangupPendingMO;
    GsmConnection pendingMO;
    GSMPhone phone;
    GsmCall ringingCall;
    Phone.State state;
    RegistrantList voiceCallEndedRegistrants;
    RegistrantList voiceCallStartedRegistrants;

    GsmCallTracker(GSMPhone gSMPhone) {
        CommandsInterface commandsInterface;
        Phone.State state;
        GsmCall gsmCall;
        GsmCall gsmCall2;
        GsmCall gsmCall3;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        GsmConnection[] gsmConnectionArray = new GsmConnection[7];
        this.connections = gsmConnectionArray;
        this.voiceCallEndedRegistrants = registrantList2 = new RegistrantList();
        this.voiceCallStartedRegistrants = registrantList = new RegistrantList();
        ArrayList arrayList = new ArrayList(7);
        this.droppedDuringPoll = arrayList;
        this.ringingCall = gsmCall3 = new GsmCall(this);
        this.foregroundCall = gsmCall2 = new GsmCall(this);
        this.backgroundCall = gsmCall = new GsmCall(this);
        this.desiredMute = false;
        this.state = state = Phone.State.IDLE;
        this.phone = gSMPhone;
        this.cm = commandsInterface = gSMPhone.mCM;
        this.cm.registerForCallStateChanged(this, 2, null);
        this.cm.registerForOn(this, 9, null);
        this.cm.registerForNotAvailable(this, 10, null);
    }

    private void dumpState() {
        StringBuilder stringBuilder = new StringBuilder().append("Phone State:");
        Phone.State state = this.state;
        String string2 = stringBuilder.append((Object)state).toString();
        int n = Log.i(LOG_TAG, string2);
        StringBuilder stringBuilder2 = new StringBuilder().append("Ringing call: ");
        String string3 = this.ringingCall.toString();
        String string4 = stringBuilder2.append(string3).toString();
        int n2 = Log.i(LOG_TAG, string4);
        List<Connection> list = this.ringingCall.getConnections();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            String string5 = ((Object)list.get(i)).toString();
            int n4 = Log.i(LOG_TAG, string5);
        }
        StringBuilder stringBuilder3 = new StringBuilder().append("Foreground call: ");
        String string6 = this.foregroundCall.toString();
        String string7 = stringBuilder3.append(string6).toString();
        int n5 = Log.i(LOG_TAG, string7);
        List<Connection> list2 = this.foregroundCall.getConnections();
        int n6 = list2.size();
        for (int i = 0; i < n6; ++i) {
            String string8 = ((Object)list2.get(i)).toString();
            int n7 = Log.i(LOG_TAG, string8);
        }
        StringBuilder stringBuilder4 = new StringBuilder().append("Background call: ");
        String string9 = this.backgroundCall.toString();
        String string10 = stringBuilder4.append(string9).toString();
        int n8 = Log.i(LOG_TAG, string10);
        List<Connection> list3 = this.backgroundCall.getConnections();
        int n9 = 0;
        int n10 = list3.size();
        while (n9 < n10) {
            String string11 = ((Object)list3.get(n9)).toString();
            int n11 = Log.i(LOG_TAG, string11);
            ++n9;
        }
        return;
    }

    private void fakeHoldForegroundBeforeDial() {
        List list = (List)this.foregroundCall.connections.clone();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            ((GsmConnection)list.get(n)).fakeHoldBeforeDial();
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Phone.SuppService getFailedService(int n) {
        switch (n) {
            default: {
                return Phone.SuppService.UNKNOWN;
            }
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: 
        }
        return Phone.SuppService.TRANSFER;
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void internalClearDisconnected() {
        this.ringingCall.clearDisconnected();
        this.foregroundCall.clearDisconnected();
        this.backgroundCall.clearDisconnected();
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int n) {
        int n2;
        this.pendingOperations = n2 = this.pendingOperations + 1;
        this.lastRelevantPoll = null;
        this.needsPoll = true;
        return this.obtainMessage(n);
    }

    private void operationComplete() {
        int n;
        this.pendingOperations = n = this.pendingOperations - 1;
        if (this.pendingOperations == 0 && this.needsPoll) {
            Message message;
            this.lastRelevantPoll = message = this.obtainMessage(1);
            CommandsInterface commandsInterface = this.cm;
            Message message2 = this.lastRelevantPoll;
            commandsInterface.getCurrentCalls(message2);
            return;
        }
        if (this.pendingOperations >= 0) {
            return;
        }
        int n2 = Log.e(LOG_TAG, "GsmCallTracker.pendingOperations < 0");
        this.pendingOperations = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePhoneState() {
        Phone.State state;
        Phone.State state2;
        Phone.State state3;
        Phone.State state4;
        Phone.State state5 = this.state;
        this.state = this.ringingCall.isRinging() ? (state4 = Phone.State.RINGING) : (this.pendingMO != null || !this.foregroundCall.isIdle() || !this.backgroundCall.isIdle() ? (state3 = Phone.State.OFFHOOK) : (state2 = Phone.State.IDLE));
        Phone.State state6 = this.state;
        Phone.State state7 = Phone.State.IDLE;
        if (state6 == state7 && state5 != (state = this.state)) {
            RegistrantList registrantList = this.voiceCallEndedRegistrants;
            AsyncResult asyncResult = new AsyncResult(null, null, null);
            registrantList.notifyRegistrants(asyncResult);
        } else {
            Phone.State state8;
            Phone.State state9 = Phone.State.IDLE;
            if (state5 == state9 && state5 != (state8 = this.state)) {
                RegistrantList registrantList = this.voiceCallStartedRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, null, null);
                registrantList.notifyRegistrants(asyncResult);
            }
        }
        if (this.state == state5) {
            return;
        }
        this.phone.notifyPhoneStateChanged();
    }

    void acceptCall() throws CallStateException {
        Call.State state;
        Call.State state2;
        Call.State state3 = this.ringingCall.getState();
        if (state3 == (state2 = Call.State.INCOMING)) {
            int n = Log.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.acceptCall(message);
            return;
        }
        Call.State state4 = this.ringingCall.getState();
        if (state4 == (state = Call.State.WAITING)) {
            this.setMute(false);
            this.switchWaitingOrHoldingAndActive();
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canConference() {
        Call.State state;
        Call.State state2;
        Call.State state3 = this.foregroundCall.getState();
        if (state3 != (state2 = Call.State.ACTIVE)) return false;
        Call.State state4 = this.backgroundCall.getState();
        if (state4 != (state = Call.State.HOLDING)) return false;
        if (this.backgroundCall.isFull()) return false;
        if (this.foregroundCall.isFull()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canDial() {
        int n = this.phone.getServiceState().getState();
        String string2 = SystemProperties.get("ro.telephony.disable-call", "false");
        if (n == 3) return false;
        if (this.pendingMO != null) return false;
        if (this.ringingCall.isRinging()) return false;
        if (string2.equals("true")) return false;
        if (!this.foregroundCall.getState().isAlive()) return true;
        if (this.backgroundCall.getState().isAlive()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canTransfer() {
        Call.State state;
        Call.State state2;
        Call.State state3 = this.foregroundCall.getState();
        if (state3 != (state2 = Call.State.ACTIVE)) return false;
        Call.State state4 = this.backgroundCall.getState();
        if (state4 != (state = Call.State.HOLDING)) return false;
        return true;
    }

    void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
    }

    void conference() throws CallStateException {
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage(11);
        commandsInterface.conference(message);
    }

    Connection dial(String string2) throws CallStateException {
        return this.dial(string2, 0, null);
    }

    Connection dial(String string2, int n) throws CallStateException {
        return this.dial(string2, n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    Connection dial(String string2, int n, UUSInfo uUSInfo) throws CallStateException {
        GsmConnection gsmConnection;
        Call.State state;
        Call.State state2;
        Call.State state3;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        Call.State state4 = this.foregroundCall.getState();
        if (state4 == (state3 = Call.State.ACTIVE)) {
            this.switchWaitingOrHoldingAndActive();
            this.fakeHoldForegroundBeforeDial();
        }
        if ((state2 = this.foregroundCall.getState()) != (state = Call.State.IDLE)) {
            throw new CallStateException("cannot dial in current state");
        }
        Context context = this.phone.getContext();
        GsmCall gsmCall = this.foregroundCall;
        this.pendingMO = gsmConnection = new GsmConnection(context, string2, this, gsmCall);
        this.hangupPendingMO = false;
        if (this.pendingMO.address == null || this.pendingMO.address.length() == 0 || this.pendingMO.address.indexOf(78) >= 0) {
            Connection.DisconnectCause disconnectCause;
            GsmConnection gsmConnection2 = this.pendingMO;
            gsmConnection2.cause = disconnectCause = Connection.DisconnectCause.INVALID_NUMBER;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            CommandsInterface commandsInterface = this.cm;
            String string3 = this.pendingMO.address;
            Message message = this.obtainCompleteMessage();
            commandsInterface.dial(string3, n, uUSInfo, message);
        }
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
        return this.pendingMO;
    }

    Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        return this.dial(string2, 0, uUSInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.cm.unregisterForCallStateChanged(this);
        this.cm.unregisterForOn(this);
        this.cm.unregisterForNotAvailable(this);
        for (GsmConnection gsmConnection : this.connections) {
            if (gsmConnection == null) continue;
            try {
                this.hangup(gsmConnection);
            }
            catch (CallStateException callStateException) {
                int n = Log.e(LOG_TAG, "unexpected error on hangup during dispose");
            }
        }
        try {
            if (this.pendingMO != null) {
                GsmConnection gsmConnection = this.pendingMO;
                this.hangup(gsmConnection);
            }
        }
        catch (CallStateException callStateException) {
            int n = Log.e(LOG_TAG, "unexpected error on hangup during dispose");
        }
        this.clearDisconnected();
    }

    void explicitCallTransfer() throws CallStateException {
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage(13);
        commandsInterface.explicitCallTransfer(message);
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "GsmCallTracker finalized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GsmConnection getConnectionByIndex(GsmCall gsmCall, int n) throws CallStateException {
        int n2 = gsmCall.connections.size();
        int n3 = 0;
        while (n3 < n2) {
            GsmConnection gsmConnection = (GsmConnection)gsmCall.connections.get(n3);
            if (gsmConnection.getGSMIndex() != n) {
                return gsmConnection;
            }
            ++n3;
        }
        return null;
    }

    boolean getMute() {
        return this.desiredMute;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Message message2 = this.lastRelevantPoll;
                if (message != message2) {
                    return;
                }
                this.needsPoll = false;
                this.lastRelevantPoll = null;
                AsyncResult asyncResult2 = (AsyncResult)message.obj;
                this.handlePollCalls(asyncResult2);
                return;
            }
            case 4: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.operationComplete();
                return;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                if (((AsyncResult)message.obj).exception != null) {
                    GSMPhone gSMPhone = this.phone;
                    int n = message.what;
                    Phone.SuppService suppService = this.getFailedService(n);
                    gSMPhone.notifySuppServiceFailed(suppService);
                }
                this.operationComplete();
                return;
            }
            case 5: {
                int n;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.operationComplete();
                if (asyncResult.exception != null) {
                    n = 16;
                    int n2 = Log.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    n = ((int[])asyncResult.result)[0];
                }
                if (n == 34 || n == 41 || n == 42 || n == 44 || n == 49 || n == 58 || n == 65535) {
                    GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
                    int n3 = 50106;
                    Object[] objectArray = new Object[3];
                    Integer n4 = n;
                    objectArray[0] = n4;
                    int n5 = 1;
                    int n6 = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
                    Integer n7 = n6;
                    objectArray[n5] = n7;
                    Integer n8 = TelephonyManager.getDefault().getNetworkType();
                    objectArray[2] = n8;
                    int n9 = EventLog.writeEvent(n3, objectArray);
                }
                int n10 = 0;
                int n11 = this.droppedDuringPoll.size();
                while (true) {
                    if (n10 >= n11) {
                        this.updatePhoneState();
                        this.phone.notifyPreciseCallStateChanged();
                        this.droppedDuringPoll.clear();
                        return;
                    }
                    this.droppedDuringPoll.get(n10).onRemoteDisconnect(n);
                    ++n10;
                }
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                return;
            }
            case 9: {
                this.handleRadioAvailable();
                return;
            }
            case 10: 
        }
        this.handleRadioNotAvailable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        int n;
        int n2;
        int n3;
        ArrayList arrayList;
        if (asyncResult.exception == null) {
            arrayList = (ArrayList)asyncResult.result;
        } else {
            GsmCallTracker gsmCallTracker = this;
            Throwable throwable = asyncResult.exception;
            Throwable throwable2 = throwable;
            if (!gsmCallTracker.isCommandExceptionRadioNotAvailable(throwable2)) {
                this.pollCallsAfterDelay();
                return;
            }
            arrayList = new ArrayList();
        }
        GsmConnection gsmConnection = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = arrayList.size();
        while ((n3 = ++n4) < (n2 = (n = this.connections.length))) {
            GsmConnection gsmConnection2 = this.connections[n4];
            DriverCall driverCall = null;
            if (n5 < n6) {
                ArrayList arrayList2 = arrayList;
                int n7 = n5++;
                driverCall = (DriverCall)arrayList2.get(n7);
                int n8 = driverCall.index;
                int n9 = n8;
                int n10 = n4 + 1;
                int n11 = n10;
                if (n9 == n11) {
                    driverCall = null;
                }
            }
            if (gsmConnection2 == null && driverCall != null) {
                DriverCall driverCall2;
                GsmConnection gsmConnection3;
                if (this.pendingMO != null && (gsmConnection3 = this.pendingMO).compareTo(driverCall2 = driverCall)) {
                    int n12;
                    GsmConnection gsmConnection4;
                    GsmConnection[] gsmConnectionArray = this.connections;
                    gsmConnectionArray[n4] = gsmConnection4 = this.pendingMO;
                    GsmConnection gsmConnection5 = this.pendingMO;
                    gsmConnection5.index = n12 = n4;
                    GsmConnection gsmConnection6 = this.pendingMO;
                    DriverCall driverCall3 = driverCall;
                    boolean bl4 = gsmConnection6.update(driverCall3);
                    Object var30_33 = null;
                    this.pendingMO = var30_33;
                    if (this.hangupPendingMO) {
                        boolean bl5;
                        this.hangupPendingMO = bl5 = false;
                        try {
                            StringBuilder stringBuilder = new StringBuilder().append("poll: hangupPendingMO, hangup conn ");
                            int n13 = n4;
                            String string2 = stringBuilder.append(n13).toString();
                            GsmCallTracker gsmCallTracker = this;
                            String string3 = string2;
                            gsmCallTracker.log(string3);
                            GsmConnection gsmConnection7 = this.connections[n4];
                            GsmCallTracker gsmCallTracker2 = this;
                            GsmConnection gsmConnection8 = gsmConnection7;
                            gsmCallTracker2.hangup(gsmConnection8);
                            return;
                        }
                        catch (CallStateException callStateException) {
                            int n14 = Log.e(LOG_TAG, "unexpected error on hangup");
                            return;
                        }
                    }
                } else {
                    GsmConnection gsmConnection9;
                    GsmConnection[] gsmConnectionArray = this.connections;
                    Context context = this.phone.getContext();
                    GsmConnection gsmConnection10 = gsmConnection9;
                    Context context2 = context;
                    DriverCall driverCall4 = driverCall;
                    GsmCallTracker gsmCallTracker = this;
                    int n15 = n4;
                    gsmConnection10(context2, driverCall4, gsmCallTracker, n15);
                    gsmConnectionArray[n4] = gsmConnection9;
                    Call call = this.connections[n4].getCall();
                    GsmCall gsmCall = this.ringingCall;
                    Call call2 = call;
                    GsmCall gsmCall2 = gsmCall;
                    if (call2 == gsmCall2) {
                        gsmConnection = this.connections[n4];
                    } else {
                        DriverCall.State state;
                        DriverCall.State state2;
                        DriverCall.State state3;
                        DriverCall.State state4;
                        StringBuilder stringBuilder = new StringBuilder().append("Phantom call appeared ");
                        DriverCall driverCall5 = driverCall;
                        String string4 = stringBuilder.append(driverCall5).toString();
                        int n16 = Log.i(LOG_TAG, string4);
                        DriverCall.State state5 = driverCall.state;
                        DriverCall.State state6 = state5;
                        DriverCall.State state7 = DriverCall.State.ALERTING;
                        DriverCall.State state8 = state7;
                        if (state6 != state8 && (state4 = (state3 = driverCall.state)) != (state2 = (state = DriverCall.State.DIALING))) {
                            long l;
                            GsmConnection gsmConnection11 = this.connections[n4];
                            gsmConnection11.connectTime = l = System.currentTimeMillis();
                        }
                        bl3 = true;
                    }
                }
                bl = true;
                continue;
            }
            if (gsmConnection2 != null && driverCall == null) {
                ArrayList<GsmConnection> arrayList3 = this.droppedDuringPoll;
                GsmConnection gsmConnection12 = gsmConnection2;
                boolean bl6 = arrayList3.add(gsmConnection12);
                this.connections[n4] = null;
                continue;
            }
            if (gsmConnection2 != null && driverCall != null && !gsmConnection2.compareTo(driverCall)) {
                GsmConnection gsmConnection13;
                ArrayList<GsmConnection> arrayList4 = this.droppedDuringPoll;
                GsmConnection gsmConnection14 = gsmConnection2;
                boolean bl7 = arrayList4.add(gsmConnection14);
                GsmConnection[] gsmConnectionArray = this.connections;
                Context context = this.phone.getContext();
                GsmConnection gsmConnection15 = gsmConnection13;
                Context context3 = context;
                DriverCall driverCall6 = driverCall;
                GsmCallTracker gsmCallTracker = this;
                int n17 = n4;
                gsmConnection15(context3, driverCall6, gsmCallTracker, n17);
                gsmConnectionArray[n4] = gsmConnection13;
                Call call = this.connections[n4].getCall();
                GsmCall gsmCall = this.ringingCall;
                Call call3 = call;
                GsmCall gsmCall3 = gsmCall;
                if (call3 == gsmCall3) {
                    gsmConnection = this.connections[n4];
                }
                bl = true;
                continue;
            }
            if (gsmConnection2 == null || driverCall == null) continue;
            boolean bl8 = gsmConnection2.update(driverCall);
            if (bl || bl8) {
                bl = true;
                continue;
            }
            bl = false;
        }
        if (this.pendingMO != null) {
            boolean bl9;
            StringBuilder stringBuilder = new StringBuilder().append("Pending MO dropped before poll fg state:");
            Call.State state = this.foregroundCall.getState();
            String string5 = stringBuilder.append((Object)state).toString();
            int n18 = Log.d(LOG_TAG, string5);
            ArrayList<GsmConnection> arrayList5 = this.droppedDuringPoll;
            GsmConnection gsmConnection16 = this.pendingMO;
            boolean bl10 = arrayList5.add(gsmConnection16);
            Object var98_97 = null;
            this.pendingMO = var98_97;
            this.hangupPendingMO = bl9 = false;
        }
        if (gsmConnection != null) {
            GSMPhone gSMPhone = this.phone;
            GsmConnection gsmConnection17 = gsmConnection;
            gSMPhone.notifyNewRingingConnection(gsmConnection17);
        }
        n4 = this.droppedDuringPoll.size() - 1;
        while (n4 >= 0) {
            ArrayList<GsmConnection> arrayList6 = this.droppedDuringPoll;
            int n19 = n4;
            GsmConnection gsmConnection18 = arrayList6.get(n19);
            if (gsmConnection18.isIncoming() && gsmConnection18.getConnectTime() == 0L) {
                Connection.DisconnectCause disconnectCause = gsmConnection18.cause;
                Connection.DisconnectCause disconnectCause2 = disconnectCause;
                Connection.DisconnectCause disconnectCause3 = Connection.DisconnectCause.LOCAL;
                Connection.DisconnectCause disconnectCause4 = disconnectCause3;
                Connection.DisconnectCause disconnectCause5 = disconnectCause2 == disconnectCause4 ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.INCOMING_MISSED;
                StringBuilder stringBuilder = new StringBuilder().append("missed/rejected call, conn.cause=");
                Connection.DisconnectCause disconnectCause6 = gsmConnection18.cause;
                String string6 = stringBuilder.append((Object)disconnectCause6).toString();
                GsmCallTracker gsmCallTracker = this;
                String string7 = string6;
                gsmCallTracker.log(string7);
                StringBuilder stringBuilder2 = new StringBuilder().append("setting cause to ");
                Connection.DisconnectCause disconnectCause7 = disconnectCause5;
                String string8 = stringBuilder2.append((Object)disconnectCause7).toString();
                GsmCallTracker gsmCallTracker3 = this;
                String string9 = string8;
                gsmCallTracker3.log(string9);
                ArrayList<GsmConnection> arrayList7 = this.droppedDuringPoll;
                int n20 = n4;
                GsmConnection gsmConnection19 = arrayList7.remove(n20);
                gsmConnection18.onDisconnect(disconnectCause5);
            } else {
                Connection.DisconnectCause disconnectCause = gsmConnection18.cause;
                Connection.DisconnectCause disconnectCause8 = disconnectCause;
                Connection.DisconnectCause disconnectCause9 = Connection.DisconnectCause.LOCAL;
                Connection.DisconnectCause disconnectCause10 = disconnectCause9;
                if (disconnectCause8 == disconnectCause10) {
                    ArrayList<GsmConnection> arrayList8 = this.droppedDuringPoll;
                    int n21 = n4;
                    GsmConnection gsmConnection20 = arrayList8.remove(n21);
                    Connection.DisconnectCause disconnectCause11 = Connection.DisconnectCause.LOCAL;
                    GsmConnection gsmConnection21 = gsmConnection18;
                    Connection.DisconnectCause disconnectCause12 = disconnectCause11;
                    gsmConnection21.onDisconnect(disconnectCause12);
                } else {
                    Connection.DisconnectCause disconnectCause13 = gsmConnection18.cause;
                    Connection.DisconnectCause disconnectCause14 = disconnectCause13;
                    Connection.DisconnectCause disconnectCause15 = Connection.DisconnectCause.INVALID_NUMBER;
                    Connection.DisconnectCause disconnectCause16 = disconnectCause15;
                    if (disconnectCause14 == disconnectCause16) {
                        ArrayList<GsmConnection> arrayList9 = this.droppedDuringPoll;
                        int n22 = n4;
                        GsmConnection gsmConnection22 = arrayList9.remove(n22);
                        Connection.DisconnectCause disconnectCause17 = Connection.DisconnectCause.INVALID_NUMBER;
                        GsmConnection gsmConnection23 = gsmConnection18;
                        Connection.DisconnectCause disconnectCause18 = disconnectCause17;
                        gsmConnection23.onDisconnect(disconnectCause18);
                    }
                }
            }
            int n23 = n4 + -1;
        }
        if (this.droppedDuringPoll.size() > 0) {
            CommandsInterface commandsInterface = this.cm;
            GsmCallTracker gsmCallTracker = this;
            int n24 = 5;
            Message message = gsmCallTracker.obtainNoPollCompleteMessage(n24);
            commandsInterface.getLastCallFailCause(message);
        }
        if (bl2) {
            this.pollCallsAfterDelay();
        }
        if (gsmConnection != null || bl) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (bl3) {
            this.phone.notifyUnknownConnection();
        }
        if (!bl && gsmConnection == null) {
            return;
        }
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    void hangup(GsmCall gsmCall) throws CallStateException {
        if (gsmCall.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        GsmCall gsmCall2 = this.ringingCall;
        if (gsmCall == gsmCall2) {
            this.log("(ringing) hangup waiting or background");
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.hangupWaitingOrBackground(message);
        } else {
            GsmCall gsmCall3 = this.foregroundCall;
            if (gsmCall == gsmCall3) {
                if (gsmCall.isDialingOrAlerting()) {
                    this.log("(foregnd) hangup dialing or alerting...");
                    GsmConnection gsmConnection = (GsmConnection)gsmCall.getConnections().get(0);
                    this.hangup(gsmConnection);
                } else {
                    this.hangupForegroundResumeBackground();
                }
            } else {
                GsmCall gsmCall4 = this.backgroundCall;
                if (gsmCall != gsmCall4) {
                    String string2 = "GsmCall " + gsmCall + "does not belong to GsmCallTracker " + this;
                    throw new RuntimeException(string2);
                }
                if (this.ringingCall.isRinging()) {
                    this.log("hangup all conns in background call");
                    this.hangupAllConnections(gsmCall);
                } else {
                    this.hangupWaitingOrBackground();
                }
            }
        }
        gsmCall.onHangupLocal();
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void hangup(GsmConnection gsmConnection) throws CallStateException {
        if (gsmConnection.owner != this) {
            String string2 = "GsmConnection " + gsmConnection + "does not belong to GsmCallTracker " + this;
            throw new CallStateException(string2);
        }
        GsmConnection gsmConnection2 = this.pendingMO;
        if (gsmConnection == gsmConnection2) {
            this.log("hangup: set hangupPendingMO to true");
            this.hangupPendingMO = true;
        } else {
            try {
                CommandsInterface commandsInterface = this.cm;
                int n = gsmConnection.getGSMIndex();
                Message message = this.obtainCompleteMessage();
                commandsInterface.hangupConnection(n, message);
            }
            catch (CallStateException callStateException) {
                String string3 = "GsmCallTracker WARN: hangup() on absent connection " + gsmConnection;
                int n = Log.w(LOG_TAG, string3);
            }
        }
        gsmConnection.onHangupLocal();
    }

    void hangupAllConnections(GsmCall gsmCall) throws CallStateException {
        try {
            int n = gsmCall.connections.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                GsmConnection gsmConnection = (GsmConnection)gsmCall.connections.get(n2);
                CommandsInterface commandsInterface = this.cm;
                int n3 = gsmConnection.getGSMIndex();
                Message message = this.obtainCompleteMessage();
                commandsInterface.hangupConnection(n3, message);
                ++n2;
            }
        }
        catch (CallStateException callStateException) {
            String string2 = "hangupConnectionByIndex caught " + callStateException;
            int n = Log.e(LOG_TAG, string2);
            return;
        }
    }

    void hangupConnectionByIndex(GsmCall gsmCall, int n) throws CallStateException {
        int n2 = gsmCall.connections.size();
        for (int i = 0; i < n2; ++i) {
            if (((GsmConnection)gsmCall.connections.get(i)).getGSMIndex() == n) continue;
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.hangupConnection(n, message);
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage();
        commandsInterface.hangupForegroundResumeBackground(message);
    }

    void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage();
        commandsInterface.hangupWaitingOrBackground(message);
    }

    @Override
    protected void log(String string2) {
        String string3 = "[GsmCallTracker] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallEndedRegistrants.add(registrant);
    }

    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallStartedRegistrants.add(registrant);
    }

    void rejectCall() throws CallStateException {
        if (this.ringingCall.getState().isRinging()) {
            CommandsInterface commandsInterface = this.cm;
            Message message = this.obtainCompleteMessage();
            commandsInterface.rejectCall(message);
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    void separate(GsmConnection gsmConnection) throws CallStateException {
        if (gsmConnection.owner != this) {
            String string2 = "GsmConnection " + gsmConnection + "does not belong to GsmCallTracker " + this;
            throw new CallStateException(string2);
        }
        try {
            CommandsInterface commandsInterface = this.cm;
            int n = gsmConnection.getGSMIndex();
            Message message = this.obtainCompleteMessage(12);
            commandsInterface.separateConnection(n, message);
            return;
        }
        catch (CallStateException callStateException) {
            String string3 = "GsmCallTracker WARN: separate() on absent connection " + gsmConnection;
            int n = Log.w(LOG_TAG, string3);
            return;
        }
    }

    void setMute(boolean bl) {
        this.desiredMute = bl;
        CommandsInterface commandsInterface = this.cm;
        boolean bl2 = this.desiredMute;
        commandsInterface.setMute(bl2, null);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        Call.State state;
        Call.State state2 = this.ringingCall.getState();
        if (state2 == (state = Call.State.INCOMING)) {
            throw new CallStateException("cannot be in the incoming state");
        }
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainCompleteMessage(8);
        commandsInterface.switchWaitingOrHoldingAndActive(message);
    }

    public void unregisterForVoiceCallEnded(Handler handler) {
        this.voiceCallEndedRegistrants.remove(handler);
    }

    public void unregisterForVoiceCallStarted(Handler handler) {
        this.voiceCallStartedRegistrants.remove(handler);
    }
}

