/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;

public class GsmConnection
extends Connection {
    static final int EVENT_DTMF_DONE = 1;
    static final int EVENT_NEXT_POST_DIAL = 3;
    static final int EVENT_PAUSE_DONE = 2;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static final String LOG_TAG = "GSM";
    static final int PAUSE_DELAY_FIRST_MILLIS = 100;
    static final int PAUSE_DELAY_MILLIS = 3000;
    static final int WAKE_LOCK_TIMEOUT_MILLIS = 60000;
    String address;
    Connection.DisconnectCause cause;
    long connectTime;
    long connectTimeReal;
    long createTime;
    String dialString;
    long disconnectTime;
    boolean disconnected;
    long duration;
    Handler h;
    long holdingStartTime;
    int index;
    boolean isIncoming;
    private PowerManager.WakeLock mPartialWakeLock;
    int nextPostDialChar;
    int numberPresentation;
    GsmCallTracker owner;
    GsmCall parent;
    Connection.PostDialState postDialState;
    String postDialString;
    UUSInfo uusInfo;

    GsmConnection(Context context, DriverCall driverCall, GsmCallTracker gsmCallTracker, int n) {
        GsmCall gsmCall;
        UUSInfo uUSInfo;
        int n2;
        long l;
        boolean bl;
        String string2;
        int n3;
        Connection.PostDialState postDialState;
        Connection.DisconnectCause disconnectCause;
        this.cause = disconnectCause = Connection.DisconnectCause.NOT_DISCONNECTED;
        this.postDialState = postDialState = Connection.PostDialState.NOT_STARTED;
        this.numberPresentation = n3 = Connection.PRESENTATION_ALLOWED;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = gsmCallTracker;
        Looper looper = this.owner.getLooper();
        MyHandler myHandler = new MyHandler(looper);
        this.h = myHandler;
        this.address = string2 = driverCall.number;
        this.isIncoming = bl = driverCall.isMT;
        this.createTime = l = System.currentTimeMillis();
        this.numberPresentation = n2 = driverCall.numberPresentation;
        this.uusInfo = uUSInfo = driverCall.uusInfo;
        this.index = n;
        DriverCall.State state = driverCall.state;
        this.parent = gsmCall = this.parentFromDCState(state);
        this.parent.attach(this, driverCall);
    }

    GsmConnection(Context context, String string2, GsmCallTracker gsmCallTracker, GsmCall gsmCall) {
        long l;
        String string3;
        String string4;
        int n;
        Connection.PostDialState postDialState;
        Connection.DisconnectCause disconnectCause;
        this.cause = disconnectCause = Connection.DisconnectCause.NOT_DISCONNECTED;
        this.postDialState = postDialState = Connection.PostDialState.NOT_STARTED;
        this.numberPresentation = n = Connection.PRESENTATION_ALLOWED;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = gsmCallTracker;
        Looper looper = this.owner.getLooper();
        MyHandler myHandler = new MyHandler(looper);
        this.h = myHandler;
        this.dialString = string2;
        this.address = string4 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        this.postDialString = string3 = PhoneNumberUtils.extractPostDialPortion(string2);
        this.index = -1;
        this.isIncoming = false;
        this.createTime = l = System.currentTimeMillis();
        this.parent = gsmCall;
        Call.State state = Call.State.DIALING;
        gsmCall.attachFake(this, state);
    }

    private void acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    private void createWakeLock(Context context) {
        PowerManager.WakeLock wakeLock;
        this.mPartialWakeLock = wakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, LOG_TAG);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean equalsHandlesNulls(Object object, Object object2) {
        if (object != null) return object.equals(object2);
        if (object2 != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectingInOrOut() {
        if (this.parent == null) return true;
        GsmCall gsmCall = this.parent;
        GsmCall gsmCall2 = this.owner.ringingCall;
        if (gsmCall == gsmCall2) return true;
        Call.State state = this.parent.state;
        Call.State state2 = Call.State.DIALING;
        if (state == state2) return true;
        Call.State state3 = this.parent.state;
        Call.State state4 = Call.State.ALERTING;
        if (state3 != state4) return false;
        return true;
    }

    private void log(String string2) {
        String string3 = "[GSMConn] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    private void onStartedHolding() {
        long l;
        this.holdingStartTime = l = SystemClock.elapsedRealtime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GsmCall parentFromDCState(DriverCall.State state) {
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$DriverCall$State;
        int n = state.ordinal();
        switch (nArray[n]) {
            default: {
                String string2 = "illegal call state: " + (Object)((Object)state);
                throw new RuntimeException(string2);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.owner.foregroundCall;
            }
            case 4: {
                return this.owner.backgroundCall;
            }
            case 5: 
            case 6: 
        }
        return this.owner.ringingCall;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processNextPostDialChar() {
        Registrant registrant;
        char c;
        int n;
        int n2;
        Connection.PostDialState postDialState = this.postDialState;
        Connection.PostDialState postDialState2 = Connection.PostDialState.CANCELLED;
        if (postDialState == postDialState2) {
            return;
        }
        if (this.postDialString == null || (n2 = this.postDialString.length()) <= (n = this.nextPostDialChar)) {
            Connection.PostDialState postDialState3 = Connection.PostDialState.COMPLETE;
            this.setPostDialState(postDialState3);
            c = '\u0000';
        } else {
            int n3;
            Connection.PostDialState postDialState4 = Connection.PostDialState.STARTED;
            this.setPostDialState(postDialState4);
            String string2 = this.postDialString;
            int n4 = this.nextPostDialChar;
            this.nextPostDialChar = n3 = n4 + 1;
            c = string2.charAt(n4);
            if (!this.processPostDialChar(c)) {
                this.h.obtainMessage(3).sendToTarget();
                String string3 = "processNextPostDialChar: c=" + c + " isn't valid!";
                int n5 = Log.e(LOG_TAG, string3);
                return;
            }
        }
        if ((registrant = this.owner.phone.mPostDialHandler) == null) {
            return;
        }
        Message message = registrant.messageForRegistrant();
        if (message == null) {
            return;
        }
        Connection.PostDialState postDialState5 = this.postDialState;
        AsyncResult asyncResult = AsyncResult.forMessage(message);
        asyncResult.result = this;
        asyncResult.userObj = postDialState5;
        message.arg1 = c;
        message.sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            CommandsInterface commandsInterface = this.owner.cm;
            Message message = this.h.obtainMessage(1);
            commandsInterface.sendDtmf(c, message);
            return true;
        }
        if (c == ',') {
            if (this.nextPostDialChar == 1) {
                Handler handler = this.h;
                Message message = this.h.obtainMessage(2);
                boolean bl = handler.sendMessageDelayed(message, 100L);
                return true;
            }
            Handler handler = this.h;
            Message message = this.h.obtainMessage(2);
            boolean bl = handler.sendMessageDelayed(message, 3000L);
            return true;
        }
        if (c == ';') {
            Connection.PostDialState postDialState = Connection.PostDialState.WAIT;
            this.setPostDialState(postDialState);
            return true;
        }
        if (c != 'N') return false;
        Connection.PostDialState postDialState = Connection.PostDialState.WILD;
        this.setPostDialState(postDialState);
        return true;
    }

    private void releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPostDialState(Connection.PostDialState postDialState) {
        Connection.PostDialState postDialState2;
        Connection.PostDialState postDialState3 = this.postDialState;
        Connection.PostDialState postDialState4 = Connection.PostDialState.STARTED;
        if (postDialState3 != postDialState4 && postDialState == (postDialState2 = Connection.PostDialState.STARTED)) {
            this.acquireWakeLock();
            Message message = this.h.obtainMessage(4);
            boolean bl = this.h.sendMessageDelayed(message, 60000L);
        } else {
            Connection.PostDialState postDialState5;
            Connection.PostDialState postDialState6 = this.postDialState;
            Connection.PostDialState postDialState7 = Connection.PostDialState.STARTED;
            if (postDialState6 == postDialState7 && postDialState != (postDialState5 = Connection.PostDialState.STARTED)) {
                this.h.removeMessages(4);
                this.releaseWakeLock();
            }
        }
        this.postDialState = postDialState;
    }

    @Override
    public void cancelPostDial() {
        Connection.PostDialState postDialState = Connection.PostDialState.CANCELLED;
        this.setPostDialState(postDialState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean compareTo(DriverCall driverCall) {
        if (!this.isIncoming && !driverCall.isMT) {
            return true;
        }
        String string2 = driverCall.number;
        int n = driverCall.TOA;
        String string3 = PhoneNumberUtils.stringFromStringAndTOA(string2, n);
        boolean bl = this.isIncoming;
        boolean bl2 = driverCall.isMT;
        if (bl == bl2) return false;
        if (!GsmConnection.equalsHandlesNulls(this.address, string3)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Connection.DisconnectCause disconnectCauseFromCode(int n) {
        IccCard.State state;
        int n2;
        GSMPhone gSMPhone;
        switch (n) {
            default: {
                gSMPhone = this.owner.phone;
                n2 = gSMPhone.getServiceState().getState();
                if (n2 != 3) break;
                return Connection.DisconnectCause.POWER_OFF;
            }
            case 17: {
                return Connection.DisconnectCause.BUSY;
            }
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 58: {
                return Connection.DisconnectCause.CONGESTION;
            }
            case 68: {
                return Connection.DisconnectCause.LIMIT_EXCEEDED;
            }
            case 240: {
                return Connection.DisconnectCause.CALL_BARRED;
            }
            case 241: {
                return Connection.DisconnectCause.FDN_BLOCKED;
            }
            case 1: {
                return Connection.DisconnectCause.UNOBTAINABLE_NUMBER;
            }
        }
        if (n2 == 1) return Connection.DisconnectCause.OUT_OF_SERVICE;
        if (n2 == 2) {
            return Connection.DisconnectCause.OUT_OF_SERVICE;
        }
        IccCard.State state2 = gSMPhone.getIccCard().getState();
        if (state2 != (state = IccCard.State.READY)) {
            return Connection.DisconnectCause.ICC_ERROR;
        }
        if (n == 65535) {
            if (gSMPhone.mSST.rs.isCsRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED;
            }
            if (gSMPhone.mSST.rs.isCsEmergencyRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_EMERGENCY;
            }
            if (!gSMPhone.mSST.rs.isCsNormalRestricted()) return Connection.DisconnectCause.ERROR_UNSPECIFIED;
            return Connection.DisconnectCause.CS_RESTRICTED_NORMAL;
        }
        if (n != 16) return Connection.DisconnectCause.ERROR_UNSPECIFIED;
        return Connection.DisconnectCause.NORMAL;
    }

    public void dispose() {
    }

    void fakeHoldBeforeDial() {
        GsmCall gsmCall;
        if (this.parent != null) {
            this.parent.detach(this);
        }
        GsmCall gsmCall2 = this.parent = (gsmCall = this.owner.backgroundCall);
        Call.State state = Call.State.HOLDING;
        gsmCall2.attachFake(this, state);
        this.onStartedHolding();
    }

    protected void finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            int n = Log.e(LOG_TAG, "[GSMConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public GsmCall getCall() {
        return this.parent;
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public Connection.DisconnectCause getDisconnectCause() {
        return this.cause;
    }

    @Override
    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration != 0L) return this.duration;
        long l = SystemClock.elapsedRealtime();
        long l2 = this.connectTimeReal;
        return l - l2;
    }

    int getGSMIndex() throws CallStateException {
        if (this.index >= 0) {
            return this.index + 1;
        }
        throw new CallStateException("GSM index not yet assigned");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getHoldDurationMillis() {
        Call.State state;
        Call.State state2 = this.getState();
        if (state2 != (state = Call.State.HOLDING)) {
            return 0L;
        }
        long l = SystemClock.elapsedRealtime();
        long l2 = this.holdingStartTime;
        return l - l2;
    }

    @Override
    public int getNumberPresentation() {
        return this.numberPresentation;
    }

    @Override
    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getRemainingPostDialString() {
        int n;
        Connection.PostDialState postDialState = this.postDialState;
        Connection.PostDialState postDialState2 = Connection.PostDialState.CANCELLED;
        if (postDialState == postDialState2) return "";
        Connection.PostDialState postDialState3 = this.postDialState;
        Connection.PostDialState postDialState4 = Connection.PostDialState.COMPLETE;
        if (postDialState3 == postDialState4) return "";
        if (this.postDialString == null) return "";
        int n2 = this.postDialString.length();
        if (n2 <= (n = this.nextPostDialChar)) {
            return "";
        }
        String string2 = this.postDialString;
        int n3 = this.nextPostDialChar;
        return string2.substring(n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Call.State getState() {
        if (!this.disconnected) return super.getState();
        return Call.State.DISCONNECTED;
    }

    @Override
    public UUSInfo getUUSInfo() {
        return this.uusInfo;
    }

    @Override
    public void hangup() throws CallStateException {
        if (!this.disconnected) {
            this.owner.hangup(this);
            return;
        }
        throw new CallStateException("disconnected");
    }

    @Override
    public boolean isIncoming() {
        return this.isIncoming;
    }

    void onConnectedInOrOut() {
        long l;
        long l2;
        this.connectTime = l2 = System.currentTimeMillis();
        this.connectTimeReal = l = SystemClock.elapsedRealtime();
        this.duration = 0L;
        StringBuilder stringBuilder = new StringBuilder().append("onConnectedInOrOut: connectTime=");
        long l3 = this.connectTime;
        String string2 = stringBuilder.append(l3).toString();
        this.log(string2);
        if (!this.isIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    void onDisconnect(Connection.DisconnectCause disconnectCause) {
        this.cause = disconnectCause;
        if (!this.disconnected) {
            long l;
            long l2;
            this.index = -1;
            this.disconnectTime = l2 = System.currentTimeMillis();
            long l3 = SystemClock.elapsedRealtime();
            long l4 = this.connectTimeReal;
            this.duration = l = l3 - l4;
            this.disconnected = true;
            String string2 = "[GSMConn] onDisconnect: cause=" + (Object)((Object)disconnectCause);
            int n = Log.d(LOG_TAG, string2);
            this.owner.phone.notifyDisconnect(this);
            if (this.parent != null) {
                this.parent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
    }

    void onHangupLocal() {
        Connection.DisconnectCause disconnectCause;
        this.cause = disconnectCause = Connection.DisconnectCause.LOCAL;
    }

    void onRemoteDisconnect(int n) {
        Connection.DisconnectCause disconnectCause = this.disconnectCauseFromCode(n);
        this.onDisconnect(disconnectCause);
    }

    @Override
    public void proceedAfterWaitChar() {
        Connection.PostDialState postDialState = this.postDialState;
        Connection.PostDialState postDialState2 = Connection.PostDialState.WAIT;
        if (postDialState != postDialState2) {
            StringBuilder stringBuilder = new StringBuilder().append("GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was ");
            Connection.PostDialState postDialState3 = this.postDialState;
            String string2 = stringBuilder.append((Object)postDialState3).toString();
            int n = Log.w(LOG_TAG, string2);
            return;
        }
        Connection.PostDialState postDialState4 = Connection.PostDialState.STARTED;
        this.setPostDialState(postDialState4);
        this.processNextPostDialChar();
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        String string3;
        Connection.PostDialState postDialState = this.postDialState;
        Connection.PostDialState postDialState2 = Connection.PostDialState.WILD;
        if (postDialState != postDialState2) {
            StringBuilder stringBuilder = new StringBuilder().append("GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was ");
            Connection.PostDialState postDialState3 = this.postDialState;
            String string4 = stringBuilder.append((Object)postDialState3).toString();
            int n = Log.w(LOG_TAG, string4);
            return;
        }
        Connection.PostDialState postDialState4 = Connection.PostDialState.STARTED;
        this.setPostDialState(postDialState4);
        StringBuilder stringBuilder = new StringBuilder(string2);
        String string5 = this.postDialString;
        int n = this.nextPostDialChar;
        String string6 = string5.substring(n);
        StringBuilder stringBuilder2 = stringBuilder.append(string6);
        this.postDialString = string3 = stringBuilder.toString();
        this.nextPostDialChar = 0;
        StringBuilder stringBuilder3 = new StringBuilder().append("proceedAfterWildChar: new postDialString is ");
        String string7 = this.postDialString;
        String string8 = stringBuilder3.append(string7).toString();
        this.log(string8);
        this.processNextPostDialChar();
    }

    @Override
    public void separate() throws CallStateException {
        if (!this.disconnected) {
            this.owner.separate(this);
            return;
        }
        throw new CallStateException("disconnected");
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean update(DriverCall driverCall) {
        Call.State state;
        Call.State state2;
        boolean bl;
        GsmCall gsmCall;
        Call.State state3;
        boolean bl2 = false;
        boolean bl3 = this.isConnectingInOrOut();
        Call.State state4 = this.getState();
        boolean bl4 = state4 == (state3 = Call.State.HOLDING);
        DriverCall.State state5 = driverCall.state;
        GsmCall gsmCall2 = this.parentFromDCState(state5);
        String string2 = this.address;
        String string3 = driverCall.number;
        if (!GsmConnection.equalsHandlesNulls(string2, string3)) {
            String string4;
            this.log("update: phone # changed!");
            this.address = string4 = driverCall.number;
            bl2 = true;
        }
        if (gsmCall2 != (gsmCall = this.parent)) {
            if (this.parent != null) {
                this.parent.detach(this);
            }
            gsmCall2.attach(this, driverCall);
            this.parent = gsmCall2;
            bl = true;
        } else {
            boolean bl5 = this.parent.update(this, driverCall);
            bl = bl2 || bl5;
        }
        StringBuilder stringBuilder = new StringBuilder().append("update: parent=");
        GsmCall gsmCall3 = this.parent;
        StringBuilder stringBuilder2 = stringBuilder.append(gsmCall3).append(", hasNewParent=");
        GsmCall gsmCall4 = this.parent;
        boolean bl6 = gsmCall2 != gsmCall4;
        StringBuilder stringBuilder3 = stringBuilder2.append(bl6).append(", wasConnectingInOrOut=").append(bl3).append(", wasHolding=").append(bl4).append(", isConnectingInOrOut=");
        boolean bl7 = this.isConnectingInOrOut();
        String string5 = stringBuilder3.append(bl7).append(", changed=").append(bl).toString();
        this.log(string5);
        if (bl3 && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (bl && !bl4 && (state2 = this.getState()) == (state = Call.State.HOLDING)) {
            this.onStartedHolding();
        }
        return bl;
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    GsmConnection.this.processNextPostDialChar();
                    return;
                }
                case 4: 
            }
            GsmConnection.this.releaseWakeLock();
        }
    }
}

