/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Message;
import android.util.Log;
import android.util.Patterns;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;
import java.util.regex.Pattern;

public class GsmDataConnection
extends DataConnection {
    private static final String LOG_TAG = "GSM";
    private static final int PDP_FAIL_ACTIVATION_REJECT_GGSN = 30;
    private static final int PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED = 31;
    private static final int PDP_FAIL_ERROR_UNSPECIFIED = 65535;
    private static final int PDP_FAIL_GPRS_REGISTRATION_FAIL = 254;
    private static final int PDP_FAIL_INSUFFICIENT_RESOURCES = 26;
    private static final int PDP_FAIL_MISSING_UKNOWN_APN = 27;
    private static final int PDP_FAIL_NSAPI_IN_USE = 35;
    private static final int PDP_FAIL_OPERATOR_BARRED = 8;
    private static final int PDP_FAIL_PROTOCOL_ERRORS = 111;
    private static final int PDP_FAIL_REGISTRATION_FAIL = 255;
    private static final int PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED = 33;
    private static final int PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED = 32;
    private static final int PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER = 34;
    private static final int PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE = 28;
    private static final int PDP_FAIL_USER_AUTHENTICATION = 29;
    private ApnSetting apn;

    private GsmDataConnection(GSMPhone gSMPhone, String string2) {
        super(gSMPhone, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isIpAddress(String string2) {
        if (string2 == null) {
            return false;
        }
        Pattern pattern = Patterns.IP_ADDRESS;
        String string3 = this.apn.mmsProxy;
        return pattern.matcher(string3).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static GsmDataConnection makeDataConnection(GSMPhone gSMPhone) {
        Object object = mCountLock;
        // MONITORENTER : object
        // MONITOREXIT : object
        StringBuilder stringBuilder = new StringBuilder().append("GsmDataConnection-");
        int n = ++mCount;
        String string2 = stringBuilder.append(n).toString();
        GsmDataConnection gsmDataConnection = new GsmDataConnection(gSMPhone, string2);
        gsmDataConnection.start();
        StringBuilder stringBuilder2 = new StringBuilder().append("Made ");
        String string3 = gsmDataConnection.getName();
        String string4 = stringBuilder2.append(string3).toString();
        gsmDataConnection.log(string4);
        return gsmDataConnection;
    }

    private void setHttpProxy(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            this.phone.setSystemProperty("net.gprs.http-proxy", null);
            return;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "8080";
        }
        PhoneBase phoneBase = this.phone;
        String string4 = "http://" + string2 + ":" + string3 + "/";
        phoneBase.setSystemProperty("net.gprs.http-proxy", string4);
    }

    @Override
    protected void clearSettings() {
        super.clearSettings();
        this.apn = null;
    }

    public ApnSetting getApn() {
        return this.apn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected DataConnection.FailCause getFailCauseFromRequest(int n) {
        switch (n) {
            default: {
                return DataConnection.FailCause.UNKNOWN;
            }
            case 8: {
                return DataConnection.FailCause.OPERATOR_BARRED;
            }
            case 26: {
                return DataConnection.FailCause.INSUFFICIENT_RESOURCES;
            }
            case 27: {
                return DataConnection.FailCause.MISSING_UNKNOWN_APN;
            }
            case 28: {
                return DataConnection.FailCause.UNKNOWN_PDP_ADDRESS;
            }
            case 29: {
                return DataConnection.FailCause.USER_AUTHENTICATION;
            }
            case 30: {
                return DataConnection.FailCause.ACTIVATION_REJECT_GGSN;
            }
            case 31: {
                return DataConnection.FailCause.ACTIVATION_REJECT_UNSPECIFIED;
            }
            case 34: {
                return DataConnection.FailCause.SERVICE_OPTION_OUT_OF_ORDER;
            }
            case 32: {
                return DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
            }
            case 33: {
                return DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
            }
            case 35: {
                return DataConnection.FailCause.NSAPI_IN_USE;
            }
            case 111: {
                return DataConnection.FailCause.PROTOCOL_ERRORS;
            }
            case 65535: {
                return DataConnection.FailCause.UNKNOWN;
            }
            case -1: {
                return DataConnection.FailCause.REGISTRATION_FAIL;
            }
            case -2: 
        }
        return DataConnection.FailCause.GPRS_REGISTRATION_FAIL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isDnsOk(String[] stringArray) {
        String string2 = this.dnsServers[0];
        if (!"0.0.0.0".equals(string2)) return true;
        String string3 = this.dnsServers[1];
        if (!"0.0.0.0".equals(string3)) return true;
        if (((GSMPhone)this.phone).isDnsCheckDisabled()) return true;
        if (!this.apn.types[0].equals("mms")) return false;
        String string4 = this.apn.mmsProxy;
        if (this.isIpAddress(string4)) return true;
        return false;
    }

    @Override
    protected void log(String string2) {
        StringBuilder stringBuilder = new StringBuilder().append("[");
        String string3 = this.getName();
        String string4 = stringBuilder.append(string3).append("] ").append(string2).toString();
        int n = Log.d(LOG_TAG, string4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onConnect(DataConnection.ConnectionParams connectionParams) {
        DataConnection.FailCause failCause;
        ApnSetting apnSetting;
        this.apn = apnSetting = connectionParams.apn;
        StringBuilder stringBuilder = new StringBuilder().append("Connecting to carrier: '");
        String string2 = this.apn.carrier;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("' APN: '");
        String string3 = this.apn.apn;
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("' proxy: '");
        String string4 = this.apn.proxy;
        StringBuilder stringBuilder4 = stringBuilder3.append(string4).append("' port: '");
        String string5 = this.apn.port;
        String string6 = stringBuilder4.append(string5).toString();
        this.log(string6);
        String string7 = this.apn.proxy;
        String string8 = this.apn.port;
        this.setHttpProxy(string7, string8);
        this.createTime = 65535L;
        this.lastFailTime = 65535L;
        this.lastFailCause = failCause = DataConnection.FailCause.NONE;
        Message message = this.obtainMessage(3, connectionParams);
        message.obj = connectionParams;
        int n = this.apn.authType;
        if (n == -1) {
            n = this.apn.user != null ? 3 : 0;
        }
        CommandsInterface commandsInterface = this.phone.mCM;
        String string9 = Integer.toString(1);
        String string10 = Integer.toString(0);
        String string11 = this.apn.apn;
        String string12 = this.apn.user;
        String string13 = this.apn.password;
        String string14 = Integer.toString(n);
        commandsInterface.setupDataCall(string9, string10, string11, string12, string13, string14, message);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("State=");
        String string2 = this.getCurrentState().getName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" Apn=");
        ApnSetting apnSetting = this.apn;
        StringBuilder stringBuilder3 = stringBuilder2.append(apnSetting).append(" create=");
        long l = this.createTime;
        StringBuilder stringBuilder4 = stringBuilder3.append(l).append(" lastFail=");
        long l2 = this.lastFailTime;
        StringBuilder stringBuilder5 = stringBuilder4.append(l2).append(" lastFailCause=");
        DataConnection.FailCause failCause = this.lastFailCause;
        return stringBuilder5.append((Object)failCause).toString();
    }
}

