/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmDataConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public final class GsmDataConnectionTracker
extends DataConnectionTracker {
    protected static final int APN_DELAY_MILLIS = 5000;
    static final String APN_ID = "apn_id";
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.gprs-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    private static final int PDP_CONNECTION_POOL_SIZE = 1;
    private static final int POLL_PDP_MILLIS = 5000;
    static final Uri PREFERAPN_URI = Uri.parse("content://telephony/carriers/preferapn");
    protected final String LOG_TAG;
    private ArrayList<ApnSetting> allApns = null;
    private ApnChangeObserver apnObserver;
    private boolean canSetPreferApn = false;
    boolean failNextConnect = false;
    protected ApnSetting mActiveApn;
    private GsmDataConnection mActivePdp;
    private RetryManager mDefaultRetryManager;
    private GSMPhone mGsmPhone;
    BroadcastReceiver mIntentReceiver;
    private boolean mIsPsRestricted = false;
    private boolean mIsScreenOn = true;
    private int mPdpResetCount = 0;
    private boolean mPingTestActive = false;
    private Runnable mPollNetStat;
    private boolean mReregisterOnReconnectFailure = false;
    private ContentResolver mResolver;
    private RetryManager mSecondaryRetryManager;
    private boolean noAutoAttach = false;
    private ArrayList<DataConnection> pdpList;
    private ApnSetting preferredApn = null;
    private ArrayList<ApnSetting> waitingApns = null;
    private int waitingApnsPermanentFailureCountDown = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GsmDataConnectionTracker(GSMPhone gSMPhone) {
        super(gSMPhone);
        RetryManager retryManager;
        ApnChangeObserver apnChangeObserver;
        ContentResolver contentResolver;
        Runnable runnable;
        BroadcastReceiver broadcastReceiver;
        this.LOG_TAG = "GSM";
        this.mIntentReceiver = broadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if (string2.equals("android.intent.action.SCREEN_ON")) {
                    boolean bl = GsmDataConnectionTracker.access$102(GsmDataConnectionTracker.this, true);
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    GsmDataConnectionTracker.this.startNetStatPoll();
                    return;
                }
                if (string2.equals("android.intent.action.SCREEN_OFF")) {
                    boolean bl = GsmDataConnectionTracker.access$102(GsmDataConnectionTracker.this, false);
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    GsmDataConnectionTracker.this.startNetStatPoll();
                    return;
                }
                if (string2.equals(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                    DataConnectionTracker.State state;
                    StringBuilder stringBuilder = new StringBuilder().append("GPRS reconnect alarm. Previous state was ");
                    DataConnectionTracker.State state2 = GsmDataConnectionTracker.this.state;
                    String string3 = stringBuilder.append((Object)state2).toString();
                    int n = Log.d("GSM", string3);
                    String string4 = intent.getStringExtra(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                    DataConnectionTracker.State state3 = GsmDataConnectionTracker.this.state;
                    if (state3 == (state = DataConnectionTracker.State.FAILED)) {
                        Message message = GsmDataConnectionTracker.this.obtainMessage(34);
                        message.arg1 = 0;
                        message.obj = string4;
                        boolean bl = GsmDataConnectionTracker.this.sendMessage(message);
                    }
                    GsmDataConnectionTracker gsmDataConnectionTracker = GsmDataConnectionTracker.this;
                    Message message = GsmDataConnectionTracker.this.obtainMessage(5);
                    boolean bl = gsmDataConnectionTracker.sendMessage(message);
                    return;
                }
                if (string2.equals("android.net.wifi.STATE_CHANGE")) {
                    NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    GsmDataConnectionTracker gsmDataConnectionTracker = GsmDataConnectionTracker.this;
                    boolean bl = networkInfo != null && networkInfo.isConnected();
                    boolean bl2 = GsmDataConnectionTracker.access$402(gsmDataConnectionTracker, bl);
                    return;
                }
                if (!string2.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    return;
                }
                if (intent.getIntExtra("wifi_state", 4) == 3) {
                    return;
                }
                boolean bl = false;
                if (bl) {
                    return;
                }
                boolean bl3 = GsmDataConnectionTracker.access$502(GsmDataConnectionTracker.this, false);
            }
        };
        this.mPollNetStat = runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                long l;
                long l2 = GsmDataConnectionTracker.this.txPkts;
                long l3 = GsmDataConnectionTracker.this.rxPkts;
                GsmDataConnectionTracker gsmDataConnectionTracker = GsmDataConnectionTracker.this;
                long l4 = TrafficStats.getMobileTxPackets();
                long l5 = GsmDataConnectionTracker.access$802(gsmDataConnectionTracker, l4);
                GsmDataConnectionTracker gsmDataConnectionTracker2 = GsmDataConnectionTracker.this;
                long l6 = TrafficStats.getMobileRxPackets();
                long l7 = GsmDataConnectionTracker.access$902(gsmDataConnectionTracker2, l6);
                if (GsmDataConnectionTracker.this.netStatPollEnabled && (l2 > 0L || l3 > 0L)) {
                    DataConnectionTracker.Activity activity;
                    DataConnectionTracker.Activity activity2;
                    DataConnectionTracker.Activity activity3;
                    long l8 = GsmDataConnectionTracker.this.txPkts - l2;
                    long l9 = GsmDataConnectionTracker.this.rxPkts - l3;
                    if (l8 > 0L && l9 > 0L) {
                        long l10 = GsmDataConnectionTracker.access$1302(GsmDataConnectionTracker.this, 0L);
                        activity3 = DataConnectionTracker.Activity.DATAINANDOUT;
                        int n = GsmDataConnectionTracker.access$1402(GsmDataConnectionTracker.this, 0);
                    } else if (l8 > 0L && l9 == 0L) {
                        Phone.State state;
                        Phone.State state2;
                        Phone.State state3 = GsmDataConnectionTracker.this.phone.getState();
                        Phone.State state4 = state3;
                        if (state4 == (state2 = (state = Phone.State.IDLE))) {
                            GsmDataConnectionTracker gsmDataConnectionTracker3 = GsmDataConnectionTracker.this;
                            long l11 = l8;
                            long l12 = GsmDataConnectionTracker.access$1614(gsmDataConnectionTracker3, l11);
                        } else {
                            long l13 = GsmDataConnectionTracker.access$1702(GsmDataConnectionTracker.this, 0L);
                        }
                        activity3 = DataConnectionTracker.Activity.DATAOUT;
                    } else if (l8 == 0L && l9 > 0L) {
                        long l14 = GsmDataConnectionTracker.access$1802(GsmDataConnectionTracker.this, 0L);
                        activity3 = DataConnectionTracker.Activity.DATAIN;
                        int n = GsmDataConnectionTracker.access$1402(GsmDataConnectionTracker.this, 0);
                    } else if (l8 == 0L && l9 == 0L) {
                        activity3 = DataConnectionTracker.Activity.NONE;
                    } else {
                        long l15 = GsmDataConnectionTracker.access$1902(GsmDataConnectionTracker.this, 0L);
                        activity3 = DataConnectionTracker.Activity.NONE;
                    }
                    if ((activity2 = GsmDataConnectionTracker.this.activity) != (activity = activity3) && GsmDataConnectionTracker.this.mIsScreenOn) {
                        GsmDataConnectionTracker gsmDataConnectionTracker4 = GsmDataConnectionTracker.this;
                        DataConnectionTracker.Activity activity4 = activity3;
                        DataConnectionTracker.Activity activity5 = GsmDataConnectionTracker.access$2102(gsmDataConnectionTracker4, activity4);
                        GsmDataConnectionTracker.this.phone.notifyDataActivity();
                    }
                }
                int n = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
                long l16 = GsmDataConnectionTracker.this.sentSinceLastRecv;
                if (l16 >= (l = (long)n)) {
                    int n2;
                    if (GsmDataConnectionTracker.this.mNoRecvPollCount == 0) {
                        long l17 = GsmDataConnectionTracker.this.sentSinceLastRecv;
                        int n3 = EventLog.writeEvent(50101, l17);
                    }
                    int n4 = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_count", 24);
                    int n5 = GsmDataConnectionTracker.this.mNoRecvPollCount;
                    if (n5 < (n2 = n4)) {
                        CommandsInterface commandsInterface = ((GsmDataConnectionTracker)GsmDataConnectionTracker.this).phone.mCM;
                        Message message = GsmDataConnectionTracker.this.obtainMessage(11);
                        commandsInterface.getDataCallList(message);
                        int n6 = GsmDataConnectionTracker.access$2908(GsmDataConnectionTracker.this);
                        GsmDataConnectionTracker gsmDataConnectionTracker5 = GsmDataConnectionTracker.this;
                        int n7 = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_interval_ms", 5000);
                        int n8 = GsmDataConnectionTracker.access$3002(gsmDataConnectionTracker5, n7);
                    } else {
                        1 var69_50;
                        GsmDataConnectionTracker.this.stopNetStatPoll();
                        1 var70_51 = var69_50;
                        2 var71_52 = this;
                        var70_51();
                        boolean bl = GsmDataConnectionTracker.access$3202(GsmDataConnectionTracker.this, true);
                        var69_50.start();
                    }
                } else {
                    int n9 = GsmDataConnectionTracker.access$3302(GsmDataConnectionTracker.this, 0);
                    if (GsmDataConnectionTracker.this.mIsScreenOn) {
                        GsmDataConnectionTracker gsmDataConnectionTracker6 = GsmDataConnectionTracker.this;
                        int n10 = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
                        int n11 = GsmDataConnectionTracker.access$3402(gsmDataConnectionTracker6, n10);
                    } else {
                        GsmDataConnectionTracker gsmDataConnectionTracker7 = GsmDataConnectionTracker.this;
                        int n12 = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
                        int n13 = GsmDataConnectionTracker.access$3502(gsmDataConnectionTracker7, n12);
                    }
                }
                if (!GsmDataConnectionTracker.this.netStatPollEnabled) {
                    return;
                }
                Handler handler = GsmDataConnectionTracker.this.mDataConnectionTracker;
                long l18 = GsmDataConnectionTracker.this.netStatPollPeriod;
                Handler handler2 = handler;
                2 var49_36 = this;
                long l19 = l18;
                boolean bl = handler2.postDelayed(var49_36, l19);
            }
        };
        this.mGsmPhone = gSMPhone;
        gSMPhone.mCM.registerForAvailable(this, 3, null);
        gSMPhone.mCM.registerForOffOrNotAvailable(this, 12, null);
        gSMPhone.mSIMRecords.registerForRecordsLoaded(this, 4, null);
        gSMPhone.mCM.registerForDataStateChanged(this, 6, null);
        gSMPhone.mCT.registerForVoiceCallEnded(this, 15, null);
        gSMPhone.mCT.registerForVoiceCallStarted(this, 14, null);
        gSMPhone.mSST.registerForGprsAttached(this, 26, null);
        gSMPhone.mSST.registerForGprsDetached(this, 19, null);
        gSMPhone.mSST.registerForRoamingOn(this, 21, null);
        gSMPhone.mSST.registerForRoamingOff(this, 22, null);
        gSMPhone.mSST.registerForPsRestrictedEnabled(this, 32, null);
        gSMPhone.mSST.registerForPsRestrictedDisabled(this, 33, null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(INTENT_RECONNECT_ALARM);
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        Context context = gSMPhone.getContext();
        BroadcastReceiver broadcastReceiver2 = this.mIntentReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver2, intentFilter, null, gSMPhone);
        this.mDataConnectionTracker = this;
        this.mResolver = contentResolver = this.phone.getContext().getContentResolver();
        this.apnObserver = apnChangeObserver = new ApnChangeObserver();
        ContentResolver contentResolver2 = gSMPhone.getContext().getContentResolver();
        Uri uri = Telephony.Carriers.CONTENT_URI;
        ApnChangeObserver apnChangeObserver2 = this.apnObserver;
        contentResolver2.registerContentObserver(uri, true, apnChangeObserver2);
        this.createAllPdpList();
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean bl = true;
        try {
            boolean bl2;
            bl = bl2 = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")).getMobileDataEnabled();
        }
        catch (Exception exception) {}
        boolean[] blArray = this.dataEnabled;
        boolean bl3 = !sharedPreferences.getBoolean("disabled_on_boot_key", false) && bl;
        blArray[0] = bl3;
        if (this.dataEnabled[0] != null) {
            int n;
            this.enabledCount = n = this.enabledCount + 1;
        }
        boolean bl4 = this.dataEnabled[0] == null;
        this.noAutoAttach = bl4;
        RetryManager retryManager2 = this.mRetryMgr;
        String string2 = SystemProperties.get("ro.gsm.data_retry_config");
        if (!retryManager2.configure(string2) && !this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            int n = Log.e("GSM", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
            boolean bl5 = this.mRetryMgr.configure(20, 2000, 1000);
        }
        this.mDefaultRetryManager = retryManager = this.mRetryMgr;
        RetryManager retryManager3 = new RetryManager();
        this.mSecondaryRetryManager = retryManager3;
        RetryManager retryManager4 = this.mSecondaryRetryManager;
        String string3 = SystemProperties.get("ro.gsm.2nd_data_retry_config");
        if (retryManager4.configure(string3)) {
            return;
        }
        if (this.mSecondaryRetryManager.configure("max_retries=3, 5000, 5000, 5000")) {
            return;
        }
        int n = Log.e("GSM", "Could note configure using SECONDARY_DATA_RETRY_CONFIG=max_retries=3, 5000, 5000, 5000");
        boolean bl6 = this.mSecondaryRetryManager.configure("max_retries=3, 333, 333, 333");
    }

    static /* synthetic */ boolean access$102(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mIsScreenOn = bl;
        return bl;
    }

    static /* synthetic */ long access$1302(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ int access$1402(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.mPdpResetCount = n;
        return n;
    }

    static /* synthetic */ long access$1614(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        long l2;
        gsmDataConnectionTracker.sentSinceLastRecv = l2 = gsmDataConnectionTracker.sentSinceLastRecv + l;
        return l2;
    }

    static /* synthetic */ long access$1702(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1802(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1902(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ DataConnectionTracker.Activity access$2102(GsmDataConnectionTracker gsmDataConnectionTracker, DataConnectionTracker.Activity activity) {
        gsmDataConnectionTracker.activity = activity;
        return activity;
    }

    static /* synthetic */ int access$2908(GsmDataConnectionTracker gsmDataConnectionTracker) {
        int n;
        int n2 = gsmDataConnectionTracker.mNoRecvPollCount;
        gsmDataConnectionTracker.mNoRecvPollCount = n = n2 + 1;
        return n2;
    }

    static /* synthetic */ int access$3002(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$3202(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mPingTestActive = bl;
        return bl;
    }

    static /* synthetic */ int access$3302(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.mNoRecvPollCount = n;
        return n;
    }

    static /* synthetic */ int access$3402(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ int access$3502(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$402(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ long access$802(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.txPkts = l;
        return l;
    }

    static /* synthetic */ long access$902(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.rxPkts = l;
        return l;
    }

    private String apnListToString(ArrayList<ApnSetting> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder2 = stringBuilder.append('[');
            String string2 = arrayList.get(i).toString();
            StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(']');
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<ApnSetting> buildWaitingApns() {
        ArrayList<ApnSetting> arrayList = new ArrayList<ApnSetting>();
        if (this.mRequestedApnType.equals("dun")) {
            ApnSetting apnSetting = this.fetchDunApn();
            if (apnSetting == null) return arrayList;
            boolean bl = arrayList.add(apnSetting);
            return arrayList;
        }
        String string2 = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (this.mRequestedApnType.equals("default") && this.canSetPreferApn && this.preferredApn != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Preferred APN:").append(string2).append(":");
            String string3 = this.preferredApn.numeric;
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(":");
            ApnSetting apnSetting = this.preferredApn;
            String string4 = stringBuilder2.append(apnSetting).toString();
            int n = Log.i("GSM", string4);
            if (this.preferredApn.numeric.equals(string2)) {
                int n2 = Log.i("GSM", "Waiting APN set to preferred APN");
                ApnSetting apnSetting2 = this.preferredApn;
                boolean bl = arrayList.add(apnSetting2);
                return arrayList;
            }
            this.setPreferredApn(-1);
            this.preferredApn = null;
        }
        if (this.allApns == null) return arrayList;
        Iterator<ApnSetting> iterator = this.allApns.iterator();
        while (iterator.hasNext()) {
            String string5;
            ApnSetting apnSetting = iterator.next();
            if (!apnSetting.canHandleType(string5 = this.mRequestedApnType)) continue;
            boolean bl = arrayList.add(apnSetting);
        }
        return arrayList;
    }

    private void cleanUpConnection(boolean bl, String string2) {
        if (this.mReconnectIntent != null) {
            AlarmManager alarmManager = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            PendingIntent pendingIntent = this.mReconnectIntent;
            alarmManager.cancel(pendingIntent);
            this.mReconnectIntent = null;
        }
        DataConnectionTracker.State state = DataConnectionTracker.State.DISCONNECTING;
        this.setState(state);
        boolean bl2 = false;
        for (DataConnection dataConnection : this.pdpList) {
            if (bl) {
                Message message = this.obtainMessage(25, string2);
                dataConnection.disconnect(message);
                bl2 = true;
                continue;
            }
            dataConnection.resetSynchronously();
            bl2 = false;
        }
        this.stopNetStatPoll();
        if (bl2) {
            return;
        }
        this.gotoIdleAndNotifyDataConnection(string2);
    }

    private void createAllApnList() {
        ApnSetting apnSetting;
        ArrayList arrayList = new ArrayList();
        this.allApns = arrayList;
        String string2 = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (string2 != null) {
            String string3;
            String[] stringArray;
            Uri uri;
            String string4 = "numeric = '" + string2 + "'";
            ContentResolver contentResolver = this.phone.getContext().getContentResolver();
            Cursor cursor = contentResolver.query(uri = Telephony.Carriers.CONTENT_URI, null, string4, stringArray = null, string3 = null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    ArrayList<ApnSetting> arrayList2 = this.createApnList(cursor);
                    this.allApns = arrayList2;
                }
                cursor.close();
            }
        }
        if (this.allApns.isEmpty()) {
            this.preferredApn = null;
            DataConnection.FailCause failCause = DataConnection.FailCause.MISSING_UNKNOWN_APN;
            this.notifyNoData(failCause);
            return;
        }
        this.preferredApn = apnSetting = this.getPreferredApn();
        int n = Log.d("GSM", "Get PreferredAPN");
        if (this.preferredApn == null) {
            return;
        }
        if (this.preferredApn.numeric.equals(string2)) {
            return;
        }
        this.preferredApn = null;
        this.setPreferredApn(-1);
    }

    private void createAllPdpList() {
        ArrayList arrayList = new ArrayList();
        this.pdpList = arrayList;
        int n = 0;
        while (n < 1) {
            GsmDataConnection gsmDataConnection = GsmDataConnection.makeDataConnection(this.mGsmPhone);
            boolean bl = this.pdpList.add(gsmDataConnection);
            ++n;
        }
        return;
    }

    private ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> arrayList = new ArrayList<ApnSetting>();
        if (cursor.moveToFirst()) {
            do {
                Cursor cursor2 = cursor;
                String string2 = "type";
                int n = cursor2.getColumnIndexOrThrow(string2);
                Cursor cursor3 = cursor;
                int n2 = n;
                String string3 = cursor3.getString(n2);
                GsmDataConnectionTracker gsmDataConnectionTracker = this;
                String string4 = string3;
                String[] stringArray = gsmDataConnectionTracker.parseTypes(string4);
                Cursor cursor4 = cursor;
                String string5 = "_id";
                int n3 = cursor4.getColumnIndexOrThrow(string5);
                Cursor cursor5 = cursor;
                int n4 = n3;
                int n5 = cursor5.getInt(n4);
                Cursor cursor6 = cursor;
                String string6 = "numeric";
                int n6 = cursor6.getColumnIndexOrThrow(string6);
                Cursor cursor7 = cursor;
                int n7 = n6;
                String string7 = cursor7.getString(n7);
                Cursor cursor8 = cursor;
                String string8 = "name";
                int n8 = cursor8.getColumnIndexOrThrow(string8);
                Cursor cursor9 = cursor;
                int n9 = n8;
                String string9 = cursor9.getString(n9);
                Cursor cursor10 = cursor;
                String string10 = "apn";
                int n10 = cursor10.getColumnIndexOrThrow(string10);
                Cursor cursor11 = cursor;
                int n11 = n10;
                String string11 = cursor11.getString(n11);
                Cursor cursor12 = cursor;
                String string12 = "proxy";
                int n12 = cursor12.getColumnIndexOrThrow(string12);
                Cursor cursor13 = cursor;
                int n13 = n12;
                String string13 = cursor13.getString(n13);
                Cursor cursor14 = cursor;
                String string14 = "port";
                int n14 = cursor14.getColumnIndexOrThrow(string14);
                Cursor cursor15 = cursor;
                int n15 = n14;
                String string15 = cursor15.getString(n15);
                Cursor cursor16 = cursor;
                String string16 = "mmsc";
                int n16 = cursor16.getColumnIndexOrThrow(string16);
                Cursor cursor17 = cursor;
                int n17 = n16;
                String string17 = cursor17.getString(n17);
                Cursor cursor18 = cursor;
                String string18 = "mmsproxy";
                int n18 = cursor18.getColumnIndexOrThrow(string18);
                Cursor cursor19 = cursor;
                int n19 = n18;
                String string19 = cursor19.getString(n19);
                Cursor cursor20 = cursor;
                String string20 = "mmsport";
                int n20 = cursor20.getColumnIndexOrThrow(string20);
                Cursor cursor21 = cursor;
                int n21 = n20;
                String string21 = cursor21.getString(n21);
                Cursor cursor22 = cursor;
                String string22 = "user";
                int n22 = cursor22.getColumnIndexOrThrow(string22);
                Cursor cursor23 = cursor;
                int n23 = n22;
                String string23 = cursor23.getString(n23);
                Cursor cursor24 = cursor;
                String string24 = "password";
                int n24 = cursor24.getColumnIndexOrThrow(string24);
                Cursor cursor25 = cursor;
                int n25 = n24;
                String string25 = cursor25.getString(n25);
                Cursor cursor26 = cursor;
                String string26 = "authtype";
                int n26 = cursor26.getColumnIndexOrThrow(string26);
                Cursor cursor27 = cursor;
                int n27 = n26;
                int n28 = cursor27.getInt(n27);
                ApnSetting apnSetting = new ApnSetting(n5, string7, string9, string11, string13, string15, string17, string19, string21, string23, string25, n28, stringArray);
                ArrayList<ApnSetting> arrayList2 = arrayList;
                ApnSetting apnSetting2 = apnSetting;
                boolean bl = arrayList2.add(apnSetting2);
            } while (cursor.moveToNext());
        }
        return arrayList;
    }

    private void destroyAllPdpList() {
        if (this.pdpList == null) {
            return;
        }
        ArrayList<DataConnection> arrayList = this.pdpList;
        ArrayList<DataConnection> arrayList2 = this.pdpList;
        boolean bl = arrayList.removeAll(arrayList2);
    }

    private void doRecovery() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        int n = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_max_pdp_reset_fail_count", 3);
        if (this.mPdpResetCount < n) {
            int n2;
            this.mPdpResetCount = n2 = this.mPdpResetCount + 1;
            long l = this.sentSinceLastRecv;
            int n3 = EventLog.writeEvent(50102, l);
            this.cleanUpConnection(true, "pdpReset");
            return;
        }
        this.mPdpResetCount = 0;
        long l = this.sentSinceLastRecv;
        int n4 = EventLog.writeEvent(50104, l);
        this.mGsmPhone.mSST.reRegisterNetwork(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApnSetting fetchDunApn() {
        Context context = this.phone.getContext();
        ApnSetting apnSetting = ApnSetting.fromString(Settings.Secure.getString(context.getContentResolver(), "tether_dun_apn"));
        if (apnSetting == null) return ApnSetting.fromString(context.getResources().getString(17039383));
        return apnSetting;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GsmDataConnection findFreePdp() {
        GsmDataConnection gsmDataConnection;
        Iterator<DataConnection> iterator = this.pdpList.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while (!(gsmDataConnection = (GsmDataConnection)iterator.next()).isInactive());
        return gsmDataConnection;
    }

    private ApnSetting getNextApn() {
        ArrayList<ApnSetting> arrayList = this.waitingApns;
        ApnSetting apnSetting = null;
        if (arrayList != null && !arrayList.isEmpty()) {
            apnSetting = arrayList.get(0);
        }
        return apnSetting;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ApnSetting getPreferredApn() {
        if (this.allApns.isEmpty()) {
            return null;
        }
        ContentResolver contentResolver = this.phone.getContext().getContentResolver();
        Uri uri = PREFERAPN_URI;
        String[] stringArray = new String[]{"_id", "name", "apn"};
        String[] stringArray2 = null;
        Cursor cursor = contentResolver.query(uri, stringArray, null, stringArray2, "name ASC");
        this.canSetPreferApn = cursor != null;
        if (this.canSetPreferApn && cursor.getCount() > 0) {
            boolean bl = cursor.moveToFirst();
            int n = cursor.getColumnIndexOrThrow("_id");
            int n2 = cursor.getInt(n);
            for (ApnSetting apnSetting : this.allApns) {
                String string2;
                if (apnSetting.id == n2 || !apnSetting.canHandleType(string2 = this.mRequestedApnType)) continue;
                cursor.close();
                return apnSetting;
            }
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
    }

    private void gotoIdleAndNotifyDataConnection(String string2) {
        DataConnectionTracker.State state = DataConnectionTracker.State.IDLE;
        this.setState(state);
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDataAllowed() {
        boolean bl = this.phone.getServiceState().getRoaming();
        if (!this.getAnyDataEnabled()) return false;
        if (bl) {
            if (!this.getDataOnRoamingEnabled()) return false;
        }
        if (!this.mMasterDataEnabled) return false;
        return true;
    }

    private void notifyDefaultData(String string2) {
        DataConnectionTracker.State state = DataConnectionTracker.State.CONNECTED;
        this.setState(state);
        this.phone.notifyDataConnection(string2);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
    }

    private void notifyNoData(DataConnection.FailCause failCause) {
        DataConnectionTracker.State state = DataConnectionTracker.State.FAILED;
        this.setState(state);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onApnChanged() {
        DataConnectionTracker.State state;
        DataConnectionTracker.State state2;
        DataConnectionTracker.State state3 = this.state;
        DataConnectionTracker.State state4 = DataConnectionTracker.State.IDLE;
        boolean bl = state3 != state4 && (state2 = this.state) != (state = DataConnectionTracker.State.FAILED);
        boolean bl2 = this.mGsmPhone.updateCurrentCarrierInProvider();
        this.createAllApnList();
        DataConnectionTracker.State state5 = this.state;
        DataConnectionTracker.State state6 = DataConnectionTracker.State.DISCONNECTING;
        if (state5 == state6) {
            return;
        }
        this.cleanUpConnection(bl, "apnChanged");
        if (bl) {
            return;
        }
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        boolean bl3 = this.trySetupData("apnChanged");
    }

    private void onGprsAttached() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state == state2) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("gprsAttached");
            return;
        }
        DataConnectionTracker.State state3 = this.state;
        DataConnectionTracker.State state4 = DataConnectionTracker.State.FAILED;
        if (state3 == state4) {
            this.cleanUpConnection(false, "gprsAttached");
            this.mRetryMgr.resetRetryCount();
        }
        boolean bl = this.trySetupData("gprsAttached");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] parseTypes(String string2) {
        if (string2 != null) {
            if (!string2.equals("")) return string2.split(",");
        }
        String[] stringArray = new String[]{"*"};
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pdpStatesHasActiveCID(ArrayList<DataCallState> arrayList, int n) {
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            if (arrayList.get((int)n2).cid != n && arrayList.get((int)n2).active != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pdpStatesHasCID(ArrayList<DataCallState> arrayList, int n) {
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            if (arrayList.get((int)n2).cid != n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void reconnectAfterFail(DataConnection.FailCause failCause, String string2) {
        PendingIntent pendingIntent;
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.FAILED;
        if (state != state2) {
            return;
        }
        if (!this.mRetryMgr.isRetryNeeded()) {
            if (!this.mRequestedApnType.equals("default")) {
                this.phone.notifyDataConnection("apnFailed");
                String string3 = this.mRequestedApnType;
                int n = this.apnTypeToId(string3);
                this.onEnableApn(n, 0);
                return;
            }
            if (!this.mReregisterOnReconnectFailure) {
                int n = Log.d("GSM", "PDP activate failed, Reregistering to the network");
                this.mReregisterOnReconnectFailure = true;
                this.mGsmPhone.mSST.reRegisterNetwork(null);
                this.mRetryMgr.resetRetryCount();
                return;
            }
            this.mRetryMgr.retryForeverUsingLastTimeout();
        }
        int n = this.mRetryMgr.getRetryTimer();
        StringBuilder stringBuilder = new StringBuilder().append("PDP activate failed. Scheduling next attempt for ");
        int n2 = n / 1000;
        String string4 = stringBuilder.append(n2).append("s").toString();
        int n3 = Log.d("GSM", string4);
        AlarmManager alarmManager = (AlarmManager)this.phone.getContext().getSystemService("alarm");
        Intent intent = new Intent(INTENT_RECONNECT_ALARM);
        Intent intent2 = intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, string2);
        this.mReconnectIntent = pendingIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
        long l = SystemClock.elapsedRealtime();
        long l2 = n;
        long l3 = l + l2;
        PendingIntent pendingIntent2 = this.mReconnectIntent;
        alarmManager.set(2, l3, pendingIntent2);
        this.mRetryMgr.increaseRetryCount();
        if (!this.shouldPostNotification(failCause)) {
            int n4 = Log.d("GSM", "NOT Posting GPRS Unavailable notification -- likely transient error");
            return;
        }
        this.notifyNoData(failCause);
    }

    private void resetPollStats() {
        this.txPkts = 65535L;
        this.rxPkts = 65535L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    private boolean retryAfterDisconnected(String string2) {
        boolean bl = true;
        if ("radioTurnedOff".equals(string2)) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runPingTest() {
        int n = -1;
        try {
            String string2 = Settings.Secure.getString(this.mResolver, "pdp_watchdog_ping_address");
            int n2 = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_ping_deadline", 5);
            if (string2 != null && !"0.0.0.0".equals(string2)) {
                int n3;
                Runtime runtime = Runtime.getRuntime();
                String string3 = "ping -c 1 -i 1 -w " + n2 + " " + string2;
                n = n3 = runtime.exec(string3).waitFor();
            }
        }
        catch (IOException iOException) {
            int n4 = Log.w("GSM", "ping failed: IOException");
        }
        catch (Exception exception) {
            int n5 = Log.w("GSM", "exception trying to ping");
        }
        if (n == 0) {
            int n6 = EventLog.writeEvent(50102, -1);
            this.mPdpResetCount = 0;
            Message message = this.obtainMessage(27);
            boolean bl = this.sendMessage(message);
            return;
        }
        Message message = this.obtainMessage(28);
        boolean bl = this.sendMessage(message);
    }

    private void setPreferredApn(int n) {
        if (!this.canSetPreferApn) {
            return;
        }
        ContentResolver contentResolver = this.phone.getContext().getContentResolver();
        Uri uri = PREFERAPN_URI;
        int n2 = contentResolver.delete(uri, null, null);
        if (n < 0) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        Integer n3 = n;
        contentValues.put(APN_ID, n3);
        Uri uri2 = PREFERAPN_URI;
        Uri uri3 = contentResolver.insert(uri2, contentValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setupData(String string2) {
        boolean bl = false;
        ApnSetting apnSetting = this.getNextApn();
        if (apnSetting == null) {
            return bl;
        }
        GsmDataConnection gsmDataConnection = this.findFreePdp();
        if (gsmDataConnection == null) return bl;
        this.mActiveApn = apnSetting;
        this.mActivePdp = gsmDataConnection;
        Message message = this.obtainMessage();
        message.what = 1;
        message.obj = string2;
        gsmDataConnection.connect(message, apnSetting);
        DataConnectionTracker.State state = DataConnectionTracker.State.INITING;
        this.setState(state);
        this.phone.notifyDataConnection(string2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldPostNotification(DataConnection.FailCause failCause) {
        DataConnection.FailCause failCause2 = DataConnection.FailCause.UNKNOWN;
        if (failCause == failCause2) return false;
        return true;
    }

    private void startDelayedRetry(DataConnection.FailCause failCause, String string2) {
        this.notifyNoData(failCause);
        this.reconnectAfterFail(failCause, string2);
    }

    private void startPeriodicPdpPoll() {
        this.removeMessages(7);
        Message message = this.obtainMessage(7);
        boolean bl = this.sendMessageDelayed(message, 5000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean trySetupData(String string2) {
        int n;
        Phone.State state;
        StringBuilder stringBuilder = new StringBuilder().append("[DSAC DEB] trySetupData with mIsPsRestricted=");
        boolean bl = this.mIsPsRestricted;
        String string3 = stringBuilder.append(bl).toString();
        int n2 = Log.d("GSM", string3);
        if (this.phone.getSimulatedRadioControl() != null) {
            DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
            this.setState(state2);
            this.phone.notifyDataConnection(string2);
            int n3 = Log.i("GSM", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int n4 = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean bl2 = this.mGsmPhone.mSST.getDesiredPowerState();
        DataConnectionTracker.State state3 = this.state;
        DataConnectionTracker.State state4 = DataConnectionTracker.State.IDLE;
        if (state3 != state4) {
            DataConnectionTracker.State state5 = this.state;
            DataConnectionTracker.State state6 = DataConnectionTracker.State.SCANNING;
            if (state5 != state6) return false;
        }
        if (n4 != 0) {
            if (!this.noAutoAttach) return false;
        }
        if (!this.mGsmPhone.mSIMRecords.getRecordsLoaded()) return false;
        Phone.State state7 = this.phone.getState();
        if (state7 != (state = Phone.State.IDLE)) return false;
        if (!this.isDataAllowed()) return false;
        if (this.mIsPsRestricted) return false;
        if (!bl2) return false;
        DataConnectionTracker.State state8 = this.state;
        DataConnectionTracker.State state9 = DataConnectionTracker.State.IDLE;
        if (state8 != state9) return this.setupData(string2);
        ArrayList<ApnSetting> arrayList = this.buildWaitingApns();
        this.waitingApns = arrayList;
        this.waitingApnsPermanentFailureCountDown = n = this.waitingApns.size();
        if (this.waitingApns.isEmpty()) {
            DataConnection.FailCause failCause = DataConnection.FailCause.MISSING_UNKNOWN_APN;
            this.notifyNoData(failCause);
            return false;
        }
        StringBuilder stringBuilder2 = new StringBuilder().append("Create from allApns : ");
        ArrayList<ApnSetting> arrayList2 = this.allApns;
        String string4 = this.apnListToString(arrayList2);
        String string5 = stringBuilder2.append(string4).toString();
        this.log(string5);
        return this.setupData(string2);
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mGsmPhone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mGsmPhone.mSST.unregisterForGprsAttached(this);
        this.mGsmPhone.mSST.unregisterForGprsDetached(this);
        this.mGsmPhone.mSST.unregisterForRoamingOn(this);
        this.mGsmPhone.mSST.unregisterForRoamingOff(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedEnabled(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedDisabled(this);
        Context context = this.phone.getContext();
        BroadcastReceiver broadcastReceiver = this.mIntentReceiver;
        context.unregisterReceiver(broadcastReceiver);
        ContentResolver contentResolver = this.phone.getContext().getContentResolver();
        ApnChangeObserver apnChangeObserver = this.apnObserver;
        contentResolver.unregisterContentObserver(apnChangeObserver);
        this.destroyAllPdpList();
    }

    protected void finalize() {
    }

    @Override
    protected String getActiveApnString() {
        String string2 = null;
        if (this.mActiveApn != null) {
            string2 = this.mActiveApn.apn;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getActiveApnTypes() {
        if (this.mActiveApn != null) {
            return this.mActiveApn.types;
        }
        String[] stringArray = new String[]{"default"};
        return stringArray;
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        return (ArrayList)this.pdpList.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[] getDnsServers(String string2) {
        if (this.mActivePdp == null) return null;
        if (string2 == null) return this.mActivePdp.getDnsServers();
        if (this.mActiveApn == null) return null;
        if (!this.mActiveApn.canHandleType(string2)) return null;
        return this.mActivePdp.getDnsServers();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getGateway(String string2) {
        if (this.mActivePdp == null) return null;
        if (string2 == null) return this.mActivePdp.getGatewayAddress();
        if (this.mActiveApn == null) return null;
        if (!this.mActiveApn.canHandleType(string2)) return null;
        return this.mActivePdp.getGatewayAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getInterfaceName(String string2) {
        if (this.mActivePdp == null) return null;
        if (string2 == null) return this.mActivePdp.getInterface();
        if (this.mActiveApn == null) return null;
        if (!this.mActiveApn.canHandleType(string2)) return null;
        return this.mActivePdp.getInterface();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getIpAddress(String string2) {
        if (this.mActivePdp == null) return null;
        if (string2 == null) return this.mActivePdp.getIpAddress();
        if (this.mActiveApn == null) return null;
        if (!this.mActiveApn.canHandleType(string2)) return null;
        return this.mActivePdp.getIpAddress();
    }

    @Override
    public void handleMessage(Message message) {
        if (!this.mGsmPhone.mIsTheCurrentActivePhone) {
            int n = Log.d("GSM", "Ignore GSM msgs since GSM phone is inactive");
            return;
        }
        switch (message.what) {
            default: {
                super.handleMessage(message);
                return;
            }
            case 4: {
                this.onRecordsLoaded();
                return;
            }
            case 19: {
                this.onGprsDetached();
                return;
            }
            case 26: {
                this.onGprsAttached();
                return;
            }
            case 6: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onPdpStateChanged(asyncResult, false);
                return;
            }
            case 11: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onPdpStateChanged(asyncResult, true);
                return;
            }
            case 7: {
                this.onPollPdp();
                return;
            }
            case 27: {
                this.mPingTestActive = false;
                this.startNetStatPoll();
                return;
            }
            case 28: {
                this.mPingTestActive = false;
                this.doRecovery();
                return;
            }
            case 29: {
                this.onApnChanged();
                return;
            }
            case 32: {
                StringBuilder stringBuilder = new StringBuilder().append("[DSAC DEB] EVENT_PS_RESTRICT_ENABLED ");
                boolean bl = this.mIsPsRestricted;
                String string2 = stringBuilder.append(bl).toString();
                int n = Log.d("GSM", string2);
                this.stopNetStatPoll();
                this.mIsPsRestricted = true;
                return;
            }
            case 33: 
        }
        StringBuilder stringBuilder = new StringBuilder().append("[DSAC DEB] EVENT_PS_RESTRICT_DISABLED ");
        boolean bl = this.mIsPsRestricted;
        String string3 = stringBuilder.append(bl).toString();
        int n = Log.d("GSM", string3);
        this.mIsPsRestricted = false;
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state == state2) {
            this.startNetStatPoll();
            return;
        }
        DataConnectionTracker.State state3 = this.state;
        DataConnectionTracker.State state4 = DataConnectionTracker.State.FAILED;
        if (state3 == state4) {
            this.cleanUpConnection(false, "psRestrictEnabled");
            this.mRetryMgr.resetRetryCount();
            this.mReregisterOnReconnectFailure = false;
        }
        boolean bl2 = this.trySetupData("psRestrictEnabled");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApnTypeActive(String string2) {
        if (this.mActiveApn == null) return false;
        if (!this.mActiveApn.canHandleType(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApnTypeAvailable(String string2) {
        if (string2.equals("dun")) {
            if (this.fetchDunApn() == null) return false;
            return true;
        }
        if (this.allApns == null) return false;
        Iterator<ApnSetting> iterator = this.allApns.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!iterator.next().canHandleType(string2));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDataConnectionAsDesired() {
        boolean bl = this.phone.getServiceState().getRoaming();
        if (!this.mGsmPhone.mSIMRecords.getRecordsLoaded()) return true;
        if (this.mGsmPhone.mSST.getCurrentGprsState() != 0) return true;
        if (bl) {
            if (!this.getDataOnRoamingEnabled()) return true;
        }
        if (this.mIsWifiConnected) return true;
        if (this.mIsPsRestricted) return true;
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) return false;
        return true;
    }

    @Override
    protected void log(String string2) {
        String string3 = "[GsmDataConnectionTracker] " + string2;
        int n = Log.d("GSM", string3);
    }

    @Override
    protected void onCleanUpConnection(boolean bl, String string2) {
        this.cleanUpConnection(bl, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDataSetupComplete(AsyncResult asyncResult) {
        int n;
        Object[] objectArray = "gsm.defaultpdpcontext.active";
        String string2 = null;
        if (asyncResult.userObj instanceof String) {
            string2 = (String)asyncResult.userObj;
        }
        if (asyncResult.exception == null) {
            if (this.isApnTypeActive("default")) {
                SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                if (this.canSetPreferApn && this.preferredApn == null) {
                    ApnSetting apnSetting;
                    int n2 = Log.d("GSM", "PREFERRED APN is null");
                    this.preferredApn = apnSetting = this.mActiveApn;
                    int n3 = this.preferredApn.id;
                    this.setPreferredApn(n3);
                }
            } else {
                SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            }
            this.notifyDefaultData(string2);
            return;
        }
        DataConnection.FailCause failCause = (DataConnection.FailCause)((Object)asyncResult.result);
        if (failCause.isEventLoggable()) {
            GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
            int n4 = 50105;
            objectArray = new Object[3];
            Integer n5 = failCause.ordinal();
            objectArray[0] = n5;
            int n6 = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
            Integer n7 = n6;
            objectArray[1] = n7;
            Integer n8 = TelephonyManager.getDefault().getNetworkType();
            objectArray[2] = n8;
            int n9 = EventLog.writeEvent(n4, objectArray);
        }
        int n10 = this.waitingApnsPermanentFailureCountDown;
        int n11 = failCause.isPermanentFail() ? 1 : 0;
        this.waitingApnsPermanentFailureCountDown = n = n10 - n11;
        ApnSetting apnSetting = this.waitingApns.remove(0);
        if (!this.waitingApns.isEmpty()) {
            DataConnectionTracker.State state = DataConnectionTracker.State.SCANNING;
            this.setState(state);
            Message message = this.obtainMessage(5, string2);
            boolean bl = this.sendMessageDelayed(message, 5000L);
            return;
        }
        if (this.waitingApnsPermanentFailureCountDown == 0) {
            this.notifyNoData(failCause);
            this.phone.notifyDataConnection("apnFailed");
            return;
        }
        this.startDelayedRetry(failCause, string2);
    }

    @Override
    protected void onDisconnectDone(AsyncResult asyncResult) {
        String string2 = null;
        if (asyncResult.userObj instanceof String) {
            string2 = (String)asyncResult.userObj;
        }
        DataConnectionTracker.State state = DataConnectionTracker.State.IDLE;
        this.setState(state);
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
        if (!this.retryAfterDisconnected(string2)) {
            return;
        }
        boolean bl = this.trySetupData(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onEnableNewApn() {
        RetryManager retryManager;
        RetryManager retryManager2;
        this.mRetryMgr = this.mRequestedApnType.equals("default") ? (retryManager2 = this.mDefaultRetryManager) : (retryManager = this.mSecondaryRetryManager);
        this.mRetryMgr.resetRetryCount();
        this.cleanUpConnection(true, "apnSwitched");
    }

    protected void onGprsDetached() {
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("gprsDetached");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPdpStateChanged(AsyncResult asyncResult, boolean bl) {
        ArrayList arrayList = (ArrayList)asyncResult.result;
        if (asyncResult.exception != null) {
            return;
        }
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        int n = this.cidActive;
        if (!this.pdpStatesHasCID(arrayList, n)) {
            int n2 = Log.i("GSM", "PDP connection has dropped. Reconnecting");
            GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
            Object[] objectArray = new Object[2];
            int n3 = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
            Integer n4 = n3;
            objectArray[0] = n4;
            Integer n5 = TelephonyManager.getDefault().getNetworkType();
            objectArray[1] = n5;
            int n6 = EventLog.writeEvent(50109, objectArray);
            this.cleanUpConnection(true, null);
            return;
        }
        int n7 = this.cidActive;
        if (this.pdpStatesHasActiveCID(arrayList, n7)) {
            return;
        }
        if (!bl) {
            CommandsInterface commandsInterface = this.phone.mCM;
            Message message = this.obtainMessage(11);
            commandsInterface.getPDPContextList(message);
            return;
        }
        int n8 = Log.i("GSM", "PDP connection has dropped (active=false case).  Reconnecting");
        GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
        Object[] objectArray = new Object[2];
        int n9 = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
        Integer n10 = n9;
        objectArray[0] = n10;
        Integer n11 = TelephonyManager.getDefault().getNetworkType();
        objectArray[1] = n11;
        int n12 = EventLog.writeEvent(50109, objectArray);
        this.cleanUpConnection(true, null);
    }

    protected void onPollPdp() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        CommandsInterface commandsInterface = this.phone.mCM;
        Message message = this.obtainMessage(11);
        commandsInterface.getPDPContextList(message);
        Message message2 = this.obtainMessage(7);
        boolean bl = this.sendMessageDelayed(message2, 5000L);
    }

    @Override
    protected void onRadioAvailable() {
        DataConnectionTracker.State state;
        DataConnectionTracker.State state2;
        if (this.phone.getSimulatedRadioControl() != null) {
            DataConnectionTracker.State state3 = DataConnectionTracker.State.CONNECTED;
            this.setState(state3);
            this.phone.notifyDataConnection(null);
            int n = Log.i("GSM", "We're on the simulator; assuming data is connected");
        }
        if ((state2 = this.state) == (state = DataConnectionTracker.State.IDLE)) {
            return;
        }
        this.cleanUpConnection(true, null);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        if (this.phone.getSimulatedRadioControl() != null) {
            int n = Log.i("GSM", "We're on the simulator; assuming radio off is meaningless");
            return;
        }
        this.cleanUpConnection(false, "radioTurnedOff");
    }

    protected void onRecordsLoaded() {
        this.createAllApnList();
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.FAILED;
        if (state == state2) {
            this.cleanUpConnection(false, null);
        }
        Message message = this.obtainMessage(5, "simLoaded");
        boolean bl = this.sendMessage(message);
    }

    @Override
    protected void onResetDone(AsyncResult asyncResult) {
        String string2 = null;
        if (asyncResult.userObj instanceof String) {
            string2 = (String)asyncResult.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(string2);
    }

    @Override
    protected void onRoamingOff() {
        boolean bl = this.trySetupData("roamingOff");
    }

    @Override
    protected void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            boolean bl = this.trySetupData("roamingOn");
            return;
        }
        this.cleanUpConnection(true, "roamingOn");
    }

    @Override
    protected boolean onTrySetupData(String string2) {
        return this.trySetupData(string2);
    }

    @Override
    protected void onVoiceCallEnded() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state == state2) {
            if (!this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
                return;
            }
            this.resetPollStats();
            return;
        }
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        boolean bl = this.trySetupData("2GVoiceCallEnded");
    }

    @Override
    protected void onVoiceCallStarted() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        if (this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
            return;
        }
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("2GVoiceCallStarted");
    }

    @Override
    protected void restartRadio() {
        int n = Log.d("GSM", "************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.mGsmPhone.mSST.powerOffRadioSafely();
        String string2 = String.valueOf(Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0")) + 1);
        SystemProperties.set("net.ppp.reset-by-timeout", string2);
    }

    @Override
    protected void setState(DataConnectionTracker.State state) {
        DataConnectionTracker.State state2;
        DataConnectionTracker.State state3;
        if (this.state != state) {
            Object[] objectArray = new Object[2];
            String string2 = this.state.toString();
            objectArray[0] = string2;
            String string3 = state.toString();
            objectArray[1] = string3;
            int n = EventLog.writeEvent(50113, objectArray);
            this.state = state;
        }
        if ((state3 = this.state) != (state2 = DataConnectionTracker.State.FAILED)) {
            return;
        }
        if (this.waitingApns == null) {
            return;
        }
        this.waitingApns.clear();
    }

    @Override
    protected void startNetStatPoll() {
        DataConnectionTracker.State state = this.state;
        DataConnectionTracker.State state2 = DataConnectionTracker.State.CONNECTED;
        if (state != state2) {
            return;
        }
        if (this.mPingTestActive) {
            return;
        }
        if (this.netStatPollEnabled) {
            return;
        }
        int n = Log.d("GSM", "[DataConnection] Start poll NetStat");
        this.resetPollStats();
        this.netStatPollEnabled = true;
        this.mPollNetStat.run();
    }

    @Override
    protected void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        Runnable runnable = this.mPollNetStat;
        this.removeCallbacks(runnable);
        int n = Log.d("GSM", "[DataConnection] Stop poll NetStat");
    }

    private class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            Handler handler = GsmDataConnectionTracker.this.mDataConnectionTracker;
            super(handler);
        }

        @Override
        public void onChange(boolean bl) {
            GsmDataConnectionTracker gsmDataConnectionTracker = GsmDataConnectionTracker.this;
            Message message = GsmDataConnectionTracker.this.obtainMessage(29);
            boolean bl2 = gsmDataConnectionTracker.sendMessage(message);
        }
    }
}

