/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.gsm.GSMPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GsmMmiCode
extends Handler
implements MmiCode {
    static final String ACTION_ACTIVATE = "*";
    static final String ACTION_DEACTIVATE = "#";
    static final String ACTION_ERASURE = "##";
    static final String ACTION_INTERROGATE = "*#";
    static final String ACTION_REGISTER = "**";
    static final int EVENT_GET_CLIR_COMPLETE = 2;
    static final int EVENT_QUERY_CF_COMPLETE = 3;
    static final int EVENT_QUERY_COMPLETE = 5;
    static final int EVENT_SET_CFF_COMPLETE = 6;
    static final int EVENT_SET_COMPLETE = 1;
    static final int EVENT_USSD_CANCEL_COMPLETE = 7;
    static final int EVENT_USSD_COMPLETE = 4;
    static final String LOG_TAG = "GSM";
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final String SC_BAIC = "35";
    static final String SC_BAICr = "351";
    static final String SC_BAOC = "33";
    static final String SC_BAOIC = "331";
    static final String SC_BAOICxH = "332";
    static final String SC_BA_ALL = "330";
    static final String SC_BA_MO = "333";
    static final String SC_BA_MT = "353";
    static final String SC_CFB = "67";
    static final String SC_CFNR = "62";
    static final String SC_CFNRy = "61";
    static final String SC_CFU = "21";
    static final String SC_CF_All = "002";
    static final String SC_CF_All_Conditional = "004";
    static final String SC_CLIP = "30";
    static final String SC_CLIR = "31";
    static final String SC_PIN = "04";
    static final String SC_PIN2 = "042";
    static final String SC_PUK = "05";
    static final String SC_PUK2 = "052";
    static final String SC_PWD = "03";
    static final String SC_WAIT = "43";
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    private static String[] sTwoDigitNumberPattern;
    String action;
    Context context;
    String dialingNumber;
    private boolean isPendingUSSD;
    private boolean isUssdRequest;
    CharSequence message;
    GSMPhone phone;
    String poundString;
    String pwd;
    String sc;
    String sia;
    String sib;
    String sic;
    MmiCode.State state;

    GsmMmiCode(GSMPhone gSMPhone) {
        Context context;
        MmiCode.State state;
        Looper looper = gSMPhone.getHandler().getLooper();
        super(looper);
        this.state = state = MmiCode.State.PENDING;
        this.phone = gSMPhone;
        this.context = context = gSMPhone.getContext();
    }

    private CharSequence createQueryCallBarringResultMessage(int n) {
        CharSequence charSequence = this.context.getText(17039541);
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        for (int i = 1; i <= 128; i <<= 1) {
            if ((i & n) == 0) continue;
            StringBuilder stringBuilder2 = stringBuilder.append("\n");
            int n2 = i & n;
            CharSequence charSequence2 = this.serviceClassToCFString(n2);
            StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
        }
        return stringBuilder;
    }

    private CharSequence createQueryCallWaitingResultMessage(int n) {
        CharSequence charSequence = this.context.getText(17039541);
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        for (int i = 1; i <= 128; i <<= 1) {
            if ((i & n) == 0) continue;
            StringBuilder stringBuilder2 = stringBuilder.append("\n");
            int n2 = i & n;
            CharSequence charSequence2 = this.serviceClassToCFString(n2);
            StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
        }
        return stringBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence getErrorMessage(AsyncResult asyncResult) {
        CommandException.Error error;
        if (!(asyncResult.exception instanceof CommandException)) return this.context.getText(17039538);
        CommandException.Error error2 = ((CommandException)asyncResult.exception).getCommandError();
        if (error2 != (error = CommandException.Error.FDN_CHECK_FAILURE)) return this.context.getText(17039538);
        int n = Log.i(LOG_TAG, "FDN_CHECK_FAILURE");
        return this.context.getText(17039539);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence getScString() {
        void var1_2;
        if (this.sc != null) {
            if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                CharSequence charSequence = this.context.getText(17039557);
                return var1_2;
            }
            if (GsmMmiCode.isServiceCodeCallForwarding(this.sc)) {
                CharSequence charSequence = this.context.getText(17039555);
                return var1_2;
            }
            if (this.sc.equals(SC_CLIP)) {
                CharSequence charSequence = this.context.getText(17039553);
                return var1_2;
            }
            if (this.sc.equals(SC_CLIR)) {
                CharSequence charSequence = this.context.getText(17039554);
                return var1_2;
            }
            if (this.sc.equals(SC_PWD)) {
                CharSequence charSequence = this.context.getText(17039558);
                return var1_2;
            }
            if (this.sc.equals(SC_WAIT)) {
                CharSequence charSequence = this.context.getText(17039556);
                return var1_2;
            }
            if (this.isPinCommand()) {
                CharSequence charSequence = this.context.getText(17039559);
                return var1_2;
            }
        }
        String string2 = "";
        return var1_2;
    }

    private void handlePasswordError(int n) {
        MmiCode.State state;
        this.state = state = MmiCode.State.FAILED;
        CharSequence charSequence = this.getScString();
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        StringBuilder stringBuilder2 = stringBuilder.append("\n");
        CharSequence charSequence2 = this.context.getText(n);
        StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEmptyOrNull(CharSequence charSequence) {
        if (charSequence == null) return true;
        if (charSequence.length() != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isServiceCodeCallBarring(String string2) {
        if (string2 == null) return false;
        if (string2.equals(SC_BAOC)) return true;
        if (string2.equals(SC_BAOIC)) return true;
        if (string2.equals(SC_BAOICxH)) return true;
        if (string2.equals(SC_BAIC)) return true;
        if (string2.equals(SC_BAICr)) return true;
        if (string2.equals(SC_BA_ALL)) return true;
        if (string2.equals(SC_BA_MO)) return true;
        if (!string2.equals(SC_BA_MT)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isServiceCodeCallForwarding(String string2) {
        if (string2 == null) return false;
        if (string2.equals(SC_CFU)) return true;
        if (string2.equals(SC_CFB)) return true;
        if (string2.equals(SC_CFNRy)) return true;
        if (string2.equals(SC_CFNR)) return true;
        if (string2.equals(SC_CF_All)) return true;
        if (!string2.equals(SC_CF_All_Conditional)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isShortCode(String string2, GSMPhone gSMPhone) {
        if (string2 == null) return false;
        if (string2.length() > 2) return false;
        if (PhoneNumberUtils.isEmergencyNumber(string2)) return false;
        if (gSMPhone.isInCall()) return true;
        if (string2.length() == 2) {
            if (string2.charAt(0) == '1') return false;
        }
        if (string2.equals("0")) return false;
        if (string2.equals("00")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTwoDigitShortCode(Context context, String string2) {
        int n = Log.d(LOG_TAG, "isTwoDigitShortCode");
        if (string2 == null) return false;
        if (string2.length() != 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17235994);
        }
        for (String string3 : sTwoDigitNumberPattern) {
            String string4 = "Two Digit Number Pattern " + string3;
            int n2 = Log.d(LOG_TAG, string4);
            if (!string2.equals(string3)) continue;
            int n3 = Log.d(LOG_TAG, "Two Digit Number Pattern -true");
            return true;
        }
        int n4 = Log.d(LOG_TAG, "Two Digit Number Pattern -false");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence makeCFQueryResultMessage(CallForwardInfo callForwardInfo, int n) {
        CharSequence charSequence;
        String[] stringArray = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] charSequenceArray = new CharSequence[3];
        boolean bl = callForwardInfo.reason == 2;
        CharSequence charSequence2 = callForwardInfo.status == 1 ? (bl ? this.context.getText(17039605) : this.context.getText(17039604)) : (callForwardInfo.status == 0 && GsmMmiCode.isEmptyOrNull(callForwardInfo.number) ? this.context.getText(17039603) : (bl ? this.context.getText(17039607) : this.context.getText(17039606)));
        int n2 = callForwardInfo.serviceClass & n;
        charSequenceArray[0] = charSequence = this.serviceClassToCFString(n2);
        String string2 = callForwardInfo.number;
        int n3 = callForwardInfo.toa;
        String string3 = PhoneNumberUtils.stringFromStringAndTOA(string2, n3);
        charSequenceArray[1] = string3;
        String string4 = Integer.toString(callForwardInfo.timeSeconds);
        charSequenceArray[2] = string4;
        if (callForwardInfo.reason == 0 && (callForwardInfo.serviceClass & n) == 1) {
            boolean bl2 = callForwardInfo.status == 1;
            this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, bl2);
        }
        return TextUtils.replace(charSequence2, stringArray, charSequenceArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String makeEmptyNull(String string2) {
        if (string2 == null) return string2;
        if (string2.length() != 0) return string2;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GsmMmiCode newFromDialString(String string2, GSMPhone gSMPhone) {
        GsmMmiCode gsmMmiCode = null;
        Matcher matcher = sPatternSuppService.matcher(string2);
        if (matcher.matches()) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            gsmMmiCode = new GsmMmiCode(gSMPhone);
            gsmMmiCode.poundString = string10 = GsmMmiCode.makeEmptyNull(matcher.group(1));
            gsmMmiCode.action = string9 = GsmMmiCode.makeEmptyNull(matcher.group(2));
            gsmMmiCode.sc = string8 = GsmMmiCode.makeEmptyNull(matcher.group(3));
            gsmMmiCode.sia = string7 = GsmMmiCode.makeEmptyNull(matcher.group(5));
            gsmMmiCode.sib = string6 = GsmMmiCode.makeEmptyNull(matcher.group(7));
            gsmMmiCode.sic = string5 = GsmMmiCode.makeEmptyNull(matcher.group(9));
            gsmMmiCode.pwd = string4 = GsmMmiCode.makeEmptyNull(matcher.group(11));
            gsmMmiCode.dialingNumber = string3 = GsmMmiCode.makeEmptyNull(matcher.group(12));
            return gsmMmiCode;
        }
        if (string2.endsWith(ACTION_DEACTIVATE)) {
            gsmMmiCode = new GsmMmiCode(gSMPhone);
            gsmMmiCode.poundString = string2;
            return gsmMmiCode;
        }
        if (GsmMmiCode.isTwoDigitShortCode(gSMPhone.getContext(), string2)) {
            return null;
        }
        if (!GsmMmiCode.isShortCode(string2, gSMPhone)) return gsmMmiCode;
        gsmMmiCode = new GsmMmiCode(gSMPhone);
        gsmMmiCode.dialingNumber = string2;
        return gsmMmiCode;
    }

    static GsmMmiCode newFromUssdUserInput(String string2, GSMPhone gSMPhone) {
        MmiCode.State state;
        GsmMmiCode gsmMmiCode = new GsmMmiCode(gSMPhone);
        gsmMmiCode.message = string2;
        gsmMmiCode.state = state = MmiCode.State.PENDING;
        gsmMmiCode.isPendingUSSD = true;
        return gsmMmiCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GsmMmiCode newNetworkInitiatedUssd(String string2, boolean bl, GSMPhone gSMPhone) {
        MmiCode.State state;
        GsmMmiCode gsmMmiCode = new GsmMmiCode(gSMPhone);
        gsmMmiCode.message = string2;
        gsmMmiCode.isUssdRequest = bl;
        if (bl) {
            MmiCode.State state2;
            gsmMmiCode.isPendingUSSD = true;
            gsmMmiCode.state = state2 = MmiCode.State.PENDING;
            return gsmMmiCode;
        }
        gsmMmiCode.state = state = MmiCode.State.COMPLETE;
        return gsmMmiCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onGetClirComplete(AsyncResult asyncResult) {
        CharSequence charSequence = this.getScString();
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        StringBuilder stringBuilder2 = stringBuilder.append("\n");
        if (asyncResult.exception != null) {
            MmiCode.State state;
            this.state = state = MmiCode.State.FAILED;
            CharSequence charSequence2 = this.getErrorMessage(asyncResult);
            StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
        } else {
            int[] nArray = (int[])asyncResult.result;
            switch (nArray[1]) {
                default: {
                    break;
                }
                case 0: {
                    MmiCode.State state;
                    CharSequence charSequence3 = this.context.getText(17039570);
                    StringBuilder stringBuilder4 = stringBuilder.append(charSequence3);
                    this.state = state = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    MmiCode.State state;
                    CharSequence charSequence4 = this.context.getText(17039571);
                    StringBuilder stringBuilder5 = stringBuilder.append(charSequence4);
                    this.state = state = MmiCode.State.COMPLETE;
                    break;
                }
                case 2: {
                    MmiCode.State state;
                    CharSequence charSequence5 = this.context.getText(17039538);
                    StringBuilder stringBuilder6 = stringBuilder.append(charSequence5);
                    this.state = state = MmiCode.State.FAILED;
                    break;
                }
                case 3: {
                    MmiCode.State state;
                    switch (nArray[0]) {
                        default: {
                            CharSequence charSequence6 = this.context.getText(17039566);
                            StringBuilder stringBuilder7 = stringBuilder.append(charSequence6);
                            break;
                        }
                        case 1: {
                            CharSequence charSequence7 = this.context.getText(17039566);
                            StringBuilder stringBuilder8 = stringBuilder.append(charSequence7);
                            break;
                        }
                        case 2: {
                            CharSequence charSequence8 = this.context.getText(17039567);
                            StringBuilder stringBuilder9 = stringBuilder.append(charSequence8);
                        }
                    }
                    this.state = state = MmiCode.State.COMPLETE;
                    break;
                }
                case 4: {
                    MmiCode.State state;
                    switch (nArray[0]) {
                        default: {
                            CharSequence charSequence9 = this.context.getText(17039569);
                            StringBuilder stringBuilder10 = stringBuilder.append(charSequence9);
                            break;
                        }
                        case 1: {
                            CharSequence charSequence10 = this.context.getText(17039568);
                            StringBuilder stringBuilder11 = stringBuilder.append(charSequence10);
                            break;
                        }
                        case 2: {
                            CharSequence charSequence11 = this.context.getText(17039569);
                            StringBuilder stringBuilder12 = stringBuilder.append(charSequence11);
                        }
                    }
                    this.state = state = MmiCode.State.COMPLETE;
                }
            }
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Unable to fully structure code
     */
    private void onQueryCfComplete(AsyncResult var1_1) {
        var2_2 = this.getScString();
        var3_3 = new StringBuilder(var2_2);
        var4_4 = var3_3.append("\n");
        if (var1_1.exception != null) {
            this.state = var5_5 = MmiCode.State.FAILED;
            var6_6 = this.getErrorMessage(var1_1);
            var7_7 = var3_3.append(var6_6);
lbl8:
            // 2 sources

            while (true) {
                this.message = var3_3;
                this.phone.onMMIDone(this);
                return;
            }
        }
        var8_8 = (CallForwardInfo[])var1_1.result;
        if (var8_8.length == 0) {
            var9_9 = this.context.getText(17039542);
            var10_10 = var3_3.append(var9_9);
            this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, false);
lbl17:
            // 2 sources

            while (true) {
                this.state = var11_11 = MmiCode.State.COMPLETE;
                ** continue;
                break;
            }
        }
        var12_12 = new SpannableStringBuilder();
        for (var13_13 = 1; var13_13 <= 128; var13_13 <<= 1) {
            var15_15 = var8_8.length;
            for (var14_14 = 0; var14_14 < var15_15; ++var14_14) {
                if ((var8_8[var14_14].serviceClass & var13_13) == 0) continue;
                var16_16 = var8_8[var14_14];
                var17_17 = this.makeCFQueryResultMessage(var16_16, var13_13);
                var18_18 = var12_12.append(var17_17);
                var19_19 = var12_12.append("\n");
            }
        }
        var20_20 = var3_3.append(var12_12);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onQueryComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder;
        block6: {
            MmiCode.State state;
            block4: {
                block7: {
                    int[] nArray;
                    block9: {
                        block8: {
                            block5: {
                                MmiCode.State state2;
                                CharSequence charSequence = this.getScString();
                                stringBuilder = new StringBuilder(charSequence);
                                StringBuilder stringBuilder2 = stringBuilder.append("\n");
                                if (asyncResult.exception == null) break block5;
                                this.state = state2 = MmiCode.State.FAILED;
                                CharSequence charSequence2 = this.getErrorMessage(asyncResult);
                                StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
                                break block6;
                            }
                            nArray = (int[])asyncResult.result;
                            if (nArray.length == 0) break block7;
                            if (nArray[0] != 0) break block8;
                            CharSequence charSequence = this.context.getText(17039542);
                            StringBuilder stringBuilder4 = stringBuilder.append(charSequence);
                            break block4;
                        }
                        if (!this.sc.equals(SC_WAIT)) break block9;
                        int n = nArray[1];
                        CharSequence charSequence = this.createQueryCallWaitingResultMessage(n);
                        StringBuilder stringBuilder5 = stringBuilder.append(charSequence);
                        break block4;
                    }
                    if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                        int n = nArray[0];
                        CharSequence charSequence = this.createQueryCallBarringResultMessage(n);
                        StringBuilder stringBuilder6 = stringBuilder.append(charSequence);
                        break block4;
                    } else if (nArray[0] == 1) {
                        CharSequence charSequence = this.context.getText(17039540);
                        StringBuilder stringBuilder7 = stringBuilder.append(charSequence);
                        break block4;
                    } else {
                        CharSequence charSequence = this.context.getText(17039538);
                        StringBuilder stringBuilder8 = stringBuilder.append(charSequence);
                    }
                    break block4;
                }
                CharSequence charSequence = this.context.getText(17039538);
                StringBuilder stringBuilder9 = stringBuilder.append(charSequence);
            }
            this.state = state = MmiCode.State.COMPLETE;
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSetComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder;
        block18: {
            block19: {
                block20: {
                    CommandException.Error error;
                    block21: {
                        CommandException.Error error2;
                        MmiCode.State state;
                        CharSequence charSequence = this.getScString();
                        stringBuilder = new StringBuilder(charSequence);
                        StringBuilder stringBuilder2 = stringBuilder.append("\n");
                        if (asyncResult.exception == null) break block19;
                        this.state = state = MmiCode.State.FAILED;
                        if (!(asyncResult.exception instanceof CommandException)) break block20;
                        error = ((CommandException)asyncResult.exception).getCommandError();
                        if (error != (error2 = CommandException.Error.PASSWORD_INCORRECT)) break block21;
                        if (this.isPinCommand()) {
                            if (this.sc.equals(SC_PUK) || this.sc.equals(SC_PUK2)) {
                                CharSequence charSequence2 = this.context.getText(17039548);
                                StringBuilder stringBuilder3 = stringBuilder.append(charSequence2);
                                break block18;
                            } else {
                                CharSequence charSequence3 = this.context.getText(17039547);
                                StringBuilder stringBuilder4 = stringBuilder.append(charSequence3);
                            }
                            break block18;
                        } else {
                            CharSequence charSequence4 = this.context.getText(17039545);
                            StringBuilder stringBuilder5 = stringBuilder.append(charSequence4);
                        }
                        break block18;
                    }
                    CommandException.Error error3 = CommandException.Error.SIM_PUK2;
                    if (error == error3) {
                        CharSequence charSequence = this.context.getText(17039547);
                        StringBuilder stringBuilder6 = stringBuilder.append(charSequence);
                        StringBuilder stringBuilder7 = stringBuilder.append("\n");
                        CharSequence charSequence5 = this.context.getText(17039552);
                        StringBuilder stringBuilder8 = stringBuilder.append(charSequence5);
                        break block18;
                    } else {
                        CommandException.Error error4 = CommandException.Error.FDN_CHECK_FAILURE;
                        if (error == error4) {
                            int n = Log.i(LOG_TAG, "FDN_CHECK_FAILURE");
                            CharSequence charSequence = this.context.getText(17039539);
                            StringBuilder stringBuilder9 = stringBuilder.append(charSequence);
                            break block18;
                        } else {
                            CharSequence charSequence = this.context.getText(17039538);
                            StringBuilder stringBuilder10 = stringBuilder.append(charSequence);
                        }
                    }
                    break block18;
                }
                CharSequence charSequence = this.context.getText(17039538);
                StringBuilder stringBuilder11 = stringBuilder.append(charSequence);
                break block18;
            }
            if (this.isActivate()) {
                MmiCode.State state;
                this.state = state = MmiCode.State.COMPLETE;
                CharSequence charSequence = this.context.getText(17039540);
                StringBuilder stringBuilder12 = stringBuilder.append(charSequence);
                if (this.sc.equals(SC_CLIR)) {
                    this.phone.saveClirSetting(1);
                }
            } else if (this.isDeactivate()) {
                MmiCode.State state;
                this.state = state = MmiCode.State.COMPLETE;
                CharSequence charSequence = this.context.getText(17039542);
                StringBuilder stringBuilder13 = stringBuilder.append(charSequence);
                if (this.sc.equals(SC_CLIR)) {
                    this.phone.saveClirSetting(2);
                }
            } else if (this.isRegister()) {
                MmiCode.State state;
                this.state = state = MmiCode.State.COMPLETE;
                CharSequence charSequence = this.context.getText(17039543);
                StringBuilder stringBuilder14 = stringBuilder.append(charSequence);
            } else if (this.isErasure()) {
                MmiCode.State state;
                this.state = state = MmiCode.State.COMPLETE;
                CharSequence charSequence = this.context.getText(17039544);
                StringBuilder stringBuilder15 = stringBuilder.append(charSequence);
            } else {
                MmiCode.State state;
                this.state = state = MmiCode.State.FAILED;
                CharSequence charSequence = this.context.getText(17039538);
                StringBuilder stringBuilder16 = stringBuilder.append(charSequence);
            }
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String scToBarringFacility(String string2) {
        if (string2 == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (string2.equals(SC_BAOC)) {
            return "AO";
        }
        if (string2.equals(SC_BAOIC)) {
            return "OI";
        }
        if (string2.equals(SC_BAOICxH)) {
            return "OX";
        }
        if (string2.equals(SC_BAIC)) {
            return "AI";
        }
        if (string2.equals(SC_BAICr)) {
            return "IR";
        }
        if (string2.equals(SC_BA_ALL)) {
            return "AB";
        }
        if (string2.equals(SC_BA_MO)) {
            return "AG";
        }
        if (!string2.equals(SC_BA_MT)) throw new RuntimeException("invalid call barring sc");
        return "AC";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int scToCallForwardReason(String string2) {
        if (string2 == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (string2.equals(SC_CF_All)) {
            return 4;
        }
        if (string2.equals(SC_CFU)) {
            return 0;
        }
        if (string2.equals(SC_CFB)) {
            return 1;
        }
        if (string2.equals(SC_CFNR)) {
            return 3;
        }
        if (string2.equals(SC_CFNRy)) {
            return 2;
        }
        if (!string2.equals(SC_CF_All_Conditional)) throw new RuntimeException("invalid call forward sc");
        return 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence serviceClassToCFString(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                return this.context.getText(17039581);
            }
            case 2: {
                return this.context.getText(17039582);
            }
            case 4: {
                return this.context.getText(17039583);
            }
            case 8: {
                return this.context.getText(17039584);
            }
            case 16: {
                return this.context.getText(17039586);
            }
            case 32: {
                return this.context.getText(17039585);
            }
            case 64: {
                return this.context.getText(17039587);
            }
            case 128: 
        }
        return this.context.getText(17039588);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int siToServiceClass(String string2) {
        if (string2 == null) return 0;
        if (string2.length() == 0) {
            return 0;
        }
        switch (Integer.parseInt(string2, 10)) {
            default: {
                String string3 = "unsupported MMI service code " + string2;
                throw new RuntimeException(string3);
            }
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: 
        }
        return 64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int siToTime(String string2) {
        if (string2 == null) return 0;
        if (string2.length() != 0) return Integer.parseInt(string2, 10);
        return 0;
    }

    @Override
    public void cancel() {
        MmiCode.State state;
        MmiCode.State state2 = this.state;
        MmiCode.State state3 = MmiCode.State.COMPLETE;
        if (state2 == state3) {
            return;
        }
        MmiCode.State state4 = this.state;
        MmiCode.State state5 = MmiCode.State.FAILED;
        if (state4 == state5) {
            return;
        }
        this.state = state = MmiCode.State.CANCELLED;
        if (this.isPendingUSSD) {
            CommandsInterface commandsInterface = this.phone.mCM;
            Message message = this.obtainMessage(7, this);
            commandsInterface.cancelPendingUssd(message);
            return;
        }
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getCLIRMode() {
        if (this.sc == null) return 0;
        if (!this.sc.equals(SC_CLIR)) return 0;
        if (this.isActivate()) {
            return 2;
        }
        if (!this.isDeactivate()) return 0;
        return 1;
    }

    @Override
    public CharSequence getMessage() {
        return this.message;
    }

    @Override
    public MmiCode.State getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onSetComplete(asyncResult);
                return;
            }
            case 6: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null && message.arg1 == 1) {
                    boolean bl = message.arg2 == 1;
                    this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, bl);
                }
                this.onSetComplete(asyncResult);
                return;
            }
            case 2: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onGetClirComplete(asyncResult);
                return;
            }
            case 3: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onQueryCfComplete(asyncResult);
                return;
            }
            case 5: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onQueryComplete(asyncResult);
                return;
            }
            case 4: {
                CharSequence charSequence;
                MmiCode.State state;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    return;
                }
                this.state = state = MmiCode.State.FAILED;
                this.message = charSequence = this.getErrorMessage(asyncResult);
                this.phone.onMMIDone(this);
                return;
            }
            case 7: 
        }
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isActivate() {
        if (this.action == null) return false;
        if (!this.action.equals(ACTION_ACTIVATE)) return false;
        return true;
    }

    @Override
    public boolean isCancelable() {
        return this.isPendingUSSD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isDeactivate() {
        if (this.action == null) return false;
        if (!this.action.equals(ACTION_DEACTIVATE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isErasure() {
        if (this.action == null) return false;
        if (!this.action.equals(ACTION_ERASURE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isInterrogate() {
        if (this.action == null) return false;
        if (!this.action.equals(ACTION_INTERROGATE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isMMI() {
        if (this.poundString == null) return false;
        return true;
    }

    public boolean isPendingUSSD() {
        return this.isPendingUSSD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isPinCommand() {
        if (this.sc == null) return false;
        if (this.sc.equals(SC_PIN)) return true;
        if (this.sc.equals(SC_PIN2)) return true;
        if (this.sc.equals(SC_PUK)) return true;
        if (!this.sc.equals(SC_PUK2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRegister() {
        if (this.action == null) return false;
        if (!this.action.equals(ACTION_REGISTER)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isShortCode() {
        if (this.poundString != null) return false;
        if (this.dialingNumber == null) return false;
        if (this.dialingNumber.length() > 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isTemporaryModeCLIR() {
        if (this.sc == null) return false;
        if (!this.sc.equals(SC_CLIR)) return false;
        if (this.dialingNumber == null) return false;
        if (this.isActivate()) return true;
        if (!this.isDeactivate()) return false;
        return true;
    }

    @Override
    public boolean isUssdRequest() {
        return this.isUssdRequest;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onUssdFinished(String string2, boolean bl) {
        CharSequence charSequence;
        MmiCode.State state = this.state;
        MmiCode.State state2 = MmiCode.State.PENDING;
        if (state != state2) {
            return;
        }
        this.message = string2 == null ? (charSequence = this.context.getText(17039546)) : string2;
        this.isUssdRequest = bl;
        if (!bl) {
            MmiCode.State state3;
            this.state = state3 = MmiCode.State.COMPLETE;
        }
        this.phone.onMMIDone(this);
    }

    void onUssdFinishedError() {
        CharSequence charSequence;
        MmiCode.State state;
        MmiCode.State state2 = this.state;
        MmiCode.State state3 = MmiCode.State.PENDING;
        if (state2 != state3) {
            return;
        }
        this.state = state = MmiCode.State.FAILED;
        this.message = charSequence = this.context.getText(17039538);
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processCode() {
        block38: {
            try {
                if (this.isShortCode()) {
                    int n = Log.d(LOG_TAG, "isShortCode");
                    String string2 = this.dialingNumber;
                    GsmMmiCode gsmMmiCode = this;
                    String string3 = string2;
                    gsmMmiCode.sendUssd(string3);
                    return;
                }
                if (this.dialingNumber != null) {
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.sc == null || !this.sc.equals(SC_CLIP)) break block38;
                int n = Log.d(LOG_TAG, "is CLIP");
                if (!this.isInterrogate()) throw new RuntimeException("Invalid or Unsupported MMI Code");
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n2 = 5;
                GsmMmiCode gsmMmiCode2 = this;
                Message message = gsmMmiCode.obtainMessage(n2, gsmMmiCode2);
                commandsInterface.queryCLIP(message);
                return;
            }
            catch (RuntimeException runtimeException) {
                CharSequence charSequence;
                MmiCode.State state;
                this.state = state = MmiCode.State.FAILED;
                this.message = charSequence = this.context.getText(17039538);
                GSMPhone gSMPhone = this.phone;
                GsmMmiCode gsmMmiCode = this;
                gSMPhone.onMMIDone(gsmMmiCode);
                return;
            }
        }
        if (this.sc != null && this.sc.equals(SC_CLIR)) {
            int n = Log.d(LOG_TAG, "is CLIR");
            if (this.isActivate()) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n3 = 1;
                GsmMmiCode gsmMmiCode3 = this;
                Message message = gsmMmiCode.obtainMessage(n3, gsmMmiCode3);
                commandsInterface.setCLIR(1, message);
                return;
            }
            if (this.isDeactivate()) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n4 = 1;
                GsmMmiCode gsmMmiCode4 = this;
                Message message = gsmMmiCode.obtainMessage(n4, gsmMmiCode4);
                commandsInterface.setCLIR(2, message);
                return;
            }
            if (!this.isInterrogate()) throw new RuntimeException("Invalid or Unsupported MMI Code");
            CommandsInterface commandsInterface = this.phone.mCM;
            GsmMmiCode gsmMmiCode = this;
            int n5 = 2;
            GsmMmiCode gsmMmiCode5 = this;
            Message message = gsmMmiCode.obtainMessage(n5, gsmMmiCode5);
            commandsInterface.getCLIR(message);
            return;
        }
        if (GsmMmiCode.isServiceCodeCallForwarding(this.sc)) {
            int n;
            int n6 = Log.d(LOG_TAG, "is CF");
            String string4 = this.sia;
            int n7 = GsmMmiCode.siToServiceClass(this.sib);
            int n8 = GsmMmiCode.scToCallForwardReason(this.sc);
            int n9 = GsmMmiCode.siToTime(this.sic);
            if (this.isInterrogate()) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n10 = 3;
                GsmMmiCode gsmMmiCode6 = this;
                Message message = gsmMmiCode.obtainMessage(n10, gsmMmiCode6);
                commandsInterface.queryCallForwardStatus(n8, n7, string4, message);
                return;
            }
            if (this.isActivate()) {
                n = 1;
            } else if (this.isDeactivate()) {
                n = 0;
            } else if (this.isRegister()) {
                n = 3;
            } else {
                if (!this.isErasure()) {
                    throw new RuntimeException("invalid action");
                }
                n = 4;
            }
            int n11 = !(n8 != 0 && n8 != 4 || (n7 & 1) == 0 && n7 != 0) ? 1 : 0;
            int n12 = n == 1 || n == 3 ? 1 : 0;
            int n13 = Log.d(LOG_TAG, "is CF setCallForward");
            CommandsInterface commandsInterface = this.phone.mCM;
            GsmMmiCode gsmMmiCode = this;
            int n14 = 6;
            int n15 = n11;
            int n16 = n12;
            GsmMmiCode gsmMmiCode7 = this;
            Message message = gsmMmiCode.obtainMessage(n14, n15, n16, gsmMmiCode7);
            commandsInterface.setCallForward(n, n8, n7, string4, n9, message);
            return;
        }
        if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
            String string5 = this.sia;
            int n = GsmMmiCode.siToServiceClass(this.sib);
            String string6 = GsmMmiCode.scToBarringFacility(this.sc);
            if (this.isInterrogate()) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n17 = 5;
                GsmMmiCode gsmMmiCode8 = this;
                Message message = gsmMmiCode.obtainMessage(n17, gsmMmiCode8);
                commandsInterface.queryFacilityLock(string6, string5, n, message);
                return;
            }
            if (!this.isActivate() && !this.isDeactivate()) {
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            CommandsInterface commandsInterface = this.phone.mCM;
            boolean bl = this.isActivate();
            GsmMmiCode gsmMmiCode = this;
            int n18 = 1;
            GsmMmiCode gsmMmiCode9 = this;
            Message message = gsmMmiCode.obtainMessage(n18, gsmMmiCode9);
            int n19 = n;
            commandsInterface.setFacilityLock(string6, bl, string5, n19, message);
            return;
        }
        if (this.sc != null && this.sc.equals(SC_PWD)) {
            String string7;
            String string8 = this.sib;
            String string9 = this.sic;
            if (!this.isActivate() && !this.isRegister()) {
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            this.action = string7 = ACTION_REGISTER;
            String string10 = this.sia == null ? "AB" : GsmMmiCode.scToBarringFacility(this.sia);
            String string11 = string9;
            String string12 = this.pwd;
            String string13 = string12;
            if (string11.equals(string13)) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n = 1;
                GsmMmiCode gsmMmiCode10 = this;
                Message message = gsmMmiCode.obtainMessage(n, gsmMmiCode10);
                CommandsInterface commandsInterface2 = commandsInterface;
                String string14 = string10;
                String string15 = string8;
                String string16 = string9;
                Message message2 = message;
                commandsInterface2.changeBarringPassword(string14, string15, string16, message2);
                return;
            }
            GsmMmiCode gsmMmiCode = this;
            int n = 17039545;
            gsmMmiCode.handlePasswordError(n);
            return;
        }
        if (this.sc != null && this.sc.equals(SC_WAIT)) {
            int n = GsmMmiCode.siToServiceClass(this.sia);
            if (this.isActivate() || this.isDeactivate()) {
                CommandsInterface commandsInterface = this.phone.mCM;
                boolean bl = this.isActivate();
                GsmMmiCode gsmMmiCode = this;
                int n20 = 1;
                GsmMmiCode gsmMmiCode11 = this;
                Message message = gsmMmiCode.obtainMessage(n20, gsmMmiCode11);
                commandsInterface.setCallWaiting(bl, n, message);
                return;
            }
            if (!this.isInterrogate()) throw new RuntimeException("Invalid or Unsupported MMI Code");
            CommandsInterface commandsInterface = this.phone.mCM;
            GsmMmiCode gsmMmiCode = this;
            int n21 = 5;
            GsmMmiCode gsmMmiCode12 = this;
            Message message = gsmMmiCode.obtainMessage(n21, gsmMmiCode12);
            commandsInterface.queryCallWaiting(n, message);
            return;
        }
        if (this.isPinCommand()) {
            IccCard.State state;
            IccCard.State state2;
            int n;
            int n22;
            String string17 = this.sia;
            String string18 = this.sib;
            int n23 = string18.length();
            if (!this.isRegister()) {
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            String string19 = string18;
            String string20 = this.sic;
            String string21 = string20;
            if (!string19.equals(string21)) {
                GsmMmiCode gsmMmiCode = this;
                int n24 = 17039549;
                gsmMmiCode.handlePasswordError(n24);
                return;
            }
            int n25 = n23;
            int n26 = 4;
            if (n25 < n26 || (n22 = n23) > (n = 8)) {
                GsmMmiCode gsmMmiCode = this;
                int n27 = 17039550;
                gsmMmiCode.handlePasswordError(n27);
                return;
            }
            if (this.sc.equals(SC_PIN) && (state2 = this.phone.mSimCard.getState()) == (state = IccCard.State.PUK_REQUIRED)) {
                GsmMmiCode gsmMmiCode = this;
                int n28 = 17039551;
                gsmMmiCode.handlePasswordError(n28);
                return;
            }
            if (this.sc.equals(SC_PIN)) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n29 = 1;
                GsmMmiCode gsmMmiCode13 = this;
                Message message = gsmMmiCode.obtainMessage(n29, gsmMmiCode13);
                CommandsInterface commandsInterface3 = commandsInterface;
                String string22 = string17;
                String string23 = string18;
                Message message3 = message;
                commandsInterface3.changeIccPin(string22, string23, message3);
                return;
            }
            if (this.sc.equals(SC_PIN2)) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n30 = 1;
                GsmMmiCode gsmMmiCode14 = this;
                Message message = gsmMmiCode.obtainMessage(n30, gsmMmiCode14);
                CommandsInterface commandsInterface4 = commandsInterface;
                String string24 = string17;
                String string25 = string18;
                Message message4 = message;
                commandsInterface4.changeIccPin2(string24, string25, message4);
                return;
            }
            if (this.sc.equals(SC_PUK)) {
                CommandsInterface commandsInterface = this.phone.mCM;
                GsmMmiCode gsmMmiCode = this;
                int n31 = 1;
                GsmMmiCode gsmMmiCode15 = this;
                Message message = gsmMmiCode.obtainMessage(n31, gsmMmiCode15);
                CommandsInterface commandsInterface5 = commandsInterface;
                String string26 = string17;
                String string27 = string18;
                Message message5 = message;
                commandsInterface5.supplyIccPuk(string26, string27, message5);
                return;
            }
            if (!this.sc.equals(SC_PUK2)) {
                return;
            }
            CommandsInterface commandsInterface = this.phone.mCM;
            GsmMmiCode gsmMmiCode = this;
            int n32 = 1;
            GsmMmiCode gsmMmiCode16 = this;
            Message message = gsmMmiCode.obtainMessage(n32, gsmMmiCode16);
            CommandsInterface commandsInterface6 = commandsInterface;
            String string28 = string17;
            String string29 = string18;
            Message message6 = message;
            commandsInterface6.supplyIccPuk2(string28, string29, message6);
            return;
        }
        if (this.poundString == null) throw new RuntimeException("Invalid or Unsupported MMI Code");
        String string30 = this.poundString;
        GsmMmiCode gsmMmiCode = this;
        String string31 = string30;
        gsmMmiCode.sendUssd(string31);
    }

    void sendUssd(String string2) {
        this.isPendingUSSD = true;
        CommandsInterface commandsInterface = this.phone.mCM;
        Message message = this.obtainMessage(4, this);
        commandsInterface.sendUSSD(string2, message);
    }
}

