/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SmsMessage;
import java.util.ArrayList;
import java.util.HashMap;

final class GsmSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "GSM";
    private GSMPhone mGsmPhone;

    GsmSMSDispatcher(GSMPhone gSMPhone) {
        super(gSMPhone);
        this.mGsmPhone = gSMPhone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int resultToCause(int n) {
        switch (n) {
            default: {
                return 255;
            }
            case -1: 
            case 1: {
                return 0;
            }
            case 3: 
        }
        return 211;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendMultipartTextWithPermit(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        int n;
        int n2;
        int n3;
        int n4 = this.mPhone.getServiceState().getState();
        if (n4 == 0) {
            int n5;
            int n6;
            n3 = GsmSMSDispatcher.getNextConcatenatedRef() & 0xFF;
            n2 = arrayList.size();
            n = 0;
            mRemainingMessages = n2;
            int n7 = 0;
            while ((n6 = ++n7) < (n5 = n2)) {
                ArrayList<String> arrayList4 = arrayList;
                int n8 = n7;
                SmsMessageBase.TextEncodingDetails textEncodingDetails = SmsMessage.calculateLength(arrayList4.get(n8), false);
                int n9 = textEncodingDetails.codeUnitSize;
                if (n == n9 || n != 0 && n != 1) continue;
                n = textEncodingDetails.codeUnitSize;
            }
        } else {
            int n10 = 0;
            int n11 = arrayList.size();
            while (true) {
                if (n10 >= n11) {
                    return;
                }
                PendingIntent pendingIntent = null;
                if (arrayList2 != null && arrayList2.size() > n10) {
                    ArrayList<PendingIntent> arrayList5 = arrayList2;
                    int n12 = n10;
                    pendingIntent = arrayList5.get(n12);
                }
                GsmSMSDispatcher gsmSMSDispatcher = this;
                HashMap hashMap = null;
                PendingIntent pendingIntent2 = pendingIntent;
                PendingIntent pendingIntent3 = null;
                SMSDispatcher.SmsTracker smsTracker = gsmSMSDispatcher.SmsTrackerFactory(hashMap, pendingIntent2, pendingIntent3);
                GsmSMSDispatcher gsmSMSDispatcher2 = this;
                int n13 = n4;
                SMSDispatcher.SmsTracker smsTracker2 = smsTracker;
                gsmSMSDispatcher2.handleNotInService(n13, smsTracker2);
                ++n10;
            }
        }
        int n14 = 0;
        int n15;
        int n16;
        while ((n16 = ++n14) < (n15 = n2)) {
            SmsHeader.ConcatRef concatRef;
            int n17;
            int n18;
            int n19;
            SmsHeader.ConcatRef concatRef2 = new SmsHeader.ConcatRef();
            concatRef2.refNumber = n19 = n3;
            concatRef2.seqNumber = n18 = n14 + 1;
            concatRef2.msgCount = n17 = n2;
            concatRef2.isEightBits = false;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef = concatRef2;
            PendingIntent pendingIntent = null;
            if (arrayList2 != null && arrayList2.size() > n14) {
                ArrayList<PendingIntent> arrayList6 = arrayList2;
                int n20 = n14;
                pendingIntent = arrayList6.get(n20);
            }
            PendingIntent pendingIntent4 = null;
            if (arrayList3 != null && arrayList3.size() > n14) {
                ArrayList<PendingIntent> arrayList7 = arrayList3;
                int n21 = n14;
                pendingIntent4 = arrayList7.get(n21);
            }
            ArrayList<String> arrayList8 = arrayList;
            int n22 = n14;
            String string4 = arrayList8.get(n22);
            boolean bl = pendingIntent4 != null;
            byte[] byArray = SmsHeader.toByteArray(smsHeader);
            String string5 = string3;
            String string6 = string2;
            SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string5, string6, string4, bl, byArray, n);
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            byte[] byArray2 = submitPdu.encodedScAddress;
            byte[] byArray3 = hashMap.put("smsc", byArray2);
            byte[] byArray4 = submitPdu.encodedMessage;
            byte[] byArray5 = hashMap.put("pdu", byArray4);
            GsmSMSDispatcher gsmSMSDispatcher = this;
            HashMap<String, byte[]> hashMap2 = hashMap;
            PendingIntent pendingIntent5 = pendingIntent;
            PendingIntent pendingIntent6 = pendingIntent4;
            SMSDispatcher.SmsTracker smsTracker = gsmSMSDispatcher.SmsTrackerFactory(hashMap2, pendingIntent5, pendingIntent6);
            GsmSMSDispatcher gsmSMSDispatcher3 = this;
            SMSDispatcher.SmsTracker smsTracker3 = smsTracker;
            gsmSMSDispatcher3.sendSms(smsTracker3);
        }
        return;
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        if (this.mCm == null) {
            return;
        }
        CommandsInterface commandsInterface = this.mCm;
        int n2 = this.resultToCause(n);
        commandsInterface.acknowledgeLastIncomingGsmSms(bl, n2, message);
    }

    @Override
    protected void activateCellBroadcastSms(int n, Message message) {
        int n2 = Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        message.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int dispatchMessage(SmsMessageBase smsMessageBase) {
        SmsMessage.MessageClass messageClass;
        SmsMessage.MessageClass messageClass2;
        if (smsMessageBase == null) {
            return 2;
        }
        SmsMessage smsMessage = (SmsMessage)smsMessageBase;
        boolean bl = false;
        if (smsMessage.isTypeZero()) {
            int n = Log.d(TAG, "Received short message type 0, Don't display or store it. Send Ack");
            return 1;
        }
        if (smsMessage.isMWISetMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(true);
            bl = smsMessage.isMwiDontStore();
            StringBuilder stringBuilder = new StringBuilder().append("Received voice mail indicator set SMS shouldStore=");
            boolean bl2 = !bl;
            String string2 = stringBuilder.append(bl2).toString();
            int n = Log.d(TAG, string2);
        } else if (smsMessage.isMWIClearMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(false);
            bl = smsMessage.isMwiDontStore();
            StringBuilder stringBuilder = new StringBuilder().append("Received voice mail indicator clear SMS shouldStore=");
            boolean bl3 = !bl;
            String string3 = stringBuilder.append(bl3).toString();
            int n = Log.d(TAG, string3);
        }
        if (bl) {
            return 1;
        }
        if (!this.mStorageAvailable && (messageClass2 = smsMessage.getMessageClass()) != (messageClass = SmsMessage.MessageClass.CLASS_0)) {
            return 3;
        }
        SmsHeader smsHeader = smsMessage.getUserDataHeader();
        if (smsHeader != null && smsHeader.concatRef != null) {
            SmsHeader.ConcatRef concatRef = smsHeader.concatRef;
            SmsHeader.PortAddrs portAddrs = smsHeader.portAddrs;
            return this.processMessagePart(smsMessage, concatRef, portAddrs);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = smsMessage.getPdu();
        byArray[0] = (byte)byArray2;
        if (smsHeader != null && smsHeader.portAddrs != null) {
            if (smsHeader.portAddrs.destPort == 2948) {
                WapPushOverSms wapPushOverSms = this.mWapPush;
                byte[] byArray3 = smsMessage.getUserData();
                return wapPushOverSms.dispatchWapPdu(byArray3);
            }
            int n = smsHeader.portAddrs.destPort;
            this.dispatchPortAddressedPdus((byte[][])byArray, n);
            return -1;
        } else {
            this.dispatchPdus((byte[][])byArray);
        }
        return -1;
    }

    @Override
    protected void getCellBroadcastSmsConfig(Message message) {
        int n = Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        message.recycle();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleStatusReport(AsyncResult asyncResult) {
        String string2 = (String)asyncResult.result;
        SmsMessage smsMessage = SmsMessage.newFromCDS(string2);
        int n = smsMessage.getStatus();
        if (smsMessage != null) {
            int n2 = smsMessage.messageRef;
            int n3 = this.deliveryPendingList.size();
            for (int i = 0; i < n3; ++i) {
                SMSDispatcher.SmsTracker smsTracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (smsTracker.mMessageRef == n2) continue;
                if (n >= 64 || n < 32) {
                    Object e = this.deliveryPendingList.remove(i);
                }
                PendingIntent pendingIntent = smsTracker.mDeliveryIntent;
                Intent intent = new Intent();
                byte[] byArray = IccUtils.hexStringToBytes(string2);
                Intent intent2 = intent.putExtra("pdu", byArray);
                try {
                    Context context = this.mContext;
                    pendingIntent.send(context, -1, intent);
                }
                catch (PendingIntent.CanceledException canceledException) {}
                break;
            }
        }
        this.acknowledgeLastIncomingSms(true, 1, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, n, byArray, bl);
        byte[] byArray2 = submitPdu.encodedScAddress;
        byte[] byArray3 = submitPdu.encodedMessage;
        this.sendRawPdu(byArray2, byArray3, pendingIntent, pendingIntent2);
    }

    @Override
    protected void sendMultipartSms(SMSDispatcher.SmsTracker smsTracker) {
        HashMap hashMap = smsTracker.mData;
        String string2 = (String)hashMap.get("destination");
        String string3 = (String)hashMap.get("scaddress");
        ArrayList arrayList = (ArrayList)hashMap.get("parts");
        ArrayList arrayList2 = (ArrayList)hashMap.get("sentIntents");
        ArrayList arrayList3 = (ArrayList)hashMap.get("deliveryIntents");
        this.sendMultipartTextWithPermit(string2, string3, arrayList, arrayList2, arrayList3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        int n = GsmSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int n2 = arrayList.size();
        int n3 = 0;
        mRemainingMessages = n2;
        for (int i = 0; i < n2; ++i) {
            ArrayList<String> arrayList4 = arrayList;
            int n4 = i;
            SmsMessageBase.TextEncodingDetails textEncodingDetails = SmsMessage.calculateLength(arrayList4.get(n4), false);
            int n5 = textEncodingDetails.codeUnitSize;
            if (n3 == n5 || n3 != 0 && n3 != 1) continue;
            n3 = textEncodingDetails.codeUnitSize;
        }
        int n6 = 0;
        while (n6 < n2) {
            SmsHeader.ConcatRef concatRef;
            int n7;
            int n8;
            SmsHeader.ConcatRef concatRef2 = new SmsHeader.ConcatRef();
            concatRef2.refNumber = n8 = n;
            concatRef2.seqNumber = n7 = n6 + 1;
            concatRef2.msgCount = n2;
            concatRef2.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef = concatRef2;
            PendingIntent pendingIntent = null;
            if (arrayList2 != null && arrayList2.size() > n6) {
                ArrayList<PendingIntent> arrayList5 = arrayList2;
                int n9 = n6;
                pendingIntent = arrayList5.get(n9);
            }
            PendingIntent pendingIntent2 = null;
            if (arrayList3 != null && arrayList3.size() > n6) {
                ArrayList<PendingIntent> arrayList6 = arrayList3;
                int n10 = n6;
                pendingIntent2 = arrayList6.get(n10);
            }
            ArrayList<String> arrayList7 = arrayList;
            int n11 = n6;
            String string4 = arrayList7.get(n11);
            boolean bl = pendingIntent2 != null;
            byte[] byArray = SmsHeader.toByteArray(smsHeader);
            String string5 = string3;
            String string6 = string2;
            SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string5, string6, string4, bl, byArray, n3);
            byte[] byArray2 = submitPdu.encodedScAddress;
            byte[] byArray3 = submitPdu.encodedMessage;
            GsmSMSDispatcher gsmSMSDispatcher = this;
            byte[] byArray4 = byArray2;
            byte[] byArray5 = byArray3;
            PendingIntent pendingIntent3 = pendingIntent;
            PendingIntent pendingIntent4 = pendingIntent2;
            gsmSMSDispatcher.sendRawPdu(byArray4, byArray5, pendingIntent3, pendingIntent4);
            ++n6;
        }
        return;
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        HashMap hashMap = smsTracker.mData;
        byte[] byArray = (byte[])hashMap.get("smsc");
        byte[] byArray2 = (byte[])hashMap.get("pdu");
        Message message = this.obtainMessage(2, smsTracker);
        CommandsInterface commandsInterface = this.mCm;
        String string2 = IccUtils.bytesToHexString(byArray);
        String string3 = IccUtils.bytesToHexString(byArray2);
        commandsInterface.sendSMS(string2, string3, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, string4, bl);
        byte[] byArray = submitPdu.encodedScAddress;
        byte[] byArray2 = submitPdu.encodedMessage;
        this.sendRawPdu(byArray, byArray2, pendingIntent, pendingIntent2);
    }

    @Override
    protected void setCellBroadcastConfig(int[] nArray, Message message) {
        int n = Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        message.recycle();
    }
}

