/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.RestrictedState;
import com.android.internal.telephony.gsm.SIMRecords;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class GsmServiceStateTracker
extends ServiceStateTracker {
    static final int CS_DISABLED = 1004;
    static final int CS_EMERGENCY_ENABLED = 1006;
    static final int CS_ENABLED = 1003;
    static final int CS_NORMAL_ENABLED = 1005;
    static final int CS_NOTIFICATION = 999;
    static final boolean DBG = true;
    static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    static final String LOG_TAG = "GSM";
    static final int MAX_NUM_DATA_STATE_READS = 15;
    static final int PS_DISABLED = 1002;
    static final int PS_ENABLED = 1001;
    static final int PS_NOTIFICATION = 888;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    GsmCellLocation cellLoc;
    private ContentResolver cr;
    private String curPlmn;
    private String curSpn;
    private int curSpnRule;
    private RegistrantList gprsAttachedRegistrants;
    private RegistrantList gprsDetachedRegistrants;
    private int gprsState = 1;
    private ContentObserver mAutoTimeObserver;
    private boolean mDataRoaming = false;
    private boolean mEmergencyOnly = false;
    private boolean mGotCountryCode;
    private boolean mGsmRoaming = false;
    private BroadcastReceiver mIntentReceiver;
    private boolean mNeedFixZone;
    private boolean mNeedToRegForSimLoaded;
    private Notification mNotification;
    int mPreferredNetworkType;
    private boolean mReportedGprsNoReg;
    long mSavedAtTime;
    long mSavedTime;
    String mSavedTimeZone;
    private boolean mStartedGprsRegCheck;
    private PowerManager.WakeLock mWakeLock;
    private boolean mZoneDst;
    private int mZoneOffset;
    private long mZoneTime;
    private int networkType = 0;
    GsmCellLocation newCellLoc;
    private int newGPRSState = 1;
    private int newNetworkType = 0;
    GSMPhone phone;
    private RegistrantList psRestrictDisabledRegistrants;
    private RegistrantList psRestrictEnabledRegistrants;
    RestrictedState rs;

    /*
     * Enabled aggressive block sorting
     */
    public GsmServiceStateTracker(GSMPhone gSMPhone) {
        ContentResolver contentResolver;
        PowerManager.WakeLock wakeLock;
        SignalStrength signalStrength;
        RestrictedState restrictedState;
        GsmCellLocation gsmCellLocation;
        GsmCellLocation gsmCellLocation2;
        ServiceState serviceState;
        ServiceState serviceState2;
        CommandsInterface commandsInterface;
        ContentObserver contentObserver;
        BroadcastReceiver broadcastReceiver;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        RegistrantList registrantList4;
        this.gprsAttachedRegistrants = registrantList4 = new RegistrantList();
        this.gprsDetachedRegistrants = registrantList3 = new RegistrantList();
        this.psRestrictEnabledRegistrants = registrantList2 = new RegistrantList();
        this.psRestrictDisabledRegistrants = registrantList = new RegistrantList();
        this.mNeedFixZone = false;
        this.mGotCountryCode = false;
        this.mStartedGprsRegCheck = false;
        this.mReportedGprsNoReg = false;
        this.curSpn = null;
        this.curPlmn = null;
        this.curSpnRule = 0;
        this.mIntentReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (!intent.getAction().equals("android.intent.action.LOCALE_CHANGED")) {
                    return;
                }
                GsmServiceStateTracker.this.updateSpnDisplay();
            }
        };
        Handler handler = new Handler();
        this.mAutoTimeObserver = contentObserver = new ContentObserver(handler){

            @Override
            public void onChange(boolean bl) {
                int n = Log.i("GsmServiceStateTracker", "Auto time state changed");
                GsmServiceStateTracker.this.revertToNitz();
            }
        };
        this.phone = gSMPhone;
        this.cm = commandsInterface = gSMPhone.mCM;
        this.ss = serviceState2 = new ServiceState();
        this.newSS = serviceState = new ServiceState();
        this.cellLoc = gsmCellLocation2 = new GsmCellLocation();
        this.newCellLoc = gsmCellLocation = new GsmCellLocation();
        this.rs = restrictedState = new RestrictedState();
        this.mSignalStrength = signalStrength = new SignalStrength();
        this.mWakeLock = wakeLock = ((PowerManager)gSMPhone.getContext().getSystemService("power")).newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForNetworkStateChanged(this, 2, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.setOnRestrictedStateChanged(this, 23, null);
        this.cm.registerForSIMReady(this, 17, null);
        boolean bl = Settings.System.getInt(gSMPhone.getContext().getContentResolver(), "airplane_mode_on", 0) <= 0;
        this.mDesiredPowerState = bl;
        ContentResolver contentResolver2 = this.cr = (contentResolver = gSMPhone.getContext().getContentResolver());
        Uri uri = Settings.System.getUriFor("auto_time");
        ContentObserver contentObserver2 = this.mAutoTimeObserver;
        contentResolver2.registerContentObserver(uri, true, contentObserver2);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForSimLoaded = true;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.LOCALE_CHANGED");
        Context context = gSMPhone.getContext();
        BroadcastReceiver broadcastReceiver2 = this.mIntentReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver2, intentFilter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String displayNameFor(int n) {
        char c;
        char c2;
        char c3;
        char c4;
        int n2 = n / 1000 / 60;
        char[] cArray = new char[9];
        cArray[0] = 71;
        cArray[1] = 77;
        cArray[2] = 84;
        if (n2 < 0) {
            cArray[3] = 45;
            n2 = -n2;
        } else {
            cArray[3] = 43;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        cArray[4] = c4 = (char)(n3 / 10 + 48);
        cArray[5] = c3 = (char)(n3 % 10 + 48);
        cArray[6] = 58;
        cArray[7] = c2 = (char)(n4 / 10 + 48);
        cArray[8] = c = (char)(n4 % 10 + 48);
        return new String(cArray);
    }

    private TimeZone findTimeZone(int n, boolean bl, long l) {
        int n2 = n;
        if (bl) {
            n2 -= 3600000;
        }
        String[] stringArray = TimeZone.getAvailableIDs(n2);
        TimeZone timeZone = null;
        Date date = new Date(l);
        String[] stringArray2 = stringArray;
        int n3 = stringArray2.length;
        int n4 = 0;
        while (true) {
            block6: {
                block5: {
                    if (n4 >= n3) break block5;
                    TimeZone timeZone2 = TimeZone.getTimeZone(stringArray2[n4]);
                    if (timeZone2.getOffset(l) == n || timeZone2.inDaylightTime(date) == bl) break block6;
                    timeZone = timeZone2;
                }
                return timeZone;
            }
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getAutoTime() {
        try {
            int n = Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time");
            if (n <= 0) return false;
            return true;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TimeZone getNitzTimeZone(int n, boolean bl, long l) {
        TimeZone timeZone = this.findTimeZone(n, bl, l);
        if (timeZone == null) {
            boolean bl2 = !bl;
            timeZone = this.findTimeZone(n, bl2, l);
        }
        String string2 = LOG_TAG;
        StringBuilder stringBuilder = new StringBuilder().append("getNitzTimeZone returning ");
        Object object = timeZone == null ? timeZone : timeZone.getID();
        String string3 = stringBuilder.append(object).toString();
        int n2 = Log.d(string2, string3);
        return timeZone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isGprsConsistent(int n, int n2) {
        if (n2 != 0) return true;
        if (n != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRoamingBetweenOperators(boolean bl, ServiceState serviceState) {
        String string2 = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String string3 = serviceState.getOperatorAlphaLong();
        String string4 = serviceState.getOperatorAlphaShort();
        boolean bl2 = string3 != null && string2.equals(string3);
        boolean bl3 = string4 != null && string2.equals(string4);
        String string5 = SystemProperties.get("gsm.sim.operator.numeric", "");
        String string6 = serviceState.getOperatorNumeric();
        boolean bl4 = true;
        int n = 0;
        int n2 = 3;
        try {
            boolean bl5;
            String string7 = string5.substring(n, n2);
            String string8 = string6.substring(0, 3);
            bl4 = bl5 = string7.equals(string8);
        }
        catch (Exception exception) {}
        if (!bl) return false;
        if (!bl4) return true;
        if (bl2) return false;
        if (bl3) return false;
        return true;
    }

    private void log(String string2) {
        String string3 = "[GsmServiceStateTracker] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String networkTypeToString(int n) {
        String string2 = "unknown";
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Wrong network type: ");
                String string3 = Integer.toString(n);
                String string4 = stringBuilder.append(string3).toString();
                int n2 = Log.e(LOG_TAG, string4);
                return string2;
            }
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 9: {
                return "HSDPA";
            }
            case 10: {
                return "HSUPA";
            }
            case 11: 
        }
        return "HSPA";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRestrictedStateChanged(AsyncResult asyncResult) {
        block18: {
            RestrictedState restrictedState;
            block21: {
                block24: {
                    block25: {
                        block22: {
                            block23: {
                                block19: {
                                    block20: {
                                        int n = Log.d(LOG_TAG, "[DSAC DEB] onRestrictedStateChanged");
                                        restrictedState = new RestrictedState();
                                        StringBuilder stringBuilder = new StringBuilder().append("[DSAC DEB] current rs at enter ");
                                        RestrictedState restrictedState2 = this.rs;
                                        String string2 = stringBuilder.append(restrictedState2).toString();
                                        int n2 = Log.d(LOG_TAG, string2);
                                        if (asyncResult.exception != null) break block18;
                                        int n3 = ((int[])asyncResult.result)[0];
                                        boolean bl = (n3 & 1) != 0 || (n3 & 4) != 0;
                                        restrictedState.setCsEmergencyRestricted(bl);
                                        IccCard.State state = this.phone.getIccCard().getState();
                                        IccCard.State state2 = IccCard.State.READY;
                                        if (state == state2) {
                                            boolean bl2 = (n3 & 2) != 0 || (n3 & 4) != 0;
                                            restrictedState.setCsNormalRestricted(bl2);
                                            boolean bl3 = (n3 & 0x10) != 0;
                                            restrictedState.setPsRestricted(bl3);
                                        }
                                        String string3 = "[DSAC DEB] new rs " + restrictedState;
                                        int n4 = Log.d(LOG_TAG, string3);
                                        if (!this.rs.isPsRestricted() && restrictedState.isPsRestricted()) {
                                            this.psRestrictEnabledRegistrants.notifyRegistrants();
                                            this.setNotification(1001);
                                        } else if (this.rs.isPsRestricted() && !restrictedState.isPsRestricted()) {
                                            this.psRestrictDisabledRegistrants.notifyRegistrants();
                                            this.setNotification(1002);
                                        }
                                        if (!this.rs.isCsRestricted()) break block19;
                                        if (restrictedState.isCsRestricted()) break block20;
                                        this.setNotification(1004);
                                        break block21;
                                    }
                                    if (!restrictedState.isCsNormalRestricted()) {
                                        this.setNotification(1006);
                                        break block21;
                                    } else if (!restrictedState.isCsEmergencyRestricted()) {
                                        this.setNotification(1005);
                                    }
                                    break block21;
                                }
                                if (!this.rs.isCsEmergencyRestricted() || this.rs.isCsNormalRestricted()) break block22;
                                if (restrictedState.isCsRestricted()) break block23;
                                this.setNotification(1004);
                                break block21;
                            }
                            if (restrictedState.isCsRestricted()) {
                                this.setNotification(1003);
                                break block21;
                            } else if (restrictedState.isCsNormalRestricted()) {
                                this.setNotification(1005);
                            }
                            break block21;
                        }
                        if (this.rs.isCsEmergencyRestricted() || !this.rs.isCsNormalRestricted()) break block24;
                        if (restrictedState.isCsRestricted()) break block25;
                        this.setNotification(1004);
                        break block21;
                    }
                    if (restrictedState.isCsRestricted()) {
                        this.setNotification(1003);
                        break block21;
                    } else if (restrictedState.isCsEmergencyRestricted()) {
                        this.setNotification(1006);
                    }
                    break block21;
                }
                if (restrictedState.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (restrictedState.isCsEmergencyRestricted()) {
                    this.setNotification(1006);
                } else if (restrictedState.isCsNormalRestricted()) {
                    this.setNotification(1005);
                }
            }
            this.rs = restrictedState;
        }
        StringBuilder stringBuilder = new StringBuilder().append("[DSAC DEB] current rs at return ");
        RestrictedState restrictedState = this.rs;
        String string4 = stringBuilder.append(restrictedState).toString();
        int n = Log.d(LOG_TAG, string4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSignalStrengthResult(AsyncResult asyncResult) {
        SignalStrength signalStrength;
        SignalStrength signalStrength2 = this.mSignalStrength;
        int n = 99;
        if (asyncResult.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int[] nArray = (int[])asyncResult.result;
            if (nArray.length != 0) {
                n = nArray[0];
            } else {
                int n2 = Log.e(LOG_TAG, "Bogus signal strength response");
                n = 99;
            }
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        this.mSignalStrength = signalStrength = new SignalStrength(n, -1, n3, n4, n5, n6, n7, true);
        if (this.mSignalStrength.equals(signalStrength2)) {
            return;
        }
        try {
            this.phone.notifySignalStrength();
            return;
        }
        catch (NullPointerException nullPointerException) {
            String string2 = "onSignalStrengthResult() Phone already destroyed: " + nullPointerException + "SignalStrength not notified";
            this.log(string2);
            return;
        }
    }

    private void pollState() {
        int[] nArray = new int[1];
        this.pollingContext = nArray;
        this.pollingContext[0] = 0;
        int[] nArray2 = 3.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState;
        int n = this.cm.getRadioState().ordinal();
        switch (nArray2[n]) {
            default: {
                int n2;
                int n3;
                int n4;
                int n5;
                int[] nArray3 = this.pollingContext;
                nArray3[0] = n5 = nArray3[0] + 1;
                CommandsInterface commandsInterface = this.cm;
                int[] nArray4 = this.pollingContext;
                Message message = this.obtainMessage(6, nArray4);
                commandsInterface.getOperator(message);
                int[] nArray5 = this.pollingContext;
                nArray5[0] = n4 = nArray5[0] + 1;
                CommandsInterface commandsInterface2 = this.cm;
                int[] nArray6 = this.pollingContext;
                Message message2 = this.obtainMessage(5, nArray6);
                commandsInterface2.getGPRSRegistrationState(message2);
                int[] nArray7 = this.pollingContext;
                nArray7[0] = n3 = nArray7[0] + 1;
                CommandsInterface commandsInterface3 = this.cm;
                int[] nArray8 = this.pollingContext;
                Message message3 = this.obtainMessage(4, nArray8);
                commandsInterface3.getRegistrationState(message3);
                int[] nArray9 = this.pollingContext;
                nArray9[0] = n2 = nArray9[0] + 1;
                CommandsInterface commandsInterface4 = this.cm;
                int[] nArray10 = this.pollingContext;
                Message message4 = this.obtainMessage(14, nArray10);
                commandsInterface4.getNetworkSelectionMode(message4);
                return;
            }
            case 1: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 2: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        int n6 = Log.d(LOG_TAG, "Radio Technology Change ongoing, setting SS to off");
        this.newSS.setStateOff();
        this.newCellLoc.setStateInvalid();
        this.setSignalStrengthDefaultValues();
        this.mGotCountryCode = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pollStateDone() {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        GsmServiceStateTracker gsmServiceStateTracker;
        int n5;
        int n6;
        GsmCellLocation gsmCellLocation;
        GsmCellLocation gsmCellLocation2;
        ServiceState serviceState;
        ServiceState serviceState2;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        StringBuilder stringBuilder = new StringBuilder().append("Poll ServiceState done:  oldSS=[");
        ServiceState serviceState3 = this.ss;
        StringBuilder stringBuilder2 = stringBuilder.append(serviceState3).append("] newSS=[");
        ServiceState serviceState4 = this.newSS;
        StringBuilder stringBuilder3 = stringBuilder2.append(serviceState4).append("] oldGprs=");
        int n13 = this.gprsState;
        StringBuilder stringBuilder4 = stringBuilder3.append(n13).append(" newGprs=");
        int n14 = this.newGPRSState;
        StringBuilder stringBuilder5 = stringBuilder4.append(n14).append(" oldType=");
        String string2 = GsmServiceStateTracker.networkTypeToString(this.networkType);
        StringBuilder stringBuilder6 = stringBuilder5.append(string2).append(" newType=");
        String string3 = GsmServiceStateTracker.networkTypeToString(this.newNetworkType);
        String string4 = stringBuilder6.append(string3).toString();
        int n15 = Log.d(LOG_TAG, string4);
        boolean bl2 = this.ss.getState() != 0 && this.newSS.getState() == 0;
        if (this.ss.getState() == 0 && this.newSS.getState() != 0) {
            boolean bl3 = true;
        } else {
            boolean bl4 = false;
        }
        boolean bl5 = this.gprsState != 0 && this.newGPRSState == 0;
        boolean bl6 = this.gprsState == 0 && this.newGPRSState != 0;
        int n16 = this.networkType;
        int n17 = n16;
        int n18 = this.newNetworkType;
        int n19 = n18;
        boolean bl7 = n17 != n19;
        ServiceState serviceState5 = this.newSS;
        ServiceState serviceState6 = this.ss;
        boolean bl8 = !serviceState5.equals(serviceState6);
        boolean bl9 = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean bl10 = this.ss.getRoaming() && !this.newSS.getRoaming();
        GsmCellLocation gsmCellLocation3 = this.newCellLoc;
        GsmCellLocation gsmCellLocation4 = this.cellLoc;
        boolean bl11 = !gsmCellLocation3.equals(gsmCellLocation4);
        int n20 = this.ss.getState();
        int n21 = n20;
        if (n21 == (n12 = (n11 = this.newSS.getState())) || (n10 = (n9 = this.gprsState)) != (n8 = (n7 = this.newGPRSState))) {
            Object[] objectArray = new Object[4];
            Integer n22 = this.ss.getState();
            objectArray[0] = n22;
            Integer n23 = this.gprsState;
            objectArray[1] = n23;
            Integer n24 = this.newSS.getState();
            objectArray[2] = n24;
            Integer n25 = this.newGPRSState;
            objectArray[3] = n25;
            int n26 = EventLog.writeEvent(50114, objectArray);
        }
        ServiceState serviceState7 = this.ss;
        this.ss = serviceState2 = this.newSS;
        this.newSS = serviceState = serviceState7;
        this.newSS.setStateOutOfService();
        GsmCellLocation gsmCellLocation5 = this.cellLoc;
        this.cellLoc = gsmCellLocation2 = this.newCellLoc;
        this.newCellLoc = gsmCellLocation = gsmCellLocation5;
        if (bl7) {
            int n27 = -1;
            GsmCellLocation gsmCellLocation6 = (GsmCellLocation)this.phone.getCellLocation();
            if (gsmCellLocation6 != null) {
                n27 = gsmCellLocation6.getCid();
            }
            Object[] objectArray = new Object[3];
            Integer n28 = n27;
            objectArray[0] = n28;
            Integer n29 = this.networkType;
            objectArray[1] = n29;
            Integer n30 = this.newNetworkType;
            objectArray[2] = n30;
            int n31 = EventLog.writeEvent(50112, objectArray);
            StringBuilder stringBuilder7 = new StringBuilder().append("RAT switched ");
            String string5 = GsmServiceStateTracker.networkTypeToString(this.networkType);
            StringBuilder stringBuilder8 = stringBuilder7.append(string5).append(" -> ");
            String string6 = GsmServiceStateTracker.networkTypeToString(this.newNetworkType);
            StringBuilder stringBuilder9 = stringBuilder8.append(string6).append(" at cell ");
            int n32 = n27;
            String string7 = stringBuilder9.append(n32).toString();
            int n33 = Log.d(LOG_TAG, string7);
        }
        this.gprsState = n6 = this.newGPRSState;
        this.networkType = n5 = this.newNetworkType;
        this.newSS.setStateOutOfService();
        if (bl7) {
            GSMPhone gSMPhone = this.phone;
            String string8 = GsmServiceStateTracker.networkTypeToString(this.networkType);
            gSMPhone.setSystemProperty("gsm.network.type", string8);
        }
        if (bl2) {
            this.networkAttachedRegistrants.notifyRegistrants();
        }
        if (bl8) {
            this.updateSpnDisplay();
            GSMPhone gSMPhone = this.phone;
            String string9 = this.ss.getOperatorAlphaLong();
            gSMPhone.setSystemProperty("gsm.operator.alpha", string9);
            String string10 = this.ss.getOperatorNumeric();
            GSMPhone gSMPhone2 = this.phone;
            String string11 = "gsm.operator.numeric";
            String string12 = string10;
            gSMPhone2.setSystemProperty(string11, string12);
            if (string10 == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
            } else {
                boolean bl12;
                String string13 = "";
                int n34 = 0;
                int n35 = 3;
                try {
                    String string14;
                    String string15 = string10;
                    int n36 = n34;
                    int n37 = n35;
                    string13 = string14 = MccTable.countryCodeForMcc(Integer.parseInt(string15.substring(n36, n37)));
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder10 = new StringBuilder().append("countryCodeForMcc error");
                    NumberFormatException numberFormatException2 = numberFormatException;
                    String string16 = stringBuilder10.append(numberFormatException2).toString();
                    int n38 = Log.w(LOG_TAG, string16);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    StringBuilder stringBuilder11 = new StringBuilder().append("countryCodeForMcc error");
                    StringIndexOutOfBoundsException stringIndexOutOfBoundsException2 = stringIndexOutOfBoundsException;
                    String string17 = stringBuilder11.append(stringIndexOutOfBoundsException2).toString();
                    int n39 = Log.w(LOG_TAG, string17);
                }
                GSMPhone gSMPhone3 = this.phone;
                String string18 = "gsm.operator.iso-country";
                String string19 = string13;
                gSMPhone3.setSystemProperty(string18, string19);
                this.mGotCountryCode = bl12 = true;
                if (this.mNeedFixZone) {
                    boolean bl13;
                    TimeZone timeZone;
                    String string20;
                    Object[] objectArray;
                    String string21 = SystemProperties.get("persist.sys.timezone");
                    if (this.mZoneOffset == 0 && !this.mZoneDst && string21 != null && string21.length() > 0 && Arrays.binarySearch(objectArray = GMT_COUNTRY_CODES, string20 = string13) < 0) {
                        timeZone = TimeZone.getDefault();
                        long l = System.currentTimeMillis();
                        TimeZone timeZone2 = timeZone;
                        long l2 = l;
                        long l3 = timeZone2.getOffset(l2);
                        if (this.getAutoTime()) {
                            long l4 = System.currentTimeMillis() - l3;
                            GsmServiceStateTracker gsmServiceStateTracker2 = this;
                            long l5 = l4;
                            gsmServiceStateTracker2.setAndBroadcastNetworkSetTime(l5);
                        } else {
                            long l6;
                            this.mSavedTime = l6 = this.mSavedTime - l3;
                        }
                    } else {
                        String string22 = string13;
                        String string23 = "";
                        if (string22.equals(string23)) {
                            int n40 = this.mZoneOffset;
                            boolean bl14 = this.mZoneDst;
                            long l = this.mZoneTime;
                            GsmServiceStateTracker gsmServiceStateTracker3 = this;
                            int n41 = n40;
                            boolean bl15 = bl14;
                            long l7 = l;
                            timeZone = gsmServiceStateTracker3.getNitzTimeZone(n41, bl15, l7);
                        } else {
                            int n42 = this.mZoneOffset;
                            boolean bl16 = this.mZoneDst;
                            long l = this.mZoneTime;
                            int n43 = n42;
                            boolean bl17 = bl16;
                            long l8 = l;
                            String string24 = string13;
                            timeZone = TimeUtils.getTimeZone(n43, bl17, l8, string24);
                        }
                    }
                    this.mNeedFixZone = bl13 = false;
                    if (timeZone != null) {
                        if (this.getAutoTime()) {
                            String string25 = timeZone.getID();
                            GsmServiceStateTracker gsmServiceStateTracker4 = this;
                            String string26 = string25;
                            gsmServiceStateTracker4.setAndBroadcastNetworkSetTimeZone(string26);
                        }
                        String string27 = timeZone.getID();
                        GsmServiceStateTracker gsmServiceStateTracker5 = this;
                        String string28 = string27;
                        gsmServiceStateTracker5.saveNitzTimeZone(string28);
                    }
                }
            }
            GSMPhone gSMPhone4 = this.phone;
            String string29 = "gsm.operator.isroaming";
            String string30 = this.ss.getRoaming() ? "true" : "false";
            gSMPhone4.setSystemProperty(string29, string30);
            GSMPhone gSMPhone5 = this.phone;
            ServiceState serviceState8 = this.ss;
            gSMPhone5.notifyServiceStateChanged(serviceState8);
        }
        if (bl5) {
            this.gprsAttachedRegistrants.notifyRegistrants();
        }
        if (bl6) {
            this.gprsDetachedRegistrants.notifyRegistrants();
        }
        if (bl7) {
            this.phone.notifyDataConnection(null);
        }
        if (bl9) {
            this.roamingOnRegistrants.notifyRegistrants();
        }
        if (bl10) {
            this.roamingOffRegistrants.notifyRegistrants();
        }
        if (bl11) {
            this.phone.notifyLocationChanged();
        }
        if ((gsmServiceStateTracker = this).isGprsConsistent(n4 = (n3 = this.gprsState), n2 = (n = this.ss.getState()))) {
            boolean bl18;
            this.mReportedGprsNoReg = bl18 = false;
            return;
        }
        if (this.mStartedGprsRegCheck) {
            return;
        }
        if (this.mReportedGprsNoReg) {
            return;
        }
        this.mStartedGprsRegCheck = bl = true;
        int n44 = Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "gprs_register_check_period_ms", 60000);
        GsmServiceStateTracker gsmServiceStateTracker6 = this;
        int n45 = 22;
        Message message = gsmServiceStateTracker6.obtainMessage(n45);
        long l = n44;
        GsmServiceStateTracker gsmServiceStateTracker7 = this;
        Message message2 = message;
        long l9 = l;
        boolean bl19 = gsmServiceStateTracker7.sendMessageDelayed(message2, l9);
    }

    private void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength) {
            return;
        }
        if (this.cm.getRadioState().isCdma()) {
            return;
        }
        Message message = this.obtainMessage();
        message.what = 10;
        boolean bl = this.sendMessageDelayed(message, 20000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean regCodeIsRoaming(int n) {
        if (5 == n) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int regCodeToServiceState(int n) {
        int n2 = 0;
        switch (n) {
            default: {
                String string2 = "unexpected service state " + n;
                int n3 = Log.w(LOG_TAG, string2);
                n2 = 1;
            }
            case 1: 
            case 5: {
                return n2;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
        }
        return 1;
    }

    private void revertToNitz() {
        if (Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time", 0) == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Reverting to NITZ: tz='");
        String string2 = this.mSavedTimeZone;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("' mSavedTime=");
        long l = this.mSavedTime;
        StringBuilder stringBuilder3 = stringBuilder2.append(l).append(" mSavedAtTime=");
        long l2 = this.mSavedAtTime;
        String string3 = stringBuilder3.append(l2).toString();
        int n = Log.d(LOG_TAG, string3);
        if (this.mSavedTimeZone == null) {
            return;
        }
        if (this.mSavedTime == 0L) {
            return;
        }
        if (this.mSavedAtTime == 0L) {
            return;
        }
        String string4 = this.mSavedTimeZone;
        this.setAndBroadcastNetworkSetTimeZone(string4);
        long l3 = this.mSavedTime;
        long l4 = SystemClock.elapsedRealtime();
        long l5 = this.mSavedAtTime;
        long l6 = l4 - l5;
        long l7 = l3 + l6;
        this.setAndBroadcastNetworkSetTime(l7);
    }

    private void saveNitzTime(long l) {
        long l2;
        this.mSavedTime = l;
        this.mSavedAtTime = l2 = SystemClock.elapsedRealtime();
    }

    private void saveNitzTimeZone(String string2) {
        this.mSavedTimeZone = string2;
    }

    private void setAndBroadcastNetworkSetTime(long l) {
        boolean bl = SystemClock.setCurrentTimeMillis(l);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        Intent intent2 = intent.addFlags(0x20000000);
        Intent intent3 = intent.putExtra("time", l);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setAndBroadcastNetworkSetTimeZone(String string2) {
        ((AlarmManager)this.phone.getContext().getSystemService("alarm")).setTimeZone(string2);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        Intent intent2 = intent.addFlags(0x20000000);
        Intent intent3 = intent.putExtra("time-zone", string2);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void setNotification(int n) {
        void var12_12;
        PendingIntent pendingIntent;
        long l;
        Notification notification;
        String string2 = "[DSAC DEB] create notification " + n;
        int n2 = Log.d(LOG_TAG, string2);
        Context context = this.phone.getContext();
        Notification notification2 = this.mNotification = (notification = new Notification());
        notification2.when = l = System.currentTimeMillis();
        this.mNotification.flags = 16;
        this.mNotification.icon = 17301642;
        Intent intent = new Intent();
        Notification notification3 = this.mNotification;
        notification3.contentIntent = pendingIntent = PendingIntent.getActivity(context, 0, intent, 0x10000000);
        String string3 = "";
        CharSequence charSequence = context.getText(17039572);
        int n3 = 999;
        switch (n) {
            case 1001: {
                n3 = 888;
                CharSequence charSequence2 = context.getText(17039573);
                break;
            }
            case 1002: {
                n3 = 888;
                break;
            }
            case 1003: {
                CharSequence charSequence3 = context.getText(17039576);
                break;
            }
            case 1005: {
                CharSequence charSequence4 = context.getText(17039575);
                break;
            }
            case 1006: {
                CharSequence charSequence5 = context.getText(17039574);
            }
        }
        String string4 = "[DSAC DEB] put notification " + charSequence + " / " + var12_12;
        int n4 = Log.d(LOG_TAG, string4);
        this.mNotification.tickerText = charSequence;
        Notification notification4 = this.mNotification;
        PendingIntent pendingIntent2 = this.mNotification.contentIntent;
        notification4.setLatestEventInfo(context, charSequence, (CharSequence)var12_12, pendingIntent2);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (n == 1002 || n == 1004) {
            notificationManager.cancel(n3);
            return;
        }
        Notification notification5 = this.mNotification;
        notificationManager.notify(n3, notification5);
    }

    private void setSignalStrengthDefaultValues() {
        SignalStrength signalStrength;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        this.mSignalStrength = signalStrength = new SignalStrength(99, -1, n, n2, n3, n4, n5, true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeFromNITZString(String var1_1, long var2_2) {
        block18: {
            block17: {
                var4_3 = SystemClock.elapsedRealtime();
                var6_4 = new StringBuilder().append("NITZ: ");
                var7_5 = var1_1;
                var8_6 = var6_4.append(var7_5).append(",");
                var9_7 = var2_2;
                var11_8 = var8_6.append(var9_7).append(" start=");
                var12_9 = var4_3;
                var14_10 = var11_8.append(var12_9).append(" delay=");
                var15_11 = var4_3 - var2_2;
                var17_12 = var14_10.append(var15_11).toString();
                var18_13 = Log.i("GSM", var17_12);
                try {
                    var19_14 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    var19_14.clear();
                    var20_15 = var19_14;
                    var21_16 = 16;
                    var22_17 = 0;
                    var20_15.set(var21_16, var22_17);
                    var23_18 = var1_1;
                    var24_19 = "[/:,+-]";
                    var25_20 = var23_18.split(var24_19);
                    var26_21 = Integer.parseInt(var25_20[0]) + 2000;
                    var27_22 = var19_14;
                    var28_23 = 1;
                    var29_24 = var26_21;
                    var27_22.set(var28_23, var29_24);
                    var30_25 = Integer.parseInt(var25_20[1]) - 1;
                    var31_26 = var19_14;
                    var32_27 = 2;
                    var33_28 = var30_25;
                    var31_26.set(var32_27, var33_28);
                    var34_29 = Integer.parseInt(var25_20[2]);
                    var35_30 = var19_14;
                    var36_31 = 5;
                    var37_32 = var34_29;
                    var35_30.set(var36_31, var37_32);
                    var38_33 = Integer.parseInt(var25_20[3]);
                    var39_34 = var19_14;
                    var40_35 = 10;
                    var41_36 = var38_33;
                    var39_34.set(var40_35, var41_36);
                    var42_37 = Integer.parseInt(var25_20[4]);
                    var43_38 = var19_14;
                    var44_39 = 12;
                    var45_40 = var42_37;
                    var43_38.set(var44_39, var45_40);
                    var46_41 = Integer.parseInt(var25_20[5]);
                    var47_42 = var19_14;
                    var48_43 = 13;
                    var49_44 = var46_41;
                    var47_42.set(var48_43, var49_44);
                    var50_45 = var1_1;
                    var51_46 = 45;
                    var52_47 = var50_45.indexOf(var51_46);
                    var48_43 = 65535;
                    var49_44 = var52_47 == var48_43 ? 1 : 0;
                    var55_48 = Integer.parseInt(var25_20[6]);
                    var56_49 = var25_20.length;
                    var57_50 = 8;
                    var58_51 = var56_49 >= var57_50 ? Integer.parseInt(var25_20[7]) : 0;
                    var59_52 = var49_44 != 0 ? 1 : 65535;
                    var55_48 = var59_52 * var55_48 * 15 * 60 * 1000;
                    var60_53 = null;
                    var61_54 = var25_20.length;
                    var62_55 = 9;
                    if (var61_54 >= var62_55) {
                        var60_53 = TimeZone.getTimeZone(var25_20[8].replace('!', '/'));
                    }
                    var63_56 = SystemProperties.get("gsm.operator.iso-country");
                    if (var60_53 == null && this.mGotCountryCode) {
                        if (var63_56 != null && var63_56.length() > 0) {
                            var59_52 = var58_51 != 0 ? 1 : 0;
                            var64_57 = var19_14.getTimeInMillis();
                            var66_58 = var55_48;
                            var67_59 = var59_52;
                            var68_60 = var64_57;
                            var70_61 = var63_56;
                            var60_53 = TimeUtils.getTimeZone(var66_58, (boolean)var67_59, var68_60, var70_61);
                        } else {
                            var59_52 = var58_51 != 0 ? 1 : 0;
                            var86_76 = var19_14.getTimeInMillis();
                            var88_77 = this;
                            var89_78 = var55_48;
                            var90_79 = var59_52;
                            var91_80 = var86_76;
                            var60_53 = var93_81 = var88_77.getNitzTimeZone(var89_78, (boolean)var90_79, var91_80);
                        }
                    }
                    if (var60_53 == null) {
                        this.mNeedFixZone = var71_62 = true;
                        this.mZoneOffset = var72_63 = var55_48;
                        var59_52 = var58_51 != 0 ? 1 : 0;
                        var73_64 = var59_52;
                        this.mZoneDst = var73_64;
                        this.mZoneTime = var74_65 = var19_14.getTimeInMillis();
                    }
                    if (var60_53 != null) {
                        if (this.getAutoTime()) {
                            var76_66 = var60_53.getID();
                            var77_67 = this;
                            var78_68 = var76_66;
                            var77_67.setAndBroadcastNetworkSetTimeZone(var78_68);
                        }
                        var79_69 = var60_53.getID();
                        var80_70 = this;
                        var81_71 = var79_69;
                        var80_70.saveNitzTimeZone(var81_71);
                    }
                    if ((var82_72 = SystemProperties.get("gsm.ignore-nitz")) == null || !(var83_73 = var82_72).equals(var84_74 = "yes")) break block17;
                    var85_75 = Log.i("GSM", "NITZ: Not setting clock because gsm.ignore-nitz is set");
                    return;
                }
                catch (RuntimeException var100_87) {
                    var101_88 = new StringBuilder().append("NITZ: Parsing NITZ time ");
                    var102_89 = var1_1;
                    var103_90 = var101_88.append(var102_89).toString();
                    var104_91 = "GSM";
                    var105_92 = var103_90;
                    var106_93 = var100_87;
                    var107_94 = Log.e(var104_91, var105_92, var106_93);
                    return;
                }
            }
            this.mWakeLock.acquire();
            if (!this.getAutoTime()) ** GOTO lbl162
            var94_82 = SystemClock.elapsedRealtime() - var2_2;
            if (var94_82 >= 0L) break block18;
            var96_83 = new StringBuilder().append("NITZ: not setting time, clock has rolled backwards since NITZ time was received, ");
            var97_84 = var1_1;
            var98_85 = var96_83.append(var97_84).toString();
            var99_86 = Log.i("GSM", var98_85);
            this.mWakeLock.release();
            return;
        }
        if (var94_82 > 0x7FFFFFFFL) {
            var108_95 = new StringBuilder().append("NITZ: not setting time, processing has taken ");
            var109_96 = var94_82 / 86400000L;
            var111_97 = var108_95.append(var109_96).append(" days").toString();
            var112_98 = Log.i("GSM", var111_97);
            this.mWakeLock.release();
            return;
        }
        var59_52 = 14;
        var113_99 = (int)var94_82;
        try {
            var114_100 = var19_14;
            var115_101 = var59_52;
            var116_102 = var113_99;
            var114_100.add(var115_101, var116_102);
            var117_103 = new StringBuilder().append("NITZ: Setting time of day to ");
            var118_104 = var19_14.getTime();
            var119_105 = var117_103.append(var118_104).append(" NITZ receive delay(ms): ");
            var120_106 = var94_82;
            var122_107 = var119_105.append(var120_106).append(" gained(ms): ");
            var123_108 = var19_14.getTimeInMillis();
            var125_109 = System.currentTimeMillis();
            var127_110 = var123_108 - var125_109;
            var129_111 = var122_107.append(var127_110).append(" from ");
            var130_112 = var1_1;
            var131_113 = var129_111.append(var130_112).toString();
            var132_114 = Log.i("GSM", var131_113);
            var133_115 = var19_14.getTimeInMillis();
            var135_116 = this;
            var136_117 = var133_115;
            var135_116.setAndBroadcastNetworkSetTime(var136_117);
            var138_118 = Log.i("GSM", "NITZ: after Setting time of day");
lbl162:
            // 2 sources

            var139_119 = String.valueOf(var19_14.getTimeInMillis());
            SystemProperties.set("gsm.nitz.time", var139_119);
            var140_120 = var19_14.getTimeInMillis();
            var142_121 = this;
            var143_122 = var140_120;
            var142_121.saveNitzTime(var143_122);
        }
        catch (Throwable var145_123) {
            this.mWakeLock.release();
            throw var145_123;
        }
        this.mWakeLock.release();
    }

    private static int twoDigitsAt(String string2, int n) {
        int n2 = Character.digit(string2.charAt(n), 10);
        int n3 = n + 1;
        int n4 = Character.digit(string2.charAt(n3), 10);
        if (n2 < 0 || n4 < 0) {
            throw new RuntimeException("invalid format");
        }
        return n2 * 10 + n4;
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForNetworkStateChanged(this);
        this.cm.unregisterForSIMReady(this);
        this.phone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnRestrictedStateChanged(this);
        this.cm.unSetOnNITZTime(this);
        ContentResolver contentResolver = this.cr;
        ContentObserver contentObserver = this.mAutoTimeObserver;
        contentResolver.unregisterContentObserver(contentObserver);
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "GsmServiceStateTracker finalized");
    }

    int getCurrentGprsState() {
        return this.gprsState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unhandled message with number: ");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.e(LOG_TAG, string2);
            }
            case 13: {
                return;
            }
            case 17: {
                if (this.mNeedToRegForSimLoaded) {
                    boolean bl;
                    SIMRecords sIMRecords = this.phone.mSIMRecords;
                    GsmServiceStateTracker gsmServiceStateTracker = this;
                    int n = 16;
                    Object var9_9 = null;
                    sIMRecords.registerForRecordsLoaded(gsmServiceStateTracker, n, var9_9);
                    this.mNeedToRegForSimLoaded = bl = false;
                }
                if (!this.phone.getContext().getResources().getBoolean(17629203)) {
                    this.phone.restoreSavedNetworkSelection(null);
                }
                this.pollState();
                this.queueNextSignalStrengthPoll();
                return;
            }
            case 1: {
                this.setPowerStateToDesired();
                this.pollState();
                return;
            }
            case 2: {
                this.pollState();
                return;
            }
            case 3: {
                if (!this.cm.getRadioState().isOn()) {
                    return;
                }
                if (this.cm.getRadioState().isCdma()) {
                    return;
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                AsyncResult asyncResult2 = asyncResult;
                gsmServiceStateTracker.onSignalStrengthResult(asyncResult2);
                this.queueNextSignalStrengthPoll();
                return;
            }
            case 15: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    String[] stringArray = (String[])asyncResult.result;
                    int n = -1;
                    int n3 = -1;
                    int n4 = stringArray.length;
                    int n5 = 3;
                    if (n4 >= n5) {
                        int n6 = 1;
                        try {
                            if (stringArray[n6] != null && stringArray[1].length() > 0) {
                                n = Integer.parseInt(stringArray[1], 16);
                            }
                            if (stringArray[2] != null && stringArray[2].length() > 0) {
                                int n7;
                                n3 = n7 = Integer.parseInt(stringArray[2], 16);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            StringBuilder stringBuilder = new StringBuilder().append("error parsing location: ");
                            NumberFormatException numberFormatException2 = numberFormatException;
                            String string3 = stringBuilder.append(numberFormatException2).toString();
                            int n8 = Log.w(LOG_TAG, string3);
                        }
                    }
                    GsmCellLocation gsmCellLocation = this.cellLoc;
                    int n9 = n;
                    int n10 = n3;
                    gsmCellLocation.setLacAndCid(n9, n10);
                    this.phone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                int n = message.what;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                int n11 = n;
                AsyncResult asyncResult3 = asyncResult;
                gsmServiceStateTracker.handlePollStateResult(n11, asyncResult3);
                return;
            }
            case 10: {
                CommandsInterface commandsInterface = this.cm;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                int n = 3;
                Message message2 = gsmServiceStateTracker.obtainMessage(n);
                commandsInterface.getSignalStrength(message2);
                return;
            }
            case 11: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                String string4 = (String)((Object[])asyncResult.result)[0];
                long l = (Long)((Object[])asyncResult.result)[1];
                GsmServiceStateTracker gsmServiceStateTracker = this;
                String string5 = string4;
                long l2 = l;
                gsmServiceStateTracker.setTimeFromNITZString(string5, l2);
                return;
            }
            case 12: {
                boolean bl;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.dontPollSignalStrength = bl = true;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                AsyncResult asyncResult4 = asyncResult;
                gsmServiceStateTracker.onSignalStrengthResult(asyncResult4);
                return;
            }
            case 16: {
                this.updateSpnDisplay();
                return;
            }
            case 18: {
                if (((AsyncResult)message.obj).exception != null) {
                    return;
                }
                CommandsInterface commandsInterface = this.cm;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                int n = 15;
                Object var54_54 = null;
                Message message3 = gsmServiceStateTracker.obtainMessage(n, var54_54);
                commandsInterface.getRegistrationState(message3);
                return;
            }
            case 20: {
                Object object = ((AsyncResult)message.obj).userObj;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                int n = 21;
                Object object2 = object;
                Message message4 = gsmServiceStateTracker.obtainMessage(n, object2);
                CommandsInterface commandsInterface = this.cm;
                int n12 = this.mPreferredNetworkType;
                CommandsInterface commandsInterface2 = commandsInterface;
                int n13 = n12;
                Message message5 = message4;
                commandsInterface2.setPreferredNetworkType(n13, message5);
                return;
            }
            case 21: {
                Throwable throwable;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.userObj == null) {
                    return;
                }
                AsyncResult asyncResult5 = AsyncResult.forMessage((Message)asyncResult.userObj);
                asyncResult5.exception = throwable = asyncResult.exception;
                ((Message)asyncResult.userObj).sendToTarget();
                return;
            }
            case 19: {
                int n;
                int n14;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.mPreferredNetworkType = asyncResult.exception == null ? (n14 = ((int[])asyncResult.result)[0]) : (n = 7);
                Object object = asyncResult.userObj;
                GsmServiceStateTracker gsmServiceStateTracker = this;
                int n15 = 20;
                Object object3 = object;
                Message message6 = gsmServiceStateTracker.obtainMessage(n15, object3);
                CommandsInterface commandsInterface = this.cm;
                int n16 = 7;
                Message message7 = message6;
                commandsInterface.setPreferredNetworkType(n16, message7);
                return;
            }
            case 22: {
                boolean bl;
                int n;
                int n17;
                int n18;
                int n19;
                GsmServiceStateTracker gsmServiceStateTracker;
                if (this.ss != null && !(gsmServiceStateTracker = this).isGprsConsistent(n19 = (n18 = this.gprsState), n17 = (n = this.ss.getState()))) {
                    boolean bl2;
                    GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
                    int n20 = 50107;
                    Object[] objectArray = new Object[2];
                    String string6 = this.ss.getOperatorNumeric();
                    objectArray[0] = string6;
                    int n21 = 1;
                    int n22 = gsmCellLocation != null ? gsmCellLocation.getCid() : 65535;
                    Integer n23 = n22;
                    objectArray[n21] = n23;
                    int n24 = EventLog.writeEvent(n20, objectArray);
                    this.mReportedGprsNoReg = bl2 = true;
                }
                this.mStartedGprsRegCheck = bl = false;
                return;
            }
            case 23: 
        }
        int n = Log.d(LOG_TAG, "[DSAC DEB] EVENT_RESTRICTED_STATE_CHANGED");
        AsyncResult asyncResult = (AsyncResult)message.obj;
        GsmServiceStateTracker gsmServiceStateTracker = this;
        AsyncResult asyncResult6 = asyncResult;
        gsmServiceStateTracker.onRestrictedStateChanged(asyncResult6);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void handlePollStateResult(int var1_1, AsyncResult var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 614->685)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isConcurrentVoiceAndData() {
        if (this.networkType < 3) return false;
        return true;
    }

    @Override
    protected void powerOffRadioSafely() {
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        Message message = dataConnectionTracker.obtainMessage(34);
        message.arg1 = 1;
        message.obj = "radioTurnedOff";
        boolean bl = dataConnectionTracker.sendMessage(message);
        int n = 0;
        while (true) {
            block6: {
                block5: {
                    DataConnectionTracker.State state;
                    DataConnectionTracker.State state2;
                    DataConnectionTracker.State state3;
                    if (n >= 15) break block5;
                    DataConnectionTracker.State state4 = dataConnectionTracker.getState();
                    if (state4 == (state3 = DataConnectionTracker.State.CONNECTED) || (state2 = dataConnectionTracker.getState()) == (state = DataConnectionTracker.State.DISCONNECTING)) break block6;
                    int n2 = Log.d(LOG_TAG, "Data shutdown complete.");
                }
                if (this.phone.isInCall()) {
                    this.phone.mCT.ringingCall.hangupIfAlive();
                    this.phone.mCT.backgroundCall.hangupIfAlive();
                    this.phone.mCT.foregroundCall.hangupIfAlive();
                }
                this.cm.setRadioPower(false, null);
                return;
            }
            SystemClock.sleep(100L);
            ++n;
        }
    }

    void registerForGprsAttached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.gprsAttachedRegistrants.add(registrant);
        if (this.gprsState != 0) {
            return;
        }
        registrant.notifyRegistrant();
    }

    void registerForGprsDetached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.gprsDetachedRegistrants.add(registrant);
        if (this.gprsState != 1) {
            return;
        }
        registrant.notifyRegistrant();
    }

    void registerForNetworkAttach(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.networkAttachedRegistrants.add(registrant);
        if (this.ss.getState() != 0) {
            return;
        }
        registrant.notifyRegistrant();
    }

    void registerForPsRestrictedDisabled(Handler handler, int n, Object object) {
        int n2 = Log.d(LOG_TAG, "[DSAC DEB] registerForPsRestrictedDisabled ");
        Registrant registrant = new Registrant(handler, n, object);
        this.psRestrictDisabledRegistrants.add(registrant);
        if (!this.rs.isPsRestricted()) {
            return;
        }
        registrant.notifyRegistrant();
    }

    void registerForPsRestrictedEnabled(Handler handler, int n, Object object) {
        int n2 = Log.d(LOG_TAG, "[DSAC DEB] registerForPsRestrictedEnabled ");
        Registrant registrant = new Registrant(handler, n, object);
        this.psRestrictEnabledRegistrants.add(registrant);
        if (!this.rs.isPsRestricted()) {
            return;
        }
        registrant.notifyRegistrant();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setPowerStateToDesired() {
        CommandsInterface.RadioState radioState;
        CommandsInterface.RadioState radioState2;
        if (this.mDesiredPowerState && (radioState2 = this.cm.getRadioState()) == (radioState = CommandsInterface.RadioState.RADIO_OFF)) {
            this.cm.setRadioPower(true, null);
            return;
        }
        if (this.mDesiredPowerState) {
            return;
        }
        if (!this.cm.getRadioState().isOn()) {
            return;
        }
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        if (!dataConnectionTracker.isDataConnectionAsDesired()) {
            int n = 50108;
            Object[] objectArray = new Object[2];
            String string2 = dataConnectionTracker.getStateInString();
            objectArray[0] = string2;
            int n2 = dataConnectionTracker.getAnyDataEnabled() ? 1 : 0;
            Integer n3 = n2;
            objectArray[1] = n3;
            int n4 = EventLog.writeEvent(n, objectArray);
        }
        this.powerOffRadioSafely();
    }

    void unregisterForGprsAttached(Handler handler) {
        this.gprsAttachedRegistrants.remove(handler);
    }

    void unregisterForGprsDetached(Handler handler) {
        this.gprsDetachedRegistrants.remove(handler);
    }

    void unregisterForNetworkAttach(Handler handler) {
        this.networkAttachedRegistrants.remove(handler);
    }

    void unregisterForPsRestrictedDisabled(Handler handler) {
        this.psRestrictDisabledRegistrants.remove(handler);
    }

    void unregisterForPsRestrictedEnabled(Handler handler) {
        this.psRestrictEnabledRegistrants.remove(handler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateSpnDisplay() {
        String string2;
        String string3;
        int n;
        SIMRecords sIMRecords = this.phone.mSIMRecords;
        String string4 = this.ss.getOperatorNumeric();
        int n2 = sIMRecords.getDisplayRule(string4);
        String string5 = this.phone.mSIMRecords.getServiceProviderName();
        String string6 = this.ss.getOperatorAlphaLong();
        if (this.mEmergencyOnly && this.cm.getRadioState().isOn()) {
            string6 = ((Object)Resources.getSystem().getText(17040016)).toString();
        }
        if (n2 == (n = this.curSpnRule) || !TextUtils.equals(string5, string3 = this.curSpn) || !TextUtils.equals(string6, string2 = this.curPlmn)) {
            boolean bl = !this.mEmergencyOnly && (n2 & 1) == 1;
            boolean bl2 = (n2 & 2) == 2;
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            Intent intent2 = intent.addFlags(0x20000000);
            Intent intent3 = intent.putExtra("showSpn", bl);
            Intent intent4 = intent.putExtra("spn", string5);
            Intent intent5 = intent.putExtra("showPlmn", bl2);
            Intent intent6 = intent.putExtra("plmn", string6);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.curSpnRule = n2;
        this.curSpn = string5;
        this.curPlmn = string6;
    }
}

