/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.gsm.GSMPhone;

public final class SIMFileHandler
extends IccFileHandler
implements IccConstants {
    static final String LOG_TAG = "GSM";
    private Phone mPhone;

    SIMFileHandler(GSMPhone gSMPhone) {
        super(gSMPhone);
        this.mPhone = gSMPhone;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "SIMFileHandler finalized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getEFPath(int n) {
        String string2;
        switch (n) {
            default: {
                IccCardApplication.AppType appType;
                string2 = this.getCommonIccEFPath(n);
                if (string2 != null) return string2;
                IccCard iccCard = this.phone.getIccCard();
                if (iccCard == null || !iccCard.isApplicationOnIcc(appType = IccCardApplication.AppType.APPTYPE_USIM)) break;
                return "3F007F105F3A";
            }
            case 28476: {
                return "3F007F10";
            }
            case 28472: 
            case 28486: 
            case 28589: 
            case 28613: 
            case 28615: 
            case 28616: 
            case 28617: 
            case 28618: 
            case 28619: 
            case 28621: {
                return "3F007F20";
            }
            case 28433: 
            case 28435: 
            case 28436: 
            case 28438: 
            case 28439: 
            case 28440: {
                return "3F007F20";
            }
            case 20272: {
                return "3F007F105F3A";
            }
        }
        int n2 = Log.e(LOG_TAG, "Error: EF Path being returned in null");
        return string2;
    }

    @Override
    public void handleMessage(Message message) {
        super.handleMessage(message);
    }

    @Override
    protected void logd(String string2) {
        String string3 = "[SIMFileHandler] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    @Override
    protected void loge(String string2) {
        String string3 = "[SIMFileHandler] " + string2;
        int n = Log.e(LOG_TAG, string3);
    }
}

