/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Message;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.IccVmFixedException;
import com.android.internal.telephony.IccVmNotSupportedException;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.gsm.SpnOverride;
import com.android.internal.telephony.gsm.VoiceMailConstants;
import java.util.ArrayList;
import java.util.Iterator;

public final class SIMRecords
extends IccRecords {
    static final int CFF_LINE1_MASK = 15;
    static final int CFF_LINE1_RESET = 240;
    static final int CFF_UNCONDITIONAL_ACTIVE = 10;
    static final int CFF_UNCONDITIONAL_DEACTIVE = 5;
    private static final int CPHS_SST_MBN_ENABLED = 48;
    private static final int CPHS_SST_MBN_MASK = 48;
    private static final boolean CRASH_RIL = false;
    private static final boolean DBG = true;
    private static final int EVENT_GET_AD_DONE = 9;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_GET_CFF_DONE = 24;
    private static final int EVENT_GET_CFIS_DONE = 32;
    private static final int EVENT_GET_CPHS_MAILBOX_DONE = 11;
    private static final int EVENT_GET_ICCID_DONE = 4;
    private static final int EVENT_GET_IMSI_DONE = 3;
    private static final int EVENT_GET_INFO_CPHS_DONE = 26;
    private static final int EVENT_GET_MBDN_DONE = 6;
    private static final int EVENT_GET_MBI_DONE = 5;
    private static final int EVENT_GET_MSISDN_DONE = 10;
    private static final int EVENT_GET_MWIS_DONE = 7;
    private static final int EVENT_GET_PNN_DONE = 15;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_GET_SPDI_DONE = 13;
    private static final int EVENT_GET_SPN_DONE = 12;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE = 8;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 2;
    private static final int EVENT_SET_CPHS_MAILBOX_DONE = 25;
    private static final int EVENT_SET_MBDN_DONE = 20;
    private static final int EVENT_SET_MSISDN_DONE = 30;
    private static final int EVENT_SIM_READY = 1;
    private static final int EVENT_SIM_REFRESH = 31;
    private static final int EVENT_SMS_ON_SIM = 21;
    private static final int EVENT_UPDATE_DONE = 14;
    static final String LOG_TAG = "GSM";
    private static final String[] MCCMNC_CODES_HAVING_3DIGITS_MNC;
    static final int SPN_RULE_SHOW_PLMN = 2;
    static final int SPN_RULE_SHOW_SPN = 1;
    static final int TAG_FULL_NETWORK_NAME = 67;
    static final int TAG_SHORT_NETWORK_NAME = 69;
    static final int TAG_SPDI_PLMN_LIST = 128;
    boolean callForwardingEnabled;
    byte[] efCPHS_MWI = null;
    byte[] efMWIS = null;
    String imsi;
    private byte[] mCphsInfo = null;
    byte[] mEfCff = null;
    byte[] mEfCfis = null;
    SpnOverride mSpnOverride;
    VoiceMailConstants mVmConfig;
    String pnnHomeName = null;
    ArrayList<String> spdiNetworks = null;
    int spnDisplayCondition;
    private Get_Spn_Fsm_State spnState;

    static {
        String[] stringArray = new String[]{"405025", "405026", "405027", "405028", "405029", "405030", "405031", "405032", "405033", "405034", "405035", "405036", "405037", "405038", "405039", "405040", "405041", "405042", "405043", "405044", "405045", "405046", "405047", "405750", "405751", "405752", "405753", "405754", "405755", "405756", "405799", "405800", "405801", "405802", "405803", "405804", "405805", "405806", "405807", "405808", "405809", "405810", "405811", "405812", "405813", "405814", "405815", "405816", "405817", "405818", "405819", "405820", "405821", "405822", "405823", "405824", "405825", "405826", "405827", "405828", "405829", "405830", "405831", "405832", "405833", "405834", "405835", "405836", "405837", "405838", "405839", "405840", "405841", "405842", "405843", "405844", "405845", "405846", "405847", "405848", "405849", "405850", "405851", "405852", "405853", "405875", "405876", "405877", "405878", "405879", "405880", "405881", "405882", "405883", "405884", "405885", "405886", "405908", "405909", "405910", "405911", "405925", "405926", "405927", "405928", "405929", "405932"};
        MCCMNC_CODES_HAVING_3DIGITS_MNC = stringArray;
    }

    SIMRecords(GSMPhone gSMPhone) {
        super(gSMPhone);
        SpnOverride spnOverride;
        VoiceMailConstants voiceMailConstants;
        AdnRecordCache adnRecordCache;
        PhoneBase phoneBase = this.phone;
        this.adnCache = adnRecordCache = new AdnRecordCache(phoneBase);
        this.mVmConfig = voiceMailConstants = new VoiceMailConstants();
        this.mSpnOverride = spnOverride = new SpnOverride();
        this.recordsRequested = false;
        this.recordsToLoad = 0;
        gSMPhone.mCM.registerForSIMReady(this, 1, null);
        gSMPhone.mCM.registerForOffOrNotAvailable(this, 2, null);
        gSMPhone.mCM.setOnSmsOnSim(this, 21, null);
        gSMPhone.mCM.setOnIccRefresh(this, 31, null);
        this.onRadioOffOrNotAvailable();
    }

    private void fetchSimRecords() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        this.recordsRequested = true;
        IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
        StringBuilder stringBuilder = new StringBuilder().append("SIMRecords:fetchSimRecords ");
        int n14 = this.recordsToLoad;
        String string2 = stringBuilder.append(n14).toString();
        int n15 = Log.v(LOG_TAG, string2);
        CommandsInterface commandsInterface = this.phone.mCM;
        Message message = this.obtainMessage(3);
        commandsInterface.getIMSI(message);
        this.recordsToLoad = n13 = this.recordsToLoad + 1;
        Message message2 = this.obtainMessage(4);
        iccFileHandler.loadEFTransparent(12258, message2);
        this.recordsToLoad = n12 = this.recordsToLoad + 1;
        PhoneBase phoneBase = this.phone;
        AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
        Message message3 = this.obtainMessage(10);
        adnRecordLoader.loadFromEF(28480, 28490, 1, message3);
        this.recordsToLoad = n11 = this.recordsToLoad + 1;
        Message message4 = this.obtainMessage(5);
        iccFileHandler.loadEFLinearFixed(28617, 1, message4);
        this.recordsToLoad = n10 = this.recordsToLoad + 1;
        Message message5 = this.obtainMessage(9);
        iccFileHandler.loadEFTransparent(28589, message5);
        this.recordsToLoad = n9 = this.recordsToLoad + 1;
        Message message6 = this.obtainMessage(7);
        iccFileHandler.loadEFLinearFixed(28618, 1, message6);
        this.recordsToLoad = n8 = this.recordsToLoad + 1;
        Message message7 = this.obtainMessage(8);
        iccFileHandler.loadEFTransparent(28433, message7);
        this.recordsToLoad = n7 = this.recordsToLoad + 1;
        Message message8 = this.obtainMessage(32);
        iccFileHandler.loadEFLinearFixed(28619, 1, message8);
        this.recordsToLoad = n6 = this.recordsToLoad + 1;
        Message message9 = this.obtainMessage(24);
        iccFileHandler.loadEFTransparent(28435, message9);
        this.recordsToLoad = n5 = this.recordsToLoad + 1;
        this.getSpnFsm(true, null);
        Message message10 = this.obtainMessage(13);
        iccFileHandler.loadEFTransparent(28621, message10);
        this.recordsToLoad = n4 = this.recordsToLoad + 1;
        Message message11 = this.obtainMessage(15);
        iccFileHandler.loadEFLinearFixed(28613, 1, message11);
        this.recordsToLoad = n3 = this.recordsToLoad + 1;
        Message message12 = this.obtainMessage(17);
        iccFileHandler.loadEFTransparent(28472, message12);
        this.recordsToLoad = n2 = this.recordsToLoad + 1;
        Message message13 = this.obtainMessage(26);
        iccFileHandler.loadEFTransparent(28438, message13);
        this.recordsToLoad = n = this.recordsToLoad + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getSpnFsm(boolean bl, AsyncResult asyncResult) {
        Get_Spn_Fsm_State get_Spn_Fsm_State;
        if (bl) {
            Get_Spn_Fsm_State get_Spn_Fsm_State2;
            this.spnState = get_Spn_Fsm_State2 = Get_Spn_Fsm_State.INIT;
        }
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$gsm$SIMRecords$Get_Spn_Fsm_State;
        int n = this.spnState.ordinal();
        switch (nArray[n]) {
            default: {
                Get_Spn_Fsm_State get_Spn_Fsm_State3;
                this.spnState = get_Spn_Fsm_State3 = Get_Spn_Fsm_State.IDLE;
                return;
            }
            case 1: {
                Get_Spn_Fsm_State get_Spn_Fsm_State4;
                int n2;
                this.spn = null;
                IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
                Message message = this.obtainMessage(12);
                iccFileHandler.loadEFTransparent(28486, message);
                this.recordsToLoad = n2 = this.recordsToLoad + 1;
                this.spnState = get_Spn_Fsm_State4 = Get_Spn_Fsm_State.READ_SPN_3GPP;
                return;
            }
            case 2: {
                Get_Spn_Fsm_State get_Spn_Fsm_State5;
                int n3;
                if (asyncResult != null && asyncResult.exception == null) {
                    Get_Spn_Fsm_State get_Spn_Fsm_State6;
                    String string2;
                    int n4;
                    byte[] byArray = (byte[])asyncResult.result;
                    this.spnDisplayCondition = n4 = byArray[0] & 0xFF;
                    int n5 = byArray.length - 1;
                    this.spn = string2 = IccUtils.adnStringFieldToString(byArray, 1, n5);
                    StringBuilder stringBuilder = new StringBuilder().append("Load EF_SPN: ");
                    String string3 = this.spn;
                    StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" spnDisplayCondition: ");
                    int n6 = this.spnDisplayCondition;
                    String string4 = stringBuilder2.append(n6).toString();
                    this.log(string4);
                    PhoneBase phoneBase = this.phone;
                    String string5 = this.spn;
                    phoneBase.setSystemProperty("gsm.sim.operator.alpha", string5);
                    this.spnState = get_Spn_Fsm_State6 = Get_Spn_Fsm_State.IDLE;
                    return;
                }
                IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
                Message message = this.obtainMessage(12);
                iccFileHandler.loadEFTransparent(28436, message);
                this.recordsToLoad = n3 = this.recordsToLoad + 1;
                this.spnState = get_Spn_Fsm_State5 = Get_Spn_Fsm_State.READ_SPN_CPHS;
                this.spnDisplayCondition = -1;
                return;
            }
            case 3: {
                Get_Spn_Fsm_State get_Spn_Fsm_State7;
                int n7;
                if (asyncResult != null && asyncResult.exception == null) {
                    Get_Spn_Fsm_State get_Spn_Fsm_State8;
                    String string6;
                    byte[] byArray = (byte[])asyncResult.result;
                    int n8 = byArray.length - 1;
                    this.spn = string6 = IccUtils.adnStringFieldToString(byArray, 0, n8);
                    StringBuilder stringBuilder = new StringBuilder().append("Load EF_SPN_CPHS: ");
                    String string7 = this.spn;
                    String string8 = stringBuilder.append(string7).toString();
                    this.log(string8);
                    PhoneBase phoneBase = this.phone;
                    String string9 = this.spn;
                    phoneBase.setSystemProperty("gsm.sim.operator.alpha", string9);
                    this.spnState = get_Spn_Fsm_State8 = Get_Spn_Fsm_State.IDLE;
                    return;
                }
                IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
                Message message = this.obtainMessage(12);
                iccFileHandler.loadEFTransparent(28440, message);
                this.recordsToLoad = n7 = this.recordsToLoad + 1;
                this.spnState = get_Spn_Fsm_State7 = Get_Spn_Fsm_State.READ_SPN_SHORT_CPHS;
                return;
            }
            case 4: 
        }
        if (asyncResult != null && asyncResult.exception == null) {
            String string10;
            byte[] byArray = (byte[])asyncResult.result;
            int n9 = byArray.length - 1;
            this.spn = string10 = IccUtils.adnStringFieldToString(byArray, 0, n9);
            StringBuilder stringBuilder = new StringBuilder().append("Load EF_SPN_SHORT_CPHS: ");
            String string11 = this.spn;
            String string12 = stringBuilder.append(string11).toString();
            this.log(string12);
            PhoneBase phoneBase = this.phone;
            String string13 = this.spn;
            phoneBase.setSystemProperty("gsm.sim.operator.alpha", string13);
        } else {
            this.log("No SPN loaded in either CHPS or 3GPP");
        }
        this.spnState = get_Spn_Fsm_State = Get_Spn_Fsm_State.IDLE;
    }

    private void handleFileUpdate(int n) {
        int n2;
        switch (n) {
            default: {
                this.adnCache.reset();
                this.fetchSimRecords();
                return;
            }
            case 28615: {
                int n3;
                this.recordsToLoad = n3 = this.recordsToLoad + 1;
                PhoneBase phoneBase = this.phone;
                AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
                int n4 = this.mailboxIndex;
                Message message = this.obtainMessage(6);
                adnRecordLoader.loadFromEF(28615, 28616, n4, message);
                return;
            }
            case 28439: 
        }
        this.recordsToLoad = n2 = this.recordsToLoad + 1;
        PhoneBase phoneBase = this.phone;
        AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
        Message message = this.obtainMessage(11);
        adnRecordLoader.loadFromEF(28439, 28490, 1, message);
    }

    private void handleSimRefresh(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.log("handleSimRefresh without input");
            return;
        }
        switch (nArray[0]) {
            default: {
                this.log("handleSimRefresh with unknown operation");
                return;
            }
            case 0: {
                this.log("handleSimRefresh with SIM_REFRESH_FILE_UPDATED");
                int n = nArray[1];
                this.handleFileUpdate(n);
                return;
            }
            case 1: {
                this.log("handleSimRefresh with SIM_REFRESH_INIT");
                this.adnCache.reset();
                this.fetchSimRecords();
                return;
            }
            case 2: 
        }
        this.log("handleSimRefresh with SIM_REFRESH_RESET");
        this.phone.mCM.setRadioPower(false, null);
    }

    private void handleSms(byte[] byArray) {
        if (byArray[0] != null) {
            StringBuilder stringBuilder = new StringBuilder().append("status : ");
            byte by = byArray[0];
            String string2 = stringBuilder.append(by).toString();
            int n = Log.d("ENF", string2);
        }
        if (byArray[0] != 3) {
            return;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n - 1];
        int n2 = n - 1;
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        SmsMessage smsMessage = SmsMessage.createFromPdu(byArray2);
        int n3 = ((GSMPhone)this.phone).mSMS.dispatchMessage(smsMessage);
    }

    private void handleSmses(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = (byte[])arrayList.get(n2);
            if (byArray[0] != null) {
                StringBuilder stringBuilder = new StringBuilder().append("status ").append(n2).append(": ");
                byte by = byArray[0];
                String string2 = stringBuilder.append(by).toString();
                int n3 = Log.i("ENF", string2);
            }
            if (byArray[0] == 3) {
                int n4 = byArray.length;
                byte[] byArray2 = new byte[n4 - 1];
                int n5 = n4 - 1;
                System.arraycopy(byArray, 1, byArray2, 0, n5);
                SmsMessage smsMessage = SmsMessage.createFromPdu(byArray2);
                int n6 = ((GSMPhone)this.phone).mSMS.dispatchMessage(smsMessage);
                byArray[0] = 1;
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCphsMailboxEnabled() {
        if (this.mCphsInfo == null) {
            return false;
        }
        if ((this.mCphsInfo[1] & 0x30) != 48) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOnMatchingPlmn(String string2) {
        String string3;
        if (string2 == null) {
            return false;
        }
        String string4 = this.getSIMOperatorNumeric();
        if (string2.equals(string4)) {
            return true;
        }
        if (this.spdiNetworks == null) return false;
        Iterator<String> iterator = this.spdiNetworks.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!string2.equals(string3 = iterator.next()));
        return true;
    }

    private void onSimReady() {
        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("READY", null);
        this.fetchSimRecords();
    }

    private void parseEfSpdi(byte[] byArray) {
        int n = byArray.length;
        SimTlv simTlv = new SimTlv(byArray, 0, n);
        byte[] byArray2 = null;
        while (true) {
            block8: {
                block7: {
                    if (!simTlv.isValidObject()) break block7;
                    if (simTlv.getTag() != 128) break block8;
                    byArray2 = simTlv.getData();
                }
                if (byArray2 != null) break;
                return;
            }
            boolean bl = simTlv.nextObject();
        }
        int n2 = byArray2.length / 3;
        ArrayList arrayList = new ArrayList(n2);
        this.spdiNetworks = arrayList;
        int n3 = 0;
        int n4;
        int n5;
        while ((n5 = n3 + 2) < (n4 = byArray2.length)) {
            String string2 = IccUtils.bcdToString(byArray2, n3, 3);
            if (string2.length() >= 5) {
                String string3 = "EF_SPDI network: " + string2;
                this.log(string3);
                boolean bl = this.spdiNetworks.add(string2);
            }
            n3 += 3;
        }
        return;
    }

    private void setSpnFromConfig(String string2) {
        String string3;
        if (!this.mSpnOverride.containsCarrier(string2)) {
            return;
        }
        this.spn = string3 = this.mSpnOverride.getSpn(string2);
    }

    private void setVoiceMailByCountry(String string2) {
        String string3;
        String string4;
        if (!this.mVmConfig.containsCarrier(string2)) {
            return;
        }
        this.isVoiceMailFixed = true;
        this.voiceMailNum = string4 = this.mVmConfig.getVoiceMailNumber(string2);
        this.voiceMailTag = string3 = this.mVmConfig.getVoiceMailTag(string2);
    }

    public void dispose() {
        this.phone.mCM.unregisterForSIMReady(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unSetOnIccRefresh(this);
    }

    protected void finalize() {
        int n = Log.d(LOG_TAG, "SIMRecords finalized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getDisplayRule(String string2) {
        int n;
        if (this.spn == null) return 2;
        if (this.spnDisplayCondition == -1) {
            return 2;
        }
        if (this.isOnMatchingPlmn(string2)) {
            n = 1;
            if ((this.spnDisplayCondition & 1) != 1) return n;
            n |= 2;
            return n;
        }
        n = 2;
        if ((this.spnDisplayCondition & 2) != 0) return n;
        n |= 1;
        return n;
    }

    public String getIMSI() {
        return this.imsi;
    }

    @Override
    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    @Override
    public String getMsisdnNumber() {
        return this.msisdn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getSIMOperatorNumeric() {
        if (this.imsi == null) return null;
        if (this.mncLength == -1) return null;
        if (this.mncLength == 0) {
            return null;
        }
        String string2 = this.imsi;
        int n = this.mncLength + 3;
        return string2.substring(0, n);
    }

    public boolean getVoiceCallForwardingFlag() {
        return this.callForwardingEnabled;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    @Override
    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Message var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5, 6 : 191->198)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void log(String string2) {
        String string3 = "[SIMRecords] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onAllRecordsLoaded() {
        int n = Log.d(LOG_TAG, "SIMRecords: record load complete");
        String string2 = this.getSIMOperatorNumeric();
        this.phone.setSystemProperty("gsm.sim.operator.numeric", string2);
        if (this.imsi != null) {
            PhoneBase phoneBase = this.phone;
            String string3 = MccTable.countryCodeForMcc(Integer.parseInt(this.imsi.substring(0, 3)));
            phoneBase.setSystemProperty("gsm.sim.operator.iso-country", string3);
        } else {
            int n2 = Log.e("SIM", "[SIMRecords] onAllRecordsLoaded: imsi is NULL!");
        }
        this.setVoiceMailByCountry(string2);
        this.setSpnFromConfig(string2);
        RegistrantList registrantList = this.recordsLoadedRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, null, null);
        registrantList.notifyRegistrants(asyncResult);
        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("LOADED", null);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.imsi = null;
        this.msisdn = null;
        this.voiceMailNum = null;
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.iccid = null;
        this.spnDisplayCondition = -1;
        this.efMWIS = null;
        this.efCPHS_MWI = null;
        this.spdiNetworks = null;
        this.pnnHomeName = null;
        this.adnCache.reset();
        this.phone.setSystemProperty("gsm.sim.operator.numeric", null);
        this.phone.setSystemProperty("gsm.sim.operator.alpha", null);
        this.phone.setSystemProperty("gsm.sim.operator.iso-country", null);
        this.recordsRequested = false;
    }

    @Override
    protected void onRecordLoaded() {
        int n;
        this.recordsToLoad = n = this.recordsToLoad - 1;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
            return;
        }
        if (this.recordsToLoad >= 0) {
            return;
        }
        int n2 = Log.e(LOG_TAG, "SIMRecords: recordsToLoad <0, programmer error suspected");
        this.recordsToLoad = 0;
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        if (!bl) {
            return;
        }
        this.fetchSimRecords();
    }

    @Override
    public void setMsisdnNumber(String string2, String string3, Message message) {
        this.msisdn = string3;
        this.msisdnTag = string2;
        StringBuilder stringBuilder = new StringBuilder().append("Set MSISDN: ");
        String string4 = this.msisdnTag;
        String string5 = stringBuilder.append(string4).append(" ").append("xxxxxxx").toString();
        this.log(string5);
        String string6 = this.msisdnTag;
        String string7 = this.msisdn;
        AdnRecord adnRecord = new AdnRecord(string6, string7);
        PhoneBase phoneBase = this.phone;
        AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
        Message message2 = this.obtainMessage(30, message);
        adnRecordLoader.updateEF(adnRecord, 28480, 28490, 1, null, message2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVoiceCallForwardingFlag(int n, boolean bl) {
        block9: {
            byte by;
            block8: {
                if (n != 1) {
                    return;
                }
                this.callForwardingEnabled = bl;
                ((GSMPhone)this.phone).notifyCallForwardingIndicator();
                try {
                    byte by2;
                    if (this.mEfCfis != null) {
                        if (bl) {
                            byte by3;
                            byte[] byArray = this.mEfCfis;
                            byArray[1] = by3 = (byte)(byArray[1] | 1);
                        } else {
                            byte by4;
                            byte[] byArray = this.mEfCfis;
                            byArray[1] = by4 = (byte)(byArray[1] & 0xFE);
                        }
                        IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
                        byte[] byArray = this.mEfCfis;
                        Integer n2 = 28619;
                        Message message = this.obtainMessage(14, n2);
                        iccFileHandler.updateEFLinearFixed(28619, 1, byArray, null, message);
                    }
                    if (this.mEfCff == null) {
                        return;
                    }
                    if (!bl) break block8;
                    byte[] byArray = this.mEfCff;
                    byArray[0] = by2 = (byte)(this.mEfCff[0] & 0xF0 | 0xA);
                    break block9;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int n3 = Log.w(LOG_TAG, "Error saving call fowarding flag to SIM. Probably malformed SIM record", arrayIndexOutOfBoundsException);
                    return;
                }
            }
            byte[] byArray = this.mEfCff;
            byArray[0] = by = (byte)(this.mEfCff[0] & 0xF0 | 5);
        }
        IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
        byte[] byArray = this.mEfCff;
        Integer n4 = 28435;
        Message message = this.obtainMessage(14, n4);
        iccFileHandler.updateEFTransparent(28435, byArray, message);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        if (this.isVoiceMailFixed) {
            AsyncResult asyncResult = AsyncResult.forMessage(message);
            IccVmFixedException iccVmFixedException = new IccVmFixedException("Voicemail number is fixed by operator");
            asyncResult.exception = iccVmFixedException;
            message.sendToTarget();
            return;
        }
        this.newVoiceMailNum = string3;
        String string4 = this.newVoiceMailTag = string2;
        String string5 = this.newVoiceMailNum;
        AdnRecord adnRecord = new AdnRecord(string4, string5);
        if (this.mailboxIndex != 0 && this.mailboxIndex != 255) {
            PhoneBase phoneBase = this.phone;
            AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
            int n = this.mailboxIndex;
            Message message2 = this.obtainMessage(20, message);
            adnRecordLoader.updateEF(adnRecord, 28615, 28616, n, null, message2);
            return;
        }
        if (this.isCphsMailboxEnabled()) {
            PhoneBase phoneBase = this.phone;
            AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
            Message message3 = this.obtainMessage(25, message);
            adnRecordLoader.updateEF(adnRecord, 28439, 28490, 1, null, message3);
            return;
        }
        AsyncResult asyncResult = AsyncResult.forMessage(message);
        IccVmNotSupportedException iccVmNotSupportedException = new IccVmNotSupportedException("Update SIM voice mailbox error");
        asyncResult.exception = iccVmNotSupportedException;
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        if (n != 1) {
            return;
        }
        if (n2 < 0) {
            n2 = -1;
        } else if (n2 > 255) {
            n2 = 255;
        }
        this.countVoiceMessages = n2;
        ((GSMPhone)this.phone).notifyMessageWaitingIndicator();
        try {
            byte by;
            int n3;
            int n4;
            int n5;
            byte[] byArray;
            if (this.efMWIS != null) {
                byte by2;
                byArray = this.efMWIS;
                n5 = 0;
                n4 = this.efMWIS[0] & 0xFE;
                n3 = this.countVoiceMessages == 0 ? 0 : 1;
                byArray[n5] = by2 = (byte)(n4 | n3);
                if (n2 < 0) {
                    this.efMWIS[1] = 0;
                } else {
                    byte by3;
                    byte[] byArray2 = this.efMWIS;
                    byArray2[1] = by3 = (byte)n2;
                }
                IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
                byte[] byArray3 = this.efMWIS;
                Integer n6 = 28618;
                Message message = this.obtainMessage(14, n6);
                iccFileHandler.updateEFLinearFixed(28618, 1, byArray3, null, message);
            }
            if (this.efCPHS_MWI == null) {
                return;
            }
            byArray = this.efCPHS_MWI;
            n5 = 0;
            n4 = this.efCPHS_MWI[0] & 0xF0;
            n3 = this.countVoiceMessages == 0 ? 5 : 10;
            byArray[n5] = by = (byte)(n4 | n3);
            IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
            byte[] byArray4 = this.efCPHS_MWI;
            Integer n7 = 28433;
            Message message = this.obtainMessage(14, n7);
            iccFileHandler.updateEFTransparent(28433, byArray4, message);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n8 = Log.w(LOG_TAG, "Error saving voice mail state to SIM. Probably malformed SIM record", arrayIndexOutOfBoundsException);
            return;
        }
    }

    private static final class Get_Spn_Fsm_State
    extends Enum<Get_Spn_Fsm_State> {
        private static final /* synthetic */ Get_Spn_Fsm_State[] $VALUES;
        public static final /* enum */ Get_Spn_Fsm_State IDLE = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State INIT = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State READ_SPN_3GPP = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State READ_SPN_CPHS = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State READ_SPN_SHORT_CPHS = new Get_Spn_Fsm_State();

        static {
            Get_Spn_Fsm_State get_Spn_Fsm_State = IDLE;
            Get_Spn_Fsm_State get_Spn_Fsm_State2 = INIT;
            Get_Spn_Fsm_State get_Spn_Fsm_State3 = READ_SPN_3GPP;
            Get_Spn_Fsm_State get_Spn_Fsm_State4 = READ_SPN_CPHS;
            Get_Spn_Fsm_State get_Spn_Fsm_State5 = READ_SPN_SHORT_CPHS;
            Get_Spn_Fsm_State[] get_Spn_Fsm_StateArray = new Get_Spn_Fsm_State[]{get_Spn_Fsm_State, get_Spn_Fsm_State2, get_Spn_Fsm_State3, get_Spn_Fsm_State4, get_Spn_Fsm_State5};
            $VALUES = get_Spn_Fsm_StateArray;
        }

        public static Get_Spn_Fsm_State valueOf(String string2) {
            return Enum.valueOf(Get_Spn_Fsm_State.class, string2);
        }

        public static Get_Spn_Fsm_State[] values() {
            return (Get_Spn_Fsm_State[])$VALUES.clone();
        }
    }
}

