/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.gsm.GSMPhone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimSmsInterfaceManager
extends IccSmsInterfaceManager {
    static final boolean DBG = true;
    private static final int EVENT_LOAD_DONE = 1;
    private static final int EVENT_UPDATE_DONE = 2;
    static final String LOG_TAG = "GSM";
    Handler mHandler;
    private final Object mLock;
    private List<SmsRawData> mSms;
    private boolean mSuccess;

    public SimSmsInterfaceManager(GSMPhone gSMPhone, SMSDispatcher sMSDispatcher) {
        super(gSMPhone);
        Handler handler;
        Object object;
        this.mLock = object = new Object();
        this.mHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 2: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = SimSmsInterfaceManager.this.mLock;
                        synchronized (object) {
                            SimSmsInterfaceManager simSmsInterfaceManager = SimSmsInterfaceManager.this;
                            boolean bl = asyncResult.exception == null;
                            boolean bl2 = SimSmsInterfaceManager.access$102(simSmsInterfaceManager, bl);
                            SimSmsInterfaceManager.this.mLock.notifyAll();
                            return;
                        }
                    }
                    case 1: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Object object = SimSmsInterfaceManager.this.mLock;
                synchronized (object) {
                    if (asyncResult.exception == null) {
                        SimSmsInterfaceManager simSmsInterfaceManager = SimSmsInterfaceManager.this;
                        SimSmsInterfaceManager simSmsInterfaceManager2 = SimSmsInterfaceManager.this;
                        ArrayList arrayList = (ArrayList)asyncResult.result;
                        ArrayList arrayList2 = simSmsInterfaceManager2.buildValidRawData(arrayList);
                        List list = SimSmsInterfaceManager.access$202(simSmsInterfaceManager, arrayList2);
                    } else {
                        SimSmsInterfaceManager.this.log("Cannot load Sms records");
                        if (SimSmsInterfaceManager.this.mSms != null) {
                            SimSmsInterfaceManager.this.mSms.clear();
                        }
                    }
                    SimSmsInterfaceManager.this.mLock.notifyAll();
                    return;
                }
            }
        };
        this.mDispatcher = sMSDispatcher;
    }

    static /* synthetic */ boolean access$102(SimSmsInterfaceManager simSmsInterfaceManager, boolean bl) {
        simSmsInterfaceManager.mSuccess = bl;
        return bl;
    }

    static /* synthetic */ List access$202(SimSmsInterfaceManager simSmsInterfaceManager, List list) {
        simSmsInterfaceManager.mSms = list;
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean copyMessageToIccEf(int n, byte[] byArray, byte[] byArray2) {
        StringBuilder stringBuilder = new StringBuilder().append("copyMessageToIccEf: status=").append(n).append(" ==> ").append("pdu=(");
        String string2 = Arrays.toString(byArray);
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("), smsm=(");
        String string3 = Arrays.toString(byArray2);
        String string4 = stringBuilder2.append(string3).append(")").toString();
        this.log(string4);
        this.enforceReceiveAndSend("Copying message to SIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message message = this.mHandler.obtainMessage(2);
            CommandsInterface commandsInterface = this.mPhone.mCM;
            String string5 = IccUtils.bytesToHexString(byArray2);
            String string6 = IccUtils.bytesToHexString(byArray);
            commandsInterface.writeSmsToSim(n, string5, string6, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to update by index");
            }
            return this.mSuccess;
        }
    }

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            int n = Log.e(LOG_TAG, "Error while finalizing:", throwable);
        }
        int n = Log.d(LOG_TAG, "SimSmsInterfaceManager finalized");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf() {
        this.log("getAllMessagesFromEF");
        this.mPhone.getContext().enforceCallingPermission("android.permission.RECEIVE_SMS", "Reading messages from SIM");
        Object object = this.mLock;
        synchronized (object) {
            Message message = this.mHandler.obtainMessage(1);
            this.mPhone.getIccFileHandler().loadEFLinearFixedAll(28476, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to load from the SIM");
            }
            return this.mSms;
        }
    }

    @Override
    protected void log(String string2) {
        String string3 = "[SimSmsInterfaceManager] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateMessageOnIccEf(int n, int n2, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder().append("updateMessageOnIccEf: index=").append(n).append(" status=").append(n2).append(" ==> ").append("(");
        String string2 = Arrays.toString(byArray);
        String string3 = stringBuilder.append(string2).append(")").toString();
        this.log(string3);
        this.enforceReceiveAndSend("Updating message on SIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message message = this.mHandler.obtainMessage(2);
            if (n2 == 0) {
                this.mPhone.mCM.deleteSmsOnSim(n, message);
            } else {
                byte[] byArray2 = this.makeSmsRecordData(n2, byArray);
                IccFileHandler iccFileHandler = this.mPhone.getIccFileHandler();
                int n3 = n;
                iccFileHandler.updateEFLinearFixed(28476, n3, byArray2, null, message);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to update by index");
            }
            return this.mSuccess;
        }
    }
}

