/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Parcel;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GsmSmsAddress;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class SmsMessage
extends SmsMessageBase {
    static final String LOG_TAG = "GSM";
    private boolean automaticDeletion;
    private int dataCodingScheme;
    private long dischargeTimeMillis;
    private boolean forSubmit;
    private boolean isStatusReportMessage = false;
    private SmsMessage.MessageClass messageClass;
    private int mti;
    private int protocolIdentifier;
    private GsmSmsAddress recipientAddress;
    private boolean replyPathPresent = false;
    private int status;

    /*
     * Unable to fully structure code
     */
    public static SmsMessageBase.TextEncodingDetails calculateLength(CharSequence var0, boolean var1_1) {
        var2_2 = new SmsMessageBase.TextEncodingDetails();
        if (var1_1) ** GOTO lbl15
        var3_3 = true;
        try lbl-1000:
        // 2 sources

        {
            block8: {
                while (true) {
                    var2_2.codeUnitCount = var4_4 = GsmAlphabet.countGsmSeptets(var0, var3_3);
                    if (var4_4 > 160) {
                        var2_2.msgCount = var5_5 = (var4_4 + 152) / 153;
                        var2_2.codeUnitsRemaining = var6_6 = var2_2.msgCount * 153 - var4_4;
lbl10:
                        // 2 sources

                        while (true) {
                            var2_2.codeUnitSize = 1;
lbl12:
                            // 2 sources

                            return var2_2;
                        }
                    }
                    break block8;
                    break;
                }
lbl15:
                // 1 sources

                var3_3 = false;
                ** continue;
            }
            var2_2.msgCount = 1;
            var2_2.codeUnitsRemaining = var7_7 = 160 - var4_4;
            ** continue;
        }
        catch (EncodeException var8_8) {
            var9_9 = var0.length() * 2;
            var2_2.codeUnitCount = var10_10 = var0.length();
            if (var9_9 > 140) {
                var2_2.msgCount = var11_11 = (var9_9 + 133) / 134;
                var2_2.codeUnitsRemaining = var12_12 = (var2_2.msgCount * 134 - var9_9) / 2;
lbl27:
                // 2 sources

                while (true) {
                    var2_2.codeUnitSize = 3;
                    ** continue;
                    break;
                }
            }
            var2_2.msgCount = 1;
            var2_2.codeUnitsRemaining = var13_13 = (140 - var9_9) / 2;
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        try {
            int n2;
            SmsMessage smsMessage = new SmsMessage();
            smsMessage.indexOnIcc = n;
            if ((byArray[0] & 1) == 0) {
                int n3 = Log.w(LOG_TAG, "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            smsMessage.statusOnIcc = n2 = byArray[0] & 7;
            int n4 = byArray.length - 1;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 1, byArray2, 0, n4);
            smsMessage.parsePdu(byArray2);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            int n5 = Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage createFromPdu(byte[] byArray) {
        try {
            SmsMessage smsMessage = new SmsMessage();
            smsMessage.parsePdu(byArray);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] encodeUCS2(String string2, byte[] byArray) throws UnsupportedEncodingException {
        byte by;
        byte[] byArray2;
        byte[] byArray3 = string2.getBytes("utf-16be");
        if (byArray != null) {
            byte by2;
            int n = byArray.length;
            int n2 = byArray3.length;
            byArray2 = new byte[n + n2 + 1];
            byArray2[0] = by2 = (byte)byArray.length;
            int n3 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 1, n3);
            int n4 = byArray.length + 1;
            int n5 = byArray3.length;
            System.arraycopy(byArray3, 0, byArray2, n4, n5);
        } else {
            byArray2 = byArray3;
        }
        byte[] byArray4 = new byte[byArray2.length + 1];
        byArray4[0] = by = (byte)(byArray2.length & 0xFF);
        int n = byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, 1, n);
        return byArray4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubmitPdu getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = n;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        int n2 = byArray.length;
        byte[] byArray2 = SmsHeader.toByteArray(smsHeader);
        int n3 = byArray2.length;
        if (n2 + n3 + 1 > 140) {
            StringBuilder stringBuilder = new StringBuilder().append("SMS data message may only contain ");
            int n4 = byArray2.length;
            int n5 = 140 - n4 - 1;
            String string4 = stringBuilder.append(n5).append(" bytes").toString();
            int n6 = Log.e(LOG_TAG, string4);
            return null;
        }
        SubmitPdu submitPdu = new SubmitPdu();
        ByteArrayOutputStream byteArrayOutputStream = SmsMessage.getSubmitPduHead(string2, string3, (byte)65, bl, submitPdu);
        byteArrayOutputStream.write(4);
        int n7 = byArray.length;
        int n8 = byArray2.length;
        int n9 = n7 + n8 + 1;
        byteArrayOutputStream.write(n9);
        int n10 = byArray2.length;
        byteArrayOutputStream.write(n10);
        int n11 = byArray2.length;
        byteArrayOutputStream.write(byArray2, 0, n11);
        int n12 = byArray.length;
        byteArrayOutputStream.write(byArray, 0, n12);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        submitPdu.encodedMessage = byArray3;
        return submitPdu;
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl) {
        return SmsMessage.getSubmitPdu(string2, string3, string4, bl, null);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, byte[] byArray) {
        String string5 = string2;
        String string6 = string3;
        String string7 = string4;
        boolean bl2 = bl;
        byte[] byArray2 = byArray;
        return SmsMessage.getSubmitPdu(string5, string6, string7, bl2, byArray2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SubmitPdu getSubmitPdu(String string2, String object, String string3, boolean bl, byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        SubmitPdu submitPdu;
        block15: {
            block11: {
                block14: {
                    block13: {
                        if (string3 == null) return null;
                        if (object == null) {
                            return null;
                        }
                        submitPdu = new SubmitPdu();
                        int n2 = byArray != null ? 64 : 0;
                        byte by = (byte)(n2 | 1);
                        byteArrayOutputStream = SmsMessage.getSubmitPduHead(string2, (String)object, by, bl, submitPdu);
                        if (n == 0) {
                            n = 1;
                        }
                        if (n != 1) break block13;
                        byte[] byArray2 = GsmAlphabet.stringToGsm7BitPackedWithHeader(string3, byArray);
                        object = byArray2;
                        break block14;
                    }
                    try {
                        byte[] byArray3;
                        try {
                            byArray3 = SmsMessage.encodeUCS2(string3, byArray);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            int n3 = Log.e(LOG_TAG, "Implausible UnsupportedEncodingException ", unsupportedEncodingException);
                            return null;
                        }
                        object = byArray3;
                    }
                    catch (EncodeException encodeException) {
                        byte[] byArray4;
                        try {
                            byArray4 = SmsMessage.encodeUCS2(string3, byArray);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            int n4 = Log.e(LOG_TAG, "Implausible UnsupportedEncodingException ", unsupportedEncodingException);
                            return null;
                        }
                        object = byArray4;
                        n = 3;
                    }
                }
                if (n != 1) break block11;
                if ((object[0] & 0xFF) > 160) {
                    return null;
                }
                byteArrayOutputStream.write(0);
                break block15;
            }
            if ((object[0] & 0xFF) > 140) {
                return null;
            }
            byteArrayOutputStream.write(11);
        }
        int n5 = ((Object)object).length;
        byteArrayOutputStream.write((byte[])object, 0, n5);
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        submitPdu.encodedMessage = byArray5;
        return submitPdu;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ByteArrayOutputStream getSubmitPduHead(String string2, String string3, byte by, boolean bl, SubmitPdu submitPdu) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(180);
        if (string2 == null) {
            submitPdu.encodedScAddress = null;
        } else {
            byte[] byArray = PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(string2);
            submitPdu.encodedScAddress = byArray;
        }
        if (bl) {
            by = (byte)(by | 0x20);
            int n = Log.d(LOG_TAG, "SMS status report requested");
        }
        byteArrayOutputStream.write(by);
        byteArrayOutputStream.write(0);
        byte[] byArray = PhoneNumberUtils.networkPortionToCalledPartyBCD(string3);
        int n = (byArray.length - 1) * 2;
        int n2 = byArray.length - 1;
        int n3 = (byArray[n2] & 0xF0) == 240 ? 1 : 0;
        int n4 = n - n3;
        byteArrayOutputStream.write(n4);
        int n5 = byArray.length;
        byteArrayOutputStream.write(byArray, 0, n5);
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream;
    }

    public static int getTPLayerLengthForPDU(String string2) {
        int n = string2.length() / 2;
        int n2 = Integer.parseInt(string2.substring(0, 2), 16);
        return n - n2 - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage newFromCDS(String string2) {
        try {
            SmsMessage smsMessage = new SmsMessage();
            byte[] byArray = IccUtils.hexStringToBytes(string2);
            smsMessage.parsePdu(byArray);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.e(LOG_TAG, "CDS SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage newFromCMT(String[] stringArray) {
        try {
            SmsMessage smsMessage = new SmsMessage();
            byte[] byArray = IccUtils.hexStringToBytes(stringArray[1]);
            smsMessage.parsePdu(byArray);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    public static SmsMessage newFromCMTI(String string2) {
        int n = Log.e(LOG_TAG, "newFromCMTI: not yet supported");
        return null;
    }

    public static SmsMessageBase newFromParcel(Parcel parcel) {
        int n = Log.w(LOG_TAG, "newFromParcel: is not supported in GSM mode.");
        return null;
    }

    private void parsePdu(byte[] byArray) {
        int n;
        String string2;
        this.mPdu = byArray;
        PduParser pduParser = new PduParser(byArray);
        this.scAddress = string2 = pduParser.getSCAddress();
        if (this.scAddress != null) {
            StringBuilder stringBuilder = new StringBuilder().append("SMS SC address: ");
            String string3 = this.scAddress;
            String string4 = stringBuilder.append(string3).toString();
            int n2 = Log.d(LOG_TAG, string4);
        }
        int n3 = pduParser.getByte();
        this.mti = n = n3 & 3;
        switch (this.mti) {
            default: {
                throw new RuntimeException("Unsupported message type");
            }
            case 0: {
                this.parseSmsDeliver(pduParser, n3);
                return;
            }
            case 2: 
        }
        this.parseSmsStatusReport(pduParser, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSmsDeliver(PduParser pduParser, int n) {
        long l;
        int n2;
        int n3;
        boolean bl = (n & 0x80) == 128;
        this.replyPathPresent = bl;
        GsmSmsAddress gsmSmsAddress = pduParser.getAddress();
        this.originatingAddress = gsmSmsAddress;
        if (this.originatingAddress != null) {
            // empty if block
        }
        this.protocolIdentifier = n3 = pduParser.getByte();
        this.dataCodingScheme = n2 = pduParser.getByte();
        this.scTimeMillis = l = pduParser.getSCTimestampMillis();
        StringBuilder stringBuilder = new StringBuilder().append("SMS SC timestamp: ");
        long l2 = this.scTimeMillis;
        String string2 = stringBuilder.append(l2).toString();
        int n4 = Log.d(LOG_TAG, string2);
        boolean bl2 = (n & 0x40) == 64;
        this.parseUserData(pduParser, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSmsStatusReport(PduParser pduParser, int n) {
        int n2;
        int n3;
        long l;
        long l2;
        GsmSmsAddress gsmSmsAddress;
        int n4;
        this.isStatusReportMessage = true;
        boolean bl = (n & 0x20) == 0;
        this.forSubmit = bl;
        this.messageRef = n4 = pduParser.getByte();
        this.recipientAddress = gsmSmsAddress = pduParser.getAddress();
        this.scTimeMillis = l2 = pduParser.getSCTimestampMillis();
        this.dischargeTimeMillis = l = pduParser.getSCTimestampMillis();
        this.status = n3 = pduParser.getByte();
        if (!pduParser.moreDataPresent()) {
            return;
        }
        int n5 = n2 = pduParser.getByte();
        while ((n5 & 0x80) != 0) {
            n5 = pduParser.getByte();
        }
        if ((n2 & 1) != 0) {
            int n6;
            this.protocolIdentifier = n6 = pduParser.getByte();
        }
        if ((n2 & 2) != 0) {
            int n7;
            this.dataCodingScheme = n7 = pduParser.getByte();
        }
        if ((n2 & 4) == 0) {
            return;
        }
        boolean bl2 = (n & 0x40) == 64;
        this.parseUserData(pduParser, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseUserData(PduParser pduParser, boolean bl) {
        SmsMessage.MessageClass messageClass;
        SmsHeader smsHeader;
        boolean bl2 = false;
        int n = 0;
        if ((this.dataCodingScheme & 0x80) == 0) {
            boolean bl3 = (this.dataCodingScheme & 0x40) != 0;
            this.automaticDeletion = bl3;
            boolean bl4 = (this.dataCodingScheme & 0x20) != 0;
            bl2 = (this.dataCodingScheme & 0x10) != 0;
            if (bl4) {
                StringBuilder stringBuilder = new StringBuilder().append("4 - Unsupported SMS data coding scheme (compression) ");
                int n2 = this.dataCodingScheme & 0xFF;
                String string2 = stringBuilder.append(n2).toString();
                int n3 = Log.w(LOG_TAG, string2);
            } else {
                switch (this.dataCodingScheme >> 2 & 3) {
                    default: {
                        break;
                    }
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        StringBuilder stringBuilder = new StringBuilder().append("1 - Unsupported SMS data coding scheme ");
                        int n4 = this.dataCodingScheme & 0xFF;
                        String string3 = stringBuilder.append(n4).toString();
                        int n5 = Log.w(LOG_TAG, string3);
                        n = 2;
                        break;
                    }
                }
            }
        } else if ((this.dataCodingScheme & 0xF0) == 240) {
            this.automaticDeletion = false;
            bl2 = true;
            n = (this.dataCodingScheme & 4) == 0 ? 1 : 2;
        } else if ((this.dataCodingScheme & 0xF0) == 192 || (this.dataCodingScheme & 0xF0) == 208 || (this.dataCodingScheme & 0xF0) == 224) {
            n = (this.dataCodingScheme & 0xF0) == 224 ? 3 : 1;
            boolean bl5 = (this.dataCodingScheme & 8) == 8;
            if ((this.dataCodingScheme & 3) == 0) {
                this.isMwi = true;
                this.mwiSense = bl5;
                boolean bl6 = (this.dataCodingScheme & 0xF0) == 192;
                this.mwiDontStore = bl6;
            } else {
                this.isMwi = false;
                StringBuilder stringBuilder = new StringBuilder().append("MWI for fax, email, or other ");
                int n6 = this.dataCodingScheme & 0xFF;
                String string4 = stringBuilder.append(n6).toString();
                int n7 = Log.w(LOG_TAG, string4);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("3 - Unsupported SMS data coding scheme ");
            int n8 = this.dataCodingScheme & 0xFF;
            String string5 = stringBuilder.append(n8).toString();
            int n9 = Log.w(LOG_TAG, string5);
        }
        boolean bl7 = n == 1;
        int n10 = pduParser.constructUserData(bl, bl7);
        byte[] byArray = pduParser.getUserData();
        this.userData = byArray;
        this.userDataHeader = smsHeader = pduParser.getUserDataHeader();
        switch (n) {
            case 0: 
            case 2: {
                this.messageBody = null;
                break;
            }
            case 1: {
                String string6;
                this.messageBody = string6 = pduParser.getUserDataGSM7Bit(n10);
                break;
            }
            case 3: {
                String string7;
                this.messageBody = string7 = pduParser.getUserDataUCS2(n10);
            }
        }
        if (this.messageBody != null) {
            this.parseMessageBody();
        }
        if (!bl2) {
            SmsMessage.MessageClass messageClass2;
            this.messageClass = messageClass2 = SmsMessage.MessageClass.UNKNOWN;
            return;
        }
        switch (this.dataCodingScheme & 3) {
            default: {
                return;
            }
            case 0: {
                SmsMessage.MessageClass messageClass3;
                this.messageClass = messageClass3 = SmsMessage.MessageClass.CLASS_0;
                return;
            }
            case 1: {
                SmsMessage.MessageClass messageClass4;
                this.messageClass = messageClass4 = SmsMessage.MessageClass.CLASS_1;
                return;
            }
            case 2: {
                SmsMessage.MessageClass messageClass5;
                this.messageClass = messageClass5 = SmsMessage.MessageClass.CLASS_2;
                return;
            }
            case 3: 
        }
        this.messageClass = messageClass = SmsMessage.MessageClass.CLASS_3;
    }

    @Override
    public SmsMessage.MessageClass getMessageClass() {
        return this.messageClass;
    }

    @Override
    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCphsMwiMessage() {
        if (((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageClear()) return true;
        if (!((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageSet()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMWIClearMessage() {
        if (this.isMwi && !this.mwiSense) {
            return true;
        }
        if (this.originatingAddress == null) return false;
        if (!((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageClear()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMWISetMessage() {
        if (this.isMwi && this.mwiSense) {
            return true;
        }
        if (this.originatingAddress == null) return false;
        if (!((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageSet()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMwiDontStore() {
        if (this.isMwi && this.mwiDontStore) {
            return true;
        }
        if (!this.isCphsMwiMessage()) return false;
        String string2 = this.getMessageBody();
        if (!" ".equals(string2)) return true;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isReplace() {
        if ((this.protocolIdentifier & 0xC0) != 64) return false;
        if ((this.protocolIdentifier & 0x3F) <= 0) return false;
        if ((this.protocolIdentifier & 0x3F) >= 8) return false;
        return true;
    }

    @Override
    public boolean isReplyPathPresent() {
        return this.replyPathPresent;
    }

    @Override
    public boolean isStatusReportMessage() {
        return this.isStatusReportMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTypeZero() {
        if (this.protocolIdentifier != 64) return false;
        return true;
    }

    static class PduParser {
        int cur;
        int mUserDataSeptetPadding;
        int mUserDataSize;
        byte[] pdu;
        byte[] userData;
        SmsHeader userDataHeader;

        PduParser(String string2) {
            byte[] byArray = IccUtils.hexStringToBytes(string2);
            this(byArray);
        }

        PduParser(byte[] byArray) {
            this.pdu = byArray;
            this.cur = 0;
            this.mUserDataSeptetPadding = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        int constructUserData(boolean bl, boolean bl2) {
            int n;
            int n2;
            int n3 = this.cur;
            byte[] byArray = this.pdu;
            int n4 = n3 + 1;
            int n5 = byArray[n3] & 0xFF;
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                int n8;
                SmsHeader smsHeader;
                byte[] byArray2 = this.pdu;
                int n9 = n4 + 1;
                n7 = byArray2[n4] & 0xFF;
                byte[] byArray3 = new byte[n7];
                System.arraycopy(this.pdu, n9, byArray3, 0, n7);
                this.userDataHeader = smsHeader = SmsHeader.fromByteArray(byArray3);
                n2 = n9 + n7;
                int n10 = (n7 + 1) * 8;
                int n11 = n10 / 7;
                int n12 = n10 % 7 > 0 ? 1 : 0;
                n6 = n11 + n12;
                this.mUserDataSeptetPadding = n8 = n6 * 7 - n10;
            } else {
                n2 = n4;
            }
            if (bl2) {
                n = this.pdu.length - n2;
            } else {
                int n13 = bl ? n7 + 1 : 0;
                n = n5 - n13;
                if (n < 0) {
                    n = 0;
                }
            }
            byte[] byArray4 = new byte[n];
            this.userData = byArray4;
            byte[] byArray5 = this.pdu;
            byte[] byArray6 = this.userData;
            int n14 = this.userData.length;
            System.arraycopy(byArray5, n2, byArray6, 0, n14);
            this.cur = n2;
            if (!bl2) {
                return this.userData.length;
            }
            int n15 = n5 - n6;
            if (n15 >= 0) return n15;
            return 0;
        }

        GsmSmsAddress getAddress() {
            int n;
            byte[] byArray = this.pdu;
            int n2 = this.cur;
            int n3 = ((byArray[n2] & 0xFF) + 1) / 2 + 2;
            byte[] byArray2 = this.pdu;
            int n4 = this.cur;
            GsmSmsAddress gsmSmsAddress = new GsmSmsAddress(byArray2, n4, n3);
            this.cur = n = this.cur + n3;
            return gsmSmsAddress;
        }

        int getByte() {
            int n;
            byte[] byArray = this.pdu;
            int n2 = this.cur;
            this.cur = n = n2 + 1;
            return byArray[n2] & 0xFF;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String getSCAddress() {
            int n;
            String string2;
            int n2 = this.getByte();
            if (n2 == 0) {
                string2 = null;
            } else {
                try {
                    String string3;
                    byte[] byArray = this.pdu;
                    int n3 = this.cur;
                    string2 = string3 = PhoneNumberUtils.calledPartyBCDToString(byArray, n3, n2);
                }
                catch (RuntimeException runtimeException) {
                    int n4 = Log.d(SmsMessage.LOG_TAG, "invalid SC address: ", runtimeException);
                    string2 = null;
                }
            }
            this.cur = n = this.cur + n2;
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        long getSCTimestampMillis() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            byte[] byArray = this.pdu;
            int n9 = this.cur;
            this.cur = n8 = n9 + 1;
            int n10 = IccUtils.gsmBcdByteToInt(byArray[n9]);
            byte[] byArray2 = this.pdu;
            int n11 = this.cur;
            this.cur = n7 = n11 + 1;
            int n12 = IccUtils.gsmBcdByteToInt(byArray2[n11]);
            byte[] byArray3 = this.pdu;
            int n13 = this.cur;
            this.cur = n6 = n13 + 1;
            int n14 = IccUtils.gsmBcdByteToInt(byArray3[n13]);
            byte[] byArray4 = this.pdu;
            int n15 = this.cur;
            this.cur = n5 = n15 + 1;
            int n16 = IccUtils.gsmBcdByteToInt(byArray4[n15]);
            byte[] byArray5 = this.pdu;
            int n17 = this.cur;
            this.cur = n4 = n17 + 1;
            int n18 = IccUtils.gsmBcdByteToInt(byArray5[n17]);
            byte[] byArray6 = this.pdu;
            int n19 = this.cur;
            this.cur = n3 = n19 + 1;
            int n20 = IccUtils.gsmBcdByteToInt(byArray6[n19]);
            byte[] byArray7 = this.pdu;
            int n21 = this.cur;
            this.cur = n2 = n21 + 1;
            byte by = byArray7[n21];
            int n22 = IccUtils.gsmBcdByteToInt((byte)(by & 0xFFFFFFF7));
            if ((by & 8) != 0) {
                n22 = -n22;
            }
            Time time = new Time("UTC");
            int n23 = n10 >= 90 ? n10 + 1900 : n10 + 2000;
            time.year = n23;
            time.month = n = n12 - 1;
            time.monthDay = n14;
            time.hour = n16;
            time.minute = n18;
            time.second = n20;
            long l = time.toMillis(true);
            long l2 = n22 * 15 * 60 * 1000;
            return l - l2;
        }

        byte[] getUserData() {
            return this.userData;
        }

        String getUserDataGSM7Bit(int n) {
            int n2;
            byte[] byArray = this.pdu;
            int n3 = this.cur;
            int n4 = this.mUserDataSeptetPadding;
            String string2 = GsmAlphabet.gsm7BitPackedToString(byArray, n3, n, n4);
            int n5 = this.cur;
            int n6 = n * 7 / 8;
            this.cur = n2 = n5 + n6;
            return string2;
        }

        SmsHeader getUserDataHeader() {
            return this.userDataHeader;
        }

        int getUserDataSeptetPadding() {
            return this.mUserDataSeptetPadding;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String getUserDataUCS2(int n) {
            int n2;
            String string2;
            try {
                byte[] byArray = this.pdu;
                int n3 = this.cur;
                string2 = new String(byArray, n3, n, "utf-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = "";
                int n4 = Log.e(SmsMessage.LOG_TAG, "implausible UnsupportedEncodingException", unsupportedEncodingException);
            }
            this.cur = n2 = this.cur + n;
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean moreDataPresent() {
            int n = this.pdu.length;
            int n2 = this.cur;
            if (n <= n2) return false;
            return true;
        }
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase {
    }
}

