/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.SimTlv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UsimPhoneBookManager
extends Handler
implements IccConstants {
    private static final boolean DBG = true;
    private static final int EVENT_EMAIL_LOAD_DONE = 4;
    private static final int EVENT_IAP_LOAD_DONE = 3;
    private static final int EVENT_PBR_LOAD_DONE = 1;
    private static final int EVENT_USIM_ADN_LOAD_DONE = 2;
    private static final String LOG_TAG = "GSM";
    private static final int USIM_EFAAS_TAG = 199;
    private static final int USIM_EFADN_TAG = 192;
    private static final int USIM_EFANR_TAG = 196;
    private static final int USIM_EFCCP1_TAG = 203;
    private static final int USIM_EFEMAIL_TAG = 202;
    private static final int USIM_EFEXT1_TAG = 194;
    private static final int USIM_EFGRP_TAG = 198;
    private static final int USIM_EFGSD_TAG = 200;
    private static final int USIM_EFIAP_TAG = 193;
    private static final int USIM_EFPBC_TAG = 197;
    private static final int USIM_EFSNE_TAG = 195;
    private static final int USIM_EFUID_TAG = 201;
    private static final int USIM_TYPE1_TAG = 168;
    private static final int USIM_TYPE2_TAG = 169;
    private static final int USIM_TYPE3_TAG = 170;
    private AdnRecordCache mAdnCache;
    private ArrayList<byte[]> mEmailFileRecord;
    private boolean mEmailPresentInIap;
    private int mEmailTagNumberInIap;
    private Map<Integer, ArrayList<String>> mEmailsForAdnRec;
    private ArrayList<byte[]> mIapFileRecord;
    private Boolean mIsPbrPresent;
    private Object mLock;
    private PbrFile mPbrFile;
    private PhoneBase mPhone;
    private ArrayList<AdnRecord> mPhoneBookRecords;

    public UsimPhoneBookManager(PhoneBase phoneBase, AdnRecordCache adnRecordCache) {
        Boolean bl;
        Object object;
        this.mLock = object = new Object();
        this.mEmailPresentInIap = false;
        this.mEmailTagNumberInIap = 0;
        this.mPhone = phoneBase;
        ArrayList arrayList = new ArrayList();
        this.mPhoneBookRecords = arrayList;
        this.mPbrFile = null;
        this.mIsPbrPresent = bl = Boolean.valueOf(true);
        this.mAdnCache = adnRecordCache;
    }

    static /* synthetic */ boolean access$002(UsimPhoneBookManager usimPhoneBookManager, boolean bl) {
        usimPhoneBookManager.mEmailPresentInIap = bl;
        return bl;
    }

    static /* synthetic */ int access$102(UsimPhoneBookManager usimPhoneBookManager, int n) {
        usimPhoneBookManager.mEmailTagNumberInIap = n;
        return n;
    }

    private void createPbrFile(ArrayList<byte[]> arrayList) {
        PbrFile pbrFile;
        if (arrayList == null) {
            Boolean bl;
            this.mPbrFile = null;
            this.mIsPbrPresent = bl = Boolean.valueOf(false);
            return;
        }
        this.mPbrFile = pbrFile = new PbrFile(arrayList);
    }

    private void log(String string2) {
        int n = Log.d(LOG_TAG, string2);
    }

    private void readAdnFileAndWait(int n) {
        HashMap<Integer, Map<Integer, Integer>> hashMap = this.mPbrFile.mFileIds;
        Integer n2 = n;
        Map<Integer, Integer> map = hashMap.get(n2);
        if (map == null) {
            return;
        }
        if (map.isEmpty()) {
            return;
        }
        AdnRecordCache adnRecordCache = this.mAdnCache;
        Integer n3 = 192;
        int n4 = map.get(n3);
        Integer n5 = 194;
        int n6 = map.get(n5);
        Message message = this.obtainMessage(2);
        adnRecordCache.requestLoadAllAdnLike(n4, n6, message);
        try {
            this.mLock.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            int n7 = Log.e(LOG_TAG, "Interrupted Exception in readAdnFileAndWait");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readEmailFileAndWait(int n) {
        HashMap<Integer, Map<Integer, Integer>> hashMap = this.mPbrFile.mFileIds;
        Integer n2 = n;
        Map<Integer, Integer> map = hashMap.get(n2);
        if (map == null) {
            return;
        }
        Integer n3 = 202;
        if (!map.containsKey(n3)) {
            return;
        }
        Integer n4 = 202;
        int n5 = map.get(n4);
        if (this.mEmailPresentInIap) {
            Integer n6 = 193;
            int n7 = map.get(n6);
            this.readIapFileAndWait(n7);
            if (this.mIapFileRecord == null) {
                int n8 = Log.e(LOG_TAG, "Error: IAP file is empty");
                return;
            }
        }
        IccFileHandler iccFileHandler = this.mPhone.getIccFileHandler();
        Integer n9 = 202;
        int n10 = map.get(n9);
        Message message = this.obtainMessage(4);
        iccFileHandler.loadEFLinearFixedAll(n10, message);
        try {
            this.mLock.wait();
        }
        catch (InterruptedException interruptedException) {
            int n11 = Log.e(LOG_TAG, "Interrupted Exception in readEmailFileAndWait");
        }
        if (this.mEmailFileRecord == null) {
            int n12 = Log.e(LOG_TAG, "Error: Email file is empty");
            return;
        }
        this.updatePhoneAdnRecord();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readEmailRecord(int n) {
        byte[] byArray;
        try {
            byArray = this.mEmailFileRecord.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        int n2 = byArray.length - 2;
        return IccUtils.adnStringFieldToString(byArray, 0, n2);
    }

    private void readIapFileAndWait(int n) {
        IccFileHandler iccFileHandler = this.mPhone.getIccFileHandler();
        Message message = this.obtainMessage(3);
        iccFileHandler.loadEFLinearFixedAll(n, message);
        try {
            this.mLock.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            int n2 = Log.e(LOG_TAG, "Interrupted Exception in readIapFileAndWait");
            return;
        }
    }

    private void readPbrFileAndWait() {
        IccFileHandler iccFileHandler = this.mPhone.getIccFileHandler();
        Message message = this.obtainMessage(1);
        iccFileHandler.loadEFLinearFixedAll(20272, message);
        try {
            this.mLock.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            int n = Log.e(LOG_TAG, "Interrupted Exception in readAdnFileAndWait");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePhoneAdnRecord() {
        if (this.mEmailFileRecord == null) {
            return;
        }
        int n = this.mPhoneBookRecords.size();
        if (this.mIapFileRecord != null) {
            for (int i = 0; i < n; ++i) {
                String string2;
                int n2;
                byte[] byArray;
                try {
                    byArray = this.mIapFileRecord.get(i);
                    n2 = this.mEmailTagNumberInIap;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    int n3 = Log.e(LOG_TAG, "Error: Improper ICC card: No IAP record for ADN, continuing");
                    break;
                }
                byte by = byArray[n2];
                if (by == -1) continue;
                String[] stringArray = new String[1];
                int n4 = by - 1;
                stringArray[0] = string2 = this.readEmailRecord(n4);
                AdnRecord adnRecord = this.mPhoneBookRecords.get(i);
                if (adnRecord != null) {
                    adnRecord.setEmails(stringArray);
                } else {
                    adnRecord = new AdnRecord("", "", stringArray);
                }
                AdnRecord adnRecord2 = this.mPhoneBookRecords.set(i, adnRecord);
                continue;
            }
        }
        int n5 = this.mPhoneBookRecords.size();
        if (this.mEmailsForAdnRec == null) {
            this.parseType1EmailFile(n5);
        }
        int n6 = 0;
        while (true) {
            block13: {
                ArrayList<String> arrayList;
                block12: {
                    if (n6 >= n) {
                        return;
                    }
                    try {
                        Map<Integer, ArrayList<String>> map = this.mEmailsForAdnRec;
                        Integer n7 = n6;
                        arrayList = map.get(n7);
                        if (arrayList != null) break block12;
                        break block13;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        return;
                    }
                }
                AdnRecord adnRecord = this.mPhoneBookRecords.get(n6);
                String[] stringArray = new String[arrayList.size()];
                Object[] objectArray = arrayList.toArray();
                int n8 = arrayList.size();
                System.arraycopy(objectArray, 0, stringArray, 0, n8);
                adnRecord.setEmails(stringArray);
                AdnRecord adnRecord3 = this.mPhoneBookRecords.set(n6, adnRecord);
            }
            ++n6;
        }
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    ArrayList arrayList = (ArrayList)asyncResult.result;
                    this.createPbrFile(arrayList);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    return;
                }
            }
            case 2: {
                this.log("Loading USIM ADN records done");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    ArrayList<AdnRecord> arrayList = this.mPhoneBookRecords;
                    ArrayList arrayList2 = (ArrayList)asyncResult.result;
                    boolean bl = arrayList.addAll(arrayList2);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    return;
                }
            }
            case 3: {
                this.log("Loading USIM IAP records done");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    ArrayList arrayList;
                    this.mIapFileRecord = arrayList = (ArrayList)asyncResult.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    return;
                }
            }
            case 4: 
        }
        this.log("Loading USIM Email records done");
        AsyncResult asyncResult = (AsyncResult)message.obj;
        if (asyncResult.exception == null) {
            ArrayList arrayList;
            this.mEmailFileRecord = arrayList = (ArrayList)asyncResult.result;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<AdnRecord> loadEfFilesFromUsim() {
        ArrayList<AdnRecord> arrayList = this.mLock;
        synchronized (arrayList) {
            if (!this.mPhoneBookRecords.isEmpty()) {
                ArrayList<AdnRecord> arrayList2 = this.mPhoneBookRecords;
                return arrayList2;
            }
            if (!this.mIsPbrPresent.booleanValue()) {
                return null;
            }
            if (this.mPbrFile == null) {
                this.readPbrFileAndWait();
            }
            if (this.mPbrFile == null) {
                return null;
            }
            int n = this.mPbrFile.mFileIds.size();
            int n2 = 0;
            while (n2 < n) {
                this.readAdnFileAndWait(n2);
                this.readEmailFileAndWait(n2);
                ++n2;
            }
            return this.mPhoneBookRecords;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseType1EmailFile(int n) {
        HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
        this.mEmailsForAdnRec = hashMap;
        int n2 = 0;
        while (true) {
            block7: {
                byte by;
                block6: {
                    byte[] byArray;
                    if (n2 >= n) {
                        return;
                    }
                    try {
                        byArray = this.mEmailFileRecord.get(n2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        int n3 = Log.e(LOG_TAG, "Error: Improper ICC card: No email record for ADN, continuing");
                        return;
                    }
                    int n4 = byArray.length - 1;
                    by = byArray[n4];
                    if (by != -1) break block6;
                    break block7;
                }
                String string2 = this.readEmailRecord(n2);
                if (string2 != null && !string2.equals("")) {
                    void var12_10;
                    Map<Integer, ArrayList<String>> map = this.mEmailsForAdnRec;
                    Integer n5 = by - 1;
                    ArrayList<String> arrayList = map.get(n5);
                    if (arrayList == null) {
                        ArrayList arrayList2 = new ArrayList();
                    }
                    boolean bl = var12_10.add(string2);
                    Map<Integer, ArrayList<String>> map2 = this.mEmailsForAdnRec;
                    Integer n6 = by - 1;
                    ArrayList<String> arrayList3 = map2.put(n6, (ArrayList<String>)var12_10);
                }
            }
            ++n2;
        }
    }

    public void reset() {
        Boolean bl;
        this.mPhoneBookRecords.clear();
        this.mIapFileRecord = null;
        this.mEmailFileRecord = null;
        this.mPbrFile = null;
        this.mIsPbrPresent = bl = Boolean.valueOf(true);
    }

    private class PbrFile {
        HashMap<Integer, Map<Integer, Integer>> mFileIds;

        PbrFile(ArrayList<byte[]> arrayList) {
            HashMap hashMap = new HashMap();
            this.mFileIds = hashMap;
            int n = 0;
            Iterator<byte[]> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = iterator.next();
                int n2 = byArray.length;
                SimTlv simTlv = new SimTlv(byArray, 0, n2);
                this.parseTag(simTlv, n);
                ++n;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        void parseEf(SimTlv simTlv, Map<Integer, Integer> map, int n) {
            int n2 = 0;
            do {
                int n3 = simTlv.getTag();
                if (n == 169 && n3 == 202) {
                    boolean bl = UsimPhoneBookManager.access$002(UsimPhoneBookManager.this, true);
                    int n4 = UsimPhoneBookManager.access$102(UsimPhoneBookManager.this, n2);
                }
                switch (n3) {
                    default: {
                        break;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: {
                        byte[] byArray = simTlv.getData();
                        int n5 = (byArray[0] & 0xFF) << 8;
                        int n6 = byArray[1] & 0xFF;
                        int n7 = n5 | n6;
                        Integer n8 = n3;
                        Integer n9 = n7;
                        Integer n10 = map.put(n8, n9);
                    }
                }
                ++n2;
            } while (simTlv.nextObject());
        }

        /*
         * Enabled aggressive block sorting
         */
        void parseTag(SimTlv simTlv, int n) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            do {
                int n2 = simTlv.getTag();
                switch (n2) {
                    default: {
                        break;
                    }
                    case 168: 
                    case 169: 
                    case 170: {
                        byte[] byArray = simTlv.getData();
                        int n3 = byArray.length;
                        SimTlv simTlv2 = new SimTlv(byArray, 0, n3);
                        this.parseEf(simTlv2, hashMap, n2);
                    }
                }
            } while (simTlv.nextObject());
            HashMap<Integer, Map<Integer, Integer>> hashMap2 = this.mFileIds;
            Integer n4 = n;
            HashMap hashMap3 = hashMap2.put(n4, hashMap);
        }
    }
}

