/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.stk.BerTlv;
import com.android.internal.telephony.gsm.stk.CallSetupParams;
import com.android.internal.telephony.gsm.stk.CommandDetails;
import com.android.internal.telephony.gsm.stk.CommandParams;
import com.android.internal.telephony.gsm.stk.ComprehensionTlv;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.DisplayTextParams;
import com.android.internal.telephony.gsm.stk.Duration;
import com.android.internal.telephony.gsm.stk.GetInputParams;
import com.android.internal.telephony.gsm.stk.IconId;
import com.android.internal.telephony.gsm.stk.IconLoader;
import com.android.internal.telephony.gsm.stk.Input;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.ItemsIconId;
import com.android.internal.telephony.gsm.stk.LaunchBrowserMode;
import com.android.internal.telephony.gsm.stk.LaunchBrowserParams;
import com.android.internal.telephony.gsm.stk.Menu;
import com.android.internal.telephony.gsm.stk.PlayToneParams;
import com.android.internal.telephony.gsm.stk.PresentationType;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.ResultException;
import com.android.internal.telephony.gsm.stk.RilMessageDecoder;
import com.android.internal.telephony.gsm.stk.SelectItemParams;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.telephony.gsm.stk.TextMessage;
import com.android.internal.telephony.gsm.stk.Tone;
import com.android.internal.telephony.gsm.stk.ValueParser;
import java.util.Iterator;
import java.util.List;

class CommandParamsFactory
extends Handler {
    static final int LOAD_MULTI_ICONS = 2;
    static final int LOAD_NO_ICON = 0;
    static final int LOAD_SINGLE_ICON = 1;
    static final int MSG_ID_LOAD_ICON_DONE = 1;
    static final int REFRESH_NAA_INIT = 3;
    static final int REFRESH_NAA_INIT_AND_FILE_CHANGE = 2;
    static final int REFRESH_NAA_INIT_AND_FULL_FILE_CHANGE = 0;
    static final int REFRESH_UICC_RESET = 4;
    private static CommandParamsFactory sInstance = null;
    private RilMessageDecoder mCaller = null;
    private CommandParams mCmdParams = null;
    private int mIconLoadState = 0;
    private IconLoader mIconLoader;

    private CommandParamsFactory(RilMessageDecoder rilMessageDecoder, SIMFileHandler sIMFileHandler) {
        IconLoader iconLoader;
        this.mCaller = rilMessageDecoder;
        this.mIconLoader = iconLoader = IconLoader.getInstance(this, sIMFileHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CommandParamsFactory getInstance(RilMessageDecoder rilMessageDecoder, SIMFileHandler sIMFileHandler) {
        synchronized (CommandParamsFactory.class) {
            block6: {
                if (sInstance == null) break block6;
                return sInstance;
            }
            if (sIMFileHandler == null) return null;
            CommandParamsFactory commandParamsFactory = new CommandParamsFactory(rilMessageDecoder, sIMFileHandler);
            return commandParamsFactory;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommandDetails processCommandDetails(List<ComprehensionTlv> list) {
        CommandDetails commandDetails = null;
        if (list == null) return commandDetails;
        ComprehensionTlvTag comprehensionTlvTag = ComprehensionTlvTag.COMMAND_DETAILS;
        ComprehensionTlv comprehensionTlv = this.searchForTag(comprehensionTlvTag, list);
        if (comprehensionTlv == null) return commandDetails;
        try {
            CommandDetails commandDetails2 = ValueParser.retrieveCommandDetails(comprehensionTlv);
            return commandDetails2;
        }
        catch (ResultException resultException) {
            StkLog.d(this, "Failed to procees command details");
            return commandDetails;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processDisplayText(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlvTag comprehensionTlvTag;
        ComprehensionTlv comprehensionTlv;
        ComprehensionTlvTag comprehensionTlvTag2;
        ComprehensionTlv comprehensionTlv2;
        StkLog.d(this, "process DisplayText");
        TextMessage textMessage = new TextMessage();
        IconId iconId = null;
        ComprehensionTlvTag comprehensionTlvTag3 = ComprehensionTlvTag.TEXT_STRING;
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(comprehensionTlvTag3, list);
        if (comprehensionTlv3 != null) {
            String string2;
            textMessage.text = string2 = ValueParser.retrieveTextString(comprehensionTlv3);
        }
        if (textMessage.text == null) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
        ComprehensionTlvTag comprehensionTlvTag4 = ComprehensionTlvTag.IMMEDIATE_RESPONSE;
        if (this.searchForTag(comprehensionTlvTag4, list) != null) {
            textMessage.responseNeeded = false;
        }
        if ((comprehensionTlv2 = this.searchForTag(comprehensionTlvTag2 = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl;
            iconId = ValueParser.retrieveIconId(comprehensionTlv2);
            textMessage.iconSelfExplanatory = bl = iconId.selfExplanatory;
        }
        if ((comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.DURATION, list)) != null) {
            Duration duration;
            textMessage.duration = duration = ValueParser.retrieveDuration(comprehensionTlv);
        }
        boolean bl = (commandDetails.commandQualifier & 1) != 0;
        textMessage.isHighPriority = bl;
        boolean bl2 = (commandDetails.commandQualifier & 0x80) != 0;
        textMessage.userClear = bl2;
        DisplayTextParams displayTextParams = new DisplayTextParams(commandDetails, textMessage);
        this.mCmdParams = displayTextParams;
        if (iconId == null) return false;
        this.mIconLoadState = 1;
        IconLoader iconLoader = this.mIconLoader;
        int n = iconId.recordNumber;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcon(n, message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processEventNotify(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        StkLog.d(this, "process EventNotify");
        TextMessage textMessage = new TextMessage();
        IconId iconId = null;
        ComprehensionTlvTag comprehensionTlvTag = ComprehensionTlvTag.ALPHA_ID;
        ComprehensionTlv comprehensionTlv = this.searchForTag(comprehensionTlvTag, list);
        if (comprehensionTlv != null) {
            String string2;
            textMessage.text = string2 = ValueParser.retrieveAlphaId(comprehensionTlv);
            ComprehensionTlvTag comprehensionTlvTag2 = ComprehensionTlvTag.ICON_ID;
            ComprehensionTlv comprehensionTlv2 = this.searchForTag(comprehensionTlvTag2, list);
            if (comprehensionTlv2 != null) {
                boolean bl;
                iconId = ValueParser.retrieveIconId(comprehensionTlv2);
                textMessage.iconSelfExplanatory = bl = iconId.selfExplanatory;
            }
            textMessage.responseNeeded = false;
            DisplayTextParams displayTextParams = new DisplayTextParams(commandDetails, textMessage);
            this.mCmdParams = displayTextParams;
            if (iconId == null) return false;
            this.mIconLoadState = 1;
            IconLoader iconLoader = this.mIconLoader;
            int n = iconId.recordNumber;
            Message message = this.obtainMessage(1);
            iconLoader.loadIcon(n, message);
            return true;
        }
        ResultCode resultCode = ResultCode.REQUIRED_VALUES_MISSING;
        throw new ResultException(resultCode);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processGetInkey(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        String string2;
        StkLog.d(this, "process GetInkey");
        Input input = new Input();
        IconId iconId = null;
        ComprehensionTlvTag comprehensionTlvTag = ComprehensionTlvTag.TEXT_STRING;
        ComprehensionTlv comprehensionTlv = this.searchForTag(comprehensionTlvTag, list);
        if (comprehensionTlv == null) {
            ResultCode resultCode = ResultCode.REQUIRED_VALUES_MISSING;
            throw new ResultException(resultCode);
        }
        input.text = string2 = ValueParser.retrieveTextString(comprehensionTlv);
        ComprehensionTlvTag comprehensionTlvTag2 = ComprehensionTlvTag.ICON_ID;
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(comprehensionTlvTag2, list);
        if (comprehensionTlv2 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv2);
        }
        input.minLen = 1;
        input.maxLen = 1;
        boolean bl = (commandDetails.commandQualifier & 1) == 0;
        input.digitOnly = bl;
        boolean bl2 = (commandDetails.commandQualifier & 2) != 0;
        input.ucs2 = bl2;
        boolean bl3 = (commandDetails.commandQualifier & 4) != 0;
        input.yesNo = bl3;
        boolean bl4 = (commandDetails.commandQualifier & 0x80) != 0;
        input.helpAvailable = bl4;
        GetInputParams getInputParams = new GetInputParams(commandDetails, input);
        this.mCmdParams = getInputParams;
        if (iconId == null) return false;
        this.mIconLoadState = 1;
        IconLoader iconLoader = this.mIconLoader;
        int n = iconId.recordNumber;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcon(n, message);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processGetInput(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlvTag comprehensionTlvTag;
        ComprehensionTlv comprehensionTlv;
        ComprehensionTlvTag comprehensionTlvTag2;
        String string2;
        StkLog.d(this, "process GetInput");
        Input input = new Input();
        IconId iconId = null;
        ComprehensionTlvTag comprehensionTlvTag3 = ComprehensionTlvTag.TEXT_STRING;
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(comprehensionTlvTag3, list);
        if (comprehensionTlv2 == null) {
            ResultCode resultCode = ResultCode.REQUIRED_VALUES_MISSING;
            throw new ResultException(resultCode);
        }
        input.text = string2 = ValueParser.retrieveTextString(comprehensionTlv2);
        ComprehensionTlvTag comprehensionTlvTag4 = ComprehensionTlvTag.RESPONSE_LENGTH;
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(comprehensionTlvTag4, list);
        if (comprehensionTlv3 == null) {
            ResultCode resultCode = ResultCode.REQUIRED_VALUES_MISSING;
            throw new ResultException(resultCode);
        }
        try {
            int n;
            int n2;
            byte[] byArray = comprehensionTlv3.getRawValue();
            int n3 = comprehensionTlv3.getValueIndex();
            input.minLen = n2 = byArray[n3] & 0xFF;
            int n4 = n3 + 1;
            input.maxLen = n = byArray[n4] & 0xFF;
            comprehensionTlvTag2 = ComprehensionTlvTag.DEFAULT_TEXT;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(comprehensionTlvTag2, list);
        if (comprehensionTlv4 != null) {
            String string3;
            input.defaultText = string3 = ValueParser.retrieveTextString(comprehensionTlv4);
        }
        if ((comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.ICON_ID, list)) != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv);
        }
        boolean bl = (commandDetails.commandQualifier & 1) == 0;
        input.digitOnly = bl;
        boolean bl2 = (commandDetails.commandQualifier & 2) != 0;
        input.ucs2 = bl2;
        boolean bl3 = (commandDetails.commandQualifier & 4) == 0;
        input.echo = bl3;
        boolean bl4 = (commandDetails.commandQualifier & 8) != 0;
        input.packed = bl4;
        boolean bl5 = (commandDetails.commandQualifier & 0x80) != 0;
        input.helpAvailable = bl5;
        GetInputParams getInputParams = new GetInputParams(commandDetails, input);
        this.mCmdParams = getInputParams;
        if (iconId == null) return false;
        this.mIconLoadState = 1;
        IconLoader iconLoader = this.mIconLoader;
        int n = iconId.recordNumber;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcon(n, message);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processLaunchBrowser(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        LaunchBrowserMode launchBrowserMode;
        ComprehensionTlvTag comprehensionTlvTag;
        ComprehensionTlv comprehensionTlv;
        ComprehensionTlvTag comprehensionTlvTag2;
        ComprehensionTlv comprehensionTlv2;
        StkLog.d(this, "process LaunchBrowser");
        TextMessage textMessage = new TextMessage();
        IconId iconId = null;
        String string2 = null;
        ComprehensionTlvTag comprehensionTlvTag3 = ComprehensionTlvTag.URL;
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(comprehensionTlvTag3, list);
        if (comprehensionTlv3 != null) {
            String string3;
            byte[] byArray = comprehensionTlv3.getRawValue();
            int n = comprehensionTlv3.getValueIndex();
            int n2 = comprehensionTlv3.getLength();
            string2 = n2 > 0 ? (string3 = GsmAlphabet.gsm8BitUnpackedToString(byArray, n, n2)) : null;
        }
        if ((comprehensionTlv2 = this.searchForTag(comprehensionTlvTag2 = ComprehensionTlvTag.ALPHA_ID, list)) != null) {
            String string4;
            textMessage.text = string4 = ValueParser.retrieveAlphaId(comprehensionTlv2);
        }
        if ((comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl;
            iconId = ValueParser.retrieveIconId(comprehensionTlv);
            textMessage.iconSelfExplanatory = bl = iconId.selfExplanatory;
        }
        switch (commandDetails.commandQualifier) {
            default: {
                launchBrowserMode = LaunchBrowserMode.LAUNCH_IF_NOT_ALREADY_LAUNCHED;
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
                throw new ResultException(resultCode);
            }
            case 2: {
                launchBrowserMode = LaunchBrowserMode.USE_EXISTING_BROWSER;
                break;
            }
            case 3: {
                launchBrowserMode = LaunchBrowserMode.LAUNCH_NEW_BROWSER;
            }
        }
        LaunchBrowserParams launchBrowserParams = new LaunchBrowserParams(commandDetails, textMessage, string2, launchBrowserMode);
        this.mCmdParams = launchBrowserParams;
        if (iconId == null) return false;
        this.mIconLoadState = 1;
        IconLoader iconLoader = this.mIconLoader;
        int n = iconId.recordNumber;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcon(n, message);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processPlayTone(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlvTag comprehensionTlvTag;
        ComprehensionTlv comprehensionTlv;
        ComprehensionTlvTag comprehensionTlvTag2;
        ComprehensionTlv comprehensionTlv2;
        ComprehensionTlvTag comprehensionTlvTag3;
        ComprehensionTlv comprehensionTlv3;
        StkLog.d(this, "process PlayTone");
        Tone tone = null;
        TextMessage textMessage = new TextMessage();
        Duration duration = null;
        IconId iconId = null;
        ComprehensionTlvTag comprehensionTlvTag4 = ComprehensionTlvTag.TONE;
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(comprehensionTlvTag4, list);
        if (comprehensionTlv4 != null && comprehensionTlv4.getLength() > 0) {
            try {
                Tone tone2;
                byte[] byArray = comprehensionTlv4.getRawValue();
                int n = comprehensionTlv4.getValueIndex();
                tone = tone2 = Tone.fromInt(byArray[n]);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
                throw new ResultException(resultCode);
            }
        }
        if ((comprehensionTlv3 = this.searchForTag(comprehensionTlvTag3 = ComprehensionTlvTag.ALPHA_ID, list)) != null) {
            String string2;
            textMessage.text = string2 = ValueParser.retrieveAlphaId(comprehensionTlv3);
        }
        if ((comprehensionTlv2 = this.searchForTag(comprehensionTlvTag2 = ComprehensionTlvTag.DURATION, list)) != null) {
            duration = ValueParser.retrieveDuration(comprehensionTlv2);
        }
        if ((comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl;
            iconId = ValueParser.retrieveIconId(comprehensionTlv);
            textMessage.iconSelfExplanatory = bl = iconId.selfExplanatory;
        }
        boolean bl = (commandDetails.commandQualifier & 1) != 0;
        textMessage.responseNeeded = false;
        CommandDetails commandDetails2 = commandDetails;
        PlayToneParams playToneParams = new PlayToneParams(commandDetails2, textMessage, tone, duration, bl);
        this.mCmdParams = playToneParams;
        if (iconId == null) return false;
        this.mIconLoadState = 1;
        IconLoader iconLoader = this.mIconLoader;
        int n = iconId.recordNumber;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcon(n, message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processRefresh(CommandDetails commandDetails, List<ComprehensionTlv> list) {
        StkLog.d(this, "process Refresh");
        switch (commandDetails.commandQualifier) {
            default: {
                return false;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
        }
        DisplayTextParams displayTextParams = new DisplayTextParams(commandDetails, null);
        this.mCmdParams = displayTextParams;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processSelectItem(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        boolean bl;
        ComprehensionTlvTag comprehensionTlvTag;
        ComprehensionTlv comprehensionTlv;
        ComprehensionTlvTag comprehensionTlvTag2;
        ComprehensionTlv comprehensionTlv2;
        ComprehensionTlvTag comprehensionTlvTag3;
        StkLog.d(this, "process SelectItem");
        Menu menu = new Menu();
        IconId iconId = null;
        ItemsIconId itemsIconId = null;
        Iterator<ComprehensionTlv> iterator = list.iterator();
        ComprehensionTlvTag comprehensionTlvTag4 = ComprehensionTlvTag.ALPHA_ID;
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(comprehensionTlvTag4, list);
        if (comprehensionTlv3 != null) {
            String string2;
            menu.title = string2 = ValueParser.retrieveAlphaId(comprehensionTlv3);
        }
        while ((comprehensionTlv3 = this.searchForNextTag(comprehensionTlvTag3 = ComprehensionTlvTag.ITEM, iterator)) != null) {
            List<Item> list2 = menu.items;
            Item item = ValueParser.retrieveItem(comprehensionTlv3);
            boolean bl2 = list2.add(item);
        }
        if (menu.items.size() == 0) {
            ResultCode resultCode = ResultCode.REQUIRED_VALUES_MISSING;
            throw new ResultException(resultCode);
        }
        ComprehensionTlvTag comprehensionTlvTag5 = ComprehensionTlvTag.ITEM_ID;
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(comprehensionTlvTag5, list);
        if (comprehensionTlv4 != null) {
            int n;
            menu.defaultItem = n = ValueParser.retrieveItemId(comprehensionTlv4) - 1;
        }
        if ((comprehensionTlv2 = this.searchForTag(comprehensionTlvTag2 = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl3;
            this.mIconLoadState = 1;
            iconId = ValueParser.retrieveIconId(comprehensionTlv2);
            menu.titleIconSelfExplanatory = bl3 = iconId.selfExplanatory;
        }
        if ((comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.ITEM_ICON_ID_LIST, list)) != null) {
            boolean bl4;
            this.mIconLoadState = 2;
            itemsIconId = ValueParser.retrieveItemsIconId(comprehensionTlv);
            menu.itemsIconSelfExplanatory = bl4 = itemsIconId.selfExplanatory;
        }
        if (bl = (commandDetails.commandQualifier & 1) != 0) {
            PresentationType presentationType;
            PresentationType presentationType2;
            menu.presentationType = (commandDetails.commandQualifier & 2) == 0 ? (presentationType2 = PresentationType.DATA_VALUES) : (presentationType = PresentationType.NAVIGATION_OPTIONS);
        }
        boolean bl5 = (commandDetails.commandQualifier & 4) != 0;
        menu.softKeyPreferred = bl5;
        boolean bl6 = (commandDetails.commandQualifier & 0x80) != 0;
        menu.helpAvailable = bl6;
        boolean bl7 = iconId != null;
        SelectItemParams selectItemParams = new SelectItemParams(commandDetails, menu, bl7);
        this.mCmdParams = selectItemParams;
        switch (this.mIconLoadState) {
            case 0: {
                return false;
            }
            case 1: {
                IconLoader iconLoader = this.mIconLoader;
                int n = iconId.recordNumber;
                Message message = this.obtainMessage(1);
                iconLoader.loadIcon(n, message);
            }
            default: {
                return true;
            }
            case 2: {
                int[] nArray = itemsIconId.recordNumbers;
                if (iconId != null) {
                    int n;
                    nArray = new int[itemsIconId.recordNumbers.length + 1];
                    nArray[0] = n = iconId.recordNumber;
                    int[] nArray2 = itemsIconId.recordNumbers;
                    int n2 = itemsIconId.recordNumbers.length;
                    System.arraycopy(nArray2, 0, nArray, 1, n2);
                }
                IconLoader iconLoader = this.mIconLoader;
                Message message = this.obtainMessage(1);
                iconLoader.loadIcons(nArray, message);
            }
        }
        return true;
    }

    private boolean processSetUpEventList(CommandDetails commandDetails, List<ComprehensionTlv> list) {
        StkLog.d(this, "process SetUpEventList");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processSetUpIdleModeText(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlvTag comprehensionTlvTag;
        StkLog.d(this, "process SetUpIdleModeText");
        TextMessage textMessage = new TextMessage();
        IconId iconId = null;
        ComprehensionTlvTag comprehensionTlvTag2 = ComprehensionTlvTag.TEXT_STRING;
        ComprehensionTlv comprehensionTlv = this.searchForTag(comprehensionTlvTag2, list);
        if (comprehensionTlv != null) {
            String string2;
            textMessage.text = string2 = ValueParser.retrieveTextString(comprehensionTlv);
        }
        if (textMessage.text != null && (comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl;
            iconId = ValueParser.retrieveIconId(comprehensionTlv);
            textMessage.iconSelfExplanatory = bl = iconId.selfExplanatory;
        }
        DisplayTextParams displayTextParams = new DisplayTextParams(commandDetails, textMessage);
        this.mCmdParams = displayTextParams;
        if (iconId == null) return false;
        this.mIconLoadState = 1;
        IconLoader iconLoader = this.mIconLoader;
        int n = iconId.recordNumber;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcon(n, message);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processSetupCall(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlvTag comprehensionTlvTag;
        ComprehensionTlv comprehensionTlv;
        ComprehensionTlvTag comprehensionTlvTag2;
        ComprehensionTlv comprehensionTlv2;
        ComprehensionTlvTag comprehensionTlvTag3;
        ComprehensionTlv comprehensionTlv3;
        StkLog.d(this, "process SetupCall");
        Iterator<ComprehensionTlv> iterator = list.iterator();
        TextMessage textMessage = new TextMessage();
        TextMessage textMessage2 = new TextMessage();
        IconId iconId = null;
        IconId iconId2 = null;
        ComprehensionTlvTag comprehensionTlvTag4 = ComprehensionTlvTag.ALPHA_ID;
        ComprehensionTlv comprehensionTlv4 = this.searchForNextTag(comprehensionTlvTag4, iterator);
        if (comprehensionTlv4 != null) {
            String string2;
            textMessage.text = string2 = ValueParser.retrieveAlphaId(comprehensionTlv4);
        }
        if ((comprehensionTlv3 = this.searchForTag(comprehensionTlvTag3 = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl;
            iconId = ValueParser.retrieveIconId(comprehensionTlv3);
            textMessage.iconSelfExplanatory = bl = iconId.selfExplanatory;
        }
        if ((comprehensionTlv2 = this.searchForNextTag(comprehensionTlvTag2 = ComprehensionTlvTag.ALPHA_ID, iterator)) != null) {
            String string3;
            textMessage2.text = string3 = ValueParser.retrieveAlphaId(comprehensionTlv2);
        }
        if ((comprehensionTlv = this.searchForTag(comprehensionTlvTag = ComprehensionTlvTag.ICON_ID, list)) != null) {
            boolean bl;
            iconId2 = ValueParser.retrieveIconId(comprehensionTlv);
            textMessage2.iconSelfExplanatory = bl = iconId2.selfExplanatory;
        }
        CallSetupParams callSetupParams = new CallSetupParams(commandDetails, textMessage, textMessage2);
        this.mCmdParams = callSetupParams;
        if (iconId == null && iconId2 == null) {
            return false;
        }
        this.mIconLoadState = 2;
        int[] nArray = new int[2];
        int n = iconId != null ? iconId.recordNumber : -1;
        nArray[0] = n;
        int n2 = iconId2 != null ? iconId2.recordNumber : -1;
        nArray[1] = n2;
        IconLoader iconLoader = this.mIconLoader;
        Message message = this.obtainMessage(1);
        iconLoader.loadIcons(nArray, message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ComprehensionTlv searchForNextTag(ComprehensionTlvTag comprehensionTlvTag, Iterator<ComprehensionTlv> iterator) {
        ComprehensionTlv comprehensionTlv;
        int n = comprehensionTlvTag.value();
        do {
            if (!iterator.hasNext()) return null;
        } while ((comprehensionTlv = iterator.next()).getTag() == n);
        return comprehensionTlv;
    }

    private ComprehensionTlv searchForTag(ComprehensionTlvTag comprehensionTlvTag, List<ComprehensionTlv> list) {
        Iterator<ComprehensionTlv> iterator = list.iterator();
        return this.searchForNextTag(comprehensionTlvTag, iterator);
    }

    private void sendCmdParams(ResultCode resultCode) {
        RilMessageDecoder rilMessageDecoder = this.mCaller;
        CommandParams commandParams = this.mCmdParams;
        rilMessageDecoder.sendMsgParamsDecoded(resultCode, commandParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ResultCode setIcons(Object object) {
        if (object == null) {
            return ResultCode.PRFRMD_ICON_NOT_DISPLAYED;
        }
        switch (this.mIconLoadState) {
            case 1: {
                CommandParams commandParams = this.mCmdParams;
                Bitmap bitmap = (Bitmap)object;
                boolean bl = commandParams.setIcon(bitmap);
            }
            default: {
                return ResultCode.OK;
            }
            case 2: {
                Bitmap[] bitmapArray = (Bitmap[])object;
                int n = bitmapArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bitmap bitmap = bitmapArray[n2];
                    boolean bl = this.mCmdParams.setIcon(bitmap);
                    ++n2;
                }
                return ResultCode.OK;
            }
        }
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: 
        }
        Object object = message.obj;
        ResultCode resultCode = this.setIcons(object);
        this.sendCmdParams(resultCode);
    }

    /*
     * Exception decompiling
     */
    void make(BerTlv var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 242->251)] com.android.internal.telephony.gsm.stk.ResultException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

