/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.ResponseData;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

class GetInkeyInputResponseData
extends ResponseData {
    protected static final byte GET_INKEY_NO = 0;
    protected static final byte GET_INKEY_YES = 1;
    public String mInData;
    private boolean mIsPacked;
    private boolean mIsUcs2;
    private boolean mIsYesNo;
    private boolean mYesNoResponse;

    public GetInkeyInputResponseData(String string2, boolean bl, boolean bl2) {
        this.mIsUcs2 = bl;
        this.mIsPacked = bl2;
        this.mInData = string2;
        this.mIsYesNo = false;
    }

    public GetInkeyInputResponseData(boolean bl) {
        this.mIsUcs2 = false;
        this.mIsPacked = false;
        this.mInData = "";
        this.mIsYesNo = true;
        this.mYesNoResponse = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void format(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray;
        if (byteArrayOutputStream == null) {
            return;
        }
        int n = ComprehensionTlvTag.TEXT_STRING.value() | 0x80;
        byteArrayOutputStream.write(n);
        if (this.mIsYesNo) {
            byArray = new byte[1];
            byte by = this.mYesNoResponse ? (byte)1 : 0;
            byArray[0] = by;
        } else if (this.mInData != null && this.mInData.length() > 0) {
            try {
                if (this.mIsUcs2) {
                    byArray = this.mInData.getBytes("UTF-16");
                } else {
                    if (this.mIsPacked) {
                        int n2 = this.mInData.length();
                        byte[] byArray2 = GsmAlphabet.stringToGsm7BitPacked(this.mInData);
                        byArray = new byte[n2];
                        System.arraycopy(byArray2, 1, byArray, 0, n2);
                    }
                    byte[] byArray3 = GsmAlphabet.stringToGsm8BitPacked(this.mInData);
                    byArray = byArray3;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = new byte[]{};
            }
            catch (EncodeException encodeException) {
                byArray = new byte[]{};
            }
        } else {
            byArray = new byte[]{};
        }
        int n3 = byArray.length + 1;
        byteArrayOutputStream.write(n3);
        if (this.mIsUcs2) {
            byteArrayOutputStream.write(8);
        } else if (this.mIsPacked) {
            byteArrayOutputStream.write(0);
        } else {
            byteArrayOutputStream.write(4);
        }
        byte[] byArray4 = byArray;
        int n4 = byArray4.length;
        int n5 = 0;
        while (n5 < n4) {
            byte by = byArray4[n5];
            byteArrayOutputStream.write(by);
            ++n5;
        }
        return;
    }
}

