/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.stk.ImageDescriptor;
import com.android.internal.telephony.gsm.stk.StkLog;
import java.util.HashMap;

class IconLoader
extends Handler {
    private static final int CLUT_ENTRY_SIZE = 3;
    private static final int CLUT_LOCATION_OFFSET = 4;
    private static final int EVENT_READ_CLUT_DONE = 3;
    private static final int EVENT_READ_EF_IMG_RECOED_DONE = 1;
    private static final int EVENT_READ_ICON_DONE = 2;
    private static final int STATE_MULTI_ICONS = 2;
    private static final int STATE_SINGLE_ICON = 1;
    private static IconLoader sLoader = null;
    private Bitmap mCurrentIcon = null;
    private int mCurrentRecordIndex = 0;
    private Message mEndMsg = null;
    private byte[] mIconData = null;
    private Bitmap[] mIcons = null;
    private HashMap<Integer, Bitmap> mIconsCache = null;
    private ImageDescriptor mId = null;
    private int mRecordNumber;
    private int[] mRecordNumbers = null;
    private SIMFileHandler mSimFH = null;
    private int mState = 1;

    private IconLoader(Looper looper, SIMFileHandler sIMFileHandler) {
        super(looper);
        this.mSimFH = sIMFileHandler;
        HashMap hashMap = new HashMap(50);
        this.mIconsCache = hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int bitToBnW(int n) {
        if (n != 1) return -16777216;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IconLoader getInstance(Handler handler, SIMFileHandler sIMFileHandler) {
        if (sLoader != null) {
            return sLoader;
        }
        if (sIMFileHandler == null) return null;
        HandlerThread handlerThread = new HandlerThread("Stk Icon Loader");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        return new IconLoader(looper, sIMFileHandler);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getMask(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
            case 7: {
                return 127;
            }
            case 8: {
                return 255;
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleImageDescriptor(byte[] byArray) {
        ImageDescriptor imageDescriptor;
        this.mId = imageDescriptor = ImageDescriptor.parse(byArray, 1);
        if (this.mId != null) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToBnW(byte[] byArray, int n) {
        int n2 = 0 + 1;
        int n3 = byArray[0] & 0xFF;
        int n4 = n2 + 1;
        int n5 = byArray[n2] & 0xFF;
        int n6 = n3 * n5;
        int[] nArray = new int[n6];
        int n7 = 7;
        byte by = 0;
        int n8 = 0;
        int n9 = n4;
        while (n8 < n6) {
            int n10;
            int n11;
            if (n8 % 8 == 0) {
                n11 = n9 + 1;
                by = byArray[n9];
                n7 = 7;
            } else {
                n11 = n9;
            }
            int n12 = n8 + 1;
            int n13 = n7 + -1;
            nArray[n8] = n10 = IconLoader.bitToBnW(by >> n7 & 1);
            int n14 = n13;
            n8 = n12;
            n9 = n11;
        }
        if (n8 != n6) {
            StkLog.d("IconLoader", "parseToBnW; size error");
        }
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        return Bitmap.createBitmap(nArray, n3, n5, config);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToRGB(byte[] byArray, int n, boolean bl, byte[] byArray2) {
        int n2;
        int n3 = 0 + 1;
        int n4 = byArray[0] & 0xFF;
        int n5 = n3 + 1;
        int n6 = byArray[n3] & 0xFF;
        int n7 = n5 + 1;
        int n8 = byArray[n5] & 0xFF;
        int n9 = n7 + 1;
        int n10 = byArray[n7] & 0xFF;
        boolean bl2 = true;
        boolean bl3 = bl;
        if (bl2 != bl3) {
            int n11 = n10 - 1;
            byArray2[n11] = 0;
        }
        int n12 = n4 * n6;
        int[] nArray = new int[n12];
        int n13 = 0;
        int n14 = n2 = 8 - n8;
        int n15 = 6 + 1;
        int n16 = byArray[6];
        int n17 = IconLoader.getMask(n8);
        boolean bl4 = 8 % n8 == 0;
        int n18 = n13;
        while (true) {
            int n19;
            int n20;
            if (n18 >= n12) {
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
                int[] nArray2 = nArray;
                int n21 = n4;
                int n22 = n6;
                Bitmap.Config config2 = config;
                return Bitmap.createBitmap(nArray2, n21, n22, config2);
            }
            if (n14 < 0) {
                int n23 = n15 + 1;
                n16 = byArray[n15];
                n14 = bl4 ? n2 : (n14 *= -1);
                n20 = n23;
                n13 = n16;
            } else {
                n13 = n16;
                n20 = n15;
            }
            int n24 = (n13 >> n14 & n17) * 3;
            int n25 = n18 + 1;
            byte by = byArray2[n24];
            int n26 = n24 + 1;
            byte by2 = byArray2[n26];
            int n27 = n24 + 2;
            byte by3 = byArray2[n27];
            byte by4 = by;
            byte by5 = by2;
            byte by6 = by3;
            nArray[n18] = n19 = Color.rgb(by4, by5, by6);
            int n28 = n14 - n8;
            int n29 = n13;
            n18 = n25;
            n15 = n20;
        }
    }

    private void postIcon() {
        Bitmap[] bitmapArray;
        Bitmap bitmap;
        int n;
        if (this.mState == 1) {
            Message message = this.mEndMsg;
            Bitmap bitmap2 = this.mCurrentIcon;
            message.obj = bitmap2;
            this.mEndMsg.sendToTarget();
            return;
        }
        if (this.mState != 2) {
            return;
        }
        Bitmap[] bitmapArray2 = this.mIcons;
        int n2 = this.mCurrentRecordIndex;
        this.mCurrentRecordIndex = n = n2 + 1;
        bitmapArray2[n2] = bitmap = this.mCurrentIcon;
        int n3 = this.mCurrentRecordIndex;
        int n4 = this.mRecordNumbers.length;
        if (n3 < n4) {
            int[] nArray = this.mRecordNumbers;
            int n5 = this.mCurrentRecordIndex;
            int n6 = nArray[n5];
            this.startLoadingIcon(n6);
            return;
        }
        Message message = this.mEndMsg;
        message.obj = bitmapArray = this.mIcons;
        this.mEndMsg.sendToTarget();
    }

    private void readClut() {
        int n = this.mIconData[3] * 3;
        Message message = this.obtainMessage(3);
        SIMFileHandler sIMFileHandler = this.mSimFH;
        int n2 = this.mId.imageId;
        byte by = this.mIconData[4];
        byte by2 = this.mIconData[5];
        sIMFileHandler.loadEFImgTransparent(n2, by, by2, n, message);
    }

    private void readIconData() {
        Message message = this.obtainMessage(2);
        SIMFileHandler sIMFileHandler = this.mSimFH;
        int n = this.mId.imageId;
        int n2 = this.mId.length;
        int n3 = 0;
        sIMFileHandler.loadEFImgTransparent(n, 0, n3, n2, message);
    }

    private void readId() {
        if (this.mRecordNumber < 0) {
            this.mCurrentIcon = null;
            this.postIcon();
            return;
        }
        Message message = this.obtainMessage(1);
        SIMFileHandler sIMFileHandler = this.mSimFH;
        int n = this.mRecordNumber;
        sIMFileHandler.loadEFImgLinearFixed(n, message);
    }

    private void startLoadingIcon(int n) {
        this.mId = null;
        this.mIconData = null;
        this.mCurrentIcon = null;
        this.mRecordNumber = n;
        HashMap<Integer, Bitmap> hashMap = this.mIconsCache;
        Integer n2 = n;
        if (hashMap.containsKey(n2)) {
            Bitmap bitmap;
            HashMap<Integer, Bitmap> hashMap2 = this.mIconsCache;
            Integer n3 = n;
            this.mCurrentIcon = bitmap = hashMap2.get(n3);
            this.postIcon();
            return;
        }
        this.readId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        try {
            Bitmap bitmap;
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    byte[] byArray = (byte[])((AsyncResult)message.obj).result;
                    if (this.handleImageDescriptor(byArray)) {
                        this.readIconData();
                        return;
                    }
                    throw new Exception("Unable to parse image descriptor");
                }
                case 2: {
                    byte[] byArray = (byte[])((AsyncResult)message.obj).result;
                    if (this.mId.codingScheme == 17) {
                        Bitmap bitmap2;
                        int n = byArray.length;
                        this.mCurrentIcon = bitmap2 = IconLoader.parseToBnW(byArray, n);
                        HashMap<Integer, Bitmap> hashMap = this.mIconsCache;
                        Integer n2 = this.mRecordNumber;
                        Bitmap bitmap3 = this.mCurrentIcon;
                        Bitmap bitmap4 = hashMap.put(n2, bitmap3);
                        this.postIcon();
                        return;
                    }
                    if (this.mId.codingScheme != 33) {
                        return;
                    }
                    this.mIconData = byArray;
                    this.readClut();
                    return;
                }
                case 3: 
            }
            byte[] byArray = (byte[])((AsyncResult)message.obj).result;
            byte[] byArray2 = this.mIconData;
            int n = this.mIconData.length;
            this.mCurrentIcon = bitmap = IconLoader.parseToRGB(byArray2, n, false, byArray);
            HashMap<Integer, Bitmap> hashMap = this.mIconsCache;
            Integer n3 = this.mRecordNumber;
            Bitmap bitmap5 = this.mCurrentIcon;
            Bitmap bitmap6 = hashMap.put(n3, bitmap5);
            this.postIcon();
            return;
        }
        catch (Exception exception) {
            StkLog.d(this, "Icon load failed");
            this.postIcon();
            return;
        }
    }

    void loadIcon(int n, Message message) {
        if (message == null) {
            return;
        }
        this.mEndMsg = message;
        this.mState = 1;
        this.startLoadingIcon(n);
    }

    void loadIcons(int[] nArray, Message message) {
        if (nArray == null) {
            return;
        }
        if (nArray.length == 0) {
            return;
        }
        if (message == null) {
            return;
        }
        this.mEndMsg = message;
        Bitmap[] bitmapArray = new Bitmap[nArray.length];
        this.mIcons = bitmapArray;
        this.mRecordNumbers = nArray;
        this.mCurrentRecordIndex = 0;
        this.mState = 2;
        int n = nArray[0];
        this.startLoadingIcon(n);
    }
}

