/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.stk.BerTlv;
import com.android.internal.telephony.gsm.stk.CommandParams;
import com.android.internal.telephony.gsm.stk.CommandParamsFactory;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.ResultException;
import com.android.internal.telephony.gsm.stk.RilMessage;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

class RilMessageDecoder
extends HierarchicalStateMachine {
    private static final int CMD_PARAMS_READY = 2;
    private static final int CMD_START = 1;
    private static RilMessageDecoder sInstance = null;
    private Handler mCaller = null;
    private CommandParamsFactory mCmdParamsFactory = null;
    private RilMessage mCurrentRilMessage = null;
    private StateCmdParamsReady mStateCmdParamsReady;
    private StateStart mStateStart;

    private RilMessageDecoder(Handler handler, SIMFileHandler sIMFileHandler) {
        super("RilMessageDecoder");
        CommandParamsFactory commandParamsFactory;
        StateCmdParamsReady stateCmdParamsReady;
        StateStart stateStart;
        this.mStateStart = stateStart = new StateStart();
        this.mStateCmdParamsReady = stateCmdParamsReady = new StateCmdParamsReady();
        StateStart stateStart2 = this.mStateStart;
        this.addState(stateStart2);
        StateCmdParamsReady stateCmdParamsReady2 = this.mStateCmdParamsReady;
        this.addState(stateCmdParamsReady2);
        StateStart stateStart3 = this.mStateStart;
        this.setInitialState(stateStart3);
        this.mCaller = handler;
        this.mCmdParamsFactory = commandParamsFactory = CommandParamsFactory.getInstance(this, sIMFileHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean decodeMessageParams(RilMessage rilMessage) {
        byte[] byArray;
        this.mCurrentRilMessage = rilMessage;
        switch (rilMessage.mId) {
            default: {
                return false;
            }
            case 1: 
            case 4: {
                ResultCode resultCode;
                RilMessage rilMessage2 = this.mCurrentRilMessage;
                rilMessage2.mResCode = resultCode = ResultCode.OK;
                RilMessage rilMessage3 = this.mCurrentRilMessage;
                this.sendCmdForExecution(rilMessage3);
                return false;
            }
            case 2: 
            case 3: 
            case 5: 
        }
        try {
            byte[] byArray2;
            byArray = byArray2 = IccUtils.hexStringToBytes((String)rilMessage.mData);
        }
        catch (Exception exception) {
            StkLog.d(this, "decodeMessageParams dropping zombie messages");
            return false;
        }
        try {
            CommandParamsFactory commandParamsFactory = this.mCmdParamsFactory;
            BerTlv berTlv = BerTlv.decode(byArray);
            commandParamsFactory.make(berTlv);
            return true;
        }
        catch (ResultException resultException) {
            ResultCode resultCode;
            RilMessage rilMessage4 = this.mCurrentRilMessage;
            rilMessage4.mResCode = resultCode = resultException.result();
            RilMessage rilMessage5 = this.mCurrentRilMessage;
            this.sendCmdForExecution(rilMessage5);
            return false;
        }
    }

    public static RilMessageDecoder getInstance(Handler handler, SIMFileHandler sIMFileHandler) {
        synchronized (RilMessageDecoder.class) {
            if (sInstance == null) {
                sInstance = new RilMessageDecoder(handler, sIMFileHandler);
                sInstance.start();
            }
            RilMessageDecoder rilMessageDecoder = sInstance;
            return rilMessageDecoder;
        }
    }

    private void sendCmdForExecution(RilMessage rilMessage) {
        Handler handler = this.mCaller;
        RilMessage rilMessage2 = new RilMessage(rilMessage);
        handler.obtainMessage(10, rilMessage2).sendToTarget();
    }

    public void sendMsgParamsDecoded(ResultCode resultCode, CommandParams commandParams) {
        int n;
        Message message = this.obtainMessage(2);
        message.arg1 = n = resultCode.value();
        message.obj = commandParams;
        this.sendMessage(message);
    }

    public void sendStartDecodingMessageParams(RilMessage rilMessage) {
        Message message = this.obtainMessage(1);
        message.obj = rilMessage;
        this.sendMessage(message);
    }

    private class StateCmdParamsReady
    extends HierarchicalState {
        private StateCmdParamsReady() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            if (message.what == 2) {
                Object object;
                ResultCode resultCode;
                RilMessage rilMessage = RilMessageDecoder.this.mCurrentRilMessage;
                rilMessage.mResCode = resultCode = ResultCode.fromInt(message.arg1);
                RilMessage rilMessage2 = RilMessageDecoder.this.mCurrentRilMessage;
                rilMessage2.mData = object = message.obj;
                RilMessageDecoder rilMessageDecoder = RilMessageDecoder.this;
                RilMessage rilMessage3 = RilMessageDecoder.this.mCurrentRilMessage;
                rilMessageDecoder.sendCmdForExecution(rilMessage3);
                RilMessageDecoder rilMessageDecoder2 = RilMessageDecoder.this;
                StateStart stateStart = RilMessageDecoder.this.mStateStart;
                rilMessageDecoder2.transitionTo(stateStart);
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder().append("StateCmdParamsReady expecting CMD_PARAMS_READY=2 got ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            StkLog.d(this, string2);
            RilMessageDecoder.this.deferMessage(message);
            return true;
        }
    }

    private class StateStart
    extends HierarchicalState {
        private StateStart() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            if (message.what == 1) {
                RilMessageDecoder rilMessageDecoder = RilMessageDecoder.this;
                RilMessage rilMessage = (RilMessage)message.obj;
                if (rilMessageDecoder.decodeMessageParams(rilMessage)) {
                    RilMessageDecoder rilMessageDecoder2 = RilMessageDecoder.this;
                    StateCmdParamsReady stateCmdParamsReady = RilMessageDecoder.this.mStateCmdParamsReady;
                    rilMessageDecoder2.transitionTo(stateCmdParamsReady);
                }
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder().append("StateStart unexpected expecting START=1 got ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            StkLog.d(this, string2);
            return true;
        }
    }
}

