/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.SIMRecords;
import com.android.internal.telephony.gsm.SimCard;
import com.android.internal.telephony.gsm.stk.AppInterface;
import com.android.internal.telephony.gsm.stk.CommandDetails;
import com.android.internal.telephony.gsm.stk.CommandParams;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.GetInkeyInputResponseData;
import com.android.internal.telephony.gsm.stk.Input;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.Menu;
import com.android.internal.telephony.gsm.stk.ResponseData;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.RilMessage;
import com.android.internal.telephony.gsm.stk.RilMessageDecoder;
import com.android.internal.telephony.gsm.stk.SelectItemResponseData;
import com.android.internal.telephony.gsm.stk.StkCmdMessage;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.telephony.gsm.stk.StkResponseMessage;
import java.io.ByteArrayOutputStream;

public class StkService
extends Handler
implements AppInterface {
    private static final int DEV_ID_DISPLAY = 2;
    private static final int DEV_ID_EARPIECE = 3;
    private static final int DEV_ID_KEYPAD = 1;
    private static final int DEV_ID_NETWORK = 131;
    private static final int DEV_ID_TERMINAL = 130;
    private static final int DEV_ID_UICC = 129;
    static final int MSG_ID_CALL_SETUP = 4;
    static final int MSG_ID_EVENT_NOTIFY = 3;
    static final int MSG_ID_PROACTIVE_COMMAND = 2;
    static final int MSG_ID_REFRESH = 5;
    static final int MSG_ID_RESPONSE = 6;
    static final int MSG_ID_RIL_MSG_DECODED = 10;
    static final int MSG_ID_SESSION_END = 1;
    private static final int MSG_ID_SIM_LOADED = 20;
    private static SIMRecords mSimRecords;
    private static StkService sInstance;
    private CommandsInterface mCmdIf;
    private Context mContext;
    private StkCmdMessage mCurrntCmd = null;
    private StkCmdMessage mMenuCmd = null;
    private RilMessageDecoder mMsgDecoder = null;

    private StkService(CommandsInterface commandsInterface, SIMRecords sIMRecords, Context context, SIMFileHandler sIMFileHandler, SimCard simCard) {
        RilMessageDecoder rilMessageDecoder;
        if (commandsInterface == null || sIMRecords == null || context == null || sIMFileHandler == null || simCard == null) {
            throw new NullPointerException("Service: Input parameters must not be null");
        }
        this.mCmdIf = commandsInterface;
        this.mContext = context;
        this.mMsgDecoder = rilMessageDecoder = RilMessageDecoder.getInstance(this, sIMFileHandler);
        this.mCmdIf.setOnStkSessionEnd(this, 1, null);
        this.mCmdIf.setOnStkProactiveCmd(this, 2, null);
        this.mCmdIf.setOnStkEvent(this, 3, null);
        this.mCmdIf.setOnStkCallSetUp(this, 4, null);
        mSimRecords = sIMRecords;
        mSimRecords.registerForRecordsLoaded(this, 20, null);
        this.mCmdIf.reportStkServiceIsRunning(null);
        StkLog.d(this, "StkService: is running");
    }

    private void eventDownload(int n, int n2, int n3, byte[] byArray, boolean bl) {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(214);
        byteArrayOutputStream.write(0);
        int n4 = ComprehensionTlvTag.EVENT_LIST.value() | 0x80;
        byteArrayOutputStream.write(n4);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(n);
        int n5 = ComprehensionTlvTag.DEVICE_IDENTITIES.value() | 0x80;
        byteArrayOutputStream.write(n5);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(n3);
        if (byArray != null) {
            for (byte by2 : byArray) {
                byteArrayOutputStream.write(by2);
            }
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byArray2[1] = by = (byte)(byArray2.length - 2);
        String string2 = IccUtils.bytesToHexString(byArray2);
        this.mCmdIf.sendEnvelope(string2, null);
    }

    public static AppInterface getInstance() {
        return StkService.getInstance(null, null, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StkService getInstance(CommandsInterface commandsInterface, SIMRecords sIMRecords, Context context, SIMFileHandler sIMFileHandler, SimCard simCard) {
        if (sInstance == null) {
            if (commandsInterface == null) return null;
            if (sIMRecords == null) return null;
            if (context == null) return null;
            if (sIMFileHandler == null) return null;
            if (simCard == null) {
                return null;
            }
            new HandlerThread("Stk Telephony service").start();
            CommandsInterface commandsInterface2 = commandsInterface;
            SIMRecords sIMRecords2 = sIMRecords;
            Context context2 = context;
            SIMFileHandler sIMFileHandler2 = sIMFileHandler;
            SimCard simCard2 = simCard;
            sInstance = new StkService(commandsInterface2, sIMRecords2, context2, sIMFileHandler2, simCard2);
            StkLog.d(sInstance, "NEW sInstance");
            return sInstance;
        }
        if (sIMRecords != null && mSimRecords != sIMRecords) {
            StkLog.d(sInstance, "Reinitialize the Service with SIMRecords");
            SIMRecords sIMRecords3 = mSimRecords = sIMRecords;
            StkService stkService = sInstance;
            sIMRecords3.registerForRecordsLoaded(stkService, 20, null);
            StkLog.d(sInstance, "sr changed reinitialize and return current sInstance");
            return sInstance;
        }
        StkLog.d(sInstance, "Return current sInstance");
        return sInstance;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void handleCmdResponse(StkResponseMessage stkResponseMessage) {
        void var2_3;
        if (!this.validateResponse(stkResponseMessage)) {
            return;
        }
        Object var2_2 = null;
        boolean bl = false;
        CommandDetails commandDetails = stkResponseMessage.getCmdDetails();
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$gsm$stk$ResultCode;
        int n = stkResponseMessage.resCode.ordinal();
        block0 : switch (nArray[n]) {
            default: {
                return;
            }
            case 1: {
                bl = true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int[] nArray2 = 1.$SwitchMap$com$android$internal$telephony$gsm$stk$AppInterface$CommandType;
                int n2 = AppInterface.CommandType.fromInt(commandDetails.typeOfCommand).ordinal();
                switch (nArray2[n2]) {
                    case 1: {
                        ResultCode resultCode = stkResponseMessage.resCode;
                        ResultCode resultCode2 = ResultCode.HELP_INFO_REQUIRED;
                        bl = resultCode == resultCode2;
                        int n3 = stkResponseMessage.usersMenuSelection;
                        this.sendMenuSelection(n3, bl);
                        return;
                    }
                    case 6: {
                        int n4 = stkResponseMessage.usersMenuSelection;
                        SelectItemResponseData selectItemResponseData = new SelectItemResponseData(n4);
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        Input input = this.mCurrntCmd.geInput();
                        if (!input.yesNo) {
                            if (!bl) {
                                String string2 = stkResponseMessage.usersInput;
                                boolean bl2 = input.ucs2;
                                boolean bl3 = input.packed;
                                GetInkeyInputResponseData getInkeyInputResponseData = new GetInkeyInputResponseData(string2, bl2, bl3);
                                break block0;
                            }
                        } else {
                            boolean bl4 = stkResponseMessage.usersYesNoSelection;
                            GetInkeyInputResponseData getInkeyInputResponseData = new GetInkeyInputResponseData(bl4);
                        }
                    }
                    default: {
                        break block0;
                    }
                    case 14: 
                }
                CommandsInterface commandsInterface = this.mCmdIf;
                boolean bl5 = stkResponseMessage.usersConfirm;
                commandsInterface.handleCallSetupRequestFromSim(bl5, null);
                this.mCurrntCmd = null;
                return;
            }
            case 12: 
            case 13: 
            case 14: {
                Object var2_7 = null;
            }
        }
        ResultCode resultCode = stkResponseMessage.resCode;
        StkService stkService = this;
        int n5 = 0;
        stkService.sendTerminalResponse(commandDetails, resultCode, false, n5, (ResponseData)var2_3);
        this.mCurrntCmd = null;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private void handleProactiveCommand(CommandParams commandParams) {
        String string2 = commandParams.getCommandType().name();
        StkLog.d(this, string2);
        StkCmdMessage stkCmdMessage = new StkCmdMessage(commandParams);
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$gsm$stk$AppInterface$CommandType;
        int n = commandParams.getCommandType().ordinal();
        int n2 = 0;
        block7: do {
            switch (n2 == 0 ? nArray[n] : n2) {
                default: {
                    StkLog.d(this, "Unsupported command");
                    return;
                }
                case 1: {
                    Menu menu = stkCmdMessage.getMenu();
                    this.mMenuCmd = this.removeMenu(menu) ? null : stkCmdMessage;
                    CommandDetails commandDetails = commandParams.cmdDet;
                    ResultCode resultCode = ResultCode.OK;
                    StkService stkService = this;
                    int n3 = 0;
                    stkService.sendTerminalResponse(commandDetails, resultCode, false, n3, null);
                    break;
                }
                case 2: {
                    n2 = 5;
                    if (stkCmdMessage.geTextMessage().responseNeeded) continue block7;
                    CommandDetails commandDetails = commandParams.cmdDet;
                    ResultCode resultCode = ResultCode.OK;
                    StkService stkService = this;
                    int n4 = 0;
                    stkService.sendTerminalResponse(commandDetails, resultCode, false, n4, null);
                    break;
                }
                case 3: {
                    int n5;
                    CommandDetails commandDetails = commandParams.cmdDet;
                    commandDetails.typeOfCommand = n5 = AppInterface.CommandType.SET_UP_IDLE_MODE_TEXT.value();
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 4: {
                    CommandDetails commandDetails = commandParams.cmdDet;
                    ResultCode resultCode = ResultCode.OK;
                    StkService stkService = this;
                    int n6 = 0;
                    stkService.sendTerminalResponse(commandDetails, resultCode, false, n6, null);
                }
            }
            break;
        } while (true);
        this.mCurrntCmd = stkCmdMessage;
        Intent intent = new Intent("android.intent.action.stk.command");
        Intent intent2 = intent.putExtra("STK CMD", stkCmdMessage);
        this.mContext.sendBroadcast(intent);
    }

    private void handleRilMsg(RilMessage rilMessage) {
        if (rilMessage == null) {
            return;
        }
        switch (rilMessage.mId) {
            default: {
                return;
            }
            case 1: {
                this.handleSessionEnd();
                return;
            }
            case 3: {
                ResultCode resultCode = rilMessage.mResCode;
                ResultCode resultCode2 = ResultCode.OK;
                if (resultCode != resultCode2) {
                    return;
                }
                CommandParams commandParams = (CommandParams)rilMessage.mData;
                if (commandParams == null) {
                    return;
                }
                this.handleProactiveCommand(commandParams);
                return;
            }
            case 2: {
                CommandParams commandParams = (CommandParams)rilMessage.mData;
                if (commandParams == null) {
                    return;
                }
                ResultCode resultCode = rilMessage.mResCode;
                ResultCode resultCode3 = ResultCode.OK;
                if (resultCode == resultCode3) {
                    this.handleProactiveCommand(commandParams);
                    return;
                }
                CommandDetails commandDetails = commandParams.cmdDet;
                ResultCode resultCode4 = rilMessage.mResCode;
                StkService stkService = this;
                int n = 0;
                stkService.sendTerminalResponse(commandDetails, resultCode4, false, n, null);
                return;
            }
            case 5: 
        }
        CommandParams commandParams = (CommandParams)rilMessage.mData;
        if (commandParams == null) {
            return;
        }
        this.handleProactiveCommand(commandParams);
    }

    private void handleSessionEnd() {
        StkCmdMessage stkCmdMessage;
        StkLog.d(this, "SESSION END");
        this.mCurrntCmd = stkCmdMessage = this.mMenuCmd;
        Intent intent = new Intent("android.intent.action.stk.session_end");
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean removeMenu(Menu menu) {
        try {
            if (menu.items.size() != 1) return false;
            Item item = menu.items.get(0);
            if (item != null) return false;
            return true;
        }
        catch (NullPointerException nullPointerException) {
            StkLog.d(this, "Unable to get Menu's items size");
            return true;
        }
    }

    private void sendMenuSelection(int n, boolean bl) {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(211);
        byteArrayOutputStream.write(0);
        int n2 = ComprehensionTlvTag.DEVICE_IDENTITIES.value() | 0x80;
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(129);
        int n3 = ComprehensionTlvTag.ITEM_ID.value() | 0x80;
        byteArrayOutputStream.write(n3);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(n);
        if (bl) {
            int n4 = ComprehensionTlvTag.HELP_REQUEST.value();
            byteArrayOutputStream.write(n4);
            byteArrayOutputStream.write(0);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byArray[1] = by = (byte)(byArray.length - 2);
        String string2 = IccUtils.bytesToHexString(byArray);
        this.mCmdIf.sendEnvelope(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendTerminalResponse(CommandDetails commandDetails, ResultCode resultCode, boolean bl, int n, ResponseData responseData) {
        if (commandDetails == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = ComprehensionTlvTag.COMMAND_DETAILS.value();
        if (commandDetails.compRequired) {
            n2 |= 0x80;
        }
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(3);
        int n3 = commandDetails.commandNumber;
        byteArrayOutputStream.write(n3);
        int n4 = commandDetails.typeOfCommand;
        byteArrayOutputStream.write(n4);
        int n5 = commandDetails.commandQualifier;
        byteArrayOutputStream.write(n5);
        int n6 = ComprehensionTlvTag.DEVICE_IDENTITIES.value() | 0x80;
        byteArrayOutputStream.write(n6);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(130);
        byteArrayOutputStream.write(129);
        int n7 = ComprehensionTlvTag.RESULT.value() | 0x80;
        byteArrayOutputStream.write(n7);
        int n8 = bl ? 2 : 1;
        byteArrayOutputStream.write(n8);
        int n9 = resultCode.value();
        byteArrayOutputStream.write(n9);
        if (bl) {
            byteArrayOutputStream.write(n);
        }
        if (responseData != null) {
            responseData.format(byteArrayOutputStream);
        }
        String string2 = IccUtils.bytesToHexString(byteArrayOutputStream.toByteArray());
        String string3 = "TERMINAL RESPONSE: " + string2;
        StkLog.d(this, string3);
        this.mCmdIf.sendTerminalResponse(string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateResponse(StkResponseMessage stkResponseMessage) {
        if (this.mCurrntCmd == null) return false;
        CommandDetails commandDetails = stkResponseMessage.cmdDet;
        CommandDetails commandDetails2 = this.mCurrntCmd.mCmdDet;
        return commandDetails.compareTo(commandDetails2);
    }

    public void dispose() {
        mSimRecords.unregisterForRecordsLoaded(this);
        this.mCmdIf.unSetOnStkSessionEnd(this);
        this.mCmdIf.unSetOnStkProactiveCmd(this);
        this.mCmdIf.unSetOnStkEvent(this);
        this.mCmdIf.unSetOnStkCallSetUp(this);
        this.removeCallbacksAndMessages(null);
    }

    protected void finalize() {
        StkLog.d(this, "Service finalized");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unrecognized STK command: ");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                throw new AssertionError((Object)string2);
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                AsyncResult asyncResult;
                StkLog.d(this, "ril message arrived");
                String string3 = null;
                if (message.obj != null && (asyncResult = (AsyncResult)message.obj) != null && asyncResult.result != null) {
                    try {
                        string3 = (String)asyncResult.result;
                    }
                    catch (ClassCastException classCastException) {
                        return;
                    }
                }
                RilMessageDecoder rilMessageDecoder = this.mMsgDecoder;
                int n = message.what;
                RilMessage rilMessage = new RilMessage(n, string3);
                rilMessageDecoder.sendStartDecodingMessageParams(rilMessage);
            }
            case 20: {
                return;
            }
            case 4: {
                RilMessageDecoder rilMessageDecoder = this.mMsgDecoder;
                int n = message.what;
                RilMessage rilMessage = new RilMessage(n, null);
                rilMessageDecoder.sendStartDecodingMessageParams(rilMessage);
                return;
            }
            case 10: {
                RilMessage rilMessage = (RilMessage)message.obj;
                this.handleRilMsg(rilMessage);
                return;
            }
            case 6: 
        }
        StkResponseMessage stkResponseMessage = (StkResponseMessage)message.obj;
        this.handleCmdResponse(stkResponseMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCmdResponse(StkResponseMessage stkResponseMessage) {
        synchronized (this) {
            if (stkResponseMessage == null) {
                return;
            }
            int n = 6;
            this.obtainMessage(n, stkResponseMessage).sendToTarget();
            return;
        }
    }
}

