/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.stk.CommandDetails;
import com.android.internal.telephony.gsm.stk.ComprehensionTlv;
import com.android.internal.telephony.gsm.stk.DeviceIdentities;
import com.android.internal.telephony.gsm.stk.Duration;
import com.android.internal.telephony.gsm.stk.FontSize;
import com.android.internal.telephony.gsm.stk.IconId;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.ItemsIconId;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.ResultException;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.telephony.gsm.stk.TextAlignment;
import com.android.internal.telephony.gsm.stk.TextAttribute;
import com.android.internal.telephony.gsm.stk.TextColor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

abstract class ValueParser {
    ValueParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String retrieveAlphaId(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = comprehensionTlv.getLength();
        if (n2 == 0) return null;
        try {
            String string2 = IccUtils.adnStringFieldToString(byArray, n, n2);
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
    }

    static CommandDetails retrieveCommandDetails(ComprehensionTlv comprehensionTlv) throws ResultException {
        CommandDetails commandDetails = new CommandDetails();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            int n2;
            int n3;
            int n4;
            boolean bl;
            commandDetails.compRequired = bl = comprehensionTlv.isComprehensionRequired();
            commandDetails.commandNumber = n4 = byArray[n] & 0xFF;
            int n5 = n + 1;
            commandDetails.typeOfCommand = n3 = byArray[n5] & 0xFF;
            int n6 = n + 2;
            commandDetails.commandQualifier = n2 = byArray[n6] & 0xFF;
            return commandDetails;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
    }

    static DeviceIdentities retrieveDeviceIdentities(ComprehensionTlv comprehensionTlv) throws ResultException {
        DeviceIdentities deviceIdentities = new DeviceIdentities();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            int n2;
            int n3;
            deviceIdentities.sourceId = n3 = byArray[n] & 0xFF;
            int n4 = n + 1;
            deviceIdentities.destinationId = n2 = byArray[n4] & 0xFF;
            return deviceIdentities;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.REQUIRED_VALUES_MISSING;
            throw new ResultException(resultCode);
        }
    }

    static Duration retrieveDuration(ComprehensionTlv comprehensionTlv) throws ResultException {
        int n;
        Duration.TimeUnit timeUnit;
        Duration.TimeUnit timeUnit2 = Duration.TimeUnit.SECOND;
        byte[] byArray = comprehensionTlv.getRawValue();
        int n2 = comprehensionTlv.getValueIndex();
        try {
            Duration.TimeUnit[] timeUnitArray = Duration.TimeUnit.values();
            int n3 = byArray[n2] & 0xFF;
            timeUnit = timeUnitArray[n3];
            int n4 = n2 + 1;
            byte by = byArray[n4];
            n = by & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
        return new Duration(n, timeUnit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IconId retrieveIconId(ComprehensionTlv comprehensionTlv) throws ResultException {
        IconId iconId = new IconId();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = n + 1;
        try {
            int n3;
            boolean bl = (byArray[n] & 0xFF) == 0;
            iconId.selfExplanatory = bl;
            iconId.recordNumber = n3 = byArray[n2] & 0xFF;
            return iconId;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Item retrieveItem(ComprehensionTlv comprehensionTlv) throws ResultException {
        Item item = null;
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = comprehensionTlv.getLength();
        if (n2 == 0) return item;
        int n3 = n2 - 1;
        try {
            int n4 = byArray[n] & 0xFF;
            int n5 = n + 1;
            String string2 = IccUtils.adnStringFieldToString(byArray, n5, n3);
            return new Item(n4, string2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
    }

    static int retrieveItemId(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            byte by = byArray[n];
            return by & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ItemsIconId retrieveItemsIconId(ComprehensionTlv var0) throws ResultException {
        block6: {
            StkLog.d("ValueParser", "retrieveItemsIconId:");
            var1_1 = new ItemsIconId();
            var2_2 = var0.getRawValue();
            var3_3 = var0.getValueIndex();
            var4_4 = var0.getLength() - 1;
            var5_5 = new int[var4_4];
            var1_1.recordNumbers = var5_5;
            var6_6 = var3_3 + 1;
            try {
                var7_7 = (var2_2[var3_3] & 255) == 0 ? null : null;
                var1_1.selfExplanatory = var7_7;
                var8_8 = 0;
lbl13:
                // 2 sources

                while (var8_8 < var4_4) {
                    var7_7 = var1_1.recordNumbers;
                    var9_9 = var8_8 + 1;
                    var3_3 = var6_6 + 1;
                    break block6;
                }
                return var1_1;
            }
            catch (IndexOutOfBoundsException var11_11) {
                var12_12 = var6_6;
lbl21:
                // 2 sources

                while (true) {
                    var13_13 = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
                    throw new ResultException(var13_13);
                }
            }
        }
        try {
            var7_7[var8_8] = var10_10 = var2_2[var6_6];
            var8_8 = var9_9;
            var6_6 = var3_3;
            ** GOTO lbl13
        }
        catch (IndexOutOfBoundsException var14_14) {
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<TextAttribute> retrieveTextAttribute(ComprehensionTlv comprehensionTlv) throws ResultException {
        ArrayList<TextAttribute> arrayList = new ArrayList<TextAttribute>();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = comprehensionTlv.getLength();
        if (n2 == 0) {
            int n3 = n;
            ArrayList<TextAttribute> arrayList2 = null;
            int n4 = n3;
            return arrayList2;
        }
        int n5 = n2 / 4;
        int n6 = 0;
        int n7 = n;
        while (true) {
            if (n6 >= n5) {
                int n8 = n7;
                return arrayList;
            }
            try {
                int n9 = byArray[n7] & 0xFF;
                int n10 = n7 + 1;
                int n11 = byArray[n10] & 0xFF;
                int n12 = n7 + 2;
                int n13 = byArray[n12] & 0xFF;
                int n14 = n7 + 3;
                n = byArray[n14] & 0xFF;
                TextAlignment textAlignment = TextAlignment.fromInt(n13 & 3);
                FontSize fontSize = FontSize.fromInt(n13 >> 2 & 3);
                if (fontSize == null) {
                    fontSize = FontSize.NORMAL;
                }
                boolean bl = (n13 & 0x10) != 0;
                boolean bl2 = (n13 & 0x20) != 0;
                boolean bl3 = (n13 & 0x40) != 0;
                n13 = (n13 & 0x80) != 0 ? 1 : 0;
                TextColor textColor = TextColor.fromInt(n);
                TextAttribute textAttribute = new TextAttribute(n9, n11, textAlignment, fontSize, bl, bl2, bl3, n13 != 0, textColor);
                boolean bl4 = arrayList.add(textAttribute);
                int n15 = n6 + 1;
                int n16 = n7 + 4;
                n6 = n15;
                n7 = n16;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ResultException resultException;
                ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
                ResultException resultException2 = resultException;
                ResultCode resultCode2 = resultCode;
                resultException2(resultCode2);
                throw resultException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String retrieveTextString(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        String string2 = null;
        int n2 = comprehensionTlv.getLength();
        if (n2 == 0) {
            return null;
        }
        n2 += -1;
        try {
            byte by = (byte)(byArray[n] & 0xC);
            if (by == null) {
                int n3 = n + 1;
                int n4 = n2 * 8 / 7;
                string2 = GsmAlphabet.gsm7BitPackedToString(byArray, n3, n4);
                return string2;
            }
            if (by == 4) {
                int n5 = n + 1;
                return GsmAlphabet.gsm8BitUnpackedToString(byArray, n5, n2);
            }
            if (by == 8) {
                int n6 = n + 1;
                return new String(byArray, n6, n2, "UTF-16");
            }
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ResultCode resultCode = ResultCode.CMD_DATA_NOT_UNDERSTOOD;
            throw new ResultException(resultCode);
        }
    }
}

