/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.net.sip.SipAudioCall;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;

abstract class SipConnectionBase
extends Connection {
    private static final String LOG_TAG = "SIP_CONN";
    private long connectTime;
    private long connectTimeReal;
    private long createTime;
    private String dialString;
    private long disconnectTime;
    private long duration = 65535L;
    private long holdingStartTime;
    private boolean isIncoming;
    private Connection.DisconnectCause mCause;
    private SipAudioCall mSipAudioCall;
    private int nextPostDialChar;
    private Connection.PostDialState postDialState;
    private String postDialString;

    SipConnectionBase(String string2) {
        long l;
        String string3;
        Connection.PostDialState postDialState;
        Connection.DisconnectCause disconnectCause;
        this.mCause = disconnectCause = Connection.DisconnectCause.NOT_DISCONNECTED;
        this.postDialState = postDialState = Connection.PostDialState.NOT_STARTED;
        this.dialString = string2;
        this.postDialString = string3 = PhoneNumberUtils.extractPostDialPortion(string2);
        this.isIncoming = false;
        this.createTime = l = System.currentTimeMillis();
    }

    private void log(String string2) {
        String string3 = "[SipConn] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    @Override
    public void cancelPostDial() {
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public Connection.DisconnectCause getDisconnectCause() {
        return this.mCause;
    }

    @Override
    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration >= 0L) return this.duration;
        long l = SystemClock.elapsedRealtime();
        long l2 = this.connectTimeReal;
        return l - l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getHoldDurationMillis() {
        Call.State state;
        Call.State state2 = this.getState();
        if (state2 != (state = Call.State.HOLDING)) {
            return 0L;
        }
        long l = SystemClock.elapsedRealtime();
        long l2 = this.holdingStartTime;
        return l - l2;
    }

    @Override
    public int getNumberPresentation() {
        return Connection.PRESENTATION_ALLOWED;
    }

    protected abstract Phone getPhone();

    @Override
    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getRemainingPostDialString() {
        int n;
        Connection.PostDialState postDialState = this.postDialState;
        Connection.PostDialState postDialState2 = Connection.PostDialState.CANCELLED;
        if (postDialState == postDialState2) return "";
        Connection.PostDialState postDialState3 = this.postDialState;
        Connection.PostDialState postDialState4 = Connection.PostDialState.COMPLETE;
        if (postDialState3 == postDialState4) return "";
        if (this.postDialString == null) return "";
        int n2 = this.postDialString.length();
        if (n2 <= (n = this.nextPostDialChar)) {
            return "";
        }
        String string2 = this.postDialString;
        int n3 = this.nextPostDialChar;
        return string2.substring(n3);
    }

    @Override
    public void proceedAfterWaitChar() {
    }

    @Override
    public void proceedAfterWildChar(String string2) {
    }

    void setDisconnectCause(Connection.DisconnectCause disconnectCause) {
        this.mCause = disconnectCause;
    }

    protected void setState(Call.State state) {
        long l;
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$Call$State;
        int n = state.ordinal();
        switch (nArray[n]) {
            default: {
                return;
            }
            case 1: {
                long l2;
                long l3;
                if (this.connectTime != 0L) {
                    return;
                }
                this.connectTimeReal = l3 = SystemClock.elapsedRealtime();
                this.connectTime = l2 = System.currentTimeMillis();
                return;
            }
            case 2: {
                long l4;
                long l5;
                this.duration = l5 = this.getDurationMillis();
                this.disconnectTime = l4 = System.currentTimeMillis();
                return;
            }
            case 3: 
        }
        this.holdingStartTime = l = SystemClock.elapsedRealtime();
    }
}

