/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioGroup;
import android.net.sip.SipAudioCall;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipCallBase;
import com.android.internal.telephony.sip.SipConnectionBase;
import com.android.internal.telephony.sip.SipPhoneBase;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;

public class SipPhone
extends SipPhoneBase {
    private static final boolean DEBUG = true;
    private static final String LOG_TAG = "SipPhone";
    private static final int TIMEOUT_ANSWER_CALL = 8;
    private static final int TIMEOUT_HOLD_CALL = 15;
    private static final int TIMEOUT_MAKE_CALL = 15;
    private SipCall backgroundCall;
    private SipCall foregroundCall;
    private SipProfile mProfile;
    private SipManager mSipManager;
    private SipCall ringingCall;

    SipPhone(Context context, PhoneNotifier phoneNotifier, SipProfile sipProfile) {
        super(context, phoneNotifier);
        SipManager sipManager;
        SipCall sipCall;
        SipCall sipCall2;
        SipCall sipCall3;
        SipCall sipCall4;
        SipCall sipCall5;
        SipCall sipCall6;
        this.ringingCall = sipCall6 = new SipCall();
        this.foregroundCall = sipCall5 = new SipCall();
        this.backgroundCall = sipCall4 = new SipCall();
        StringBuilder stringBuilder = new StringBuilder().append("new SipPhone: ");
        String string2 = sipProfile.getUriString();
        String string3 = stringBuilder.append(string2).toString();
        int n = Log.d(LOG_TAG, string3);
        this.ringingCall = sipCall3 = new SipCall();
        this.foregroundCall = sipCall2 = new SipCall();
        this.backgroundCall = sipCall = new SipCall();
        this.mProfile = sipProfile;
        this.mSipManager = sipManager = SipManager.newInstance(context);
    }

    private Connection dialInternal(String string2) throws CallStateException {
        Call.State state;
        Call.State state2;
        Call.State state3;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        Call.State state4 = this.foregroundCall.getState();
        if (state4 == (state3 = Call.State.ACTIVE)) {
            this.switchHoldingAndActive();
        }
        if ((state2 = this.foregroundCall.getState()) != (state = Call.State.IDLE)) {
            throw new CallStateException("cannot dial in current state");
        }
        this.foregroundCall.setMute(false);
        try {
            Connection connection = this.foregroundCall.dial(string2);
            return connection;
        }
        catch (SipException sipException) {
            int n = Log.e(LOG_TAG, "dial()", sipException);
            String string3 = "dial error: " + sipException;
            throw new CallStateException(string3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Call.State getCallStateFrom(SipAudioCall sipAudioCall) {
        if (sipAudioCall.isOnHold()) {
            return Call.State.HOLDING;
        }
        int n = sipAudioCall.getState();
        switch (n) {
            default: {
                String string2 = "illegal connection state: " + n;
                int n2 = Log.w(LOG_TAG, string2);
                return Call.State.DISCONNECTED;
            }
            case 0: {
                return Call.State.IDLE;
            }
            case 3: 
            case 4: {
                return Call.State.INCOMING;
            }
            case 5: {
                return Call.State.DIALING;
            }
            case 6: {
                return Call.State.ALERTING;
            }
            case 7: {
                return Call.State.DISCONNECTING;
            }
            case 8: 
        }
        return Call.State.ACTIVE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSipDomain(SipProfile sipProfile) {
        String string2 = sipProfile.getSipDomain();
        if (!string2.endsWith(":5060")) return string2;
        int n = string2.length() - 5;
        return string2.substring(0, n);
    }

    private String getUriString(SipProfile sipProfile) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = sipProfile.getUserName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("@");
        String string3 = this.getSipDomain(sipProfile);
        return stringBuilder2.append(string3).toString();
    }

    @Override
    public void acceptCall() throws CallStateException {
        synchronized (SipPhone.class) {
            Call.State state;
            Call.State state2;
            Call.State state3 = this.ringingCall.getState();
            Call.State state4 = Call.State.INCOMING;
            if (state3 == state4 || (state2 = this.ringingCall.getState()) == (state = Call.State.WAITING)) {
                int n = Log.d(LOG_TAG, "acceptCall");
                this.ringingCall.setMute(false);
                this.ringingCall.acceptCall();
                return;
            }
            throw new CallStateException("phone not ringing");
        }
    }

    @Override
    public boolean canConference() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTake(Object object) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (clazz) {
            if (!(object instanceof SipAudioCall)) {
                // ** MonitorExit[com.android.internal.telephony.sip.SipPhone.class] (shouldn't be in output)
                return (boolean)null;
            }
            if (this.ringingCall.getState().isAlive()) {
                // ** MonitorExit[com.android.internal.telephony.sip.SipPhone.class] (shouldn't be in output)
                return (boolean)null;
            }
            if (this.foregroundCall.getState().isAlive() && this.backgroundCall.getState().isAlive()) {
                // ** MonitorExit[com.android.internal.telephony.sip.SipPhone.class] (shouldn't be in output)
                return (boolean)null;
            }
            try {
                SipAudioCall sipAudioCall = (SipAudioCall)object;
                StringBuilder stringBuilder = new StringBuilder().append("+++ taking call from: ");
                String string2 = sipAudioCall.getPeerProfile().getUriString();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.d(LOG_TAG, string3);
                String string4 = sipAudioCall.getLocalProfile().getUriString();
                String string5 = this.mProfile.getUriString();
                if (!string4.equals(string5)) return (boolean)null;
                boolean bl = this.foregroundCall.getState().isAlive();
                this.ringingCall.initIncomingCall(sipAudioCall, bl);
                if (sipAudioCall.getState() == 3) return (boolean)null;
                int n2 = Log.d(LOG_TAG, "    call cancelled !!");
                this.ringingCall.reset();
                return (boolean)null;
            }
            catch (Exception exception) {
                this.ringingCall.reset();
            }
            return (boolean)null;
        }
    }

    @Override
    public boolean canTransfer() {
        return false;
    }

    @Override
    public void clearDisconnected() {
        synchronized (SipPhone.class) {
            this.ringingCall.clearDisconnected();
            this.foregroundCall.clearDisconnected();
            this.backgroundCall.clearDisconnected();
            this.updatePhoneState();
            this.notifyPreciseCallStateChanged();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void conference() throws CallStateException {
        synchronized (SipPhone.class) {
            Call.State state;
            Call.State state2;
            Call.State state3 = this.foregroundCall.getState();
            Call.State state4 = Call.State.ACTIVE;
            if (state3 == state4 && (state2 = this.foregroundCall.getState()) == (state = Call.State.ACTIVE)) {
                SipCall sipCall = this.foregroundCall;
                SipCall sipCall2 = this.backgroundCall;
                sipCall.merge(sipCall2);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("wrong state to merge calls: fg=");
            Call.State state5 = this.foregroundCall.getState();
            StringBuilder stringBuilder2 = stringBuilder.append((Object)state5).append(", bg=");
            Call.State state6 = this.backgroundCall.getState();
            String string2 = stringBuilder2.append((Object)state6).toString();
            throw new CallStateException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void conference(Call call) throws CallStateException {
        synchronized (SipPhone.class) {
            if (!(call instanceof SipCall)) {
                StringBuilder stringBuilder = new StringBuilder().append("expect ").append(SipCall.class).append(", cannot merge with ");
                Class<? extends Object> clazz = call.getClass();
                String string2 = stringBuilder.append(clazz).toString();
                throw new CallStateException(string2);
            }
            SipCall sipCall = this.foregroundCall;
            SipCall sipCall2 = (SipCall)call;
            sipCall.merge(sipCall2);
            return;
        }
    }

    @Override
    public Connection dial(String string2) throws CallStateException {
        synchronized (SipPhone.class) {
            Connection connection = this.dialInternal(string2);
            return connection;
        }
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        return this.dial(string2);
    }

    public boolean equals(SipPhone sipPhone) {
        String string2 = this.getSipUri();
        String string3 = sipPhone.getSipUri();
        return string2.equals(string3);
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
    }

    @Override
    public Call getBackgroundCall() {
        return this.backgroundCall;
    }

    @Override
    public void getCallWaiting(Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public Call getForegroundCall() {
        return this.foregroundCall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getMute() {
        if (!this.foregroundCall.getState().isAlive()) return this.backgroundCall.getMute();
        return this.foregroundCall.getMute();
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public String getPhoneName() {
        StringBuilder stringBuilder = new StringBuilder().append("SIP:");
        SipProfile sipProfile = this.mProfile;
        String string2 = this.getUriString(sipProfile);
        return stringBuilder.append(string2).toString();
    }

    @Override
    public Call getRingingCall() {
        return this.ringingCall;
    }

    @Override
    public ServiceState getServiceState() {
        return super.getServiceState();
    }

    public String getSipUri() {
        return this.mProfile.getUriString();
    }

    @Override
    public void rejectCall() throws CallStateException {
        synchronized (SipPhone.class) {
            if (this.ringingCall.getState().isRinging()) {
                int n = Log.d(LOG_TAG, "rejectCall");
                this.ringingCall.rejectCall();
                return;
            }
            throw new CallStateException("phone not ringing");
        }
    }

    public void sendBurstDtmf(String string2) {
        int n = Log.e(LOG_TAG, "[SipPhone] sendBurstDtmf() is a CDMA method");
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            String string2 = "sendDtmf called with invalid character '" + c + "'";
            int n = Log.e(LOG_TAG, string2);
            return;
        }
        if (!this.foregroundCall.getState().isAlive()) {
            return;
        }
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (clazz) {
            this.foregroundCall.sendDtmf(c);
            return;
        }
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        int n = Log.e(LOG_TAG, "call waiting not supported");
    }

    @Override
    public void setEchoSuppressionEnabled(boolean bl) {
        synchronized (SipPhone.class) {
            this.foregroundCall.setAudioGroupMode();
            return;
        }
    }

    @Override
    public void setMute(boolean bl) {
        synchronized (SipPhone.class) {
            this.foregroundCall.setMute(bl);
            return;
        }
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            String string2 = "startDtmf called with invalid character '" + c + "'";
            int n = Log.e(LOG_TAG, string2);
            return;
        }
        this.sendDtmf(c);
    }

    @Override
    public void stopDtmf() {
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        int n = Log.d(LOG_TAG, " ~~~~~~  switch fg and bg");
        synchronized (SipPhone.class) {
            SipCall sipCall = this.foregroundCall;
            SipCall sipCall2 = this.backgroundCall;
            sipCall.switchWith(sipCall2);
            if (this.backgroundCall.getState().isAlive()) {
                this.backgroundCall.hold();
            }
            if (this.foregroundCall.getState().isAlive()) {
                this.foregroundCall.unhold();
            }
            return;
        }
    }

    private abstract class SipAudioCallAdapter
    extends SipAudioCall.Listener {
        private SipAudioCallAdapter() {
        }

        @Override
        public void onCallBusy(SipAudioCall sipAudioCall) {
            Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.BUSY;
            this.onCallEnded(disconnectCause);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onCallEnded(SipAudioCall sipAudioCall) {
            Connection.DisconnectCause disconnectCause = sipAudioCall.isInCall() ? Connection.DisconnectCause.NORMAL : Connection.DisconnectCause.INCOMING_MISSED;
            this.onCallEnded(disconnectCause);
        }

        protected abstract void onCallEnded(Connection.DisconnectCause var1);

        @Override
        public void onError(SipAudioCall sipAudioCall, int n, String string2) {
            switch (n) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("error: ");
                    String string3 = SipErrorCode.toString(n);
                    String string4 = stringBuilder.append(string3).append(": ").append(string2).toString();
                    int n2 = Log.w(SipPhone.LOG_TAG, string4);
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.ERROR_UNSPECIFIED;
                    this.onError(disconnectCause);
                    return;
                }
                case -12: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.SERVER_UNREACHABLE;
                    this.onError(disconnectCause);
                    return;
                }
                case -7: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.NUMBER_UNREACHABLE;
                    this.onError(disconnectCause);
                    return;
                }
                case -6: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.INVALID_NUMBER;
                    this.onError(disconnectCause);
                    return;
                }
                case -5: 
                case -3: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.TIMED_OUT;
                    this.onError(disconnectCause);
                    return;
                }
                case -10: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.LOST_SIGNAL;
                    this.onError(disconnectCause);
                    return;
                }
                case -8: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.INVALID_CREDENTIALS;
                    this.onError(disconnectCause);
                    return;
                }
                case -11: {
                    Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.OUT_OF_NETWORK;
                    this.onError(disconnectCause);
                    return;
                }
                case -2: 
            }
            Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.SERVER_ERROR;
            this.onError(disconnectCause);
        }

        protected abstract void onError(Connection.DisconnectCause var1);
    }

    private class SipConnection
    extends SipConnectionBase {
        private SipAudioCallAdapter mAdapter;
        private boolean mIncoming;
        private String mOriginalNumber;
        private SipCall mOwner;
        private SipProfile mPeer;
        private SipAudioCall mSipAudioCall;
        private Call.State mState;
        final /* synthetic */ SipPhone this$0;

        public SipConnection(SipPhone sipPhone, SipCall sipCall, SipProfile sipProfile) {
            String string2 = sipPhone.getUriString(sipProfile);
            this(sipPhone, sipCall, sipProfile, string2);
        }

        public SipConnection(SipPhone sipPhone, SipCall sipCall, SipProfile sipProfile, String string2) {
            SipAudioCallAdapter sipAudioCallAdapter;
            Call.State state;
            this.this$0 = sipPhone;
            super(string2);
            this.mState = state = Call.State.IDLE;
            this.mIncoming = false;
            this.mAdapter = sipAudioCallAdapter = new SipAudioCallAdapter(){
                {
                    SipPhone sipPhone = SipConnection.this.this$0;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                protected void onCallEnded(Connection.DisconnectCause disconnectCause) {
                    Connection.DisconnectCause disconnectCause2;
                    Connection.DisconnectCause disconnectCause3 = SipConnection.this.getDisconnectCause();
                    if (disconnectCause3 != (disconnectCause2 = Connection.DisconnectCause.LOCAL)) {
                        SipConnection.this.setDisconnectCause(disconnectCause);
                    }
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (clazz) {
                        String string2;
                        SipConnection sipConnection = SipConnection.this;
                        Call.State state = Call.State.DISCONNECTED;
                        sipConnection.setState(state);
                        SipAudioCall sipAudioCall = SipConnection.this.mSipAudioCall;
                        SipAudioCall sipAudioCall2 = SipConnection.access$702(SipConnection.this, null);
                        if (sipAudioCall == null) {
                            string2 = "";
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            int n = sipAudioCall.getState();
                            string2 = stringBuilder.append(n).append(", ").toString();
                        }
                        StringBuilder stringBuilder = new StringBuilder().append("--- connection ended: ");
                        String string3 = SipConnection.this.mPeer.getUriString();
                        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(": ").append(string2).append("cause: ");
                        Connection.DisconnectCause disconnectCause4 = SipConnection.this.getDisconnectCause();
                        StringBuilder stringBuilder3 = stringBuilder2.append((Object)disconnectCause4).append(", on phone ");
                        Phone phone = SipConnection.this.getPhone();
                        String string4 = stringBuilder3.append(phone).toString();
                        int n = Log.d(SipPhone.LOG_TAG, string4);
                        if (sipAudioCall != null) {
                            sipAudioCall.setListener(null);
                            sipAudioCall.close();
                        }
                        SipCall sipCall = SipConnection.this.mOwner;
                        SipConnection sipConnection2 = SipConnection.this;
                        sipCall.onConnectionEnded(sipConnection2);
                        return;
                    }
                }

                @Override
                public void onCallEstablished(SipAudioCall sipAudioCall) {
                    this.onChanged(sipAudioCall);
                    Call.State state = SipConnection.this.mState;
                    Call.State state2 = Call.State.ACTIVE;
                    if (state != state2) {
                        return;
                    }
                    sipAudioCall.startAudio();
                }

                @Override
                public void onCallHeld(SipAudioCall sipAudioCall) {
                    this.onChanged(sipAudioCall);
                    Call.State state = SipConnection.this.mState;
                    Call.State state2 = Call.State.HOLDING;
                    if (state != state2) {
                        return;
                    }
                    sipAudioCall.startAudio();
                }

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onChanged(SipAudioCall sipAudioCall) {
                    synchronized (SipPhone.class) {
                        Call.State state = SipPhone.getCallStateFrom(sipAudioCall);
                        if (SipConnection.this.mState == state) {
                            return;
                        }
                        Call.State state2 = Call.State.INCOMING;
                        if (state == state2) {
                            SipConnection sipConnection = SipConnection.this;
                            Call.State state3 = SipConnection.this.mOwner.getState();
                            sipConnection.setState(state3);
                        } else {
                            SipCall sipCall;
                            SipCall sipCall2 = SipConnection.this.mOwner;
                            if (sipCall2 == (sipCall = SipConnection.this.this$0.ringingCall)) {
                                Call.State state4;
                                Call.State state5 = SipConnection.this.this$0.ringingCall.getState();
                                if (state5 == (state4 = Call.State.WAITING)) {
                                    SipConnection.this.this$0.switchHoldingAndActive();
                                }
                                SipCall sipCall3 = SipConnection.this.this$0.foregroundCall;
                                SipCall sipCall4 = SipConnection.this.this$0.ringingCall;
                                sipCall3.switchWith(sipCall4);
                            }
                            SipConnection.this.setState(state);
                        }
                        SipCall sipCall = SipConnection.this.mOwner;
                        SipConnection sipConnection = SipConnection.this;
                        sipCall.onConnectionStateChanged(sipConnection);
                        StringBuilder stringBuilder = new StringBuilder().append("+***+ connection state changed: ");
                        String string2 = SipConnection.this.mPeer.getUriString();
                        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(": ");
                        Call.State state6 = SipConnection.this.mState;
                        StringBuilder stringBuilder3 = stringBuilder2.append((Object)state6).append(" on phone ");
                        Phone phone = SipConnection.this.getPhone();
                        String string3 = stringBuilder3.append(phone).toString();
                        int n = Log.v(SipPhone.LOG_TAG, string3);
                        return;
                        catch (CallStateException callStateException) {
                            Connection.DisconnectCause disconnectCause = Connection.DisconnectCause.LOCAL;
                            this.onCallEnded(disconnectCause);
                            return;
                        }
                    }
                }

                @Override
                protected void onError(Connection.DisconnectCause disconnectCause) {
                    String string2 = "SIP error: " + (Object)((Object)disconnectCause);
                    int n = Log.d(SipPhone.LOG_TAG, string2);
                    this.onCallEnded(disconnectCause);
                }
            };
            this.mOwner = sipCall;
            this.mPeer = sipProfile;
            this.mOriginalNumber = string2;
        }

        static /* synthetic */ SipAudioCall access$702(SipConnection sipConnection, SipAudioCall sipAudioCall) {
            sipConnection.mSipAudioCall = sipAudioCall;
            return sipAudioCall;
        }

        void acceptCall() throws CallStateException {
            try {
                this.mSipAudioCall.answerCall(8);
                return;
            }
            catch (SipException sipException) {
                String string2 = "acceptCall(): " + sipException;
                throw new CallStateException(string2);
            }
        }

        void changeOwner(SipCall sipCall) {
            this.mOwner = sipCall;
        }

        void dial() throws SipException {
            SipAudioCall sipAudioCall;
            Call.State state = Call.State.DIALING;
            this.setState(state);
            SipManager sipManager = this.this$0.mSipManager;
            SipProfile sipProfile = this.this$0.mProfile;
            SipProfile sipProfile2 = this.mPeer;
            SipAudioCall sipAudioCall2 = this.mSipAudioCall = (sipAudioCall = sipManager.makeAudioCall(sipProfile, sipProfile2, null, 15));
            SipAudioCallAdapter sipAudioCallAdapter = this.mAdapter;
            sipAudioCall2.setListener(sipAudioCallAdapter);
        }

        @Override
        public String getAddress() {
            return this.mOriginalNumber;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        AudioGroup getAudioGroup() {
            if (this.mSipAudioCall != null) return this.mSipAudioCall.getAudioGroup();
            return null;
        }

        @Override
        public SipCall getCall() {
            return this.mOwner;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getCnapName() {
            String string2 = this.mPeer.getDisplayName();
            if (!TextUtils.isEmpty(string2)) return string2;
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean getMute() {
            if (this.mSipAudioCall != null) return this.mSipAudioCall.isMuted();
            return false;
        }

        @Override
        public int getNumberPresentation() {
            return Connection.PRESENTATION_ALLOWED;
        }

        @Override
        protected Phone getPhone() {
            return this.mOwner.getPhone();
        }

        @Override
        public Call.State getState() {
            return this.mState;
        }

        @Override
        public UUSInfo getUUSInfo() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void hangup() throws CallStateException {
            synchronized (SipPhone.class) {
                Connection.DisconnectCause disconnectCause;
                SipAudioCallAdapter sipAudioCallAdapter;
                StringBuilder stringBuilder = new StringBuilder().append("hangup conn: ");
                String string2 = this.mPeer.getUriString();
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(": ");
                Call.State state = this.mState;
                StringBuilder stringBuilder3 = stringBuilder2.append((Object)state).append(": on phone ");
                String string3 = this.getPhone().getPhoneName();
                String string4 = stringBuilder3.append(string3).toString();
                int n = Log.d(SipPhone.LOG_TAG, string4);
                if (!this.mState.isAlive()) {
                    return;
                }
                try {
                    Call.State state2;
                    Call.State state3;
                    SipAudioCall sipAudioCall = this.mSipAudioCall;
                    if (sipAudioCall != null) {
                        sipAudioCall.setListener(null);
                        sipAudioCall.endCall();
                    }
                    sipAudioCallAdapter = this.mAdapter;
                    Call.State state4 = this.mState;
                    Call.State state5 = Call.State.INCOMING;
                    disconnectCause = state4 == state5 || (state3 = this.mState) == (state2 = Call.State.WAITING) ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.LOCAL;
                }
                catch (SipException sipException) {
                    try {
                        String string5 = "hangup(): " + sipException;
                        throw new CallStateException(string5);
                    }
                    catch (Throwable throwable) {
                        Call.State state6;
                        Call.State state7;
                        SipAudioCallAdapter sipAudioCallAdapter2 = this.mAdapter;
                        Call.State state8 = this.mState;
                        Call.State state9 = Call.State.INCOMING;
                        Connection.DisconnectCause disconnectCause2 = state8 == state9 || (state7 = this.mState) == (state6 = Call.State.WAITING) ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.LOCAL;
                        sipAudioCallAdapter2.onCallEnded(disconnectCause2);
                        throw throwable;
                    }
                }
                sipAudioCallAdapter.onCallEnded(disconnectCause);
                return;
            }
        }

        void hold() throws CallStateException {
            Call.State state = Call.State.HOLDING;
            this.setState(state);
            try {
                this.mSipAudioCall.holdCall(15);
                return;
            }
            catch (SipException sipException) {
                String string2 = "hold(): " + sipException;
                throw new CallStateException(string2);
            }
        }

        void initIncomingCall(SipAudioCall sipAudioCall, Call.State state) {
            this.setState(state);
            this.mSipAudioCall = sipAudioCall;
            SipAudioCallAdapter sipAudioCallAdapter = this.mAdapter;
            sipAudioCall.setListener(sipAudioCallAdapter);
            this.mIncoming = true;
        }

        @Override
        public boolean isIncoming() {
            return this.mIncoming;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void separate() throws CallStateException {
            synchronized (SipPhone.class) {
                Call.State state;
                Phone phone = this.getPhone();
                SipPhone sipPhone = this.this$0;
                SipCall sipCall = phone == sipPhone ? (SipCall)this.this$0.getBackgroundCall() : (SipCall)this.this$0.getForegroundCall();
                Call.State state2 = sipCall.getState();
                if (state2 != (state = Call.State.IDLE)) {
                    StringBuilder stringBuilder = new StringBuilder().append("cannot put conn back to a call in non-idle state: ");
                    Call.State state3 = sipCall.getState();
                    String string2 = stringBuilder.append((Object)state3).toString();
                    throw new CallStateException(string2);
                }
                StringBuilder stringBuilder = new StringBuilder().append("separate conn: ");
                String string3 = this.mPeer.getUriString();
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" from ");
                SipCall sipCall2 = this.mOwner;
                String string4 = stringBuilder2.append(sipCall2).append(" back to ").append(sipCall).toString();
                int n = Log.d(SipPhone.LOG_TAG, string4);
                Phone phone2 = this.getPhone();
                AudioGroup audioGroup = sipCall.getAudioGroup();
                sipCall.add(this);
                this.mSipAudioCall.setAudioGroup(audioGroup);
                phone2.switchHoldingAndActive();
                SipCall sipCall3 = (SipCall)this.this$0.getForegroundCall();
                this.mSipAudioCall.startAudio();
                sipCall3.onConnectionStateChanged(this);
                return;
            }
        }

        void setMute(boolean bl) {
            if (this.mSipAudioCall == null) {
                return;
            }
            boolean bl2 = this.mSipAudioCall.isMuted();
            if (bl != bl2) {
                return;
            }
            this.mSipAudioCall.toggleMute();
        }

        @Override
        protected void setState(Call.State state) {
            Call.State state2 = this.mState;
            if (state == state2) {
                return;
            }
            super.setState(state);
            this.mState = state;
        }

        void unhold(AudioGroup audioGroup) throws CallStateException {
            this.mSipAudioCall.setAudioGroup(audioGroup);
            Call.State state = Call.State.ACTIVE;
            this.setState(state);
            try {
                this.mSipAudioCall.continueCall(15);
                return;
            }
            catch (SipException sipException) {
                String string2 = "unhold(): " + sipException;
                throw new CallStateException(string2);
            }
        }
    }

    private class SipCall
    extends SipCallBase {
        private SipCall() {
        }

        private void add(SipConnection sipConnection) {
            Call call = sipConnection.getCall();
            if (call == this) {
                return;
            }
            if (call != null) {
                boolean bl = ((SipCall)call).connections.remove(sipConnection);
            }
            boolean bl = this.connections.add(sipConnection);
            sipConnection.changeOwner(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int convertDtmf(char c) {
            int n = c - 48;
            if (n >= 0) {
                if (n <= 9) return n;
            }
            switch (c) {
                default: {
                    String string2 = "invalid DTMF char: " + c;
                    throw new IllegalArgumentException(string2);
                }
                case '*': {
                    return 10;
                }
                case '#': {
                    return 11;
                }
                case 'A': {
                    return 12;
                }
                case 'B': {
                    return 13;
                }
                case 'C': {
                    return 14;
                }
                case 'D': 
            }
            return 15;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private AudioGroup getAudioGroup() {
            if (!this.connections.isEmpty()) return ((SipConnection)this.connections.get(0)).getAudioGroup();
            return null;
        }

        private boolean isSpeakerOn() {
            return ((AudioManager)SipPhone.this.mContext.getSystemService("audio")).isSpeakerphoneOn();
        }

        private void takeOver(SipCall sipCall) {
            Call.State state;
            List list;
            this.connections = list = sipCall.connections;
            this.state = state = sipCall.state;
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).changeOwner(this);
            }
            return;
        }

        void acceptCall() throws CallStateException {
            SipCall sipCall = SipPhone.this.ringingCall;
            if (this != sipCall) {
                throw new CallStateException("acceptCall() in a non-ringing call");
            }
            if (this.connections.size() != 1) {
                throw new CallStateException("acceptCall() in a conf call");
            }
            ((SipConnection)this.connections.get(0)).acceptCall();
        }

        Connection dial(String string2) throws SipException {
            String string3 = string2;
            if (!string3.contains("@")) {
                String string4 = SipPhone.this.mProfile.getUriString();
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = SipPhone.this.mProfile.getUserName();
                String string6 = stringBuilder.append(string5).append("@").toString();
                String string7 = string3 + "@";
                string3 = string4.replaceFirst(string6, string7);
            }
            try {
                SipProfile sipProfile = new SipProfile.Builder(string3).build();
                SipPhone sipPhone = SipPhone.this;
                SipConnection sipConnection = new SipConnection(sipPhone, this, sipProfile, string2);
                sipConnection.dial();
                boolean bl = this.connections.add(sipConnection);
                Call.State state = Call.State.DIALING;
                this.setState(state);
                return sipConnection;
            }
            catch (ParseException parseException) {
                throw new SipException("dial", parseException);
            }
        }

        @Override
        public List<Connection> getConnections() {
            synchronized (SipPhone.class) {
                List list = this.connections;
                return list;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean getMute() {
            if (!this.connections.isEmpty()) return ((SipConnection)this.connections.get(0)).getMute();
            return false;
        }

        @Override
        public Phone getPhone() {
            return SipPhone.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void hangup() throws CallStateException {
            synchronized (SipPhone.class) {
                if (!this.state.isAlive()) {
                    StringBuilder stringBuilder = new StringBuilder().append("hang up dead call: ");
                    Call.State state = this.getState();
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)state).append(": ").append(this).append(" on phone ");
                    Phone phone = this.getPhone();
                    String string2 = stringBuilder2.append(phone).toString();
                    int n = Log.d("Call", string2);
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("hang up call: ");
                    Call.State state = this.getState();
                    StringBuilder stringBuilder3 = stringBuilder.append((Object)state).append(": ").append(this).append(" on phone ");
                    Phone phone = this.getPhone();
                    String string3 = stringBuilder3.append(phone).toString();
                    int n = Log.d("Call", string3);
                    Call.State state2 = Call.State.DISCONNECTING;
                    this.setState(state2);
                    Object var8_8 = null;
                    for (Connection connection : this.connections) {
                        try {
                            connection.hangup();
                        }
                        catch (CallStateException callStateException) {}
                    }
                    if (var8_8 != null) {
                        throw var8_8;
                    }
                }
                return;
            }
        }

        void hold() throws CallStateException {
            Call.State state = Call.State.HOLDING;
            this.setState(state);
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).hold();
            }
            this.setAudioGroupMode();
        }

        /*
         * Enabled aggressive block sorting
         */
        void initIncomingCall(SipAudioCall sipAudioCall, boolean bl) {
            SipProfile sipProfile = sipAudioCall.getPeerProfile();
            SipPhone sipPhone = SipPhone.this;
            SipConnection sipConnection = new SipConnection(sipPhone, this, sipProfile);
            boolean bl2 = this.connections.add(sipConnection);
            Call.State state = bl ? Call.State.WAITING : Call.State.INCOMING;
            sipConnection.initIncomingCall(sipAudioCall, state);
            this.setState(state);
            SipPhone.this.notifyNewRingingConnectionP(sipConnection);
        }

        void merge(SipCall sipCall) throws CallStateException {
            AudioGroup audioGroup = this.getAudioGroup();
            List list = sipCall.connections;
            Connection[] connectionArray = new Connection[sipCall.connections.size()];
            Connection[] connectionArray2 = list.toArray(connectionArray);
            int n = connectionArray2.length;
            for (int i = 0; i < n; ++i) {
                SipConnection sipConnection = (SipConnection)connectionArray2[i];
                this.add(sipConnection);
                Call.State state = sipConnection.getState();
                Call.State state2 = Call.State.HOLDING;
                if (state != state2) continue;
                sipConnection.unhold(audioGroup);
            }
            Call.State state = Call.State.IDLE;
            sipCall.setState(state);
        }

        void onConnectionEnded(SipConnection sipConnection) {
            Call.State state = this.state;
            Call.State state2 = Call.State.DISCONNECTED;
            if (state != state2) {
                boolean bl = true;
                StringBuilder stringBuilder = new StringBuilder().append("---check connections: ");
                int n = this.connections.size();
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.d("Call", string2);
                for (Connection connection : this.connections) {
                    Call.State state3;
                    StringBuilder stringBuilder2 = new StringBuilder().append("   state=");
                    Call.State state4 = connection.getState();
                    String string3 = stringBuilder2.append((Object)state4).append(": ").append(connection).toString();
                    int n3 = Log.d("Call", string3);
                    Call.State state5 = connection.getState();
                    if (state5 == (state3 = Call.State.DISCONNECTED)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    Call.State state6 = Call.State.DISCONNECTED;
                    this.setState(state6);
                }
            }
            SipPhone.this.notifyDisconnectP(sipConnection);
        }

        void onConnectionStateChanged(SipConnection sipConnection) {
            Call.State state = this.state;
            Call.State state2 = Call.State.ACTIVE;
            if (state == state2) {
                return;
            }
            Call.State state3 = sipConnection.getState();
            this.setState(state3);
        }

        void rejectCall() throws CallStateException {
            this.hangup();
        }

        void reset() {
            this.connections.clear();
            Call.State state = Call.State.IDLE;
            this.setState(state);
        }

        void sendDtmf(char c) {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                return;
            }
            int n = this.convertDtmf(c);
            audioGroup.sendDtmf(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        void setAudioGroupMode() {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                return;
            }
            int n = audioGroup.getMode();
            Call.State state = this.state;
            Call.State state2 = Call.State.HOLDING;
            if (state == state2) {
                audioGroup.setMode(0);
            } else if (this.getMute()) {
                audioGroup.setMode(1);
            } else if (this.isSpeakerOn()) {
                audioGroup.setMode(3);
            } else {
                audioGroup.setMode(2);
            }
            Object[] objectArray = new Object[2];
            Integer n2 = n;
            objectArray[0] = n2;
            Integer n3 = audioGroup.getMode();
            objectArray[1] = n3;
            String string2 = String.format("audioGroup mode change: %d --> %d", objectArray);
            int n4 = Log.d("Call", string2);
        }

        void setMute(boolean bl) {
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).setMute(bl);
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void setState(Call.State state) {
            if (this.state == state) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("+***+ call state changed: ");
            Call.State state2 = this.state;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)state2).append(" --> ").append((Object)state).append(": ").append(this).append(": on phone ");
            Phone phone = this.getPhone();
            StringBuilder stringBuilder3 = stringBuilder2.append(phone).append(" ");
            int n = this.connections.size();
            String string2 = stringBuilder3.append(n).toString();
            int n2 = Log.v("Call", string2);
            Call.State state3 = Call.State.ALERTING;
            if (state == state3) {
                this.state = state;
                SipPhone.this.startRingbackTone();
            } else {
                Call.State state4 = this.state;
                Call.State state5 = Call.State.ALERTING;
                if (state4 == state5) {
                    SipPhone.this.stopRingbackTone();
                }
            }
            this.state = state;
            SipPhone.this.updatePhoneState();
            SipPhone.this.notifyPreciseCallStateChanged();
        }

        void switchWith(SipCall sipCall) {
            synchronized (SipPhone.class) {
                SipPhone sipPhone = SipPhone.this;
                SipCall sipCall2 = sipPhone.new SipCall();
                sipCall2.takeOver(this);
                this.takeOver(sipCall);
                sipCall.takeOver(sipCall2);
                return;
            }
        }

        void unhold() throws CallStateException {
            Call.State state = Call.State.ACTIVE;
            this.setState(state);
            AudioGroup audioGroup = new AudioGroup();
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).unhold(audioGroup);
            }
            this.setAudioGroupMode();
        }
    }
}

