/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.sip.SipCommandInterface;
import java.util.ArrayList;
import java.util.List;

abstract class SipPhoneBase
extends PhoneBase {
    private static final String LOG_TAG = "SipPhone";
    private RegistrantList mRingbackRegistrants;
    private Phone.State state;

    public SipPhoneBase(Context context, PhoneNotifier phoneNotifier) {
        Phone.State state;
        RegistrantList registrantList;
        SipCommandInterface sipCommandInterface = new SipCommandInterface(context);
        super(phoneNotifier, context, sipCommandInterface, false);
        this.mRingbackRegistrants = registrantList = new RegistrantList();
        this.state = state = Phone.State.IDLE;
    }

    static void migrate(RegistrantList registrantList, RegistrantList registrantList2) {
        registrantList2.removeCleared();
        int n = 0;
        int n2 = registrantList2.size();
        while (n < n2) {
            Registrant registrant = (Registrant)registrantList2.get(n);
            registrantList.add(registrant);
            ++n;
        }
        return;
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        int n2 = Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDial() {
        int n = this.getServiceState().getState();
        String string2 = "canDial(): serviceState = " + n;
        int n2 = Log.v(LOG_TAG, string2);
        if (n == 3) {
            return false;
        }
        String string3 = SystemProperties.get("ro.telephony.disable-call", "false");
        String string4 = "canDial(): disableCall = " + string3;
        int n3 = Log.v(LOG_TAG, string4);
        if (string3.equals("true")) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder().append("canDial(): ringingCall: ");
        Call.State state = this.getRingingCall().getState();
        String string5 = stringBuilder.append((Object)state).toString();
        int n4 = Log.v(LOG_TAG, string5);
        StringBuilder stringBuilder2 = new StringBuilder().append("canDial(): foregndCall: ");
        Call.State state2 = this.getForegroundCall().getState();
        String string6 = stringBuilder2.append((Object)state2).toString();
        int n5 = Log.v(LOG_TAG, string6);
        StringBuilder stringBuilder3 = new StringBuilder().append("canDial(): backgndCall: ");
        Call.State state3 = this.getBackgroundCall().getState();
        String string7 = stringBuilder3.append((Object)state3).toString();
        int n6 = Log.v(LOG_TAG, string7);
        if (this.getRingingCall().isRinging()) return false;
        if (!this.getForegroundCall().getState().isAlive()) return true;
        if (this.getBackgroundCall().getState().isAlive()) return false;
        return true;
    }

    @Override
    public boolean disableDataConnectivity() {
        return false;
    }

    @Override
    public void disableLocationUpdates() {
    }

    @Override
    public boolean enableDataConnectivity() {
        return false;
    }

    @Override
    public void enableLocationUpdates() {
    }

    @Override
    public void getAvailableNetworks(Message message) {
    }

    @Override
    public abstract Call getBackgroundCall();

    @Override
    public boolean getCallForwardingIndicator() {
        return false;
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
    }

    @Override
    public void getCallWaiting(Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        int n = Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public CellLocation getCellLocation() {
        return null;
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return null;
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return Phone.DataActivityState.NONE;
    }

    @Override
    public void getDataCallList(Message message) {
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        return Phone.DataState.DISCONNECTED;
    }

    public Phone.DataState getDataConnectionState(String string2) {
        return Phone.DataState.DISCONNECTED;
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return false;
    }

    @Override
    public String getDeviceId() {
        return null;
    }

    @Override
    public String getDeviceSvn() {
        return null;
    }

    @Override
    public String getEsn() {
        int n = Log.e(LOG_TAG, "[SipPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public abstract Call getForegroundCall();

    @Override
    public IccCard getIccCard() {
        return null;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return null;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return null;
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return false;
    }

    @Override
    public String getIccSerialNumber() {
        return null;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return null;
    }

    @Override
    public String getLine1AlphaTag() {
        return null;
    }

    @Override
    public String getLine1Number() {
        return null;
    }

    @Override
    public String getMeid() {
        int n = Log.e(LOG_TAG, "[SipPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return false;
    }

    @Override
    public void getNeighboringCids(Message message) {
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return new ArrayList(0);
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return null;
    }

    @Override
    public int getPhoneType() {
        return 3;
    }

    @Override
    public abstract Call getRingingCall();

    @Override
    public ServiceState getServiceState() {
        ServiceState serviceState = new ServiceState();
        serviceState.setState(0);
        return serviceState;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return new SignalStrength();
    }

    @Override
    public Phone.State getState() {
        return this.state;
    }

    @Override
    public String getSubscriberId() {
        return null;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return null;
    }

    @Override
    public String getVoiceMailNumber() {
        return null;
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        return false;
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return false;
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isInCall() {
        Call.State state = this.getForegroundCall().getState();
        Call.State state2 = this.getBackgroundCall().getState();
        Call.State state3 = this.getRingingCall().getState();
        if (state.isAlive()) return true;
        if (state2.isAlive()) return true;
        if (!state3.isAlive()) return false;
        return true;
    }

    void migrateFrom(SipPhoneBase sipPhoneBase) {
        RegistrantList registrantList = this.mRingbackRegistrants;
        RegistrantList registrantList2 = sipPhoneBase.mRingbackRegistrants;
        SipPhoneBase.migrate(registrantList, registrantList2);
        RegistrantList registrantList3 = this.mPreciseCallStateRegistrants;
        RegistrantList registrantList4 = sipPhoneBase.mPreciseCallStateRegistrants;
        SipPhoneBase.migrate(registrantList3, registrantList4);
        RegistrantList registrantList5 = this.mNewRingingConnectionRegistrants;
        RegistrantList registrantList6 = sipPhoneBase.mNewRingingConnectionRegistrants;
        SipPhoneBase.migrate(registrantList5, registrantList6);
        RegistrantList registrantList7 = this.mIncomingRingRegistrants;
        RegistrantList registrantList8 = sipPhoneBase.mIncomingRingRegistrants;
        SipPhoneBase.migrate(registrantList7, registrantList8);
        RegistrantList registrantList9 = this.mDisconnectRegistrants;
        RegistrantList registrantList10 = sipPhoneBase.mDisconnectRegistrants;
        SipPhoneBase.migrate(registrantList9, registrantList10);
        RegistrantList registrantList11 = this.mServiceStateRegistrants;
        RegistrantList registrantList12 = sipPhoneBase.mServiceStateRegistrants;
        SipPhoneBase.migrate(registrantList11, registrantList12);
        RegistrantList registrantList13 = this.mMmiCompleteRegistrants;
        RegistrantList registrantList14 = sipPhoneBase.mMmiCompleteRegistrants;
        SipPhoneBase.migrate(registrantList13, registrantList14);
        RegistrantList registrantList15 = this.mMmiRegistrants;
        RegistrantList registrantList16 = sipPhoneBase.mMmiRegistrants;
        SipPhoneBase.migrate(registrantList15, registrantList16);
        RegistrantList registrantList17 = this.mUnknownConnectionRegistrants;
        RegistrantList registrantList18 = sipPhoneBase.mUnknownConnectionRegistrants;
        SipPhoneBase.migrate(registrantList17, registrantList18);
        RegistrantList registrantList19 = this.mSuppServiceFailedRegistrants;
        RegistrantList registrantList20 = sipPhoneBase.mSuppServiceFailedRegistrants;
        SipPhoneBase.migrate(registrantList19, registrantList20);
    }

    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    void notifyDisconnect(Connection connection) {
        this.mDisconnectRegistrants.notifyResult(connection);
    }

    void notifyNewRingingConnection(Connection connection) {
        super.notifyNewRingingConnectionP(connection);
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        super.notifyServiceStateChangedP(serviceState);
    }

    void notifySuppServiceFailed(Phone.SuppService suppService) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)suppService);
    }

    void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mRingbackRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
    }

    public void saveClirSetting(int n) {
    }

    @Override
    public void selectNetworkManually(NetworkInfo networkInfo, Message message) {
    }

    @Override
    public void sendUssdResponse(String string2) {
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        int n = Log.e(LOG_TAG, "call waiting not supported");
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        int n = Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void setRadioPower(boolean bl) {
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    protected void startRingbackTone() {
        Boolean bl = new Boolean(true);
        AsyncResult asyncResult = new AsyncResult(null, bl, null);
        this.mRingbackRegistrants.notifyRegistrants(asyncResult);
    }

    protected void stopRingbackTone() {
        Boolean bl = new Boolean(false);
        AsyncResult asyncResult = new AsyncResult(null, bl, null);
        this.mRingbackRegistrants.notifyRegistrants(asyncResult);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        this.mRingbackRegistrants.remove(handler);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
    }

    boolean updateCurrentCarrierInProvider() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updatePhoneState() {
        Phone.State state;
        Phone.State state2;
        Phone.State state3;
        Phone.State state4 = this.state;
        this.state = this.getRingingCall().isRinging() ? (state3 = Phone.State.RINGING) : (this.getForegroundCall().isIdle() && this.getBackgroundCall().isIdle() ? (state2 = Phone.State.IDLE) : (state = Phone.State.OFFHOOK));
        if (this.state == state4) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(" ^^^ new phone state: ");
        Phone.State state5 = this.state;
        String string2 = stringBuilder.append((Object)state5).toString();
        int n = Log.d(LOG_TAG, string2);
        this.notifyPhoneStateChanged();
    }

    @Override
    public void updateServiceLocation() {
    }
}

