/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.DriverCall;

class CallInfo {
    int TOA;
    boolean isMT;
    boolean isMpty;
    String number;
    State state;

    CallInfo(boolean bl, State state, boolean bl2, String string2) {
        this.isMT = bl;
        this.state = state;
        this.isMpty = bl2;
        this.number = string2;
        if (string2.length() > 0 && string2.charAt(0) == '+') {
            this.TOA = 145;
            return;
        }
        this.TOA = 129;
    }

    static CallInfo createIncomingCall(String string2) {
        State state = State.INCOMING;
        return new CallInfo(true, state, false, string2);
    }

    static CallInfo createOutgoingCall(String string2) {
        State state = State.DIALING;
        return new CallInfo(false, state, false, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isActiveOrHeld() {
        State state = this.state;
        State state2 = State.ACTIVE;
        if (state == state2) return true;
        State state3 = this.state;
        State state4 = State.HOLDING;
        if (state3 != state4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isConnecting() {
        State state = this.state;
        State state2 = State.DIALING;
        if (state == state2) return true;
        State state3 = this.state;
        State state4 = State.ALERTING;
        if (state3 != state4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRinging() {
        State state = this.state;
        State state2 = State.INCOMING;
        if (state == state2) return true;
        State state3 = this.state;
        State state4 = State.WAITING;
        if (state3 != state4) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    String toCLCCLine(int n) {
        StringBuilder stringBuilder = new StringBuilder().append("+CLCC: ").append(n).append(",");
        String string2 = this.isMT ? "1" : "0";
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(",");
        int n2 = this.state.value();
        StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(",0,");
        String string3 = this.isMpty ? "1" : "0";
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append(",\"");
        String string4 = this.number;
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\",");
        int n3 = this.TOA;
        return stringBuilder5.append(n3).toString();
    }

    DriverCall toDriverCall(int n) {
        int n2;
        String string2;
        boolean bl;
        boolean bl2;
        DriverCall driverCall = new DriverCall();
        driverCall.index = n;
        driverCall.isMT = bl2 = this.isMT;
        try {
            DriverCall.State state;
            driverCall.state = state = DriverCall.stateFromCLCC(this.state.value());
        }
        catch (ATParseEx aTParseEx) {
            throw new RuntimeException("should never happen", aTParseEx);
        }
        driverCall.isMpty = bl = this.isMpty;
        driverCall.number = string2 = this.number;
        driverCall.TOA = n2 = this.TOA;
        driverCall.isVoice = true;
        driverCall.als = 0;
        return driverCall;
    }

    static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ACTIVE = new State(0);
        public static final /* enum */ State ALERTING;
        public static final /* enum */ State DIALING;
        public static final /* enum */ State HOLDING;
        public static final /* enum */ State INCOMING;
        public static final /* enum */ State WAITING;
        private final int value;

        static {
            HOLDING = new State(1);
            DIALING = new State(2);
            ALERTING = new State(3);
            INCOMING = new State(4);
            WAITING = new State(5);
            State state = ACTIVE;
            State state2 = HOLDING;
            State state3 = DIALING;
            State state4 = ALERTING;
            State state5 = INCOMING;
            State state6 = WAITING;
            State[] stateArray = new State[]{state, state2, state3, state4, state5, state6};
            $VALUES = stateArray;
        }

        private State(int n2) {
            this.value = n2;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public int value() {
            return this.value;
        }
    }
}

