/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.android.internal.telephony.test.InterpreterEx;
import com.android.internal.telephony.test.LineReader;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

public class ModelInterpreter
implements Runnable,
SimulatedRadioControl {
    static final int CONNECTING_PAUSE_MSEC = 500;
    static final String LOG_TAG = "ModelInterpreter";
    static final int MAX_CALLS = 6;
    static final int PROGRESS_CALL_STATE = 1;
    static final String[][] sDefaultResponses;
    private String finalResponse;
    InputStream in;
    LineReader lineReader;
    HandlerThread mHandlerThread;
    OutputStream out;
    int pausedResponseCount;
    Object pausedResponseMonitor;
    SimulatedGsmCallState simulatedCallState;
    ServerSocket ss;

    static {
        String[] stringArray = new String[31];
        String[] stringArray2 = new String[]{"E0Q0V1", null};
        stringArray[0] = stringArray2;
        String[] stringArray3 = new String[]{"+CMEE=2", null};
        stringArray[1] = stringArray3;
        String[] stringArray4 = new String[]{"+CREG=2", null};
        stringArray[2] = stringArray4;
        String[] stringArray5 = new String[]{"+CGREG=2", null};
        stringArray[3] = stringArray5;
        String[] stringArray6 = new String[]{"+CCWA=1", null};
        stringArray[4] = stringArray6;
        String[] stringArray7 = new String[]{"+COPS=0", null};
        stringArray[5] = stringArray7;
        String[] stringArray8 = new String[]{"+CFUN=1", null};
        stringArray[6] = stringArray8;
        String[] stringArray9 = new String[]{"+CGMI", "+CGMI: Android Model AT Interpreter\r"};
        stringArray[7] = stringArray9;
        String[] stringArray10 = new String[]{"+CGMM", "+CGMM: Android Model AT Interpreter\r"};
        stringArray[8] = stringArray10;
        String[] stringArray11 = new String[]{"+CGMR", "+CGMR: 1.0\r"};
        stringArray[9] = stringArray11;
        String[] stringArray12 = new String[]{"+CGSN", "000000000000000\r"};
        stringArray[10] = stringArray12;
        String[] stringArray13 = new String[]{"+CIMI", "320720000000000\r"};
        stringArray[11] = stringArray13;
        String[] stringArray14 = new String[]{"+CSCS=?", "+CSCS: (\"HEX\",\"UCS2\")\r"};
        stringArray[12] = stringArray14;
        String[] stringArray15 = new String[]{"+CFUN?", "+CFUN: 1\r"};
        stringArray[13] = stringArray15;
        String[] stringArray16 = new String[]{"+COPS=3,0;+COPS?;+COPS=3,1;+COPS?;+COPS=3,2;+COPS?", "+COPS: 0,0,\"Android\"\r+COPS: 0,1,\"Android\"\r+COPS: 0,2,\"310995\"\r"};
        stringArray[14] = stringArray16;
        String[] stringArray17 = new String[]{"+CREG?", "+CREG: 2,5, \"0113\", \"6614\"\r"};
        stringArray[15] = stringArray17;
        String[] stringArray18 = new String[]{"+CGREG?", "+CGREG: 2,0\r"};
        stringArray[16] = stringArray18;
        String[] stringArray19 = new String[]{"+CSQ", "+CSQ: 16,99\r"};
        stringArray[17] = stringArray19;
        String[] stringArray20 = new String[]{"+CNMI?", "+CNMI: 1,2,2,1,1\r"};
        stringArray[18] = stringArray20;
        String[] stringArray21 = new String[]{"+CLIR?", "+CLIR: 1,3\r"};
        stringArray[19] = stringArray21;
        String[] stringArray22 = new String[]{"%CPVWI=2", "%CPVWI: 0\r"};
        stringArray[20] = stringArray22;
        String[] stringArray23 = new String[]{"+CUSD=1,\"#646#\"", "+CUSD=0,\"You have used 23 minutes\"\r"};
        stringArray[21] = stringArray23;
        String[] stringArray24 = new String[]{"+CRSM=176,12258,0,0,10", "+CRSM: 144,0,981062200050259429F6\r"};
        stringArray[22] = stringArray24;
        String[] stringArray25 = new String[]{"+CRSM=192,12258,0,0,15", "+CRSM: 144,0,0000000A2FE204000FF55501020000\r"};
        stringArray[23] = stringArray25;
        String[] stringArray26 = new String[]{"+CRSM=192,28474,0,0,15", "+CRSM: 144,0,0000005a6f3a040011f5220102011e\r"};
        stringArray[24] = stringArray26;
        String[] stringArray27 = new String[]{"+CRSM=178,28474,1,4,30", "+CRSM: 144,0,437573746f6d65722043617265ffffff07818100398799f7ffffffffffff\r"};
        stringArray[25] = stringArray27;
        String[] stringArray28 = new String[]{"+CRSM=178,28474,2,4,30", "+CRSM: 144,0,566f696365204d61696cffffffffffff07918150367742f3ffffffffffff\r"};
        stringArray[26] = stringArray28;
        String[] stringArray29 = new String[]{"+CRSM=178,28474,3,4,30", "+CRSM: 144,0,4164676a6dffffffffffffffffffffff0b918188551512c221436587ff01\r"};
        stringArray[27] = stringArray29;
        String[] stringArray30 = new String[]{"+CRSM=178,28474,4,4,30", "+CRSM: 144,0,810101c1ffffffffffffffffffffffff068114455245f8ffffffffffffff\r"};
        stringArray[28] = stringArray30;
        String[] stringArray31 = new String[]{"+CRSM=192,28490,0,0,15", "+CRSM: 144,0,000000416f4a040011f5550102010d\r"};
        stringArray[29] = stringArray31;
        String[] stringArray32 = new String[]{"+CRSM=178,28490,1,4,13", "+CRSM: 144,0,0206092143658709ffffffffff\r"};
        stringArray[30] = stringArray32;
        sDefaultResponses = stringArray;
    }

    public ModelInterpreter(InputStream inputStream, OutputStream outputStream) {
        Object object;
        this.pausedResponseMonitor = object = new Object();
        this.in = inputStream;
        this.out = outputStream;
        this.init();
    }

    public ModelInterpreter(InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocket serverSocket;
        Object object;
        this.pausedResponseMonitor = object = new Object();
        this.ss = serverSocket = new ServerSocket();
        this.ss.setReuseAddress(true);
        this.ss.bind(inetSocketAddress);
        this.init();
    }

    private void conference() throws InterpreterEx {
        if (this.simulatedCallState.conference()) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void init() {
        SimulatedGsmCallState simulatedGsmCallState;
        HandlerThread handlerThread;
        new Thread(this, LOG_TAG).start();
        this.mHandlerThread = handlerThread = new HandlerThread(LOG_TAG);
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.simulatedCallState = simulatedGsmCallState = new SimulatedGsmCallState(looper);
    }

    private void onAnswer() throws InterpreterEx {
        if (this.simulatedCallState.onAnswer()) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void onCHLD(String string2) throws InterpreterEx {
        char c = '\u0000';
        char c2 = string2.charAt(6);
        if (string2.length() >= 8) {
            c = string2.charAt(7);
        }
        if (this.simulatedCallState.onChld(c2, c)) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void onCLCC() throws InterpreterEx {
        List<String> list = this.simulatedCallState.getClccLines();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            String string2 = list.get(n);
            this.println(string2);
            ++n;
        }
        return;
    }

    private void onDial(String string2) throws InterpreterEx {
        SimulatedGsmCallState simulatedGsmCallState = this.simulatedCallState;
        String string3 = string2.substring(1);
        if (simulatedGsmCallState.onDial(string3)) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void onHangup() throws InterpreterEx {
        if (!this.simulatedCallState.onAnswer()) {
            throw new InterpreterEx("ERROR");
        }
        this.finalResponse = "NO CARRIER";
    }

    private void onSMSSend(String string2) throws InterpreterEx {
        this.print("> ");
        String string3 = this.lineReader.getNextLineCtrlZ();
        this.println("+CMGS: 1");
    }

    private void releaseActiveAcceptHeldOrWaiting() throws InterpreterEx {
        if (this.simulatedCallState.releaseActiveAcceptHeldOrWaiting()) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void releaseHeldOrUDUB() throws InterpreterEx {
        if (this.simulatedCallState.releaseHeldOrUDUB()) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void separateCall(int n) throws InterpreterEx {
        if (this.simulatedCallState.separateCall(n)) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    private void switchActiveAndHeldOrWaiting() throws InterpreterEx {
        if (this.simulatedCallState.switchActiveAndHeldOrWaiting()) {
            return;
        }
        throw new InterpreterEx("ERROR");
    }

    @Override
    public void pauseResponses() {
        Object object = this.pausedResponseMonitor;
        synchronized (object) {
            int n;
            this.pausedResponseCount = n = this.pausedResponseCount + 1;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void print(String string2) {
        synchronized (this) {
            try {
                byte[] byArray = string2.getBytes("US-ASCII");
                this.out.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void println(String string2) {
        synchronized (this) {
            try {
                byte[] byArray = string2.getBytes("US-ASCII");
                this.out.write(byArray);
                this.out.write(13);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    void processLine(String var1_1) throws InterpreterEx {
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            var2_2 = this.splitCommands(var1_1);
                            var3_3 = 0;
                            block0: while (true) {
                                if (var3_3 >= (var4_4 = var2_2.length)) {
                                    return;
                                }
                                var5_5 = var2_2[var3_3];
                                if (!var5_5.equals("A")) break;
                                this.onAnswer();
lbl9:
                                // 7 sources

                                while (true) {
                                    ++var3_3;
                                    continue block0;
                                    break;
                                }
                                break;
                            }
                            if (!var5_5.equals("H")) break block8;
                            this.onHangup();
                            ** GOTO lbl9
                        }
                        if (!var5_5.startsWith("+CHLD=")) break block9;
                        this.onCHLD(var5_5);
                        ** GOTO lbl9
                    }
                    if (!var5_5.equals("+CLCC")) break block10;
                    this.onCLCC();
                    ** GOTO lbl9
                }
                if (!var5_5.startsWith("D")) break block11;
                this.onDial(var5_5);
                ** GOTO lbl9
            }
            if (!var5_5.startsWith("+CMGS=")) break block12;
            this.onSMSSend(var5_5);
            ** GOTO lbl9
        }
        var6_6 = false;
        var7_7 = 0;
        while (true) {
            block14: {
                block13: {
                    if (var7_7 >= (var8_8 = ModelInterpreter.sDefaultResponses.length)) break block13;
                    var9_9 = ModelInterpreter.sDefaultResponses[var7_7][0];
                    if (!var5_5.equals(var9_9)) break block14;
                    var10_10 = ModelInterpreter.sDefaultResponses[var7_7][1];
                    if (var10_10 != null) {
                        this.println(var10_10);
                    }
                    var6_6 = true;
                }
                if (!var6_6) ** break;
                ** continue;
                throw new InterpreterEx("ERROR");
            }
            ++var7_7;
        }
    }

    @Override
    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
    }

    @Override
    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
    }

    @Override
    public void resumeResponses() {
        Object object = this.pausedResponseMonitor;
        synchronized (object) {
            int n;
            this.pausedResponseCount = n = this.pausedResponseCount - 1;
            if (this.pausedResponseCount == 0) {
                this.pausedResponseMonitor.notifyAll();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block14: while (true) {
            LineReader lineReader;
            block18: {
                Socket socket;
                if (this.ss == null) break block18;
                try {
                    Socket socket2;
                    socket = socket2 = this.ss.accept();
                }
                catch (IOException iOException) {
                    int n = Log.w(LOG_TAG, "IOException on socket.accept(); stopping", iOException);
                    return;
                }
                try {
                    OutputStream outputStream;
                    InputStream inputStream;
                    this.in = inputStream = socket.getInputStream();
                    this.out = outputStream = socket.getOutputStream();
                }
                catch (IOException iOException) {
                    int n = Log.w(LOG_TAG, "IOException on accepted socket(); re-listening", iOException);
                }
                int n = Log.i(LOG_TAG, "New connection accepted");
                break block18;
                continue;
            }
            InputStream inputStream = this.in;
            this.lineReader = lineReader = new LineReader(inputStream);
            this.println("Welcome");
            while (true) {
                int n;
                String string2;
                if ((string2 = this.lineReader.getNextLine()) == null) {
                    int n2 = Log.i(LOG_TAG, "Disconnected");
                    if (this.ss == null) return;
                    continue block14;
                }
                Object object = this.pausedResponseMonitor;
                // MONITORENTER : object
                while ((n = this.pausedResponseCount) > 0) {
                    try {
                        this.pausedResponseMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // MONITOREXIT : object
                // MONITORENTER : this
                try {
                    this.finalResponse = "OK";
                    this.processLine(string2);
                    String string3 = this.finalResponse;
                    this.println(string3);
                }
                catch (InterpreterEx interpreterEx) {
                    String string4 = interpreterEx.result;
                    this.println(string4);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    this.println("ERROR");
                }
            }
            break;
        }
    }

    public void sendUnsolicited(String string2) {
        synchronized (this) {
            this.println(string2);
            return;
        }
    }

    @Override
    public void setAutoProgressConnectingCall(boolean bl) {
        this.simulatedCallState.setAutoProgressConnectingCall(bl);
    }

    @Override
    public void setNextCallFailCause(int n) {
    }

    @Override
    public void setNextDialFailImmediately(boolean bl) {
        this.simulatedCallState.setNextDialFailImmediately(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdown() {
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {}
        try {
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String[] splitCommands(String string2) throws InterpreterEx {
        if (!string2.startsWith("AT")) {
            throw new InterpreterEx("ERROR");
        }
        if (string2.length() == 2) {
            return new String[0];
        }
        String string3 = string2.substring(2);
        String[] stringArray = new String[]{string3};
        return stringArray;
    }

    @Override
    public void triggerHangupAll() {
        if (!this.simulatedCallState.triggerHangupAll()) {
            return;
        }
        this.println("NO CARRIER");
    }

    @Override
    public void triggerHangupBackground() {
        if (!this.simulatedCallState.triggerHangupBackground()) {
            return;
        }
        this.println("NO CARRIER");
    }

    @Override
    public void triggerHangupForeground() {
        if (!this.simulatedCallState.triggerHangupForeground()) {
            return;
        }
        this.println("NO CARRIER");
    }

    @Override
    public void triggerIncomingSMS(String string2) {
    }

    @Override
    public void triggerIncomingUssd(String string2, String string3) {
    }

    @Override
    public void triggerRing(String string2) {
        synchronized (this) {
            if (this.simulatedCallState.triggerRing(string2)) {
                this.println("RING");
            }
            return;
        }
    }

    @Override
    public void triggerSsn(int n, int n2) {
    }
}

