/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.AsyncResult;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Registrant;
import android.util.Log;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.ArrayList;
import java.util.List;

public final class SimulatedCommands
extends BaseCommands
implements CommandsInterface,
SimulatedRadioControl {
    private static final String DEFAULT_SIM_PIN2_CODE = "5678";
    private static final String DEFAULT_SIM_PIN_CODE = "1234";
    private static final SimFdnState INITIAL_FDN_STATE;
    private static final SimLockState INITIAL_LOCK_STATE;
    private static final String LOG_TAG = "SIM";
    private static final String SIM_PUK2_CODE = "87654321";
    private static final String SIM_PUK_CODE = "12345678";
    HandlerThread mHandlerThread;
    int mNetworkType;
    String mPin2Code;
    int mPin2UnlockAttempts;
    String mPinCode;
    int mPinUnlockAttempts;
    int mPuk2UnlockAttempts;
    int mPukUnlockAttempts;
    boolean mSimFdnEnabled;
    SimFdnState mSimFdnEnabledState;
    boolean mSimLockEnabled;
    SimLockState mSimLockedState;
    boolean mSsnNotifyOn = false;
    int nextCallFailCause;
    int pausedResponseCount;
    ArrayList<Message> pausedResponses;
    SimulatedGsmCallState simulatedCallState;

    static {
        INITIAL_LOCK_STATE = SimLockState.NONE;
        INITIAL_FDN_STATE = SimFdnState.NONE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SimulatedCommands() {
        super(null);
        SimLockState simLockState;
        SimulatedGsmCallState simulatedGsmCallState;
        HandlerThread handlerThread;
        ArrayList arrayList = new ArrayList();
        this.pausedResponses = arrayList;
        this.nextCallFailCause = 16;
        this.mHandlerThread = handlerThread = new HandlerThread("SimulatedCommands");
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.simulatedCallState = simulatedGsmCallState = new SimulatedGsmCallState(looper);
        CommandsInterface.RadioState radioState = CommandsInterface.RadioState.RADIO_OFF;
        this.setRadioState(radioState);
        SimLockState simLockState2 = this.mSimLockedState = (simLockState = INITIAL_LOCK_STATE);
        SimLockState simLockState3 = SimLockState.NONE;
        boolean bl = simLockState2 != simLockState3;
        this.mSimLockEnabled = bl;
        this.mPinCode = DEFAULT_SIM_PIN_CODE;
        SimFdnState simFdnState = INITIAL_FDN_STATE;
        this.mSimFdnEnabledState = simFdnState;
        SimFdnState simFdnState2 = this.mSimFdnEnabledState;
        SimFdnState simFdnState3 = SimFdnState.NONE;
        boolean bl2 = simFdnState2 != simFdnState3;
        this.mSimFdnEnabled = bl2;
        this.mPin2Code = DEFAULT_SIM_PIN2_CODE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSimLocked() {
        SimLockState simLockState = this.mSimLockedState;
        SimLockState simLockState2 = SimLockState.NONE;
        if (simLockState == simLockState2) return false;
        return true;
    }

    private void resultFail(Message message, Throwable throwable) {
        if (message == null) {
            return;
        }
        AsyncResult.forMessage((Message)message).exception = throwable;
        if (this.pausedResponseCount > 0) {
            boolean bl = this.pausedResponses.add(message);
            return;
        }
        message.sendToTarget();
    }

    private void resultSuccess(Message message, Object object) {
        if (message == null) {
            return;
        }
        AsyncResult.forMessage((Message)message).result = object;
        if (this.pausedResponseCount > 0) {
            boolean bl = this.pausedResponses.add(message);
            return;
        }
        message.sendToTarget();
    }

    private void unimplemented(Message message) {
        if (message == null) {
            return;
        }
        AsyncResult asyncResult = AsyncResult.forMessage(message);
        RuntimeException runtimeException = new RuntimeException("Unimplemented");
        asyncResult.exception = runtimeException;
        if (this.pausedResponseCount > 0) {
            boolean bl = this.pausedResponses.add(message);
            return;
        }
        message.sendToTarget();
    }

    @Override
    public void acceptCall(Message message) {
        if (!this.simulatedCallState.onAnswer()) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        String string4;
        if (string2 != null && string2.equals(string4 = this.mPinCode)) {
            this.mPinCode = string3;
            if (message == null) {
                return;
            }
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) {
            return;
        }
        int n = Log.i(LOG_TAG, "[SimCmd] changeIccPin: pin failed!");
        CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
        CommandException commandException = new CommandException(error);
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
        message.sendToTarget();
    }

    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        String string4;
        if (string2 != null && string2.equals(string4 = this.mPin2Code)) {
            this.mPin2Code = string3;
            if (message == null) {
                return;
            }
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) {
            return;
        }
        int n = Log.i(LOG_TAG, "[SimCmd] changeIccPin2: pin2 failed!");
        CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
        CommandException commandException = new CommandException(error);
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
        message.sendToTarget();
    }

    @Override
    public void conference(Message message) {
        if (!this.simulatedCallState.onChld('3', '\u0000')) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void deactivateDataCall(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void deactivateDefaultPDP(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        String string2 = "Delete RUIM message at index " + n;
        int n2 = Log.d(LOG_TAG, string2);
        this.unimplemented(message);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        String string2 = "Delete message at index " + n;
        int n2 = Log.d(LOG_TAG, string2);
        this.unimplemented(message);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        boolean bl = this.simulatedCallState.onDial(string2);
        this.resultSuccess(message, null);
    }

    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        boolean bl = this.simulatedCallState.onDial(string2);
        this.resultSuccess(message, null);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        if (!this.simulatedCallState.onChld('4', '\u0000')) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    public void forceDataDormancy(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getBasebandVersion(Message message) {
        this.resultSuccess(message, "SimulatedCommands");
    }

    @Override
    public void getCDMASubscription(Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void getCLIR(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getCurrentCalls(Message message) {
        CommandsInterface.RadioState radioState = this.mState;
        CommandsInterface.RadioState radioState2 = CommandsInterface.RadioState.SIM_READY;
        if (radioState == radioState2) {
            List<DriverCall> list = this.simulatedCallState.getDriverCalls();
            this.resultSuccess(message, list);
            return;
        }
        CommandException.Error error = CommandException.Error.RADIO_NOT_AVAILABLE;
        CommandException commandException = new CommandException(error);
        this.resultFail(message, commandException);
    }

    @Override
    public void getDataCallList(Message message) {
        ArrayList arrayList = new ArrayList(0);
        this.resultSuccess(message, arrayList);
    }

    @Override
    public void getDeviceIdentity(Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void getGPRSRegistrationState(Message message) {
        String[] stringArray = new String[]{"5", null, null, "2"};
        this.resultSuccess(message, stringArray);
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getIMEI(Message message) {
        this.resultSuccess(message, "012345678901234");
    }

    @Override
    public void getIMEISV(Message message) {
        this.resultSuccess(message, "99");
    }

    @Override
    public void getIMSI(Message message) {
        this.resultSuccess(message, "012345678901234");
    }

    @Override
    public void getIccCardStatus(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        int n = this.nextCallFailCause;
        int[] nArray = new int[]{n};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getLastPdpFailCause(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getMute(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getNeighboringCids(Message message) {
        int[] nArray = new int[7];
        nArray[0] = 6;
        for (int i = 1; i < 7; ++i) {
            nArray[i] = i;
        }
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        int[] nArray = new int[]{0};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getOperator(Message message) {
        String[] stringArray = new String[]{"El Telco Loco", "Telco Loco", "001001"};
        this.resultSuccess(message, stringArray);
    }

    @Override
    public void getPDPContextList(Message message) {
        this.getDataCallList(message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        int n = this.mNetworkType;
        int[] nArray = new int[]{n};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void getRegistrationState(Message message) {
        String[] stringArray = new String[]{"5", null, null, null, null, null, null, null, null, null, null, null, null, null};
        this.resultSuccess(message, stringArray);
    }

    @Override
    public void getSignalStrength(Message message) {
        int[] nArray = new int[]{23, 0};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getSmscAddress(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        SimulatedGsmCallState simulatedGsmCallState = this.simulatedCallState;
        char c = (char)(n + 48);
        if (!simulatedGsmCallState.onChld('1', c)) {
            int n2 = Log.i("GSM", "[SimCmd] hangupConnection: resultFail");
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        int n3 = Log.i("GSM", "[SimCmd] hangupConnection: resultSuccess");
        this.resultSuccess(message, null);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        if (!this.simulatedCallState.onChld('1', '\u0000')) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        if (!this.simulatedCallState.onChld('0', '\u0000')) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        if (message == null) {
            return;
        }
        AsyncResult.forMessage((Message)message).result = byArray;
        message.sendToTarget();
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        if (message == null) {
            return;
        }
        AsyncResult.forMessage((Message)message).result = stringArray;
        message.sendToTarget();
    }

    @Override
    public void pauseResponses() {
        int n;
        this.pausedResponseCount = n = this.pausedResponseCount + 1;
    }

    @Override
    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        int[] nArray = new int[]{4, 2, 3, 4};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void queryCLIP(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        if (string2 != null && string2.equals("SC")) {
            if (message == null) {
                return;
            }
            int[] nArray = new int[1];
            int n2 = this.mSimLockEnabled ? 1 : 0;
            nArray[0] = n2;
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] queryFacilityLock: SIM is ");
            String string4 = nArray[0] == 0 ? "unlocked" : "locked";
            String string5 = stringBuilder.append(string4).toString();
            int n3 = Log.i(LOG_TAG, string5);
            AsyncResult asyncResult = AsyncResult.forMessage(message, nArray, null);
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals("FD")) {
            if (message == null) {
                return;
            }
            int[] nArray = new int[1];
            int n4 = this.mSimFdnEnabled ? 1 : 0;
            nArray[0] = n4;
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] queryFacilityLock: FDN is ");
            String string6 = nArray[0] == 0 ? "disabled" : "enabled";
            String string7 = stringBuilder.append(string6).toString();
            int n5 = Log.i(LOG_TAG, string7);
            AsyncResult asyncResult = AsyncResult.forMessage(message, nArray, null);
            message.sendToTarget();
            return;
        }
        this.unimplemented(message);
    }

    @Override
    public void queryTTYMode(Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void rejectCall(Message message) {
        if (!this.simulatedCallState.onChld('0', '\u0000')) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void resetRadio(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void resumeResponses() {
        int n;
        this.pausedResponseCount = n = this.pausedResponseCount - 1;
        if (this.pausedResponseCount == 0) {
            int n2 = this.pausedResponses.size();
            for (int i = 0; i < n2; ++i) {
                this.pausedResponses.get(i).sendToTarget();
            }
            this.pausedResponses.clear();
            return;
        }
        int n3 = Log.e("GSM", "SimulatedCommands.resumeResponses < 0");
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
    }

    @Override
    public void sendDtmf(char c, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        if (string2.equals("#646#")) {
            this.resultSuccess(message, null);
            this.triggerIncomingUssd("0", "You have NNN minutes remaining.");
            return;
        }
        this.resultSuccess(message, null);
        this.triggerIncomingUssd("0", "All Done");
    }

    @Override
    public void separateConnection(int n, Message message) {
        char c = (char)(n + 48);
        if (!this.simulatedCallState.onChld('2', c)) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void setAutoProgressConnectingCall(boolean bl) {
        this.simulatedCallState.setAutoProgressConnectingCall(bl);
    }

    @Override
    public void setBandMode(int n, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void setCLIR(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCdmaBroadcastConfig(int[] nArray, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        int n2 = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        int n2 = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        if (string2 != null && string2.equals("SC")) {
            String string4;
            if (string3 != null && string3.equals(string4 = this.mPinCode)) {
                int n2 = Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin is valid");
                this.mSimLockEnabled = bl;
                if (message == null) {
                    return;
                }
                AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
                message.sendToTarget();
                return;
            }
            if (message == null) {
                return;
            }
            int n3 = Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin failed!");
            CommandException.Error error = CommandException.Error.GENERIC_FAILURE;
            CommandException commandException = new CommandException(error);
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals("FD")) {
            String string5;
            if (string3 != null && string3.equals(string5 = this.mPin2Code)) {
                int n4 = Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 is valid");
                this.mSimFdnEnabled = bl;
                if (message == null) {
                    return;
                }
                AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
                message.sendToTarget();
                return;
            }
            if (message == null) {
                return;
            }
            int n5 = Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 failed!");
            CommandException.Error error = CommandException.Error.GENERIC_FAILURE;
            CommandException commandException = new CommandException(error);
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
            message.sendToTarget();
            return;
        }
        this.unimplemented(message);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setMute(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setNextCallFailCause(int n) {
        this.nextCallFailCause = n;
    }

    @Override
    public void setNextDialFailImmediately(boolean bl) {
        this.simulatedCallState.setNextDialFailImmediately(bl);
    }

    @Override
    public void setPhoneType(int n) {
        int n2 = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        this.mNetworkType = n;
        this.resultSuccess(message, null);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        int n = Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setRadioPower(boolean bl, Message message) {
        if (bl) {
            if (this.isSimLocked()) {
                StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] setRadioPower: SIM locked! state=");
                SimLockState simLockState = this.mSimLockedState;
                String string2 = stringBuilder.append((Object)simLockState).toString();
                int n = Log.i(LOG_TAG, string2);
                CommandsInterface.RadioState radioState = CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT;
                this.setRadioState(radioState);
                return;
            }
            CommandsInterface.RadioState radioState = CommandsInterface.RadioState.SIM_READY;
            this.setRadioState(radioState);
            return;
        }
        CommandsInterface.RadioState radioState = CommandsInterface.RadioState.RADIO_OFF;
        this.setRadioState(radioState);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        this.resultSuccess(message, null);
        if (bl && this.mSsnNotifyOn) {
            int n = Log.w(LOG_TAG, "Supp Service Notifications already enabled!");
        }
        this.mSsnNotifyOn = bl;
    }

    @Override
    public void setTTYMode(int n, Message message) {
        int n2 = Log.w(LOG_TAG, "Not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setupDataCall(String string2, String string3, String string4, String string5, String string6, String string7, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setupDefaultPDP(String string2, String string3, String string4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void shutdown() {
        CommandsInterface.RadioState radioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        this.setRadioState(radioState);
        Looper looper = this.mHandlerThread.getLooper();
        if (looper == null) {
            return;
        }
        looper.quit();
    }

    @Override
    public void startDtmf(char c, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void stopDtmf(Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void supplyIccPin(String string2, Message message) {
        int n;
        String string3;
        SimLockState simLockState = this.mSimLockedState;
        SimLockState simLockState2 = SimLockState.REQUIRE_PIN;
        if (simLockState != simLockState2) {
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPin: wrong state, state=");
            SimLockState simLockState3 = this.mSimLockedState;
            String string4 = stringBuilder.append((Object)simLockState3).toString();
            int n2 = Log.i(LOG_TAG, string4);
            CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
            CommandException commandException = new CommandException(error);
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals(string3 = this.mPinCode)) {
            SimLockState simLockState4;
            int n3 = Log.i(LOG_TAG, "[SimCmd] supplyIccPin: success!");
            CommandsInterface.RadioState radioState = CommandsInterface.RadioState.SIM_READY;
            this.setRadioState(radioState);
            this.mPinUnlockAttempts = 0;
            this.mSimLockedState = simLockState4 = SimLockState.NONE;
            if (message == null) {
                return;
            }
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) {
            return;
        }
        this.mPinUnlockAttempts = n = this.mPinUnlockAttempts + 1;
        StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPin: failed! attempt=");
        int n4 = this.mPinUnlockAttempts;
        String string5 = stringBuilder.append(n4).toString();
        int n5 = Log.i(LOG_TAG, string5);
        if (this.mPinUnlockAttempts >= 3) {
            SimLockState simLockState5;
            int n6 = Log.i(LOG_TAG, "[SimCmd] supplyIccPin: set state to REQUIRE_PUK");
            this.mSimLockedState = simLockState5 = SimLockState.REQUIRE_PUK;
        }
        CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
        CommandException commandException = new CommandException(error);
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
        message.sendToTarget();
    }

    @Override
    public void supplyIccPin2(String string2, Message message) {
        int n;
        String string3;
        SimFdnState simFdnState = this.mSimFdnEnabledState;
        SimFdnState simFdnState2 = SimFdnState.REQUIRE_PIN2;
        if (simFdnState != simFdnState2) {
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPin2: wrong state, state=");
            SimFdnState simFdnState3 = this.mSimFdnEnabledState;
            String string4 = stringBuilder.append((Object)simFdnState3).toString();
            int n2 = Log.i(LOG_TAG, string4);
            CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
            CommandException commandException = new CommandException(error);
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals(string3 = this.mPin2Code)) {
            SimFdnState simFdnState4;
            int n3 = Log.i(LOG_TAG, "[SimCmd] supplyIccPin2: success!");
            this.mPin2UnlockAttempts = 0;
            this.mSimFdnEnabledState = simFdnState4 = SimFdnState.NONE;
            if (message == null) {
                return;
            }
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) {
            return;
        }
        this.mPin2UnlockAttempts = n = this.mPin2UnlockAttempts + 1;
        StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPin2: failed! attempt=");
        int n4 = this.mPin2UnlockAttempts;
        String string5 = stringBuilder.append(n4).toString();
        int n5 = Log.i(LOG_TAG, string5);
        if (this.mPin2UnlockAttempts >= 3) {
            SimFdnState simFdnState5;
            int n6 = Log.i(LOG_TAG, "[SimCmd] supplyIccPin2: set state to REQUIRE_PUK2");
            this.mSimFdnEnabledState = simFdnState5 = SimFdnState.REQUIRE_PUK2;
        }
        CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
        CommandException commandException = new CommandException(error);
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
        message.sendToTarget();
    }

    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        int n;
        SimLockState simLockState = this.mSimLockedState;
        SimLockState simLockState2 = SimLockState.REQUIRE_PUK;
        if (simLockState != simLockState2) {
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPuk: wrong state, state=");
            SimLockState simLockState3 = this.mSimLockedState;
            String string4 = stringBuilder.append((Object)simLockState3).toString();
            int n2 = Log.i(LOG_TAG, string4);
            CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
            CommandException commandException = new CommandException(error);
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals(SIM_PUK_CODE)) {
            SimLockState simLockState4;
            int n3 = Log.i(LOG_TAG, "[SimCmd] supplyIccPuk: success!");
            CommandsInterface.RadioState radioState = CommandsInterface.RadioState.SIM_READY;
            this.setRadioState(radioState);
            this.mSimLockedState = simLockState4 = SimLockState.NONE;
            this.mPukUnlockAttempts = 0;
            if (message == null) {
                return;
            }
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) {
            return;
        }
        this.mPukUnlockAttempts = n = this.mPukUnlockAttempts + 1;
        StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPuk: failed! attempt=");
        int n4 = this.mPukUnlockAttempts;
        String string5 = stringBuilder.append(n4).toString();
        int n5 = Log.i(LOG_TAG, string5);
        if (this.mPukUnlockAttempts >= 10) {
            SimLockState simLockState5;
            int n6 = Log.i(LOG_TAG, "[SimCmd] supplyIccPuk: set state to SIM_PERM_LOCKED");
            this.mSimLockedState = simLockState5 = SimLockState.SIM_PERM_LOCKED;
        }
        CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
        CommandException commandException = new CommandException(error);
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
        message.sendToTarget();
    }

    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        int n;
        SimFdnState simFdnState = this.mSimFdnEnabledState;
        SimFdnState simFdnState2 = SimFdnState.REQUIRE_PUK2;
        if (simFdnState != simFdnState2) {
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPuk2: wrong state, state=");
            SimLockState simLockState = this.mSimLockedState;
            String string4 = stringBuilder.append((Object)simLockState).toString();
            int n2 = Log.i(LOG_TAG, string4);
            CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
            CommandException commandException = new CommandException(error);
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals(SIM_PUK2_CODE)) {
            SimFdnState simFdnState3;
            int n3 = Log.i(LOG_TAG, "[SimCmd] supplyIccPuk2: success!");
            this.mSimFdnEnabledState = simFdnState3 = SimFdnState.NONE;
            this.mPuk2UnlockAttempts = 0;
            if (message == null) {
                return;
            }
            AsyncResult asyncResult = AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) {
            return;
        }
        this.mPuk2UnlockAttempts = n = this.mPuk2UnlockAttempts + 1;
        StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] supplyIccPuk2: failed! attempt=");
        int n4 = this.mPuk2UnlockAttempts;
        String string5 = stringBuilder.append(n4).toString();
        int n5 = Log.i(LOG_TAG, string5);
        if (this.mPuk2UnlockAttempts >= 10) {
            SimFdnState simFdnState4;
            int n6 = Log.i(LOG_TAG, "[SimCmd] supplyIccPuk2: set state to SIM_PERM_LOCKED");
            this.mSimFdnEnabledState = simFdnState4 = SimFdnState.SIM_PERM_LOCKED;
        }
        CommandException.Error error = CommandException.Error.PASSWORD_INCORRECT;
        CommandException commandException = new CommandException(error);
        AsyncResult asyncResult = AsyncResult.forMessage(message, null, commandException);
        message.sendToTarget();
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        if (!this.simulatedCallState.onChld('2', '\u0000')) {
            RuntimeException runtimeException = new RuntimeException("Hangup Error");
            this.resultFail(message, runtimeException);
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void triggerHangupAll() {
        boolean bl = this.simulatedCallState.triggerHangupAll();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerHangupBackground() {
        boolean bl = this.simulatedCallState.triggerHangupBackground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerHangupForeground() {
        boolean bl = this.simulatedCallState.triggerHangupForeground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerIncomingSMS(String string2) {
    }

    @Override
    public void triggerIncomingUssd(String string2, String string3) {
        if (this.mUSSDRegistrant == null) {
            return;
        }
        String[] stringArray = new String[]{string2, string3};
        this.mUSSDRegistrant.notifyResult(stringArray);
    }

    @Override
    public void triggerRing(String string2) {
        boolean bl = this.simulatedCallState.triggerRing(string2);
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerSsn(int n, int n2) {
        SuppServiceNotification suppServiceNotification = new SuppServiceNotification();
        suppServiceNotification.notificationType = n;
        suppServiceNotification.code = n2;
        Registrant registrant = this.mSsnRegistrant;
        AsyncResult asyncResult = new AsyncResult(null, suppServiceNotification, null);
        registrant.notifyRegistrant(asyncResult);
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        String string3 = "Write SMS to RUIM with status " + n;
        int n2 = Log.d(LOG_TAG, string3);
        this.unimplemented(message);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        String string4 = "Write SMS to SIM with status " + n;
        int n2 = Log.d(LOG_TAG, string4);
        this.unimplemented(message);
    }

    private static final class SimFdnState
    extends Enum<SimFdnState> {
        private static final /* synthetic */ SimFdnState[] $VALUES;
        public static final /* enum */ SimFdnState NONE = new SimFdnState();
        public static final /* enum */ SimFdnState REQUIRE_PIN2 = new SimFdnState();
        public static final /* enum */ SimFdnState REQUIRE_PUK2 = new SimFdnState();
        public static final /* enum */ SimFdnState SIM_PERM_LOCKED = new SimFdnState();

        static {
            SimFdnState simFdnState = NONE;
            SimFdnState simFdnState2 = REQUIRE_PIN2;
            SimFdnState simFdnState3 = REQUIRE_PUK2;
            SimFdnState simFdnState4 = SIM_PERM_LOCKED;
            SimFdnState[] simFdnStateArray = new SimFdnState[]{simFdnState, simFdnState2, simFdnState3, simFdnState4};
            $VALUES = simFdnStateArray;
        }

        public static SimFdnState valueOf(String string2) {
            return Enum.valueOf(SimFdnState.class, string2);
        }

        public static SimFdnState[] values() {
            return (SimFdnState[])$VALUES.clone();
        }
    }

    private static final class SimLockState
    extends Enum<SimLockState> {
        private static final /* synthetic */ SimLockState[] $VALUES;
        public static final /* enum */ SimLockState NONE = new SimLockState();
        public static final /* enum */ SimLockState REQUIRE_PIN = new SimLockState();
        public static final /* enum */ SimLockState REQUIRE_PUK = new SimLockState();
        public static final /* enum */ SimLockState SIM_PERM_LOCKED = new SimLockState();

        static {
            SimLockState simLockState = NONE;
            SimLockState simLockState2 = REQUIRE_PIN;
            SimLockState simLockState3 = REQUIRE_PUK;
            SimLockState simLockState4 = SIM_PERM_LOCKED;
            SimLockState[] simLockStateArray = new SimLockState[]{simLockState, simLockState2, simLockState3, simLockState4};
            $VALUES = simLockStateArray;
        }

        public static SimLockState valueOf(String string2) {
            return Enum.valueOf(SimLockState.class, string2);
        }

        public static SimLockState[] values() {
            return (SimLockState[])$VALUES.clone();
        }
    }
}

