/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.test.CallInfo;
import com.android.internal.telephony.test.InvalidStateEx;
import java.util.ArrayList;
import java.util.List;

class SimulatedGsmCallState
extends Handler {
    static final int CONNECTING_PAUSE_MSEC = 500;
    static final int EVENT_PROGRESS_CALL_STATE = 1;
    static final int MAX_CALLS = 7;
    private boolean autoProgressConnecting;
    CallInfo[] calls;
    private boolean nextDialFailImmediately;

    public SimulatedGsmCallState(Looper looper) {
        super(looper);
        CallInfo[] callInfoArray = new CallInfo[7];
        this.calls = callInfoArray;
        this.autoProgressConnecting = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int countActiveLines() throws InvalidStateEx {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < (n = this.calls.length); ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            if (callInfo.isMpty) {
                CallInfo.State state = callInfo.state;
                CallInfo.State state2 = CallInfo.State.HOLDING;
                if (state == state2) {
                    boolean bl5 = true;
                } else {
                    boolean bl6 = false;
                }
            } else {
                if (callInfo.isMpty) {
                    // empty if block
                }
                if (!callInfo.isMpty) {
                    // empty if block
                }
            }
            boolean bl7 = callInfo.isMpty;
            boolean bl8 = false | bl7;
            CallInfo.State state = callInfo.state;
            CallInfo.State state3 = CallInfo.State.HOLDING;
            boolean bl9 = state == state3;
            bl |= bl9;
            CallInfo.State state4 = callInfo.state;
            CallInfo.State state5 = CallInfo.State.ACTIVE;
            boolean bl10 = state4 == state5;
            bl2 |= bl10;
            boolean bl11 = callInfo.isConnecting();
            bl3 |= bl11;
            boolean bl12 = callInfo.isRinging();
            bl4 |= bl12;
        }
        int n2 = 0;
        if (bl) {
            ++n2;
        }
        if (bl2) {
            ++n2;
        }
        if (bl3) {
            ++n2;
        }
        if (bl4) {
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conference() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < (n2 = this.calls.length); ++n3) {
            CallInfo callInfo = this.calls[n3];
            if (callInfo == null) continue;
            ++n4;
            if (!callInfo.isConnecting()) continue;
            return false;
        }
        n3 = 0;
        while (n3 < (n = this.calls.length)) {
            CallInfo callInfo = this.calls[n3];
            if (callInfo != null) {
                CallInfo.State state;
                callInfo.state = state = CallInfo.State.ACTIVE;
                if (n4 > 0) {
                    callInfo.isMpty = true;
                }
            }
            int n5 = n3 + 1;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean explicitCallTransfer() {
        int n;
        int n2 = 0;
        while (n2 < (n = this.calls.length)) {
            CallInfo callInfo = this.calls[n2];
            if (callInfo != null) {
                int n3 = 0 + 1;
                if (callInfo.isConnecting()) {
                    return false;
                }
            }
            ++n2;
        }
        return this.triggerHangupAll();
    }

    public List<String> getClccLines() {
        int n;
        int n2 = this.calls.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i = 0; i < (n = this.calls.length); ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            int n3 = i + 1;
            String string2 = callInfo.toCLCCLine(n3);
            boolean bl = arrayList.add(string2);
        }
        return arrayList;
    }

    public List<DriverCall> getDriverCalls() {
        int n;
        int n2 = this.calls.length;
        ArrayList<DriverCall> arrayList = new ArrayList<DriverCall>(n2);
        for (int i = 0; i < (n = this.calls.length); ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            int n3 = i + 1;
            DriverCall driverCall = callInfo.toDriverCall(n3);
            boolean bl = arrayList.add(driverCall);
        }
        String string2 = "SC< getDriverCalls " + arrayList;
        int n4 = Log.d("GSM", string2);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        synchronized (this) {
            switch (message.what) {
                default: {
                    break;
                }
                case 1: {
                    this.progressConnectingCallState();
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onAnswer() {
        synchronized (this) {
            int n;
            int n2 = 0;
            while (n2 < (n = this.calls.length)) {
                CallInfo callInfo = this.calls[n2];
                if (callInfo != null) {
                    CallInfo.State state = callInfo.state;
                    CallInfo.State state2 = CallInfo.State.INCOMING;
                    if (state == state2) return this.switchActiveAndHeldOrWaiting();
                    CallInfo.State state3 = callInfo.state;
                    CallInfo.State state4 = CallInfo.State.WAITING;
                    if (state3 == state4) {
                        return this.switchActiveAndHeldOrWaiting();
                    }
                }
                ++n2;
            }
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onChld(char c, char c2) {
        int n = 0;
        if (c2 != null) {
            n = c2 - 49;
            if (n < 0) return false;
            int n2 = this.calls.length;
            if (n >= n2) {
                return false;
            }
        }
        switch (c) {
            default: {
                return false;
            }
            case '0': {
                return this.releaseHeldOrUDUB();
            }
            case '1': {
                if (c2 <= '\u0000') {
                    return this.releaseActiveAcceptHeldOrWaiting();
                }
                if (this.calls[n] == null) {
                    return false;
                }
                this.calls[n] = null;
                return true;
            }
            case '2': {
                if (c2 > '\u0000') return this.separateCall(n);
                return this.switchActiveAndHeldOrWaiting();
            }
            case '3': {
                return this.conference();
            }
            case '4': {
                return this.explicitCallTransfer();
            }
            case '5': 
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onDial(String string2) {
        CallInfo callInfo;
        int n;
        int n2 = -1;
        String string3 = "SC> dial '" + string2 + "'";
        int n3 = Log.d("GSM", string3);
        if (this.nextDialFailImmediately) {
            this.nextDialFailImmediately = false;
            int n4 = Log.d("GSM", "SC< dial fail (per request)");
            return false;
        }
        String string4 = PhoneNumberUtils.extractNetworkPortion(string2);
        if (string4.length() == 0) {
            int n5 = Log.d("GSM", "SC< dial fail (invalid ph num)");
            return false;
        }
        if (string4.startsWith("*99") && string4.endsWith("#")) {
            int n6 = Log.d("GSM", "SC< dial ignored (gprs)");
            return true;
        }
        try {
            if (this.countActiveLines() > 1) {
                int n7 = Log.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
        }
        catch (InvalidStateEx invalidStateEx) {
            int n8 = Log.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        for (int i = 0; i < (n = this.calls.length); ++i) {
            CallInfo.State state;
            CallInfo.State state2;
            CallInfo.State state3;
            if (-1 < 0 && this.calls[i] == null) {
                n2 = i;
            }
            if (this.calls[i] != null && !this.calls[i].isActiveOrHeld()) {
                int n9 = Log.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
            if (this.calls[i] == null || (state3 = this.calls[i].state) != (state2 = CallInfo.State.ACTIVE)) continue;
            CallInfo callInfo2 = this.calls[i];
            callInfo2.state = state = CallInfo.State.HOLDING;
        }
        if (-1 < 0) {
            int n10 = Log.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        CallInfo[] callInfoArray = this.calls;
        callInfoArray[-1] = callInfo = CallInfo.createOutgoingCall(string4);
        if (this.autoProgressConnecting) {
            CallInfo callInfo3 = this.calls[-1];
            Message message = this.obtainMessage(1, callInfo3);
            boolean bl = this.sendMessageDelayed(message, 500L);
        }
        String string5 = "SC< dial (slot = " + -1 + ")";
        int n11 = Log.d("GSM", string5);
        return true;
    }

    public boolean onHangup() {
        int n;
        boolean bl = false;
        for (int i = 0; i < (n = this.calls.length); ++i) {
            CallInfo.State state;
            CallInfo.State state2;
            CallInfo callInfo = this.calls[i];
            if (callInfo == null || (state2 = callInfo.state) == (state = CallInfo.State.WAITING)) continue;
            this.calls[i] = null;
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void progressConnectingCallState() {
        synchronized (this) {
            int n = 0;
            while (true) {
                block10: {
                    block8: {
                        CallInfo.State state;
                        CallInfo.State state2;
                        CallInfo.State state3;
                        CallInfo callInfo;
                        block9: {
                            CallInfo.State state4;
                            CallInfo.State state5;
                            CallInfo.State state6;
                            int n2;
                            if (n >= (n2 = this.calls.length)) break block8;
                            callInfo = this.calls[n];
                            if (callInfo == null || (state6 = callInfo.state) != (state5 = CallInfo.State.DIALING)) break block9;
                            callInfo.state = state4 = CallInfo.State.ALERTING;
                            if (this.autoProgressConnecting) {
                                Message message = this.obtainMessage(1, callInfo);
                                boolean bl = this.sendMessageDelayed(message, 500L);
                            }
                            break block8;
                        }
                        if (callInfo == null || (state3 = callInfo.state) != (state2 = CallInfo.State.ALERTING)) break block10;
                        callInfo.state = state = CallInfo.State.ACTIVE;
                    }
                    return;
                }
                ++n;
            }
        }
    }

    public void progressConnectingToActive() {
        synchronized (this) {
            int n = 0;
            while (true) {
                block7: {
                    block6: {
                        CallInfo.State state;
                        CallInfo.State state2;
                        CallInfo.State state3;
                        CallInfo.State state4;
                        CallInfo.State state5;
                        int n2;
                        if (n >= (n2 = this.calls.length)) break block6;
                        CallInfo callInfo = this.calls[n];
                        if (callInfo == null || (state5 = callInfo.state) != (state4 = CallInfo.State.DIALING) && (state3 = callInfo.state) != (state2 = CallInfo.State.ALERTING)) break block7;
                        callInfo.state = state = CallInfo.State.ACTIVE;
                    }
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean releaseActiveAcceptHeldOrWaiting() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        boolean bl2 = false;
        for (n5 = 0; n5 < (n4 = this.calls.length); ++n5) {
            CallInfo.State state;
            CallInfo.State state2;
            CallInfo callInfo = this.calls[n5];
            if (callInfo == null || (state2 = callInfo.state) != (state = CallInfo.State.ACTIVE)) continue;
            this.calls[n5] = null;
            bl2 = true;
        }
        if (!bl2) {
            int n6;
            for (n5 = 0; n5 < (n6 = this.calls.length); ++n5) {
                CallInfo.State state;
                CallInfo.State state3;
                CallInfo.State state4;
                CallInfo.State state5;
                CallInfo callInfo = this.calls[n5];
                if (callInfo == null || (state5 = callInfo.state) != (state4 = CallInfo.State.DIALING) && (state3 = callInfo.state) != (state = CallInfo.State.ALERTING)) continue;
                this.calls[n5] = null;
            }
        }
        for (n3 = 0; n3 < (n2 = this.calls.length); ++n3) {
            CallInfo.State state;
            CallInfo.State state6;
            CallInfo.State state7;
            CallInfo callInfo = this.calls[n3];
            if (callInfo == null || (state7 = callInfo.state) != (state6 = CallInfo.State.HOLDING)) continue;
            callInfo.state = state = CallInfo.State.ACTIVE;
            bl = true;
        }
        if (bl) {
            return true;
        }
        n3 = 0;
        while (n3 < (n = this.calls.length)) {
            CallInfo callInfo = this.calls[n3];
            if (callInfo != null && callInfo.isRinging()) {
                CallInfo.State state;
                callInfo.state = state = CallInfo.State.ACTIVE;
                return true;
            }
            ++n3;
        }
        return true;
    }

    public boolean releaseHeldOrUDUB() {
        boolean bl = false;
        int n = 0;
        while (true) {
            block4: {
                int n2;
                CallInfo callInfo;
                block3: {
                    int n3;
                    if (n >= (n3 = this.calls.length)) break block3;
                    callInfo = this.calls[n];
                    if (callInfo == null || !callInfo.isRinging()) break block4;
                    bl = true;
                    this.calls[n] = null;
                }
                if (bl) break;
                for (n = 0; n < (n2 = this.calls.length); ++n) {
                    CallInfo.State state;
                    CallInfo.State state2;
                    callInfo = this.calls[n];
                    if (callInfo == null || (state2 = callInfo.state) != (state = CallInfo.State.HOLDING)) continue;
                    this.calls[n] = null;
                }
                break;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean separateCall(int n) {
        try {
            int n2;
            CallInfo.State state;
            CallInfo callInfo = this.calls[n];
            if (callInfo == null) return false;
            if (callInfo.isConnecting()) return false;
            if (this.countActiveLines() != 1) {
                return false;
            }
            callInfo.state = state = CallInfo.State.ACTIVE;
            callInfo.isMpty = false;
            int n3 = 0;
            while (n3 < (n2 = this.calls.length)) {
                CallInfo.State state2;
                CallInfo.State state3;
                CallInfo callInfo2;
                int n4 = 0;
                int n5 = 0;
                if (n3 != n && (callInfo2 = this.calls[n3]) != null && (state3 = callInfo2.state) == (state2 = CallInfo.State.ACTIVE)) {
                    CallInfo.State state4;
                    callInfo2.state = state4 = CallInfo.State.HOLDING;
                    ++n4;
                    n5 = n3;
                }
                if (n4 == 1) {
                    this.calls[n5].isMpty = false;
                }
                ++n3;
            }
            return true;
        }
        catch (InvalidStateEx invalidStateEx) {
            return false;
        }
    }

    public void setAutoProgressConnectingCall(boolean bl) {
        this.autoProgressConnecting = bl;
    }

    public void setNextDialFailImmediately(boolean bl) {
        this.nextDialFailImmediately = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean switchActiveAndHeldOrWaiting() {
        CallInfo callInfo;
        boolean bl = false;
        int n = 0;
        while (true) {
            CallInfo.State state;
            CallInfo.State state2;
            int n2;
            if (n >= (n2 = this.calls.length)) break;
            callInfo = this.calls[n];
            if (callInfo != null && (state2 = callInfo.state) == (state = CallInfo.State.HOLDING)) {
                bl = true;
                break;
            }
            ++n;
        }
        int n3 = 0;
        int n4;
        while (n3 < (n4 = this.calls.length)) {
            callInfo = this.calls[n3];
            if (callInfo != null) {
                CallInfo.State state = callInfo.state;
                CallInfo.State state3 = CallInfo.State.ACTIVE;
                if (state == state3) {
                    CallInfo.State state4;
                    callInfo.state = state4 = CallInfo.State.HOLDING;
                } else {
                    CallInfo.State state5 = callInfo.state;
                    CallInfo.State state6 = CallInfo.State.HOLDING;
                    if (state5 == state6) {
                        CallInfo.State state7;
                        callInfo.state = state7 = CallInfo.State.ACTIVE;
                    } else if (!bl && callInfo.isRinging()) {
                        CallInfo.State state8;
                        callInfo.state = state8 = CallInfo.State.ACTIVE;
                    }
                }
            }
            ++n3;
        }
        return true;
    }

    public boolean triggerHangupAll() {
        synchronized (this) {
            int n;
            boolean bl = false;
            for (int i = 0; i < (n = this.calls.length); ++i) {
                CallInfo callInfo = this.calls[i];
                if (this.calls[i] != null) {
                    bl = true;
                }
                this.calls[i] = null;
            }
            return bl;
        }
    }

    public boolean triggerHangupBackground() {
        synchronized (this) {
            int n;
            boolean bl = false;
            for (int i = 0; i < (n = this.calls.length); ++i) {
                CallInfo.State state;
                CallInfo.State state2;
                CallInfo callInfo = this.calls[i];
                if (callInfo == null || (state2 = callInfo.state) != (state = CallInfo.State.HOLDING)) continue;
                this.calls[i] = null;
                bl = true;
            }
            return bl;
        }
    }

    public boolean triggerHangupForeground() {
        synchronized (this) {
            int n;
            CallInfo callInfo;
            int n2;
            int n3;
            boolean bl = false;
            for (n3 = 0; n3 < (n2 = this.calls.length); ++n3) {
                CallInfo.State state;
                CallInfo.State state2;
                CallInfo.State state3;
                CallInfo.State state4;
                callInfo = this.calls[n3];
                if (callInfo == null || (state4 = callInfo.state) != (state3 = CallInfo.State.INCOMING) && (state2 = callInfo.state) != (state = CallInfo.State.WAITING)) continue;
                this.calls[n3] = null;
                bl = true;
            }
            for (n3 = 0; n3 < (n = this.calls.length); ++n3) {
                CallInfo.State state;
                CallInfo.State state5;
                CallInfo.State state6;
                CallInfo.State state7;
                CallInfo.State state8;
                CallInfo.State state9;
                callInfo = this.calls[n3];
                if (callInfo == null || (state9 = callInfo.state) != (state8 = CallInfo.State.DIALING) && (state7 = callInfo.state) != (state6 = CallInfo.State.ACTIVE) && (state5 = callInfo.state) != (state = CallInfo.State.ALERTING)) continue;
                this.calls[n3] = null;
                bl = true;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean triggerRing(String string2) {
        synchronized (this) {
            CallInfo.State state;
            CallInfo callInfo;
            int n;
            int n2 = -1;
            boolean bl = false;
            for (int i = 0; i < (n = this.calls.length); ++i) {
                CallInfo.State state2;
                CallInfo.State state3;
                CallInfo.State state4;
                CallInfo.State state5;
                CallInfo callInfo2 = this.calls[i];
                if (callInfo2 == null && n2 < 0) {
                    n2 = i;
                    continue;
                }
                if (callInfo2 != null && ((state5 = callInfo2.state) == (state4 = CallInfo.State.INCOMING) || (state3 = callInfo2.state) == (state2 = CallInfo.State.WAITING))) {
                    int n3 = Log.w("ModelInterpreter", "triggerRing failed; phone already ringing");
                    return false;
                }
                if (callInfo2 == null) continue;
                bl = true;
            }
            if (n2 < 0) {
                int n4 = Log.w("ModelInterpreter", "triggerRing failed; all full");
                return false;
            }
            CallInfo[] callInfoArray = this.calls;
            callInfoArray[n2] = callInfo = CallInfo.createIncomingCall(PhoneNumberUtils.extractNetworkPortion(string2));
            if (!bl) return true;
            CallInfo callInfo3 = this.calls[n2];
            callInfo3.state = state = CallInfo.State.WAITING;
            return true;
        }
    }
}

