/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.lang.reflect.Array;

public class ArrayUtils {
    private static final int CACHE_SIZE = 73;
    private static Object[] EMPTY = new Object[0];
    private static Object[] sCache = new Object[73];

    private ArrayUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> boolean contains(T[] TArray, T t) {
        T[] TArray2 = TArray;
        int n = TArray2.length;
        int n2 = 0;
        while (n2 < n) {
            T t2 = TArray2[n2];
            if (t2 == null ? t == null : t != null && t2.equals(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T[] emptyArray(Class<T> clazz) {
        if (clazz == Object.class) {
            return EMPTY;
        }
        int n = (System.identityHashCode(clazz) / 8 & Integer.MAX_VALUE) % 73;
        Object object = sCache[n];
        if (object != null) {
            if (object.getClass().getComponentType() == clazz) return (Object[])object;
        }
        ArrayUtils.sCache[n] = object = Array.newInstance(clazz, 0);
        return (Object[])object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null) return false;
        if (byArray2 == null) return false;
        if (byArray.length < n) return false;
        if (byArray2.length < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            byte by2 = byArray2[n2];
            if (by != by2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int idealBooleanArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int idealByteArraySize(int n) {
        int n2 = 4;
        while (n2 < 32) {
            int n3 = (1 << n2) - 12;
            if (n <= n3) {
                return (1 << n2) - 12;
            }
            ++n2;
        }
        return n;
    }

    public static int idealCharArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 2) / 2;
    }

    public static int idealFloatArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 4) / 4;
    }

    public static int idealIntArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 4) / 4;
    }

    public static int idealLongArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 8) / 8;
    }

    public static int idealObjectArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 4) / 4;
    }

    public static int idealShortArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 2) / 2;
    }
}

