/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.xmlpull.v1.XmlSerializer;

public class FastXmlSerializer
implements XmlSerializer {
    private static final int BUFFER_LEN = 8192;
    private static final String[] ESCAPE_TABLE;
    private ByteBuffer mBytes;
    private CharsetEncoder mCharset;
    private boolean mInTag;
    private OutputStream mOutputStream;
    private int mPos;
    private final char[] mText;
    private Writer mWriter;

    static {
        String[] stringArray = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
        ESCAPE_TABLE = stringArray;
    }

    public FastXmlSerializer() {
        ByteBuffer byteBuffer;
        char[] cArray = new char[8192];
        this.mText = cArray;
        this.mBytes = byteBuffer = ByteBuffer.allocate(8192);
    }

    private void append(char c) throws IOException {
        int n;
        int n2 = this.mPos;
        if (n2 >= 8191) {
            this.flush();
            n2 = this.mPos;
        }
        this.mText[n2] = c;
        this.mPos = n = n2 + 1;
    }

    private void append(String string2) throws IOException {
        int n = string2.length();
        this.append(string2, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void append(String string2, int n, int n2) throws IOException {
        if (n2 <= 8192) {
            int n3;
            int n4 = this.mPos;
            if (n4 + n2 > 8192) {
                this.flush();
                n4 = this.mPos;
            }
            int n5 = n + n2;
            char[] cArray = this.mText;
            string2.getChars(n, n5, cArray, n4);
            this.mPos = n3 = n4 + n2;
            return;
        }
        int n6 = n + n2;
        while (n < n6) {
            int n7 = n + 8192;
            int n8 = n7 < n6 ? 8192 : n6 - n;
            this.append(string2, n, n8);
            n = n7;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void append(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= 8192) {
            int n3;
            int n4 = this.mPos;
            if (n4 + n2 > 8192) {
                this.flush();
                n4 = this.mPos;
            }
            char[] cArray2 = this.mText;
            System.arraycopy(cArray, n, cArray2, n4, n2);
            this.mPos = n3 = n4 + n2;
            return;
        }
        int n5 = n + n2;
        while (n < n5) {
            int n6 = n + 8192;
            int n7 = n6 < n5 ? 8192 : n5 - n;
            this.append(cArray, n, n7);
            n = n6;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeAndAppendString(String string2) throws IOException {
        int n;
        int n2 = string2.length();
        char c = (char)ESCAPE_TABLE.length;
        String[] stringArray = ESCAPE_TABLE;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            String string3;
            char c2 = string2.charAt(n);
            if (c2 >= c || (string3 = stringArray[c2]) == null) continue;
            if (n3 < n) {
                int n4 = n - n3;
                this.append(string2, n3, n4);
            }
            n3 = n + 1;
            this.append(string3);
        }
        if (n3 >= n) {
            return;
        }
        int n5 = n - n3;
        this.append(string2, n3, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeAndAppendString(char[] cArray, int n, int n2) throws IOException {
        int n3;
        char c = (char)ESCAPE_TABLE.length;
        String[] stringArray = ESCAPE_TABLE;
        int n4 = n + n2;
        int n5 = n;
        for (n3 = n; n3 < n4; ++n3) {
            String string2;
            char c2 = cArray[n3];
            if (c2 >= c || (string2 = stringArray[c2]) == null) continue;
            if (n5 < n3) {
                int n6 = n3 - n5;
                this.append(cArray, n5, n6);
            }
            n5 = n3 + 1;
            this.append(string2);
        }
        if (n5 >= n3) {
            return;
        }
        int n7 = n3 - n5;
        this.append(cArray, n5, n7);
    }

    private void flushBytes() throws IOException {
        int n = this.mBytes.position();
        if (n <= 0) {
            return;
        }
        Buffer buffer = this.mBytes.flip();
        OutputStream outputStream = this.mOutputStream;
        byte[] byArray = this.mBytes.array();
        outputStream.write(byArray, 0, n);
        Buffer buffer2 = this.mBytes.clear();
    }

    @Override
    public XmlSerializer attribute(String string2, String string3, String string4) throws IOException, IllegalArgumentException, IllegalStateException {
        this.append(' ');
        if (string2 != null) {
            this.append(string2);
            this.append(':');
        }
        this.append(string3);
        this.append("=\"");
        this.escapeAndAppendString(string4);
        this.append('\"');
        return this;
    }

    @Override
    public void cdsect(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void comment(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void docdecl(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        this.flush();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public XmlSerializer endTag(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(" />\n");
        } else {
            this.append("</");
            if (string2 != null) {
                this.append(string2);
                this.append(':');
            }
            this.append(string3);
            this.append(">\n");
        }
        this.mInTag = false;
        return this;
    }

    @Override
    public void entityRef(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void flush() throws IOException {
        if (this.mPos <= 0) {
            return;
        }
        if (this.mOutputStream == null) {
            Writer writer = this.mWriter;
            char[] cArray = this.mText;
            int n = this.mPos;
            writer.write(cArray, 0, n);
            this.mWriter.flush();
        } else {
            char[] cArray = this.mText;
            int n = this.mPos;
            CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, n);
            CharsetEncoder charsetEncoder = this.mCharset;
            ByteBuffer byteBuffer = this.mBytes;
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            while (true) {
                if (coderResult.isError()) {
                    String string2 = coderResult.toString();
                    throw new IOException(string2);
                }
                if (!coderResult.isOverflow()) break;
                this.flushBytes();
                CharsetEncoder charsetEncoder2 = this.mCharset;
                ByteBuffer byteBuffer2 = this.mBytes;
                coderResult = charsetEncoder2.encode(charBuffer, byteBuffer2, true);
            }
            this.flushBytes();
            this.mOutputStream.flush();
        }
        this.mPos = 0;
    }

    @Override
    public int getDepth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFeature(String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrefix(String string2, boolean bl) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ignorableWhitespace(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processingInstruction(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFeature(String string2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (string2.equals("http://xmlpull.org/v1/doc/features.html#indent-output")) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOutput(OutputStream outputStream, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            CharsetEncoder charsetEncoder;
            this.mCharset = charsetEncoder = Charset.forName(string2).newEncoder();
            this.mOutputStream = outputStream;
            return;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string2).initCause(illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string2).initCause(unsupportedCharsetException);
        }
    }

    @Override
    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mWriter = writer;
    }

    @Override
    public void setPrefix(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String string2, Object object) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startDocument(String string2, Boolean bl) throws IOException, IllegalArgumentException, IllegalStateException {
        StringBuilder stringBuilder = new StringBuilder().append("<?xml version='1.0' encoding='utf-8' standalone='");
        String string3 = bl != false ? "yes" : "no";
        String string4 = stringBuilder.append(string3).append("' ?>\n").toString();
        this.append(string4);
    }

    @Override
    public XmlSerializer startTag(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">\n");
        }
        this.append('<');
        if (string2 != null) {
            this.append(string2);
            this.append(':');
        }
        this.append(string3);
        this.mInTag = true;
        return this;
    }

    @Override
    public XmlSerializer text(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(string2);
        return this;
    }

    @Override
    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(cArray, n, n2);
        return this;
    }
}

