/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.ProcessedMessages;
import java.util.ArrayList;
import java.util.HashMap;

public class HierarchicalStateMachine {
    public static final boolean HANDLED = true;
    public static final int HSM_INIT_CMD = 255;
    public static final int HSM_QUIT_CMD = 255;
    public static final boolean NOT_HANDLED = false;
    private static final String TAG = "HierarchicalStateMachine";
    private HsmHandler mHsmHandler;
    private HandlerThread mHsmThread;
    private String mName;

    protected HierarchicalStateMachine(String string2) {
        HandlerThread handlerThread;
        this.mHsmThread = handlerThread = new HandlerThread(string2);
        this.mHsmThread.start();
        Looper looper = this.mHsmThread.getLooper();
        this.initStateMachine(string2, looper);
    }

    protected HierarchicalStateMachine(String string2, Looper looper) {
        this.initStateMachine(string2, looper);
    }

    private void initStateMachine(String string2, Looper looper) {
        HsmHandler hsmHandler;
        this.mName = string2;
        this.mHsmHandler = hsmHandler = new HsmHandler(looper, this);
    }

    protected final void addState(HierarchicalState hierarchicalState) {
        HsmHandler.StateInfo stateInfo = this.mHsmHandler.addState(hierarchicalState, null);
    }

    protected final void addState(HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
        HsmHandler.StateInfo stateInfo = this.mHsmHandler.addState(hierarchicalState, hierarchicalState2);
    }

    protected final void deferMessage(Message message) {
        this.mHsmHandler.deferMessage(message);
    }

    protected final Message getCurrentMessage() {
        return this.mHsmHandler.getCurrentMessage();
    }

    protected final HierarchicalState getCurrentState() {
        return this.mHsmHandler.getCurrentState();
    }

    public final Handler getHandler() {
        return this.mHsmHandler;
    }

    public final String getName() {
        return this.mName;
    }

    public final ProcessedMessages.Info getProcessedMessage(int n) {
        return this.mHsmHandler.getProcessedMessage(n);
    }

    public final int getProcessedMessagesCount() {
        return this.mHsmHandler.getProcessedMessagesCount();
    }

    public final int getProcessedMessagesSize() {
        return this.mHsmHandler.getProcessedMessagesSize();
    }

    protected void haltedProcessMessage(Message message) {
    }

    protected void halting() {
    }

    public boolean isDbg() {
        return this.mHsmHandler.isDbg();
    }

    protected final boolean isQuit(Message message) {
        return this.mHsmHandler.isQuit(message);
    }

    public final Message obtainMessage() {
        return Message.obtain(this.mHsmHandler);
    }

    public final Message obtainMessage(int n) {
        return Message.obtain((Handler)this.mHsmHandler, n);
    }

    public final Message obtainMessage(int n, Object object) {
        return Message.obtain(this.mHsmHandler, n, object);
    }

    public final void quit() {
        this.mHsmHandler.quit();
    }

    protected void quitting() {
    }

    public final void sendMessage(int n) {
        HsmHandler hsmHandler = this.mHsmHandler;
        Message message = this.obtainMessage(n);
        boolean bl = hsmHandler.sendMessage(message);
    }

    public final void sendMessage(int n, Object object) {
        HsmHandler hsmHandler = this.mHsmHandler;
        Message message = this.obtainMessage(n, object);
        boolean bl = hsmHandler.sendMessage(message);
    }

    public final void sendMessage(Message message) {
        boolean bl = this.mHsmHandler.sendMessage(message);
    }

    protected final void sendMessageAtFrontOfQueue(int n) {
        HsmHandler hsmHandler = this.mHsmHandler;
        Message message = this.obtainMessage(n);
        boolean bl = hsmHandler.sendMessageAtFrontOfQueue(message);
    }

    protected final void sendMessageAtFrontOfQueue(int n, Object object) {
        HsmHandler hsmHandler = this.mHsmHandler;
        Message message = this.obtainMessage(n, object);
        boolean bl = hsmHandler.sendMessageAtFrontOfQueue(message);
    }

    protected final void sendMessageAtFrontOfQueue(Message message) {
        boolean bl = this.mHsmHandler.sendMessageAtFrontOfQueue(message);
    }

    public final void sendMessageDelayed(int n, long l) {
        HsmHandler hsmHandler = this.mHsmHandler;
        Message message = this.obtainMessage(n);
        boolean bl = hsmHandler.sendMessageDelayed(message, l);
    }

    public final void sendMessageDelayed(int n, Object object, long l) {
        HsmHandler hsmHandler = this.mHsmHandler;
        Message message = this.obtainMessage(n, object);
        boolean bl = hsmHandler.sendMessageDelayed(message, l);
    }

    public final void sendMessageDelayed(Message message, long l) {
        boolean bl = this.mHsmHandler.sendMessageDelayed(message, l);
    }

    public void setDbg(boolean bl) {
        this.mHsmHandler.setDbg(bl);
    }

    protected final void setInitialState(HierarchicalState hierarchicalState) {
        this.mHsmHandler.setInitialState(hierarchicalState);
    }

    public final void setProcessedMessagesSize(int n) {
        this.mHsmHandler.setProcessedMessagesSize(n);
    }

    public void start() {
        this.mHsmHandler.completeConstruction();
    }

    protected final void transitionTo(HierarchicalState hierarchicalState) {
        this.mHsmHandler.transitionTo(hierarchicalState);
    }

    protected final void transitionToHaltingState() {
        HsmHandler hsmHandler = this.mHsmHandler;
        HsmHandler.HaltingState haltingState = this.mHsmHandler.mHaltingState;
        hsmHandler.transitionTo(haltingState);
    }

    protected void unhandledMessage(Message message) {
    }

    private static class HsmHandler
    extends Handler {
        private static final Message mInitMsg;
        private static final Object mQuitObj;
        private boolean mDbg = false;
        private ArrayList<Message> mDeferredMessages;
        private HierarchicalState mDestState;
        private HaltingState mHaltingState;
        private HierarchicalStateMachine mHsm;
        private HierarchicalState mInitialState;
        private boolean mIsConstructionCompleted;
        private Message mMsg;
        private ProcessedMessages mProcessedMessages;
        private QuittingState mQuittingState;
        private HashMap<HierarchicalState, StateInfo> mStateInfo;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;

        static {
            mQuitObj = new Object();
            mInitMsg = null;
        }

        private HsmHandler(Looper looper, HierarchicalStateMachine hierarchicalStateMachine) {
            super(looper);
            QuittingState quittingState;
            HaltingState haltingState;
            ProcessedMessages processedMessages;
            this.mProcessedMessages = processedMessages = new ProcessedMessages();
            this.mStateStackTopIndex = -1;
            this.mHaltingState = haltingState = new HaltingState();
            this.mQuittingState = quittingState = new QuittingState();
            HashMap hashMap = new HashMap();
            this.mStateInfo = hashMap;
            ArrayList arrayList = new ArrayList();
            this.mDeferredMessages = arrayList;
            this.mHsm = hierarchicalStateMachine;
            HaltingState haltingState2 = this.mHaltingState;
            StateInfo stateInfo = this.addState(haltingState2, null);
            QuittingState quittingState2 = this.mQuittingState;
            StateInfo stateInfo2 = this.addState(quittingState2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final StateInfo addState(HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
            StateInfo stateInfo;
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("addStateInternal: E state=");
                String string2 = hierarchicalState.getName();
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(",parent=");
                String string3 = hierarchicalState2 == null ? "" : hierarchicalState2.getName();
                String string4 = stringBuilder2.append(string3).toString();
                int n = Log.d(HierarchicalStateMachine.TAG, string4);
            }
            StateInfo stateInfo2 = null;
            if (hierarchicalState2 != null && (stateInfo2 = this.mStateInfo.get(hierarchicalState2)) == null) {
                stateInfo2 = this.addState(hierarchicalState2, null);
            }
            if ((stateInfo = this.mStateInfo.get(hierarchicalState)) == null) {
                stateInfo = new StateInfo();
                StateInfo stateInfo3 = this.mStateInfo.put(hierarchicalState, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != stateInfo2) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = hierarchicalState;
            stateInfo.parentStateInfo = stateInfo2;
            stateInfo.active = false;
            if (this.mDbg) {
                String string5 = "addStateInternal: X stateInfo: " + stateInfo;
                int n = Log.d(HierarchicalStateMachine.TAG, string5);
            }
            return stateInfo;
        }

        private final void completeConstruction() {
            Message message;
            if (this.mDbg) {
                int n = Log.d(HierarchicalStateMachine.TAG, "completeConstruction: E");
            }
            int n = 0;
            for (StateInfo stateInfo : this.mStateInfo.values()) {
                int n2 = 0;
                StateInfo stateInfo2 = stateInfo;
                while (stateInfo2 != null) {
                    stateInfo2 = stateInfo2.parentStateInfo;
                    ++n2;
                }
                if (n >= n2) continue;
                n = n2;
            }
            if (this.mDbg) {
                String string2 = "completeConstruction: maxDepth=" + n;
                int n3 = Log.d(HierarchicalStateMachine.TAG, string2);
            }
            StateInfo[] stateInfoArray = new StateInfo[n];
            this.mStateStack = stateInfoArray;
            StateInfo[] stateInfoArray2 = new StateInfo[n];
            this.mTempStateStack = stateInfoArray2;
            this.setupInitialStateStack();
            this.mIsConstructionCompleted = true;
            this.mMsg = message = this.obtainMessage(-1);
            this.invokeEnterMethods(0);
            this.performTransitions();
            if (!this.mDbg) {
                return;
            }
            int n4 = Log.d(HierarchicalStateMachine.TAG, "completeConstruction: X");
        }

        private final void deferMessage(Message message) {
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("deferMessage: msg=");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.d(HierarchicalStateMachine.TAG, string2);
            }
            Message message2 = this.obtainMessage();
            message2.copyFrom(message);
            boolean bl = this.mDeferredMessages.add(message2);
        }

        private final Message getCurrentMessage() {
            return this.mMsg;
        }

        private final HierarchicalState getCurrentState() {
            StateInfo[] stateInfoArray = this.mStateStack;
            int n = this.mStateStackTopIndex;
            return stateInfoArray[n].state;
        }

        private final ProcessedMessages.Info getProcessedMessage(int n) {
            return this.mProcessedMessages.get(n);
        }

        private final int getProcessedMessagesCount() {
            return this.mProcessedMessages.count();
        }

        private final int getProcessedMessagesSize() {
            return this.mProcessedMessages.size();
        }

        private final void invokeEnterMethods(int n) {
            int n2 = n;
            int n3;
            while (n2 <= (n3 = this.mStateStackTopIndex)) {
                if (this.mDbg) {
                    StringBuilder stringBuilder = new StringBuilder().append("invokeEnterMethods: ");
                    String string2 = this.mStateStack[n2].state.getName();
                    String string3 = stringBuilder.append(string2).toString();
                    int n4 = Log.d(HierarchicalStateMachine.TAG, string3);
                }
                this.mStateStack[n2].state.enter();
                this.mStateStack[n2].active = true;
                ++n2;
            }
            return;
        }

        private final void invokeExitMethods(StateInfo stateInfo) {
            while (this.mStateStackTopIndex >= 0) {
                int n;
                StateInfo[] stateInfoArray = this.mStateStack;
                int n2 = this.mStateStackTopIndex;
                if (stateInfoArray[n2] == stateInfo) {
                    return;
                }
                StateInfo[] stateInfoArray2 = this.mStateStack;
                int n3 = this.mStateStackTopIndex;
                HierarchicalState hierarchicalState = stateInfoArray2[n3].state;
                if (this.mDbg) {
                    StringBuilder stringBuilder = new StringBuilder().append("invokeExitMethods: ");
                    String string2 = hierarchicalState.getName();
                    String string3 = stringBuilder.append(string2).toString();
                    int n4 = Log.d(HierarchicalStateMachine.TAG, string3);
                }
                hierarchicalState.exit();
                StateInfo[] stateInfoArray3 = this.mStateStack;
                int n5 = this.mStateStackTopIndex;
                stateInfoArray3[n5].active = false;
                this.mStateStackTopIndex = n = this.mStateStackTopIndex - 1;
            }
            return;
        }

        private final boolean isDbg() {
            return this.mDbg;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isQuit(Message message) {
            if (message.what != -1) return false;
            Object object = message.obj;
            Object object2 = mQuitObj;
            if (object != object2) return false;
            return true;
        }

        private final void moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; i += -1) {
                Message message = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    StringBuilder stringBuilder = new StringBuilder().append("moveDeferredMessageAtFrontOfQueue; what=");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.d(HierarchicalStateMachine.TAG, string2);
                }
                boolean bl = this.sendMessageAtFrontOfQueue(message);
            }
            this.mDeferredMessages.clear();
        }

        private final int moveTempStateStackToStateStack() {
            int n;
            int n2 = this.mStateStackTopIndex + 1;
            int n3 = n2;
            for (int i = this.mTempStateStackCount - 1; i >= 0; i += -1) {
                StateInfo stateInfo;
                if (this.mDbg) {
                    String string2 = "moveTempStackToStateStack: i=" + i + ",j=" + n3;
                    int n4 = Log.d(HierarchicalStateMachine.TAG, string2);
                }
                StateInfo[] stateInfoArray = this.mStateStack;
                stateInfoArray[n3] = stateInfo = this.mTempStateStack[i];
                ++n3;
            }
            this.mStateStackTopIndex = n = n3 - 1;
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("moveTempStackToStateStack: X mStateStackTop=");
                int n5 = this.mStateStackTopIndex;
                StringBuilder stringBuilder2 = stringBuilder.append(n5).append(",startingIndex=").append(n2).append(",Top=");
                StateInfo[] stateInfoArray = this.mStateStack;
                int n6 = this.mStateStackTopIndex;
                String string3 = stateInfoArray[n6].state.getName();
                String string4 = stringBuilder2.append(string3).toString();
                int n7 = Log.d(HierarchicalStateMachine.TAG, string4);
            }
            return n2;
        }

        private void performTransitions() {
            HierarchicalState hierarchicalState = null;
            while (this.mDestState != null) {
                if (this.mDbg) {
                    int n = Log.d(HierarchicalStateMachine.TAG, "handleMessage: new destination call exit");
                }
                hierarchicalState = this.mDestState;
                this.mDestState = null;
                StateInfo stateInfo = this.setupTempStateStackWithStatesToEnter(hierarchicalState);
                this.invokeExitMethods(stateInfo);
                int n = this.moveTempStateStackToStateStack();
                this.invokeEnterMethods(n);
                this.moveDeferredMessageAtFrontOfQueue();
            }
            if (hierarchicalState == null) {
                return;
            }
            QuittingState quittingState = this.mQuittingState;
            if (hierarchicalState == quittingState) {
                this.mHsm.quitting();
                if (this.mHsm.mHsmThread == null) {
                    return;
                }
                this.getLooper().quit();
                return;
            }
            HaltingState haltingState = this.mHaltingState;
            if (hierarchicalState != haltingState) {
                return;
            }
            this.mHsm.halting();
        }

        private final void processMsg(Message message) {
            StateInfo[] stateInfoArray = this.mStateStack;
            int n = this.mStateStackTopIndex;
            StateInfo stateInfo = stateInfoArray[n];
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("processMsg: ");
                String string2 = stateInfo.state.getName();
                String string3 = stringBuilder.append(string2).toString();
                int n2 = Log.d(HierarchicalStateMachine.TAG, string3);
            }
            while (true) {
                block7: {
                    block6: {
                        if (stateInfo.state.processMessage(message)) break block6;
                        stateInfo = stateInfo.parentStateInfo;
                        if (stateInfo != null) break block7;
                        this.mHsm.unhandledMessage(message);
                        if (this.isQuit(message)) {
                            QuittingState quittingState = this.mQuittingState;
                            this.transitionTo(quittingState);
                        }
                    }
                    if (stateInfo == null) break;
                    StateInfo[] stateInfoArray2 = this.mStateStack;
                    int n3 = this.mStateStackTopIndex;
                    HierarchicalState hierarchicalState = stateInfoArray2[n3].state;
                    ProcessedMessages processedMessages = this.mProcessedMessages;
                    HierarchicalState hierarchicalState2 = stateInfo.state;
                    processedMessages.add(message, hierarchicalState2, hierarchicalState);
                    return;
                }
                if (!this.mDbg) continue;
                StringBuilder stringBuilder = new StringBuilder().append("processMsg: ");
                String string4 = stateInfo.state.getName();
                String string5 = stringBuilder.append(string4).toString();
                int n4 = Log.d(HierarchicalStateMachine.TAG, string5);
            }
            this.mProcessedMessages.add(message, null, null);
        }

        private final void quit() {
            if (this.mDbg) {
                int n = Log.d(HierarchicalStateMachine.TAG, "quit:");
            }
            Object object = mQuitObj;
            Message message = this.obtainMessage(-1, object);
            boolean bl = this.sendMessage(message);
        }

        private final void setDbg(boolean bl) {
            this.mDbg = bl;
        }

        private final void setInitialState(HierarchicalState hierarchicalState) {
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("setInitialState: initialState");
                String string2 = hierarchicalState.getName();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.d(HierarchicalStateMachine.TAG, string3);
            }
            this.mInitialState = hierarchicalState;
        }

        private final void setProcessedMessagesSize(int n) {
            this.mProcessedMessages.setSize(n);
        }

        private final void setupInitialStateStack() {
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("setupInitialStateStack: E mInitialState=");
                String string2 = this.mInitialState.getName();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.d(HierarchicalStateMachine.TAG, string3);
            }
            HashMap<HierarchicalState, StateInfo> hashMap = this.mStateInfo;
            HierarchicalState hierarchicalState = this.mInitialState;
            StateInfo stateInfo = hashMap.get(hierarchicalState);
            this.mTempStateStackCount = 0;
            while (stateInfo != null) {
                int n;
                StateInfo[] stateInfoArray = this.mTempStateStack;
                int n2 = this.mTempStateStackCount;
                stateInfoArray[n2] = stateInfo;
                stateInfo = stateInfo.parentStateInfo;
                this.mTempStateStackCount = n = this.mTempStateStackCount + 1;
            }
            this.mStateStackTopIndex = -1;
            int n = this.moveTempStateStackToStateStack();
        }

        private final StateInfo setupTempStateStackWithStatesToEnter(HierarchicalState hierarchicalState) {
            this.mTempStateStackCount = 0;
            StateInfo stateInfo = this.mStateInfo.get(hierarchicalState);
            do {
                int n;
                StateInfo[] stateInfoArray = this.mTempStateStack;
                int n2 = this.mTempStateStackCount;
                this.mTempStateStackCount = n = n2 + 1;
                stateInfoArray[n2] = stateInfo;
            } while ((stateInfo = stateInfo.parentStateInfo) != null && !stateInfo.active);
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("setupTempStateStackWithStatesToEnter: X mTempStateStackCount=");
                int n = this.mTempStateStackCount;
                String string2 = stringBuilder.append(n).append(",curStateInfo: ").append(stateInfo).toString();
                int n3 = Log.d(HierarchicalStateMachine.TAG, string2);
            }
            return stateInfo;
        }

        private final void transitionTo(HierarchicalState hierarchicalState) {
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("StateMachine.transitionTo EX destState");
                String string2 = hierarchicalState.getName();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.d(HierarchicalStateMachine.TAG, string3);
            }
            this.mDestState = hierarchicalState;
        }

        @Override
        public final void handleMessage(Message message) {
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("handleMessage: E msg.what=");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.d(HierarchicalStateMachine.TAG, string2);
            }
            this.mMsg = message;
            if (!this.mIsConstructionCompleted) {
                String string3 = "The start method not called, ignore msg: " + message;
                int n = Log.e(HierarchicalStateMachine.TAG, string3);
                return;
            }
            this.processMsg(message);
            this.performTransitions();
            if (!this.mDbg) {
                return;
            }
            int n = Log.d(HierarchicalStateMachine.TAG, "handleMessage: X");
        }

        private class QuittingState
        extends HierarchicalState {
            private QuittingState() {
            }

            @Override
            public boolean processMessage(Message message) {
                return false;
            }
        }

        private class HaltingState
        extends HierarchicalState {
            private HaltingState() {
            }

            @Override
            public boolean processMessage(Message message) {
                HsmHandler.this.mHsm.haltedProcessMessage(message);
                return true;
            }
        }

        private class StateInfo {
            boolean active;
            StateInfo parentStateInfo;
            HierarchicalState state;

            private StateInfo() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String toString() {
                String string2;
                StringBuilder stringBuilder = new StringBuilder().append("state=");
                String string3 = this.state.getName();
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(",active=");
                boolean bl = this.active;
                StringBuilder stringBuilder3 = stringBuilder2.append(bl).append(",parent=");
                if (this.parentStateInfo == null) {
                    string2 = "null";
                    return stringBuilder3.append(string2).toString();
                }
                string2 = this.parentStateInfo.state.getName();
                return stringBuilder3.append(string2).toString();
            }
        }
    }
}

