/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Predicate;
import java.util.Arrays;
import java.util.Iterator;

public class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new AndPredicate(iterable);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return Predicates.and(Arrays.asList(predicateArray));
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new OrPredicate(iterable);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return Predicates.or(Arrays.asList(predicateArray));
    }

    private static class NotPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean apply(T t) {
            if (this.predicate.apply(t)) return false;
            return true;
        }
    }

    private static class OrPredicate<T>
    implements Predicate<T> {
        private final Iterable<? extends Predicate<? super T>> components;

        private OrPredicate(Iterable<? extends Predicate<? super T>> iterable) {
            this.components = iterable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean apply(T t) {
            Iterator<Predicate<T>> iterator = this.components.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!iterator.next().apply(t));
            return true;
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private final Iterable<? extends Predicate<? super T>> components;

        private AndPredicate(Iterable<? extends Predicate<? super T>> iterable) {
            this.components = iterable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean apply(T t) {
            Iterator<Predicate<T>> iterator = this.components.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while (iterator.next().apply(t));
            return false;
        }
    }
}

