/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TypedProperties
extends HashMap<String, Object> {
    static final String NULL_STRING = new String("<TypedProperties:NULL_STRING>");
    public static final int STRING_NOT_SET = 255;
    public static final int STRING_NULL = 0;
    public static final int STRING_SET = 1;
    public static final int STRING_TYPE_MISMATCH = 254;
    static final int TYPE_BOOLEAN = 90;
    static final int TYPE_BYTE = 329;
    static final int TYPE_DOUBLE = 2118;
    static final int TYPE_ERROR = 255;
    static final int TYPE_FLOAT = 1094;
    static final int TYPE_INT = 1097;
    static final int TYPE_LONG = 2121;
    static final int TYPE_SHORT = 585;
    static final int TYPE_STRING = 29516;
    static final int TYPE_UNSET = 120;

    static StreamTokenizer initTokenizer(Reader reader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.ordinaryChar(61);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.quoteChar(34);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        return streamTokenizer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int interpretType(String string2) {
        if ("unset".equals(string2)) {
            return 120;
        }
        if ("boolean".equals(string2)) {
            return 90;
        }
        if ("byte".equals(string2)) {
            return 329;
        }
        if ("short".equals(string2)) {
            return 585;
        }
        if ("int".equals(string2)) {
            return 1097;
        }
        if ("long".equals(string2)) {
            return 2121;
        }
        if ("float".equals(string2)) {
            return 1094;
        }
        if ("double".equals(string2)) {
            return 2118;
        }
        if (!"String".equals(string2)) return -1;
        return 29516;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void parse(Reader reader, Map<String, Object> map) throws ParseException, IOException {
        StreamTokenizer streamTokenizer = TypedProperties.initTokenizer(reader);
        Pattern pattern = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*\\.)*[a-zA-Z_$][0-9a-zA-Z_$]*");
        do {
            Class<? extends Object> clazz;
            Class<? extends Object> clazz2;
            int n;
            if ((n = streamTokenizer.nextToken()) == -1) {
                return;
            }
            if (n != -1) {
                throw new ParseException(streamTokenizer, "type name");
            }
            int n2 = TypedProperties.interpretType(streamTokenizer.sval);
            if (n2 == -1) {
                throw new ParseException(streamTokenizer, "valid type name");
            }
            streamTokenizer.sval = null;
            if (n2 == 120 && streamTokenizer.nextToken() != 40) {
                throw new ParseException(streamTokenizer, "'('");
            }
            if (streamTokenizer.nextToken() != -1) {
                throw new ParseException(streamTokenizer, "property name");
            }
            String string2 = streamTokenizer.sval;
            if (!pattern.matcher(string2).matches()) {
                throw new ParseException(streamTokenizer, "valid property name");
            }
            streamTokenizer.sval = null;
            if (n2 == 120) {
                if (streamTokenizer.nextToken() != 41) {
                    throw new ParseException(streamTokenizer, "')'");
                }
                Object object = map.remove(string2);
                continue;
            }
            if (streamTokenizer.nextToken() != 61) {
                throw new ParseException(streamTokenizer, "'='");
            }
            Object object = TypedProperties.parseValue(streamTokenizer, n2);
            Object object2 = map.remove(string2);
            if (object2 != null && (clazz2 = object.getClass()) != (clazz = object2.getClass())) {
                throw new ParseException(streamTokenizer, "(property previously declared as a different type)");
            }
            Object object3 = map.put(string2, object);
        } while (streamTokenizer.nextToken() == 59);
        throw new ParseException(streamTokenizer, "';'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object parseValue(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2 = streamTokenizer.nextToken();
        if (n == 90) {
            if (n2 != -1) {
                throw new ParseException(streamTokenizer, "boolean constant");
            }
            String string2 = streamTokenizer.sval;
            if ("true".equals(string2)) {
                return Boolean.TRUE;
            }
            String string3 = streamTokenizer.sval;
            if (!"false".equals(string3)) throw new ParseException(streamTokenizer, "boolean constant");
            return Boolean.FALSE;
        }
        if ((n & 0xFF) == 73) {
            int n3;
            long l2;
            if (n2 != -1) {
                throw new ParseException(streamTokenizer, "integer constant");
            }
            try {
                long l;
                l2 = l = Long.decode(streamTokenizer.sval).longValue();
                n3 = n >> 8 & 0xFF;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(streamTokenizer, "integer constant");
            }
            switch (n3) {
                default: {
                    String string4 = "Internal error; unexpected integer type width " + n3;
                    throw new IllegalStateException(string4);
                }
                case 1: {
                    if (l2 < 65408L) throw new ParseException(streamTokenizer, "8-bit integer constant");
                    if (l2 > 127L) {
                        throw new ParseException(streamTokenizer, "8-bit integer constant");
                    }
                    byte by = (byte)l2;
                    return new Byte(by);
                }
                case 2: {
                    if (l2 < 32768L) throw new ParseException(streamTokenizer, "16-bit integer constant");
                    if (l2 > 32767L) {
                        throw new ParseException(streamTokenizer, "16-bit integer constant");
                    }
                    short s = (short)l2;
                    return new Short(s);
                }
                case 4: {
                    if (l2 < Integer.MIN_VALUE) throw new ParseException(streamTokenizer, "32-bit integer constant");
                    if (l2 > Integer.MAX_VALUE) {
                        throw new ParseException(streamTokenizer, "32-bit integer constant");
                    }
                    int n4 = (int)l2;
                    return new Integer(n4);
                }
                case 8: 
            }
            if (l2 < Long.MIN_VALUE) throw new ParseException(streamTokenizer, "64-bit integer constant");
            if (l2 <= Long.MAX_VALUE) return new Long(l2);
            throw new ParseException(streamTokenizer, "64-bit integer constant");
        }
        if ((n & 0xFF) == 70) {
            double d;
            if (n2 != -1) {
                throw new ParseException(streamTokenizer, "float constant");
            }
            try {
                double d2;
                d = d2 = Double.parseDouble(streamTokenizer.sval);
                if ((n >> 8 & 0xFF) != 4) return new Double(d);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(streamTokenizer, "float constant");
            }
            double d3 = Math.abs(d);
            if (d3 != 0.0 && !Double.isInfinite(d) && !Double.isNaN(d)) {
                if (d3 < (double)1.4E-45f) throw new ParseException(streamTokenizer, "32-bit float constant");
                if (d3 > 3.4028234663852886E38) {
                    throw new ParseException(streamTokenizer, "32-bit float constant");
                }
            }
            float f = (float)d;
            return new Float(f);
        }
        if (n != 29516) {
            String string6 = "Internal error; unknown type " + n;
            throw new IllegalStateException(string6);
        }
        if (n2 == 34) {
            return streamTokenizer.sval;
        }
        if (n2 != -1) throw new ParseException(streamTokenizer, "double-quoted string or 'null'");
        String string5 = streamTokenizer.sval;
        if (!"null".equals(string5)) throw new ParseException(streamTokenizer, "double-quoted string or 'null'");
        return NULL_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object get(Object object) {
        String string2;
        Object v = super.get(object);
        if (v != (string2 = NULL_STRING)) return v;
        return null;
    }

    public boolean getBoolean(String string2) {
        return this.getBoolean(string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(String string2, boolean bl) {
        Object v = super.get(string2);
        if (v == null) {
            return bl;
        }
        if (!(v instanceof Boolean)) throw new TypeException(string2, v, "boolean");
        return (Boolean)v;
    }

    public byte getByte(String string2) {
        return this.getByte(string2, (byte)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte getByte(String string2, byte by) {
        Object v = super.get(string2);
        if (v == null) {
            return by;
        }
        if (!(v instanceof Byte)) throw new TypeException(string2, v, "byte");
        return (Byte)v;
    }

    public double getDouble(String string2) {
        return this.getDouble(string2, 0.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(String string2, double d) {
        Object v = super.get(string2);
        if (v == null) {
            return d;
        }
        if (!(v instanceof Double)) throw new TypeException(string2, v, "double");
        return (Double)v;
    }

    public float getFloat(String string2) {
        return this.getFloat(string2, 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(String string2, float f) {
        Object v = super.get(string2);
        if (v == null) {
            return f;
        }
        if (!(v instanceof Float)) throw new TypeException(string2, v, "float");
        return ((Float)v).floatValue();
    }

    public int getInt(String string2) {
        return this.getInt(string2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(String string2, int n) {
        Object v = super.get(string2);
        if (v == null) {
            return n;
        }
        if (!(v instanceof Integer)) throw new TypeException(string2, v, "int");
        return (Integer)v;
    }

    public long getLong(String string2) {
        return this.getLong(string2, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(String string2, long l) {
        Object v = super.get(string2);
        if (v == null) {
            return l;
        }
        if (!(v instanceof Long)) throw new TypeException(string2, v, "long");
        return (Long)v;
    }

    public short getShort(String string2) {
        return this.getShort(string2, (short)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(String string2, short s) {
        Object v = super.get(string2);
        if (v == null) {
            return s;
        }
        if (!(v instanceof Short)) throw new TypeException(string2, v, "short");
        return (Short)v;
    }

    public String getString(String string2) {
        return this.getString(string2, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(String string2, String string3) {
        Object v = super.get(string2);
        if (v == null) {
            return string3;
        }
        String string4 = NULL_STRING;
        if (v == string4) {
            return null;
        }
        if (!(v instanceof String)) throw new TypeException(string2, v, "string");
        return (String)v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStringInfo(String string2) {
        Object v = super.get(string2);
        if (v == null) {
            return -1;
        }
        String string3 = NULL_STRING;
        if (v == string3) {
            return 0;
        }
        if (!(v instanceof String)) return -1;
        return 1;
    }

    public void load(Reader reader) throws IOException {
        TypedProperties.parse(reader, this);
    }

    public static class TypeException
    extends IllegalArgumentException {
        TypeException(String string2, Object object, String string3) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append(" has type ");
            String string4 = object.getClass().getName();
            String string5 = stringBuilder.append(string4).append(", not ").append(string3).toString();
            super(string5);
        }
    }

    public static class ParseException
    extends IllegalArgumentException {
        ParseException(StreamTokenizer streamTokenizer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append("expected ").append(string2).append(", saw ");
            String string3 = streamTokenizer.toString();
            String string4 = stringBuilder.append(string3).toString();
            super(string4);
        }
    }
}

