/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseSurfaceHolder
implements SurfaceHolder {
    static final boolean DEBUG = false;
    private static final String TAG = "BaseSurfaceHolder";
    public final ArrayList<SurfaceHolder.Callback> mCallbacks;
    SurfaceHolder.Callback[] mGottenCallbacks;
    boolean mHaveGottenCallbacks;
    long mLastLockTime;
    protected int mRequestedFormat;
    int mRequestedHeight;
    int mRequestedType;
    int mRequestedWidth;
    public Surface mSurface;
    final Rect mSurfaceFrame;
    public final ReentrantLock mSurfaceLock;
    int mType;

    public BaseSurfaceHolder() {
        Rect rect;
        Surface surface;
        ReentrantLock reentrantLock;
        ArrayList arrayList = new ArrayList();
        this.mCallbacks = arrayList;
        this.mSurfaceLock = reentrantLock = new ReentrantLock();
        this.mSurface = surface = new Surface();
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = -1;
        this.mRequestedType = -1;
        this.mLastLockTime = 0L;
        this.mType = -1;
        this.mSurfaceFrame = rect = new Rect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Canvas internalLockCanvas(Rect rect) {
        if (this.mType == 3) {
            throw new SurfaceHolder.BadSurfaceTypeException("Surface type is SURFACE_TYPE_PUSH_BUFFERS");
        }
        this.mSurfaceLock.lock();
        Canvas canvas = null;
        if (this.onAllowLockCanvas()) {
            Rect rect2 = rect != null ? rect : this.mSurfaceFrame;
            try {
                Canvas canvas2;
                canvas = canvas2 = this.mSurface.lockCanvas(rect2);
            }
            catch (Exception exception) {
                int n = Log.e(TAG, "Exception locking surface", exception);
            }
        }
        if (canvas != null) {
            long l;
            this.mLastLockTime = l = SystemClock.uptimeMillis();
            return canvas;
        }
        long l = this.mLastLockTime + 100L;
        long l2 = SystemClock.uptimeMillis();
        if (l > l2) {
            long l3 = l - l2;
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {}
            l2 = SystemClock.uptimeMillis();
        }
        this.mLastLockTime = l2;
        this.mSurfaceLock.unlock();
        return null;
    }

    @Override
    public void addCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            if (!this.mCallbacks.contains(callback)) {
                boolean bl = this.mCallbacks.add(callback);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SurfaceHolder.Callback[] getCallbacks() {
        if (this.mHaveGottenCallbacks) {
            return this.mGottenCallbacks;
        }
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            int n = this.mCallbacks.size();
            if (n > 0) {
                if (this.mGottenCallbacks == null || this.mGottenCallbacks.length != n) {
                    SurfaceHolder.Callback[] callbackArray = new SurfaceHolder.Callback[n];
                    this.mGottenCallbacks = callbackArray;
                }
                ArrayList<SurfaceHolder.Callback> arrayList2 = this.mCallbacks;
                SurfaceHolder.Callback[] callbackArray = this.mGottenCallbacks;
                SurfaceHolder.Callback[] callbackArray2 = arrayList2.toArray(callbackArray);
            } else {
                Object var8_8 = null;
                this.mGottenCallbacks = var8_8;
            }
            this.mHaveGottenCallbacks = true;
            return this.mGottenCallbacks;
        }
    }

    public int getRequestedFormat() {
        return this.mRequestedFormat;
    }

    public int getRequestedHeight() {
        return this.mRequestedHeight;
    }

    public int getRequestedType() {
        return this.mRequestedType;
    }

    public int getRequestedWidth() {
        return this.mRequestedWidth;
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public Rect getSurfaceFrame() {
        return this.mSurfaceFrame;
    }

    @Override
    public Canvas lockCanvas() {
        return this.internalLockCanvas(null);
    }

    @Override
    public Canvas lockCanvas(Rect rect) {
        return this.internalLockCanvas(rect);
    }

    public abstract boolean onAllowLockCanvas();

    public abstract void onRelayoutContainer();

    public abstract void onUpdateSurface();

    @Override
    public void removeCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            boolean bl = this.mCallbacks.remove(callback);
            return;
        }
    }

    @Override
    public void setFixedSize(int n, int n2) {
        if (this.mRequestedWidth != n && this.mRequestedHeight != n2) {
            return;
        }
        this.mRequestedWidth = n;
        this.mRequestedHeight = n2;
        this.onRelayoutContainer();
    }

    @Override
    public void setFormat(int n) {
        if (this.mRequestedFormat != n) {
            return;
        }
        this.mRequestedFormat = n;
        this.onUpdateSurface();
    }

    @Override
    public void setSizeFromLayout() {
        if (this.mRequestedWidth == -1 && this.mRequestedHeight == -1) {
            return;
        }
        this.mRequestedHeight = -1;
        this.mRequestedWidth = -1;
        this.onRelayoutContainer();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setType(int n) {
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                n = 0;
            }
        }
        switch (n) {
            default: {
                return;
            }
            case 0: 
            case 3: 
        }
        if (this.mRequestedType != n) {
            return;
        }
        this.mRequestedType = n;
        this.onUpdateSurface();
    }

    public void ungetCallbacks() {
        this.mHaveGottenCallbacks = false;
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        this.mSurface.unlockCanvasAndPost(canvas);
        this.mSurfaceLock.unlock();
    }
}

