/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;
import java.lang.ref.WeakReference;

public class IInputConnectionWrapper
extends IInputContext.Stub {
    private static final int DO_BEGIN_BATCH_EDIT = 90;
    private static final int DO_CLEAR_META_KEY_STATES = 130;
    private static final int DO_COMMIT_COMPLETION = 55;
    private static final int DO_COMMIT_TEXT = 50;
    private static final int DO_DELETE_SURROUNDING_TEXT = 80;
    private static final int DO_END_BATCH_EDIT = 95;
    private static final int DO_FINISH_COMPOSING_TEXT = 65;
    private static final int DO_GET_CURSOR_CAPS_MODE = 30;
    private static final int DO_GET_EXTRACTED_TEXT = 40;
    private static final int DO_GET_SELECTED_TEXT = 25;
    private static final int DO_GET_TEXT_AFTER_CURSOR = 10;
    private static final int DO_GET_TEXT_BEFORE_CURSOR = 20;
    private static final int DO_PERFORM_CONTEXT_MENU_ACTION = 59;
    private static final int DO_PERFORM_EDITOR_ACTION = 58;
    private static final int DO_PERFORM_PRIVATE_COMMAND = 120;
    private static final int DO_REPORT_FULLSCREEN_MODE = 100;
    private static final int DO_SEND_KEY_EVENT = 70;
    private static final int DO_SET_COMPOSING_REGION = 63;
    private static final int DO_SET_COMPOSING_TEXT = 60;
    private static final int DO_SET_SELECTION = 57;
    static final String TAG = "IInputConnectionWrapper";
    private Handler mH;
    private WeakReference<InputConnection> mInputConnection;
    private Looper mMainLooper;

    public IInputConnectionWrapper(Looper looper, InputConnection inputConnection) {
        WeakReference<InputConnection> weakReference = new WeakReference<InputConnection>(inputConnection);
        this.mInputConnection = weakReference;
        Looper looper2 = this.mMainLooper = looper;
        MyHandler myHandler = new MyHandler(looper2);
        this.mH = myHandler;
    }

    @Override
    public void beginBatchEdit() {
        Message message = this.obtainMessage(90);
        this.dispatchMessage(message);
    }

    @Override
    public void clearMetaKeyStates(int n) {
        Message message = this.obtainMessageII(130, n, 0);
        this.dispatchMessage(message);
    }

    @Override
    public void commitCompletion(CompletionInfo completionInfo) {
        Message message = this.obtainMessageO(55, completionInfo);
        this.dispatchMessage(message);
    }

    @Override
    public void commitText(CharSequence charSequence, int n) {
        Message message = this.obtainMessageIO(50, n, charSequence);
        this.dispatchMessage(message);
    }

    @Override
    public void deleteSurroundingText(int n, int n2) {
        Message message = this.obtainMessageII(80, n, n2);
        this.dispatchMessage(message);
    }

    void dispatchMessage(Message message) {
        Looper looper;
        Looper looper2 = Looper.myLooper();
        if (looper2 == (looper = this.mMainLooper)) {
            this.executeMessage(message);
            message.recycle();
            return;
        }
        boolean bl = this.mH.sendMessage(message);
    }

    @Override
    public void endBatchEdit() {
        Message message = this.obtainMessage(95);
        this.dispatchMessage(message);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void executeMessage(Message message) {
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unhandled message code: ");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.w(TAG, string2);
                return;
            }
            case 10: {
                InputConnection inputConnection;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection = (InputConnection)this.mInputConnection.get();
                    if (inputConnection == null || !this.isActive()) {
                        int n = Log.w(TAG, "getTextAfterCursor on inactive InputConnection");
                        IInputContextCallback iInputContextCallback = someArgs.callback;
                        int n3 = someArgs.seq;
                        iInputContextCallback.setTextAfterCursor(null, n3);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    int n = Log.w(TAG, "Got RemoteException calling setTextAfterCursor", remoteException);
                    return;
                }
                {
                    IInputContextCallback iInputContextCallback = someArgs.callback;
                    int n = message.arg1;
                    int n4 = message.arg2;
                    CharSequence charSequence = inputConnection.getTextAfterCursor(n, n4);
                    int n5 = someArgs.seq;
                    iInputContextCallback.setTextAfterCursor(charSequence, n5);
                    return;
                }
            }
            case 20: {
                InputConnection inputConnection;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection = (InputConnection)this.mInputConnection.get();
                    if (inputConnection == null || !this.isActive()) {
                        int n = Log.w(TAG, "getTextBeforeCursor on inactive InputConnection");
                        IInputContextCallback iInputContextCallback = someArgs.callback;
                        int n6 = someArgs.seq;
                        iInputContextCallback.setTextBeforeCursor(null, n6);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    int n = Log.w(TAG, "Got RemoteException calling setTextBeforeCursor", remoteException);
                    return;
                }
                {
                    IInputContextCallback iInputContextCallback = someArgs.callback;
                    int n = message.arg1;
                    int n7 = message.arg2;
                    CharSequence charSequence = inputConnection.getTextBeforeCursor(n, n7);
                    int n8 = someArgs.seq;
                    iInputContextCallback.setTextBeforeCursor(charSequence, n8);
                    return;
                }
            }
            case 25: {
                InputConnection inputConnection;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection = (InputConnection)this.mInputConnection.get();
                    if (inputConnection == null || !this.isActive()) {
                        int n = Log.w(TAG, "getSelectedText on inactive InputConnection");
                        IInputContextCallback iInputContextCallback = someArgs.callback;
                        int n9 = someArgs.seq;
                        iInputContextCallback.setSelectedText(null, n9);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    int n = Log.w(TAG, "Got RemoteException calling setSelectedText", remoteException);
                    return;
                }
                {
                    IInputContextCallback iInputContextCallback = someArgs.callback;
                    int n = message.arg1;
                    CharSequence charSequence = inputConnection.getSelectedText(n);
                    int n10 = someArgs.seq;
                    iInputContextCallback.setSelectedText(charSequence, n10);
                    return;
                }
            }
            case 30: {
                InputConnection inputConnection;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection = (InputConnection)this.mInputConnection.get();
                    if (inputConnection == null || !this.isActive()) {
                        int n = Log.w(TAG, "getCursorCapsMode on inactive InputConnection");
                        IInputContextCallback iInputContextCallback = someArgs.callback;
                        int n11 = someArgs.seq;
                        iInputContextCallback.setCursorCapsMode(0, n11);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    int n = Log.w(TAG, "Got RemoteException calling setCursorCapsMode", remoteException);
                    return;
                }
                {
                    IInputContextCallback iInputContextCallback = someArgs.callback;
                    int n = message.arg1;
                    int n12 = inputConnection.getCursorCapsMode(n);
                    int n13 = someArgs.seq;
                    iInputContextCallback.setCursorCapsMode(n12, n13);
                    return;
                }
            }
            case 40: {
                InputConnection inputConnection;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection = (InputConnection)this.mInputConnection.get();
                    if (inputConnection == null || !this.isActive()) {
                        int n = Log.w(TAG, "getExtractedText on inactive InputConnection");
                        IInputContextCallback iInputContextCallback = someArgs.callback;
                        int n14 = someArgs.seq;
                        iInputContextCallback.setExtractedText(null, n14);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    int n = Log.w(TAG, "Got RemoteException calling setExtractedText", remoteException);
                    return;
                }
                {
                    IInputContextCallback iInputContextCallback = someArgs.callback;
                    ExtractedTextRequest extractedTextRequest = (ExtractedTextRequest)someArgs.arg1;
                    int n = message.arg1;
                    ExtractedText extractedText = inputConnection.getExtractedText(extractedTextRequest, n);
                    int n15 = someArgs.seq;
                    iInputContextCallback.setExtractedText(extractedText, n15);
                    return;
                }
            }
            case 50: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    CharSequence charSequence = (CharSequence)message.obj;
                    int n = message.arg1;
                    boolean bl = inputConnection.commitText(charSequence, n);
                    return;
                }
                int n = Log.w(TAG, "commitText on inactive InputConnection");
                return;
            }
            case 57: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    int n = message.arg1;
                    int n16 = message.arg2;
                    boolean bl = inputConnection.setSelection(n, n16);
                    return;
                }
                int n = Log.w(TAG, "setSelection on inactive InputConnection");
                return;
            }
            case 58: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    int n = message.arg1;
                    boolean bl = inputConnection.performEditorAction(n);
                    return;
                }
                int n = Log.w(TAG, "performEditorAction on inactive InputConnection");
                return;
            }
            case 59: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    int n = message.arg1;
                    boolean bl = inputConnection.performContextMenuAction(n);
                    return;
                }
                int n = Log.w(TAG, "performContextMenuAction on inactive InputConnection");
                return;
            }
            case 55: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    CompletionInfo completionInfo = (CompletionInfo)message.obj;
                    boolean bl = inputConnection.commitCompletion(completionInfo);
                    return;
                }
                int n = Log.w(TAG, "commitCompletion on inactive InputConnection");
                return;
            }
            case 60: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    CharSequence charSequence = (CharSequence)message.obj;
                    int n = message.arg1;
                    boolean bl = inputConnection.setComposingText(charSequence, n);
                    return;
                }
                int n = Log.w(TAG, "setComposingText on inactive InputConnection");
                return;
            }
            case 63: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    int n = message.arg1;
                    int n17 = message.arg2;
                    boolean bl = inputConnection.setComposingRegion(n, n17);
                    return;
                }
                int n = Log.w(TAG, "setComposingRegion on inactive InputConnection");
                return;
            }
            case 65: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection == null) {
                    int n = Log.w(TAG, "finishComposingText on inactive InputConnection");
                    return;
                }
                boolean bl = inputConnection.finishComposingText();
                return;
            }
            case 70: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    KeyEvent keyEvent = (KeyEvent)message.obj;
                    boolean bl = inputConnection.sendKeyEvent(keyEvent);
                    return;
                }
                int n = Log.w(TAG, "sendKeyEvent on inactive InputConnection");
                return;
            }
            case 130: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    int n = message.arg1;
                    boolean bl = inputConnection.clearMetaKeyStates(n);
                    return;
                }
                int n = Log.w(TAG, "clearMetaKeyStates on inactive InputConnection");
                return;
            }
            case 80: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    int n = message.arg1;
                    int n18 = message.arg2;
                    boolean bl = inputConnection.deleteSurroundingText(n, n18);
                    return;
                }
                int n = Log.w(TAG, "deleteSurroundingText on inactive InputConnection");
                return;
            }
            case 90: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    boolean bl = inputConnection.beginBatchEdit();
                    return;
                }
                int n = Log.w(TAG, "beginBatchEdit on inactive InputConnection");
                return;
            }
            case 95: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection != null && this.isActive()) {
                    boolean bl = inputConnection.endBatchEdit();
                    return;
                }
                int n = Log.w(TAG, "endBatchEdit on inactive InputConnection");
                return;
            }
            case 100: {
                InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
                if (inputConnection == null || !this.isActive()) {
                    int n = Log.w(TAG, "showStatusIcon on inactive InputConnection");
                    return;
                }
                boolean bl = message.arg1 == 1;
                boolean bl2 = inputConnection.reportFullscreenMode(bl);
                return;
            }
            case 120: 
        }
        InputConnection inputConnection = (InputConnection)this.mInputConnection.get();
        if (inputConnection != null && this.isActive()) {
            SomeArgs someArgs = (SomeArgs)message.obj;
            String string3 = (String)someArgs.arg1;
            Bundle bundle = (Bundle)someArgs.arg2;
            boolean bl = inputConnection.performPrivateCommand(string3, bundle);
            return;
        }
        int n = Log.w(TAG, "performPrivateCommand on inactive InputConnection");
    }

    @Override
    public void finishComposingText() {
        Message message = this.obtainMessage(65);
        this.dispatchMessage(message);
    }

    @Override
    public void getCursorCapsMode(int n, int n2, IInputContextCallback iInputContextCallback) {
        Message message = this.obtainMessageISC(30, n, n2, iInputContextCallback);
        this.dispatchMessage(message);
    }

    @Override
    public void getExtractedText(ExtractedTextRequest extractedTextRequest, int n, int n2, IInputContextCallback iInputContextCallback) {
        IInputConnectionWrapper iInputConnectionWrapper = this;
        int n3 = n;
        ExtractedTextRequest extractedTextRequest2 = extractedTextRequest;
        int n4 = n2;
        IInputContextCallback iInputContextCallback2 = iInputContextCallback;
        Message message = iInputConnectionWrapper.obtainMessageIOSC(40, n3, extractedTextRequest2, n4, iInputContextCallback2);
        this.dispatchMessage(message);
    }

    @Override
    public void getSelectedText(int n, int n2, IInputContextCallback iInputContextCallback) {
        Message message = this.obtainMessageISC(25, n, n2, iInputContextCallback);
        this.dispatchMessage(message);
    }

    @Override
    public void getTextAfterCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        IInputConnectionWrapper iInputConnectionWrapper = this;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        IInputContextCallback iInputContextCallback2 = iInputContextCallback;
        Message message = iInputConnectionWrapper.obtainMessageIISC(10, n4, n5, n6, iInputContextCallback2);
        this.dispatchMessage(message);
    }

    @Override
    public void getTextBeforeCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        IInputConnectionWrapper iInputConnectionWrapper = this;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        IInputContextCallback iInputContextCallback2 = iInputContextCallback;
        Message message = iInputConnectionWrapper.obtainMessageIISC(20, n4, n5, n6, iInputContextCallback2);
        this.dispatchMessage(message);
    }

    public boolean isActive() {
        return true;
    }

    Message obtainMessage(int n) {
        return this.mH.obtainMessage(n);
    }

    Message obtainMessageII(int n, int n2, int n3) {
        return this.mH.obtainMessage(n, n2, n3);
    }

    Message obtainMessageIISC(int n, int n2, int n3, int n4, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n4;
        return this.mH.obtainMessage(n, n2, n3, someArgs);
    }

    Message obtainMessageIO(int n, int n2, Object object) {
        return this.mH.obtainMessage(n, n2, 0, object);
    }

    Message obtainMessageIOSC(int n, int n2, Object object, int n3, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.arg1 = object;
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n3;
        return this.mH.obtainMessage(n, n2, 0, someArgs);
    }

    Message obtainMessageISC(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n3;
        return this.mH.obtainMessage(n, n2, 0, someArgs);
    }

    Message obtainMessageO(int n, Object object) {
        return this.mH.obtainMessage(n, 0, 0, object);
    }

    Message obtainMessageOO(int n, Object object, Object object2) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    @Override
    public void performContextMenuAction(int n) {
        Message message = this.obtainMessageII(59, n, 0);
        this.dispatchMessage(message);
    }

    @Override
    public void performEditorAction(int n) {
        Message message = this.obtainMessageII(58, n, 0);
        this.dispatchMessage(message);
    }

    @Override
    public void performPrivateCommand(String string2, Bundle bundle) {
        Message message = this.obtainMessageOO(120, string2, bundle);
        this.dispatchMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reportFullscreenMode(boolean bl) {
        int n = bl ? 1 : 0;
        Message message = this.obtainMessageII(100, n, 0);
        this.dispatchMessage(message);
    }

    @Override
    public void sendKeyEvent(KeyEvent keyEvent) {
        Message message = this.obtainMessageO(70, keyEvent);
        this.dispatchMessage(message);
    }

    @Override
    public void setComposingRegion(int n, int n2) {
        Message message = this.obtainMessageII(63, n, n2);
        this.dispatchMessage(message);
    }

    @Override
    public void setComposingText(CharSequence charSequence, int n) {
        Message message = this.obtainMessageIO(60, n, charSequence);
        this.dispatchMessage(message);
    }

    @Override
    public void setSelection(int n, int n2) {
        Message message = this.obtainMessageII(57, n, n2);
        this.dispatchMessage(message);
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            IInputConnectionWrapper.this.executeMessage(message);
        }
    }

    static class SomeArgs {
        Object arg1;
        Object arg2;
        IInputContextCallback callback;
        int seq;

        SomeArgs() {
        }
    }
}

